/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define PR_CPP
#include "../common.h"
//  PrintF

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	WCHAR names[10][50+1];
	INT32 idxNames;
	INT32 cntNames;
	INT16 orientation;
	INT16 paperSize;
	INT16 paperLength;
	INT16 paperWidth;
	INT16 scale;
	INT16 color;
	INT16 printQuality;
	INT16 yResolution;
	WCHAR formName[50+1];
	INT32 *arPaperSize;
	INT32 *arPaperWidth;
	INT32 *arPaperLength;
	WCHAR **arPaperStr;
	INT32 cntArray;
	BOOL flgClick [5];
	BOOL flgAnchor[5];
	INT32 tabStopIdx;
	HWND tabStops[TBSP_PRINT];
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;} cn;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			st_Image mono;} pc;
	
	HWND hWnd;
	HWND hPd[5];
	HWND hCmb[2];
//	HWND hCmbEdit;
	HWND hChk[2];
	HWND hEdit;
	HWND hBtn;
	HWND hAc[5];
	HWND hCn;
	HWND hPc;
	
	LRESULT (CALLBACK *pCallCmb[2])  (HWND,UINT,WPARAM,LPARAM);
//	LRESULT (CALLBACK *pCallCmbEdit) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallChk[2])  (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallEdit)    (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn)     (HWND,UINT,WPARAM,LPARAM);
} pr[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void PrInitClass(void);
void PrInit(LONG);
void PrInst(LONG);
void PrDialog(LONG);
void PrMsgBx(LONG, LCHAR *);
LRESULT CALLBACK PrWndProc       (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PrWndProcPd     (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PrWndProcCmbN   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PrWndProcCmbP   (HWND, UINT, WPARAM, LPARAM);
//LRESULT CALLBACK PrWndProcCmbD   (HWND, UINT, WPARAM, LPARAM);
//LRESULT CALLBACK PrWndProcCmbEdit(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PrWndProcChkH   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PrWndProcChkM   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PrWndProcEdit   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PrWndProcBtn    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PrWndProcAc     (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PrWndProcPc     (HWND, UINT, WPARAM, LPARAM);
void PrSize         (LONG, WPARAM, LPARAM);
void PrGetMinMaxInfo(LONG, WPARAM, LPARAM);
void PrSize5        (LONG, WPARAM, LPARAM);
void PrSetFocus     (LONG, WPARAM, LPARAM);
void PrKeyDown      (LONG, WPARAM, LPARAM, HWND);
void PrKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void PrKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void PrKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void PrKeyDownF5    (LONG, WPARAM, LPARAM, HWND);
void PrKeyDownSp    (LONG, WPARAM, LPARAM, HWND);
void PrKeyDownUpDw  (LONG, WPARAM, LPARAM, HWND);
void PrClose        (LONG, WPARAM, LPARAM);
void PrDestroy      (LONG, WPARAM, LPARAM);
void PrPdCommand    (LONG, WPARAM, LPARAM);
void PrPdPaint2     (LONG, WPARAM, LPARAM);
void PrPdPaint3     (LONG, WPARAM, LPARAM);
void PrPdPaint4     (LONG, WPARAM, LPARAM);
void PrCmCommand    (LONG, LONG, WPARAM, LPARAM);
void PrChSetCheck   (LONG, LONG, WPARAM, LPARAM);
void PrEdSetFocus   (LONG, WPARAM, LPARAM, HWND);
void PrEdKillFocus  (LONG, WPARAM, LPARAM, HWND);
BOOL PrEdChar       (LONG, WPARAM, LPARAM, HWND);
void PrAcPaint      (LONG, LONG, WPARAM, LPARAM);
void PrAcSetFocus   (LONG, LONG, WPARAM, LPARAM, HWND);
void PrAcKillFocus  (LONG, LONG, WPARAM, LPARAM, HWND);
void PrAcLButtonDown(LONG, LONG, WPARAM, LPARAM);
void PrAcLButtonUp  (LONG, LONG, WPARAM, LPARAM);
void PrPcPaint      (LONG, WPARAM, LPARAM);
BOOL  PrEnterOk(LONG);
void  PrUpdate(LONG);
void  PrPosAnchor(LONG,INT32 *,INT32 *,INT32 *,INT32 *,INT32,INT32,INT32,INT32,INT32,INT32);
void  PrMonoCreate(LONG);
void  PrMonoDelete(LONG);
void  PrLoad(LONG, INT32);
void  PrPaperLoad(LONG, WCHAR *);
void  PrPaperList(LONG);
void  PrPaperDelete(LONG);
INT32 PrIdxPaperSize(LONG);
void  PrDump(LONG, WCHAR *);
void  PrImageView(LONG);
void  PrSetPane(LONG);

/*------------------------------------------------------------------------------
    Fvoid PrInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void PrInitClass(void)
{
	WNDCLASS wcPrint;
	WNDCLASS wcPrintPd;
	WNDCLASS wcPrintAc;
	WNDCLASS wcPrintCn;
	WNDCLASS wcPrintPc;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_PRINT,  &wcPrint);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_PRINTPD,&wcPrintPd);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurHand, hBrNull,  NM_PRINTAC,&wcPrintAc);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_PRINTCN,&wcPrintCn);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrNull,  NM_PRINTPC,&wcPrintPc);
	
	RegisterClass(&wcPrint);
	RegisterClass(&wcPrintPd);
	RegisterClass(&wcPrintAc);
	RegisterClass(&wcPrintCn);
	RegisterClass(&wcPrintPc);
}

/*------------------------------------------------------------------------------
    Fvoid PrInit(LONG)
    FLONG    FORM ID
    @\F
------------------------------------------------------------------------------*/
void PrInit(LONG id)
{
	INT32 i;
	
	for (i = 0; i < 10; i++) {
		wmemset(pr[id].names[i], 0x0000, 50+1);
	}
	wmemset(pr[id].formName, 0x0000, 50+1);
	
	pr[id].idxNames     = 0;
	pr[id].cntNames     = 0;
	pr[id].orientation  = DMORIENT_PORTRAIT;
	pr[id].paperSize    = DMPAPER_A4;
	pr[id].paperLength  = 0;
	pr[id].paperWidth   = 0;
	pr[id].scale        = 0;
	pr[id].color        = DMCOLOR_MONOCHROME;
	pr[id].printQuality = 0;
	pr[id].yResolution  = 0;
	
	pr[id].arPaperSize   = NULL;
	pr[id].arPaperWidth  = NULL;
	pr[id].arPaperLength = NULL;
	pr[id].arPaperStr    = NULL;
	pr[id].cntArray      = 0;
	
	for (i = 0; i < 5; i++) {
		pr[id].flgClick [i] = FALSE;
		pr[id].flgAnchor[i] = FALSE;
	}
	
	pr[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_PRINT; i++) {pr[id].tabStops[i] = NULL;}
	
	pr[id].cn.x = 0;
	pr[id].cn.y = 0;
	pr[id].cn.w = 0;
	pr[id].cn.h = 0;
	
	pr[id].pc.x = 0;
	pr[id].pc.y = 0;
	pr[id].pc.w = 0;
	pr[id].pc.h = 0;
	
	pr[id].hWnd = NULL;
	for (i = 0; i < 5; i++) {pr[id].hPd[i]  = NULL;}
	for (i = 0; i < 2; i++) {pr[id].hCmb[i] = NULL;}
//	pr[id].hCmbEdit = NULL;
	for (i = 0; i < 2; i++) {pr[id].hChk[i] = NULL;}
	pr[id].hEdit = NULL;
	pr[id].hBtn  = NULL;
	for (i = 0; i < 5; i++) {pr[id].hAc[i] = NULL;}
	pr[id].hCn = NULL;
	pr[id].hPc = NULL;
	
	for (i = 0; i < 3; i++) {pr[id].pCallCmb[i] = NULL;}
//	pr[id].pCallCmbEdit = NULL;
	for (i = 0; i < 2; i++) {pr[id].pCallChk[i] = NULL;}
	pr[id].pCallEdit = NULL;
	pr[id].pCallBtn  = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid PrInst(LONG)
    FLONG      FORM ID
    @\FPRINT̉
------------------------------------------------------------------------------*/
void PrInst(LONG id)
{
	INT32 i;
	DWORD stylePr  = WS_OVERLAPPED|WS_CAPTION|WS_MAXIMIZEBOX|WS_THICKFRAME|WS_SYSMENU;
	DWORD stylePd1 = WS_CHILD|WS_VISIBLE;
	DWORD stylePd2 = WS_CHILD|WS_VISIBLE;
	DWORD stylePd3 = WS_CHILD|WS_VISIBLE;
	DWORD stylePd4 = WS_CHILD;
	DWORD stylePd5 = WS_CHILD;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD styleCm1 = WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST;
//	DWORD styleCm2 = WS_CHILD|WS_VISIBLE|CBS_DROPDOWN;
	DWORD styleCk  = WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX;
	DWORD styleEd  = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleAc  = WS_CHILD|WS_VISIBLE;
	DWORD styleCn  = WS_CHILD|WS_CLIPCHILDREN;
	DWORD stylePc  = WS_CHILD;
	INT32 y;
	INT32 w;
	INT32 wPr;
	INT32 hPr;
	INT32 idx;
	WCHAR prScale[4+1];
	
	_itow(pr[id].scale, prScale, 10);
	
	idx = PrIdxPaperSize(id);
	
	y   = SZ_HPRINT1+PADD8*2;
	w   = SZ_WEDIT2 -PADD8*2;
	wPr = SZ_WPRINT1;
	hPr = SZ_HPRINT1;
	pr[id].hWnd    = a_CreateWindow(NM_PRINT,   TxTl(E_TTLPRN),     stylePr, 0,  0,  0,  0,  fm[id].hWnd);
	pr[id].hPd[0]  = a_CreateWindow(NM_PRINTPD, NULL,               stylePd1,8,  8,  wPr,hPr,pr[id].hWnd);
	pr[id].hPd[1]  = a_CreateWindow(NM_PRINTPD, NULL,               stylePd2,8,  y,  w,  194,pr[id].hWnd);
	pr[id].hPd[2]  = a_CreateWindow(NM_PRINTPD, NULL,               stylePd3,0,  0,  0,  0,  pr[id].hWnd);
	pr[id].hPd[3]  = a_CreateWindow(NM_PRINTPD, NULL,               stylePd4,0,  0,  0,  0,  pr[id].hWnd);
	pr[id].hPd[4]  = a_CreateWindow(NM_PRINTPD, NULL,               stylePd5,0,  0,  0,  0,  pr[id].hWnd);
	pr[id].hCmb[0] = a_CreateWindow(L"Combobox",NULL,               styleCm1,5,  5,  220,300,pr[id].hPd[0]);
	pr[id].hCmb[1] = a_CreateWindow(L"Combobox",NULL,               styleCm1,64, 10, 75, 300,pr[id].hPd[1]);
//	pr[id].hCmb[2] = a_CreateWindow(L"Combobox",NULL,               styleCm2,44, 162,70, 300,pr[id].hPd[1]);
	pr[id].hBtn    = a_CreateWindow(L"Button",  TxEd(E_PRBTN),      styleBt, 232,3,  70, 25, pr[id].hPd[0]);
	pr[id].hChk[0] = a_CreateWindow(L"Button",  TxEd(E_PRLANDSCAPE),styleCk, 47, 39, 80, 25, pr[id].hPd[1]);
//	pr[id].hChk[1] = a_CreateWindow(L"Button",  L"",            styleCk, 47, 190,70, 25, pr[id].hPd[1]);
	pr[id].hAc[0]  = a_CreateWindow(NM_PRINTAC, NULL,               styleAc, 41, 106,20, 8,  pr[id].hPd[1]);
	pr[id].hAc[1]  = a_CreateWindow(NM_PRINTAC, NULL,               styleAc, 82, 70, 8,  20, pr[id].hPd[1]);
	pr[id].hAc[2]  = a_CreateWindow(NM_PRINTAC, NULL,               styleAc, 111,106,20, 8,  pr[id].hPd[1]);
	pr[id].hAc[3]  = a_CreateWindow(NM_PRINTAC, NULL,               styleAc, 82, 130,8,  20, pr[id].hPd[1]);
	pr[id].hAc[4]  = a_CreateWindow(NM_PRINTAC, NULL,               styleAc, 61, 90, 50, 40, pr[id].hPd[1]);
	pr[id].hEdit   = a_CreateWindow(L"Edit",    prScale,            styleEd, 64, 162,65, 17, pr[id].hPd[1]);
	pr[id].hCn     = a_CreateWindow(NM_PRINTCN, NULL,               styleCn, 0,  0,  0,  0,  pr[id].hPd[4]);
	pr[id].hPc     = a_CreateWindow(NM_PRINTPC, NULL,               stylePc, 0,  0,  0,  0,  pr[id].hCn);
//	pr[id].hCmbEdit = FindWindowEx(pr[id].hCmb[2], NULL, NULL, NULL);
	
	SetWindowLong(pr[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(pr[id].hPd[0],   GWL_USERDATA, 0*100+id);
	SetWindowLong(pr[id].hPd[1],   GWL_USERDATA, 1*100+id);
	SetWindowLong(pr[id].hPd[2],   GWL_USERDATA, 2*100+id);
	SetWindowLong(pr[id].hPd[3],   GWL_USERDATA, 3*100+id);
	SetWindowLong(pr[id].hPd[4],   GWL_USERDATA, 4*100+id);
	SetWindowLong(pr[id].hCmb[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(pr[id].hCmb[1],  GWL_USERDATA, 1*100+id);
//	SetWindowLong(pr[id].hCmb[2],  GWL_USERDATA, 2*100+id);
	SetWindowLong(pr[id].hChk[0],  GWL_USERDATA, 0*100+id);
//	SetWindowLong(pr[id].hChk[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(pr[id].hBtn,     GWL_USERDATA, id);
	SetWindowLong(pr[id].hEdit,    GWL_USERDATA, id);
	SetWindowLong(pr[id].hAc[0],   GWL_USERDATA, 0*100+id);
	SetWindowLong(pr[id].hAc[1],   GWL_USERDATA, 1*100+id);
	SetWindowLong(pr[id].hAc[2],   GWL_USERDATA, 2*100+id);
	SetWindowLong(pr[id].hAc[3],   GWL_USERDATA, 3*100+id);
	SetWindowLong(pr[id].hAc[4],   GWL_USERDATA, 4*100+id);
	SetWindowLong(pr[id].hPc,      GWL_USERDATA, id);
//	SetWindowLong(pr[id].hCmbEdit, GWL_USERDATA, id);
	
	SetWindowLong(pr[id].hWnd,   GWL_WNDPROC, (LONG)PrWndProc);
	SetWindowLong(pr[id].hPd[0], GWL_WNDPROC, (LONG)PrWndProcPd);
	SetWindowLong(pr[id].hPd[1], GWL_WNDPROC, (LONG)PrWndProcPd);
	SetWindowLong(pr[id].hPd[2], GWL_WNDPROC, (LONG)PrWndProcPd);
	SetWindowLong(pr[id].hPd[3], GWL_WNDPROC, (LONG)PrWndProcPd);
	SetWindowLong(pr[id].hPd[4], GWL_WNDPROC, (LONG)PrWndProcPd);
	SetWindowLong(pr[id].hAc[0], GWL_WNDPROC, (LONG)PrWndProcAc);
	SetWindowLong(pr[id].hAc[1], GWL_WNDPROC, (LONG)PrWndProcAc);
	SetWindowLong(pr[id].hAc[2], GWL_WNDPROC, (LONG)PrWndProcAc);
	SetWindowLong(pr[id].hAc[3], GWL_WNDPROC, (LONG)PrWndProcAc);
	SetWindowLong(pr[id].hAc[4], GWL_WNDPROC, (LONG)PrWndProcAc);
	SetWindowLong(pr[id].hPc,    GWL_WNDPROC, (LONG)PrWndProcPc);
	
	for (i = 0; i < pr[id].cntNames; i++) {
		C_ADDSTRING(pr[id].hCmb[0], pr[id].names[i]);
	}
	
//	C_ADDSTRING(pr[id].hCmb[2], L"127");
//	C_ADDSTRING(pr[id].hCmb[2], L"254");
//	C_ADDSTRING(pr[id].hCmb[2], L"381");
//	C_ADDSTRING(pr[id].hCmb[2], L"508");
//	SetWindowText(pr[id].hCmb[2], prDpi);
	
	C_SETCURSEL(pr[id].hCmb[0], pr[id].idxNames);
	
	E_SETLIMITTEXT(pr[id].hEdit,   4);
//	C_LIMITTEXT   (pr[id].hCmb[2], 3);
	
	C_SETFONT(pr[id].hCmb[0], hFtArial14);
	C_SETFONT(pr[id].hCmb[1], hFtArial14);
//	C_SETFONT(pr[id].hCmb[2], hFtArial14);
	B_SETFONT(pr[id].hChk[0], hFtArial14);
//	B_SETFONT(pr[id].hChk[1], hFtArial14);
	E_SETFONT(pr[id].hEdit,   hFtCourier);
	B_SETFONT(pr[id].hBtn,    hFtArial14);
	
	pr[id].pCallCmb[0]  = (CALLFUNC)GetWindowLong(pr[id].hCmb[0],  GWL_WNDPROC);
	pr[id].pCallCmb[1]  = (CALLFUNC)GetWindowLong(pr[id].hCmb[1],  GWL_WNDPROC);
//	pr[id].pCallCmb[2]  = (CALLFUNC)GetWindowLong(pr[id].hCmb[2],  GWL_WNDPROC);
	pr[id].pCallChk[0]  = (CALLFUNC)GetWindowLong(pr[id].hChk[0],  GWL_WNDPROC);
//	pr[id].pCallChk[1]  = (CALLFUNC)GetWindowLong(pr[id].hChk[1],  GWL_WNDPROC);
	pr[id].pCallEdit    = (CALLFUNC)GetWindowLong(pr[id].hEdit,    GWL_WNDPROC);
	pr[id].pCallBtn     = (CALLFUNC)GetWindowLong(pr[id].hBtn,     GWL_WNDPROC);
//	pr[id].pCallCmbEdit = (CALLFUNC)GetWindowLong(pr[id].hCmbEdit, GWL_WNDPROC);
	SetWindowLong(pr[id].hCmb[0],  GWL_WNDPROC, (LONG)PrWndProcCmbN);
	SetWindowLong(pr[id].hCmb[1],  GWL_WNDPROC, (LONG)PrWndProcCmbP);
//	SetWindowLong(pr[id].hCmb[2],  GWL_WNDPROC, (LONG)PrWndProcCmbD);
	SetWindowLong(pr[id].hChk[0],  GWL_WNDPROC, (LONG)PrWndProcChkH);
//	SetWindowLong(pr[id].hChk[1],  GWL_WNDPROC, (LONG)PrWndProcChkM);
	SetWindowLong(pr[id].hEdit,    GWL_WNDPROC, (LONG)PrWndProcEdit);
	SetWindowLong(pr[id].hBtn,     GWL_WNDPROC, (LONG)PrWndProcBtn);
//	SetWindowLong(pr[id].hCmbEdit, GWL_WNDPROC, (LONG)PrWndProcCmbEdit);
	
	pr[id].tabStopIdx = 0;
	pr[id].tabStops[0] = pr[id].hCmb[0];
	pr[id].tabStops[1] = pr[id].hBtn;
	pr[id].tabStops[2] = pr[id].hCmb[1];
	pr[id].tabStops[3] = pr[id].hChk[0];
	pr[id].tabStops[4] = pr[id].hAc[0];
	pr[id].tabStops[5] = pr[id].hAc[1];
	pr[id].tabStops[6] = pr[id].hAc[2];
	pr[id].tabStops[7] = pr[id].hAc[3];
	pr[id].tabStops[8] = pr[id].hAc[4];
	pr[id].tabStops[9] = pr[id].hEdit;
	
	SetFocus  (pr[id].hCmb[0]);
	EditSelAll(pr[id].hCmb[0]);
}

/*------------------------------------------------------------------------------
    Fvoid PrDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void PrDialog(LONG id)
{
	INT32 idx;
	
//	PrMonoCreate(id);
	PrInit(id);
	
	PrLoad(id, 99);
	PrPaperLoad(id, pr[id].names[pr[id].idxNames]);
	
	PrInst(id);
	PrPaperList(id);
	idx = PrIdxPaperSize(id);
	pr[id].paperWidth  = pr[id].arPaperWidth[idx];
	pr[id].paperLength = pr[id].arPaperLength[idx];
	C_SETCURSEL(pr[id].hCmb[1], idx);
	
	PpPlacement(id, pr[id].hWnd);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = pr[id].hWnd;
	
	ShowWindow(pr[id].hPd[3], 0x1);
	ShowWindow(pr[id].hPd[4], 0x1);
	ShowWindow(pr[id].hCn,    0x1);
	ShowWindow(pr[id].hPc,    0x1);
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid PrMsgBx(LONG, LCHAR *)
    FLONG     -
          LCHAR *  -
    @\F|bvAbvbZ[W\
------------------------------------------------------------------------------*/
void PrMsgBx(LONG id, LCHAR *str)
{
	HWND hWnd;
	
	if (pr[id].hWnd != NULL) {hWnd = pr[id].hWnd;}
	else                     {hWnd = fm[id].hWnd;}
	
	MessageBox(hWnd, str, L_TITLE, MB_OK);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PrWndProc(,,,)
    F-
    ߒlF-
    @\FPRINTCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PrWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SIZE:           PrSize         (id, wp, lp);  break;
	case WM_GETMINMAXINFO:  PrGetMinMaxInfo(id, wp, lp);  break;
	case WM_SETFOCUS:       PrSetFocus     (id, wp, lp);  break;
	case WM_CLOSE:          PrClose        (id, wp, lp);  break;
	case WM_DESTROY:        PrDestroy      (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PrWndProcPd(,,,)
    F-
    ߒlF-
    @\FPRINT PDCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PrWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idP;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:
		if (idP == 0) {PrPdCommand(id, wp, lp);}
		break;
	case WM_PAINT:
		switch (idP) {
		case 1:  PrPdPaint2(id, wp, lp);  break;
		case 2:  PrPdPaint3(id, wp, lp);  break;
		case 3:  PrPdPaint4(id, wp, lp);  break;
		default: break;
		}
		break;
	case WM_CTLCOLORSTATIC:
		if ((HWND)lp == pr[id].hChk[0]) {return (LRESULT)hBrWhite;}
//		if ((HWND)lp == pr[id].hChk[1]) {return (LRESULT)hBrWhite;}
		break;
	default:  break;
	}
	
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PrWndProcCmbN(,,,)
    F-
    ߒlF-
    @\FPRINT CMB NAMECxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PrWndProcCmbN(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG idC;
	LONG id;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   PrEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  PrEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		if (!C_GETDROPPEDSTATE(hWnd)) {PrKeyDown(id, wp, lp, hWnd);}
		break;
	default: break;
	}
	
	res = pr[id].pCallCmb[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case WM_COMMAND:  PrCmCommand(id, idC, wp, lp);  break;  // v^Ƃ̒ʐM͊OBԂ鎞B
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PrWndProcCmbP(,,,)
    F-
    ߒlF-
    @\FPRINT CMB PAPERCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PrWndProcCmbP(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:    PrCmCommand  (id, idC, wp, lp);   break;
	case WM_SETFOCUS:   PrEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  PrEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		if (!C_GETDROPPEDSTATE(hWnd)) {PrKeyDown(id, wp, lp, hWnd);}
		break;
	default: break;
	}
	
	return pr[id].pCallCmb[idC](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PrWndProcCmbD(,,,)
    F-
    ߒlF-
    @\FPRINT CMB DPICxg
------------------------------------------------------------------------------*/
//LRESULT CALLBACK PrWndProcCmbD(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
//{
//	LRESULT res;
//	LONG tmp;
//	LONG id;
//	LONG idC;
//	
//	tmp = GetWindowLong(hWnd, GWL_USERDATA);
//	id  = tmp % 100;
//	idC = tmp / 100;
//	
//	switch (msg) {
//	default: break;
//	}
//	
//	res = pr[id].pCallCmb[idC](hWnd, msg, wp, lp);
//	
//	switch (msg) {
//	case WM_COMMAND:  PrCmCommand(id, idC, wp, lp);  break;
//	default: break;
//	}
//	return res;
//}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PrWndProcCmbEdit(,,,)
    F-
    ߒlF-
    @\FPRINT CMB EDITCxg
------------------------------------------------------------------------------*/
//LRESULT CALLBACK PrWndProcCmbEdit(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
//{
//	LONG id;
//	
//	id = GetWindowLong(hWnd, GWL_USERDATA);
//	
//	switch (msg) {
//	case WM_SETFOCUS:   PrEdSetFocus (id, wp, lp, hWnd);  break;
//	case WM_KILLFOCUS:  PrEdKillFocus(id, wp, lp, hWnd);  break;
//	case WM_KEYDOWN:    PrKeyDown    (id, wp, lp, hWnd);  break;  // alt+
//	case WM_CHAR:
//		if (PrEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
//		break;
//	default: break;
//	}
//	
//	return pr[id].pCallCmbEdit(hWnd, msg, wp, lp);
//}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PrWndProcChkH(,,,)
    F-
    ߒlF-
    @\FPRINT CHK HCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PrWndProcChkH(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   PrEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  PrEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    PrKeyDown    (id, wp, lp, hWnd);  break;
	default: break;
	}
	
	res = pr[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  PrChSetCheck(id, idC, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PrWndProcChkM(,,,)
    F-
    ߒlF-
    @\FPRINT CHK MCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PrWndProcChkM(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   PrEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  PrEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    PrKeyDown    (id, wp, lp, hWnd);  break;
	default: break;
	}
	
	res = pr[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  PrChSetCheck(id, idC, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PrWndProcEdit(,,,)
    F-
    ߒlF-
    @\FPRINT EDITCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PrWndProcEdit(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:   PrEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  PrEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		PrKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (PrEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return pr[id].pCallEdit(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PrWndProcBtn(,,,)
    F-
    ߒlF-
    @\FPRINT BTNCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PrWndProcBtn(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:   PrEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  PrEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    PrKeyDown    (id, wp, lp, hWnd);  break;
	default: break;
	}
	return pr[id].pCallBtn(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PrWndProcAc(,,,)
    F-
    ߒlF-
    @\FPRINT ACCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PrWndProcAc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idA;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idA = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:        PrAcPaint      (id, idA, wp, lp);        break;
	case WM_SETFOCUS:     PrAcSetFocus   (id, idA, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    PrAcKillFocus  (id, idA, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  PrAcLButtonDown(id, idA, wp, lp);        break;
	case WM_LBUTTONUP:    PrAcLButtonUp  (id, idA, wp, lp);        break;
	case WM_KEYDOWN:      PrKeyDown      (id, wp, lp, hWnd);       break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PrWndProcPc(,,,)
    F-
    ߒlF-
    @\FPRINT PCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PrWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:  PrPcPaint(id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid PrSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPRINT WM_SIZECxg
------------------------------------------------------------------------------*/
void PrSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	if (fm[id].cntSkipEdit != 0) {fm[id].cntSkipEdit--;  return;}
	
	GetClientRect(pr[id].hWnd, &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	
	a_SetWindowPos(pr[id].hPd[2], SZ_WEDIT2,
								  SZ_HPRINT1+PADD8*2,
								  SZ_WPRINT3,
								  SZ_HPRINT3);
	
	a_SetWindowPos(pr[id].hPd[3], SZ_WEDIT2+SZ_WPRINT3+PADD8,
								  SZ_HPRINT1+PADD8*2,
								  SZ_WPRINT4,
								  SZ_HPRINT4);
	
	a_SetWindowPos(pr[id].hPd[4], SZ_WEDIT2,
								  SZ_HPRINT1+SZ_HPRINT3+PADD8*3,
								  w-SZ_WEDIT2-PADD8,
								  h-SZ_HPRINT1-SZ_HPRINT3-PADD8*4);
	
	PrSetPane(id);
	PrImageView(id);
	
	a_SetWindowPos(pr[id].hPc, pr[id].pc.x, pr[id].pc.y,
									pr[id].pc.w, pr[id].pc.h);
	
	InvalidateRect(pr[id].hWnd,   NULL, TRUE);
	InvalidateRect(pr[id].hPd[2], NULL, TRUE);
	InvalidateRect(pr[id].hPd[3], NULL, TRUE);
	InvalidateRect(pr[id].hPd[4], NULL, TRUE);
	InvalidateRect(pr[id].hCn,    NULL, TRUE);
	InvalidateRect(pr[id].hPc,    NULL, FALSE);
	UpdateWindow(pr[id].hWnd);
	UpdateWindow(pr[id].hPd[2]);
	UpdateWindow(pr[id].hPd[3]);
	UpdateWindow(pr[id].hPd[4]);
	UpdateWindow(pr[id].hCn);
	UpdateWindow(pr[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid PrSize5(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPRINT WM_SIZECxg
------------------------------------------------------------------------------*/
void PrSize5(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(pr[id].hWnd, &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	
	a_SetWindowPos(pr[id].hPd[4], SZ_WEDIT2,
								  SZ_HPRINT1+SZ_HPRINT3+PADD8*3,
								  w-SZ_WEDIT2-PADD8,
								  h-SZ_HPRINT1-SZ_HPRINT3-PADD8*4);
	
	PrSetPane(id);
	PrImageView(id);
	
	a_SetWindowPos(pr[id].hPc, pr[id].pc.x, pr[id].pc.y,
									pr[id].pc.w, pr[id].pc.h);
	
	InvalidateRect(pr[id].hPd[4], NULL, TRUE);
	InvalidateRect(pr[id].hCn,    NULL, TRUE);
	InvalidateRect(pr[id].hPc,    NULL, FALSE);
	UpdateWindow(pr[id].hPd[4]);
	UpdateWindow(pr[id].hCn);
	UpdateWindow(pr[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid PrGetMinMaxInfo(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPRINT WM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void PrGetMinMaxInfo(LONG id, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	INT32 w;
	INT32 h;
	
	w = SZ_WEDIT2+     PADD8*2+GetSystemMetrics(SM_CYSIZEFRAME)*2+SZ_WPRINT3+SZ_WPRINT4;
	h = 194+SZ_HPRINT1+PADD8*3+GetSystemMetrics(SM_CYSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = w;
	mmi->ptMinTrackSize.y = h;
}

/*------------------------------------------------------------------------------
    Fvoid PrSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPRINT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void PrSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(pr[id].tabStops[pr[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid PrKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPRINT WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void PrKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  PrKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    PrKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    PrKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_F5:     PrKeyDownF5   (id, wp, lp, hWnd);  break;
	case KEY_SP:     PrKeyDownSp   (id, wp, lp, hWnd);  break;
	case KEY_UP:
	case KEY_DW:     PrKeyDownUpDw (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid PrKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPRINT [enter]L[Cxg
------------------------------------------------------------------------------*/
void PrKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL res;
	
	SetFocus(pr[id].hBtn);
	PrUpdate(id);
	res = PrEnterOk(id);
//	if (res == TRUE) {CLOSE(pr[id].hWnd);}
}

/*------------------------------------------------------------------------------
    Fvoid PrKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPRINT [esc]L[Cxg
------------------------------------------------------------------------------*/
void PrKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(pr[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PrKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPRINT [tab]L[Cxg
------------------------------------------------------------------------------*/
void PrKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (pr[id].tabStopIdx == 0) {pr[id].tabStopIdx = TBSP_PRINT-1;}
		else                        {pr[id].tabStopIdx--;}
	}
	else {
		pr[id].tabStopIdx = (pr[id].tabStopIdx + 1) % TBSP_PRINT;
	}
	SetFocus(pr[id].tabStops[pr[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid PrKeyDownF5(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPRINT [F5]L[Cxg
------------------------------------------------------------------------------*/
void PrKeyDownF5(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	PrUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid PrKeyDownSp(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPRINT [space]L[Cxg
------------------------------------------------------------------------------*/
void PrKeyDownSp(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	LONG idA;
	
	if      (hWnd == pr[id].hAc[0]) {idA = 0;}
	else if (hWnd == pr[id].hAc[1]) {idA = 1;}
	else if (hWnd == pr[id].hAc[2]) {idA = 2;}
	else if (hWnd == pr[id].hAc[3]) {idA = 3;}
	else if (hWnd == pr[id].hAc[4]) {idA = 4;}
	else                            {return;}
	
	if (pr[id].flgAnchor[idA] == TRUE) {pr[id].flgAnchor[idA] = FALSE;}
	else                               {pr[id].flgAnchor[idA] = TRUE;}
	
	InvalidateRect(pr[id].hAc[idA], NULL, FALSE);
	UpdateWindow  (pr[id].hAc[idA]);
	
	InvalidateRect(pr[id].hPc,    NULL, TRUE);
	InvalidateRect(pr[id].hPd[3], NULL, TRUE);
	UpdateWindow  (pr[id].hPc);
	UpdateWindow  (pr[id].hPd[3]);
}

/*------------------------------------------------------------------------------
    Fvoid PrKeyDownUpDw(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPRINT [][]L[Cxg
------------------------------------------------------------------------------*/
void PrKeyDownUpDw(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT16 tmp;
	UINT16 comb;
	INT32 step;
	WCHAR text[4+1];
	INT32 val;
	INT32 limL;
	INT32 limH;
	
	comb  = 0x000;
	tmp = GetKeyState(KEY_CTRL);   if((tmp & 0x80)!=0){comb |= 0x100;}
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){comb |= 0x010;}
	
	if (hWnd != pr[id].hEdit) {return;}
	
	if      (comb == 0x000) {step = 1;}
	else if (comb == 0x100) {step = 10;}
	else if (comb == 0x010) {step = 100;}
	else if (comb == 0x110) {step = 1000;}
	else                    {return;}
	
	GetWindowText(hWnd, text, 4+1);
	val = _wtoi(text);
	
	limL = 0;
	limH = 9999;
	
	if (wp == KEY_UP) {val += step;}
	else              {val -= step;}
	
	if (val < limL) {val = limL;}
	if (limH < val) {val = limH;}
	
	_itow(val, text, 10);
	SetWindowText(hWnd, text);
	EditSelAll(hWnd);
	
	PrUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid PrClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPRINT WM_CLOSECxg
------------------------------------------------------------------------------*/
void PrClose(LONG id, WPARAM wp, LPARAM lp)
{
	PrPaperDelete(id);
	
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PrDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPRINT WM_DESTROYCxg
------------------------------------------------------------------------------*/
void PrDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	PrMonoDelete(id);
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid PrPdCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPRINT WM_COMMANDCxg
------------------------------------------------------------------------------*/
void PrPdCommand(LONG id, WPARAM wp, LPARAM lp)
{
	BOOL res;
	
	if ((HWND)lp == pr[id].hBtn) {
		if (HIWORD(wp) == BN_CLICKED) {
			PrUpdate(id);
			res = PrEnterOk(id);
//			if (res == TRUE) {CLOSE(pr[id].hWnd);}
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid PrPdPaint2(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPRINT PD WM_PAINTCxg
------------------------------------------------------------------------------*/
void PrPdPaint2(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1;
	INT32 x2, y2;
	
	hdc = BeginPaint(pr[id].hPd[1], &ps);
	GetClientRect(pr[id].hPd[1], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	switch (g_idxLang) {
	case 0:  x1 = 30;  x2 = 30;  break;
	case 1:  x1 = 27;  x2 = 27;   break;
	default: break;
	}
	
	y1 = 13;
	y2 = 163;
	a_TextOut(hdc, x1, y1, TxEd(E_PRPAPER));
	a_TextOut(hdc, x2, y2, TxEd(E_PRSCALE));
	
	SelectClipRgn(hdc, NULL);
	EndPaint(pr[id].hPd[1], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid PrPdPaint3(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPRINT PD WM_PAINTCxg
------------------------------------------------------------------------------*/
void PrPdPaint3(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	WCHAR *pStr;
	WCHAR buff[100];
	INT32 wMm;
	INT32 hMm;
	INT32 dpiX;
	INT32 dpiY;
	double percent;
	INT32 idx;
	
	hdc = BeginPaint(pr[id].hPd[2], &ps);
	GetClientRect(pr[id].hPd[2], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	pStr = pr[id].names[pr[id].idxNames];
	a_TextOut(hdc, 5, 5, pStr);
	
	idx = PrIdxPaperSize(id);
	pStr = pr[id].arPaperStr[idx];
	
	a_TextOut(hdc, 5, 20, pStr);
//	pr[id].formName;
	
	if (pr[id].orientation == DMORIENT_PORTRAIT) {pStr = (WCHAR *)TxEd(E_PRPORT);}
	else                                            {pStr = (WCHAR *)TxEd(E_PRLAND);}
	a_TextOut(hdc, 5, 35, pStr);
	
	wMm  = pr[id].paperWidth;
	hMm  = pr[id].paperLength;
	dpiX = pr[id].printQuality;
	dpiY = pr[id].yResolution;
	
	idx = 0;
	idx += swprintf(buff+idx,L"%d ~ %d [mm]", wMm/10, hMm/10);
	idx += swprintf(buff+idx,L" , ");
	idx += swprintf(buff+idx,L"%.2f ~ %.2f [inch]", (double)wMm/254, (double)hMm/254);
	a_TextOut(hdc, 5, 50, buff);
	
	swprintf(buff,L"%d [dpi]", dpiX);
	a_TextOut(hdc, 5, 65, buff);
	
	if (((pr[id].flgAnchor[0] == TRUE) &&
		 (pr[id].flgAnchor[1] == TRUE) &&
		 (pr[id].flgAnchor[2] == TRUE) &&
		 (pr[id].flgAnchor[3] == TRUE)) ||
		 (pr[id].flgAnchor[4] == TRUE))
	{
		wcscpy(buff, L"- [%]");
	}
	else {
		if ((pr[id].flgAnchor[0] == TRUE) &&
			(pr[id].flgAnchor[2] == TRUE))
		{
			TryZeroDivision(fm[id].pc[0].img.w);
			percent = (((double)dpiX * pr[id].paperWidth)/ 254)/fm[id].pc[0].img.w;
			percent *= 100;
		}
		else if ((pr[id].flgAnchor[1] == TRUE) &&
				 (pr[id].flgAnchor[3] == TRUE))
		{
			TryZeroDivision(fm[id].pc[0].img.h);
			percent = (((double)dpiY * pr[id].paperLength)/ 254)/fm[id].pc[0].img.h;
			percent *= 100;
		}
		else {
			percent = (double)pr[id].scale/10;
		}
		swprintf(buff,L"%.1f [%]", percent);
	}
	a_TextOut(hdc, 5, 80, buff);
	
	if (pr[id].color == DMCOLOR_MONOCHROME) {pStr = (WCHAR *)TxEd(E_PRMONO);}
	else                                       {pStr = (WCHAR *)TxEd(E_PRCOLOR);}
	a_TextOut(hdc, 5, 95, pStr);
	
	wcscpy(buff, L"1 [inch] = 25.4 [mm]");
	a_TextOut(hdc, 252, 95, buff);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(pr[id].hPd[2], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid PrPdPaint4(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPRINT PD WM_PAINTCxg
------------------------------------------------------------------------------*/
void PrPdPaint4(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	WCHAR buff[100];
	WCHAR buff1[20];
	WCHAR buff2[20];
	WCHAR buff3[20];
	WCHAR buff4[20];
	WCHAR buff5[20];
	double w;
	double h;
	double percent;
	double dpi;
	
	hdc = BeginPaint(pr[id].hPd[3], &ps);
	GetClientRect(pr[id].hPd[3], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	w       = ((double)pr[id].printQuality * pr[id].paperWidth)  / 254;
	h       = ((double)pr[id].yResolution  * pr[id].paperLength) / 254;
	percent = (double)pr[id].scale / 1000;
	dpi     = pr[id].printQuality;
	
	if ((percent == 0) || (dpi == 0)) {
		wcscpy(buff1, L"0");
		wcscpy(buff2, L"0");
	}
	else {
		swprintf(buff1,L"%.1f ~ %.1f", w, h);
		swprintf(buff2,L"%d ~ %d",     fm[id].pc[0].img.w, fm[id].pc[0].img.h);
	}
	swprintf(buff,L"%s [dot]", buff1);  a_TextOut(hdc,5,5, buff);
	swprintf(buff,L"%s [dot]", buff2);  a_TextOut(hdc,5,20,buff);
	
	if (((pr[id].flgAnchor[0] == TRUE) &&
		 (pr[id].flgAnchor[1] == TRUE) &&
		 (pr[id].flgAnchor[2] == TRUE) &&
		 (pr[id].flgAnchor[3] == TRUE)) ||
		 (pr[id].flgAnchor[4] == TRUE))
	{
		wcscpy(buff3, L"-");
		wcscpy(buff4, L"-");
		wcscpy(buff5, L"-");
	}
	else {
		if ((pr[id].flgAnchor[0] == TRUE) &&
			(pr[id].flgAnchor[2] == TRUE))
		{
			TryZeroDivision(fm[id].pc[0].img.w);
			percent = w/fm[id].pc[0].img.w;
		}
		else if ((pr[id].flgAnchor[1] == TRUE) &&
				 (pr[id].flgAnchor[3] == TRUE))
		{
			TryZeroDivision(fm[id].pc[0].img.h);
			percent = h/fm[id].pc[0].img.h;
		}
		
		if ((percent == 0) || (dpi == 0)) {
			wcscpy(buff3, L"0");
			wcscpy(buff4, L"0");
			wcscpy(buff5, L"0");
		}
		else {
			TryZeroDivisionDouble(dpi);
			TryZeroDivisionDouble(percent);
			swprintf(buff3,L"%.2f", dpi/percent);
			swprintf(buff4,L"%.3f", (dpi/2.54)/percent);
			swprintf(buff5,L"%.3f", (100 * 25.4 * percent)/dpi);
		}
	}
	swprintf(buff,L"%s [dot / inch]", buff3);  a_TextOut(hdc,5,50,buff);
	swprintf(buff,L"%s [dot / 10mm]", buff4);  a_TextOut(hdc,5,65,buff);
	swprintf(buff,L"%s [mm / 100dot]",buff5);  a_TextOut(hdc,5,80,buff);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(pr[id].hPd[3], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid PrCmCommand(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM  ID
          LONG    COMBO ID
          WPARAM  -
          LPARAM  -
    @\FPRINT CMB WM_COMMANDCxg
------------------------------------------------------------------------------*/
void PrCmCommand(LONG id, LONG idC, WPARAM wp, LPARAM lp)
{
	INT32 idx;
	INT32 idxPaper;
	WPARAM wpChk;
	WCHAR prScale[4+1];
	
	if (HIWORD(wp) != CBN_SELCHANGE) {return;}
	
	idx = C_GETCURSEL(pr[id].hCmb[idC]);
	
	if (idC == 0) {
		PrLoad(id, idx);
		PrPaperDelete(id);
		PrPaperLoad(id, pr[id].names[idx]);
		PrPaperList(id);
		idxPaper = PrIdxPaperSize(id);
		pr[id].paperWidth  = pr[id].arPaperWidth[idx];
		pr[id].paperLength = pr[id].arPaperLength[idx];
		
		C_SETCURSEL(pr[id].hCmb[1], idxPaper);
		
		_itow(pr[id].scale, prScale, 10);
		SetWindowText(pr[id].hEdit, prScale);
		
		if (pr[id].orientation == DMORIENT_PORTRAIT)  {wpChk = BST_UNCHECKED;}
		else                                          {wpChk = BST_CHECKED;}
		B_SETCHECK(pr[id].hChk[0], wpChk);
		
		InvalidateRect(pr[id].hPd[2], NULL, TRUE);
		InvalidateRect(pr[id].hPd[3], NULL, TRUE);
		UpdateWindow  (pr[id].hPd[2]);
		UpdateWindow  (pr[id].hPd[3]);
		PrSize5(id, NULL, NULL);
	}
	else if (idC == 1) {
		pr[id].paperSize = pr[id].arPaperSize[idx];
		
		if (pr[id].orientation == DMORIENT_PORTRAIT) {
			pr[id].paperWidth  = pr[id].arPaperWidth[idx];
			pr[id].paperLength = pr[id].arPaperLength[idx];
		}
		else {
			pr[id].paperWidth  = pr[id].arPaperLength[idx];
			pr[id].paperLength = pr[id].arPaperWidth[idx];
		}
		InvalidateRect(pr[id].hPd[2], NULL, TRUE);
		InvalidateRect(pr[id].hPd[3], NULL, TRUE);
		UpdateWindow  (pr[id].hPd[2]);
		UpdateWindow  (pr[id].hPd[3]);
		PrSize5(id, NULL, NULL);
	}
//	else {
//		PrUpdate(id);
//	}
}

/*------------------------------------------------------------------------------
    Fvoid PrChSetCheck(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM  ID
          LONG    CHECK ID
          WPARAM  -
          LPARAM  -
    @\FPRINT CHK BM_SETCHECKCxg
------------------------------------------------------------------------------*/
void PrChSetCheck(LONG id, LONG idC, WPARAM wp, LPARAM lp)
{
	INT32 checked;
	INT32 idx;
	
	checked = B_GETCHECK(pr[id].hChk[idC]);
	
	if (idC == 0) {
		idx = PrIdxPaperSize(id);
		
		if (checked == BST_CHECKED) {
			pr[id].orientation = DMORIENT_LANDSCAPE;
			pr[id].paperWidth  = pr[id].arPaperLength[idx];
			pr[id].paperLength = pr[id].arPaperWidth[idx];
		}
		else {
			pr[id].orientation = DMORIENT_PORTRAIT;
			pr[id].paperWidth  = pr[id].arPaperWidth[idx];
			pr[id].paperLength = pr[id].arPaperLength[idx];
		}
		PrSize5(id, NULL, NULL);
	}
	
	InvalidateRect(pr[id].hPd[2], NULL, TRUE);
	InvalidateRect(pr[id].hPd[3], NULL, TRUE);
	UpdateWindow  (pr[id].hPd[2]);
	UpdateWindow  (pr[id].hPd[3]);
}

/*------------------------------------------------------------------------------
    Fvoid PrEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPRINT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void PrEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
//	if (hWnd == pr[id].hCmbEdit) {hWnd = pr[id].hCmb[2];}
	
	for (i = 0; i < TBSP_PRINT; i++) {
		if (hWnd == pr[id].tabStops[i]) {
			pr[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PrEdKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPRINT WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void PrEdKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
//	if ((HWND)wp == pr[id].hCmbEdit) {wp = (WPARAM)pr[id].hCmb[2];}
	
	for (i = 0; i < TBSP_PRINT; i++) {
		if ((HWND)wp == pr[id].tabStops[i]) {
			PrUpdate(id);
			break;
		}
	}
}

/*------------------------------------------------------------------------------
    FBOOL PrEdChar(LONG, WPARAM, LPARAM, HWND )
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    ߒlFBOOL    -
    @\FPRINT WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL PrEdChar(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == pr[id].hEdit) {
		if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	}
//	else if (hWnd == pr[id].hCmbEdit) {
//		if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
//		
//		res = C_GETDROPPEDSTATE(pr[id].hCmb[2]);
//		if (res == TRUE) {
//			if (wp == 0x00D) {return TRUE;}
//		}
//	}
	
	switch (wp) {
	case 0x03:  // ctrl+C
	case 0x08:  // back space
	case 0x16:  // ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid PrAcPaint(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM   ID
          LONG    ANCHOR ID
          WPARAM  -
          LPARAM  -
    @\FPRINT AC WM_PAINTCxg
------------------------------------------------------------------------------*/
void PrAcPaint(LONG id, LONG idA, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	HWND hWnd;
	
	hdc = BeginPaint(pr[id].hAc[idA], &ps);
	GetClientRect(pr[id].hAc[idA], &rc);
	
	if (pr[id].flgAnchor[idA] == TRUE) {
		FillRect(hdc, &rc, hBrSkyBlue);
	}
	else {
		FillRect (hdc, &rc, hBrWhite);
		FrameRect(hdc, &rc, hBrGray);
	}
	
	hWnd = GetFocus();
	if (hWnd == pr[id].hAc[idA]) {FrameRect(hdc, &rc, hBrBlack);}
	
	EndPaint(pr[id].hAc[idA], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid PrAcSetFocus(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    EDIT ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPRINT AC WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void PrAcSetFocus(LONG id, LONG idA, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
//	if ((HWND)wp == pr[id].hCmbEdit) {wp = (WPARAM)pr[id].hCmb[2];}
	
	res = FALSE;
	for (i = 0; i < TBSP_PRINT; i++) {
		if ((HWND)wp == pr[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(pr[id].hAc[idA], NULL, FALSE);
		UpdateWindow  (pr[id].hAc[idA]);
	}
	PrEdSetFocus(id, wp, lp, pr[id].hAc[idA]);
}

/*------------------------------------------------------------------------------
    Fvoid PrAcKillFocus(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    EDIT ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPRINT AC WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void PrAcKillFocus(LONG id, LONG idA, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_PRINT; i++) {
		if ((HWND)wp == pr[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(pr[id].hAc[idA], NULL, FALSE);
		UpdateWindow  (pr[id].hAc[idA]);
	}
}

/*------------------------------------------------------------------------------
    Fvoid PrAcLButtonDown(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM   ID
          LONG    ANCHOR ID
          WPARAM  -
          LPARAM  -
    @\FPRINT AC WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void PrAcLButtonDown(LONG id, LONG idA, WPARAM wp, LPARAM lp)
{
	pr[id].flgClick[idA] = TRUE;
	SetCapture(pr[id].hAc[idA]);
}

/*------------------------------------------------------------------------------
    Fvoid PrAcLButtonUp(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM   ID
          LONG    ANCHOR ID
          WPARAM  -
          LPARAM  -
    @\FPRINT AC WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void PrAcLButtonUp(LONG id, LONG idA, WPARAM wp, LPARAM lp)
{
	if (pr[id].flgClick[idA] == TRUE) {
		if (IsInClientArea(pr[id].hAc[idA], LOWORD(lp), HIWORD(lp))) {
			if (pr[id].flgAnchor[idA] == TRUE) {pr[id].flgAnchor[idA] = FALSE;}
			else                               {pr[id].flgAnchor[idA] = TRUE;}
			
			SetFocus(pr[id].hAc[idA]);
			
			InvalidateRect(pr[id].hAc[idA], NULL, FALSE);
			UpdateWindow  (pr[id].hAc[idA]);
			
			InvalidateRect(pr[id].hPc,    NULL, TRUE);
			InvalidateRect(pr[id].hPd[2], NULL, TRUE);
			InvalidateRect(pr[id].hPd[3], NULL, TRUE);
			UpdateWindow  (pr[id].hPc);
			UpdateWindow  (pr[id].hPd[2]);
			UpdateWindow  (pr[id].hPd[3]);
		}
	}
	
	pr[id].flgClick[idA] = FALSE;
	ReleaseCapture();
}

/*------------------------------------------------------------------------------
    Fvoid PrPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPRINT PC WM_PAINTCxg
------------------------------------------------------------------------------*/
void PrPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	HDC hdcImg;
	PAINTSTRUCT ps;
	RECT rc;
	INT32  x,  y,  w,  h;
	INT32  x1, y1, w1, h1;
	INT32  x2, y2, w2, h2;
	INT32  wScr,  hScr;
	INT32  wPap,  hPap;
	INT32  wImg,  hImg;
	INT32  wGain, hGain;
	INT32  wMax,  hMax;
	double gain;
	st_Image scr;
	INT32 mode;
	
	hdc = BeginPaint(pr[id].hPc, &ps);
	GetClientRect(pr[id].hPc, &rc);
	wScr = rc.right - rc.left;
	hScr = rc.bottom - rc.top;
	
	ImageCreate(&scr, wScr, hScr);
	
	SetClipRgn(scr.hdc, &rc);
	memset(scr.pB, 0xFF, wScr*hScr*4);
	
	wPap = (((double)pr[id].paperWidth  * pr[id].printQuality) / 254);
	hPap = (((double)pr[id].paperLength * pr[id].yResolution)  / 254);
	
	gain = (double)pr[id].scale / 1000;
	wImg  = fm[id].pc[0].img.w;
	hImg  = fm[id].pc[0].img.h;
	wGain = fm[id].pc[0].img.w * gain;
	hGain = fm[id].pc[0].img.h * gain;
	
	TryZeroDivision(wImg);
	TryZeroDivision(hImg);
	wMax = (hPap * wImg) / hImg;
	hMax = (wPap * hImg) / wImg;
	
	if ((wPap == 0) || (hPap == 0)) {
		SelectClipRgn(scr.hdc, NULL);
		ImageDeleteSt(&scr);
		EndPaint(pr[id].hPc, &ps);
		return;
	}
	
	TryZeroDivision(wPap);
	TryZeroDivision(hPap);
	wGain = ((double)wScr * wGain) / wPap;
	hGain = ((double)hScr * hGain) / hPap;
	wMax  = ((double)wScr * wMax)  / wPap;
	hMax  = ((double)hScr * hMax)  / hPap;
	PrPosAnchor(id, &x, &y, &w, &h, wGain, hGain, wMax, hMax, wScr, hScr);
	
	x2 = x;
	y2 = y;
	w2 = w;
	h2 = h;
	x1 = 0;
	y1 = 0;
	w1 = fm[id].pc[0].img.w;
	h1 = fm[id].pc[0].img.h;
	
	if (w2*h2 < w1*h1) {mode = HALFTONE;}
	else               {mode = COLORONCOLOR;}
	SetStretchBltMode(scr.hdc, mode);
	
	hdcImg = fm[id].pc[0].img.hdc;
	
	StretchBlt(scr.hdc, x2, y2, w2, h2,
			   hdcImg,  x1, y1, w1, h1, SRCCOPY);
	
	if ((wScr != 0) && (hScr != 0)) {
		rc.left   = 0;
		rc.top    = 0;
		rc.right  = 0+wScr;
		rc.bottom = 0+hScr;
		FrameRect(scr.hdc, &rc, hBrGray);
	}
	
	if ((w2 != 0) && (h2 != 0)) {
		rc.left   = x2;
		rc.top    = y2;
		rc.right  = x2+w2;
		rc.bottom = y2+h2;
		FrameRect(scr.hdc, &rc, hBrGray);
	}
	
	BitBlt(hdc,     0, 0, wScr, hScr,
		   scr.hdc, 0, 0, SRCCOPY);
	
	SelectClipRgn(scr.hdc, NULL);
	ImageDeleteSt(&scr);
	EndPaint(pr[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    FBOOL PrEnterOk(LONG id)
    FLONG    FORM ID
    ߒlFBOOL    -
    @\Fs
------------------------------------------------------------------------------*/
BOOL PrEnterOk(LONG id)
{
	WCHAR *name;
	DOCINFO di;
	DEVMODE dm;
	HDC hdc;
	INT32 res;
	INT32 x, y, w, h;
	INT32 wPap,  hPap;
	INT32 wImg,  hImg;
	INT32 wGain, hGain;
	INT32 wMax,  hMax;
	double gain;
	INT32 mode;
	
	if (pr[id].color == DMCOLOR_MONOCHROME) {
		PrMsgBx(id, L"monochrome not supported");
		return FALSE;
	}
	
	name = pr[id].names[pr[id].idxNames];
//	PrDump(id, name);
	
	hdc = CreateDC(NULL, name, NULL, NULL);
	if (hdc == NULL) {
		PrMsgBx(id, L"CreateDC fail");
		return FALSE;
	}
	
	memset(&di, 0x00, sizeof(DOCINFO));
	di.cbSize      = sizeof(DOCINFO);
	di.lpszDocName = L_TITLE;
	
	res = StartDoc(hdc, &di);
	if (res <= 0) {
//		PrMsgBx(id, L"StartDoc fail");
		DeleteDC(hdc);
		return FALSE;
	}
	
	memset(&dm, 0x00, sizeof(DEVMODE));
	dm.dmSize        = sizeof(DEVMODE);
	dm.dmFields      = DM_PAPERSIZE|DM_ORIENTATION|DM_PAPERWIDTH;
	dm.dmPaperSize   = (INT16)pr[id].paperSize;
	dm.dmOrientation = (INT16)pr[id].orientation;
	hdc = ResetDC(hdc, &dm);
	
	StartPage(hdc);
	if (res <= 0) {
//		PrMsgBx(id, L"StartPage fail");
		EndDoc(hdc);
		DeleteDC(hdc);
		return FALSE;
	}
	
	wPap = (((double)pr[id].paperWidth  * pr[id].printQuality) / 254);
	hPap = (((double)pr[id].paperLength * pr[id].yResolution)  / 254);
	
	gain = (double)pr[id].scale / 1000;
	wImg  = fm[id].pc[0].img.w;
	hImg  = fm[id].pc[0].img.h;
	wGain = fm[id].pc[0].img.w * gain;
	hGain = fm[id].pc[0].img.h * gain;
	
	TryZeroDivision(wImg);
	TryZeroDivision(hImg);
	wMax = (hPap * wImg) / hImg;
	hMax = (wPap * hImg) / wImg;
	
	PrPosAnchor(id, &x, &y, &w, &h, wGain, hGain, wMax, hMax, wPap, hPap);
	
	if (w*h < wImg*hImg) {mode = HALFTONE;}
	else                 {mode = COLORONCOLOR;}
	SetStretchBltMode(hdc, mode);
	
	StretchBlt(hdc,                  x, y, w,    h,
			   fm[id].pc[0].img.hdc, 0, 0, wImg, hImg, SRCCOPY);
	
	EndPage(hdc);
	EndDoc(hdc);
	DeleteDC(hdc);
	
	return TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid PrUpdate(LONG id)
    FLONG    FORM ID
    @\F̕\XV
------------------------------------------------------------------------------*/
void PrUpdate(LONG id)
{
	WCHAR strEdit[4+1];
	INT32 scale;
	INT32 tmpScale;
	
	tmpScale = pr[id].scale;
	
	GetWindowText(pr[id].hEdit, strEdit, 4+1);
	scale = _wtoi(strEdit);
	
	pr[id].scale = scale;
	
	if (tmpScale != scale) {
		InvalidateRect(pr[id].hPd[2], NULL, TRUE);
		InvalidateRect(pr[id].hPd[3], NULL, TRUE);
		InvalidateRect(pr[id].hPc,    NULL, FALSE);
		UpdateWindow  (pr[id].hPd[2]);
		UpdateWindow  (pr[id].hPd[3]);
		UpdateWindow  (pr[id].hPc);
	}
}

/*------------------------------------------------------------------------------
    Fvoid PrPosAnchor(,,,)
    F-
    @\FAJ[ɂĈWvZ
------------------------------------------------------------------------------*/
void PrPosAnchor(LONG id,INT32 *x,   INT32 *y,   INT32 *w,  INT32 *h,
				 INT32 wGain,INT32 hGain,INT32 wMax,INT32 hMax,INT32 wReso,INT32 hReso)
{
	INT16 flgs;
	
	flgs = 0x0000;
	if (pr[id].flgAnchor[0] == TRUE) {flgs |= 0x0001;}
	if (pr[id].flgAnchor[1] == TRUE) {flgs |= 0x0010;}
	if (pr[id].flgAnchor[2] == TRUE) {flgs |= 0x0100;}
	if (pr[id].flgAnchor[3] == TRUE) {flgs |= 0x1000;}
	if (pr[id].flgAnchor[4] == TRUE) {flgs |= 0x1111;}
	
	switch (flgs) {
	case 0x0000:
		*x = wReso/2 - wGain/2;
		*y = hReso/2 - hGain/2;
		*w = wGain;
		*h = hGain;
		break;
	//---------------------------------//
	case 0x0001:  // 
		*x = 0;
		*y = hReso/2 - hGain/2;
		*w = wGain;
		*h = hGain;
		break;
	case 0x0010:  // 
		*x = wReso/2 - wGain/2;
		*y = 0;
		*w = wGain;
		*h = hGain;
		break;
	case 0x0100:  // 
		*x = wReso - wGain;
		*y = hReso/2 - hGain/2;
		*w = wGain;
		*h = hGain;
		break;
	case 0x1000:  // 
		*x = wReso/2 - wGain/2;
		*y = hReso - hGain;
		*w = wGain;
		*h = hGain;
		break;
	//---------------------------------//
	case 0x0011:  // 
		*x = 0;
		*y = 0;
		*w = wGain;
		*h = hGain;
		break;
	case 0x0110:  // 
		*x = wReso - wGain;
		*y = 0;
		*w = wGain;
		*h = hGain;
		break;
	case 0x1100:  // 
		*x = wReso - wGain;
		*y = hReso - hGain;
		*w = wGain;
		*h = hGain;
		break;
	case 0x1001:  // 
		*x = 0;
		*y = hReso - hGain;
		*w = wGain;
		*h = hGain;
		break;
	//---------------------------------//
	case 0x0101:  // 
		*x = 0;
		*y = hReso/2 - hMax/2;
		*w = wReso;
		*h = hMax;
		break;
	case 0x1010:  // 
		*x = wReso/2 - wMax/2;
		*y = 0;
		*w = wMax;
		*h = hReso;
		break;
	//---------------------------------//
	case 0x0111:  // 
		*x = 0;
		*y = 0;
		*w = wReso;
		*h = hMax;
		break;
	case 0x1110:  // 
		*x = wReso - wMax;
		*y = 0;
		*w = wMax;
		*h = hReso;
		break;
	case 0x1101:  // 
		*x = 0;
		*y = hReso - hMax;
		*w = wReso;
		*h = hMax;
		break;
	case 0x1011:  // 
		*x = 0;
		*y = 0;
		*w = wMax;
		*h = hReso;
		break;
	//---------------------------------//
	case 0x1111:  // 
		*x = 0;
		*y = 0;
		*w = wReso;
		*h = hReso;
		break;
	//---------------------------------//
	default:
		*x = 0;
		*y = 0;
		*w = 0;
		*h = 0;
		break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid PrMonoCreate(LONG)
    FLONG     FORM ID
    @\F C[W쐬
------------------------------------------------------------------------------*/
void PrMonoCreate(LONG id)
{
//	BITMAPINFO bInfo;
//	INT32 w;
//	INT32 h;
//	INT32 i;
//	INT32 j;
//	BYTE *pB1;
//	BYTE *pB2;
//	INT8 ave;
//	
//	w = fm[id].pc[0].img.w;
//	h = fm[id].pc[0].img.h;
//	InitBIH(w, h, &bInfo);
//	pr[id].pc.mono.hBmp = a_CreateDIBSection(NULL, &bInfo, 0, (void **)&pr[id].pc.mono.pB, NULL, 0);
//	pr[id].pc.mono.hdc  = CreateCompatibleDC(NULL);
//	SelectObject(pr[id].pc.mono.hdc, pr[id].pc.mono.hBmp);
//	pr[id].pc.mono.w = w;
//	pr[id].pc.mono.h = h;
//	
//	pB2 = pr[id].pc.mono.pB;
//	pB1 = fm[id].pc[0].img.pB;
//	for (i = 0; i < h; i++) {
//		for (j = 0; j < w; j++) {
//			*(pB2+2) = *(pB2+1) = *(pB2+0) = (*(pB1+2) +*(pB1+1) +*(pB1+0)) / 3;
//			pB2 += 4;
//			pB1 += 4;
//		}
//	}
}

/*------------------------------------------------------------------------------
    Fvoid PrMonoDelete(LONG)
    FLONG     FORM ID
    @\F C[W폜
------------------------------------------------------------------------------*/
void PrMonoDelete(LONG id)
{
//	DeleteDC    (pr[id].pc.mono.hdc);
//	DeleteObject(pr[id].pc.mono.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid PrLoad(LONG, INT32)
    FLONG   FORM ID
          INT32  -
    @\Fv^̐ݒǂݍ
------------------------------------------------------------------------------*/
void PrLoad(LONG id, INT32 idxPrint)
{
	INT32 i;
	INT32 idx;
	DWORD size;
	DWORD cnt;
	WCHAR nameDef[50+1];
	PRINTER_INFO_1 *PI1;
	PRINTER_INFO_2 *PI2;
	HANDLE hWnd;
	PRINTER_DEFAULTS pd;
	BYTE *buff;
	BOOL res;
	
	size = 0;
	GetDefaultPrinter(NULL,   &size);  if (50 < size) {return;}
	GetDefaultPrinter(nameDef,&size);
	
	EnumPrinters(PRINTER_ENUM_LOCAL,NULL,1,NULL,0,   &size,&cnt); if(10<cnt){return;} buff=(BYTE *)a_malloc(size);
	EnumPrinters(PRINTER_ENUM_LOCAL,NULL,1,buff,size,&size,&cnt);
	PI1 = (PRINTER_INFO_1 *)buff;
	
	for (i = 0; i < cnt; i++) {
		wcscpy(pr[id].names[i], PI1[i].pName);
	}
	free(buff);
	
	idx = 99;
	for (i = 0; i < cnt; i++) {
		if (wcscmp(nameDef, pr[id].names[i]) == 0) {
			idx = i;
			break;
		}
	}
	if (idx == 99) {return;}
	
	if (idxPrint != 99) {idx = idxPrint;}
	
	pr[id].idxNames = idx;
	pr[id].cntNames = cnt;
	
	memset(&pd, 0x00, sizeof(PRINTER_DEFAULTS));
	res = OpenPrinter(pr[id].names[idx], &hWnd, &pd);
	if (res == FALSE){
		PrMsgBx(id, L"OpenPrinter fail");
		return;
	}
	
	size = 0;
	GetPrinter(hWnd,2,NULL,0,   &size);  buff=(BYTE *)a_malloc(size);
	GetPrinter(hWnd,2,buff,size,&size);
	PI2 = (PRINTER_INFO_2 *)buff;
	
	pr[id].orientation = PI2->pDevMode->dmOrientation;
	pr[id].paperSize   = PI2->pDevMode->dmPaperSize;
	
//	pr[id].paperWidth
//	pr[id].paperLength
	pr[id].scale        = PI2->pDevMode->dmScale*10;
	pr[id].color        = PI2->pDevMode->dmColor;
	pr[id].printQuality = PI2->pDevMode->dmPrintQuality;
	pr[id].yResolution  = PI2->pDevMode->dmYResolution;
	wcscpy(pr[id].formName, PI2->pDevMode->dmFormName);
	
	free(buff);
	ClosePrinter(hWnd);
	
//	PrDump(id, pr[id].names[idx]);
}

/*------------------------------------------------------------------------------
    Fvoid PrPaperLoad(LONG)
    FLONG  FORM ID
    @\Fv^̑Ήpǂݍ
------------------------------------------------------------------------------*/
void PrPaperLoad(LONG id, WCHAR *name)
{
	INT32 i;
	BOOL res;
	PRINTER_DEFAULTS pd;
	HANDLE hWnder;
	DWORD size;
	BYTE * buff1;
	WORD * buff2;
	POINT *buff3;
	PRINTER_INFO_5 *PI5;
	WCHAR *pStr;
	
	memset(&pd, 0x00, sizeof(PRINTER_DEFAULTS));
	res = OpenPrinter(name, &hWnder, &pd);
	if (res == FALSE){
//		PrMsgBx(id, L"OpenPrinter fail");
		return;
	}
	
	size = 0;
	GetPrinter(hWnder,5,NULL, 0,   &size);  buff1=(BYTE *)a_malloc(size);
	GetPrinter(hWnder,5,buff1,size,&size);
	PI5 = (PRINTER_INFO_5 *)buff1;
	
	size  = DeviceCapabilities(PI5->pPrinterName, PI5->pPortName, DC_PAPERS, NULL,          NULL);
	buff2 =(WORD *)a_malloc(sizeof(WORD)*size);
	        DeviceCapabilities(PI5->pPrinterName, PI5->pPortName, DC_PAPERS, (LPWSTR)buff2, NULL);
	
	pr[id].arPaperSize   = (INT32 *) a_malloc(sizeof(INT32)*size);
	pr[id].arPaperWidth  = (INT32 *) a_malloc(sizeof(INT32)*size);
	pr[id].arPaperLength = (INT32 *) a_malloc(sizeof(INT32)*size);
	pr[id].arPaperStr    = (WCHAR **)a_malloc(sizeof(WCHAR *)*size);
	for (i = 0; i < size; i++) {
		pr[id].arPaperStr[i] = (WCHAR *)a_malloc(sizeof(WCHAR *)*30);
	}
	pr[id].cntArray = size;
	
	for (i = 0; i < size; i++) {
		switch (buff2[i]) {
		case DMPAPER_LETTER:                        pStr = (WCHAR *)L"LETTER";                        break;
		case DMPAPER_LETTERSMALL:                   pStr = (WCHAR *)L"LETTERSMALL";                   break;
		case DMPAPER_TABLOID:                       pStr = (WCHAR *)L"TABLOID";                       break;
		case DMPAPER_LEDGER:                        pStr = (WCHAR *)L"LEDGER";                        break;
		case DMPAPER_LEGAL:                         pStr = (WCHAR *)L"LEGAL";                         break;
		case DMPAPER_STATEMENT:                     pStr = (WCHAR *)L"STATEMENT";                     break;
		case DMPAPER_EXECUTIVE:                     pStr = (WCHAR *)L"EXECUTIVE";                     break;
		case DMPAPER_A3:                            pStr = (WCHAR *)L"A3";                            break;
		case DMPAPER_A4:                            pStr = (WCHAR *)L"A4";                            break;
		case DMPAPER_A4SMALL:                       pStr = (WCHAR *)L"A4SMALL";                       break;
		case DMPAPER_A5:                            pStr = (WCHAR *)L"A5";                            break;
		case DMPAPER_B4:                            pStr = (WCHAR *)L"B4";                            break;
		case DMPAPER_B5:                            pStr = (WCHAR *)L"B5";                            break;
		case DMPAPER_FOLIO:                         pStr = (WCHAR *)L"FOLIO";                         break;
		case DMPAPER_QUARTO:                        pStr = (WCHAR *)L"QUARTO";                        break;
		case DMPAPER_10X14:                         pStr = (WCHAR *)L"10X14";                         break;
		case DMPAPER_11X17:                         pStr = (WCHAR *)L"11X17";                         break;
		case DMPAPER_NOTE:                          pStr = (WCHAR *)L"NOTE";                          break;
		case DMPAPER_ENV_9:                         pStr = (WCHAR *)L"ENV_9";                         break;
		case DMPAPER_ENV_10:                        pStr = (WCHAR *)L"ENV_10";                        break;
		case DMPAPER_ENV_11:                        pStr = (WCHAR *)L"ENV_11";                        break;
		case DMPAPER_ENV_12:                        pStr = (WCHAR *)L"ENV_12";                        break;
		case DMPAPER_ENV_14:                        pStr = (WCHAR *)L"ENV_14";                        break;
		case DMPAPER_CSHEET:                        pStr = (WCHAR *)L"CSHEET";                        break;
		case DMPAPER_DSHEET:                        pStr = (WCHAR *)L"DSHEET";                        break;
		case DMPAPER_ESHEET:                        pStr = (WCHAR *)L"ESHEET";                        break;
		case DMPAPER_ENV_DL:                        pStr = (WCHAR *)L"ENV_DL";                        break;
		case DMPAPER_ENV_C5:                        pStr = (WCHAR *)L"ENV_C5";                        break;
		case DMPAPER_ENV_C3:                        pStr = (WCHAR *)L"ENV_C3";                        break;
		case DMPAPER_ENV_C4:                        pStr = (WCHAR *)L"ENV_C4";                        break;
		case DMPAPER_ENV_C6:                        pStr = (WCHAR *)L"ENV_C6";                        break;
		case DMPAPER_ENV_C65:                       pStr = (WCHAR *)L"ENV_C65";                       break;
		case DMPAPER_ENV_B4:                        pStr = (WCHAR *)L"ENV_B4";                        break;
		case DMPAPER_ENV_B5:                        pStr = (WCHAR *)L"ENV_B5";                        break;
		case DMPAPER_ENV_B6:                        pStr = (WCHAR *)L"ENV_B6";                        break;
		case DMPAPER_ENV_ITALY:                     pStr = (WCHAR *)L"ENV_ITALY";                     break;
		case DMPAPER_ENV_MONARCH:                   pStr = (WCHAR *)L"ENV_MONARCH";                   break;
		case DMPAPER_ENV_PERSONAL:                  pStr = (WCHAR *)L"ENV_PERSONAL";                  break;
		case DMPAPER_FANFOLD_US:                    pStr = (WCHAR *)L"FANFOLD_US";                    break;
		case DMPAPER_FANFOLD_STD_GERMAN:            pStr = (WCHAR *)L"FANFOLD_STD_GERMAN";            break;
		case DMPAPER_FANFOLD_LGL_GERMAN:            pStr = (WCHAR *)L"FANFOLD_LGL_GERMAN";            break;
		case DMPAPER_ISO_B4:                        pStr = (WCHAR *)L"ISO_B4";                        break;
		case DMPAPER_JAPANESE_POSTCARD:             pStr = (WCHAR *)L"JAPANESE_POSTCARD";             break;
		case DMPAPER_9X11:                          pStr = (WCHAR *)L"9X11";                          break;
		case DMPAPER_10X11:                         pStr = (WCHAR *)L"10X11";                         break;
		case DMPAPER_15X11:                         pStr = (WCHAR *)L"15X11";                         break;
		case DMPAPER_ENV_INVITE:                    pStr = (WCHAR *)L"ENV_INVITE";                    break;
		case DMPAPER_RESERVED_48:                   pStr = (WCHAR *)L"RESERVED_48";                   break;
		case DMPAPER_RESERVED_49:                   pStr = (WCHAR *)L"RESERVED_49";                   break;
		case DMPAPER_LETTER_EXTRA:                  pStr = (WCHAR *)L"LETTER_EXTRA";                  break;
		case DMPAPER_LEGAL_EXTRA:                   pStr = (WCHAR *)L"LEGAL_EXTRA";                   break;
		case DMPAPER_TABLOID_EXTRA:                 pStr = (WCHAR *)L"TABLOID_EXTRA";                 break;
		case DMPAPER_A4_EXTRA:                      pStr = (WCHAR *)L"A4_EXTRA";                      break;
		case DMPAPER_LETTER_TRANSVERSE:             pStr = (WCHAR *)L"LETTER_TRANSVERSE";             break;
		case DMPAPER_A4_TRANSVERSE:                 pStr = (WCHAR *)L"A4_TRANSVERSE";                 break;
		case DMPAPER_A_PLUS:                        pStr = (WCHAR *)L"A_PLUS";                        break;
		case DMPAPER_B_PLUS:                        pStr = (WCHAR *)L"B_PLUS";                        break;
		case DMPAPER_LETTER_PLUS:                   pStr = (WCHAR *)L"LETTER_PLUS";                   break;
		case DMPAPER_A4_PLUS:                       pStr = (WCHAR *)L"A4_PLUS";                       break;
		case DMPAPER_A5_TRANSVERSE:                 pStr = (WCHAR *)L"A5_TRANSVERSE";                 break;
		case DMPAPER_B5_TRANSVERSE:                 pStr = (WCHAR *)L"B5_TRANSVERSE";                 break;
		case DMPAPER_A3_EXTRA:                      pStr = (WCHAR *)L"A3_EXTRA";                      break;
		case DMPAPER_A5_EXTRA:                      pStr = (WCHAR *)L"A5_EXTRA";                      break;
		case DMPAPER_B5_EXTRA:                      pStr = (WCHAR *)L"B5_EXTRA";                      break;
		case DMPAPER_A2:                            pStr = (WCHAR *)L"A2";                            break;
		case DMPAPER_A3_TRANSVERSE:                 pStr = (WCHAR *)L"A3_TRANSVERSE";                 break;
		case DMPAPER_A3_EXTRA_TRANSVERSE:           pStr = (WCHAR *)L"A3_EXTRA_TRANSVERSE";           break;
		case DMPAPER_DBL_JAPANESE_POSTCARD:         pStr = (WCHAR *)L"DBL_JAPANESE_POSTCARD";         break;
		case DMPAPER_A6:                            pStr = (WCHAR *)L"A6";                            break;
		case DMPAPER_JENV_KAKU2:                    pStr = (WCHAR *)L"JENV_KAKU2";                    break;
		case DMPAPER_JENV_KAKU3:                    pStr = (WCHAR *)L"JENV_KAKU3";                    break;
		case DMPAPER_JENV_CHOU3:                    pStr = (WCHAR *)L"JENV_CHOU3";                    break;
		case DMPAPER_JENV_CHOU4:                    pStr = (WCHAR *)L"JENV_CHOU4";                    break;
		case DMPAPER_LETTER_ROTATED:                pStr = (WCHAR *)L"LETTER_ROTATED";                break;
		case DMPAPER_A3_ROTATED:                    pStr = (WCHAR *)L"A3_ROTATED";                    break;
		case DMPAPER_A4_ROTATED:                    pStr = (WCHAR *)L"A4_ROTATED";                    break;
		case DMPAPER_A5_ROTATED:                    pStr = (WCHAR *)L"A5_ROTATED";                    break;
		case DMPAPER_B4_JIS_ROTATED:                pStr = (WCHAR *)L"B4_JIS_ROTATED";                break;
		case DMPAPER_B5_JIS_ROTATED:                pStr = (WCHAR *)L"B5_JIS_ROTATED";                break;
		case DMPAPER_JAPANESE_POSTCARD_ROTATED:     pStr = (WCHAR *)L"JAPANESE_POSTCARD_ROTATED";     break;
		case DMPAPER_DBL_JAPANESE_POSTCARD_ROTATED: pStr = (WCHAR *)L"DBL_JAPANESE_POSTCARD_ROTATED"; break;
		case DMPAPER_A6_ROTATED:                    pStr = (WCHAR *)L"A6_ROTATED";                    break;
		case DMPAPER_JENV_KAKU2_ROTATED:            pStr = (WCHAR *)L"JENV_KAKU2_ROTATED";            break;
		case DMPAPER_JENV_KAKU3_ROTATED:            pStr = (WCHAR *)L"JENV_KAKU3_ROTATED";            break;
		case DMPAPER_JENV_CHOU3_ROTATED:            pStr = (WCHAR *)L"JENV_CHOU3_ROTATED";            break;
		case DMPAPER_JENV_CHOU4_ROTATED:            pStr = (WCHAR *)L"JENV_CHOU4_ROTATED";            break;
		case DMPAPER_B6_JIS:                        pStr = (WCHAR *)L"B6_JIS";                        break;
		case DMPAPER_B6_JIS_ROTATED:                pStr = (WCHAR *)L"B6_JIS_ROTATED";                break;
		case DMPAPER_12X11:                         pStr = (WCHAR *)L"12X11";                         break;
		case DMPAPER_JENV_YOU4:                     pStr = (WCHAR *)L"JENV_YOU4";                     break;
		case DMPAPER_JENV_YOU4_ROTATED:             pStr = (WCHAR *)L"JENV_YOU4_ROTATED";             break;
		case DMPAPER_P16K:                          pStr = (WCHAR *)L"P16K";                          break;
		case DMPAPER_P32K:                          pStr = (WCHAR *)L"P32K";                          break;
		case DMPAPER_P32KBIG:                       pStr = (WCHAR *)L"P32KBIG";                       break;
		case DMPAPER_PENV_1:                        pStr = (WCHAR *)L"PENV_1";                        break;
		case DMPAPER_PENV_2:                        pStr = (WCHAR *)L"PENV_2";                        break;
		case DMPAPER_PENV_3:                        pStr = (WCHAR *)L"PENV_3";                        break;
		case DMPAPER_PENV_4:                        pStr = (WCHAR *)L"PENV_4";                        break;
		case DMPAPER_PENV_5:                        pStr = (WCHAR *)L"PENV_5";                        break;
		case DMPAPER_PENV_6:                        pStr = (WCHAR *)L"PENV_6";                        break;
		case DMPAPER_PENV_7:                        pStr = (WCHAR *)L"PENV_7";                        break;
		case DMPAPER_PENV_8:                        pStr = (WCHAR *)L"PENV_8";                        break;
		case DMPAPER_PENV_9:                        pStr = (WCHAR *)L"PENV_9";                        break;
		case DMPAPER_PENV_10:                       pStr = (WCHAR *)L"PENV_10";                       break;
		case DMPAPER_P16K_ROTATED:                  pStr = (WCHAR *)L"P16K_ROTATED";                  break;
		case DMPAPER_P32K_ROTATED:                  pStr = (WCHAR *)L"P32K_ROTATED";                  break;
		case DMPAPER_P32KBIG_ROTATED:               pStr = (WCHAR *)L"P32KBIG_ROTATED";               break;
		case DMPAPER_PENV_1_ROTATED:                pStr = (WCHAR *)L"PENV_1_ROTATED";                break;
		case DMPAPER_PENV_2_ROTATED:                pStr = (WCHAR *)L"PENV_2_ROTATED";                break;
		case DMPAPER_PENV_3_ROTATED:                pStr = (WCHAR *)L"PENV_3_ROTATED";                break;
		case DMPAPER_PENV_4_ROTATED:                pStr = (WCHAR *)L"PENV_4_ROTATED";                break;
		case DMPAPER_PENV_5_ROTATED:                pStr = (WCHAR *)L"PENV_5_ROTATED";                break;
		case DMPAPER_PENV_6_ROTATED:                pStr = (WCHAR *)L"PENV_6_ROTATED";                break;
		case DMPAPER_PENV_7_ROTATED:                pStr = (WCHAR *)L"PENV_7_ROTATED";                break;
		case DMPAPER_PENV_8_ROTATED:                pStr = (WCHAR *)L"PENV_8_ROTATED";                break;
		case DMPAPER_PENV_9_ROTATED:                pStr = (WCHAR *)L"PENV_9_ROTATED";                break;
		case DMPAPER_PENV_10_ROTATED:               pStr = (WCHAR *)L"PENV_10_ROTATED";               break;
		default:                                    pStr = (WCHAR *)L"-";                              break;
		}
		pr[id].arPaperSize[i] = buff2[i];
		wcscpy(pr[id].arPaperStr[i], pStr);
	}
	
	size  = DeviceCapabilities(PI5->pPrinterName, PI5->pPortName, DC_PAPERSIZE, NULL,          NULL);
	buff3 =(POINT *)a_malloc(sizeof(POINT)*size);
	        DeviceCapabilities(PI5->pPrinterName, PI5->pPortName, DC_PAPERSIZE, (LPWSTR)buff3, NULL);
	
	for (i = 0; i < size; i++) {
		pr[id].arPaperWidth[i]  = buff3[i].x;
		pr[id].arPaperLength[i] = buff3[i].y;
	}
	
	free(buff1);
	free(buff2);
	free(buff3);
	ClosePrinter(hWnder);
}

/*------------------------------------------------------------------------------
    Fvoid PrPaperList(LONG)
    FLONG  FORM ID
    @\Fv^̑Ήpꗗ쐬
------------------------------------------------------------------------------*/
void PrPaperList(LONG id)
{
	INT32 i;
	INT32 cnt;
	
	cnt = C_GETCOUNT(pr[id].hCmb[1]);
	
	for (i = 0; i < cnt; i++) {
		C_DELETESTRING(pr[id].hCmb[1]);
	}
	
	for (i = 0; i < pr[id].cntArray; i++) {
		C_ADDSTRING(pr[id].hCmb[1], pr[id].arPaperStr[i]);
	}
}

/*------------------------------------------------------------------------------
    Fvoid PrPaperDelete(LONG)
    FLONG  FORM ID
    @\Fv^̑Ήp폜
------------------------------------------------------------------------------*/
void PrPaperDelete(LONG id)
{
	INT32 i;
	
	free(pr[id].arPaperSize);
	free(pr[id].arPaperWidth);
	free(pr[id].arPaperLength);
	
	for (i = 0; i < pr[id].cntArray; i++) {free(pr[id].arPaperStr[i]);}
	free(pr[id].arPaperStr);
	
	pr[id].arPaperSize   = NULL;
	pr[id].arPaperWidth  = NULL;
	pr[id].arPaperLength = NULL;
	pr[id].arPaperStr    = NULL;
	pr[id].cntArray      = 0;
}

/*------------------------------------------------------------------------------
    Fvoid PrIdxPaperSize(LONG)
    FLONG  FORM ID
    @\FpTCỸCfbNX擾
------------------------------------------------------------------------------*/
INT32 PrIdxPaperSize(LONG id)
{
	INT32 i;
	INT32 idx;
	
	idx = 0;
	for (i = 0; i < pr[id].cntArray; i++) {
		if (pr[id].paperSize == pr[id].arPaperSize[i]) {
			idx = i;
			break;
		}
	}
	return idx;
}

/*------------------------------------------------------------------------------
    Fvoid PrDump(LONG)
    FLONG  FORM ID
    @\Fv^̐ݒo
------------------------------------------------------------------------------*/
void PrDump(LONG id, WCHAR *name)
{
	BOOL res;
	PRINTER_DEFAULTS pd;
	HANDLE hWnder;
	DWORD size;
	BYTE *buff;
	PRINTER_INFO_2 *PI2;
	DEVMODE *dm;
	WCHAR str[1000];
	INT32 idx;
	
	memset(&pd, 0x00, sizeof(PRINTER_DEFAULTS));
	res = OpenPrinter(name, &hWnder, &pd);
	if (res == FALSE){
//		PrMsgBx(id, L"OpenPrinter fail");
		return;
	}
	
	size = 0;
	GetPrinter(hWnder,2,NULL,0,   &size);  buff=(BYTE *)a_malloc(size);
	GetPrinter(hWnder,2,buff,size,&size);
	PI2 = (PRINTER_INFO_2 *)buff;
	dm = PI2->pDevMode;
	
	idx = 0;
	idx += swprintf(str+idx, L"DeviceName\t%s\r\n",      dm->dmDeviceName);
	idx += swprintf(str+idx, L"SpecVersion\t0x%X\r\n",   dm->dmSpecVersion);
	idx += swprintf(str+idx, L"DriverVersion\t0x%X\r\n", dm->dmDriverVersion);
	idx += swprintf(str+idx, L"Size\t\t%d\r\n",          dm->dmSize);
	idx += swprintf(str+idx, L"DriverExtra\t%d\r\n",     dm->dmDriverExtra);
	idx += swprintf(str+idx, L"Fields\t\t0x%X\r\n",      dm->dmFields);			// ڗLtO
	idx += swprintf(str+idx, L"Orientation\t%d\r\n",     dm->dmOrientation);
	idx += swprintf(str+idx, L"PaperSize\t%d\r\n",       dm->dmPaperSize);		// 9=A4
	idx += swprintf(str+idx, L"PaperLength\t%d\r\n",     dm->dmPaperLength);
	idx += swprintf(str+idx, L"PaperWidth\t%d\r\n",      dm->dmPaperWidth);
	idx += swprintf(str+idx, L"Scale\t\t%d\r\n",         dm->dmScale);
	idx += swprintf(str+idx, L"Copies\t\t%d\r\n",        dm->dmCopies);
	idx += swprintf(str+idx, L"DefaultSource\t%d\r\n",   dm->dmDefaultSource);
	idx += swprintf(str+idx, L"PrintQuality\t%d\r\n",    dm->dmPrintQuality);
	idx += swprintf(str+idx, L"Color\t\t%d\r\n",         dm->dmColor);			// 2=COLOR,1=MONOCHROME
	idx += swprintf(str+idx, L"Duplex\t\t%d\r\n",        dm->dmDuplex);
	idx += swprintf(str+idx, L"YResolution\t%d\r\n",     dm->dmYResolution);
	idx += swprintf(str+idx, L"TTOption\t\t%d\r\n",      dm->dmTTOption);
	idx += swprintf(str+idx, L"Collate\t\t%d\r\n",       dm->dmCollate);
	idx += swprintf(str+idx, L"FormName\t%s\r\n",        dm->dmFormName);
	idx += swprintf(str+idx, L"LogPixels\t\t%d\r\n",     dm->dmLogPixels);
	idx += swprintf(str+idx, L"BitsPerPel\t%d\r\n",      dm->dmBitsPerPel);
	idx += swprintf(str+idx, L"PelsWidth\t%d\r\n",       dm->dmPelsWidth);
	idx += swprintf(str+idx, L"PelsHeight\t%d\r\n",      dm->dmPelsHeight);
	idx += swprintf(str+idx, L"Nup\t\t%d\r\n",           dm->dmNup);
	idx += swprintf(str+idx, L"DisplayFrequency\t%d\r\n",dm->dmDisplayFrequency);
	idx += swprintf(str+idx, L"ICMMethod\t%d\r\n",       dm->dmICMMethod);
	idx += swprintf(str+idx, L"ICMIntent\t%d\r\n",       dm->dmICMIntent);
	idx += swprintf(str+idx, L"MediaType\t%d\r\n",       dm->dmMediaType);
	idx += swprintf(str+idx, L"DitherType\t%d\r\n",      dm->dmDitherType);
	idx += swprintf(str+idx, L"Reserved1\t%d\r\n",       dm->dmReserved1);
	idx += swprintf(str+idx, L"Reserved2\t%d\r\n",       dm->dmReserved2);
	idx += swprintf(str+idx, L"PanningWidth\t%d\r\n",    dm->dmPanningWidth);
	idx += swprintf(str+idx, L"PanningHeight\t%d\r\n",   dm->dmPanningHeight);
	idx += swprintf(str+idx, L"%d", idx);
	
	PrMsgBx(id, str);
	
	free(buff);
	ClosePrinter(hWnder);
}

/*------------------------------------------------------------------------------
    Fvoid PrImageView(LONG)
    FLONG    FORM ID
    @\F̃vr[\p
------------------------------------------------------------------------------*/
void PrImageView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	INT32 val1;
	INT32 val2;
	
	if (IsBit(fm[id].pc[0].img.stat, BIT_NONE|BIT_FAILURE)) {return;}
	if (pr[id].paperWidth  == 0) {return;}
	if (pr[id].paperLength == 0) {return;}
	
	val1 = pr[id].paperWidth;
	val2 = pr[id].paperLength;
	
	TryZeroDivision(val1);
	TryZeroDivision(val2);
	gainW = (double)pr[id].cn.w / val1;
	gainH = (double)pr[id].cn.h / val2;
	
	if ((1 < gainW) && (1 < gainH)) {
		gainW = gainH = (double)1;
	}
	else {
		if (CmpGain(gainW, gainH) == TRUE) {
			limW = TRUE;
			limH = TRUE;
		}
		else {
			if (gainW < gainH) {
				gainH = gainW;
				limW = TRUE;
			}
			else {
				gainW = gainH;
				limH = TRUE;
			}
		}
	}
	
	x = (double)pr[id].cn.w / 2 - (double)val1 * gainW / 2;
	y = (double)pr[id].cn.h / 2 - (double)val2 * gainH / 2;
	w = (double)val1 * gainW;
	h = (double)val2 * gainH;
	
	if (limW == TRUE) {x = 0;  w = pr[id].cn.w;}
	if (limH == TRUE) {y = 0;  h = pr[id].cn.h;}
	
	pr[id].pc.x = x;
	pr[id].pc.y = y;
	if (w <= 0) {pr[id].pc.w = 1;}
	else        {pr[id].pc.w = w;}
	if (h <= 0) {pr[id].pc.h = 1;}
	else        {pr[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    Fvoid PrSetPane(LONG)
    FLONG    FORM ID
    @\F̕\̘g\
------------------------------------------------------------------------------*/
void PrSetPane(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(pr[id].hPd[4], &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	a_SetWindowPos(pr[id].hCn, PADD8, PADD8, w-PADD8*2, h-PADD8*2);
	
	GetClientRect(pr[id].hCn, &rc);
	pr[id].cn.x = rc.left;
	pr[id].cn.y = rc.top;
	pr[id].cn.w = rc.right - rc.left;
	pr[id].cn.h = rc.bottom - rc.top;
}
