/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define RB_CPP
#include "../common.h"
//  RgbFRGB

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	COLORREF rgb;
	WCHAR path[MAX_PATH];
	HWND hBack;
	HWND hBackEdit;
	BOOL flgClick;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_RGB];
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			st_Image img;} pc;
	
	HWND hWnd;
	HWND hPd[3];
	HWND hEdit[2];
	HWND hBtn[2];
	HWND hPc;
	HWND hPv;
	
	LRESULT (CALLBACK *pCallEdit[2]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn [2]) (HWND,UINT,WPARAM,LPARAM);
} rb[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void RbInitClass(void);
void RbInit(LONG);
void RbInst(LONG, HWND, WCHAR *);
void RbDialog(LONG, WCHAR *, HWND, HWND, HWND);
void RbLoad(LONG);
void RbStore(LONG);
void RbBoxPaint(LONG, HWND);
LRESULT CALLBACK RbWndProc     (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RbWndProcPd   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RbWndProcEditF(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RbWndProcEditP(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RbWndProcBtnF (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RbWndProcBtnP (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RbWndProcPc   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RbWndProcPv   (HWND, UINT, WPARAM, LPARAM);
void RbSetFocus     (LONG, WPARAM, LPARAM);
void RbSize         (LONG, WPARAM, LPARAM);
void RbSizePd1      (LONG);
void RbSizePd2      (LONG);
void RbSizePd3      (LONG);
void RbKeyDown      (LONG, WPARAM, LPARAM, HWND);
void RbKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void RbKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void RbKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void RbClose        (LONG, WPARAM, LPARAM);
void RbDestroy      (LONG, WPARAM, LPARAM);
void RbPdCommand    (LONG, LONG, WPARAM, LPARAM);
void RbEdSetFocus   (LONG, WPARAM, LPARAM, HWND);
BOOL RbEdChar       (LONG, WPARAM, LPARAM, HWND);
void RbBtSetFocus   (LONG, WPARAM, LPARAM, HWND);
void RbPcPaint      (LONG, WPARAM, LPARAM);
void RbPcLButtonDown(LONG, WPARAM, LPARAM);
void RbPcLButtonUp  (LONG, WPARAM, LPARAM);
void RbPvPaint      (LONG, WPARAM, LPARAM);
void RbEnterBrs(LONG);
void RbEnterOk(LONG);
void RbPlacement(LONG, HWND, INT32, INT32);
void RbImageRead(LONG);
void RbImageDraw(LONG, Bitmap *);
void RbImageView(LONG);
void RbImageDelete(LONG);

/*------------------------------------------------------------------------------
    Fvoid RbInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void RbInitClass(void)
{
	WNDCLASS wcRgbBox;
	WNDCLASS wcRgb;
	WNDCLASS wcRgbPd;
	WNDCLASS wcRgbPc;
	WNDCLASS wcRgbPv;
	
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurHand, hBrWhite, NM_RGBBOX,&wcRgbBox);
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_RGB,   &wcRgb);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_RGBPD, &wcRgbPd);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurSpuit,hBrNull,  NM_RGBPC, &wcRgbPc);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrNull,  NM_RGBPV, &wcRgbPv);
	
	RegisterClass(&wcRgbBox);
	RegisterClass(&wcRgb);
	RegisterClass(&wcRgbPd);
	RegisterClass(&wcRgbPc);
	RegisterClass(&wcRgbPv);
}

/*------------------------------------------------------------------------------
    Fvoid RbInit(LONG)
    FLONG    FORM ID
    @\FFI
------------------------------------------------------------------------------*/
void RbInit(LONG id)
{
	INT32 i;
	
	rb[id].rgb = RGB_BLACK;
	wmemset(rb[id].path, 0x0000, MAX_PATH);
	
	rb[id].hBack     = NULL;
	rb[id].hBackEdit = NULL;
	rb[id].flgClick  = FALSE;
	
	rb[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_RGB; i++) {rb[id].tabStops[i] = NULL;}
	
	rb[id].pc.x = 0;
	rb[id].pc.y = 0;
	rb[id].pc.w = 0;
	rb[id].pc.h = 0;
	
	InitImg(&rb[id].pc.img);
	
	rb[id].hWnd = NULL;
	for (i = 0; i < 3; i++) {rb[id].hPd  [i] = NULL;}
	for (i = 0; i < 2; i++) {rb[id].hEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {rb[id].hBtn [i] = NULL;}
	rb[id].hPc = NULL;
	rb[id].hPv = NULL;
	
	for (i = 0; i < 2; i++) {rb[id].pCallEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {rb[id].pCallBtn [i] = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid RbInst(LONG, HWND, WCHAR *)
    FLONG     FORM ID
          HWND     -
          WCHAR *  F
    @\FRGB̉
------------------------------------------------------------------------------*/
void RbInst(LONG id, HWND hWnd, WCHAR *pStr)
{
	DWORD styleRb  = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU;  // WS_THICKFRAME ֎~
	DWORD stylePd  = WS_CHILD|WS_VISIBLE|WS_CLIPCHILDREN;
	DWORD stylePc  = WS_CHILD|WS_VISIBLE;
	DWORD styleEd1 = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_LEFT  |ES_AUTOHSCROLL;
	DWORD styleEd2 = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD stylePv  = WS_CHILD|WS_VISIBLE;
	
	rb[id].rgb = _wtor(pStr);
	
	rb[id].hWnd     = a_CreateWindow(NM_RGB,   TxTl(E_TTLRGB),styleRb, 0,  0,  0,  0, hWnd);
	rb[id].hPd[0]   = a_CreateWindow(NM_RGBPD, NULL,          stylePd, 0,  0,  0,  0, rb[id].hWnd);
	rb[id].hPd[1]   = a_CreateWindow(NM_RGBPD, NULL,          stylePd, 0,  0,  0,  0, rb[id].hWnd);
	rb[id].hPd[2]   = a_CreateWindow(NM_RGBPD, NULL,          stylePd, 0,  0,  0,  0, rb[id].hWnd);
	rb[id].hPc      = a_CreateWindow(NM_RGBPC, NULL,          stylePc, 0,  0,  0,  0, rb[id].hPd[0]);
	rb[id].hEdit[0] = a_CreateWindow(L"Edit",  rb[id].path,   styleEd1,10, 20, 300,20,rb[id].hPd[1]);
	rb[id].hBtn[0]  = a_CreateWindow(L"Button",L"browse",     styleBt, 320,17, 70, 25,rb[id].hPd[1]);
	rb[id].hPv      = a_CreateWindow(NM_RGBPV, NULL,          stylePc, 8,  10, 78, 70,rb[id].hPd[2]);
	rb[id].hEdit[1] = a_CreateWindow(L"Edit",  pStr,          styleEd2,8,  90, 78, 17,rb[id].hPd[2]);
	rb[id].hBtn[1]  = a_CreateWindow(L"Button",L"OK",         styleBt, 13, 120,70, 25,rb[id].hPd[2]);
	
	SetWindowLong(rb[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(rb[id].hPd[0],   GWL_USERDATA, 0*100+id);
	SetWindowLong(rb[id].hPd[1],   GWL_USERDATA, 1*100+id);
	SetWindowLong(rb[id].hPd[2],   GWL_USERDATA, 2*100+id);
	SetWindowLong(rb[id].hEdit[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(rb[id].hEdit[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(rb[id].hBtn[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(rb[id].hBtn[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(rb[id].hPv,      GWL_USERDATA, id);
	SetWindowLong(rb[id].hPc,      GWL_USERDATA, id);
	
	SetWindowLong(rb[id].hWnd,   GWL_WNDPROC, (LONG)RbWndProc);
	SetWindowLong(rb[id].hPd[0], GWL_WNDPROC, (LONG)RbWndProcPd);
	SetWindowLong(rb[id].hPd[1], GWL_WNDPROC, (LONG)RbWndProcPd);
	SetWindowLong(rb[id].hPd[2], GWL_WNDPROC, (LONG)RbWndProcPd);
	SetWindowLong(rb[id].hPc,    GWL_WNDPROC, (LONG)RbWndProcPc);
	SetWindowLong(rb[id].hPv,    GWL_WNDPROC, (LONG)RbWndProcPv);
	
	EnableWindow(rb[id].hEdit[0], FALSE);
	E_SETLIMITTEXT(rb[id].hEdit[1], 6);
	
	E_SETFONT(rb[id].hEdit[0], hFtArial14);
	E_SETFONT(rb[id].hEdit[1], hFtCourier);
	B_SETFONT(rb[id].hBtn[0],  hFtArial14);
	B_SETFONT(rb[id].hBtn[1],  hFtArial14);
	
	rb[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(rb[id].hEdit[0], GWL_WNDPROC);
	rb[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(rb[id].hEdit[1], GWL_WNDPROC);
	rb[id].pCallBtn[0]  = (CALLFUNC)GetWindowLong(rb[id].hBtn[0],  GWL_WNDPROC);
	rb[id].pCallBtn[1]  = (CALLFUNC)GetWindowLong(rb[id].hBtn[1],  GWL_WNDPROC);
	SetWindowLong(rb[id].hEdit[0], GWL_WNDPROC, (LONG)RbWndProcEditF);
	SetWindowLong(rb[id].hEdit[1], GWL_WNDPROC, (LONG)RbWndProcEditP);
	SetWindowLong(rb[id].hBtn[0],  GWL_WNDPROC, (LONG)RbWndProcBtnF);
	SetWindowLong(rb[id].hBtn[1],  GWL_WNDPROC, (LONG)RbWndProcBtnP);
	
	rb[id].tabStopIdx = 1;
	rb[id].tabStops[0] = rb[id].hBtn [0];
	rb[id].tabStops[1] = rb[id].hEdit[1];
	rb[id].tabStops[2] = rb[id].hBtn [1];
	
	SetFocus  (rb[id].hEdit[1]);
	EditSelAll(rb[id].hEdit[1]);
}

/*------------------------------------------------------------------------------
    Fvoid RbDialog(LONG, WCHAR *, HWND, HWND, HWND)
    FLONG     FORM ID
          WCHAR *  -
          HWND     -
          HWND     -
          HWND     -
    @\F_CAO
------------------------------------------------------------------------------*/
void RbDialog(LONG id, WCHAR *pStr, HWND hWnd, HWND hWndEd, HWND hWndRb)
{
	RECT rc;
	
	RbInit(id);
	RbLoad(id);
	RbInst(id, hWnd, pStr);
	
	RbImageRead(id);
	GetWindowRect(hWndRb, &rc);
	RbPlacement(id, hWnd, rc.right, rc.top);
	
	EnableWindow(hWnd, FALSE);
	rb[id].hBack     = hWnd;
	rb[id].hBackEdit = hWndEd;
	fm[id].hModal    = rb[id].hWnd;
	
	MessageLoop();
	
	USER(hWnd, WMU_RGBEND);
}

/*------------------------------------------------------------------------------
    Fvoid RbLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void RbLoad(LONG id)
{
	wcscpy(rb[id].path, g_rbPath);
}

/*------------------------------------------------------------------------------
    Fvoid RbStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void RbStore(LONG id)
{
	wcscpy(g_rbPath, rb[id].path);
}

/*------------------------------------------------------------------------------
    Fvoid RbBoxPaint(LONG, HWND)
    FLONG    FORM ID
          HWND    -
    @\FRGBBOX`
------------------------------------------------------------------------------*/
void RbBoxPaint(LONG id, HWND hWnd)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 w;
	INT32 h;
	HBRUSH hBr[4];
	
	hdc = BeginPaint(hWnd, &ps);
	
	GetClientRect(hWnd, &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	
	if (hWnd != GetFocus()) {
		hBr[0] = hBrRed;
		hBr[1] = hBrGreen;
		hBr[2] = hBrBlue;
		hBr[3] = hBrBlack;
	}
	else {
		hBr[0] = hBrWhite;
		hBr[1] = hBrMagenta;
		hBr[2] = hBrYellow;
		hBr[3] = hBrCyan;
	}
	
	SelectObject(hdc, hBr[0]);
	PatBlt(hdc, 0,   0,   w/2,   h/2,   PATCOPY);
	SelectObject(hdc, hBr[1]);
	PatBlt(hdc, w/2, 0,   w-w/2, h/2,   PATCOPY);
	SelectObject(hdc, hBr[2]);
	PatBlt(hdc, 0,   h/2, w/2,   h-h/2, PATCOPY);
	SelectObject(hdc, hBr[3]);
	PatBlt(hdc, w/2, h/2, w-w/2, h-h/2, PATCOPY);
	
	EndPaint(hWnd, &ps);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RbWndProc(,,,)
    F-
    ߒlF-
    @\FRGBCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RbWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:  RbSetFocus(id, wp, lp);  break;
	case WM_SIZE:      RbSize    (id, wp, lp);  break;
	case WM_CLOSE:     RbClose   (id, wp, lp);  break;
	case WM_DESTROY:   RbDestroy (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RbWndProcPd(,,,)
    F-
    ߒlF-
    @\FPDCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RbWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idP;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:  RbPdCommand(id, idP, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RbWndProcEditF(,,,)
    F-
    ߒlF-
    @\FEDIT FCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RbWndProcEditF(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG idE;
	LONG id;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  RbEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   RbKeyDown   (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (RbEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default: break;
	}
	return rb[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RbWndProcEditP(,,,)
    F-
    ߒlF-
    @\FEDIT PCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RbWndProcEditP(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  RbEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   RbKeyDown   (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (RbEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default: break;
	}
	return rb[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RbWndProcBtnF(,,,)
    F-
    ߒlF-
    @\FBTN FCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RbWndProcBtnF(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS: RbEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:  RbKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return rb[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RbWndProcBtnP(,,,)
    F-
    ߒlF-
    @\FBTN PCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RbWndProcBtnP(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS: RbEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:  RbKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return rb[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RbWndProcPc(,,,)
    F-
    ߒlF-
    @\FPCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RbWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        RbPcPaint      (id, wp, lp);  break;
	case WM_LBUTTONDOWN:  RbPcLButtonDown(id, wp, lp);  break;
	case WM_LBUTTONUP:    RbPcLButtonUp  (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RbWndProcPv(,,,)
    F-
    ߒlF-
    @\FPVCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RbWndProcPv(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:  RbPvPaint(id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid RbSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FRGB WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void RbSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(rb[id].tabStops[rb[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid RbSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FRGB WM_SIZECxg
------------------------------------------------------------------------------*/
void RbSize(LONG id, WPARAM wp, LPARAM lp)
{
	// NɂP񂾂BEBhE̓TCYƓOjOjSjSjB
	// EBhEƂ@\ȂBeEBhEƎqEBhEB
	RbSizePd1(id);
	RbSizePd2(id);
	RbSizePd3(id);
}

/*------------------------------------------------------------------------------
    Fvoid RbSizePd1(LONG)
    FLONG    FORM ID
    @\FPD1 WM_SIZECxg
------------------------------------------------------------------------------*/
void RbSizePd1(LONG id)
{
	a_SetWindowPos(rb[id].hPd[0], PADD8,
								  PADD8,
								  SZ_WRGBCOLOR,
								  SZ_HRGBCOLOR);
	
	RbImageView(id);
	a_SetWindowPos(rb[id].hPc, rb[id].pc.x, rb[id].pc.y,
								  rb[id].pc.w, rb[id].pc.h);
	InvalidateRect(rb[id].hPd[0], NULL, TRUE);
	InvalidateRect(rb[id].hPc, NULL, FALSE);
	UpdateWindow  (rb[id].hPd[0]);
	UpdateWindow  (rb[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid RbSizePd2(LONG)
    FLONG    FORM ID
    @\FPD2 WM_SIZECxg
------------------------------------------------------------------------------*/
void RbSizePd2(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(rb[id].hWnd, &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	
	a_SetWindowPos(rb[id].hPd[1], PADD8,
									 h - SZ_RGBBOTTOM+PADD8,
									 w           -PADD8*2,
									 SZ_RGBBOTTOM-PADD8*2);
	InvalidateRect(rb[id].hPd[1], NULL, TRUE);
	UpdateWindow  (rb[id].hPd[1]);
}

/*------------------------------------------------------------------------------
    Fvoid RbSizePd3(LONG)
    FLONG    FORM ID
    @\FPD3 WM_SIZECxg
------------------------------------------------------------------------------*/
void RbSizePd3(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(rb[id].hWnd, &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	
	a_SetWindowPos(rb[id].hPd[2], w-SZ_RGBRIGHT+PADD8,
									 PADD8,
									 SZ_RGBRIGHT   -PADD8*2,
									 h-SZ_RGBBOTTOM-PADD8);
	UpdateWindow  (rb[id].hPd[2]);
	InvalidateRect(rb[id].hPd[2], NULL, TRUE);
}

/*------------------------------------------------------------------------------
    Fvoid RbKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGB WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void RbKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  RbKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    RbKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    RbKeyDownTab  (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid RbKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGB [enter]L[Cxg
------------------------------------------------------------------------------*/
void RbKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == rb[id].hBtn[0]) {RbEnterBrs(id);}
	else                        {RbEnterOk (id);}
}

/*------------------------------------------------------------------------------
    Fvoid RbKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGB [esc]L[Cxg
------------------------------------------------------------------------------*/
void RbKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(rb[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid RbKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGB [tab]L[Cxg
------------------------------------------------------------------------------*/
void RbKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (rb[id].tabStopIdx == 0) {rb[id].tabStopIdx = TBSP_RGB-1;}
		else                        {rb[id].tabStopIdx--;}
	}
	else {
		rb[id].tabStopIdx = (rb[id].tabStopIdx + 1) % TBSP_RGB;
	}
	SetFocus(rb[id].tabStops[rb[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid RbClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FRGB WM_CLOSECxg
------------------------------------------------------------------------------*/
void RbClose(LONG id, WPARAM wp, LPARAM lp)
{
	RbImageDelete(id);
	EnableWindow(rb[id].hBack, TRUE);
	SetForegroundWindow(rb[id].hBack);
	fm[id].hModal = rb[id].hBack;
	rb[id].hBack = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid RbDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FRGB WM_DESTROYCxg
------------------------------------------------------------------------------*/
void RbDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid RbPdCommand(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM    ID
          LONG    PADDING ID
          WPARAM  -
          LPARAM  -
    @\FPD WM_COMMANDCxg
------------------------------------------------------------------------------*/
void RbPdCommand(LONG id, LONG idP, WPARAM wp, LPARAM lp)
{
	COLORREF rgb;
	WCHAR str[6+1];
	
	if (HIWORD(wp) == BN_CLICKED) {
		if      ((HWND)lp == rb[id].hBtn[0]) {RbEnterBrs(id);}
		else if ((HWND)lp == rb[id].hBtn[1]) {RbEnterOk (id);}
	}
	else if (HIWORD(wp) == EN_CHANGE) {
		if ((HWND)lp == rb[id].hEdit[1]) {
			GetWindowText(rb[id].hEdit[1], str, 6+1);
			rgb = _wtor(str);
			rb[id].rgb = rgb;
			InvalidateRect(rb[id].hPv, NULL, FALSE);
			UpdateWindow  (rb[id].hPv);
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid RbEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FEDIT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void RbEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_RGB; i++) {
		if (hWnd == rb[id].tabStops[i]) {
			rb[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    FBOOL RbEdChar(LONG, WPARAM, LPARAM, HWND )
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    ߒlFBOOL    -
    @\FRGB WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL RbEdChar(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == rb[id].hEdit[1]) {
		if (((0x30 <= wp) && (wp <= 0x39)) ||  // 0-9
			((0x41 <= wp) && (wp <= 0x46)) ||  // a-f
			((0x61 <= wp) && (wp <= 0x66)))    // A-F
		{
			return TRUE;
		}
	}
	
	switch (wp) {
	case 0x03:  // ctrl+C
	case 0x08:  // back space
	case 0x16:  // ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid RbBtSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FBUTTON WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void RbBtSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_RGB; i++) {
		if (hWnd == rb[id].tabStops[i]) {
			rb[id].tabStopIdx = i;
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid RbPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_PAINTCxg
------------------------------------------------------------------------------*/
void RbPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 w;
	INT32 h;
	
//	if (!IsBit(rb[id].pc.img.stat, BIT_SUCCESS)) {return;}
	
	hdc = BeginPaint(rb[id].hPc, &ps);
	GetClientRect(rb[id].hPc, &rc);
	SetClipRgn(hdc, &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	
	SetStretchBltMode(hdc, HALFTONE);
	StretchBlt(hdc,                  0, 0, w, h,
			   rb[id].pc.img.hdc, 0, 0, rb[id].pc.img.w, rb[id].pc.img.h, SRCCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w;
	rc.bottom = h;
	FrameRect(hdc, &rc, hBrGray);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(rb[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid RbPcLButtonDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPICT WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void RbPcLButtonDown(LONG id, WPARAM wp, LPARAM lp)
{
	rb[id].flgClick = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid RbPcLButtonUp(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPICT WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void RbPcLButtonUp(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	POINT pt;
	COLORREF rgb;
	WCHAR str[6+1];
	
	if (rb[id].flgClick == FALSE) {return;}
	rb[id].flgClick = FALSE;
	
	hdc = GetDC(NULL);
	GetCursorPos(&pt);
	rgb = GetPixel(hdc, pt.x, pt.y);
	
	_rtow(rgb, str);
	SetWindowText(rb[id].hEdit[1], str);
	SetFocus  (rb[id].hEdit[1]);
	EditSelAll(rb[id].hEdit[1]);
	
	rb[id].rgb = rgb;
	InvalidateRect(rb[id].hPv, NULL, FALSE);
	UpdateWindow  (rb[id].hPv);
}

/*------------------------------------------------------------------------------
    Fvoid RbPvPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPV WM_PAINTCxg
------------------------------------------------------------------------------*/
void RbPvPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 w;
	INT32 h;
	HBRUSH hBr;
	
	hdc = BeginPaint(rb[id].hPv, &ps);
	GetClientRect(rb[id].hPv, &rc);
	w = rc.right-rc.left;
	h = rc.bottom-rc.top;
	SetClipRgn(hdc, &rc);
	
	hBr = CreateSolidBrush(rb[id].rgb);
	SelectObject(hdc, hBr);
	
	PatBlt(hdc, rc.left, rc.top, w, h, PATCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w;
	rc.bottom = h;
	FrameRect(hdc, &rc, hBrGray);
	
	DeleteObject(hBr);
	SelectClipRgn(hdc, NULL);
	EndPaint(rb[id].hPv, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid RbEnterBrs(LONG)
    FLONG     FORM ID
    @\F[browse]{^s
------------------------------------------------------------------------------*/
void RbEnterBrs(LONG id)
{
	OPENFILENAME ofn;
	WCHAR path     [MAX_PATH+1];
	WCHAR pathD    [MAX_PATH];
	WCHAR pathDInit[MAX_PATH];
	WCHAR flt[60] = L"IMAGE\0*.BMP;*.PNG;*.JPG;*.JPEG;*.JFIF;*.JPE\0ALL\0*.*\0";
	
	wmemset(path, 0x0000, MAX_PATH+1);
	if (wcslen(rb[id].path) != 0) {
		wcscpy(pathD, rb[id].path);
		PathRemoveFileSpec(pathD);
	}
	else {
		GetModuleFileName(NULL, pathD, MAX_PATH);
		PathRemoveFileSpec(pathD);
	}
	
	memset(&ofn, 0x00, sizeof(OPENFILENAME));
	ofn.lStructSize     = sizeof(OPENFILENAME);
	ofn.hwndOwner       = rb[id].hWnd;
//	ofn.hInstance       = gInst;
	ofn.hInstance       = NULL;
	ofn.lpstrInitialDir = pathD;
	ofn.lpstrFile       = path;
	ofn.nMaxFile        = MAX_PATH;
	ofn.lpstrFilter     = flt;
	ofn.lpstrDefExt     = L"";
	ofn.lpstrTitle      = TxDl(E_DLGRGB);
	ofn.Flags           = OFN_FILEMUSTEXIST;
	ofn.nFilterIndex    = 1;
	
	if (GetOpenFileName(&ofn) == TRUE) {
		wcscpy(rb[id].path, path);
		
		SetWindowText(rb[id].hEdit[0], rb[id].path);
		RbImageDelete(id);
		RbImageRead(id);
		RbSizePd1(id);
		
		GetModuleFileName(NULL, pathDInit, MAX_PATH);
		PathRemoveFileSpec(pathDInit);
		SetCurrentDirectory(pathDInit);  // ŕύX邩ftHg
	}
}

/*------------------------------------------------------------------------------
    Fvoid RbEnterOk(LONG)
    FLONG     FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void RbEnterOk(LONG id)
{
	WCHAR str[6+1];
	
	GetWindowText(rb[id].hEdit[1],  str, 6+1);
	SetWindowText(rb[id].hBackEdit, str);
	CLOSE(rb[id].hWnd);
	SetFocus  (rb[id].hBackEdit);
	EditSelAll(rb[id].hBackEdit);
	
	RbStore(id);
}

/*------------------------------------------------------------------------------
    Fvoid RbPlacement(LONG, HWND, INT32, INT32)
    FLONG    FORM ID
          HWND    -
          INT32   XW
          INT32   YW
    @\FF̑I|bvAbv
------------------------------------------------------------------------------*/
void RbPlacement(LONG id, HWND hWnd, INT32 x, INT32 y)
{
	WINDOWPLACEMENT plcm;
	INT32 w;
	INT32 h;
	
	w = SZ_WRGBCOLOR+SZ_RGBRIGHT +GetSystemMetrics(SM_CXSIZEFRAME)*2;
	h = SZ_HRGBCOLOR+SZ_RGBBOTTOM+GetSystemMetrics(SM_CXSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = x;
	plcm.rcNormalPosition.top    = y;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + w;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + h;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(rb[id].hWnd, &plcm);
}

/*------------------------------------------------------------------------------
    Fvoid RbImageRead(LONG)
    FLONG    FORM ID
    @\FF̑I 摜ǂݍ
------------------------------------------------------------------------------*/
void RbImageRead(LONG id)
{
	st_Image *pImg = &rb[id].pc.img;
	Bitmap *pBmp;
	
	pBmp = Gdiplus::Bitmap::FromFile(rb[id].path);
	
	if((pBmp != NULL) && (pBmp->GetLastStatus() == Gdiplus::Ok) &&
	   (pBmp->GetWidth()  != 0) &&
	   (pBmp->GetHeight() != 0))
	{
		pImg->w = pBmp->GetWidth();
		pImg->h = pBmp->GetHeight();
		if ((pImg->w > 5000) || (pImg->h > 5000)) {
			pImg->stat = BIT_FAILURE;
			pImg->flg  = FALSE;
		}
		else {
			RbImageDraw(id, pBmp);
			pImg->stat = BIT_SUCCESS;
			pImg->flg  = TRUE;
		}
	}
	else {
		pImg->stat = BIT_FAILURE;
		pImg->flg  = FALSE;
	}
	
	delete pBmp;
}

/*------------------------------------------------------------------------------
    FBOOL RbImageDraw(LONG, Bitmap *)
    FLONG      FORM ID
          Bitmap *  -
    @\FF̑I 摜`
------------------------------------------------------------------------------*/
void RbImageDraw(LONG id, Bitmap *pBmp)
{
	st_Image *pImg = &rb[id].pc.img;
	INT32 w;
	INT32 h;
	
	w = pImg->w;
	h = pImg->h;
	
	ImageCreate(pImg, w, h);
	
	Graphics graphics(pImg->hdc);
	graphics.DrawImage(pBmp, 0, 0, w, h);
}

/*------------------------------------------------------------------------------
    Fvoid RbImageView(LONG)
    FLONG    FORM ID
    @\FF̑I \p
------------------------------------------------------------------------------*/
void RbImageView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	RECT rc;
	INT32 wPd;
	INT32 hPd;
	
	if (IsBit(rb[id].pc.img.stat, BIT_NONE|BIT_FAILURE)) {return;}
	
	GetClientRect(rb[id].hPd[0], &rc);
	wPd = rc.right - rc.left;
	hPd = rc.bottom - rc.top;
	
	TryZeroDivision(rb[id].pc.img.w);
	TryZeroDivision(rb[id].pc.img.h);
	gainW = (double)wPd / rb[id].pc.img.w;
	gainH = (double)hPd / rb[id].pc.img.h;
	
	if ((1 < gainW) && (1 < gainH)) {
		gainW = gainH = (double)1;
	}
	else {
		if (CmpGain(gainW, gainH) == TRUE) {
			limW = TRUE;
			limH = TRUE;
		}
		else {
			if (gainW < gainH) {
				gainH = gainW;
				limW = TRUE;
			}
			else {
				gainW = gainH;
				limH = TRUE;
			}
		}
	}
	
	x = (double)wPd / 2 - (double)rb[id].pc.img.w * gainW / 2;
	y = (double)hPd / 2 - (double)rb[id].pc.img.h * gainH / 2;
	w = (double)rb[id].pc.img.w * gainW;
	h = (double)rb[id].pc.img.h * gainH;
	
	if (limW == TRUE) {x = 0;  w = wPd;}
	if (limH == TRUE) {y = 0;  h = hPd;}
	
	rb[id].pc.x = x;
	rb[id].pc.y = y;
	if (w <= 0) {rb[id].pc.w = 1;}
	else        {rb[id].pc.w = w;}
	if (h <= 0) {rb[id].pc.h = 1;}
	else        {rb[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    FBOOL RbImageDelete(LONG)
    FLONG    FORM ID
    @\FF̑I 摜폜
------------------------------------------------------------------------------*/
void RbImageDelete(LONG id)
{
	ImageDeleteSt(&rb[id].pc.img);
}
