/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define SF_CPP
#include "../common.h"
//  SubFolderFTutH_

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 tabStopIdx;
	HWND tabStops[TBSP_SBF];
	
	HWND hWnd;
	HWND hEdit;
	HWND hBtn[2];
	
	LRESULT (CALLBACK *pCallEdit)   (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn[2]) (HWND,UINT,WPARAM,LPARAM);
} sf[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void SfInitClass(void);
void SfInit(LONG);
void SfInst(LONG);
void SfDialog(LONG);
LRESULT CALLBACK SfWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK SfWndProcEdit  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK SfWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK SfWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
void SfPaint       (LONG, WPARAM, LPARAM);
void SfCommand     (LONG, WPARAM, LPARAM);
void SfSetFocus    (LONG, WPARAM, LPARAM);
void SfKeyDown     (LONG, WPARAM, LPARAM, HWND);
void SfKeyDownEnter(LONG, WPARAM, LPARAM, HWND);
void SfKeyDownEsc  (LONG, WPARAM, LPARAM, HWND);
void SfKeyDownTab  (LONG, WPARAM, LPARAM, HWND);
void SfKeyDownRtLf (LONG, WPARAM, LPARAM, HWND);
void SfClose       (LONG, WPARAM, LPARAM);
void SfDestroy     (LONG, WPARAM, LPARAM);
void SfEdSetFocus  (LONG, WPARAM, LPARAM, HWND);
BOOL SfEnterOk(LONG);

/*------------------------------------------------------------------------------
    Fvoid SfInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void SfInitClass(void)
{
	WNDCLASS wcSbf;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_SBF,&wcSbf);
	
	RegisterClass(&wcSbf);
}

/*------------------------------------------------------------------------------
    Fvoid SfInit(LONG)
    FLONG    FORM ID
    @\FTutH_ 
------------------------------------------------------------------------------*/
void SfInit(LONG id)
{
	INT32 i;
	
	sf[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_SBF; i++) {sf[id].tabStops[i] = NULL;}
	
	sf[id].hWnd  = NULL;
	sf[id].hEdit = NULL;
	for (i = 0; i < 2; i++) {sf[id].hBtn[i] = NULL;}
	
	sf[id].pCallEdit = NULL;
	for (i = 0; i < 2; i++) {sf[id].pCallBtn[i] = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid SfInst(LONG)
    FLONG      FORM ID
    @\FSBF̉
------------------------------------------------------------------------------*/
void SfInst(LONG id)
{
	DWORD styleRm = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU;
	DWORD styleEd = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_LEFT|ES_AUTOHSCROLL;
	DWORD styleBt = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	
	sf[id].hWnd    = a_CreateWindow(NM_SBF,   TxTl(E_TTLSBF),styleRm,0,  0, 0,  0, fm[id].hWnd);
	sf[id].hEdit   = a_CreateWindow(L"Edit",  L"NewFolder",  styleEd,19, 20,420,20,sf[id].hWnd);
	sf[id].hBtn[0] = a_CreateWindow(L"Button",L"OK",         styleBt,289,50,70, 25,sf[id].hWnd);
	sf[id].hBtn[1] = a_CreateWindow(L"Button",L"CANCEL",     styleBt,369,50,70, 25,sf[id].hWnd);
	
	SetWindowLong(sf[id].hWnd,    GWL_USERDATA, id);
	SetWindowLong(sf[id].hEdit,   GWL_USERDATA, id);
	SetWindowLong(sf[id].hBtn[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(sf[id].hBtn[1], GWL_USERDATA, 1*100+id);
	
	SetWindowLong(sf[id].hWnd, GWL_WNDPROC, (LONG)SfWndProc);
	
	E_SETLIMITTEXT(sf[id].hEdit, 100);
	
	E_SETFONT(sf[id].hEdit,   hFtArial16);
	B_SETFONT(sf[id].hBtn[0], hFtArial14);
	B_SETFONT(sf[id].hBtn[1], hFtArial14);
	
	sf[id].pCallEdit  = (CALLFUNC)GetWindowLong(sf[id].hEdit,   GWL_WNDPROC);
	sf[id].pCallBtn[0]= (CALLFUNC)GetWindowLong(sf[id].hBtn[0], GWL_WNDPROC);
	sf[id].pCallBtn[1]= (CALLFUNC)GetWindowLong(sf[id].hBtn[1], GWL_WNDPROC);
	SetWindowLong(sf[id].hEdit,   GWL_WNDPROC, (LONG)SfWndProcEdit);
	SetWindowLong(sf[id].hBtn[0], GWL_WNDPROC, (LONG)SfWndProcBtnOk);
	SetWindowLong(sf[id].hBtn[1], GWL_WNDPROC, (LONG)SfWndProcBtnCan);
	
	sf[id].tabStopIdx = 0;
	sf[id].tabStops[0] = sf[id].hEdit;
	sf[id].tabStops[1] = sf[id].hBtn[0];
	sf[id].tabStops[2] = sf[id].hBtn[1];
	
	SetFocus  (sf[id].hEdit);
	EditSelAll(sf[id].hEdit);
}

/*------------------------------------------------------------------------------
    Fvoid SfDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void SfDialog(LONG id)
{
	WINDOWPLACEMENT plcm;
	
	SfInit(id);
	SfInst(id);
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5 + 4;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + 464;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + 121;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(sf[id].hWnd, &plcm);
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = sf[id].hWnd;
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK SfWndProc(,,,)
    F-
    ߒlF-
    @\FSBFCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK SfWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:     SfPaint   (id, wp, lp);  break;
	case WM_COMMAND:   SfCommand (id, wp, lp);  break;
	case WM_SETFOCUS:  SfSetFocus(id, wp, lp);  break;
	case WM_CLOSE:     SfClose   (id, wp, lp);  break;
	case WM_DESTROY:   SfDestroy (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK SfWndProcEdit(,,,)
    F-
    ߒlF-
    @\FSBF EDITCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK SfWndProcEdit(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:  SfEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   SfKeyDown   (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (wp == KEY_TAB)   {return 0;}
		if (wp == KEY_ENTER) {return 0;}
		break;
	default:
		break;
	}
	return sf[id].pCallEdit(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK SfWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FSBF BTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK SfWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  SfEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   SfKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	return sf[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK SfWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FSBF BTN LZ Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK SfWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  SfEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   SfKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	return sf[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid SfPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSBF WM_PAINTCxg
------------------------------------------------------------------------------*/
void SfPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	
	hdc = BeginPaint(sf[id].hWnd, &ps);
	GetClientRect(sf[id].hWnd, &rc);
	SetClipRgn(hdc, &rc);
	SelectObject(hdc, hBrWhite);
	
	PatBlt(hdc, rc.left+PADD8,
				rc.top+PADD8,
				rc.right-rc.left-PADD8*2,
				rc.bottom-rc.top-PADD8*2, PATCOPY);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(sf[id].hWnd, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid SfCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSBF WM_COMMANDCxg
------------------------------------------------------------------------------*/
void SfCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if ((HWND)lp == sf[id].hBtn[0]) {
		if (SfEnterOk(id) == TRUE) {
			CLOSE(sf[id].hWnd);
		}
	}
	else {
		CLOSE(sf[id].hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid SfSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSBF WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void SfSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(sf[id].tabStops[sf[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid SfKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSBF WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void SfKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  SfKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    SfKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    SfKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_RT:
	case KEY_LF:     SfKeyDownRtLf (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid SfKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSBF [enter]L[Cxg
------------------------------------------------------------------------------*/
void SfKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if ((hWnd == sf[id].hEdit) || (hWnd == sf[id].hBtn[0]))
	{
		if (SfEnterOk(id) == TRUE) {CLOSE(sf[id].hWnd);}
	}
	else {
		CLOSE(sf[id].hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid SfKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSBF [esc]L[Cxg
------------------------------------------------------------------------------*/
void SfKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(sf[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid SfKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSBF [tab]L[Cxg
------------------------------------------------------------------------------*/
void SfKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT8 tmp;
	BOOL shift;
	
	tmp = GetKeyState(KEY_SHIFT);
	if((tmp & 0x80)!=0){shift=TRUE;}else{shift=FALSE;}
	
	if (shift == TRUE) {
		if (sf[id].tabStopIdx == 0) {sf[id].tabStopIdx = TBSP_SBF-1;}
		else                        {sf[id].tabStopIdx--;}
	}
	else {
		sf[id].tabStopIdx = (sf[id].tabStopIdx + 1) % TBSP_SBF;
	}
	SetFocus(sf[id].tabStops[sf[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid SfKeyDownRtLf(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSBF [][]L[Cxg
------------------------------------------------------------------------------*/
void SfKeyDownRtLf(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if      ((HWND)hWnd==sf[id].hBtn[0]) {SetFocus(sf[id].hBtn[1]);}
	else if ((HWND)hWnd==sf[id].hBtn[1]) {SetFocus(sf[id].hBtn[0]);}
}

/*------------------------------------------------------------------------------
    Fvoid SfClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSBF WM_CLOSECxg
------------------------------------------------------------------------------*/
void SfClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid SfDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSBF WM_DESTROYCxg
------------------------------------------------------------------------------*/
void SfDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid SfEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSBF WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void SfEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_SBF; i++) {
		if (hWnd == sf[id].tabStops[i]) {
			sf[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    FBOOL SfEnterOk(LONG id)
    FLONG    FORM ID
    ߒlFBOOL    -
    @\FTutH_쐬s
------------------------------------------------------------------------------*/
BOOL SfEnterOk(LONG id)
{
	WCHAR text[100+1];
	WCHAR path[MAX_PATH];
	WCHAR msg [MAX_PATH+100];
	BOOL res;
	
	GetWindowText(sf[id].hEdit, text, 100+1);
	if (50 < wcslen(text))
	{MessageBox(sf[id].hWnd, L"length over", L_ERROR, MB_OK);  return FALSE;}
	
	swprintf(msg, TxFm(E_FMTSBF), fm[id].pathD, text);
	
	switch (g_idxLang) {
	case 0:  swprintf(msg, TxFm(E_FMTSBF), fm[id].pathD, text);          break;
	case 1:  swprintf(msg, TxFm(E_FMTSBF), text,         fm[id].pathD);  break;
	default: break;
	}
	
	if (MessageBox(sf[id].hWnd, msg, TxTl(E_TTLSBF), MB_OKCANCEL) != IDOK)
	{return FALSE;}
	
	wcscpy(path, fm[id].pathD);
	wcscmb(path, text);
	
	res = CreateDirectory(path, NULL);
	if (res == FALSE) {
		MessageBox(sf[id].hWnd, L"create error", L_ERROR, MB_OK);  // u:vƂ֎~
		return FALSE;
	}
	
	return TRUE;
}
