/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define SM_CPP
#include "../common.h"
//  SampleFTvO

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	HWND hWnd;
	HWND hEdit;
	HWND hPrv;
	
	LRESULT (CALLBACK *pCallEdit) (HWND,UINT,WPARAM,LPARAM);
} sm[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void SmInitClass(void);
void SmInit(LONG);
void SmInst(LONG);
void SmDialog(LONG);
LRESULT CALLBACK SmWndProc    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK SmWndProcEdit(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK SmWndProcPv  (HWND, UINT, WPARAM, LPARAM);
void SmPaint    (LONG, WPARAM, LPARAM);
void SmSetFocus (LONG, WPARAM, LPARAM);
void SmClose    (LONG, WPARAM, LPARAM);
void SmDestroy  (LONG, WPARAM, LPARAM);
BOOL SmEdChar   (LONG, WPARAM, LPARAM);
void SmEdKeyDown(LONG, WPARAM, LPARAM);
void SmPvPaint  (LONG, WPARAM, LPARAM);

/*------------------------------------------------------------------------------
    Fvoid SmInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void SmInitClass(void)
{
	WNDCLASS wcSam;
	WNDCLASS wcSamPv;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_SAM,  &wcSam);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrNull,  NM_SAMPV,&wcSamPv);
	
	RegisterClass(&wcSam);
	RegisterClass(&wcSamPv);
}

/*------------------------------------------------------------------------------
    Fvoid SmInit(LONG)
    FLONG    FORM ID
    @\FRGBl擾 
------------------------------------------------------------------------------*/
void SmInit(LONG id)
{
	sm[id].hWnd  = NULL;
	sm[id].hEdit = NULL;
	sm[id].hPrv  = NULL;
	
	sm[id].pCallEdit = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid SmInst(LONG)
    FLONG      FORM ID
    @\FSAM̉
------------------------------------------------------------------------------*/
void SmInst(LONG id)
{
	DWORD styleRg = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_CLIPCHILDREN;
	DWORD styleEd = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleSm = WS_CHILD|WS_VISIBLE|WS_BORDER;
	
	sm[id].hWnd  = a_CreateWindow(NM_SAM,   TxTl(E_TTLSAM),styleRg,0, 0, 0, 0, fm[id].hWnd);
	sm[id].hPrv  = a_CreateWindow(NM_SAMPV, L"",           styleSm,35,20,73,40,sm[id].hWnd);
	sm[id].hEdit = a_CreateWindow(L"Edit",  L"",           styleEd,35,75,73,17,sm[id].hWnd);
	SetWindowLong(sm[id].hWnd,  GWL_USERDATA, id);
	SetWindowLong(sm[id].hPrv,  GWL_USERDATA, id);
	SetWindowLong(sm[id].hEdit, GWL_USERDATA, id);
	SetWindowLong(sm[id].hWnd,  GWL_WNDPROC, (LONG)SmWndProc);
	SetWindowLong(sm[id].hPrv,  GWL_WNDPROC, (LONG)SmWndProcPv);
	
	E_SETLIMITTEXT(sm[id].hEdit, 6);
	E_SETFONT     (sm[id].hEdit, hFtCourier);
	
	sm[id].pCallEdit = (CALLFUNC)GetWindowLong(sm[id].hEdit, GWL_WNDPROC);
	SetWindowLong(sm[id].hEdit, GWL_WNDPROC, (LONG)SmWndProcEdit);
}

/*------------------------------------------------------------------------------
    Fvoid SmDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void SmDialog(LONG id)
{
	HDC hdc;
	COLORREF rgb;
	POINT pt;
	WCHAR str[6+1];
	WINDOWPLACEMENT plcm;
	
	SmInst(id);
	
	hdc = GetDC(NULL);
	GetCursorPos(&pt);
	rgb = GetPixel(hdc, pt.x, pt.y);
	ReleaseDC(NULL, hdc);
	fm[id].rgb = rgb;
	
	_rtow(rgb, str);
	SetWindowText(sm[id].hEdit, str);
	
	SetFocus  (sm[id].hEdit);
	EditSelAll(sm[id].hEdit);
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5 + 4;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + 150;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + 150;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(sm[id].hWnd, &plcm);
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = sm[id].hWnd;
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK SmWndProc(,,,)
    F-
    ߒlF-
    @\FSAMCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK SmWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:     SmPaint   (id, wp, lp);  break;
	case WM_SETFOCUS:  SmSetFocus(id, wp, lp);  break;
	case WM_CLOSE:     SmClose   (id, wp, lp);  break;
	case WM_DESTROY:   SmDestroy (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK SmWndProcEdit(,,,)
    F-
    ߒlF-
    @\FSAM EDITCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK SmWndProcEdit(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_CHAR:
		if (SmEdChar(id, wp, lp) == FALSE) {return 0;}
		break;
	case WM_KEYDOWN:  SmEdKeyDown(id, wp, lp);  break;
	default:
		break;
	}
	return sm[id].pCallEdit(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK SmWndProcPv(,,,)
    F-
    ߒlF-
    @\FSAM PRVCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK SmWndProcPv(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:  SmPvPaint(id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid SmPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSAM WM_PAINTCxg
------------------------------------------------------------------------------*/
void SmPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	
	hdc = BeginPaint(sm[id].hWnd, &ps);
	GetClientRect(sm[id].hWnd, &rc);
	SetClipRgn(hdc, &rc);
	SelectObject(hdc, hBrWhite);
	
	PatBlt(hdc, rc.left+PADD8,
				rc.top+PADD8,
				rc.right-rc.left-PADD8*2,
				rc.bottom-rc.top-PADD8*2, PATCOPY);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(sm[id].hWnd, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid SmSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSAM WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void SmSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(sm[id].hEdit);
}

/*------------------------------------------------------------------------------
    Fvoid SmClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSAM WM_CLOSECxg
------------------------------------------------------------------------------*/
void SmClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid SmDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSAM WM_DESTROYCxg
------------------------------------------------------------------------------*/
void SmDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid SmEdChar(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSAM EDIT WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL SmEdChar(LONG id, WPARAM wp, LPARAM lp)
{
	if (wp == KEY_TAB)   {return FALSE;}
	if (wp == KEY_ENTER) {return FALSE;}
	return TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid SmEdKeyDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSAM EDIT WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void SmEdKeyDown(LONG id, WPARAM wp, LPARAM lp)
{
	switch (wp) {
	case KEY_ESC:
	case KEY_ENTER:
		CLOSE(sm[id].hWnd);
		break;
	default:
		break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid SmPvPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSAM WM_PAINTCxg
------------------------------------------------------------------------------*/
void SmPvPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	HBRUSH hbr, old;
	
	hdc = BeginPaint(sm[id].hPrv, &ps);
	GetClientRect(sm[id].hPrv, &rc);
	SetClipRgn(hdc, &rc);
	
	hbr = CreateSolidBrush(fm[id].rgb);
	old = (HBRUSH)SelectObject(hdc, hbr);
	
	PatBlt(hdc, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, PATCOPY);
	
	SelectObject(hdc, old);
	DeleteObject(hbr);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(sm[id].hPrv, &ps);
}
