/** normalizetextwin.cpp
 * eLXg̐K
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + Boost C++ Libraries + MeCab
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-18-01.shtm
 * @⑫
 *	1) MeCabgpɂ MECAB `
 *
 */
//  ==============================================================
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <sstream>
#include <string>
#include <vector>
#include <locale>
#include <regex>
#include <cmath>
#include <winsock2.h>
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include <richedit.h>
#include <boost/format.hpp>
#include <boost/program_options.hpp>
#include <boost/property_tree/xml_parser.hpp>
#ifdef MECAB
	#include <mecab.h>
#endif
#include "resource.h"
#include "pahooNormalizeText.hpp"

using namespace std;
using namespace boost;
using namespace boost::program_options;
using namespace boost::property_tree;

// 萔Ȃ ==================================================================
#define MAKER		"pahoo.org"				// 쐬
#define APPNAME		"normalizetextwin"		// AvP[V
#define APPNAMEJP	"eLXg̐K"		// AvP[Vi{j
#define APPVERSION	"2.0.1"					// o[W
#define APPYEAR		"2020-25"				// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-18-01.shtm"	// QlTCg

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// ftHgۑt@C
#define SAVEFILE	"normalizetextwin.txt"

// IvVۑt@CFύXs
#define OPTIONFILE	"option.txt"

// G[EbZ[Wi[pFύXs
string ErrorMessage;

// ݂̃C^[tFCX
HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// pahooNormalizeTextIuWFNg
pahooNormalizeText* pNT;

// char*obt@TCY
#define SIZE_BUFF	5120

// ϊeLXgilj
#define DEF_SOUR	"wƐqx́AWu̒ұҰ݉fBē͋{xBZZN\\ɓ{JBs͎OS~𒴂A{㋻sʂBBp̃^Cǵwr `xB\nqƂ̏\\΂̏Az֌rɗ詓A_X̐E֖ł܂B"

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
p܂ޖp\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃CuCt[[NCAPI𗘗pĂ܂D
@MinGWig++j^Boost C++Cu^MeCab
)")
% APPNAMEJP
% APPVERSION
% APPYEAR
).str();

// CUIwv
string Help = (boost::format(R"(
%1%  o[W %2%

nmtxt.exe -IvV
        -s, --sour   eLXgt@C
        -c, --clip   Nbv{[h
        -d, --dest   eLXgt@C֏o
        -p, --paste  Nbv{[h֏o
        -o, --option KiׂĎw\jFGUIłƓp
                t@sEs̋󔒕
                T@SpƗׂ荇󔒕
                n@𔼊pɓ
                N@Spɓ
                K@ɓ
                k@(P)ɓ
                a@p𔼊pɓ
                A@pSpɓ
                y@L𔼊pɓ
                Y@LSpɓ
                h@J^Ji𔼊pɓ
                H@J^JiSpɓ
                s@ꕶ𔼊pɓ
                S@ꕶSpɓ
                F@ʎL@ɂ
                f@ʎL@ɂȂ
                c@䕶폜
                D@Spdp̊Ju
                V@\L𓝈ꂷ
                PCɕۑCNɂ͏ȗ\łD
        -v, --version o[W
        -h, --help    ICwv
)")
% APPNAMEJP
% APPVERSION).str();

// Nbv{[h֘A ======================================================
/**
 * Nbv{[hɕZbg
 * @param	string str 
 * @return	Ȃ
 */
void setClipboardData(string str) {
	char buff[str.size() + 1];
	char_traits<char>::copy(buff, str.c_str(), str.size() + 1);

	OpenClipboard(NULL);
	EmptyClipboard();

	HGLOBAL hText = GlobalAlloc(GHND | GMEM_SHARE, str.size() + 1);
	PTSTR pText = (PTSTR) GlobalLock(hText);
	lstrcpy(pText, buff);
	GlobalUnlock(hText);
	SetClipboardData(CF_TEXT, hText);
	CloseClipboard();
}

/**
 * Nbv{[h當擾
 * @param	Ȃ
 * @return	^NULL擾s
 */
char* getClipboardData(void) {
	static char buff[SIZE_BUFF + 1];

	OpenClipboard(NULL);
	HGLOBAL hText = GetClipboardData(CF_TEXT);

	if (hText == NULL) {
		return NULL;
	} else {
		PTSTR pText = (PTSTR) GlobalLock(hText);
		lstrcpy(buff, pText);
		GlobalUnlock(hText);
	}
	CloseClipboard();

	return buff;
}

#ifndef CMDAPP
// t@CǍ ========================================================
/**
 * eLXgt@Cǂݍ
 * @param	const char* fname  ǂݍރt@C
 * @return	wstring ǂݍ񂾃eLXg
*/
wstring __loadTXT(const char* fname) {
	ifstream ifs(fname);
	if (! ifs) {
		ErrorMessage = (string)fname + " ̓ǂݍ݂Ɏs܂";
	}
	string ss;
	wstring wstr = L"";
	while (getline(ifs, ss)) {
		wstr += _SW(ss) + L"\n";
	}

	return wstr;
}

/**
 * eLXgt@Cǂݍށi_CAOj
 * @param	Ȃ
 * @return	wstring ǂݍ񂾃eLXg
*/
wstring loadTXT(void) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, SAVEFILE);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("eLXgt@C(*.txt)\0*.txt\0ׂẴt@C(*.*)\0*.*\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("txt");
	// R_CAO̕\
	GetOpenFileName(&of);
	// t@Cۑ
	return __loadTXT(fname);
}

// t@Cۑ ========================================================
/**
 * ʂTXTt@Cɕۑ
 * @param	const char* fname  ۑt@C
 * @param	const wstring wstr ۑeLXg
 * @return	Ȃ
*/
void __saveTXT(const char* fname, const wstring wstr) {
	ofstream outputfile(fname);

	if (wstr != L"") {
		outputfile << _WS(wstr) << endl;
	}

	if (outputfile.bad()) {
		ErrorMessage = "eLXgt@C݃G[";
	}
	outputfile.close();
}

/**
 * ʂTXTt@Cɕۑi_CAOj
 * @param	const wstring wstr ۑeLXg
 * @return	Ȃ
*/
void saveTXT(const wstring wstr) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, SAVEFILE);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("eLXgt@C(*.txt)\0*.txt\0ׂẴt@C(*.*)\0*.*\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("txt");
	// R_CAO̕\
	GetSaveFileName(&of);
	// t@Cۑ
	__saveTXT(fname, wstr);
}

// GUI =================================================================
/**
 * eLXg{bNXɕ
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  string	s     ݒl
 * @return Ȃ
 */
void setStrEditBox(HWND hDlg, unsigned id, string s) {
	char buff[s.length() + 1];
	char_traits<char>::copy(buff, s.c_str(), s.size() + 1);
	SetDlgItemText(hDlg, id, buff);
}

/**
 * eLXg{bNX當擾
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @return string 擾
 */
string getStrEditBox(HWND hDlg, unsigned id) {
	char buff[SIZE_BUFF + 1];
	GetDlgItemText(hDlg, id, buff, SIZE_BUFF);
	return (string) buff;
}

/**
 * _CAOeEBhE̒ɔzu
 * @param	HWND hDlg		̃nh
 * @global	HWND hParent	eEBhẼnh
 * @return	Ȃ
 */
void CenterWindow(HWND hDlg) {
	int x, y;
	RECT rc;

	GetWindowRect(hParent, &rc);
	x = rc.left + (rc.right - rc.left) / 2;
	y = rc.top + (rc.bottom - rc.top) / 2;

	SetWindowPos(hDlg, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}

// IvVǍ^ۑ ====================================================
/**
 * AppDatãpX擾
 * @param	char* appname AvP[V
 * @return	string pX
 */
string getMyPath(const char* appname) {
	static TCHAR myPath[MAX_PATH] = "";

	if (strlen(myPath) == 0) {
		if (SHGetSpecialFolderPath(NULL, myPath, CSIDL_APPDATA, 0)) {
			TCHAR *ptmp = _tcsrchr(myPath, _T('\\'));
			if (ptmp != NULL) {
				ptmp = _tcsinc(ptmp);
				*ptmp = _T('\0');
			}
			strcat(myPath, _T("Roaming"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\pahoo.org"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
			strcat(myPath, _T(appname));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
		} else {
		}
	}
	return (string)myPath;
}

/**
 * IvV̏
 * @param	Ȃ
 * @return	string IvVilj
 */
string initOption(void) {
	hParent_X	= 0;
	hParent_Y	= 0;

	return OPTION_INIT;
}

/**
 * IvV̓ǂݍ
 * @param	Ȃ
 * @return	string IvV
 */
string loadOption(void) {
	ptree pt;

	// lݒ
	string option = initOption();

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (optional<string>str = pt.get_optional<string>("parameter")) {
			} else {
				return OPTION_INIT;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "option") {
					option =(string)it.second.data();
				} else if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			return initOption();
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		return initOption();
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}

	return option;
}

/**
 * IvV̕ۑ
 * @param	string option IvV
 * @return	Ȃ
 */
void saveOption(string option) {
#ifndef CMDAPP
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
#endif

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", option);
	child1.add("<xmlattr>.type", "option");
	ptree& child2 = pt.add("parameter.param", (string)to_string(hParent_X));
	child2.add("<xmlattr>.type", "wx");
	ptree& child3 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child3.add("<xmlattr>.type", "wy");

//	clog << "option=" << option << endl;

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

/**
 * IvV̓ǂݍ
 * @param	Ȃ
 * @return	string IvV
 */
string loadOption2(void) {
	string option = OPTION_INIT;

	string fname = (string)getMyPath(APPNAME) + OPTIONFILE;
	ifstream ifs(fname);
	if (! ifs) {
		ErrorMessage = (string)fname + " ̓ǂݍ݂Ɏs܂";
		return option;
	}
	getline(ifs, option);
	ifs.close();

	return option;

}

/**
 * IvV̕ۑ
 * @param	string option IvV
 * @return	Ȃ
 */
void saveOption2(string option) {
	string fname = (string)getMyPath(APPNAME) + OPTIONFILE;
	ofstream ofs(fname);
	ofs << option;

	if (ofs.bad()) {
		ErrorMessage = (string)fname + " ݂̏Ɏs܂";
		clog << ErrorMessage << endl;
	}
	ofs.close();
}

/**
 * IvV̍폜
 * @param	Ȃ
 * @return	Ȃ
 */
void delOption(void) {
	remove((getMyPath(APPNAME) + APPNAME + ".xml").c_str());

	// lݒ
	initOption();
}

// IvV擾Eݒ ======================================================
/**
 * KIvVݒ肷
 * @param	HWND hDlg	EBhEEnh
 * @param	string opt	KIvV
 * @return	Ȃ
 */
void setOption(HWND hDlg, string opt) {
	for (int i = 0; i < (int)opt.length(); i++) {
		char* ch = (char*)opt.substr(i, 1).c_str();
		switch (*ch) {
		case OPTION_ALP_HAN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ALP_HAN),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ALP_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_ALP_ZEN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ALP_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ALP_ZEN),
							BM_SETCHECK, BST_CHECKED,   0);
			break;
		case OPTION_NUM_HAN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_HAN),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_KAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_KAN2),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_NUM_ZEN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_ZEN),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_KAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_KAN2),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_NUM_KAN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_KAN),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_KAN2),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_NUM_KAN2:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_KAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_KAN2),
							BM_SETCHECK, BST_CHECKED,   0);
			break;
		case OPTION_NUM_SCALE:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_SCALE),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_NOSCALE),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_NUM_NOSCALE:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_SCALE),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_NOSCALE),
							BM_SETCHECK, BST_CHECKED,   0);
			break;
		case OPTION_YAK_HAN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_YAK_HAN),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_YAK_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_YAK_ZEN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_YAK_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_YAK_ZEN),
							BM_SETCHECK, BST_CHECKED,   0);
			break;
		case OPTION_KANA_HAN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_KANA_HAN),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_KANA_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_KANA_ZEN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_KANA_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_KANA_ZEN),
							BM_SETCHECK, BST_CHECKED,   0);
			break;
		case OPTION_SPEC_HAN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SPEC_HAN),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SPEC_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_SPEC_ZEN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SPEC_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SPEC_ZEN),
							BM_SETCHECK, BST_CHECKED,   0);
			break;
		case OPTION_CONTROL_DEL:
			SendMessage(GetDlgItem(hDlg, IDC_CHECK_CONTROL_DEL),
							BM_SETCHECK, BST_CHECKED, 0);
			break;
		case OPTION_DBL_QUOTE:
			SendMessage(GetDlgItem(hDlg, IDC_CHECK_DBL_QUOTE),
							BM_SETCHECK, BST_CHECKED, 0);
			break;
		case OPTION_VARIABLE:
			SendMessage(GetDlgItem(hDlg, IDC_CHECK_VARIABLE),
							BM_SETCHECK, BST_CHECKED, 0);
			break;
		default:
			break;
		}
	}
}

/**
 * KIvV擾
 * @param	HWND hDlg	EBhEEnh
 * @return	string KIvV
 */
string getOption(HWND hDlg) {
	string opt = "";
	if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_ALP_HAN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_ALP_HAN;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_ALP_ZEN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_ALP_ZEN;
	}
	if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_HAN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_NUM_HAN;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_ZEN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_NUM_ZEN;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_KAN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_NUM_KAN;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_KAN2), BM_GETCHECK, 0, 0)) {
		opt += OPTION_NUM_KAN2;
	}
	if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_SCALE), BM_GETCHECK, 0, 0)) {
		opt += OPTION_NUM_SCALE;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_NUM_NOSCALE), BM_GETCHECK, 0, 0)) {
		opt += OPTION_NUM_NOSCALE;
	}
	if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_YAK_HAN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_YAK_HAN;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_YAK_ZEN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_YAK_ZEN;
	}
	if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_KANA_HAN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_KANA_HAN;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_KANA_ZEN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_KANA_ZEN;
	}
	if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_SPEC_HAN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_SPEC_HAN;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_SPEC_ZEN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_SPEC_ZEN;
	}
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_CONTROL_DEL), BM_GETCHECK, 0, 0)) {
		opt += OPTION_CONTROL_DEL;
	}
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_DBL_QUOTE), BM_GETCHECK, 0, 0)) {
		opt += OPTION_DBL_QUOTE;
	}
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_VARIABLE), BM_GETCHECK, 0, 0)) {
		opt += OPTION_VARIABLE;
	}

	return opt;
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg			EBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
 */
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg,
					WPARAM wParam, LPARAM lParam) {
	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
		setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
		break;

	// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// s
		case IDC_BUTTON_OK:
			EndDialog(hDlg, 0);
			break;
		default:
			return 1;
		}
		break;
	// vOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
	return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
 */
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC) handler);
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
 */
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	HICON hIcon;
	static string option = OPTION_INIT;
	static wstring wsour, wdest;

	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		hParent = hDlg;
		hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON,
				16, 16, 0);
		SendMessage(hParent, WM_SETICON, ICON_SMALL, (LPARAM) hIcon);
		ErrorMessage = "";
		// IvVǂݍ
		option = loadOption();
		setStrEditBox(hDlg, IDC_EDIT_SOUR, DEF_SOUR);
		setOption(hDlg, option);
		// AvP[VEEBhEړ
		SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));
#ifdef MECAB
		if (pNT->isError()) {
			string errmsg = _WS(pNT->getError());
			MessageBox(hParent, (LPCSTR)errmsg.c_str(), TEXT("G["), MB_OK | MB_ICONERROR);
			EndDialog(hParent, 0);
			return 0;
		}
#endif
		break;

	// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// ϊ
		case IDC_BUTTON_EXEC:
		case IDM_EXEC:
			// KIvV擾
			option = getOption(hDlg);
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			// Ks
			wsour = _SW(getStrEditBox(hDlg, IDC_EDIT_SOUR));
			wdest = pNT->normalizeText(wsour, option.c_str(), FALSE);
			setStrEditBox(hDlg, IDC_EDIT_DEST, _WS(wdest));
			break;
		// J
		case IDM_OPEN:
			wsour = loadTXT();
			setStrEditBox(hDlg, IDC_EDIT_SOUR, _WS(wsour));
			break;
		// Zbg
		case IDC_BUTTON_RESET:
		case IDM_RESET:
			setStrEditBox(hDlg, IDC_EDIT_SOUR, "");
			break;
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			saveTXT(wdest);
			break;
		// ݒNA{AvI
		case IDM_CLEAR_PARAMETER:
			delOption();
			EndDialog(hParent, 0);
			return 0;
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hParent, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hParent, processHelp);
			break;
		// TCg
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// Rs[
		case IDM_COPY:
		case IDC_BUTTON_COPY:
			setClipboardData(getStrEditBox(hDlg, IDC_EDIT_DEST));
			break;
		// ؂
		case IDM_DELETE:
			setStrEditBox(hParent, IDC_EDIT_SOUR, "");
			setStrEditBox(hParent, IDC_EDIT_DEST, "");
			break;
		// vOI
		case IDM_QUIT:
			// IvVۑ
			option = getOption(hDlg);
			saveOption(option);
			EndDialog(hParent, 0);
			return 0;
		default:
			return 0;
		}
		break;

	// vOI
	case WM_CLOSE:
		// IvVۑ
		option = getOption(hDlg);
		saveOption(option);
		EndDialog(hParent, 0);
		return 0;
	}
	return 0;
}

// GUICvO ======================================================
/**
 * GUIpCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
 */
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");
	hInst = hInstance;

	// pahooNormalizeTextIuWFNg
	pNT = new pahooNormalizeText();

	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);

	// IuWFNg
	delete pNT;

	return 0;
}

#else
// CUICvO ======================================================
/**
 * CUIpCvO
 * @param	int argc
 * @paramm	char* argv[]
 * @return	int ^[R[h
 */
int main(int argc, char* argv[]) {
	wstring wsour = L"";
	wstring wdest = L"";
	string sour = "";

	// KIvV̏l
	string lopt = OPTION_INIT;

	// pahooNormalizeTextIuWFNg
	pNT = new pahooNormalizeText();

	// MeCab`FbN
#ifdef MECAB
	if (pNT->isError()) {
		ErrorMessage = "G[F" + _WS(pNT->getError());
		cerr << ErrorMessage << endl;
		return 1;
	}
#endif

	// R}hCEIvV̒`
	options_description options("R}hCEIvV");
	options.add_options()
		("option,o", value<std::string>()->default_value(lopt), "KIvV")
		("sour,s", value<std::string>(), "eLXgt@C")
		("clip,c", "Nbv{[h")
		("dest,d", value<std::string>(), "eLXgt@C֏o")
		("paste,p", "Nbv{[h֏o")
		("help,h", "wv")
		("version,v", "o[W")
		;
	// R}hCEIvV̎擾
	variables_map vm;
	try {
		store(parse_command_line(argc, argv, options), vm);
	} catch(const boost::program_options::error_with_option_name& e) {
		ErrorMessage =  e.what();
		cerr << ErrorMessage << endl;
		return 1;
	}
	notify(vm);

	// KIvV
	auto opt = vm["option"].as<string>();

	// wv
	if (vm.count("help")) {
		wdest = _SW(Help);
	// o[W
	} else if (vm.count("version")) {
		wdest = _SW(Version);

	// Ks
	} else {
		// ̓t@C
		wsour = _SW(DEF_SOUR);
		if (vm.count("sour")) {
			auto infile = vm["sour"].as<string>();
			ifstream ifs(infile.c_str());
			if (ifs.fail()) {
				ErrorMessage = infile + " ܂";
				cerr << ErrorMessage << endl;
				return 1;
			}
			string ss;
			while (getline(ifs, ss)) {
				sour += ss + "\r";
			}
			wsour = _SW(sour);
		// Nbv{[h
		} else if (vm.count("clip")) {
			char *ss = getClipboardData();
			sour = ss;
			wsour = _SW(sour);
		// W͂
		} else {
			cin >> sour;
			if (sour.length() > 0) {
				wsour = _SW(sour);
			}
		}
		wdest = pNT->normalizeText(wsour, opt.c_str(), FALSE);
	}

	// o̓t@C
	if (vm.count("dest")) {
		// sR[hu
		wregex re(_SW("\r"));
		wdest = regex_replace(wdest, re, _SW("\n"));
		auto outfile = vm["dest"].as<string>();
		ofstream ofs(outfile.c_str());
		ofs << _WS(wdest);
		if (ofs.bad()) {
			ErrorMessage = outfile + " ւ݂̏Ɏs܂";
			cerr << ErrorMessage << endl;
			return 1;
		}
		ofs.close();
	// Nbv{[h
	} else if (vm.count("paste")) {
		// sR[hu
		wregex re(_SW("\r"));
		wdest = regex_replace(wdest, re, _SW("\n"));
		setClipboardData(_WS(wdest));
	// Wo͂
	} else {
		// sR[hu
		wregex re(_SW("\r"));
		wdest = regex_replace(wdest, re, _SW("\n"));
		clog << _WS(wdest);
	}

	// IuWFNg
	delete pNT;

	return 0;
}

#endif

/*
 ** o[WAbv =====================================================
 *
 * @version 2.0.1  2025/11/23 MeCab[U[XVCgpCuXV
 * @version 2.0.0  2025/08/30 \Lꓝ@\ǉ
 * @version 1.9.5  2025/08/02 MeCab[U[XVCgpCuXV
 * @version 1.9.4  2025/03/29 MeCab[U[XVCgpCuXV
 * @version 1.9.3  2024/12/15 MeCab[U[XVCgpCuXV
 * @version 1.9.2  2024/08/24 MeCab[U[XVCgpCuXV
 * @version 1.9.1  2024/04/07 MeCab[U[XVCgpCuXV
 * @version 1.9.0  2023/10/25 Spdp̊Juǉ
 * @version 1.8.5  2023/10/25 MeCab`FbN@\ǉ
 * @version 1.8.4  2023/10/25 ݒNA@\ǉCCuXVCXV
 * @version 1.8.3  2023/07/30 CuXVCsC
 * @version 1.8.2  2023/04/08 Sp̑Ő󔒍폜ǁC[U[XV
 * @version 1.8.1  2022/10/10 CuC[U[XV
 * @version 1.8    2022/07/18 tgGhu@\ǉCsaveOption() C
 * @version 1.7    2022/04/29 CUIł --clip, --paste IvVǉ
 * @version 1.61   2022/05/05 MeCab[U[XV
 * @version 1.6    2022/04/29 䕶폜@\ǉ
 * @version 1.51   2022/02/19 bug-fix
 * @version 1.5    2022/01/03 1.3̑΍iɂĉ悤ɕύX
 * @version 1.4    2021/12/05 EBhEʒuۑ
 * @version 1.3    2021/11/06 uꗥvu疜vȂǕ΍
 * @version 1.2    2021/02/03 sĂLނǉ
 * @version 1.1    2020/11/15 (P)CKIvVǍ^ۑ@\ǉ
 * @version 1.01   2020/11/03 getStrEditBox() obt@10{ɑ
 * @version 1.0    2020/10/31 
 */
