/** searchoutletwin.cpp
 * dEWi-Fip\X܂
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @J	MinGW C++ + cURL + OpenSSL + Boost C++ Libraries
 *					+ WebView2Loader.dll + Leaflet + OSM (+ GoogleMap)
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-17-01.shtm
 */
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <sstream>
#include <string>
#include <locale>
#include <regex>
#include <winsock2.h>
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include <objbase.h>
#include <wrl.h>
#include <richedit.h>

#include <curl/curl.h>
#include <boost/format.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/property_tree/json_parser.hpp>
#include <boost/algorithm/string.hpp>
#include "mystrings.h"
#include "apikey.h"
#include "WebView2.h"
#include "pahooWebView2.hpp"
#include "pahooGeocode.hpp"
#include "resource.h"

using namespace std;
using namespace boost;
using namespace boost::property_tree;

// 萔Ȃ ==================================================================
#define MAKER		"pahoo.org"			// 쐬
#define APPNAME		"searchoutletwin"	// AvP[V
#define APPNAMEJP	"dEWi-Fip\\X܂"	// AvP[Vi{j
#define APPVERSION	"2.2.2"				// o[W
#define APPYEAR		"2020-25"			// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-17-01.shtm"	// QlTCg

// ListViewItem̍ő啶FύXs
#define MAX_LISTVIEWITEM	259

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// ftHgۑt@C
#define SAVEFILE	"stationsearchwin.csv"

// }bvID
#define MAP_ID			"map_id"
// n}̑傫
#define MAP_WIDTH		550		// n}̕isNZj
#define MAP_HEIGHT		320		// n}̍isNZj
// oxEܓxilj
#define DEF_LONGITUDE	139.766667
double Longitude = DEF_LONGITUDE;
#define DEF_LATITUDE	35.681111
double Latitude  = DEF_LATITUDE;
// n}g嗦ilj
#define DEF_ZOOM	13
int Zoom = DEF_ZOOM;
// n}̎ށilj
#define DEF_MAPTYPE		"GSISTD"
string Maptype = DEF_MAPTYPE;

// ݂̃C^[tFCX
HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// WebView2EBhE
HWND hWebView2;

// ICoreWebView2FpahooWebView2.cpp Œ`D
extern ICoreWebView2* webView2;

// e|t@C
char tmpFname[MAX_PATH + 1];
wchar_t wUri[MAX_PATH * 2 + 1];

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// L[i[ϐ
string Query;

// G[EbZ[Wi[pyύXsz
string ErrorMessage;

// UserAgent
string UserAgent;

// pahooGeocodeIuWFNg
pahooGeocode* pGC;

// WebView2nh̓w肷DyύXsz
enum class eAction {
	GetLatLong,				// ܓxEox擾ăuEU\
	GetZoomType,			// g嗦E}bv^Cv擾ăuEU\
	GetLatLongZoomType,		// ܓxEoxEg嗦E}bv^Cv擾ăuEU\
	Finish					// vOI
};
eAction selectAction;

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
lł̖p\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD
CoC[YIAVXAPI̋Kɂ菤pp͂ł܂D

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂DWebAPI̕ύXE~ɂĐɋ@\ȂȂꍇ܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃CuCt[[NCAPI𗘗pĂ܂D
@MinGWig++j^Boost C++Cu^libcurl^OpenSSL+^
@WebView2Loader.dll^Leaflet^OpenStreetMap^Google}bv^
@oC[YIAVXAPI^Google Geocoding API^
@YOLPRecWIR[_API^HeartRails GeoAPI
)")
% APPNAMEJP
% APPVERSION
% APPYEAR
).str();

// TuEvO =====================================================
/**
 * p[^̏
 * @param	Ȃ
 * @return	Ȃ
 */
void initParameter(void) {
	Query     = "";
	Longitude = DEF_LONGITUDE;
	Latitude  = DEF_LATITUDE;
	Zoom      = DEF_ZOOM;
	Maptype   = DEF_MAPTYPE;
	hParent_X = 0;
	hParent_Y = 0;
}

/**
 * p[^̓ǂݍ
 * @param	Ȃ
 * @return	Ȃ
 */
void loadParameter(void) {
	ptree pt;

	// lݒ
	initParameter();

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (optional<string>str = pt.get_optional<string>("parameter")) {
			} else {
				return;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "latitude") {
					Latitude = stod(it.second.data());
				} else if (type == "longitude") {
					Longitude = stod(it.second.data());
				} else if (type == "zoom") {
					Zoom = stoi(it.second.data());
				} else if (type == "maptype") {
					Maptype = (string)it.second.data();
				} else if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				} else if (type == "query") {
					Query = utf8_sjis((string)it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			initParameter();
			return;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		initParameter();
		return;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
}

/**
 * p[^̕ۑ
 * @param	Ȃ
 * @return	Ȃ
 */
void saveParameter(void) {
#ifndef CMDAPP
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
#endif

	char lng[SIZE_BUFF + 1], lat[SIZE_BUFF + 1];
	snprintf(lng, SIZE_BUFF, "%.5f", Longitude);
	snprintf(lat, SIZE_BUFF, "%.5f", Latitude);

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", lat);
	child1.add("<xmlattr>.type", "latitude");
	ptree& child2 = pt.add("parameter.param", lng);
	child2.add("<xmlattr>.type", "longitude");
	ptree& child3 = pt.add("parameter.param", to_string(Zoom));
	child3.add("<xmlattr>.type", "zoom");
	ptree& child4 = pt.add("parameter.param", Maptype);
	child4.add("<xmlattr>.type", "maptype");
	ptree& child5 = pt.add("parameter.param", (string)to_string(hParent_X));
	child5.add("<xmlattr>.type", "wx");
	ptree& child6 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child6.add("<xmlattr>.type", "wy");
	ptree& child7 = pt.add("parameter.param", sjis_utf8(Query));
	child7.add("<xmlattr>.type", "query");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

/**
 * p[^̍폜
 * @param	Ȃ
 * @return	Ȃ
 */
void delParameter(void) {
	remove((getMyPath(APPNAME) + APPNAME + ".xml").c_str());

	// lݒ
	initParameter();
}

// WebAPIuoC[YIAVXdAPIv ================================

// dEWi-Fip\X
typedef struct _poutlets {
	char id;					// ʎq
	std::wstring title;			// X
	std::wstring address;		// Z
	std::wstring phone;			// dbԍ
	double latitude;			// ܓx
	double longitude;			// ox
	std::string url;			// X܌TCgURL
	std::string mo_url;			// oC[YIAVXł̏y[WURL
	std::wstring charge;		// [d
	std::wstring powersupply;	// d
	std::wstring wireless;		// Wi-Fi

} poutlets_t;

// NX`
class pahooOasisMogya {

public:
// RXgN^
pahooOasisMogya();
~pahooOasisMogya();

std::wstring errmsg = L"";		// G[bZ[W
std::string webapi = "";		// ߂ŎgpWebAPIURL

// dEWi-Fip\X܏
poutlets_t Poutlets[__SIZE_PPOINTS];

bool isError(void);
std::wstring getError(void);
void resetError(void);
void setError(std::wstring msg);
std::string getwebapi(void);

int getResults_OasisMogya(double latitude, double longitude, double distance);

};

// pahooOasisMogya:IuWFNg
pahooOasisMogya* pOM;

/**
 * RXgN^
 */
pahooOasisMogya::pahooOasisMogya() {
}

// fXgN^
pahooOasisMogya::~pahooOasisMogya() {
}

/**
 * G[
 * @param	Ȃ
 * @return	bool TRUE:ُ^FALSE:
*/
bool pahooOasisMogya::isError(void) {
	return this->errmsg.length() > 0;
}

/**
 * G[bZ[W擾
 * @param	Ȃ
 * @return	wstring ݔĂG[bZ[W
*/
wstring pahooOasisMogya::getError(void) {
	return this->errmsg;
}

/**
 * G[Zbg
 * @param	Ȃ
 * @return	Ȃ
*/
void pahooOasisMogya::resetError(void) {
	errmsg = L"";
}

/**
 * G[Zbg
 * @param	wstring msg G[bZ[W
 * @return	Ȃ
*/
void pahooOasisMogya::setError(wstring msg) {
	errmsg = msg;
}

/**
 * ߂ŎgpWebAPIURL擾
 * @param	Ȃ
 * @return	string URL
*/
string pahooOasisMogya::getwebapi(void) {
	return this->webapi;
}

/**
 * oC[YIAVXdAPI KvȏzɊi[
 * @param	double latitude  ܓxiEnnj
 * @param	double longitude oxiEnnj
 * @param	double distance  ͈́i[gj
 * @return	int qbg^(-1)FG[
*/
int pahooOasisMogya::getResults_OasisMogya(double latitude, double longitude, double distance) {
	// oC[YIAVXdAPIĂяo
	char sn[SIZE_BUFF + 1], ss[SIZE_BUFF + 1];
	char se[SIZE_BUFF + 1], sw[SIZE_BUFF + 1];
	double n, w, s, e;

	pGC->getPointDistance(longitude, latitude, distance, 0 - distance, &w, &n);
	pGC->getPointDistance(longitude, latitude, 0 - distance, distance, &e, &s);

	snprintf(sn, SIZE_BUFF, "%.5f", n);
	snprintf(ss, SIZE_BUFF, "%.5f", s);
	snprintf(se, SIZE_BUFF, "%.5f", e);
	snprintf(sw, SIZE_BUFF, "%.5f", w);
	this->webapi = "https://oasis.mogya.com/api/v1/spots.json?n=" + (string)sn + "&w=" + (string)sw + "&s=" + (string)ss + "&e=" + (string)se;

	// oC[YIAVXdAPI
	static string contents = "";
	static wstring ucontents = L"";

	int httpStatus = 0;
	bool res = readWebContents(this->webapi, UserAgent, &contents, &httpStatus);
	cout << httpStatus << endl;
	if (res == FALSE) {
		this->errmsg = _SW("oC[YIAVXdAPI̐ڑG[܂");
		return (-1);
	} else if ((httpStatus < 200) || (httpStatus > 299)) {
		ErrorMessage = "oC[YIAVXdAPI̐ڑG[܂";
		return (-1);
	}

	// z̏
	for (int i = 0; i < __SIZE_PPOINTS; i++) {
		this->Poutlets[i].id = 0;
		this->Poutlets[i].title = this->Poutlets[i].address = L"";
		this->Poutlets[i].phone = L"";
		this->Poutlets[i].url = this->Poutlets[i].mo_url = "";
		this->Poutlets[i].latitude = this->Poutlets[i].longitude = 0.0;
	}

	wregex re1(_SW("pr\\:[d"));
	wregex re2(_SW("d\\:"));
	wregex re3(_SW("pr\\:"));
	wregex re4(_SW("NG|ng"));
	wsmatch mt1;

	// JSONǂݍ
	int cnt = 0;
	try {
		std::stringstream ss;
		ss << contents;
		ptree pt;
		json_parser::read_json(ss, pt);

		// `FbN
		if (optional<string>str = pt.get_optional<string>("status")) {
			if (str.get() == "OK") {
			} else {
				this->errmsg = _SW("oC[YIAVXdAPỈG[܂");
				return (-1);
			}
		} else {
			this->errmsg = _SW("oC[YIAVXdAPỈG[܂");
			return (-1);
		}

		// JSON
		try {
			for (auto it : pt.get_child("results")) {
				if (cnt >= __SIZE_PPOINTS) {
					break;
				}
				// X
				if (optional<string>title = it.second.get_optional<string>("title")) {
					this->Poutlets[cnt].title = _UW(title.get());
				}
				// Z
				if (optional<string>address = it.second.get_optional<string>("address")) {
					this->Poutlets[cnt].address = _UW(address.get());
				}
				// ܓx
				if (optional<string>lat = it.second.get_optional<string>("latitude")) {
					this->Poutlets[cnt].latitude = stod(lat.get());
				}
				// ox
				if (optional<string>lng = it.second.get_optional<string>("longitude")) {
					this->Poutlets[cnt].longitude = stod(lng.get());
				}
				// URL
				if (optional<string>url = it.second.get_optional<string>("url")) {
					this->Poutlets[cnt].url = url.get();
				}
				// moURL
				if (optional<string>mo_url = it.second.get_optional<string>("mo_url")) {
					this->Poutlets[cnt].mo_url = mo_url.get();
				}
				// [d
				this->Poutlets[cnt].charge = L"";
				for (auto it2 : it.second.get_child("tags")) {
					if (optional<string>name = it2.second.get_optional<string>("name")) {
						wstring ws = _UW(name.get());
						if (regex_search(ws, mt1, re1)) {
							this->Poutlets[cnt].charge = _SW("\\");
						}
					}
				}
				// d
				this->Poutlets[cnt].powersupply = L"";
				int key = 0;
				for (auto it2 : it.second.get_child("tags")) {
					if (optional<string>name = it2.second.get_optional<string>("name")) {
						wstring ws = _UW(name.get());
						if (regex_search(ws, mt1, re4)) {
							this->Poutlets[cnt].powersupply = L"";
							break;
						}
						if (regex_search(ws, mt1, re2)) {
							wstring wstr;
							if (key > 0) {
								wstr = _SW(",");
							} else {
								wstr = L"";
							}
							wstr += regex_replace(ws, re2, L"");
							this->Poutlets[cnt].powersupply += wstr;
							key++;
						}
					}
				}
				// Wi-Fi
				this->Poutlets[cnt].wireless = L"";
				for (auto it2 : it.second.get_child("wireless")) {
					if (optional<string>name = it2.second.get_optional<string>("name")) {
						wstring ws = _UW(name.get());
						wstring wstr;
						if (key > 0) {
							wstr = _SW(",");
						} else {
							wstr = L"";
						}
						wstr += regex_replace(ws, re3, L"");
						this->Poutlets[cnt].wireless += wstr;
						key++;
					}
				}
				// ʎq
				this->Poutlets[cnt].id = {(char)(65 + cnt)};
				cnt++;
			}
		// JSON߃G[
		} catch(ptree_bad_path& e) {
			this->errmsg = _SW("oC[YIAVXdAPǏG[܂");
			return (-1);
		}

	// ǂݍ݃G[
	} catch(json_parser_error& e) {
		this->errmsg = _SW("oC[YIAVXdAPI̐ڑG[܂");
		return (-1);
	}
	contents.clear();

	return cnt;
}

/**
 * n}ɕ\CtH[V쐬
 * @param	int cnt \CtH[V
 * @return	d폜̃CtH[V
 */
int makeInformation(int cnt) {
	// 
	for (int i = 0; i < __SIZE_PPOINTS; i++) {
		pGC->Ppoints[i].latitude = pGC->Ppoints[i].longitude = 0.0;
		pGC->Ppoints[i].title = pGC->Ppoints[i].address = pGC->Ppoints[i].description = L"";
		pGC->Ppoints[i].icon = "";
	}

	// CtH[V쐬
	int j = -1;
	for (int i = 0; i < cnt; i++) {
		// Lqe
		string site;
		if (pOM->Poutlets[i].url == "") {
			site = "";
		} else {
			site = "<a href=\"" + pOM->Poutlets[i].url + "\" target=\"_blank\">ˌTCg</a><br />";
		}
		string charge;
		if (pOM->Poutlets[i].charge == L"") {
			charge = "Ȃ";
		} else {
			charge = _WS(pOM->Poutlets[i].charge);
		}
		string powersupply;
		if (pOM->Poutlets[i].powersupply == L"") {
			powersupply = "Ȃ";
		} else {
			powersupply = _WS(pOM->Poutlets[i].powersupply);
		}
		string wireless;
		if (pOM->Poutlets[i].wireless == L"") {
			wireless = "Ȃ";
		} else {
			wireless = _WS(pOM->Poutlets[i].wireless);
		}
		string str =(boost::format(R"(<span class="small"><a href="%1%" target="_blank">%2%</a><br />%3%ZF%4%<br />[dF%5%<br />dF%6%<br />Wi-FiF%7%</span>)")
% pOM->Poutlets[i].mo_url
% _WS(htmlspecialchars(pOM->Poutlets[i].title))
% site
% _WS(htmlspecialchars(pOM->Poutlets[i].address))
% charge
% powersupply
% wireless
).str();
		// O̒n_ƈܓxEox
		if ((i > 0)
			&& (pOM->Poutlets[i].latitude == pOM->Poutlets[i - 1].latitude)
			&& (pOM->Poutlets[i].longitude == pOM->Poutlets[i - 1].longitude)) {
			pGC->Ppoints[j].latitude  = pOM->Poutlets[i].latitude;
			pGC->Ppoints[j].longitude = pOM->Poutlets[i].longitude;
			pGC->Ppoints[j].description += L"<br />" + _SW(str);
		// ܓxEoxقȂ
		} else {
			j++;
			pGC->Ppoints[j].latitude  = pOM->Poutlets[i].latitude;
			pGC->Ppoints[j].longitude = pOM->Poutlets[i].longitude;
			pGC->Ppoints[j].description = _SW(str);
		}
		// ʎq̐U蒼
		pOM->Poutlets[i].id = {(char)(65 + j)};
	}

	// d̍폜
	for (int i = j + 1; i < __SIZE_PPOINTS; i++) {
		pGC->Ppoints[i].latitude = pGC->Ppoints[i].longitude = 0.0;
		pGC->Ppoints[i].title = pGC->Ppoints[i].address = pGC->Ppoints[i].description = L"";
		pGC->Ppoints[i].icon = "";
	}

	return j + 1;
}

// n}\iuEUj ======================================================
/**
 * n}\pHTML
 * @param	int cnt \CtH[V
 * @return	string HTML
 */
string makeMapHTML(int cnt=0) {
	string script = pGC->makeMapLeaflet(MAP_ID, Longitude, Latitude, Zoom, Maptype, pGC->Ppoints, cnt);
	string html = (boost::format(R"(<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="SJIS">
<title>dEWi-Fip\X܂</title>
<meta name="author" content="studio pahoo" />
<meta name="copyright" content="studio pahoo" />
<meta name="ROBOTS" content="NOINDEX,NOFOLLOW" />
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="cache-control" content="no-cache">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
%8%
</head>
<body>
<div id="%1%" style="width:%2%px; height:%3%px;"></div>
<form>
<input id="latitude"  type="hidden" value="%4%" />
<input id="longitude" type="hidden" value="%5%" />
<input id="zoom"      type="hidden" value="%6%" />
<input id="maptype"   type="hidden" value="%7%" />
</form>
</body>
</html>
)")
% MAP_ID						// n}ID
% MAP_WIDTH						// n}̕
% MAP_HEIGHT					// n}̍
% Latitude						// ܓx
% Longitude						// ox
% Zoom							// n}g嗦
% Maptype						// n}^Cv
% script						// n}`XNvg
).str();

	return html;
}

/**
 * G[bZ[W\pHTML
 * @param	Ȃ
 * @return	string HTML
 */
string makeErrorHTML(void) {
	string msg;
	if (pGC->isError()) {
		msg = _WS(pGC->getError());
	} else {
		msg = ErrorMessage;
	}
	return (boost::format(R"(<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="SJIS">
<title>G[</title>
<meta name="author" content="studio pahoo" />
<meta name="copyright" content="studio pahoo" />
<meta name="ROBOTS" content="NOINDEX,NOFOLLOW" />
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="cache-control" content="no-cache">
</head>
<body>
<p style="color:red; font-size:large;">%1%</p>
</body>
</html>
)")
% msg
).str();
}

/**
 * uEUERg[\
 * @param	char* tmpname ǂݍHTMLt@C
 * @param	int cnt \CtH[V
 * @return	Ȃ
 */
void viewBrowser(const char *tmpname, int cnt=0) {
	string html;
	string fname;
	ofstream ofs;

	// \pHTMLt@C쐬
	if ((ErrorMessage == "") && (! pGC->isError())) {
		html = makeMapHTML(cnt);
	} else {
		html = makeErrorHTML();
	}
	ofs.open(tmpname);
	ofs << html;
	ofs.close();

	fname = (string) tmpname;
	std::replace(fname.begin(), fname.end(), '\\', '/');

	if (isWeb2Ready()) {
		webView2->Reload();
	}
}

// X܈ꗗ쐬iXgr[j =============================================
// Xgr[̗
enum {
	COL_ID,
	COL_TITLE,
	COL_ADDRESS,
	COL_CHARGE,
	COL_POWERSUPPLY,
	COL_WIRELESS,
	COL_LINK
};

/**
 * X܈ꗗ\t[쐬
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void makeListViewFrame(HWND hWnd) {
	LVCOLUMNA lvcol;
	lvcol.mask = LVCF_TEXT | LVCF_SUBITEM | LVCF_WIDTH | LVCF_FMT;

	lvcol.cx = 25;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"ID";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_ID, (WPARAM)&lvcol);
	lvcol.cx = 150;
	lvcol.fmt = LVCFMT_LEFT;
	lvcol.pszText = (char *)"X";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_TITLE, (WPARAM)&lvcol);
	lvcol.cx = 250;
	lvcol.fmt = LVCFMT_LEFT;
	lvcol.pszText = (char *)"Z";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_ADDRESS, (WPARAM)&lvcol);
	lvcol.cx = 25;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"[d";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_CHARGE, (WPARAM)&lvcol);
	lvcol.cx = 25;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"d";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_POWERSUPPLY, (WPARAM)&lvcol);
	lvcol.cx = 25;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"Wi-Fi";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_WIRELESS, (WPARAM)&lvcol);
	lvcol.cx = 0;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"LINK";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_LINK, (WPARAM)&lvcol);

	// r\
	DWORD dwStyle = ListView_GetExtendedListViewStyle(hWnd);
	dwStyle = dwStyle | LVS_EX_GRIDLINES | LVS_EX_ONECLICKACTIVATE | LVS_EX_FULLROWSELECT;;
	ListView_SetExtendedListViewStyle(hWnd, dwStyle);
}

/**
 * X܈ꗗ\
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void makeListView(HWND hWnd) {
	LVITEMA item;

	// 
	for (int i = 0; i < __SIZE_PPOINTS; i++) {
		item.iItem = i;
		SendMessage(hWnd, LVM_DELETEITEM, 0, (WPARAM)&item);
	}

	// f[^s
	for (int i = 0; i < __SIZE_PPOINTS; i++) {
		if (pOM->Poutlets[i].id == 0) {
			break;
		}
		// ID
		item.mask = LVIF_TEXT;
		item.iItem = i;
		item.iSubItem = COL_ID;
		string s = {pOM->Poutlets[i].id};
		item.pszText = (LPSTR)(s.c_str());
		SendMessage(hWnd, LVM_INSERTITEMA, 0,(WPARAM)&item);
		// X
		item.iSubItem = COL_TITLE;
		item.pszText = (LPSTR)_WS(pOM->Poutlets[i].title).substr(0, MAX_LISTVIEWITEM).c_str();
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// Z
		item.iSubItem = COL_ADDRESS;
		item.pszText = (LPSTR)_WS(pOM->Poutlets[i].address).substr(0, MAX_LISTVIEWITEM).c_str();
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// [d
		item.iSubItem = COL_CHARGE;
		if (pOM->Poutlets[i].charge != L"") {
			item.pszText = (LPSTR)"";
		} else {
			item.pszText = (LPSTR)"";
		}
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// d
		item.iSubItem = COL_POWERSUPPLY;
		if (pOM->Poutlets[i].powersupply != L"") {
			item.pszText = (LPSTR)"";
		} else {
			item.pszText = (LPSTR)"";
		}
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// Wi-Fi
		item.iSubItem = COL_WIRELESS;
		if (pOM->Poutlets[i].wireless != L"") {
			item.pszText = (LPSTR)"";
		} else {
			item.pszText = (LPSTR)"";
		}
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// N
		item.iSubItem = COL_LINK;
		item.pszText = (LPSTR)pOM->Poutlets[i].mo_url.c_str();
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
	}
}

/**
 * dEWi-Fip\X܂CuEU\ƈꗗ\sD
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void viewMapList(void) {
	int cnt = 0;

	// dEWi-Fip\X܌
	cnt = pOM->getResults_OasisMogya(Latitude, Longitude, 100);
	if (cnt > 0) {
		cnt = makeInformation(cnt);
	}

	// uEUERg[ɕ\
	viewBrowser(tmpFname, cnt);

	// dEWi-Fip\X܂̈ꗗ\
	makeListView(GetDlgItem(hParent, IDC_LISTVIEW_OUTLETS));
}

// ۑERs[ =============================================================
/**
 * ꗗCSVt@CɕۑFۑ
 * @param	const char* fname ۑt@C
 * @return	Ȃ
 */
void __saveCSV(const char *fname) {
	char lng[SIZE_BUFF + 1], lat[SIZE_BUFF + 1];
	string str;
	ofstream outputfile(fname);

	// x
	outputfile << "\"" << "ID" << "\",";
	outputfile << "\"" << "X" << "\",";
	outputfile << "\"" << "Z" << "\",";
	outputfile << "\"" << "ܓx" << "\",";
	outputfile << "\"" << "ox" << "\",";
	outputfile << "\"" << "[d" << "\",";
	outputfile << "\"" << "d" << "\",";
	outputfile << "\"" << "Wi-Fi" << "\"";
	outputfile << endl;

	// f[^{
	for (int i = 0; i < __SIZE_PPOINTS; i++) {
		if (pOM->Poutlets[i].id != 0) {
			snprintf(lng, SIZE_BUFF, "%.5f", pOM->Poutlets[i].longitude);
			snprintf(lat, SIZE_BUFF, "%.5f", pOM->Poutlets[i].latitude);
			outputfile << "\"" << pOM->Poutlets[i].id << "\",";
			outputfile << "\"" << _WS(pOM->Poutlets[i].title) << "\",";
			outputfile << "\"" << _WS(pOM->Poutlets[i].address) << "\",";
			outputfile << "\"" << lat << "\",";
			outputfile << "\"" << lng << "\",";
			if (pOM->Poutlets[i].charge == L"") {
				str = "Ȃ";
			} else {
				str = _WS(pOM->Poutlets[i].charge);
			}
			outputfile << "\"" << str << "\",";
			if (pOM->Poutlets[i].powersupply == L"") {
				str = "Ȃ";
			} else {
				str = _WS(pOM->Poutlets[i].powersupply);
			}
			outputfile << "\"" << str << "\",";
			if (pOM->Poutlets[i].wireless == L"") {
				str = "Ȃ";
			} else {
				str = _WS(pOM->Poutlets[i].wireless);
			}
			outputfile << "\"" << str << "\"";
			outputfile << endl;
		}
		if (outputfile.bad()) {
			ErrorMessage = "CSVt@C݃G[";
			break;
		}
	}
	outputfile.close();
}

/**
 * ꗗCSVt@CɕۑFt@C_CAO
 * @param	Ȃ
 * @return	Ȃ
 */
void saveCSV(void) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, SAVEFILE);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("CSVt@C(*.csv;*.txt)\0*.csv;*.txt\0ׂẴt@C(*.txt)\0*.txt\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("csv");
	// R_CAO̕\
	GetSaveFileName(&of);
	// t@Cۑ
	__saveCSV(fname);
}

/**
 * Nbv{[hɃRs[镶𐶐
 * @param	Ȃ
 * @return	string Rs[镶
 */
string copyText(void) {
	char lng[SIZE_BUFF + 1], lat[SIZE_BUFF + 1];
	string str;
	ostringstream oss;

	// x
	oss << "ID" << "\t";
	oss << "X" << "\t";
	oss << "Z" << "\t";
	oss << "ܓx" << "\t";
	oss << "ox" << "\t";
	oss << "[d" << "\t";
	oss << "d" << "\t";
	oss << "Wi-Fi" << endl;

	// f[^{
	for (int i = 0; i < __SIZE_PPOINTS; i++) {
		if (pOM->Poutlets[i].id != 0) {
			snprintf(lng, SIZE_BUFF, "%.5f", pOM->Poutlets[i].longitude);
			snprintf(lat, SIZE_BUFF, "%.5f", pOM->Poutlets[i].latitude);
			oss << pOM->Poutlets[i].id << "\t";
			oss << _WS(pOM->Poutlets[i].title) << "\t";
			oss << _WS(pOM->Poutlets[i].address) << "\t";
			oss << lat << "\t";
			oss << lng << "\t";
			if (pOM->Poutlets[i].charge == L"") {
				str = "Ȃ";
			} else {
				str = _WS(pOM->Poutlets[i].charge);
			}
			oss << str << "\t";
			if (pOM->Poutlets[i].powersupply == L"") {
				str = "Ȃ";
			} else {
				str = _WS(pOM->Poutlets[i].powersupply);
			}
			oss << str << "\t";
			if (pOM->Poutlets[i].wireless == L"") {
				str = "Ȃ";
			} else {
				str = _WS(pOM->Poutlets[i].wireless);
			}
			oss << str << endl;
		}
	}
	return oss.str();
}


// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg			EBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
 */
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg,
					WPARAM wParam, LPARAM lParam) {
	string help;

	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
		setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
		break;

		// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// s
		case IDC_BUTTON_OK:
			EndDialog(hDlg, 0);
			break;
		default:
			return 1;
		}
		break;
		// vOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
	return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
 */
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC) handler);
}

// WebView2p֐Q ======================================================
/**
 * WebView2F_CAO
 * @param	HWND hDlg	eEBhEEnh
 * @return	Ȃ
*/
void initDialog(HWND hDlg) {
	HICON hIcon;
	hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
	ErrorMessage = "";

	// J[\v
	SetCursor(LoadCursor(NULL, IDC_WAIT));
	// IvVǂݍ
	loadParameter();
	// AvP[VEEBhEړ
	SetWindowPos(hDlg, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));

	// e|Et@C擾
	getTempFname(tmpFname);
	size_t wLen = 0;
	mbstowcs_s(&wLen, wUri, MAX_PATH * 2, tmpFname, MAX_PATH);
	// WebView2
	hWebView2 = createWebView2(hInst, hDlg, 10, 50, MAP_WIDTH + 20, MAP_HEIGHT + 20, wUri);
	// dEWi-Fip\X܂̈ꗗ\t[쐬
	makeListViewFrame(GetDlgItem(hDlg, IDC_LISTVIEW_OUTLETS));

	// bZ[WE[v
	MSG msg;
	static bool flagWebView2 = false;
	while (GetMessage(&msg, nullptr, 0, 0)) {
		if (msg.message == WM_QUIT) {
			// IvVۑ
			// saveOption();
			DestroyWindow(hDlg);
		}
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		if (!flagWebView2 && isWeb2Ready()) {
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			// uEU\ƈꗗ\
			viewMapList();
			flagWebView2 = true;
		}
	}
}

/**
 * WebView2nhD
 * selectAction̒lɂēςB
 * @param	char* result	JavaScriptInhnf[^
 * @return	Ȃ
*/
void execScriptCompleted(string result) {
	double lat = 0, lng = 0;
	int zm = 0;
	string mt;

	// p[^ǂݍ
	vector<string> tokens;
	split(tokens, result, is_any_of(",\""));
	int cnt = 0;
	for (string ss: tokens) {
		switch (cnt) {
			case 1:
				lng = stod(ss);
				break;
			case 2:
				lat = stod(ss);
				break;
			case 3:
				zm = stoi(ss);
				break;
			case 4:
				mt = ss;
				break;
		}
		cnt++;
	}

	switch (selectAction) {
		// ܓxEox擾ăuEUɕ\
		case eAction::GetLatLong:
			Longitude = lng;
			Latitude  = lat;
			// uEU\ƈꗗ\
			viewMapList();
			break;
		// g嗦E}bv^Cv擾ăuEUɕ\
		case eAction::GetZoomType:
			Zoom = zm;
			Maptype = mt;
			// uEU\ƈꗗ\
			viewMapList();
			break;
		// ܓxEoxEg嗦E}bv^Cv擾ăuEUɕ\
		case eAction::GetLatLongZoomType:
			Longitude = lng;
			Latitude  = lat;
			Zoom = zm;
			Maptype = mt;
			// uEU\ƈꗗ\
			viewMapList();
			break;
		// vOID
		default:
			Longitude = lng;
			Latitude  = lat;
			Zoom = zm;
			Maptype = mt;
			// e|Et@C폜D
			remove(tmpFname);
			// p[^ۑD
			saveParameter();
			// vOI
			EndDialog(hParent, 0);
			DestroyWindow(hParent);
			break;
	}
//	cout << "Longitude: " << Longitude << endl;
//	cout << "Latitude: " << Latitude << endl;
//	cout << "Zoom: " << Zoom << endl;
//	cout << "Maptype: " << Maptype << endl;
}

/**
 * WebView2FJavaScriptInh
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
class MyScriptCompletedHandler : public ICoreWebView2ExecuteScriptCompletedHandler {
public:
	HRESULT STDMETHODCALLTYPE Invoke(HRESULT error, PCWSTR result) override {
		if (SUCCEEDED(error)) {
			// PCWSTR  char* ϊ
			int requiredSize = WideCharToMultiByte(CP_UTF8, 0, result, -1, nullptr, 0, nullptr, nullptr);
			char* buffer = new char[requiredSize];
			WideCharToMultiByte(CP_UTF8, 0, result, -1, buffer, requiredSize, nullptr, nullptr);
			std::string res(buffer);
			// JavaScriptIɎs֐
			execScriptCompleted(res);
		}
		return S_OK;
	}

	HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid, void** ppvObject) override {
		return E_NOINTERFACE;
	}

	ULONG STDMETHODCALLTYPE AddRef(void) override {
		return 1;
	}

	ULONG STDMETHODCALLTYPE Release(void) override {
		return 1;
	}
};

// WebView2JavaScriptsDOMvf擾
MyScriptCompletedHandler* scriptCompletedHandler = new MyScriptCompletedHandler();

/**
 * WebView2ŃXNvgsCselectActionŎw肵ANVsD
 * @param	Ȃ
 * @return	Ȃ
*/
void execScriptAndAction(void) {
	// vOIɎsJavaScript
	LPCWSTR js = L"document.getElementById('longitude').value + ',' + document.getElementById('latitude').value + ',' + document.getElementById('zoom').value + ',' + document.getElementById('maptype').value;";

	webView2->ExecuteScript(js, scriptCompletedHandler);
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
 */
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	TCHAR buff[SIZE_BUFF + 1];
	LVITEM item;
	LV_HITTESTINFO lvinfo;
	wstring val;
	wstring wid;

	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		break;

	// {^
	case WM_COMMAND:
		if ((ErrorMessage != "") | pGC->isError()) {
			break;
		}
		switch (LOWORD(wParam)) {
		// 
		case IDM_EXEC:
		case IDC_BUTTON_EXEC:
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			// L[΃WIR[hAPIĂяo
			Query = getStrEditBox(hDlg, IDC_EDIT_QUERY);
			if (Query.length() > 0) {
				if (pGC->searchPoints(_SW(Query), UserAgent, 0) > 0) {
					Longitude = pGC->Ppoints[0].longitude;
					Latitude  = pGC->Ppoints[0].latitude;
				}
				// uEU\ƈꗗ\
				selectAction = eAction::GetZoomType;
				execScriptAndAction();
			} else {
				// uEU\ƈꗗ\
				selectAction = eAction::GetLatLongZoomType;
				execScriptAndAction();
			}
			// G[EZbg
			ErrorMessage = "";
			pGC->resetError();
			break;
		// Zbg
		case IDC_BUTTON_RESET:
		case IDM_RESET:
			setStrEditBox(hDlg, IDC_EDIT_QUERY, "");
			ErrorMessage = "";
			pGC->resetError();
			break;
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			saveCSV();
			break;
		// GoogleAPIL[ۑ
		case IDM_GOOGLE_APIKEY:
			createSetAPIkey(hDlg, LABEL_GOOGLE_API, FNAME_GOOGLE_API, URL_GOOGLE_API, &pGC->GoogleAPIkey);
			pGC->readGoogleApiKey();
			// G[EZbg
			ErrorMessage = "";
			pGC->resetError();
			// GoogleAPIL[o^ȂftHg̃}bv^Cvɖ߂D
			Maptype = pGC->isGoogleApiKey() ? "GMRD" : DEF_MAPTYPE;
			// uEUERg[ɕ\
			viewBrowser(tmpFname);
			break;
		// Yahoo!AvP[VIDۑ
		case IDM_YAHOO_APIKEY:
			createSetAPIkey(hDlg, LABEL_YAHOO_API, FNAME_YAHOO_API, URL_YAHOO_API, &pGC->YahooAPIkey);
			// G[EZbg
			ErrorMessage = "";
			pGC->resetError();
			// uEUERg[ɕ\
			viewBrowser(tmpFname);
			break;
		// ݒNA{AvI
		case IDM_CLEAR_PARAMETER:
			delParameter();
			// e|Et@C폜
			remove(tmpFname);
			EndDialog(hDlg, 0);
			return 0;
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hDlg, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hDlg, processHelp);
			break;
		// TCg
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// Rs[
		case IDM_COPY:
		case IDC_BUTTON_COPY:
			setClipboardData(copyText());
			break;
		// ؂
		case IDM_DELETE:
			setStrEditBox(hDlg, IDC_EDIT_QUERY, "");
			break;
		// vOI
		case IDM_QUIT:
			selectAction = eAction::Finish;
			execScriptAndAction();
			break;
		default:
			return 1;
		}
		break;

	// ʒm
	case WM_NOTIFY:
		switch(((LPNMHDR)lParam)->idFrom) {
		case IDC_LISTVIEW_OUTLETS:
			switch (((LPNMLISTVIEW)lParam)->hdr.code) {
			case LVN_ITEMCHANGED:
			// j[Xꗗ1s_uNbN
			// case NM_DBLCLK:
				GetCursorPos((LPPOINT)&lvinfo.pt);
				ScreenToClient(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &lvinfo.pt);
				ListView_HitTest(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &lvinfo);
				if ((lvinfo.flags & LVHT_ONITEM) != 0) {
					item.mask = TVIF_HANDLE | TVIF_TEXT;
					item.iItem = lvinfo.iItem;
					item.iSubItem = COL_LINK;
					item.pszText = buff;
					item.cchTextMax = SIZE_BUFF;
					ListView_GetItem(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &item);
					// uEUN
					ShellExecute(hDlg, _T("open"), _T(buff), NULL, NULL, SW_RESTORE);
				}
				break;
			default:
				break;
			}
			break;
		default:
			break;
		}
		break;

	// vOI
	case WM_CLOSE:
		selectAction = eAction::Finish;
		execScriptAndAction();
		break;
	}
	return 0;
}

// CEvO =======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
 */
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");

	// UserAgent
	static OSVERSIONINFOEX os;
	GetVersion2(&os);
	UserAgent = (string)"Mozilla/5.0 (" + APPNAME + "/"
		+ APPVERSION + "/" + MAKER
		+ ", Windows NT " + to_string(os.dwMajorVersion) + "."
		+ to_string(os.dwMinorVersion) + ")";

	// pahooGeocodeIuWFNg
	pGC = new pahooGeocode(APPNAME);
	// pahooOasisMogyaIuWFNg
	pOM = new pahooOasisMogya();

	// CE_CAO
	HWND hDlg = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);
	hInst = hInstance;
	hParent = hDlg;
	// CE_CAOD
	initDialog(hDlg);

	// IuWFNg
	delete pGC;
	delete pOM;

	return 0;
}

/*
 ** o[WAbv =====================================================
 *
 * @version 2.2.2  2025/11/23 gpCuXV
 * @version 2.2.1  2025/07/26 gpCuXV
 * @version 2.2.0  2025/03/22 LeafletANZXۃ`FbNǉ,gpCuXV
 * @version 2.1.2  2024/11/30 gpCuXV
 * @version 2.1.1  2024/08/24 gpCuXV
 * @version 2.1.0  2024/05/03 API͏
 * @version 2.0.0  2024/04/28 EdgeuEUΉC64rbgΉ
 * @version 1.1.4  2024/04/07 gpCuXV
 * @version 1.1.3  2023/12/17 gpCuXV
 * @version 1.1.2  2023/07/23 gpCuXV
 * @version 1.1.1  2023/04/01 gpCuXV
 * @version 1.1.0  2022/09/23 EBhEʒuۑCCuXV
 * @version 1.0    2020/10/17 
 */
