/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class FDBCipher {
    public static final String CIPHER_FILE = "fdbcipher.txt";
    private static final String[] CIPHER_DEF = new String[]{"FullDirectionBB.jar", "key", "\u30bf\u30a4\u30c8\u30eb", "\u4f5c\u8005", "\u30e1\u30c3\u30bb\u30fc\u30b8", "blank", "\u30b3\u30e1\u30f3\u30c8"};
    private static final int CIPHER_ALL_NAME = 0;
    private static final int CIPHER_ALL_KEY = 1;
    private static final int CIPHER_ALL_TITLE = 2;
    private static final int CIPHER_ALL_AUTHER = 3;
    private static final int CIPHER_11_INFO01 = 4;
    private static final int CIPHER_11_INFO02 = 5;
    private static final int CIPHER_12_MESSAGE = 4;
    private static final int CIPHER_12_COMMENT = 6;
    private static final int CIPHER_12_ALL = 7;
    FDBFrame frame;
    FDBFileIO fileIO;
    File outFile = null;
    String key = null;
    String title = null;
    String message = null;

    public FDBCipher(FDBFrame frm, FDBFileIO fIO) {
        this.frame = frm;
        this.fileIO = fIO;
        String[] data = this.fileIO.getFileStringInJar(CIPHER_FILE);
        if (data == null || data.length < 4) {
            data = CIPHER_DEF;
        }
        this.setCipherFileString(data);
    }

    private void setCipherFileString(String[] data) {
        File file = this.fileIO.setSelfJarFile(data[0]);
        if (file != null) {
            this.outFile = FDBCipher.changeJarToStageFile(file);
        }
        this.key = data[1];
        this.title = data[2];
        this.title = data[2].equals("no") ? FDBCipher.getNoExtensionFileName(file) : data[2];
        if (data.length >= 7) {
            StringBuilder com = new StringBuilder();
            com.append(data[6]);
            int c = 7;
            while (c < data.length) {
                com.append(FDBFileIO.BR).append(data[c]);
                ++c;
            }
            this.frame.infoDialog.setInfoData(data[3], com.toString());
            this.message = this.decrypt(this.key, data[4]);
        } else {
            StringBuilder com = new StringBuilder();
            if (data.length >= 4) {
                com.append(data[4]);
                if (data.length >= 5) {
                    com.append(FDBFileIO.BR).append(data[5]);
                }
            } else {
                com.append("no");
            }
            if (data[3].equals("\u672a\u8a18\u5165")) {
                this.frame.infoDialog.setInfoData(FDBFileIO.BR, com.toString());
            } else {
                this.frame.infoDialog.setInfoData(data[3], com.toString());
            }
            this.message = null;
        }
    }

    private static File changeJarToStageFile(File file) {
        String path = file.getPath();
        String beforeExt = ".jar";
        String afterExt = ".dat";
        if (path.lastIndexOf(beforeExt) == path.length() - beforeExt.length()) {
            return new File(String.valueOf(path.substring(0, path.length() - beforeExt.length())) + afterExt);
        }
        return null;
    }

    private static String getNoExtensionFileName(File file) {
        String tmpStr = file.getName();
        return tmpStr.substring(0, tmpStr.indexOf("."));
    }

    public static String getCipherFileString(String fileName, String title, String autherName, String info01, String info02) {
        StringBuffer buf = new StringBuffer();
        buf.append(fileName).append(FDBFileIO.BR);
        buf.append(FDBCipher.makeKeyString(5)).append(FDBFileIO.BR);
        if (title.equals("")) {
            buf.append(fileName).append(FDBFileIO.BR);
        } else {
            buf.append(title).append(FDBFileIO.BR);
        }
        if (autherName.equals("")) {
            buf.append("\u672a\u8a18\u5165").append(FDBFileIO.BR);
        } else {
            buf.append(autherName).append(FDBFileIO.BR);
            if (!info01.equals("")) {
                buf.append(info01).append(FDBFileIO.BR);
            }
            if (!info02.equals("")) {
                buf.append(info02).append(FDBFileIO.BR);
            }
        }
        return buf.toString();
    }

    public String getCipherFileString12(String fileName, String title, String auther, String comment, String message) {
        String keyStr = FDBCipher.makeKeyString(5);
        StringBuffer buf = new StringBuffer();
        FDBCipher.addStr(buf, fileName);
        FDBCipher.addStr(buf, keyStr);
        FDBCipher.addStr(buf, title);
        FDBCipher.addStr(buf, auther);
        FDBCipher.addStr(buf, this.encrypt(keyStr, FDBCipher.convertBlank(message)));
        FDBCipher.addStr(buf, "blank");
        FDBCipher.addStr(buf, comment);
        return buf.toString();
    }

    private static void addStr(StringBuffer strBuf, String adStr) {
        strBuf.append(FDBCipher.convertBlank(adStr)).append(FDBFileIO.BR);
    }

    private static String convertBlank(String str) {
        if (str == null || str.length() == 0) {
            return "no";
        }
        return str;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean checkMessage() {
        return this.message != null && !this.message.equals("no");
    }

    public void deleteStageNum() {
        if (this.outFile == null) {
            return;
        }
        this.outFile.delete();
    }

    public boolean saveStageNum(int stgNum) {
        if (this.outFile == null) {
            this.frame.showErrorDialog("\u30b9\u30c6\u30fc\u30b8\u4fdd\u5b58\u30d5\u30a1\u30a4\u30eb\u3092\u5f97\u3089\u308c\u3066\u3044\u307e\u305b\u3093");
            return false;
        }
        String encrypted = this.encryptStageNum(stgNum);
        if (encrypted == null) {
            this.frame.showErrorDialog("\u6697\u53f7\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            return false;
        }
        try {
            FDBFileIO.makeTextFile(this.outFile, encrypted);
            return true;
        }
        catch (IOException e) {
            this.frame.showErrorDialog("\u30b9\u30c6\u30fc\u30b8\u4fdd\u5b58\u30d5\u30a1\u30a4\u30eb\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            return false;
        }
    }

    public int loadStageNum() {
        if (this.outFile == null) {
            return 1;
        }
        String[] ret = FDBFileIO.getFileString(this.outFile);
        if (ret == null) {
            return 1;
        }
        return this.decryptStageNum(ret[0]);
    }

    public String encryptStageNum(int stgNum) {
        if (this.key == null) {
            return null;
        }
        return this.encrypt(this.key, String.valueOf(stgNum));
    }

    public int decryptStageNum(String encripted) {
        if (encripted == null) {
            return 1;
        }
        if (this.key == null) {
            return 1;
        }
        String ret = this.decrypt(this.key, encripted);
        if (ret != null) {
            return Integer.parseInt(ret);
        }
        return 1;
    }

    private static String makeKeyString(int size) {
        SecureRandom random = new SecureRandom();
        char[] key = new char[size];
        int k = 0;
        while (k < key.length) {
            switch (random.nextInt(3)) {
                case 0: {
                    key[k] = (char)(97 + random.nextInt(26));
                    break;
                }
                case 1: {
                    key[k] = (char)(65 + random.nextInt(26));
                    break;
                }
                case 2: {
                    key[k] = (char)(48 + random.nextInt(10));
                    break;
                }
                default: {
                    key[k] = 97;
                }
            }
            ++k;
        }
        return new String(key);
    }

    private String encrypt(String key, String text) {
        try {
            SecretKeySpec skSpec = new SecretKeySpec(key.getBytes(), "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(1, skSpec);
            byte[] encrypted = cipher.doFinal(text.getBytes());
            return new String(Hex.encodeHex(encrypted));
        }
        catch (NoSuchPaddingException e) {
            this.frame.showErrorDialog("\u6697\u53f7\u5316\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + FDBFileIO.BR + e.toString());
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            this.frame.showErrorDialog("\u6697\u53f7\u5316\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + FDBFileIO.BR + e.toString());
            return null;
        }
        catch (IllegalBlockSizeException e) {
            this.frame.showErrorDialog("\u6697\u53f7\u5316\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + FDBFileIO.BR + e.toString());
            return null;
        }
        catch (InvalidKeyException e) {
            this.frame.showErrorDialog("\u6697\u53f7\u5316\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + FDBFileIO.BR + e.toString());
            return null;
        }
        catch (BadPaddingException e) {
            this.frame.showErrorDialog("\u6697\u53f7\u5316\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + FDBFileIO.BR + e.toString());
            return null;
        }
    }

    private String decrypt(String key, String text) {
        try {
            byte[] encrypted = Hex.decodeHex(text.toCharArray());
            SecretKeySpec skSpec = new SecretKeySpec(key.getBytes(), "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(2, skSpec);
            byte[] decrypted = cipher.doFinal(encrypted);
            return new String(decrypted);
        }
        catch (DecoderException e) {
            this.frame.showErrorDialog("\u8907\u5408\u5316\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + FDBFileIO.BR + e.toString());
            return null;
        }
        catch (NoSuchPaddingException e) {
            this.frame.showErrorDialog("\u8907\u5408\u5316\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + FDBFileIO.BR + e.toString());
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            this.frame.showErrorDialog("\u8907\u5408\u5316\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + FDBFileIO.BR + e.toString());
            return null;
        }
        catch (IllegalBlockSizeException e) {
            this.frame.showErrorDialog("\u8907\u5408\u5316\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + FDBFileIO.BR + e.toString());
            return null;
        }
        catch (InvalidKeyException e) {
            this.frame.showErrorDialog("\u8907\u5408\u5316\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + FDBFileIO.BR + e.toString());
            return null;
        }
        catch (BadPaddingException e) {
            this.frame.showErrorDialog("\u8907\u5408\u5316\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + FDBFileIO.BR + e.toString());
            return null;
        }
    }
}

