/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class FDBFileIO
extends Component {
    private static final String WORK_FOLDER = "work";
    public static final String SE_FOLDER = "se";
    public static final String BACK_FOLDER = "back";
    public static final String SEP = System.getProperty("file.separator");
    public static final String BR = System.getProperty("line.separator");
    public static final String SET_FILE = "fdbset.txt";
    private static final int[] SET_DATA_DEFAULT;
    public static final int SET_DATA_RUN = 0;
    public static final int SET_DATA_WIDTH = 1;
    public static final int SET_DATA_HEIGHT = 2;
    public static final int SET_DATA_SOUND = 3;
    public static final int SET_DATA_STAGE = 4;
    JarFile selfJarFile;
    File workFolder;
    FDBFrame frame;
    File saveFile;
    boolean changed;
    JFileChooser chooser = new JFileChooser();

    static {
        int[] nArray = new int[5];
        nArray[1] = 800;
        nArray[2] = 600;
        SET_DATA_DEFAULT = nArray;
    }

    public FDBFileIO(FDBFrame frm) {
        this.frame = frm;
        this.workFolder = new File(String.valueOf(System.getProperty("user.dir")) + SEP + WORK_FOLDER);
        this.saveFile = null;
        this.changed = false;
    }

    public String getFileName() {
        if (this.saveFile != null) {
            return this.saveFile.getName();
        }
        return "\u7121\u984c";
    }

    public void changePuzzle(boolean newPuzzle) {
        if (newPuzzle) {
            this.saveFile = null;
        }
        this.changed = true;
        this.frame.setTitleString();
    }

    public boolean needSave() {
        return this.changed;
    }

    public int[] getSetInfo(boolean outFlag) {
        String[] setStr = outFlag ? this.getFileString(SET_FILE) : this.getFileStringInJar(SET_FILE);
        if (setStr == null || setStr.length < SET_DATA_DEFAULT.length) {
            return SET_DATA_DEFAULT;
        }
        int[] setInt = new int[SET_DATA_DEFAULT.length];
        int s = 0;
        while (s < SET_DATA_DEFAULT.length) {
            try {
                setInt[s] = Integer.parseInt(setStr[s]);
            }
            catch (NumberFormatException e) {
                setInt[s] = SET_DATA_DEFAULT[s];
            }
            ++s;
        }
        return setInt;
    }

    public void makeSetFile(int run, Dimension size, int snd, int stg) {
        String data = FDBFileIO.getSetFileString(run, size, snd, stg);
        File setFile = this.getWorkFile(SET_FILE);
        try {
            FDBFileIO.makeTextFile(setFile, data);
        }
        catch (IOException e) {
            this.frame.showErrorDialog("\u57fa\u672c\u52d5\u4f5c\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + BR + e.toString());
        }
    }

    public static String getSetFileString(int run, Dimension size, int snd, int stg) {
        StringBuffer buf = new StringBuffer();
        buf.append(run).append(BR);
        buf.append(size.width).append(BR);
        buf.append(size.height).append(BR);
        buf.append(snd).append(BR);
        buf.append(stg).append(BR);
        return buf.toString();
    }

    public void makeFirstStageFile(int stg) {
        FDBSetFile s0 = new FDBSetFile(this.frame);
        s0.setDefaultData(new String[]{"stage_max(" + stg + ")"});
        this.makeStageFile(0, s0.getFirstDefaultDataString());
    }

    public void makeStageFile(int stgNum, String data) {
        File file = this.getWorkFile(FDBFileIO.getTargetStageFileName(stgNum));
        try {
            FDBFileIO.makeTextFile(file, data);
        }
        catch (IOException e) {
            this.frame.showErrorDialog("\u30b9\u30c6\u30fc\u30b8\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + BR + e.toString());
        }
    }

    public String[] getStageData(int stgNum) {
        String fileName = FDBFileIO.getTargetStageFileName(stgNum);
        String[] data = this.getFileString(fileName);
        if (data != null) {
            return data;
        }
        return new String[0];
    }

    public void copyBlockFiles(File folder, int stg) {
        int s = 0;
        while (s <= stg) {
            File beforeFile = new File(String.valueOf(folder.getPath()) + SEP + FDBFileIO.getTargetBlockFileName(s));
            if (beforeFile.exists()) {
                this.copyBlockFile(s, beforeFile);
            }
            ++s;
        }
    }

    public void copyBlockFile(int stgNum, File beforeFile) {
        File afterFile = this.getWorkFile(FDBFileIO.getTargetBlockFileName(stgNum));
        try {
            FDBFileIO.copyFile(beforeFile, afterFile);
        }
        catch (IOException ioe) {
            this.frame.showErrorDialog("\u30d6\u30ed\u30c3\u30af\u914d\u7f6e\u30d5\u30a1\u30a4\u30eb\u306e\u30b3\u30d4\u30fc\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + BR + ioe.toString());
        }
    }

    public void deleteStageFile(int stgNum) {
        File file = this.getWorkFile(FDBFileIO.getTargetStageFileName(stgNum));
        file.delete();
    }

    public void deleteBlockFile(int stgNum) {
        File file = this.getWorkFile(FDBFileIO.getTargetBlockFileName(stgNum));
        file.delete();
    }

    public void deleteUselessStageBlockFiles(int stgNum) {
        int s = 30;
        while (s > stgNum) {
            File fileS = this.getWorkFile(FDBFileIO.getTargetStageFileName(s));
            File fileB = this.getWorkFile(FDBFileIO.getTargetBlockFileName(s));
            if (fileS.exists()) {
                fileS.delete();
            }
            if (fileB.exists()) {
                fileB.delete();
            }
            --s;
        }
    }

    public static String getTargetStageFileName(int stgNum) {
        if (stgNum >= 100) {
            return "s" + String.valueOf(stgNum) + ".txt";
        }
        if (stgNum >= 10) {
            return "s0" + String.valueOf(stgNum) + ".txt";
        }
        return "s00" + String.valueOf(stgNum) + ".txt";
    }

    public static String getTargetBlockFileName(int stgNum) {
        if (stgNum >= 100) {
            return "b" + String.valueOf(stgNum) + ".csv";
        }
        if (stgNum >= 10) {
            return "b0" + String.valueOf(stgNum) + ".csv";
        }
        return "b00" + String.valueOf(stgNum) + ".csv";
    }

    public void deleteSEFolder() {
        File seFolder = this.getWorkFile(SE_FOLDER);
        if (seFolder.exists()) {
            FDBFileIO.deleteInnerFiles(seFolder, true);
        }
    }

    public void copySEFiles(File dir, String ext) {
        this.deleteSEFolder();
        File seFolder = this.getWorkFile(SE_FOLDER);
        seFolder.mkdirs();
        try {
            int s = 0;
            while (s < 8) {
                File beforeSE = new File(String.valueOf(dir.getPath()) + SEP + FDBSound.SOUND_NAME[s] + "." + ext);
                File afterSE = new File(String.valueOf(seFolder.getPath()) + SEP + FDBSound.SOUND_NAME[s] + "." + ext);
                if (beforeSE.exists()) {
                    FDBFileIO.copyFile(beforeSE, afterSE);
                } else if (this.selfJarFile != null) {
                    this.outFromSelfJarToWork("se/" + FDBSound.SOUND_NAME[s] + "." + ext);
                }
                ++s;
            }
        }
        catch (IOException e) {
            this.frame.showErrorDialog("\u52b9\u679c\u97f3\u306e\u30b3\u30d4\u30fc\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + BR + e.toString());
        }
    }

    public void copyBackImage(File before) {
        File backFolder = this.getWorkFile(BACK_FOLDER);
        if (!backFolder.exists()) {
            backFolder.mkdirs();
        }
        File after = new File(String.valueOf(backFolder.getPath()) + SEP + before.getName());
        try {
            FDBFileIO.copyFile(before, after);
        }
        catch (IOException ioe) {
            this.frame.showErrorDialog("\u80cc\u666f\u753b\u50cf\u306e\u30b3\u30d4\u30fc\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + BR + ioe.toString());
        }
    }

    public void deleteUselessBackImages(int stg) {
        File file;
        ArrayList<String> needImages = new ArrayList<String>();
        FDBSetFile set = new FDBSetFile(this.frame);
        int s = 0;
        while (s <= stg) {
            file = this.getWorkFile(FDBFileIO.getTargetStageFileName(s));
            if (file.exists()) {
                set.setDefaultData(this.getFileString(FDBFileIO.getTargetStageFileName(s)));
                if (set.backImage != null) {
                    needImages.add(FDBFileIO.changeImagePathToName(set.backImage));
                }
            }
            ++s;
        }
        File backFolder = this.getWorkFile(BACK_FOLDER);
        if (backFolder.exists()) {
            String[] existImages = backFolder.list();
            int e = 0;
            while (e < existImages.length) {
                if (this.checkImageUseless(existImages[e], needImages)) {
                    file = new File(String.valueOf(backFolder.getPath()) + SEP + existImages[e]);
                    file.delete();
                }
                ++e;
            }
            existImages = backFolder.list();
            if (existImages.length == 0) {
                backFolder.delete();
            }
        }
    }

    private boolean checkImageUseless(String name, ArrayList<String> list) {
        int n = 0;
        while (n < list.size()) {
            if (name.equals(list.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String changeImagePathToName(String path) {
        return path.substring(path.indexOf("/") + 1);
    }

    public static String changeImageNameToPath(String name) {
        return new String("back/" + name);
    }

    public void formatWorkFolder() {
        File backFolder = this.getWorkFile(BACK_FOLDER);
        backFolder.mkdirs();
        if (this.selfJarFile == null) {
            this.frame.showErrorDialog("\u81ea\u8eab\u306eJar\u30d5\u30a1\u30a4\u30eb\u3092\u5f97\u3089\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        try {
            this.outFromSelfJarToWork(SET_FILE);
            int s = 0;
            while (s <= 5) {
                this.outFromSelfJarToWork("s00" + s + ".txt");
                this.outFromSelfJarToWork("b00" + s + ".csv");
                ++s;
            }
            this.outFromSelfJarToWork("back/back.png");
        }
        catch (IOException ioe) {
            this.frame.showErrorDialog("\u521d\u671f\u30d1\u30ba\u30eb\u30c7\u30fc\u30bf\u306e\u89e3\u51cd\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + BR + ioe.toString());
        }
        catch (NullPointerException npe) {
            this.frame.showErrorDialog("\u521d\u671f\u30d1\u30ba\u30eb\u30c7\u30fc\u30bf\u306e\u89e3\u51cd\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + BR + npe.toString());
        }
    }

    private void outFromSelfJarToWork(String targetName) throws IOException, NullPointerException {
        FDBFileIO.outFromJarToFolder(this.selfJarFile, targetName, this.workFolder);
    }

    public static void outFromJarToFolder(JarFile jarFile, String targetName, File folder) throws IOException, NullPointerException {
        FDBFileIO.outFromJarToFolder(jarFile, targetName, folder, targetName);
    }

    public static void outFromJarToFolder(JarFile jarFile, String targetInJar, File folder, String targetInFolder) throws IOException, NullPointerException {
        int b;
        JarEntry jarEntry = new JarEntry(targetInJar);
        File outFile = new File(String.valueOf(folder.getPath()) + SEP + targetInFolder);
        File parent = outFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        BufferedInputStream bis = new BufferedInputStream(jarFile.getInputStream(jarEntry));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outFile));
        while ((b = bis.read()) != -1) {
            bos.write((byte)b);
        }
        bis.close();
        bos.close();
    }

    public void deleteWorkFolder() {
        if (this.workFolder.exists()) {
            FDBFileIO.deleteInnerFiles(this.workFolder, true);
        }
    }

    public void deleteWorkFiles() {
        FDBFileIO.deleteInnerFiles(this.workFolder, false);
    }

    public File getWorkFile(String target) {
        return new File(String.valueOf(this.workFolder.getPath()) + SEP + target);
    }

    public File setSelfJarFile(String defFileName) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL classURL = classLoader.getResource(String.valueOf(this.getClass().getName()) + ".class");
            JarURLConnection jarConn = (JarURLConnection)classURL.openConnection();
            URL jarURL = jarConn.getJarFileURL();
            this.selfJarFile = new JarFile(jarURL.toURI().getPath());
            return new File(jarURL.toURI().getPath());
        }
        catch (Exception e) {
            try {
                this.selfJarFile = new JarFile(String.valueOf(System.getProperty("user.dir")) + SEP + defFileName);
                return new File(String.valueOf(System.getProperty("user.dir")) + SEP + defFileName);
            }
            catch (IOException ioe) {
                this.selfJarFile = null;
                return null;
            }
        }
    }

    public JarFile getSelfJarFile() {
        return this.selfJarFile;
    }

    public void closeSelfJarFile() {
        if (this.selfJarFile != null) {
            try {
                this.selfJarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean checkEntryExtention(JarEntry entry, String ... extentions) {
        String name = entry.getName();
        int e = 0;
        while (e < extentions.length) {
            if (name.lastIndexOf(extentions[e]) == name.length() - extentions[e].length()) {
                return true;
            }
            ++e;
        }
        return false;
    }

    public String checkDefaultStageFileInWorkFolder() {
        if (FDBSetFile.checkFirstDefaultData(this.getStageData(0))) {
            return "\uff08\u00d7\uff09";
        }
        return "\uff08\u25cb\uff09";
    }

    public String checkFileInWorkFolder(String fileName) {
        File file = this.getWorkFile(fileName);
        if (file.exists()) {
            return "\uff08\u25cb\uff09";
        }
        return "\uff08\u00d7\uff09";
    }

    private static void deleteInnerFiles(File dir, boolean selfDeleteFlag) {
        String[] list = dir.list();
        int l = 0;
        while (l < list.length) {
            File file = new File(String.valueOf(dir.getPath()) + SEP + list[l]);
            if (file.isFile()) {
                file.delete();
            } else {
                FDBFileIO.deleteInnerFiles(file, true);
            }
            ++l;
        }
        if (selfDeleteFlag) {
            dir.delete();
        }
    }

    public static boolean copyFile(File before, File after) throws IOException {
        int b;
        if (!before.exists() || before.isDirectory()) {
            return false;
        }
        if (after.isDirectory()) {
            return false;
        }
        File dir = after.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            return false;
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(before));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(after));
        while ((b = bis.read()) != -1) {
            bos.write((byte)b);
        }
        bis.close();
        bos.close();
        return true;
    }

    public void load() {
        File file = this.chooseFileOnLoad("\u8a2d\u5b9a\u683c\u7d0d\u30d5\u30a1\u30a4\u30eb(*.zip)\u3092\u958b\u304f", "\u958b\u304f", this.saveFile);
        if (file != null) {
            if (!FDBFileIO.checkOpenableFile(file)) {
                this.frame.showErrorDialog("\u3053\u308c\u306fFullDirectionBB\u306e\u30bb\u30fc\u30d6\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093" + BR + file.getName());
                return;
            }
            this.deleteWorkFiles();
            this.zipToWork(file);
            this.saveFile = file;
            this.changed = false;
            this.frame.setTitleString();
            this.frame.restartPuzzle(true);
        }
    }

    private static boolean checkOpenableFile(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            boolean setFlag = false;
            boolean cipherFlag = false;
            Enumeration<? extends ZipEntry> enm = zipFile.entries();
            while (enm.hasMoreElements()) {
                String entryName = enm.nextElement().getName();
                if (entryName.equals(SET_FILE)) {
                    setFlag = true;
                    continue;
                }
                if (!entryName.equals("fdbcipher.txt")) continue;
                cipherFlag = true;
            }
            zipFile.close();
            return setFlag && !cipherFlag;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void save() {
        if (this.saveFile != null) {
            this.savePuzzleData(this.saveFile);
        } else {
            this.saveAs();
        }
    }

    public void saveAs() {
        File file = this.chooseFileOnSave("\u8a2d\u5b9a\u683c\u7d0d\u30d5\u30a1\u30a4\u30eb(*.zip)\u306b\u4fdd\u5b58", "\u4fdd\u5b58", this.saveFile, "zip");
        if (file != null) {
            this.savePuzzleData(file);
        }
    }

    private void savePuzzleData(File file) {
        this.workToZip(file);
        this.saveFile = file;
        this.changed = false;
        this.frame.setTitleString();
    }

    public void workToZip(File fileZip) {
        try {
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(fileZip)));
            this.filesToZip(this.workFolder, zos);
            zos.close();
        }
        catch (IOException ioe) {
            this.frame.showErrorDialog("\u30bb\u30fc\u30d6\uff08ZIP\u5727\u7e2e\uff09\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + BR + ioe.toString());
        }
    }

    private void filesToZip(File outFolder, ZipOutputStream zos) throws IOException {
        String[] outFilesList = outFolder.list();
        int f = 0;
        while (f < outFilesList.length) {
            File outFile = new File(String.valueOf(outFolder.getPath()) + SEP + outFilesList[f]);
            if (outFile.isFile()) {
                this.fileToZipEntry(outFile, zos);
            } else if (outFile.isDirectory()) {
                this.filesToZip(outFile, zos);
            }
            ++f;
        }
    }

    private void fileToZipEntry(File outFile, ZipOutputStream zos) throws IOException {
        int b;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(outFile));
        ZipEntry outEntry = new ZipEntry(outFile.getPath().substring(this.workFolder.getPath().length() + 1));
        zos.putNextEntry(outEntry);
        while ((b = bis.read()) != -1) {
            zos.write((byte)b);
        }
        zos.closeEntry();
        bis.close();
    }

    public void zipToWork(File fileZip) {
        try {
            ZipFile zipFile = new ZipFile(fileZip);
            Enumeration<? extends ZipEntry> enm = zipFile.entries();
            while (enm.hasMoreElements()) {
                ZipEntry zipEntry = enm.nextElement();
                this.zipEntryToFile(zipFile, zipEntry);
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            this.frame.showErrorDialog("\u30ed\u30fc\u30c9\uff08ZIP\u89e3\u51cd\uff09\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + BR + ioe.toString());
        }
    }

    private void zipEntryToFile(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        File outFile = this.getWorkFile(zipEntry.getName());
        if (outFile.isDirectory()) {
            outFile.mkdirs();
        } else {
            int b;
            File parentFolder = new File(outFile.getParent());
            parentFolder.mkdirs();
            BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outFile));
            while ((b = bis.read()) != -1) {
                bos.write((byte)b);
            }
            bis.close();
            bos.close();
        }
    }

    public AudioClip getSoundFile(String target, boolean outFlag) {
        if (outFlag) {
            File soundFile = this.getWorkFile(target);
            if (soundFile.exists()) {
                try {
                    return Applet.newAudioClip(soundFile.toURI().toURL());
                }
                catch (MalformedURLException exception) {
                    return Applet.newAudioClip(this.getClass().getResource(target));
                }
            }
            return Applet.newAudioClip(this.getClass().getResource(target));
        }
        return Applet.newAudioClip(this.getClass().getResource(target));
    }

    public Image getImageFile(String target, boolean outFlag) {
        if (outFlag) {
            Image image = Toolkit.getDefaultToolkit().getImage(String.valueOf(this.workFolder.getPath()) + SEP + target);
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(image, 0);
            try {
                mt.waitForID(0);
            }
            catch (InterruptedException e) {
                return null;
            }
            return image;
        }
        return new ImageIcon(this.getClass().getResource(target)).getImage();
    }

    public File chooseFileOnSave(String title, String button, File path, String ... extension) {
        int ret;
        this.chooser.setFileSelectionMode(0);
        if (path != null) {
            this.chooser.setSelectedFile(path);
        } else {
            this.chooser.setSelectedFile(new File(String.valueOf(System.getProperty("user.dir")) + SEP + "."));
        }
        this.chooser.setDialogTitle(title);
        block5: while ((ret = this.chooser.showDialog(this.frame, button)) == 0) {
            File f = this.chooser.getSelectedFile();
            if (extension.length > 0) {
                f = FDBFileIO.addExtension(f, extension);
            }
            if (f.exists()) {
                switch (JOptionPane.showConfirmDialog(this.frame, String.valueOf(f.getName()) + " \u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002" + BR + "\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b\uff1f", "\u78ba\u8a8d", 1)) {
                    case 0: {
                        return f;
                    }
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return null;
                    }
                }
                return null;
            }
            return f;
        }
        return null;
    }

    public File chooseFileOnLoad(String title, String button, File path) {
        this.chooser.setFileSelectionMode(0);
        if (path != null) {
            this.chooser.setSelectedFile(path);
        } else {
            this.chooser.setSelectedFile(new File(String.valueOf(System.getProperty("user.dir")) + SEP + "."));
        }
        this.chooser.setDialogTitle(title);
        int ret = this.chooser.showDialog(this.frame, button);
        if (ret == 0) {
            File f = this.chooser.getSelectedFile();
            if (f.exists()) {
                return f;
            }
            this.frame.showErrorDialog("\u5b58\u5728\u3057\u306a\u3044\u30d5\u30a1\u30a4\u30eb\u3067\u3059");
            return null;
        }
        return null;
    }

    public File chooseFolder(String title, String button, File path) {
        this.chooser.setFileSelectionMode(1);
        if (path != null) {
            this.chooser.setSelectedFile(path);
        } else {
            this.chooser.setSelectedFile(new File(String.valueOf(System.getProperty("user.dir")) + SEP + "."));
        }
        this.chooser.resetChoosableFileFilters();
        this.chooser.setDialogTitle(title);
        int ret = this.chooser.showDialog(this.frame, button);
        if (ret == 0) {
            return this.chooser.getSelectedFile();
        }
        return null;
    }

    private static File addExtension(File file, String ... extension) {
        int period = file.getPath().lastIndexOf(".");
        if (period != -1) {
            int e = 0;
            while (e < extension.length) {
                if (file.getPath().substring(period).equals("." + extension[e])) {
                    return file;
                }
                ++e;
            }
            return new File(String.valueOf(file.getPath()) + "." + extension[0]);
        }
        return new File(String.valueOf(file.getPath()) + "." + extension[0]);
    }

    public static boolean makeTextFile(File file, String data) throws IOException {
        if (data == null) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            return false;
        }
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        pw.print(data);
        pw.close();
        return true;
    }

    public String[] getFileStringInJar(String fileOrder) {
        try {
            String str;
            InputStream is = this.getClass().getResourceAsStream(fileOrder);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            ArrayList<String> array = new ArrayList<String>();
            while ((str = br.readLine()) != null) {
                array.add(str);
            }
            br.close();
            String[] ret = new String[array.size()];
            int i = 0;
            while (i < ret.length) {
                ret[i] = (String)array.get(i);
                ++i;
            }
            return ret;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public String[] getFileString(String fileOrderInWork) {
        File file = this.getWorkFile(fileOrderInWork);
        return FDBFileIO.getFileString(file);
    }

    public static String[] getFileString(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            String line;
            ArrayList<String> stringArray = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                stringArray.add(line);
            }
            br.close();
            String[] ret = new String[stringArray.size()];
            int i = 0;
            while (i < stringArray.size()) {
                ret[i] = (String)stringArray.get(i);
                ++i;
            }
            return ret;
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

