/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FDBNumSizeDialog
extends JDialog
implements ChangeListener,
ActionListener {
    FDBFrame frame;
    FDBFileIO fileIO;
    SpinnerNumberModel stageNum = new SpinnerNumberModel(1, 1, 30, 1);
    SpinnerNumberModel puzzleWidth = new SpinnerNumberModel((Number)600, Integer.valueOf(400), null, (Number)10);
    SpinnerNumberModel puzzleHeight = new SpinnerNumberModel((Number)500, Integer.valueOf(300), null, (Number)10);
    JTextField fieldWidth = new JTextField(3);
    JTextField fieldHeight = new JTextField(3);
    JButton buttonOk = new JButton("\u4e86\u89e3");
    JButton buttonCancel = new JButton("\u53d6\u6d88");
    boolean newPuzzle = false;

    public FDBNumSizeDialog(FDBFrame frm, FDBFileIO fIO) {
        super(frm, "*****", true);
        this.frame = frm;
        this.fileIO = fIO;
        this.fieldWidth.setEditable(false);
        this.fieldHeight.setEditable(false);
        JPanel panelNum = new JPanel();
        panelNum.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u30b9\u30c6\u30fc\u30b8\u6570(30\u500b\u307e\u3067)"));
        panelNum.add(new JSpinner(this.stageNum));
        JPanel panelPuzzleSize = new JPanel();
        panelPuzzleSize.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u5168\u4f53\u30b5\u30a4\u30ba\uff08400\u00d7300\u4ee5\u4e0a\uff09"));
        panelPuzzleSize.add(new JLabel("\u6a2a"));
        panelPuzzleSize.add(new JSpinner(this.puzzleWidth));
        panelPuzzleSize.add(new JLabel("\u00d7\u7e26"));
        panelPuzzleSize.add(new JSpinner(this.puzzleHeight));
        panelPuzzleSize.add(new JLabel("\u30d4\u30af\u30bb\u30eb"));
        JPanel panelFieldSize = new JPanel();
        panelFieldSize.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u30b5\u30a4\u30ba(\u81ea\u52d5\u8a08\u7b97)"));
        panelFieldSize.add(new JLabel("\u6a2a"));
        panelFieldSize.add(this.fieldWidth);
        panelFieldSize.add(new JLabel("\u00d7\u7e26"));
        panelFieldSize.add(this.fieldHeight);
        panelFieldSize.add(new JLabel("\u30d4\u30af\u30bb\u30eb"));
        JPanel panelBtn = new JPanel();
        panelBtn.add(this.buttonOk);
        panelBtn.add(this.buttonCancel);
        JPanel panelSet = new JPanel();
        panelSet.setLayout(new GridLayout(3, 1));
        panelSet.add(panelNum);
        panelSet.add(panelPuzzleSize);
        panelSet.add(panelFieldSize);
        this.setLayout(new BorderLayout());
        this.add((Component)panelSet, "Center");
        this.add((Component)panelBtn, "South");
        this.calcWholeSize();
        this.puzzleWidth.addChangeListener(this);
        this.puzzleHeight.addChangeListener(this);
        this.buttonOk.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void formatData() {
        this.stageNum.setValue(1);
        this.puzzleWidth.setValue(600);
        this.puzzleHeight.setValue(500);
        this.calcWholeSize();
        this.newPuzzle = true;
        this.setTitle("\u65b0\u898f\u4f5c\u6210");
    }

    public void setLatestData(int stg, Dimension size) {
        this.stageNum.setValue(stg);
        this.puzzleWidth.setValue(size.width);
        this.puzzleHeight.setValue(size.height);
        this.calcWholeSize();
        this.newPuzzle = false;
        this.setTitle("\u30b9\u30c6\u30fc\u30b8\u6570\u30fb\u30b5\u30a4\u30ba");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.calcWholeSize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.buttonOk) {
            if (this.newPuzzle) {
                this.fileIO.deleteWorkFiles();
            }
            int stg = Integer.parseInt(this.stageNum.getValue().toString());
            this.frame.changeDefaultSetting(stg, this.newPuzzle);
            int w = Integer.parseInt(this.puzzleWidth.getValue().toString());
            int h = Integer.parseInt(this.puzzleHeight.getValue().toString());
            this.frame.changeBaseSetting(new Dimension(w, h), this.newPuzzle);
            this.fileIO.changePuzzle(this.newPuzzle);
            this.frame.restartPuzzle(true);
            this.setVisible(false);
        } else if (object == this.buttonCancel) {
            this.setVisible(false);
        }
    }

    private void calcWholeSize() {
        int w = Integer.parseInt(this.puzzleWidth.getValue().toString());
        int h = Integer.parseInt(this.puzzleHeight.getValue().toString());
        this.fieldWidth.setText("" + (w - 30));
        this.fieldHeight.setText("" + (h - 75 - 45));
    }
}

