/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Point;

public class FDBBall {
    static final int R_CONTINUE = 0;
    static final int R_BALL_OUT = 1;
    static final int R_GAME_OVER = 2;
    static final int R_STAGE_CLEAR = 3;
    int count;
    int speedNormal;
    int speedFast;
    int speedSlow;
    int speedNow;
    int radiusNormal;
    int radiusBig;
    int radiusSmall;
    int radiusNow;
    Color color;
    int effectRate;
    int combo;
    int posX;
    int posY;
    double angle;
    int oldPosX;
    int oldPosY;
    double oldAngle;
    int addX;
    int addY;
    int stageStartCount;

    public FDBBall(FDBBall ball, int all, int num) {
        this.count = ball.count;
        this.speedNormal = ball.speedNormal;
        this.speedFast = ball.speedFast;
        this.speedSlow = ball.speedSlow;
        this.speedNow = ball.speedNow;
        this.radiusNormal = ball.radiusNormal;
        this.radiusBig = ball.radiusBig;
        this.radiusSmall = ball.radiusSmall;
        this.radiusNow = ball.radiusNow;
        this.color = ball.color;
        this.effectRate = ball.effectRate;
        this.combo = 0;
        this.posX = ball.posX;
        this.posY = ball.posY;
        this.angle = FDBBall.controlAngle(ball.angle + Math.PI * 2 * (double)(num + 1) / (double)(all + 1));
        this.oldPosX = this.posX;
        this.oldPosY = this.posY;
        this.oldAngle = this.angle;
        this.stageStartCount = ball.stageStartCount;
    }

    public FDBBall(FDBStageLoader stage) {
        this.formatBall(stage);
    }

    public void formatBall(FDBStageLoader stage) {
        if (stage.s1.ballCount != -2) {
            this.count = stage.s1.ballCount;
        }
        this.speedNormal = stage.s1.ballSpeed;
        this.speedFast = this.speedNormal * 3 / 2;
        this.speedSlow = this.speedNormal * 2 / 3;
        this.speedNow = this.speedNormal;
        this.radiusNormal = stage.s1.ballRadius;
        this.radiusBig = this.radiusNormal * 3 / 2;
        this.radiusSmall = this.radiusNormal * 2 / 3;
        this.radiusNow = this.radiusNormal;
        this.color = stage.s1.ballColor;
        this.effectRate = stage.s1.powerEffect;
        this.combo = 0;
        this.stageStartCount = this.count;
    }

    public void setBallPosition(int fieldWidth, int fieldHeight, FDBBars bars) {
        double fazzy = 0.2617993877991494;
        if (!bars.directionFlag[1]) {
            this.posX = bars.barPosX;
            this.posY = fieldHeight - bars.barOverhang - this.radiusNow;
            this.angle = 4.71238898038469 + fazzy;
        } else if (!bars.directionFlag[3]) {
            this.posX = fieldWidth - bars.barOverhang - this.radiusNow;
            this.posY = bars.barPosY;
            this.angle = Math.PI + fazzy;
        } else if (!bars.directionFlag[0]) {
            this.posX = bars.barPosX;
            this.posY = bars.barOverhang + this.radiusNow;
            this.angle = 1.5707963267948966 + fazzy;
        } else if (!bars.directionFlag[2]) {
            this.posX = bars.barOverhang + this.radiusNow;
            this.posY = bars.barPosY;
            this.angle = 0.0 + fazzy;
        } else {
            this.posX = fieldWidth / 2;
            this.posY = fieldHeight - this.radiusNow;
            this.angle = 4.71238898038469 + fazzy;
        }
        this.oldPosX = this.posX;
        this.oldPosY = this.posY;
        this.oldAngle = this.angle;
    }

    public String getCountString() {
        if (this.count > 0) {
            return String.valueOf(this.count - 1);
        }
        if (this.count == 0) {
            return "-";
        }
        return "\u221e";
    }

    public void operateLifeFromItem(int typePair) {
        if (this.count < 0) {
            return;
        }
        if (typePair == 0) {
            ++this.count;
        } else if (this.count > 1) {
            --this.count;
        }
    }

    public void receiveRepelPower(Point repelPoint) {
        if (repelPoint == null) {
            return;
        }
        if (this.effectRate >= 0) {
            double relativeAngle = FDBBall.controlRelativeAngle(Math.atan2(this.posY - repelPoint.y, this.posX - repelPoint.x) - this.angle);
            this.angle += relativeAngle * (double)this.effectRate / 1000.0;
        } else {
            double relativeAngle = FDBBall.controlRelativeAngle(Math.atan2(repelPoint.y - this.posY, repelPoint.x - this.posX) - this.angle);
            this.angle -= relativeAngle * (double)this.effectRate / 1000.0;
        }
    }

    public int move(int fieldWidth, int fieldHeight, FDBBlocks blocks, FDBBars bars, FDBGeneral general, FDBItemManager items, FDBSound sounds) {
        int blockTouchResult;
        this.addX = (int)((double)this.speedNow * Math.cos(this.angle));
        this.addY = (int)((double)this.speedNow * Math.sin(this.angle));
        if (this.posX + this.addX < bars.barOverhang + this.radiusNow) {
            if (bars.directionFlag[2]) {
                if (this.posX + this.addX < this.radiusNow) {
                    this.wallReflexLeft(sounds);
                }
            } else if (this.posX + this.addX < -this.radiusNow) {
                if (Math.abs(this.posY + this.addY - bars.barPosY) > bars.barLength / 2) {
                    if (items.effectiveItemArr[5] == null) {
                        return this.ballOut();
                    }
                    this.wallReflexLeft(sounds);
                } else if (!this.checkBarTouch(this.posX + this.addX, this.posY + this.addY, bars.barOverhang - bars.barRadius, bars.barPosY, this.radiusNow + bars.barRadius, sounds)) {
                    if (items.effectiveItemArr[5] == null) {
                        return this.ballOut();
                    }
                    this.wallReflexLeft(sounds);
                }
            } else if (!this.checkBarTouch(this.posX + this.addX, this.posY + this.addY, bars.barOverhang - bars.barRadius, bars.barPosY, this.radiusNow + bars.barRadius, sounds) && items.effectiveItemArr[5] != null && this.posX + this.addX < this.radiusNow) {
                this.wallReflexLeft(sounds);
            }
        } else if (this.posX + this.addX > fieldWidth - bars.barOverhang - this.radiusNow) {
            if (bars.directionFlag[3]) {
                if (this.posX + this.addX > fieldWidth - this.radiusNow) {
                    this.wallReflexRight(fieldWidth, sounds);
                }
            } else if (this.posX + this.addX > fieldWidth + this.radiusNow) {
                if (Math.abs(this.posY + this.addY - bars.barPosY) > bars.barLength / 2) {
                    if (items.effectiveItemArr[5] == null) {
                        return this.ballOut();
                    }
                    this.wallReflexRight(fieldWidth, sounds);
                } else if (!this.checkBarTouch(this.posX + this.addX, this.posY + this.addY, fieldWidth - bars.barOverhang + bars.barRadius, bars.barPosY, this.radiusNow + bars.barRadius, sounds)) {
                    if (items.effectiveItemArr[5] == null) {
                        return this.ballOut();
                    }
                    this.wallReflexRight(fieldWidth, sounds);
                }
            } else if (!this.checkBarTouch(this.posX + this.addX, this.posY + this.addY, fieldWidth - bars.barOverhang + bars.barRadius, bars.barPosY, this.radiusNow + bars.barRadius, sounds) && items.effectiveItemArr[5] != null && this.posX + this.addX > fieldWidth - this.radiusNow) {
                this.wallReflexRight(fieldWidth, sounds);
            }
        }
        if (this.posY + this.addY < bars.barOverhang + this.radiusNow) {
            if (bars.directionFlag[0]) {
                if (this.posY + this.addY < this.radiusNow) {
                    this.wallReflexUp(sounds);
                }
            } else if (this.posY + this.addY < -this.radiusNow) {
                if (Math.abs(this.posX + this.addX - bars.barPosX) > bars.barLength / 2) {
                    if (items.effectiveItemArr[5] == null) {
                        return this.ballOut();
                    }
                    this.wallReflexUp(sounds);
                } else if (!this.checkBarTouch(this.posX + this.addX, this.posY + this.addY, bars.barPosX, bars.barOverhang - bars.barRadius, this.radiusNow + bars.barRadius, sounds)) {
                    if (items.effectiveItemArr[5] == null) {
                        return this.ballOut();
                    }
                    this.wallReflexUp(sounds);
                }
            } else if (!this.checkBarTouch(this.posX + this.addX, this.posY + this.addY, bars.barPosX, bars.barOverhang - bars.barRadius, this.radiusNow + bars.barRadius, sounds) && items.effectiveItemArr[5] != null && this.posY + this.addY < this.radiusNow) {
                this.wallReflexUp(sounds);
            }
        } else if (this.posY + this.addY > fieldHeight - bars.barOverhang - this.radiusNow) {
            if (bars.directionFlag[1]) {
                if (this.posY + this.addY > fieldHeight - this.radiusNow) {
                    this.wallReflexDown(fieldHeight, sounds);
                }
            } else if (this.posY + this.addY > fieldHeight + this.radiusNow) {
                if (Math.abs(this.posX + this.addX - bars.barPosX) > bars.barLength / 2) {
                    if (items.effectiveItemArr[5] == null) {
                        return this.ballOut();
                    }
                    this.wallReflexDown(fieldHeight, sounds);
                } else if (!this.checkBarTouch(this.posX + this.addX, this.posY + this.addY, bars.barPosX, fieldHeight - bars.barOverhang + bars.barRadius, this.radiusNow + bars.barRadius, sounds)) {
                    if (items.effectiveItemArr[5] == null) {
                        return this.ballOut();
                    }
                    this.wallReflexDown(fieldHeight, sounds);
                }
            } else if (!this.checkBarTouch(this.posX + this.addX, this.posY + this.addY, bars.barPosX, fieldHeight - bars.barOverhang + bars.barRadius, this.radiusNow + bars.barRadius, sounds) && items.effectiveItemArr[5] != null && this.posY + this.addY > fieldHeight - this.radiusNow) {
                this.wallReflexDown(fieldHeight, sounds);
            }
        }
        if ((blockTouchResult = blocks.checkTouchBlock(this.posX, this.posY, this.addX, this.addY, this.radiusNow, items)) != 0) {
            this.addX = blocks.tmpAddX;
            this.addY = blocks.tmpAddY;
            if (this.oldPosX == this.posX && this.oldPosY == this.posY) {
                if (this.addX == 0 && this.addY == 0) {
                    this.angle = FDBBall.controlRelativeAngle(this.oldAngle - blocks.tmpReflectBaseAngle) >= 0.0 ? (this.angle -= 0.5235987755982988) : (this.angle += 0.5235987755982988);
                }
            } else if (items.effectiveItemArr[4] == null) {
                this.angle = FDBBall.calculateReflectAngle(this.angle, blocks.tmpReflectBaseAngle);
            }
            if (blockTouchResult != 2) {
                if (this.countBonus(general.addScore(this.combo))) {
                    sounds.playSE(2);
                }
                if (blockTouchResult == 4) {
                    items.addItem(this);
                    ++this.combo;
                    sounds.playSE(0);
                } else if (blockTouchResult == 3) {
                    ++this.combo;
                    sounds.playSE(0);
                } else if (blockTouchResult == 5) {
                    this.posX += this.addX;
                    this.posY += this.addY;
                    return 3;
                }
            } else {
                sounds.playSE(1);
            }
        }
        if (this.addX != 0 || this.addY != 0) {
            this.oldAngle = this.angle;
        }
        this.oldPosX = this.posX;
        this.oldPosY = this.posY;
        this.posX += this.addX;
        this.posY += this.addY;
        return 0;
    }

    public boolean countBonus(boolean f) {
        if (f && this.count > 0) {
            ++this.count;
            return true;
        }
        return false;
    }

    private int ballOut() {
        this.posX += this.addX;
        this.posY += this.addY;
        if (this.count > 0) {
            --this.count;
            if (this.count == 0) {
                return 2;
            }
            return 1;
        }
        if (this.count < 0) {
            return 1;
        }
        return 2;
    }

    private void wallReflexLeft(FDBSound sounds) {
        if (this.addX != 0) {
            this.addY = this.addY * (this.radiusNow - this.posX) / this.addX;
            this.addX = this.radiusNow - this.posX;
        } else {
            this.addY = this.addX;
        }
        this.angle = FDBBall.calculateReflectAngle(this.angle, 0.0);
        sounds.playSE(1);
    }

    private void wallReflexRight(int fieldWidth, FDBSound sounds) {
        if (this.addX != 0) {
            this.addY = this.addY * (fieldWidth - this.radiusNow - this.posX) / this.addX;
            this.addX = fieldWidth - this.radiusNow - this.posX;
        } else {
            this.addY = this.addX;
        }
        this.angle = FDBBall.calculateReflectAngle(this.angle, Math.PI);
        sounds.playSE(1);
    }

    private void wallReflexUp(FDBSound sounds) {
        if (this.addY != 0) {
            this.addX = this.addX * (this.radiusNow - this.posY) / this.addY;
            this.addY = this.radiusNow - this.posY;
        } else {
            this.addX = this.addY;
        }
        this.angle = FDBBall.calculateReflectAngle(this.angle, 1.5707963267948966);
        sounds.playSE(1);
    }

    private void wallReflexDown(int fieldHeight, FDBSound sounds) {
        if (this.addY != 0) {
            this.addX = this.addX * (fieldHeight - this.radiusNow - this.posY) / this.addY;
            this.addY = fieldHeight - this.radiusNow - this.posY;
        } else {
            this.addX = this.addY;
        }
        this.angle = FDBBall.calculateReflectAngle(this.angle, 4.71238898038469);
        sounds.playSE(1);
    }

    private boolean checkBarTouch(int ballX, int ballY, int barX, int barY, int touchRadius, FDBSound sounds) {
        int distX = ballX - barX;
        int distY = ballY - barY;
        double distNow = Math.sqrt(Math.pow(distX, 2.0) + Math.pow(distY, 2.0));
        if (distNow <= (double)touchRadius) {
            if (distNow != 0.0) {
                this.addX = (int)((double)barX + (double)(distX * touchRadius) / distNow - (double)this.posX);
                this.addY = (int)((double)barY + (double)(distY * touchRadius) / distNow - (double)this.posY);
                this.angle = FDBBall.calculateReflectAngle(this.angle, Math.atan2(distY, distX));
            } else {
                this.addX = this.addX * (this.speedNow - touchRadius) / this.speedNow;
                this.addY = this.addY * (this.speedNow - touchRadius) / this.speedNow;
                this.angle = FDBBall.controlAngle(this.angle + Math.PI);
            }
            this.combo = 0;
            sounds.playSE(1);
            return true;
        }
        return false;
    }

    public static double calculateReflectAngle(double angleBefore, double reflectBaseAngle) {
        double relativeAngle = FDBBall.controlRelativeAngle(reflectBaseAngle - angleBefore);
        if (relativeAngle >= 0.0) {
            return FDBBall.controlAngle(angleBefore + 2.0 * (relativeAngle - 1.5707963267948966));
        }
        return FDBBall.controlAngle(angleBefore + 2.0 * (relativeAngle + 1.5707963267948966));
    }

    private static double controlAngle(double angleBefore) {
        double angleAfter = angleBefore;
        if (angleAfter < 0.0) {
            while ((angleAfter += Math.PI * 2) < 0.0) {
            }
        } else if (angleAfter >= Math.PI * 2) {
            while ((angleAfter -= Math.PI * 2) >= Math.PI * 2) {
            }
        }
        return angleAfter;
    }

    private static double controlRelativeAngle(double relativeAngle) {
        if (relativeAngle > Math.PI) {
            return relativeAngle - Math.PI * 2;
        }
        if (relativeAngle < -Math.PI) {
            return relativeAngle + Math.PI * 2;
        }
        return relativeAngle;
    }
}

