/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FDBBlockDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
WindowListener {
    private static final int L_ALL = 0;
    private static final int L_DEFAULT = 1;
    private static final int L_FIRSTSTAGE = 2;
    FDBFrame frame;
    FDBFileIO fileIO;
    DefaultListModel<String> listModelStage = new DefaultListModel();
    JList<String> listStage = new JList<String>(this.listModelStage);
    JButton buttonDelete = new JButton("\u6307\u5b9a\u524a\u9664");
    JButton buttonFolder = new JButton("\u30d5\u30a9\u30eb\u30c0\u9078\u629e");
    JButton buttonFile = new JButton("\u30d5\u30a1\u30a4\u30eb\u9078\u629e");
    JButton buttonEnd = new JButton("\u7d42\u4e86");
    int selected;

    public FDBBlockDialog(FDBFrame frm, FDBFileIO fIO) {
        super(frm, "\u30d6\u30ed\u30c3\u30af\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f", true);
        this.frame = frm;
        this.fileIO = fIO;
        this.makeStageList(30);
        JPanel panelStage = new JPanel();
        JScrollPane scPanel = new JScrollPane(this.listStage);
        scPanel.setPreferredSize(new Dimension(150, 150));
        panelStage.add(scPanel);
        JPanel panelBtn = new JPanel();
        panelBtn.add(this.buttonDelete);
        panelBtn.add(this.buttonFolder);
        panelBtn.add(this.buttonFile);
        panelBtn.add(this.buttonEnd);
        this.setLayout(new BorderLayout());
        this.add((Component)panelStage, "Center");
        this.add((Component)panelBtn, "South");
        this.listStage.addListSelectionListener(this);
        this.buttonDelete.addActionListener(this);
        this.buttonFolder.addActionListener(this);
        this.buttonFile.addActionListener(this);
        this.buttonEnd.addActionListener(this);
        this.addWindowListener(this);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void makeStageList(int num) {
        this.listModelStage.clear();
        this.listModelStage.addElement("\u307e\u3068\u3081\u3066\u6307\u5b9a");
        this.listModelStage.addElement("default" + this.fileIO.checkFileInWorkFolder(FDBFileIO.getTargetBlockFileName(0)));
        int n = 1;
        while (n <= num) {
            this.listModelStage.addElement("stage " + n + this.fileIO.checkFileInWorkFolder(FDBFileIO.getTargetBlockFileName(n)));
            ++n;
        }
        this.listStage.setSelectedIndex(0);
        this.selected = 0;
        this.enableSelectButton();
    }

    private void changeSelectedListElement() {
        if (this.selected != 0) {
            if (this.selected == 1) {
                this.listModelStage.set(0, "default" + this.fileIO.checkFileInWorkFolder(FDBFileIO.getTargetBlockFileName(0)));
            } else {
                this.listModelStage.set(this.selected, "stage " + (this.selected - 1) + this.fileIO.checkFileInWorkFolder(FDBFileIO.getTargetBlockFileName(this.selected - 1)));
            }
        }
    }

    public void setLatestData(int stg) {
        this.makeStageList(stg);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.buttonDelete) {
            this.fileIO.deleteBlockFile(this.selected - 1);
            this.changeSelectedListElement();
            this.fileIO.changePuzzle(false);
        } else if (object == this.buttonFolder) {
            File folder = this.fileIO.chooseFolder("\u30d6\u30ed\u30c3\u30af\u914d\u7f6e\u304c\u5165\u3063\u305f\u30d5\u30a9\u30eb\u30c0\u3092\u9078\u629e", "\u9078\u629e", null);
            if (folder != null) {
                int stg = this.listModelStage.getSize() - 2;
                this.fileIO.copyBlockFiles(folder, stg);
                this.makeStageList(stg);
                this.fileIO.changePuzzle(false);
            }
        } else if (object == this.buttonFile) {
            File file = this.fileIO.chooseFileOnLoad("\u30d6\u30ed\u30c3\u30af\u914d\u7f6e\u30d5\u30a1\u30a4\u30eb(*.csv)\u3092\u9078\u629e", "\u9078\u629e", null);
            if (file != null) {
                this.fileIO.copyBlockFile(this.selected - 1, file);
                this.changeSelectedListElement();
                this.fileIO.changePuzzle(false);
            }
        } else if (object == this.buttonEnd) {
            this.frame.restartPuzzle(true);
            this.setVisible(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int f = this.listStage.getMinSelectionIndex();
        int l = this.listStage.getMaxSelectionIndex();
        if (f == this.selected) {
            this.listStage.setSelectedIndex(l);
            this.selected = l;
        } else {
            this.listStage.setSelectedIndex(f);
            this.selected = f;
        }
        this.enableSelectButton();
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.frame.restartPuzzle(true);
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    private void enableSelectButton() {
        if (this.selected == 0) {
            this.buttonFolder.setEnabled(true);
            this.buttonFile.setEnabled(false);
        } else {
            this.buttonFolder.setEnabled(false);
            this.buttonFile.setEnabled(true);
        }
    }
}

