/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.util.StringTokenizer;

public class FDBBlocks {
    static final int T_NO_TOUCH = 0;
    static final int T_TOUCH = 1;
    static final int T_TOUCH_UNBREAKABLE = 2;
    static final int T_TOUCH_DECREASE = 3;
    static final int T_TOUCH_BREAK_NOT_CLEAR = 4;
    static final int T_TOUCH_BREAK_CLEAR = 5;
    int horizontalNum;
    int verticalNum;
    int[] cornerX;
    int[] cornerY;
    int restBreakableBlockStart;
    int restBreakableBlockNow;
    int clearBlockNum;
    int[][] blockColor;
    int[][] blockResistStart;
    int[][] blockResistNow;
    int tmpAddX;
    int tmpAddY;
    double tmpReflectBaseAngle;

    public FDBBlocks(FDBStageLoader stage, int fieldWidth, int fieldHeight) {
        this.formatBlocks(stage, fieldWidth, fieldHeight);
    }

    public void formatBlocks(FDBStageLoader stage, int fieldWidth, int fieldHeight) {
        StringTokenizer horizCut = new StringTokenizer(stage.stageBlocksPlace[0], ",");
        this.horizontalNum = horizCut.countTokens();
        this.verticalNum = stage.stageBlocksPlace.length;
        this.cornerX = new int[this.horizontalNum + 1];
        int blockFieldStart = stage.s1.direction[2] ? 0 : stage.s1.barsOverhang + stage.s1.frontLine;
        int blockFieldSize = stage.s1.direction[3] ? fieldWidth - blockFieldStart : fieldWidth - stage.s1.barsOverhang - stage.s1.frontLine - blockFieldStart;
        int h = 0;
        while (h <= this.horizontalNum) {
            this.cornerX[h] = blockFieldStart + blockFieldSize * h / this.horizontalNum;
            ++h;
        }
        this.cornerY = new int[this.verticalNum + 1];
        blockFieldStart = stage.s1.direction[0] ? 0 : stage.s1.barsOverhang + stage.s1.frontLine;
        if (stage.s1.direction[1]) {
            blockFieldSize = fieldHeight - blockFieldStart;
            if (stage.s1.direction[2] && stage.s1.direction[3] && stage.s1.direction[0]) {
                blockFieldSize -= 3 * stage.s1.ballRadius;
            }
        } else {
            blockFieldSize = fieldHeight - stage.s1.barsOverhang - stage.s1.frontLine - blockFieldStart;
        }
        int v = 0;
        while (v <= this.verticalNum) {
            this.cornerY[v] = blockFieldStart + blockFieldSize * v / this.verticalNum;
            ++v;
        }
        this.restBreakableBlockStart = 0;
        this.blockColor = new int[this.horizontalNum][this.verticalNum];
        this.blockResistStart = new int[this.horizontalNum][this.verticalNum];
        this.blockResistNow = new int[this.horizontalNum][this.verticalNum];
        h = 0;
        while (h < this.horizontalNum) {
            int v2 = 0;
            while (v2 < this.verticalNum) {
                this.blockColor[h][v2] = 12;
                this.blockResistStart[h][v2] = 0;
                this.blockResistNow[h][v2] = 0;
                ++v2;
            }
            ++h;
        }
        v = 0;
        while (v < this.verticalNum) {
            horizCut = new StringTokenizer(stage.stageBlocksPlace[v], ",");
            int h2 = 0;
            while (h2 < this.horizontalNum) {
                if (horizCut.hasMoreTokens()) {
                    this.analyzeBlockData(horizCut.nextToken(), h2, v);
                }
                ++h2;
            }
            ++v;
        }
        this.restBreakableBlockNow = this.restBreakableBlockStart;
        this.clearBlockNum = this.restBreakableBlockStart * (100 - stage.s1.clearRate) / 100;
    }

    private void analyzeBlockData(String data, int h, int v) {
        if (data.length() != 2) {
            return;
        }
        String colorString = data.substring(0, 1);
        if (colorString.equals("w")) {
            this.blockColor[h][v] = 0;
        } else if (colorString.equals("y")) {
            this.blockColor[h][v] = 1;
        } else if (colorString.equals("o")) {
            this.blockColor[h][v] = 2;
        } else if (colorString.equals("m")) {
            this.blockColor[h][v] = 3;
        } else if (colorString.equals("r")) {
            this.blockColor[h][v] = 4;
        } else if (colorString.equals("t")) {
            this.blockColor[h][v] = 5;
        } else if (colorString.equals("k")) {
            this.blockColor[h][v] = 6;
        } else if (colorString.equals("g")) {
            this.blockColor[h][v] = 7;
        } else if (colorString.equals("l")) {
            this.blockColor[h][v] = 8;
        } else if (colorString.equals("a")) {
            this.blockColor[h][v] = 9;
        } else if (colorString.equals("p")) {
            this.blockColor[h][v] = 10;
        } else if (colorString.equals("b")) {
            this.blockColor[h][v] = 11;
        } else if (colorString.equals("n")) {
            this.blockColor[h][v] = 12;
        }
        try {
            this.blockResistStart[h][v] = Integer.parseInt(data.substring(1, 2));
            if (this.blockResistStart[h][v] > 4) {
                this.blockResistStart[h][v] = 4;
            }
            this.blockResistNow[h][v] = this.blockResistStart[h][v];
            if (this.blockResistStart[h][v] > 0 && this.blockResistStart[h][v] < 4 && this.blockColor[h][v] != 12) {
                ++this.restBreakableBlockStart;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean checkBlockBeing(int h, int v) {
        if (h < 0 || h >= this.horizontalNum || v < 0 || v >= this.verticalNum) {
            return false;
        }
        return this.blockColor[h][v] != 12 && this.blockResistNow[h][v] > 0;
    }

    public int checkTouchBlock(int posX, int posY, int addX, int addY, int radius, FDBItemManager items) {
        int touchBlockX = 0;
        int touchBlockY = 0;
        int ret = 0;
        this.tmpAddX = addX;
        this.tmpAddY = addY;
        int fX = addX >= 0 ? 1 : -1;
        int fY = addY >= 0 ? 1 : -1;
        Point startBlockPos = this.getBlockPos(posX - fX * radius, posY - fY * radius);
        Point endBlockPos = this.getBlockPos(posX + addX + fX * (radius + 1), posY + addY + fY * (radius + 1));
        int h = startBlockPos.x;
        while (!(fX < 0 ? h < endBlockPos.x : h > endBlockPos.x)) {
            int v = startBlockPos.y;
            while (!(fY < 0 ? v < endBlockPos.y : v > endBlockPos.y)) {
                block12: {
                    int pointX;
                    int pointY;
                    block20: {
                        block18: {
                            block22: {
                                int dY;
                                int dX;
                                block21: {
                                    block19: {
                                        block15: {
                                            block13: {
                                                block17: {
                                                    block16: {
                                                        block14: {
                                                            if (!this.checkBlockBeing(h, v)) break block12;
                                                            if (addX == 0) break block13;
                                                            dX = (fX < 0 ? this.cornerX[h + 1] - 1 : this.cornerX[h]) - (posX + fX * radius);
                                                            dY = addY * dX / addX;
                                                            if (posY + dY >= this.cornerY[v]) break block14;
                                                            pointY = this.cornerY[v];
                                                            break block15;
                                                        }
                                                        if (posY + dY <= this.cornerY[v + 1] - 1) break block16;
                                                        pointY = this.cornerY[v + 1] - 1;
                                                        break block15;
                                                    }
                                                    if (!(fX < 0 ? dX <= 0 : dX >= 0)) break block17;
                                                    if (this.renewFasterData(dX, dY, fX < 0 ? 0.0 : Math.PI, true)) {
                                                        touchBlockX = h;
                                                        touchBlockY = v;
                                                        ret = 1;
                                                    }
                                                    break block12;
                                                }
                                                pointY = fY < 0 ? this.cornerY[v + 1] - 1 : this.cornerY[v];
                                                break block15;
                                            }
                                            int n = pointY = fY < 0 ? this.cornerY[v + 1] - 1 : this.cornerY[v];
                                        }
                                        if (addY == 0) break block18;
                                        dY = (fY < 0 ? this.cornerY[v + 1] - 1 : this.cornerY[v]) - (posY + fY * radius);
                                        dX = addX * dY / addY;
                                        if (posX + dX >= this.cornerX[h]) break block19;
                                        pointX = this.cornerX[h];
                                        break block20;
                                    }
                                    if (posX + dX <= this.cornerX[h + 1] - 1) break block21;
                                    pointX = this.cornerX[h + 1] - 1;
                                    break block20;
                                }
                                if (!(fY < 0 ? dY <= 0 : dY >= 0)) break block22;
                                if (this.renewFasterData(dX, dY, fY < 0 ? 1.5707963267948966 : 4.71238898038469, true)) {
                                    touchBlockX = h;
                                    touchBlockY = v;
                                    ret = 1;
                                }
                                break block12;
                            }
                            pointX = fX < 0 ? this.cornerX[h + 1] - 1 : this.cornerX[h];
                            break block20;
                        }
                        int n = pointX = fX < 0 ? this.cornerX[h + 1] - 1 : this.cornerX[h];
                    }
                    if (this.checkTouchPoint(pointX, pointY, posX, posY, addX, addY, radius)) {
                        touchBlockX = h;
                        touchBlockY = v;
                        ret = 1;
                    }
                }
                v += fY;
            }
            h += fX;
        }
        if (ret == 1) {
            if (this.blockResistNow[touchBlockX][touchBlockY] >= 4) {
                return 2;
            }
            if (this.blockResistNow[touchBlockX][touchBlockY] >= 1) {
                if (items.effectiveItemArr[4] == null) {
                    int[] nArray = this.blockResistNow[touchBlockX];
                    int n = touchBlockY;
                    nArray[n] = nArray[n] - 1;
                } else {
                    this.blockResistNow[touchBlockX][touchBlockY] = 0;
                }
                if (this.blockResistNow[touchBlockX][touchBlockY] == 0) {
                    --this.restBreakableBlockNow;
                    if (this.restBreakableBlockNow <= this.clearBlockNum) {
                        return 5;
                    }
                    return 4;
                }
                return 3;
            }
            return 0;
        }
        return ret;
    }

    private boolean checkTouchPoint(int pointX, int pointY, int posX, int posY, int addX, int addY, int radius) {
        if (addX != 0) {
            double b = posY - pointY - addY * (posX - pointX) / addX;
            double A = 1.0 + Math.pow(addY, 2.0) / Math.pow(addX, 2.0);
            double B = (double)(2 * addY) * b / (double)addX;
            double C = Math.pow(b, 2.0) - Math.pow(radius, 2.0);
            double inRoot = Math.pow(B, 2.0) - 4.0 * A * C;
            if (inRoot < 0.0) {
                return false;
            }
            double ansX1 = (-B + Math.sqrt(inRoot)) / (2.0 * A);
            double ansX2 = (-B - Math.sqrt(inRoot)) / (2.0 * A);
            int dX1 = (int)((double)pointX + ansX1 - (double)posX);
            int dX2 = (int)((double)pointX + ansX2 - (double)posX);
            int dY1 = (int)((double)pointY + (ansX1 * (double)addY / (double)addX + b) - (double)posY);
            int dY2 = (int)((double)pointY + (ansX2 * (double)addY / (double)addX + b) - (double)posY);
            if ((addX < 0 ? dX1 <= 0 : dX1 >= 0) && Math.abs(dX1) <= Math.abs(addX)) {
                if ((addX < 0 ? dX2 <= 0 : dX2 >= 0) && Math.abs(dX2) <= Math.abs(addX)) {
                    if (Math.abs(dX1) < Math.abs(dX2)) {
                        return this.applyTouchPoint(pointX, pointY, posX, posY, dX1, dY1);
                    }
                    return this.applyTouchPoint(pointX, pointY, posX, posY, dX2, dY2);
                }
                return this.applyTouchPoint(pointX, pointY, posX, posY, dX1, dY1);
            }
            if ((addX < 0 ? dX2 <= 0 : dX2 >= 0) && Math.abs(dX2) <= Math.abs(addX)) {
                return this.applyTouchPoint(pointX, pointY, posX, posY, dX2, dY2);
            }
            return false;
        }
        int c = posX - pointX;
        double inRoot = Math.pow(radius, 2.0) - Math.pow(c, 2.0);
        if (inRoot < 0.0) {
            return false;
        }
        int dY1 = (int)((double)pointY + Math.sqrt(inRoot) - (double)posY);
        int dY2 = (int)((double)pointY - Math.sqrt(inRoot) - (double)posY);
        if ((addY < 0 ? dY1 <= 0 : dY1 >= 0) && Math.abs(dY1) <= Math.abs(addY)) {
            if ((addY < 0 ? dY2 <= 0 : dY2 >= 0) && Math.abs(dY2) <= Math.abs(addY)) {
                if (Math.abs(dY1) < Math.abs(dY2)) {
                    return this.applyTouchPoint(pointX, pointY, posX, posY, 0, dY1);
                }
                return this.applyTouchPoint(pointX, pointY, posX, posY, 0, dY2);
            }
            return this.applyTouchPoint(pointX, pointY, posX, posY, 0, dY1);
        }
        if ((addY < 0 ? dY2 <= 0 : dY2 >= 0) && Math.abs(dY2) <= Math.abs(addY)) {
            return this.applyTouchPoint(pointX, pointY, posX, posY, 0, dY2);
        }
        return false;
    }

    private boolean applyTouchPoint(int pointX, int pointY, int posX, int posY, int dX, int dY) {
        double reflectBaseAngle = Math.atan2(posY + dY - pointY, posX + dX - pointX);
        return this.renewFasterData(dX, dY, reflectBaseAngle, false);
    }

    private boolean renewFasterData(int dX, int dY, double reflectBaseAngle, boolean priorityFlag) {
        if (Math.abs(dX) < Math.abs(this.tmpAddX) || Math.abs(dY) < Math.abs(this.tmpAddY)) {
            this.tmpAddX = dX;
            this.tmpAddY = dY;
            this.tmpReflectBaseAngle = reflectBaseAngle;
            return true;
        }
        if (Math.abs(dX) == Math.abs(this.tmpAddX) && Math.abs(dY) == Math.abs(this.tmpAddY)) {
            if (priorityFlag) {
                this.tmpReflectBaseAngle = reflectBaseAngle;
                return true;
            }
            return false;
        }
        return false;
    }

    private Point getBlockPos(int posX, int posY) {
        Point ret = new Point();
        if (posX < this.cornerX[0]) {
            ret.x = -1;
        } else if (posX >= this.cornerX[this.horizontalNum]) {
            ret.x = this.horizontalNum;
        } else {
            ret.x = (posX - this.cornerX[0]) / (this.cornerX[1] - this.cornerX[0]);
            if (ret.x >= this.horizontalNum - 1) {
                ret.x = this.horizontalNum - 1;
            }
            if (this.cornerX[ret.x] > posX) {
                do {
                    --ret.x;
                } while (this.cornerX[ret.x] > posX);
            } else if (this.cornerX[ret.x + 1] <= posX) {
                do {
                    ++ret.x;
                } while (this.cornerX[ret.x + 1] <= posX);
            }
        }
        if (posY < this.cornerY[0]) {
            ret.y = -1;
        } else if (posY >= this.cornerY[this.verticalNum]) {
            ret.y = this.verticalNum;
        } else {
            ret.y = (posY - this.cornerY[0]) / (this.cornerY[1] - this.cornerY[0]);
            if (ret.y >= this.verticalNum - 1) {
                ret.y = this.verticalNum - 1;
            }
            if (this.cornerY[ret.y] > posY) {
                do {
                    --ret.y;
                } while (this.cornerY[ret.y] > posY);
            } else if (this.cornerY[ret.y + 1] <= posY) {
                do {
                    ++ret.y;
                } while (this.cornerY[ret.y + 1] <= posY);
            }
        }
        return ret;
    }

    public void operateBlockNumFormItem(int typePair, int num) {
        if (typePair == 0) {
            if (num > this.restBreakableBlockStart - this.restBreakableBlockNow) {
                num = this.restBreakableBlockStart - this.restBreakableBlockNow;
            }
            int rndX = (int)(Math.random() * (double)this.horizontalNum);
            int rndY = (int)(Math.random() * (double)this.verticalNum);
            while (num > 0) {
                if (this.blockResistStart[rndX][rndY] != 0 && this.blockResistNow[rndX][rndY] == 0) {
                    this.blockResistNow[rndX][rndY] = this.blockResistStart[rndX][rndY];
                    ++this.restBreakableBlockNow;
                    --num;
                    rndX = (int)(Math.random() * (double)this.horizontalNum);
                    rndY = (int)(Math.random() * (double)this.verticalNum);
                    continue;
                }
                if (++rndX < this.horizontalNum) continue;
                rndX = 0;
                if (++rndY < this.verticalNum) continue;
                rndX = 0;
                rndY = 0;
            }
        } else {
            if (this.restBreakableBlockNow - num <= this.clearBlockNum) {
                num = this.restBreakableBlockNow - (this.clearBlockNum + 1);
            }
            int rndX = (int)(Math.random() * (double)this.horizontalNum);
            int rndY = (int)(Math.random() * (double)this.verticalNum);
            while (num > 0) {
                if (this.blockResistNow[rndX][rndY] > 0 && this.blockResistStart[rndX][rndY] < 4) {
                    this.blockResistNow[rndX][rndY] = 0;
                    --this.restBreakableBlockNow;
                    --num;
                    rndX = (int)(Math.random() * (double)this.horizontalNum);
                    rndY = (int)(Math.random() * (double)this.verticalNum);
                    continue;
                }
                if (++rndX < this.horizontalNum) continue;
                rndX = 0;
                if (++rndY < this.verticalNum) continue;
                rndX = 0;
                rndY = 0;
            }
        }
    }
}

