/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.ArrayList;

public class FDBItemManager {
    int makeRate;
    int makeItemMax;
    int[][] makeItemRatio;
    ArrayList<FDBItem> flyingItemVec;
    FDBItem[] effectiveItemArr;

    public FDBItemManager(FDBStageLoader stage) {
        this.formatItems(stage);
    }

    public void formatItems(FDBStageLoader stage) {
        this.makeRate = stage.s1.itemRate;
        this.makeItemMax = 0;
        this.makeItemRatio = new int[10][2];
        int i = 0;
        while (i < 10) {
            int p = 0;
            while (p < 2) {
                this.makeItemRatio[i][p] = stage.s1.itemRatio[i][p];
                this.makeItemMax += stage.s1.itemRatio[i][p];
                ++p;
            }
            ++i;
        }
        this.flyingItemVec = new ArrayList();
        this.effectiveItemArr = new FDBItem[6];
        i = 0;
        while (i < 6) {
            this.effectiveItemArr[i] = null;
            ++i;
        }
    }

    public void addItem(FDBBall ball) {
        if (this.effectiveItemArr[4] == null ? Math.random() * 100.0 > (double)this.makeRate : Math.random() * 100.0 > (double)(this.makeRate >> 2)) {
            return;
        }
        int rnd = (int)(Math.random() * (double)this.makeItemMax);
        int sum = 0;
        int i = 0;
        while (i < 10) {
            if (FDBItem.pairFlag[i]) {
                if (rnd < (sum += this.makeItemRatio[i][0])) {
                    this.flyingItemVec.add(new FDBItem(i, 0, ball));
                    return;
                }
                if (rnd < (sum += this.makeItemRatio[i][1])) {
                    this.flyingItemVec.add(new FDBItem(i, 1, ball));
                    return;
                }
            } else if (rnd < (sum += this.makeItemRatio[i][0])) {
                this.flyingItemVec.add(new FDBItem(i, 0, ball));
                return;
            }
            ++i;
        }
    }

    public void timePassBy(int fieldWidth, int fieldHeight, FDBBall ball, FDBBars bars, FDBBlocks blocks, FDBGeneral general, FDBSound sounds, FDBPanel applet) {
        int i = 0;
        while (i < this.flyingItemVec.size()) {
            FDBItem fItem = this.flyingItemVec.get(i);
            int ret = fItem.move(fieldWidth, fieldHeight, bars);
            if (ret == 1) {
                this.flyingItemVec.remove(i);
                --i;
            } else if (ret == 2) {
                fItem.putOn(ball, bars, blocks, general, applet);
                sounds.playSE(2);
                if (fItem.typeAll < 6) {
                    this.effectiveItemArr[fItem.typeAll] = fItem;
                }
                this.flyingItemVec.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < 6) {
            if (this.effectiveItemArr[i] != null && this.effectiveItemArr[i].passBy()) {
                this.effectiveItemArr[i].putOff(ball, bars, blocks, applet);
                this.effectiveItemArr[i] = null;
            }
            ++i;
        }
    }

    public int getTimerPaintWidth(int num, int timerWidth) {
        if (this.effectiveItemArr[num] == null) {
            return 0;
        }
        return this.effectiveItemArr[num].getTimerPaintWidth(timerWidth);
    }

    public Color getTimerPaintColor(int num) {
        if (this.effectiveItemArr[num] == null) {
            return Color.darkGray;
        }
        if (FDBItem.pairFlag[num]) {
            if (this.effectiveItemArr[num].typePair == 0) {
                return Color.red;
            }
            return Color.blue;
        }
        return Color.yellow;
    }
}

