/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FDBPanel
extends JPanel
implements Runnable,
MouseListener,
MouseMotionListener,
KeyListener,
ComponentListener {
    static final int S_START = 0;
    static final int S_MOVE = 1;
    static final int S_WAIT = 2;
    static final int S_MOUSE_OUT = 3;
    static final int S_REST = 4;
    static final int S_CLEAR = 5;
    static final int S_ALL_CLEAR = 6;
    static final int S_OVER = 7;
    static final int U5 = 5;
    static final int U15 = 15;
    static final int U75 = 75;
    private static final int REPAINT_INTERVAL = 50;
    FDBFrame frame;
    int wallThick;
    int baseX;
    int baseY;
    int cornerX;
    int cornerY;
    int fieldWidth;
    int fieldHeight;
    int timerWidth;
    Rectangle messageButtonRect;
    String messageButtonStr = "Message";
    int stateMode;
    FDBStageLoader stage;
    FDBGeneral general;
    FDBItemManager items;
    FDBBars bars;
    FDBBall ball;
    ArrayList<FDBBall> divideBallVec;
    FDBBlocks blocks;
    FDBImageSupply imageSupply;
    FDBSound sounds;
    Point repelPoint;
    Thread moveThread;
    boolean speedUpFlag;
    boolean threadStop;
    Font largeFont = new Font("Dialog.plain", 1, 45);
    Font middleFont = new Font("Dialog.plain", 1, 30);
    Font smallFont = new Font("Dialog.plain", 1, 15);
    boolean debugFlag;
    JScrollPane scrollEdge;
    Dimension edgeMargin;
    boolean firstF;

    public FDBPanel(FDBFrame frm, Dimension puzzleSize) {
        this.frame = frm;
        this.wallThick = 5;
        this.baseX = 15;
        this.baseY = 75;
        this.makePuzzle(puzzleSize);
        this.setCursor(new Cursor(1));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addComponentListener(this);
        this.firstF = true;
    }

    public void makePuzzle(Dimension puzzleSize) {
        this.cornerX = puzzleSize.width - 15;
        this.cornerY = puzzleSize.height - 45;
        this.fieldWidth = puzzleSize.width - 30;
        this.fieldHeight = puzzleSize.height - 75 - 45;
        this.timerWidth = (puzzleSize.width - 30) * 2 / 54;
        this.messageButtonRect = new Rectangle(this.cornerX - 90, -60, 75, 15);
        this.setPreferredSize(puzzleSize);
        this.stateMode = 0;
        this.stage = new FDBStageLoader(this.frame);
        this.general = new FDBGeneral(this.stage, this.frame);
        this.items = new FDBItemManager(this.stage);
        this.bars = new FDBBars(this.stage);
        this.bars.setBarsPosition(0, 0, this.fieldWidth, this.fieldHeight);
        this.ball = new FDBBall(this.stage);
        this.ball.setBallPosition(this.fieldWidth, this.fieldHeight, this.bars);
        this.divideBallVec = new ArrayList();
        this.blocks = new FDBBlocks(this.stage, this.fieldWidth, this.fieldHeight);
        this.imageSupply = new FDBImageSupply(this.stage, this.ball, this.bars, this.frame);
        this.sounds = new FDBSound(this.frame);
        this.repelPoint = null;
        this.speedUpFlag = false;
        if (this.frame.getParam("debug", "off").equals("on")) {
            this.setDebug(true);
        } else {
            this.setDebug(false);
        }
        this.setPaintBasePoint();
    }

    public void setDebug(boolean f) {
        this.debugFlag = f;
        this.repaint();
    }

    public int getStageMax() {
        return this.general.getStageMax();
    }

    public FDBSetFile getDefaultSetting() {
        return this.stage.s0;
    }

    public int getReachedStage() {
        return this.general.reachedMaxStage;
    }

    public void pauseIfRuning() {
        if (this.stateMode == 1 || this.stateMode == 3) {
            this.stateMode = 4;
            this.stopThread();
        }
    }

    public void operateBallNumFromItem(int all) {
        if (this.divideBallVec.size() > 0) {
            return;
        }
        this.divideBallVec = new ArrayList();
        int b = 0;
        while (b < all) {
            this.divideBallVec.add(new FDBBall(this.ball, all, b));
            ++b;
        }
    }

    public boolean selectStagePart(int num, String sMax) {
        int iMax;
        try {
            iMax = Integer.parseInt(sMax);
        }
        catch (NumberFormatException e) {
            iMax = this.general.stageStart;
        }
        if (iMax > this.general.stageMax) {
            iMax = this.general.stageMax;
        }
        if (iMax < this.general.reachedMaxStage) {
            iMax = this.general.reachedMaxStage;
        }
        if (num < 1 || num > iMax) {
            return false;
        }
        return this.goSelectedStage(num);
    }

    public boolean selectStageAll(int num) {
        if (num < 1 || num > this.general.stageMax) {
            return false;
        }
        return this.goSelectedStage(num);
    }

    private boolean goSelectedStage(int num) {
        this.stopThread();
        this.prepareStage(num);
        this.repaint();
        return true;
    }

    public String getSaveDataStage() {
        this.goNextStageToSave();
        return String.valueOf(this.general.stageNow);
    }

    public String getSaveDataScore() {
        this.goNextStageToSave();
        return String.valueOf(this.general.stageStartScore);
    }

    public String getSaveDataLife() {
        this.goNextStageToSave();
        return String.valueOf(this.ball.stageStartCount);
    }

    public void goNextStageToSave() {
        if (this.stateMode == 5) {
            this.prepareStage(-2);
            this.repaint();
        }
    }

    public boolean setSaveData(String sStage, String sScore, String sLife) {
        int iLife;
        int iScore;
        int iStage;
        try {
            iStage = Integer.parseInt(sStage);
            iScore = Integer.parseInt(sScore);
            iLife = Integer.parseInt(sLife);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (iStage < 1 || iStage > this.general.stageMax) {
            return false;
        }
        this.stopThread();
        this.prepareStage(iStage);
        this.general.score = iScore;
        this.general.stageStartScore = iScore;
        this.ball.count = iLife;
        this.ball.stageStartCount = iLife;
        this.repaint();
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        int h;
        if (this.firstF) {
            this.frame.fitFrameSize(true);
            this.firstF = false;
        }
        super.paintComponent(g);
        g.setColor(this.stage.s1.backColor);
        g.fillRect(this.baseX, this.baseY, this.fieldWidth, this.fieldHeight);
        if (this.imageSupply.backImage != null) {
            h = 0;
            while (h <= this.fieldHeight / this.imageSupply.backHeight) {
                int w = 0;
                while (w <= this.fieldWidth / this.imageSupply.backWidth) {
                    g.drawImage(this.imageSupply.backImage, this.baseX + w * this.imageSupply.backWidth, this.baseY + h * this.imageSupply.backHeight, this);
                    ++w;
                }
                ++h;
            }
        }
        if (this.items.effectiveItemArr[3] == null) {
            h = 0;
            while (h < this.blocks.horizontalNum) {
                int v = 0;
                while (v < this.blocks.verticalNum) {
                    if (this.blocks.checkBlockBeing(h, v)) {
                        g.drawImage(this.imageSupply.blockImages[this.blocks.blockColor[h][v]][this.blocks.blockResistNow[h][v] - 1], this.baseX + this.blocks.cornerX[h], this.baseY + this.blocks.cornerY[v], this.blocks.cornerX[h + 1] - this.blocks.cornerX[h], this.blocks.cornerY[v + 1] - this.blocks.cornerY[v], this);
                    }
                    ++v;
                }
                ++h;
            }
        }
        if (!this.bars.directionFlag[2]) {
            g.drawImage(this.imageSupply.barImage, this.baseX + this.bars.barOverhang - 2 * this.bars.barRadius, this.baseY + this.bars.barPosY - this.bars.barRadius, 2 * this.bars.barRadius, 2 * this.bars.barRadius, this);
        }
        if (!this.bars.directionFlag[0]) {
            g.drawImage(this.imageSupply.barImage, this.baseX + this.bars.barPosX - this.bars.barRadius, this.baseY + this.bars.barOverhang - 2 * this.bars.barRadius, 2 * this.bars.barRadius, 2 * this.bars.barRadius, this);
        }
        if (!this.bars.directionFlag[3]) {
            g.drawImage(this.imageSupply.barImage, this.cornerX - this.bars.barOverhang, this.baseY + this.bars.barPosY - this.bars.barRadius, 2 * this.bars.barRadius, 2 * this.bars.barRadius, this);
        }
        if (!this.bars.directionFlag[1]) {
            g.drawImage(this.imageSupply.barImage, this.baseX + this.bars.barPosX - this.bars.barRadius, this.cornerY - this.bars.barOverhang, 2 * this.bars.barRadius, 2 * this.bars.barRadius, this);
        }
        if (this.items.effectiveItemArr[4] != null) {
            g.setColor(Color.yellow);
            int r = 4;
            while (r >= 3) {
                g.drawOval(this.baseX + this.ball.posX - this.ball.radiusNow - r, this.baseY + this.ball.posY - this.ball.radiusNow - r, 2 * this.ball.radiusNow + 2 * r, 2 * this.ball.radiusNow + 2 * r);
                --r;
            }
        }
        g.drawImage(this.imageSupply.ballImage, this.baseX + this.ball.posX - this.ball.radiusNow, this.baseY + this.ball.posY - this.ball.radiusNow, 2 * this.ball.radiusNow, 2 * this.ball.radiusNow, this);
        int b = 0;
        while (b < this.divideBallVec.size()) {
            FDBBall dBall = this.divideBallVec.get(b);
            if (this.items.effectiveItemArr[4] != null) {
                g.setColor(Color.yellow);
                int r = 4;
                while (r >= 3) {
                    g.drawOval(this.baseX + dBall.posX - dBall.radiusNow - r, this.baseY + dBall.posY - dBall.radiusNow - r, 2 * dBall.radiusNow + 2 * r, 2 * dBall.radiusNow + 2 * r);
                    --r;
                }
            }
            g.drawImage(this.imageSupply.ballImage, this.baseX + dBall.posX - dBall.radiusNow, this.baseY + dBall.posY - dBall.radiusNow, 2 * dBall.radiusNow, 2 * dBall.radiusNow, this);
            ++b;
        }
        int i = 0;
        while (i < this.items.flyingItemVec.size()) {
            FDBItem fItem = this.items.flyingItemVec.get(i);
            g.drawImage(this.imageSupply.itemImages[fItem.typeAll][fItem.typePair], this.baseX + fItem.posX - 11, this.baseY + fItem.posY - 11, this);
            ++i;
        }
        g.setColor(Color.gray);
        g.fillRect(0, 0, this.getSize().width, this.baseY);
        g.fillRect(0, this.cornerY, this.getSize().width, this.getSize().height - this.cornerY);
        g.fillRect(0, this.baseY, this.baseX, this.fieldHeight);
        g.fillRect(this.cornerX, this.baseY, this.getSize().width - this.cornerX, this.fieldHeight);
        g.setFont(this.smallFont);
        int t = 0;
        while (t < 6) {
            g.setColor(Color.white);
            g.drawString(FDBItem.timerString[t], this.cornerX - 3 * (t + 1) * this.timerWidth, this.cornerY + 20);
            g.setColor(Color.darkGray);
            g.fillRoundRect(this.cornerX - 3 * (t + 1) * this.timerWidth, this.cornerY + 25, 2 * this.timerWidth, 15, 5, 5);
            g.setColor(this.items.getTimerPaintColor(t));
            g.fillRoundRect(this.cornerX - 3 * (t + 1) * this.timerWidth, this.cornerY + 25, this.items.getTimerPaintWidth(t, 2 * this.timerWidth), 15, 5, 5);
            ++t;
        }
        g.setFont(this.largeFont);
        g.setColor(Color.orange);
        g.drawString("stage " + this.general.stageNow, this.baseX + 15, this.baseY - 30);
        g.setFont(this.middleFont);
        g.setColor(Color.white);
        String s = "score : " + this.general.score;
        g.drawString(s, this.cornerX - 30 - s.length() * this.middleFont.getSize() / 2, this.baseY - 15);
        g.drawString("life : " + this.ball.getCountString(), this.baseX + 30, this.cornerY + 30);
        if (this.bars.directionFlag[0]) {
            g.setColor(Color.lightGray);
            g.fillRoundRect(this.baseX - 5, this.baseY - 5, this.fieldWidth + 10, 5, 5, 5);
        } else if (this.items.effectiveItemArr[5] != null) {
            g.setColor(Color.yellow);
            g.fillRoundRect(this.baseX - 5, this.baseY - 5, this.fieldWidth + 10, 5, 5, 5);
        }
        if (this.bars.directionFlag[1]) {
            g.setColor(Color.lightGray);
            g.fillRoundRect(this.baseX - 5, this.cornerY, this.fieldWidth + 10, 5, 5, 5);
        } else if (this.items.effectiveItemArr[5] != null) {
            g.setColor(Color.yellow);
            g.fillRoundRect(this.baseX - 5, this.cornerY, this.fieldWidth + 10, 5, 5, 5);
        }
        if (this.bars.directionFlag[2]) {
            g.setColor(Color.lightGray);
            g.fillRoundRect(this.baseX - 5, this.baseY - 5, 5, this.fieldHeight + 10, 5, 5);
        } else if (this.items.effectiveItemArr[5] != null) {
            g.setColor(Color.yellow);
            g.fillRoundRect(this.baseX - 5, this.baseY - 5, 5, this.fieldHeight + 10, 5, 5);
        }
        if (this.bars.directionFlag[3]) {
            g.setColor(Color.lightGray);
            g.fillRoundRect(this.cornerX, this.baseY - 5, 5, this.fieldHeight + 10, 5, 5);
        } else if (this.items.effectiveItemArr[5] != null) {
            g.setColor(Color.yellow);
            g.fillRoundRect(this.cornerX, this.baseY - 5, 5, this.fieldHeight + 10, 5, 5);
        }
        if (this.stateMode != 1 && this.stateMode != 2) {
            String secondString;
            String firstString;
            String thirdString = null;
            if (this.stateMode == 0) {
                firstString = "stage " + this.general.stageNow;
                secondString = "click to start";
            } else if (this.stateMode == 3) {
                firstString = "mouse out";
                secondString = "move mouse cursol in";
            } else if (this.stateMode == 4) {
                firstString = "resting";
                secondString = "push space key to resume";
            } else if (this.stateMode == 5) {
                firstString = "clear";
                secondString = "click to next stage";
            } else if (this.stateMode == 6) {
                firstString = "all clear";
                secondString = "click to first stage";
            } else if (this.stateMode == 7) {
                firstString = "game over";
                if (this.general.stageContinue) {
                    secondString = "click to restart";
                    thirdString = "(+shift key to continue)";
                } else {
                    secondString = "click to restart";
                }
            } else {
                firstString = "";
                secondString = "";
            }
            Dimension fld = this.getPreferredSize();
            g.setColor(Color.yellow);
            g.setFont(this.largeFont);
            g.drawString(firstString, this.baseX - 15 + (fld.width * 2 - firstString.length() * this.largeFont.getSize()) / 4, this.baseY - 75 + fld.height / 2);
            g.setFont(this.middleFont);
            g.drawString(secondString, this.baseX - 15 + (fld.width * 2 - secondString.length() * this.middleFont.getSize()) / 4, this.baseY - 75 + fld.height / 2 + this.largeFont.getSize());
            if (thirdString != null) {
                g.drawString(thirdString, this.baseX - 15 + (fld.width * 2 - secondString.length() * this.middleFont.getSize()) / 4, this.baseY - 75 + fld.height / 2 + this.largeFont.getSize() + this.middleFont.getSize());
            }
        }
        if (this.debugFlag) {
            g.setColor(Color.yellow);
            g.setFont(this.smallFont);
            g.drawString("Debug Mode", this.baseX + this.smallFont.getSize(), this.baseY + 2 * this.smallFont.getSize());
        }
        if (this.repelPoint != null) {
            g.setColor(Color.white);
            int dX = (int)(Math.cos(Math.atan2(this.ball.posY - this.repelPoint.y, this.ball.posX - this.repelPoint.x)) * (double)this.ball.radiusNow * 3.0 / 2.0);
            int dY = (int)(Math.sin(Math.atan2(this.ball.posY - this.repelPoint.y, this.ball.posX - this.repelPoint.x)) * (double)this.ball.radiusNow * 3.0 / 2.0);
            g.drawLine(this.baseX + this.repelPoint.x, this.baseY + this.repelPoint.y, this.baseX + this.ball.posX - dX, this.baseY + this.ball.posY - dY);
            g.drawLine(this.baseX + this.ball.posX - dX + dY, this.baseY + this.ball.posY - dY - dX, this.baseX + this.ball.posX - dX - dY, this.baseY + this.ball.posY - dY + dX);
            g.drawLine(this.baseX + this.ball.posX, this.baseY + this.ball.posY, (int)((double)(this.baseX + this.ball.posX) + (double)this.ball.radiusNow * Math.cos(this.ball.angle)), (int)((double)(this.baseY + this.ball.posY) + (double)this.ball.radiusNow * Math.sin(this.ball.angle)));
            int b2 = 0;
            while (b2 < this.divideBallVec.size()) {
                FDBBall dBall = this.divideBallVec.get(b2);
                dX = (int)(Math.cos(Math.atan2(dBall.posY - this.repelPoint.y, dBall.posX - this.repelPoint.x)) * (double)dBall.radiusNow * 3.0 / 2.0);
                dY = (int)(Math.sin(Math.atan2(dBall.posY - this.repelPoint.y, dBall.posX - this.repelPoint.x)) * (double)dBall.radiusNow * 3.0 / 2.0);
                g.drawLine(this.baseX + this.repelPoint.x, this.baseY + this.repelPoint.y, this.baseX + dBall.posX - dX, this.baseY + dBall.posY - dY);
                g.drawLine(this.baseX + dBall.posX - dX + dY, this.baseY + dBall.posY - dY - dX, this.baseX + dBall.posX - dX - dY, this.baseY + dBall.posY - dY + dX);
                g.drawLine(this.baseX + dBall.posX, this.baseY + dBall.posY, (int)((double)(this.baseX + dBall.posX) + (double)dBall.radiusNow * Math.cos(dBall.angle)), (int)((double)(this.baseY + dBall.posY) + (double)dBall.radiusNow * Math.sin(dBall.angle)));
                ++b2;
            }
        }
        if (this.frame.checkMessage()) {
            int clearRatio;
            g.setFont(this.smallFont);
            int n = clearRatio = this.frame.checkMessageViewable() ? 100 : this.general.getClearRatio();
            if (clearRatio == 100) {
                g.setColor(Color.red);
                g.fillRoundRect(this.baseX + this.messageButtonRect.x, this.baseY + this.messageButtonRect.y, this.messageButtonRect.width, this.messageButtonRect.height, this.messageButtonRect.height, this.messageButtonRect.height);
            } else {
                g.setColor(Color.darkGray);
                g.fillRoundRect(this.baseX + this.messageButtonRect.x, this.baseY + this.messageButtonRect.y, this.messageButtonRect.width, this.messageButtonRect.height, this.messageButtonRect.height, this.messageButtonRect.height);
                g.setColor(Color.lightGray);
                g.fillRoundRect(this.baseX + this.messageButtonRect.x, this.baseY + this.messageButtonRect.y, this.messageButtonRect.width * clearRatio / 100, this.messageButtonRect.height, this.messageButtonRect.height, this.messageButtonRect.height);
            }
            g.setColor(Color.white);
            g.drawString(this.messageButtonStr, this.baseX + this.messageButtonRect.x + (this.messageButtonRect.height >> 1), this.baseY + this.messageButtonRect.y + this.messageButtonRect.height - 1);
            g.drawRoundRect(this.baseX + this.messageButtonRect.x, this.baseY + this.messageButtonRect.y, this.messageButtonRect.width, this.messageButtonRect.height, this.messageButtonRect.height, this.messageButtonRect.height);
        }
    }

    private void setPaintBasePoint() {
        Dimension d = this.getPreferredSize();
        if (this.getWidth() <= d.width) {
            this.baseX = 15;
            this.cornerX = d.width - 15;
        } else {
            this.baseX = 15 + (this.getWidth() - d.width >> 1);
            this.cornerX = d.width - 15 + (this.getWidth() - d.width >> 1);
        }
        if (this.getHeight() <= d.height) {
            this.baseY = 75;
            this.cornerY = d.height - 45;
        } else {
            this.baseY = 75 + (this.getHeight() - d.height >> 1);
            this.cornerY = d.height - 45 + (this.getHeight() - d.height >> 1);
        }
        this.repaint();
    }

    public Dimension getSizeDifference() {
        int w = Math.min(this.getWidth(), this.scrollEdge.getWidth() - this.edgeMargin.width) - this.getPreferredSize().width;
        int h = Math.min(this.getHeight(), this.scrollEdge.getHeight() - this.edgeMargin.height) - this.getPreferredSize().height;
        return new Dimension(w, h);
    }

    public void setScrollEdge(JScrollPane scroll) {
        this.scrollEdge = scroll;
        this.edgeMargin = new Dimension(this.scrollEdge.getWidth() - this.getWidth(), this.scrollEdge.getHeight() - this.getHeight());
        if (this.edgeMargin.width <= 0 || this.edgeMargin.height <= 0) {
            this.edgeMargin = new Dimension(3, 3);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.repelPoint = this.getRepelPoint(e);
        this.setCursor(new Cursor(12));
        this.sounds.loopSE(3);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.repelPoint = null;
        this.setCursor(new Cursor(1));
        this.sounds.stopSE(3);
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.stateMode == 1) {
            this.stateMode = 3;
            this.stopThread();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.stateMode == 3) {
            this.stateMode = 1;
            this.startThread();
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int y;
        int x;
        this.requestFocus();
        if (this.frame.checkMessage() && this.messageButtonRect.contains((x = e.getX()) - this.baseX, (y = e.getY()) - this.baseY) && (this.frame.checkMessageViewable() || this.general.getClearRatio() == 100)) {
            this.pauseIfRuning();
            this.sounds.playSE(2);
            this.frame.showMessage();
            return;
        }
        if (this.stateMode == 0) {
            this.stateMode = 2;
        } else if (this.stateMode != 1) {
            if (this.stateMode == 2) {
                this.stateMode = 1;
                this.sounds.playSE(1);
                this.startThread();
            } else if (this.stateMode != 4) {
                if (this.stateMode == 5) {
                    this.prepareStage(-2);
                } else if (this.stateMode == 6) {
                    this.prepareStage(0);
                } else if (this.stateMode == 7) {
                    if (e.isShiftDown() && this.general.stageContinue) {
                        this.prepareStage(-3);
                    } else {
                        this.prepareStage(0);
                    }
                }
            }
        }
        this.repaint();
    }

    private void prepareStage(int order) {
        this.stateMode = 0;
        this.general.formatStage(order, this.stage);
        this.items.formatItems(this.stage);
        this.bars.formatBars(this.stage);
        this.ball.formatBall(this.stage);
        this.ball.setBallPosition(this.fieldWidth, this.fieldHeight, this.bars);
        this.divideBallVec = new ArrayList();
        this.blocks.formatBlocks(this.stage, this.fieldWidth, this.fieldHeight);
        this.imageSupply.formatImages(this.stage, this.ball, this.bars, this.frame);
    }

    private Point getRepelPoint(MouseEvent e) {
        Point ret = e.getPoint();
        ret.x -= this.baseX;
        ret.y -= this.baseY;
        if (ret.x < 0) {
            ret.x = 0;
        } else if (ret.x >= this.fieldWidth) {
            ret.x = this.fieldWidth;
        }
        if (ret.y < 0) {
            ret.y = 0;
        } else if (ret.y >= this.fieldHeight) {
            ret.y = this.fieldHeight;
        }
        return ret;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.notifyBarPosition(e);
        this.repelPoint = this.getRepelPoint(e);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.frame.checkMessage()) {
            int y;
            int x = e.getX();
            if (this.messageButtonRect.contains(x - this.baseX, (y = e.getY()) - this.baseY) && (this.frame.checkMessageViewable() || this.general.getClearRatio() == 100)) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(1));
            }
        }
        this.notifyBarPosition(e);
        this.repaint();
    }

    private void notifyBarPosition(MouseEvent e) {
        int tmpX = e.getX() - this.baseX;
        int tmpY = e.getY() - this.baseY;
        this.bars.setBarsPosition(tmpX, tmpY, this.fieldWidth, this.fieldHeight);
        if (this.stateMode == 0 || this.stateMode == 2) {
            this.ball.setBallPosition(this.fieldWidth, this.fieldHeight, this.bars);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 17: {
                this.speedUpFlag = false;
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 32: {
                if (this.stateMode == 1) {
                    this.stateMode = 4;
                    this.stopThread();
                    break;
                }
                if (this.stateMode != 4) break;
                this.stateMode = 1;
                this.startThread();
                break;
            }
            case 17: {
                this.speedUpFlag = true;
            }
        }
        if (this.debugFlag) {
            switch (e.getKeyCode()) {
                case 67: {
                    this.debugStageClear();
                    return;
                }
                case 83: {
                    this.debugLastStage();
                    return;
                }
            }
        }
    }

    public void debugStageClear() {
        if (this.stateMode == 1 || this.stateMode == 3) {
            if (this.general.checkLastStage()) {
                this.stateMode = 6;
                this.sounds.playSE(7);
                this.general.setReachAll();
                this.stopThread();
            } else {
                this.stateMode = 5;
                this.sounds.playSE(6);
                this.stopThread();
            }
        }
    }

    public void debugLastStage() {
        if (this.stateMode == 5) {
            this.prepareStage(-1);
            this.repaint();
        }
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setPaintBasePoint();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    private void startThread() {
        this.threadStop = false;
        this.moveThread = new Thread(this);
        this.moveThread.start();
    }

    private void stopThread() {
        this.threadStop = true;
    }

    @Override
    public void run() {
        do {
            this.items.timePassBy(this.fieldWidth, this.fieldHeight, this.ball, this.bars, this.blocks, this.general, this.sounds, this);
            try {
                if (this.speedUpFlag) {
                    Thread.sleep(25L);
                } else {
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException e) {
                return;
            }
            int b = 0;
            while (b < this.divideBallVec.size()) {
                FDBBall dBall = this.divideBallVec.get(b);
                dBall.receiveRepelPower(this.repelPoint);
                int ballMoveResult = dBall.move(this.fieldWidth, this.fieldHeight, this.blocks, this.bars, this.general, this.items, this.sounds);
                if (ballMoveResult != 0) {
                    if (ballMoveResult == 1 || ballMoveResult == 2) {
                        this.divideBallVec.remove(b);
                    } else if (ballMoveResult == 3) {
                        if (this.general.checkLastStage()) {
                            this.stateMode = 6;
                            this.sounds.playSE(7);
                            this.general.setReachAll();
                        } else {
                            this.stateMode = 5;
                            this.sounds.playSE(6);
                        }
                        this.repaint();
                        return;
                    }
                }
                ++b;
            }
            this.ball.receiveRepelPower(this.repelPoint);
            int ballMoveResult = this.ball.move(this.fieldWidth, this.fieldHeight, this.blocks, this.bars, this.general, this.items, this.sounds);
            if (ballMoveResult != 0) {
                if (this.divideBallVec.size() <= 0) {
                    if (ballMoveResult == 1) {
                        this.stateMode = 2;
                        this.sounds.playSE(4);
                        this.ball.setBallPosition(this.fieldWidth, this.fieldHeight, this.bars);
                    } else if (ballMoveResult == 3) {
                        if (this.general.checkLastStage()) {
                            this.stateMode = 6;
                            this.sounds.playSE(7);
                            this.general.setReachAll();
                        } else {
                            this.stateMode = 5;
                            this.sounds.playSE(6);
                        }
                    } else if (ballMoveResult == 2) {
                        this.stateMode = 7;
                        this.sounds.playSE(5);
                    }
                    this.repaint();
                    return;
                }
                if (ballMoveResult == 1 || ballMoveResult == 2) {
                    this.ball = this.divideBallVec.get(0);
                    this.divideBallVec.remove(0);
                } else if (ballMoveResult == 3) {
                    if (this.general.checkLastStage()) {
                        this.stateMode = 6;
                        this.sounds.playSE(7);
                        this.general.setReachAll();
                    } else {
                        this.stateMode = 5;
                        this.sounds.playSE(6);
                    }
                    this.repaint();
                    return;
                }
            }
            this.repaint();
        } while (!this.threadStop);
    }
}

