/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;

public class FDBSound {
    static final int SE_BREAK = 0;
    static final int SE_REFLEX = 1;
    static final int SE_CATCH = 2;
    static final int SE_POWER = 3;
    static final int SE_OUT = 4;
    static final int SE_OVER = 5;
    static final int SE_CLEAR = 6;
    static final int SE_ALLCLEAR = 7;
    static final int SE_ALL = 8;
    static final String[] SOUND_NAME = new String[]{"break", "reflex", "catch", "power", "out", "over", "clear", "allclear"};
    AudioClip[] soundEffect = new AudioClip[8];
    boolean playFlag;

    public FDBSound(FDBFrame frm) {
        String folderName = frm.getParam("sound", "se");
        this.playFlag = !folderName.equals("off");
        if (this.playFlag) {
            String ext = frm.getParam("soundtype", "au");
            ext = ext.equals("wav") ? ".wav" : ".au";
            int s = 0;
            while (s < 8) {
                this.soundEffect[s] = frm.getSound(String.valueOf(folderName) + '/' + SOUND_NAME[s] + ext);
                ++s;
            }
        }
    }

    public void playSE(int soundNum) {
        if (!this.playFlag) {
            return;
        }
        if (soundNum < 8) {
            this.soundEffect[soundNum].play();
        }
    }

    public void loopSE(int soundNum) {
        if (!this.playFlag) {
            return;
        }
        if (soundNum < 8) {
            this.soundEffect[soundNum].loop();
        }
    }

    public void stopSE(int soundNum) {
        if (!this.playFlag) {
            return;
        }
        if (soundNum < 8) {
            this.soundEffect[soundNum].stop();
        }
    }
}

