/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class FDBFrame
extends JFrame
implements ActionListener,
WindowListener {
    public static final int STAGE_MAX = 30;
    private static final String TITLE_STRING = " - FullDirectionBB";
    public static final int RUN_EDIT = 0;
    public static final int RUN_PLAY = 1;
    public static final int SND_IN = 0;
    public static final int SND_OFF = 1;
    public static final int SND_OUT_AU = 2;
    public static final int SND_OUT_WAV = 3;
    public static final int STG_SELECTABLE = 0;
    public static final int STG_UNSELECTABLE = 1;
    FDBFileIO fileIO;
    FDBInfoDialog infoDialog;
    FDBCipher cipher;
    FDBPanel field;
    FDBNumSizeDialog numSizeDialog;
    FDBSetDialog setDialog;
    FDBBlockDialog blockDialog;
    FDBSoundDialog soundDialog;
    FDBJarDialog jarDialog;
    int runType;
    int sndType;
    int stgType;
    JMenuBar mainMenu = new JMenuBar();
    JMenu menuFile = new JMenu("\u30d5\u30a1\u30a4\u30eb(F)");
    JMenuItem menuItemNew = new JMenuItem("\u65b0\u898f(N)...");
    JMenuItem menuItemOpen = new JMenuItem("\u958b\u304f(O)");
    JMenuItem menuItemSave = new JMenuItem("\u4e0a\u66f8\u304d\u4fdd\u5b58(S)");
    JMenuItem menuItemSaveAs = new JMenuItem("\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58(R)...");
    JMenuItem menuItemSetNumSize = new JMenuItem("\u30b9\u30c6\u30fc\u30b8\u6570\u30fb\u30b5\u30a4\u30ba(1)...");
    JMenuItem menuItemSetStage = new JMenuItem("\u30b9\u30c6\u30fc\u30b8\u5185\u5bb9(2)...");
    JMenuItem menuItemSetBlock = new JMenuItem("\u30d6\u30ed\u30c3\u30af\u914d\u7f6e(3)...");
    JMenuItem menuItemSetSound = new JMenuItem("\u52b9\u679c\u97f3(4)...");
    JMenuItem menuItemExit = new JMenuItem("\u7d42\u4e86(X)");
    JMenuItem menuItemSaveReachStage = new JMenuItem("\u5230\u9054\u30b9\u30c6\u30fc\u30b8\u3092\u4fdd\u5b58(S)");
    JMenuItem menuItemFormatReachStage = new JMenuItem("\u5230\u9054\u30b9\u30c6\u30fc\u30b8\u3092\u521d\u671f\u5316(F)");
    JMenu menuStage = new JMenu("\u30b9\u30c6\u30fc\u30b8(S)");
    JRadioButtonMenuItem[] menuItemStage = new JRadioButtonMenuItem[30];
    JMenu menuOtherSet = new JMenu("\u74b0\u5883\u8a2d\u5b9a(E)");
    JMenuItem menuItemFitSize = new JMenuItem("\u30d5\u30ec\u30fc\u30e0\u30b5\u30a4\u30ba\u8abf\u7bc0(F)");
    JMenuItem menuItemRestart = new JMenuItem("\u518d\u8aad\u307f\u8fbc\u307f(R)");
    JMenu menuDebug = new JMenu("\u30c7\u30d0\u30c3\u30b0\u30e2\u30fc\u30c9(D)");
    JRadioButtonMenuItem menuItemDebugOn = new JRadioButtonMenuItem("on(N)");
    JRadioButtonMenuItem menuItemDebugOff = new JRadioButtonMenuItem("off(F)");
    JMenuItem menuItemDebugStageClear = new JMenuItem("\u30b9\u30c6\u30fc\u30b8\u30af\u30ea\u30a2(C)");
    JMenuItem menuItemDebugLastStage = new JMenuItem("\u6700\u7d42\u30b9\u30c6\u30fc\u30b8(S)");
    JMenu menuOut = new JMenu("\u51fa\u529b(O)");
    JMenuItem menuItemOutDist = new JMenuItem("\u30d7\u30ec\u30a4\u5c02\u7528\u30d5\u30a1\u30a4\u30eb(P)...");
    JMenu menuHelp = new JMenu("\u30d8\u30eb\u30d7(H)");
    JMenuItem menuItemAuther = new JMenuItem("\u30d1\u30ba\u30eb\u4f5c\u6210\u8005(M)");
    JMenuItem menuItemAbout = new JMenuItem("FullDirectionBB\u306b\u3064\u3044\u3066(A)");

    public static void main(String[] args) {
        FDBFrame frame = new FDBFrame();
        frame.setDefaultCloseOperation(0);
        frame.setVisible(true);
        frame.setLocationRelativeTo(null);
    }

    public FDBFrame() {
        this.fileIO = new FDBFileIO(this);
        int[] setInfo = this.fileIO.getSetInfo(false);
        this.runType = setInfo[0];
        this.sndType = setInfo[3];
        this.stgType = setInfo[4];
        this.infoDialog = new FDBInfoDialog(this);
        this.cipher = new FDBCipher(this, this.fileIO);
        if (this.runType == 0) {
            this.fileIO.formatWorkFolder();
        }
        this.setMenuItem();
        this.menuFile.setMnemonic(70);
        this.menuItemNew.setMnemonic(78);
        this.menuItemOpen.setMnemonic(79);
        this.menuItemSave.setMnemonic(83);
        this.menuItemSaveAs.setMnemonic(82);
        this.menuItemSetNumSize.setMnemonic(49);
        this.menuItemSetStage.setMnemonic(50);
        this.menuItemSetBlock.setMnemonic(51);
        this.menuItemSetSound.setMnemonic(52);
        this.menuItemExit.setMnemonic(88);
        this.menuItemSaveReachStage.setMnemonic(83);
        this.menuItemFormatReachStage.setMnemonic(70);
        this.menuStage.setMnemonic(83);
        this.menuOtherSet.setMnemonic(69);
        this.menuItemFitSize.setMnemonic(70);
        this.menuItemRestart.setMnemonic(82);
        this.menuDebug.setMnemonic(68);
        this.menuItemDebugOn.setMnemonic(78);
        this.menuItemDebugOff.setMnemonic(70);
        this.menuItemDebugStageClear.setMnemonic(67);
        this.menuItemDebugLastStage.setMnemonic(83);
        this.menuOut.setMnemonic(79);
        this.menuItemOutDist.setMnemonic(80);
        this.menuHelp.setMnemonic(72);
        this.menuItemAuther.setMnemonic(77);
        this.menuItemAbout.setMnemonic(65);
        this.menuItemNew.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.menuItemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.menuItemSave.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.menuItemSaveAs.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.menuItemSetNumSize.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.menuItemSetStage.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.menuItemSetBlock.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.menuItemSetSound.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.menuItemExit.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.menuItemFitSize.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.menuItemRestart.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.menuItemDebugOn.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.menuItemDebugOff.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.menuItemOutDist.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        this.menuItemNew.addActionListener(this);
        this.menuItemOpen.addActionListener(this);
        this.menuItemSave.addActionListener(this);
        this.menuItemSaveAs.addActionListener(this);
        this.menuItemSetNumSize.addActionListener(this);
        this.menuItemSetStage.addActionListener(this);
        this.menuItemSetBlock.addActionListener(this);
        this.menuItemSetSound.addActionListener(this);
        this.menuItemExit.addActionListener(this);
        this.menuItemSaveReachStage.addActionListener(this);
        this.menuItemFormatReachStage.addActionListener(this);
        int r = 0;
        while (r < 30) {
            this.menuItemStage[r].addActionListener(this);
            ++r;
        }
        this.menuItemFitSize.addActionListener(this);
        this.menuItemRestart.addActionListener(this);
        this.menuItemDebugOn.addActionListener(this);
        this.menuItemDebugOff.addActionListener(this);
        this.menuItemDebugStageClear.addActionListener(this);
        this.menuItemDebugLastStage.addActionListener(this);
        this.menuItemOutDist.addActionListener(this);
        this.menuItemAuther.addActionListener(this);
        this.menuItemAbout.addActionListener(this);
        this.addWindowListener(this);
        this.setSize(850, 650);
        Container cp = this.getContentPane();
        this.field = new FDBPanel(this, new Dimension(setInfo[1], setInfo[2]));
        JScrollPane scPanel = new JScrollPane(this.field);
        cp.add((Component)scPanel, "Center");
        this.numSizeDialog = new FDBNumSizeDialog(this, this.fileIO);
        this.setDialog = new FDBSetDialog(this, this.fileIO);
        this.blockDialog = new FDBBlockDialog(this, this.fileIO);
        this.soundDialog = new FDBSoundDialog(this, this.fileIO);
        this.jarDialog = new FDBJarDialog(this, this.fileIO);
        this.setTitleString();
        this.field.setScrollEdge(scPanel);
    }

    private void setMenuItem() {
        if (this.runType == 0) {
            this.menuFile.add(this.menuItemNew);
            this.menuFile.add(this.menuItemOpen);
            this.menuFile.addSeparator();
            this.menuFile.add(this.menuItemSave);
            this.menuFile.add(this.menuItemSaveAs);
            this.menuFile.addSeparator();
            this.menuFile.add(this.menuItemSetNumSize);
            this.menuFile.add(this.menuItemSetStage);
            this.menuFile.add(this.menuItemSetBlock);
            this.menuFile.add(this.menuItemSetSound);
            this.menuFile.addSeparator();
            this.menuItemSaveReachStage.setEnabled(false);
            this.menuItemFormatReachStage.setEnabled(false);
        } else if (this.runType == 1) {
            this.menuItemNew.setEnabled(false);
            this.menuItemOpen.setEnabled(false);
            this.menuItemSave.setEnabled(false);
            this.menuItemSaveAs.setEnabled(false);
            this.menuItemSetNumSize.setEnabled(false);
            this.menuItemSetStage.setEnabled(false);
            this.menuItemSetBlock.setEnabled(false);
            this.menuItemSetSound.setEnabled(false);
            if (this.stgType == 0) {
                this.menuItemSaveReachStage.setEnabled(false);
                this.menuItemFormatReachStage.setEnabled(false);
            } else {
                this.menuFile.add(this.menuItemSaveReachStage);
                this.menuFile.add(this.menuItemFormatReachStage);
                this.menuFile.addSeparator();
            }
        }
        this.menuFile.add(this.menuItemExit);
        ButtonGroup bgStage = new ButtonGroup();
        int r = 0;
        while (r < 30) {
            this.menuItemStage[r] = new JRadioButtonMenuItem("\u30b9\u30c6\u30fc\u30b8" + (r + 1));
            this.menuStage.add(this.menuItemStage[r]);
            bgStage.add(this.menuItemStage[r]);
            ++r;
        }
        this.menuItemStage[0].setSelected(true);
        this.menuOtherSet.add(this.menuItemFitSize);
        if (this.runType == 0) {
            this.menuOtherSet.add(this.menuItemRestart);
            ButtonGroup bgDebug = new ButtonGroup();
            bgDebug.add(this.menuItemDebugOn);
            bgDebug.add(this.menuItemDebugOff);
            this.menuItemDebugOff.setSelected(true);
            this.enableDebugMenu(false);
            this.menuDebug.add(this.menuItemDebugOn);
            this.menuDebug.add(this.menuItemDebugOff);
            this.menuDebug.addSeparator();
            this.menuDebug.add(this.menuItemDebugStageClear);
            this.menuDebug.add(this.menuItemDebugLastStage);
            this.menuOtherSet.add(this.menuDebug);
        } else if (this.runType == 1) {
            this.menuItemRestart.setEnabled(false);
            this.menuItemDebugOn.setEnabled(false);
            this.menuItemDebugOff.setEnabled(false);
            this.menuItemDebugStageClear.setEnabled(false);
            this.menuItemDebugLastStage.setEnabled(false);
        }
        if (this.runType == 0) {
            this.menuOut.add(this.menuItemOutDist);
        } else if (this.runType == 1) {
            this.menuItemOutDist.setEnabled(false);
        }
        this.menuHelp.add(this.menuItemAuther);
        this.menuHelp.add(this.menuItemAbout);
        this.mainMenu.add(this.menuFile);
        this.mainMenu.add(this.menuStage);
        this.mainMenu.add(this.menuOtherSet);
        if (this.runType == 0) {
            this.mainMenu.add(this.menuOut);
        }
        this.mainMenu.add(this.menuHelp);
        this.setJMenuBar(this.mainMenu);
    }

    public void changeBaseSetting(int snd) {
        this.fileIO.makeSetFile(this.runType, this.field.getPreferredSize(), snd, this.stgType);
    }

    public void changeBaseSetting(Dimension size, boolean newPuzzle) {
        if (newPuzzle) {
            this.fileIO.makeSetFile(this.runType, size, 0, this.stgType);
        } else {
            this.fileIO.makeSetFile(this.runType, size, this.sndType, this.stgType);
        }
    }

    public void changeDefaultSetting(int stg, boolean newPuzzle) {
        if (newPuzzle) {
            this.fileIO.makeFirstStageFile(stg);
        } else {
            FDBSetFile defSet = this.field.getDefaultSetting();
            defSet.gStageMax = stg;
            this.fileIO.makeStageFile(0, defSet.getDefaultDataString());
            this.fileIO.deleteUselessStageBlockFiles(stg);
        }
    }

    public void restartPuzzle(boolean outFlag) {
        int[] setInfo = this.fileIO.getSetInfo(outFlag);
        this.runType = setInfo[0];
        this.sndType = setInfo[3];
        this.stgType = setInfo[4];
        this.field.makePuzzle(new Dimension(setInfo[1], setInfo[2]));
        this.fitFrameSize(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.menuItemNew) {
            if (this.checkChangedData()) {
                this.field.pauseIfRuning();
                this.numSizeDialog.formatData();
                this.numSizeDialog.setVisible(true);
            }
        } else if (object == this.menuItemOpen) {
            if (this.checkChangedData()) {
                this.field.pauseIfRuning();
                this.fileIO.load();
            }
        } else if (object == this.menuItemSave) {
            this.field.pauseIfRuning();
            this.fileIO.save();
        } else if (object == this.menuItemSaveAs) {
            this.field.pauseIfRuning();
            this.fileIO.saveAs();
        } else if (object == this.menuItemSetNumSize) {
            this.field.pauseIfRuning();
            this.numSizeDialog.setLatestData(this.field.getStageMax(), this.field.getPreferredSize());
            this.numSizeDialog.setVisible(true);
        } else if (object == this.menuItemSetStage) {
            this.field.pauseIfRuning();
            this.setDialog.setLatestData(this.field.getDefaultSetting(), this.field.getStageMax());
            this.setDialog.setVisible(true);
        } else if (object == this.menuItemSetBlock) {
            this.field.pauseIfRuning();
            this.blockDialog.setLatestData(this.field.getStageMax());
            this.blockDialog.setVisible(true);
        } else if (object == this.menuItemSetSound) {
            this.field.pauseIfRuning();
            this.soundDialog.setLatestData(this.sndType);
            this.soundDialog.setVisible(true);
        } else if (object == this.menuItemExit) {
            if (this.checkChangedData()) {
                this.exitAll();
            }
        } else if (object == this.menuItemSaveReachStage) {
            this.field.pauseIfRuning();
            this.field.goNextStageToSave();
            if (this.cipher.saveStageNum(this.field.getReachedStage())) {
                this.showFinishDialog("\u4fdd\u5b58\u3057\u307e\u3057\u305f");
            }
        } else if (object == this.menuItemFormatReachStage) {
            this.field.pauseIfRuning();
            this.cipher.deleteStageNum();
            this.showFinishDialog("\u521d\u671f\u5316\u3057\u307e\u3057\u305f");
            this.restartPuzzle(false);
        } else if (object == this.menuItemFitSize) {
            this.fitFrameSize(true);
        } else if (object == this.menuItemRestart) {
            this.restartPuzzle(true);
        } else if (object == this.menuItemDebugOn) {
            this.field.setDebug(true);
            this.enableDebugMenu(true);
        } else if (object == this.menuItemDebugOff) {
            this.field.setDebug(false);
            this.enableDebugMenu(false);
        } else if (object == this.menuItemDebugStageClear) {
            this.field.debugStageClear();
        } else if (object == this.menuItemDebugLastStage) {
            this.field.debugLastStage();
        } else if (object == this.menuItemOutDist) {
            this.field.pauseIfRuning();
            this.jarDialog.setLatestData(this.field.getStageMax());
            this.jarDialog.setVisible(true);
        } else if (object == this.menuItemAuther) {
            this.infoDialog.setVisible(true);
        } else if (object == this.menuItemAbout) {
            JOptionPane.showMessageDialog(this, "FullDirectionBB version 1.2" + FDBFileIO.BR + FDBFileIO.BR + "Puzzle Workshop TAKANA" + FDBFileIO.BR + "http://www.takana.info/", "FullDirectionBB\u306b\u3064\u3044\u3066", 1);
        } else {
            int r = 0;
            while (r < 30) {
                if (object == this.menuItemStage[r]) {
                    this.field.selectStageAll(r + 1);
                    break;
                }
                ++r;
            }
        }
        this.field.requestFocus();
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        if (this.checkChangedData()) {
            this.exitAll();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    private boolean checkChangedData() {
        if (this.fileIO.needSave()) {
            int ret = JOptionPane.showConfirmDialog(this, "\u5185\u5bb9\u304c\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059" + FDBFileIO.BR + "\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f", "\u78ba\u8a8d", 1, 2);
            if (ret == 0) {
                this.fileIO.save();
            } else if (ret == 2) {
                return false;
            }
        }
        return true;
    }

    private void exitAll() {
        if (this.runType == 0) {
            this.fileIO.deleteWorkFolder();
        }
        this.fileIO.closeSelfJarFile();
        System.exit(0);
    }

    public void fitFrameSize(boolean shortenFlag) {
        Dimension differ = this.field.getSizeDifference();
        if (!shortenFlag) {
            if (differ.width > 0) {
                differ.width = 0;
            }
            if (differ.height > 0) {
                differ.height = 0;
            }
        }
        this.setSize(this.getWidth() - differ.width, this.getHeight() - differ.height);
        this.setVisible(true);
    }

    public void setTitleString() {
        if (this.runType == 0) {
            if (this.fileIO.needSave()) {
                this.setTitle("*" + this.fileIO.getFileName() + TITLE_STRING);
            } else {
                this.setTitle(String.valueOf(this.fileIO.getFileName()) + TITLE_STRING);
            }
        } else {
            this.setTitle(String.valueOf(this.cipher.getTitle()) + TITLE_STRING);
        }
    }

    private void enableDebugMenu(boolean f) {
        this.menuItemDebugStageClear.setEnabled(f);
        this.menuItemDebugLastStage.setEnabled(f);
    }

    public void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(this, message, "\u30a8\u30e9\u30fc", 0);
    }

    public void showFinishDialog(String message) {
        JOptionPane.showMessageDialog(this, message, "\u5b8c\u4e86", 1);
    }

    public void setStageMenu(int num) {
        int s = 0;
        while (s < num) {
            this.menuItemStage[s].setVisible(true);
            ++s;
        }
        s = num;
        while (s < 30) {
            this.menuItemStage[s].setVisible(false);
            ++s;
        }
        this.menuItemStage[0].setSelected(true);
    }

    public void setSelectableStage(int num) {
        if (this.stgType == 0 || this.runType == 0) {
            return;
        }
        int s = 0;
        while (s < num) {
            this.menuItemStage[s].setEnabled(true);
            ++s;
        }
        s = num;
        while (s < 30) {
            this.menuItemStage[s].setEnabled(false);
            ++s;
        }
    }

    public void stageChanged(int num) {
        this.menuItemStage[num - 1].setSelected(true);
    }

    public String getParam(String param, String def) {
        if (param.equals("sound")) {
            if (this.sndType == 1) {
                return "off";
            }
            return "se";
        }
        if (param.equals("soundtype")) {
            if (this.sndType == 3) {
                return "wav";
            }
            return "au";
        }
        if (param.equals("debug")) {
            if (this.menuItemDebugOn.isSelected()) {
                return "on";
            }
            return "off";
        }
        return def;
    }

    public String[] readTextFile(String fileOrder) {
        String[] ret = this.runType == 0 ? this.fileIO.getFileString(fileOrder) : this.fileIO.getFileStringInJar(fileOrder);
        if (ret != null) {
            return ret;
        }
        return new String[0];
    }

    public Image getImage(String target) {
        if (this.runType == 0) {
            if (target.indexOf("image") == 0) {
                return this.fileIO.getImageFile(target, false);
            }
            return this.fileIO.getImageFile(target, true);
        }
        return this.fileIO.getImageFile(target, false);
    }

    public AudioClip getSound(String target) {
        if (this.runType == 0) {
            if (this.sndType == 0) {
                return this.fileIO.getSoundFile(target, false);
            }
            return this.fileIO.getSoundFile(target, true);
        }
        return this.fileIO.getSoundFile(target, false);
    }

    public int loadReacdedStage() {
        if (this.stgType == 0 || this.runType == 0) {
            return 1;
        }
        return this.cipher.loadStageNum();
    }

    public void showMessage() {
        JOptionPane.showMessageDialog(this, this.cipher.message, "\u30e1\u30c3\u30bb\u30fc\u30b8", -1);
    }

    public boolean checkMessage() {
        return this.cipher.checkMessage();
    }

    public boolean checkMessageViewable() {
        return this.stgType == 0 && this.runType == 1;
    }
}

