/*
 * Decompiled with CFR 0.152.
 */
public class FDBGeneral {
    static final int O_FIRST = 0;
    static final int O_FINAL = -1;
    static final int O_NEXT = -2;
    static final int O_SAME = -3;
    static final int REACH_ALL = 1000;
    FDBFrame frame;
    int stageMax;
    int stageStart;
    int stageNow;
    boolean stageContinue;
    int score;
    int lifeUpScore;
    int reachedMaxStage;
    int stageStartScore;

    public FDBGeneral(FDBStageLoader stage, FDBFrame frm) {
        this.frame = frm;
        this.stageMax = stage.s0.gStageMax;
        this.stageNow = this.stageStart = stage.s0.gStageStart;
        this.stageContinue = stage.s0.gStageContinue;
        this.score = 0;
        this.lifeUpScore = stage.s1.lifeupScore;
        int savedReach = frm.loadReacdedStage();
        if (savedReach <= 0 || savedReach > this.stageMax) {
            savedReach = 1;
        }
        this.reachedMaxStage = this.stageNow >= savedReach ? this.stageNow : savedReach;
        this.stageStartScore = this.score;
        this.frame.setStageMenu(this.stageMax);
        this.frame.stageChanged(this.stageNow);
        if (this.reachedMaxStage == 1000) {
            this.frame.setSelectableStage(this.stageMax);
        } else {
            this.frame.setSelectableStage(this.reachedMaxStage);
        }
    }

    public void formatStage(int order, FDBStageLoader stage) {
        if (order == -2) {
            if (this.stageNow < this.stageMax) {
                ++this.stageNow;
            }
            stage.loadStage(this.stageNow, false);
        } else {
            if (order == 0) {
                this.stageNow = this.stageStart;
                this.score = 0;
            } else if (order == -3) {
                this.score = 0;
            } else if (order == -1) {
                this.stageNow = this.stageMax;
            } else {
                this.stageNow = order < 1 ? 1 : (order > this.stageMax ? this.stageMax : order);
                this.score = 0;
            }
            stage.loadStage(this.stageNow, true);
        }
        this.lifeUpScore = stage.s1.lifeupScore;
        if (this.reachedMaxStage < this.stageNow) {
            this.reachedMaxStage = this.stageNow;
            this.frame.setSelectableStage(this.stageNow);
        }
        this.stageStartScore = this.score;
        this.frame.stageChanged(this.stageNow);
    }

    public void setReachAll() {
        this.reachedMaxStage = 1000;
    }

    public int getClearRatio() {
        if (this.reachedMaxStage == 1000) {
            return 100;
        }
        return 100 * this.reachedMaxStage / (this.stageMax + 1);
    }

    public boolean checkLastStage() {
        return this.stageNow == this.stageMax;
    }

    public boolean addScore(int combo) {
        int additionalScore = combo <= 0 ? 1 : 2 + combo / 5;
        this.score += additionalScore;
        if (this.lifeUpScore <= 0) {
            return false;
        }
        return this.lifeUpScore <= additionalScore || (this.score - additionalScore) % this.lifeUpScore >= this.score % this.lifeUpScore;
    }

    public void operateScoreFromItem(int typePair, int num, FDBBall ball) {
        if (typePair == 0) {
            ball.countBonus(this.addScore((num - 2) * 5));
        } else {
            this.score = this.score >= num ? (this.score -= num) : 0;
        }
    }

    public int getStageMax() {
        return this.stageMax;
    }
}

