/*
 * Decompiled with CFR 0.152.
 */
public class FDBItem {
    static final int I_RETURN_CONTINUE = 0;
    static final int I_RETURN_OUT = 1;
    static final int I_RETURN_CATCH = 2;
    static final int I_TIME_PAIR_BARLENGTH = 0;
    static final int I_TIME_PAIR_BALLSIZE = 1;
    static final int I_TIME_PAIR_SPEED = 2;
    static final int I_TIME_MONO_BLOCKVIEW = 3;
    static final int I_TIME_MONO_THROUGH = 4;
    static final int I_TIME_MONO_REFLEX = 5;
    static final int I_TIME_MAX = 6;
    static final int I_ONCE_PAIR_LIFE = 6;
    static final int I_ONCE_PAIR_BLOCKNUM = 7;
    static final int I_ONCE_PAIR_SCORE = 8;
    static final int I_ONCE_MONO_DIVIDE = 9;
    static final int I_MAX = 10;
    static final int I_PAIR_MID = 0;
    static final int I_PAIR_UP = 0;
    static final int I_PAIR_DOWN = 1;
    static final int I_PAIR_MAX = 2;
    static final boolean[] pairFlag;
    static final int[] effectiveTime;
    static final String[] timerString;
    int typeAll;
    int typePair;
    int posX;
    int posY;
    int speed;
    double angle;
    int effectiveTimeMax;
    int effectiveTimeRemain;

    static {
        boolean[] blArray = new boolean[10];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        pairFlag = blArray;
        effectiveTime = new int[]{300, 300, 300, 150, 150, 150};
        timerString = new String[]{"Bar", "Ball", "Speed", "Block", "Through", "Reflex"};
    }

    public FDBItem(int typeA, int typeP, FDBBall ball) {
        this.typeAll = typeA;
        this.typePair = typeP;
        this.posX = ball.posX;
        this.posY = ball.posY;
        this.speed = ball.speedNow >> 1;
        this.angle = ball.oldAngle;
        if (this.typeAll < 6) {
            this.effectiveTimeRemain = this.effectiveTimeMax = effectiveTime[this.typeAll];
        }
        int dY = (int)((double)this.speed * Math.sin(this.angle));
        int dX = (int)((double)this.speed * Math.cos(this.angle));
        while (dY == 0 || dX == 0) {
            if (dY == 0 && dX == 0) {
                ++this.speed;
            } else {
                this.angle = this.angle % 1.5707963267948966 >= 0.7853981633974483 ? (this.angle -= 0.39269908169872414) : (this.angle += 0.39269908169872414);
            }
            dY = (int)((double)this.speed * Math.sin(this.angle));
            dX = (int)((double)this.speed * Math.cos(this.angle));
        }
    }

    public int move(int fieldWidth, int fieldHeight, FDBBars bars) {
        int addX = (int)((double)this.speed * Math.cos(this.angle));
        int addY = (int)((double)this.speed * Math.sin(this.angle));
        int radius = 11;
        if (this.posX + addX < fieldWidth / 2) {
            if (bars.directionFlag[2]) {
                if (this.posX + addX < radius) {
                    if (addX != 0) {
                        addY = addY * (radius - this.posX) / addX;
                        addX = radius - this.posX;
                    } else {
                        addY = addX;
                    }
                    this.angle = FDBBall.calculateReflectAngle(this.angle, 0.0);
                }
            } else {
                if (this.posX + addX < -radius) {
                    return 1;
                }
                if (this.checkBarTouch(this.posX + addX, this.posY + addY, bars.barOverhang - bars.barRadius, bars.barPosY, radius + bars.barRadius)) {
                    return 2;
                }
            }
        } else if (bars.directionFlag[3]) {
            if (this.posX + addX > fieldWidth - radius) {
                if (addX != 0) {
                    addY = addY * (fieldWidth - radius - this.posX) / addX;
                    addX = fieldWidth - radius - this.posX;
                } else {
                    addY = addX;
                }
                this.angle = FDBBall.calculateReflectAngle(this.angle, Math.PI);
            }
        } else {
            if (this.posX + addX > fieldWidth + radius) {
                return 1;
            }
            if (this.checkBarTouch(this.posX + addX, this.posY + addY, fieldWidth - bars.barOverhang + bars.barRadius, bars.barPosY, radius + bars.barRadius)) {
                return 2;
            }
        }
        if (this.posY + addY < fieldHeight / 2) {
            if (bars.directionFlag[0]) {
                if (this.posY + addY < radius) {
                    if (addY != 0) {
                        addX = addX * (radius - this.posY) / addY;
                        addY = radius - this.posY;
                    } else {
                        addX = addY;
                    }
                    this.angle = FDBBall.calculateReflectAngle(this.angle, 1.5707963267948966);
                }
            } else {
                if (this.posY + addY < -radius) {
                    return 1;
                }
                if (this.checkBarTouch(this.posX + addX, this.posY + addY, bars.barPosX, bars.barOverhang - bars.barRadius, radius + bars.barRadius)) {
                    return 2;
                }
            }
        } else if (bars.directionFlag[1]) {
            if (this.posY + addY > fieldHeight - radius) {
                if (addY != 0) {
                    addX = addX * (fieldHeight - radius - this.posY) / addY;
                    addY = fieldHeight - radius - this.posY;
                } else {
                    addX = addY;
                }
                this.angle = FDBBall.calculateReflectAngle(this.angle, 4.71238898038469);
            }
        } else {
            if (this.posY + addY > fieldHeight + radius) {
                return 1;
            }
            if (this.checkBarTouch(this.posX + addX, this.posY + addY, bars.barPosX, fieldHeight - bars.barOverhang + bars.barRadius, radius + bars.barRadius)) {
                return 2;
            }
        }
        this.posX += addX;
        this.posY += addY;
        return 0;
    }

    private boolean checkBarTouch(int ballX, int ballY, int barX, int barY, int touchRadius) {
        int distX = ballX - barX;
        int distY = ballY - barY;
        return Math.pow(touchRadius, 2.0) > Math.pow(distX, 2.0) + Math.pow(distY, 2.0);
    }

    public boolean passBy() {
        --this.effectiveTimeRemain;
        return this.effectiveTimeRemain <= 0;
    }

    public void putOn(FDBBall ball, FDBBars bars, FDBBlocks blocks, FDBGeneral general, FDBPanel field) {
        switch (this.typeAll) {
            case 0: {
                if (this.typePair == 0) {
                    bars.barRadius = bars.barRadiusLong;
                    break;
                }
                bars.barRadius = bars.barRadiusShort;
                break;
            }
            case 1: {
                if (this.typePair == 0) {
                    ball.radiusNow = ball.radiusBig;
                    int b = 0;
                    while (b < field.divideBallVec.size()) {
                        FDBBall dBall = field.divideBallVec.get(b);
                        dBall.radiusNow = dBall.radiusBig;
                        ++b;
                    }
                } else {
                    ball.radiusNow = ball.radiusSmall;
                    int b = 0;
                    while (b < field.divideBallVec.size()) {
                        FDBBall dBall = field.divideBallVec.get(b);
                        dBall.radiusNow = dBall.radiusSmall;
                        ++b;
                    }
                }
                break;
            }
            case 2: {
                if (this.typePair == 0) {
                    ball.speedNow = ball.speedFast;
                    int b = 0;
                    while (b < field.divideBallVec.size()) {
                        FDBBall dBall = field.divideBallVec.get(b);
                        dBall.speedNow = dBall.speedFast;
                        ++b;
                    }
                } else {
                    ball.speedNow = ball.speedSlow;
                    int b = 0;
                    while (b < field.divideBallVec.size()) {
                        FDBBall dBall = field.divideBallVec.get(b);
                        dBall.speedNow = dBall.speedSlow;
                        ++b;
                    }
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                ball.operateLifeFromItem(this.typePair);
                break;
            }
            case 7: {
                blocks.operateBlockNumFormItem(this.typePair, 5);
                break;
            }
            case 8: {
                general.operateScoreFromItem(this.typePair, 150, ball);
                break;
            }
            case 9: {
                field.operateBallNumFromItem(5);
            }
        }
    }

    public void putOff(FDBBall ball, FDBBars bars, FDBBlocks blocks, FDBPanel field) {
        switch (this.typeAll) {
            case 0: {
                bars.barRadius = bars.barRadiusNormal;
                break;
            }
            case 1: {
                ball.radiusNow = ball.radiusNormal;
                int b = 0;
                while (b < field.divideBallVec.size()) {
                    FDBBall dBall = field.divideBallVec.get(b);
                    dBall.radiusNow = dBall.radiusNormal;
                    ++b;
                }
                break;
            }
            case 2: {
                ball.speedNow = ball.speedNormal;
                int b = 0;
                while (b < field.divideBallVec.size()) {
                    FDBBall dBall = field.divideBallVec.get(b);
                    dBall.speedNow = dBall.speedNormal;
                    ++b;
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public int getTimerPaintWidth(int timerWidth) {
        return timerWidth * this.effectiveTimeRemain / this.effectiveTimeMax;
    }
}

