/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;

public class FDBImageSupply
extends Component {
    static final int WHITE = 0;
    static final int YELLOW = 1;
    static final int ORANGE = 2;
    static final int PINK = 3;
    static final int RED = 4;
    static final int BROWN = 5;
    static final int YELLOWGREEN = 6;
    static final int GREEN = 7;
    static final int LIGHTBLUE = 8;
    static final int BLUE = 9;
    static final int PURPLE = 10;
    static final int BLACK = 11;
    static final int NOCOLOR = 12;
    Image[][] blockImages;
    Image[][] itemImages;
    Image ballImage;
    Image barImage;
    Image backImage;
    int backWidth;
    int backHeight;

    public FDBImageSupply(FDBStageLoader stage, FDBBall ball, FDBBars bars, FDBFrame frm) {
        this.createBlockImage(frm);
        this.createItemImage(frm);
        this.formatImages(stage, ball, bars, frm);
    }

    public void formatImages(FDBStageLoader stage, FDBBall ball, FDBBars bars, FDBFrame frm) {
        if (stage.s1.backImage == null) {
            this.ballImage = this.create3DCircleImage(ball.radiusNormal, ball.color, stage.s1.backColor);
            this.barImage = this.create3DCircleImage(bars.barRadiusNormal, bars.barColor, stage.s1.backColor);
        } else {
            this.ballImage = this.create3DCircleImage(ball.radiusNormal, ball.color, null);
            this.barImage = this.create3DCircleImage(bars.barRadiusNormal, bars.barColor, null);
        }
        if (stage.s1.backImage == null) {
            this.backImage = null;
        } else {
            this.backImage = frm.getImage(stage.s1.backImage);
            this.backWidth = this.backImage.getWidth(this);
            this.backHeight = this.backImage.getHeight(this);
        }
    }

    private Image create3DCircleImage(int rad, Color col, Color backCol) {
        int brightPointX = rad * 2 / 3;
        int brightPointY = rad * 2 / 3;
        int[] circleImagePix = new int[(int)Math.pow(rad * 2, 2.0)];
        float[] hsb = new float[3];
        int h = 0;
        while (h < rad * 2) {
            int w = 0;
            while (w < rad * 2) {
                if (Math.pow(w - rad, 2.0) + Math.pow(h - rad, 2.0) > Math.pow(rad, 2.0)) {
                    circleImagePix[h * rad * 2 + w] = backCol != null ? backCol.getRGB() & 0xFFFFFF : 0xFFFFFF;
                } else {
                    Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), hsb);
                    hsb[2] = (float)((double)hsb[2] - (Math.sqrt(Math.pow(w - brightPointX, 2.0) + Math.pow(h - brightPointY, 2.0)) / (double)(rad * 2) - 0.5));
                    if (hsb[2] < 0.0f) {
                        hsb[2] = 0.0f;
                    } else if (hsb[2] > 1.0f) {
                        hsb[2] = 1.0f;
                    }
                    circleImagePix[h * rad * 2 + w] = 0xFF000000 | Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
                }
                ++w;
            }
            ++h;
        }
        if (backCol != null) {
            int h2 = 0;
            while (h2 < rad * 2) {
                int w = 0;
                while (w < rad * 2) {
                    int r2 = (int)(Math.pow(w - rad, 2.0) + Math.pow(h2 - rad, 2.0));
                    if ((double)r2 <= Math.pow(rad, 2.0) && (double)r2 > Math.pow(rad - 1, 2.0)) {
                        int bb = 0;
                        int gg = 0;
                        int rr = 0;
                        int y = -1;
                        while (y <= 1) {
                            int x = -1;
                            while (x <= 1) {
                                if (w + x >= 0 && w + x < rad * 2 && h2 + y >= 0 && h2 + y < rad * 2) {
                                    rr += circleImagePix[(h2 + y) * rad * 2 + (w + x)] >> 16 & 0xFF;
                                    gg += circleImagePix[(h2 + y) * rad * 2 + (w + x)] >> 8 & 0xFF;
                                    bb += circleImagePix[(h2 + y) * rad * 2 + (w + x)] >> 0 & 0xFF;
                                } else {
                                    rr += backCol.getRed();
                                    gg += backCol.getGreen();
                                    bb += backCol.getBlue();
                                }
                                ++x;
                            }
                            ++y;
                        }
                        circleImagePix[h2 * rad * 2 + w] = 0xFF000000 | rr / 9 << 16 | gg / 9 << 8 | bb / 9 << 0;
                    }
                    ++w;
                }
                ++h2;
            }
        }
        MemoryImageSource mis = new MemoryImageSource(rad * 2, rad * 2, circleImagePix, 0, rad * 2);
        Image ret = this.createImage(mis);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(ret, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ret;
    }

    private void createBlockImage(FDBFrame frm) {
        String folderName = "image/block_";
        String[] fileName = new String[]{"w", "y", "o", "m", "r", "t", "k", "g", "l", "a", "p", "b"};
        String extName = ".gif";
        this.blockImages = new Image[12][4];
        int c = 0;
        while (c < 12) {
            int a = 0;
            while (a < 4) {
                this.blockImages[c][a] = frm.getImage(String.valueOf(folderName) + fileName[c] + (a + 1) + extName);
                ++a;
            }
            ++c;
        }
    }

    private void createItemImage(FDBFrame frm) {
        String folderName = "image/item_";
        String[][] fileName = new String[][]{{"barlong", "barshort"}, {"ballbig", "ballsmall"}, {"speedup", "speeddown"}, {"blockhide", "damy"}, {"gothrough", "damy"}, {"keepin", "damy"}, {"lifeup", "lifedown"}, {"blockincrease", "blockdecrease"}, {"scoreup", "scoredown"}, {"ballincrease", "damy"}};
        String extName = ".gif";
        this.itemImages = new Image[10][2];
        int i = 0;
        while (i < 10) {
            if (FDBItem.pairFlag[i]) {
                this.itemImages[i][0] = frm.getImage(String.valueOf(folderName) + fileName[i][0] + extName);
                this.itemImages[i][1] = frm.getImage(String.valueOf(folderName) + fileName[i][1] + extName);
            } else {
                this.itemImages[i][0] = frm.getImage(String.valueOf(folderName) + fileName[i][0] + extName);
            }
            ++i;
        }
    }
}

