/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class FDBBars {
    static final int D_UP = 0;
    static final int D_DOWN = 1;
    static final int D_LEFT = 2;
    static final int D_RIGHT = 3;
    static final int D_ALL = 4;
    int barLength;
    int barOverhang;
    int barRadiusNormal;
    int barRadiusLong;
    int barRadiusShort;
    int barRadius;
    Color barColor;
    boolean[] directionFlag;
    int barPosX;
    int barPosY;

    public FDBBars(FDBStageLoader stage) {
        this.formatBars(stage);
    }

    public void formatBars(FDBStageLoader stage) {
        this.barLength = stage.s1.barsLength;
        this.barOverhang = stage.s1.barsOverhang;
        this.barRadiusNormal = this.calculateBarsRadius(this.barLength, this.barOverhang);
        this.barRadiusLong = this.barRadiusNormal * 3 / 2;
        this.barRadiusShort = this.barRadiusNormal * 2 / 3;
        this.barRadius = this.barRadiusNormal;
        this.barColor = stage.s1.barsColor;
        this.directionFlag = new boolean[4];
        this.directionFlag[0] = stage.s1.direction[0];
        this.directionFlag[1] = stage.s1.direction[1];
        this.directionFlag[2] = stage.s1.direction[2];
        this.directionFlag[3] = stage.s1.direction[3];
    }

    public void setBarsPosition(int tmpX, int tmpY, int fieldWidth, int fieldHeight) {
        if (tmpX < 0) {
            tmpX = 0;
        } else if (tmpX > fieldWidth) {
            tmpX = fieldWidth;
        }
        if (tmpY < 0) {
            tmpY = 0;
        } else if (tmpY > fieldHeight) {
            tmpY = fieldHeight;
        }
        this.barPosX = tmpX;
        this.barPosY = tmpY;
    }

    private int calculateBarsRadius(int length, int overhang) {
        return (int)(Math.pow(length, 2.0) / (double)(8 * overhang) + (double)(overhang / 2));
    }
}

