/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FDBJarDialog
extends JDialog
implements ActionListener {
    static final String NO_STR = "no";
    FDBFrame frame;
    FDBFileIO fileIO;
    File pathJar = null;
    JTextField fieldPath = new JTextField("", 15);
    JButton buttonPath = new JButton("jar\u30d5\u30a1\u30a4\u30eb");
    DefaultComboBoxModel<String> comboModelStart = new DefaultComboBoxModel();
    JRadioButton radioContOn = new JRadioButton("On", true);
    JRadioButton radioContOff = new JRadioButton("Off");
    JRadioButton radioSelectOn = new JRadioButton("\u6700\u521d\u304b\u3089\u5168\u30b9\u30c6\u30fc\u30b8\u53ef\u80fd");
    JRadioButton radioSelectOff = new JRadioButton("\u30af\u30ea\u30a2\u6e08\u307f\u30b9\u30c6\u30fc\u30b8\u306e\u307f", true);
    JTextField fieldTitle = new JTextField(18);
    FDBInfoPanel infoPanel = new FDBInfoPanel(true);
    JTextField fieldMessage = new JTextField(18);
    JButton buttonOk = new JButton("\u51fa\u529b");
    JButton buttonCancel = new JButton("\u53d6\u6d88");

    public FDBJarDialog(FDBFrame frm, FDBFileIO fIO) {
        super(frm, "\u30d7\u30ec\u30a4\u5c02\u7528\u30d5\u30a1\u30a4\u30eb\u51fa\u529b", true);
        this.frame = frm;
        this.fileIO = fIO;
        this.fieldPath.setEditable(false);
        ButtonGroup radioGroup1 = new ButtonGroup();
        radioGroup1.add(this.radioContOn);
        radioGroup1.add(this.radioContOff);
        ButtonGroup radioGroup2 = new ButtonGroup();
        radioGroup2.add(this.radioSelectOn);
        radioGroup2.add(this.radioSelectOff);
        JPanel jarPanel = new JPanel();
        jarPanel.add(this.fieldPath);
        jarPanel.add(this.buttonPath);
        JPanel titlePanel = new JPanel();
        titlePanel.add(new JLabel("\u30bf\u30a4\u30c8\u30eb\uff1a"));
        titlePanel.add(this.fieldTitle);
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BorderLayout());
        messagePanel.add((Component)new JLabel("\u30af\u30ea\u30a2\u5f8c\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\uff1a"), "North");
        messagePanel.add((Component)this.fieldMessage, "Center");
        JPanel autherPanel = new JPanel();
        autherPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u8aac\u660e"));
        autherPanel.setLayout(new BorderLayout());
        autherPanel.add((Component)titlePanel, "North");
        autherPanel.add((Component)this.infoPanel, "Center");
        autherPanel.add((Component)messagePanel, "South");
        JPanel contPanel = new JPanel();
        contPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "option1:\u30b3\u30f3\u30c6\u30a3\u30cb\u30e5\u30fc"));
        contPanel.add(this.radioContOn);
        contPanel.add(this.radioContOff);
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new GridLayout(2, 1));
        selectPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "option2:\u30b9\u30c6\u30fc\u30b8\u9078\u629e"));
        selectPanel.add(this.radioSelectOn);
        selectPanel.add(this.radioSelectOff);
        JPanel startPanel = new JPanel();
        startPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "option3:\u958b\u59cb\u30b9\u30c6\u30fc\u30b8"));
        startPanel.add(new JComboBox<String>(this.comboModelStart));
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new BorderLayout());
        optionPanel.add((Component)contPanel, "North");
        optionPanel.add((Component)selectPanel, "Center");
        optionPanel.add((Component)startPanel, "South");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.buttonOk);
        buttonPanel.add(this.buttonCancel);
        Container cp = this.getContentPane();
        cp.add((Component)jarPanel, "North");
        cp.add((Component)optionPanel, "West");
        cp.add((Component)autherPanel, "Center");
        cp.add((Component)buttonPanel, "South");
        this.buttonPath.addActionListener(this);
        this.buttonOk.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setLatestData(int stg) {
        this.comboModelStart.removeAllElements();
        int s = 1;
        while (s <= stg) {
            this.comboModelStart.addElement(String.valueOf(s));
            ++s;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.buttonPath) {
            File file = this.fileIO.chooseFileOnSave("\u30d7\u30ec\u30a4\u5c02\u7528\u30d5\u30a1\u30a4\u30eb(*.jar)\u306b\u51fa\u529b", "\u51fa\u529b", this.pathJar, "jar");
            if (file != null) {
                this.pathJar = file;
                this.fieldPath.setText(this.pathJar.getPath());
                if (this.fieldTitle.getText().equals("")) {
                    this.fieldTitle.setText(this.pathJar.getName());
                }
            }
        } else if (object == this.buttonOk) {
            if (this.pathJar == null) {
                this.frame.showErrorDialog("\u51fa\u529b\u5148\u306e\u30d7\u30ec\u30a4\u5c02\u7528\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
                return;
            }
            if (this.outputJarFile()) {
                this.frame.showFinishDialog("\u51fa\u529b\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
                this.setVisible(false);
            }
        } else if (object == this.buttonCancel) {
            this.setVisible(false);
        }
    }

    private String getDefaultSetString() {
        FDBSetFile s0 = new FDBSetFile(this.frame);
        s0.setDefaultData(this.fileIO.getFileString(FDBFileIO.getTargetStageFileName(0)));
        int start = Integer.parseInt((String)this.comboModelStart.getSelectedItem());
        if (start != 1) {
            s0.gStageStart = start;
        }
        if (this.radioContOff.isSelected()) {
            s0.gStageContinue = false;
        }
        return s0.getDefaultDataString();
    }

    private boolean outputJarFile() {
        JarFile selfJarFile = this.fileIO.getSelfJarFile();
        int[] setInfo = this.fileIO.getSetInfo(true);
        int stageMax = this.comboModelStart.getSize();
        try {
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attributes.put(Attributes.Name.MAIN_CLASS, "FDBFrame");
            JarOutputStream jos = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.pathJar)), manifest);
            Dimension size = new Dimension(setInfo[1], setInfo[2]);
            int stg = this.radioSelectOn.isSelected() ? 0 : 1;
            String setData = FDBFileIO.getSetFileString(1, size, setInfo[3], stg);
            FDBJarDialog.outputToJarFromString(jos, "fdbset.txt", setData);
            String cipherData = this.frame.cipher.getCipherFileString12(this.pathJar.getName(), this.fieldTitle.getText(), this.infoPanel.getAuther(), this.infoPanel.getComment(), this.fieldMessage.getText());
            FDBJarDialog.outputToJarFromString(jos, "fdbcipher.txt", cipherData);
            Enumeration<JarEntry> entries = selfJarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!FDBFileIO.checkEntryExtention(entry, ".gif", ".class")) continue;
                FDBJarDialog.outputToJarFromJar(jos, selfJarFile, entry.getName());
            }
            String sTarget = FDBFileIO.getTargetStageFileName(0);
            File sBeforeFile = null;
            FDBJarDialog.outputToJarFromString(jos, sTarget, this.getDefaultSetString());
            String bTarget = FDBFileIO.getTargetBlockFileName(0);
            File bBeforeFile = this.fileIO.getWorkFile(FDBFileIO.getTargetBlockFileName(0));
            FDBJarDialog.outputToJarFromFile(jos, bBeforeFile, bTarget);
            int s = 1;
            while (s <= stageMax) {
                sTarget = FDBFileIO.getTargetStageFileName(s);
                sBeforeFile = this.fileIO.getWorkFile(sTarget);
                FDBJarDialog.outputToJarFromFile(jos, sBeforeFile, sTarget);
                bTarget = FDBFileIO.getTargetBlockFileName(s);
                bBeforeFile = this.fileIO.getWorkFile(FDBFileIO.getTargetBlockFileName(s));
                FDBJarDialog.outputToJarFromFile(jos, bBeforeFile, bTarget);
                ++s;
            }
            switch (setInfo[3]) {
                case 0: {
                    s = 0;
                    while (s < 8) {
                        FDBJarDialog.outputToJarFromJar(jos, selfJarFile, "se/" + FDBSound.SOUND_NAME[s] + ".au");
                        ++s;
                    }
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    this.outputToJarFromWorkFolder(jos, "se");
                }
            }
            this.outputToJarFromWorkFolder(jos, "back");
            jos.close();
            return true;
        }
        catch (IOException ioe) {
            this.frame.showErrorDialog("\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + FDBFileIO.BR + ioe.toString());
            return false;
        }
        catch (NullPointerException npe) {
            this.frame.showErrorDialog("\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + FDBFileIO.BR + npe.toString());
            return false;
        }
    }

    private void outputToJarFromWorkFolder(JarOutputStream jos, String folderInWork) throws IOException {
        File beforeFolder = this.fileIO.getWorkFile(folderInWork);
        if (beforeFolder.exists()) {
            String[] targetNames = beforeFolder.list();
            int b = 0;
            while (b < targetNames.length) {
                File before = new File(String.valueOf(beforeFolder.getPath()) + FDBFileIO.SEP + targetNames[b]);
                String target = String.valueOf(folderInWork) + "/" + targetNames[b];
                if (before.isFile()) {
                    FDBJarDialog.outputToJarFromFile(jos, before, target);
                }
                ++b;
            }
        }
    }

    private static void outputToJarFromString(JarOutputStream jos, String target, String data) throws IOException {
        JarEntry cipherEntry = new JarEntry(target);
        jos.putNextEntry(cipherEntry);
        jos.write(data.getBytes());
        jos.closeEntry();
    }

    private static void outputToJarFromJar(JarOutputStream jos, JarFile selfJarFile, String target) throws IOException, NullPointerException {
        JarEntry entryFrom = new JarEntry(target);
        BufferedInputStream bis = new BufferedInputStream(selfJarFile.getInputStream(entryFrom));
        FDBJarDialog.outputToJar(jos, bis, target);
    }

    private static void outputToJarFromFile(JarOutputStream jos, File file, String target) throws IOException {
        if (!file.exists()) {
            return;
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        FDBJarDialog.outputToJar(jos, bis, target);
    }

    private static void outputToJar(JarOutputStream jos, BufferedInputStream bis, String target) throws IOException {
        int b;
        JarEntry entryTo = new JarEntry(target);
        jos.putNextEntry(entryTo);
        while ((b = bis.read()) != -1) {
            jos.write((byte)b);
        }
        jos.closeEntry();
        bis.close();
    }
}

