/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FDBSetDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
ChangeListener,
WindowListener {
    private static final String NO_IMAGE = " - ";
    FDBFrame frame;
    FDBFileIO fileIO;
    FDBSetFile s0;
    FDBSetFile s1;
    DefaultListModel<String> listModelStage = new DefaultListModel();
    JList<String> listStage = new JList<String>(this.listModelStage);
    SpinnerNumberModel barsLength = new SpinnerNumberModel((Number)100, Integer.valueOf(1), null, (Number)10);
    JSpinner spBarsLength = new JSpinner(this.barsLength);
    JButton barsColor = new JButton();
    SpinnerNumberModel barsOverhang = new SpinnerNumberModel((Number)15, Integer.valueOf(1), null, (Number)1);
    JSpinner spBarsOverhang = new JSpinner(this.barsOverhang);
    SpinnerNumberModel ballCount = new SpinnerNumberModel((Number)5, Integer.valueOf(-1), null, (Number)1);
    JSpinner spBallCount = new JSpinner(this.ballCount);
    SpinnerNumberModel ballSpeed = new SpinnerNumberModel((Number)15, Integer.valueOf(1), null, (Number)1);
    JSpinner spBallSpeed = new JSpinner(this.ballSpeed);
    SpinnerNumberModel ballRadius = new SpinnerNumberModel((Number)10, Integer.valueOf(1), null, (Number)1);
    JSpinner spBallRadius = new JSpinner(this.ballRadius);
    JButton ballColor = new JButton();
    JCheckBox wallUp = new JCheckBox("\u4e0a\u3092\u9589\u3058\u308b");
    JCheckBox wallDown = new JCheckBox("\u4e0b\u3092\u9589\u3058\u308b");
    JCheckBox wallLeft = new JCheckBox("\u5de6\u3092\u9589\u3058\u308b");
    JCheckBox wallRight = new JCheckBox("\u53f3\u3092\u9589\u3058\u308b");
    JButton backColor = new JButton();
    JTextField backImage = new JTextField(" - ");
    JButton backImageSelect = new JButton("\u753b\u50cf\u9078\u629e");
    JButton backImageDelete = new JButton("\u53d6\u308a\u6d88\u3057");
    File backImageFile = null;
    SpinnerNumberModel lifeupScore = new SpinnerNumberModel((Number)500, Integer.valueOf(0), null, (Number)100);
    JSpinner spLifeupScore = new JSpinner(this.lifeupScore);
    SpinnerNumberModel powerEffect = new SpinnerNumberModel((Number)5, null, null, (Number)1);
    JSpinner spPowerEffect = new JSpinner(this.powerEffect);
    SpinnerNumberModel clearRate = new SpinnerNumberModel(100, 0, 100, 1);
    JSpinner spClearRate = new JSpinner(this.clearRate);
    SpinnerNumberModel frontLine = new SpinnerNumberModel((Number)15, Integer.valueOf(1), null, (Number)1);
    JSpinner spFrontLine = new JSpinner(this.frontLine);
    SpinnerNumberModel itemRate = new SpinnerNumberModel(15, 0, 100, 1);
    JSpinner spItemRate = new JSpinner(this.itemRate);
    SpinnerNumberModel itemBarLong = new SpinnerNumberModel((Number)6, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemBarLong = new JSpinner(this.itemBarLong);
    SpinnerNumberModel itemBarShort = new SpinnerNumberModel((Number)6, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemBarShort = new JSpinner(this.itemBarShort);
    SpinnerNumberModel itemBallBig = new SpinnerNumberModel((Number)6, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemBallBig = new JSpinner(this.itemBallBig);
    SpinnerNumberModel itemBallSmall = new SpinnerNumberModel((Number)6, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemBallSmall = new JSpinner(this.itemBallSmall);
    SpinnerNumberModel itemSpeedUp = new SpinnerNumberModel((Number)6, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemSpeedUp = new JSpinner(this.itemSpeedUp);
    SpinnerNumberModel itemSpeedDown = new SpinnerNumberModel((Number)6, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemSpeedDown = new JSpinner(this.itemSpeedDown);
    SpinnerNumberModel itemLifeUp = new SpinnerNumberModel((Number)2, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemLifeUp = new JSpinner(this.itemLifeUp);
    SpinnerNumberModel itemLifeDown = new SpinnerNumberModel((Number)2, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemLifeDown = new JSpinner(this.itemLifeDown);
    SpinnerNumberModel itemBlockIncrease = new SpinnerNumberModel((Number)2, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemBlockIncrease = new JSpinner(this.itemBlockIncrease);
    SpinnerNumberModel itemBlockDecrease = new SpinnerNumberModel((Number)2, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemBlockDecrease = new JSpinner(this.itemBlockDecrease);
    SpinnerNumberModel itemScoreUp = new SpinnerNumberModel((Number)2, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemScoreUp = new JSpinner(this.itemScoreUp);
    SpinnerNumberModel itemScoreDown = new SpinnerNumberModel((Number)2, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemScoreDown = new JSpinner(this.itemScoreDown);
    SpinnerNumberModel itemBlockHide = new SpinnerNumberModel((Number)2, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemBlockHide = new JSpinner(this.itemBlockHide);
    SpinnerNumberModel itemGoThrough = new SpinnerNumberModel((Number)1, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemGoThrough = new JSpinner(this.itemGoThrough);
    SpinnerNumberModel itemKeepIn = new SpinnerNumberModel((Number)1, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemKeepIn = new JSpinner(this.itemKeepIn);
    SpinnerNumberModel itemBallIncrease = new SpinnerNumberModel((Number)1, Integer.valueOf(0), null, (Number)1);
    JSpinner spItemBallIncrease = new JSpinner(this.itemBallIncrease);
    JButton buttonDelete = new JButton("\u30b9\u30c6\u30fc\u30b8\u521d\u671f\u5316");
    JButton buttonSave = new JButton("\u30b9\u30c6\u30fc\u30b8\u4fdd\u5b58");
    JButton buttonEnd = new JButton("\u7d42\u4e86");
    int selected;
    boolean changed;

    public FDBSetDialog(FDBFrame frm, FDBFileIO fIO) {
        super(frm, "\u30b9\u30c6\u30fc\u30b8\u8a2d\u5b9a", true);
        this.frame = frm;
        this.fileIO = fIO;
        this.s0 = new FDBSetFile(this.frame);
        this.s1 = new FDBSetFile(this.frame);
        this.makeStageList(30);
        JPanel panelStage = new JPanel();
        JScrollPane scPanel = new JScrollPane(this.listStage);
        scPanel.setPreferredSize(new Dimension(120, 400));
        panelStage.add(scPanel);
        JPanel panelSetBar = new JPanel();
        panelSetBar.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u30d0\u30fc"));
        panelSetBar.setLayout(new BorderLayout());
        JPanel panelSetBarA = new JPanel();
        JPanel panelSetBarB = new JPanel();
        panelSetBarA.setLayout(new GridLayout(4, 1));
        panelSetBarB.setLayout(new GridLayout(4, 1));
        panelSetBarA.add(new JLabel("\u5e45"));
        panelSetBarB.add(this.spBarsLength);
        this.barsColor.setBackground(Color.BLACK);
        panelSetBarA.add(new JLabel("\u8272"));
        panelSetBarB.add(this.barsColor);
        panelSetBarA.add(new JLabel("\u9ad8\u3055"));
        panelSetBarB.add(new JSpinner(this.barsOverhang));
        panelSetBar.add((Component)panelSetBarA, "West");
        panelSetBar.add((Component)panelSetBarB, "Center");
        JPanel panelSetBall = new JPanel();
        panelSetBall.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u30dc\u30fc\u30eb"));
        panelSetBall.setLayout(new BorderLayout());
        JPanel panelSetBallA = new JPanel();
        JPanel panelSetBallB = new JPanel();
        panelSetBallA.setLayout(new GridLayout(4, 1));
        panelSetBallB.setLayout(new GridLayout(4, 1));
        panelSetBallA.add(new JLabel("\u500b\u6570"));
        panelSetBallB.add(new JSpinner(this.ballCount));
        panelSetBallA.add(new JLabel("\u901f\u5ea6"));
        panelSetBallB.add(new JSpinner(this.ballSpeed));
        panelSetBallA.add(new JLabel("\u534a\u5f84"));
        panelSetBallB.add(new JSpinner(this.ballRadius));
        this.ballColor.setBackground(Color.BLACK);
        panelSetBallA.add(new JLabel("\u8272"));
        panelSetBallB.add(this.ballColor);
        panelSetBall.add((Component)panelSetBallA, "West");
        panelSetBall.add((Component)panelSetBallB, "Center");
        JPanel panelSetWall = new JPanel();
        panelSetWall.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u58c1"));
        panelSetWall.setLayout(new GridLayout(4, 1));
        panelSetWall.add(this.wallUp);
        panelSetWall.add(this.wallDown);
        panelSetWall.add(this.wallLeft);
        panelSetWall.add(this.wallRight);
        JPanel panelSetBack = new JPanel();
        panelSetBack.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u80cc\u666f"));
        panelSetBack.setLayout(new BorderLayout());
        JPanel panelSetBackA = new JPanel();
        JPanel panelSetBackB = new JPanel();
        panelSetBackA.setLayout(new GridLayout(4, 1));
        panelSetBackB.setLayout(new GridLayout(4, 1));
        this.backColor.setBackground(Color.WHITE);
        panelSetBackA.add(new JLabel("\u8272"));
        panelSetBackB.add(this.backColor);
        this.backImage.setEditable(false);
        panelSetBackA.add(new JLabel("\u753b\u50cf"));
        panelSetBackB.add(this.backImage);
        panelSetBackA.add(new JLabel(""));
        panelSetBackB.add(this.backImageSelect);
        panelSetBackA.add(new JLabel(""));
        panelSetBackB.add(this.backImageDelete);
        panelSetBack.add((Component)panelSetBackA, "West");
        panelSetBack.add((Component)panelSetBackB, "Center");
        JPanel panelSetOther = new JPanel();
        panelSetOther.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u305d\u306e\u4ed6"));
        panelSetOther.setLayout(new BorderLayout());
        JPanel panelSetOtherA = new JPanel();
        JPanel panelSetOtherB = new JPanel();
        panelSetOtherA.setLayout(new GridLayout(4, 1));
        panelSetOtherB.setLayout(new GridLayout(4, 1));
        panelSetOtherA.add(new JLabel("\u30dc\u30fc\u30eb\u304c\u5897\u52a0\u3059\u308b\u5f97\u70b9"));
        panelSetOtherB.add(new JSpinner(this.lifeupScore));
        panelSetOtherA.add(new JLabel("\u53cd\u767a\u529b\u306e\u5f37\u3055"));
        panelSetOtherB.add(new JSpinner(this.powerEffect));
        panelSetOtherA.add(new JLabel("\u4f55\uff05\u7834\u58ca\u3067\u30af\u30ea\u30a2\u30fc\u304b"));
        panelSetOtherB.add(new JSpinner(this.clearRate));
        panelSetOtherA.add(new JLabel("\u30d0\u30fc\u3068\u30d6\u30ed\u30c3\u30af\u306e\u9699\u9593"));
        panelSetOtherB.add(new JSpinner(this.frontLine));
        panelSetOther.add((Component)panelSetOtherA, "Center");
        panelSetOther.add((Component)panelSetOtherB, "East");
        JPanel panelSetItem = new JPanel();
        panelSetItem.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u30a2\u30a4\u30c6\u30e0"));
        panelSetItem.setLayout(new GridLayout(1, 2));
        JPanel panelSetItemA = new JPanel();
        panelSetItemA.setLayout(new BorderLayout());
        JPanel panelSetItemAL = new JPanel();
        JPanel panelSetItemAR = new JPanel();
        panelSetItemAL.setLayout(new GridLayout(10, 1));
        panelSetItemAR.setLayout(new GridLayout(10, 1));
        panelSetItemAL.add(new JLabel("\u51fa\u73fe\u7387\uff08\uff05\uff09"));
        panelSetItemAR.add(new JSpinner(this.itemRate));
        panelSetItemAL.add(new JLabel("[\u7a2e\u985e]"));
        panelSetItemAR.add(new JLabel("[\u6bd4\u7387]"));
        panelSetItemAL.add(new JLabel("\u30d0\u30fc\u62e1\u5f35"));
        panelSetItemAR.add(new JSpinner(this.itemBarLong));
        panelSetItemAL.add(new JLabel("\u30d0\u30fc\u77ed\u7e2e"));
        panelSetItemAR.add(new JSpinner(this.itemBarShort));
        panelSetItemAL.add(new JLabel("\u30dc\u30fc\u30eb\u62e1\u5927"));
        panelSetItemAR.add(new JSpinner(this.itemBallBig));
        panelSetItemAL.add(new JLabel("\u30dc\u30fc\u30eb\u7e2e\u5c0f"));
        panelSetItemAR.add(new JSpinner(this.itemBallSmall));
        panelSetItemAL.add(new JLabel("\u901f\u5ea6\u5897\u52a0"));
        panelSetItemAR.add(new JSpinner(this.itemSpeedUp));
        panelSetItemAL.add(new JLabel("\u901f\u5ea6\u6e1b\u5c11"));
        panelSetItemAR.add(new JSpinner(this.itemSpeedDown));
        panelSetItemAL.add(new JLabel("\u30dc\u30fc\u30eb\u5897\u52a0"));
        panelSetItemAR.add(new JSpinner(this.itemLifeUp));
        panelSetItemAL.add(new JLabel("\u30dc\u30fc\u30eb\u6e1b\u5c11"));
        panelSetItemAR.add(new JSpinner(this.itemLifeDown));
        panelSetItemA.add((Component)panelSetItemAL, "Center");
        panelSetItemA.add((Component)panelSetItemAR, "East");
        JPanel panelSetItemB = new JPanel();
        panelSetItemB.setLayout(new BorderLayout());
        JPanel panelSetItemBL = new JPanel();
        JPanel panelSetItemBR = new JPanel();
        panelSetItemBL.setLayout(new GridLayout(10, 1));
        panelSetItemBR.setLayout(new GridLayout(10, 1));
        panelSetItemBL.add(new JLabel(""));
        panelSetItemBR.add(new JLabel(""));
        panelSetItemBL.add(new JLabel("\u3000[\u7a2e\u985e]"));
        panelSetItemBR.add(new JLabel("[\u6bd4\u7387]"));
        panelSetItemBL.add(new JLabel("\u3000\u30d6\u30ed\u30c3\u30af\u5897\u52a0"));
        panelSetItemBR.add(new JSpinner(this.itemBlockIncrease));
        panelSetItemBL.add(new JLabel("\u3000\u30d6\u30ed\u30c3\u30af\u6e1b\u5c11"));
        panelSetItemBR.add(new JSpinner(this.itemBlockDecrease));
        panelSetItemBL.add(new JLabel("\u3000\u5f97\u70b9\u5897\u52a0"));
        panelSetItemBR.add(new JSpinner(this.itemScoreUp));
        panelSetItemBL.add(new JLabel("\u3000\u5f97\u70b9\u6e1b\u5c11"));
        panelSetItemBR.add(new JSpinner(this.itemScoreDown));
        panelSetItemBL.add(new JLabel("\u3000\u30d6\u30ed\u30c3\u30af\u4e0d\u53ef\u8996"));
        panelSetItemBR.add(new JSpinner(this.itemBlockHide));
        panelSetItemBL.add(new JLabel("\u3000\u30d6\u30ed\u30c3\u30af\u8cab\u901a"));
        panelSetItemBR.add(new JSpinner(this.itemGoThrough));
        panelSetItemBL.add(new JLabel("\u3000\u30dc\u30fc\u30eb\u4fdd\u6301"));
        panelSetItemBR.add(new JSpinner(this.itemKeepIn));
        panelSetItemBL.add(new JLabel("\u3000\u30dc\u30fc\u30eb\u5206\u88c2"));
        panelSetItemBR.add(new JSpinner(this.itemBallIncrease));
        panelSetItemB.add((Component)panelSetItemBL, "Center");
        panelSetItemB.add((Component)panelSetItemBR, "East");
        panelSetItem.add(panelSetItemA);
        panelSetItem.add(panelSetItemB);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        GridBagLayout gbl = new GridBagLayout();
        JPanel panelSet = new JPanel();
        panelSet.setLayout(gbl);
        this.setPanelPos(gbc, gbl, 0, 0, 1, 1, panelSetBar);
        panelSet.add(panelSetBar);
        this.setPanelPos(gbc, gbl, 1, 0, 1, 1, panelSetBall);
        panelSet.add(panelSetBall);
        this.setPanelPos(gbc, gbl, 0, 1, 1, 1, panelSetWall);
        panelSet.add(panelSetWall);
        this.setPanelPos(gbc, gbl, 2, 0, 1, 1, panelSetBack);
        panelSet.add(panelSetBack);
        this.setPanelPos(gbc, gbl, 1, 1, 2, 1, panelSetOther);
        panelSet.add(panelSetOther);
        this.setPanelPos(gbc, gbl, 0, 2, 0, 0, panelSetItem);
        panelSet.add(panelSetItem);
        JPanel panelBtn = new JPanel();
        panelBtn.add(this.buttonDelete);
        panelBtn.add(this.buttonSave);
        panelBtn.add(this.buttonEnd);
        this.setLayout(new BorderLayout());
        this.add((Component)panelStage, "West");
        this.add((Component)panelSet, "Center");
        this.add((Component)panelBtn, "South");
        this.listStage.addListSelectionListener(this);
        this.spBarsLength.addChangeListener(this);
        this.barsColor.addActionListener(this);
        this.spBarsOverhang.addChangeListener(this);
        this.spBallCount.addChangeListener(this);
        this.spBallSpeed.addChangeListener(this);
        this.spBallRadius.addChangeListener(this);
        this.ballColor.addActionListener(this);
        this.wallUp.addActionListener(this);
        this.wallDown.addActionListener(this);
        this.wallLeft.addActionListener(this);
        this.wallRight.addActionListener(this);
        this.backColor.addActionListener(this);
        this.backImageSelect.addActionListener(this);
        this.backImageDelete.addActionListener(this);
        this.spLifeupScore.addChangeListener(this);
        this.spPowerEffect.addChangeListener(this);
        this.spClearRate.addChangeListener(this);
        this.spFrontLine.addChangeListener(this);
        this.spItemRate.addChangeListener(this);
        this.spItemBarLong.addChangeListener(this);
        this.spItemBarShort.addChangeListener(this);
        this.spItemBallBig.addChangeListener(this);
        this.spItemBallSmall.addChangeListener(this);
        this.spItemSpeedUp.addChangeListener(this);
        this.spItemSpeedDown.addChangeListener(this);
        this.spItemLifeUp.addChangeListener(this);
        this.spItemLifeDown.addChangeListener(this);
        this.spItemBlockIncrease.addChangeListener(this);
        this.spItemBlockDecrease.addChangeListener(this);
        this.spItemScoreUp.addChangeListener(this);
        this.spItemScoreDown.addChangeListener(this);
        this.spItemBlockHide.addChangeListener(this);
        this.spItemGoThrough.addChangeListener(this);
        this.spItemKeepIn.addChangeListener(this);
        this.spItemBallIncrease.addChangeListener(this);
        this.buttonDelete.addActionListener(this);
        this.buttonSave.addActionListener(this);
        this.buttonEnd.addActionListener(this);
        this.addWindowListener(this);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void setPanelPos(GridBagConstraints gbc, GridBagLayout gbl, int x, int y, int w, int h, JPanel panel) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbl.setConstraints(panel, gbc);
    }

    private boolean checkChanged(int type) {
        if (this.changed) {
            int ret = JOptionPane.showConfirmDialog(this, "\u30b9\u30c6\u30fc\u30b8\u8a2d\u5b9a\u306b\u5909\u66f4\u304c\u3042\u308a\u307e\u3059\u3002" + FDBFileIO.BR + "\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f", "\u78ba\u8a8d", type);
            switch (ret) {
                case 0: {
                    this.saveStageSetting();
                    this.setChanged(false);
                    return true;
                }
                case 1: {
                    this.setChanged(false);
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    private void setChanged(boolean f) {
        if (f) {
            this.changed = true;
            this.buttonSave.setEnabled(true);
            this.setTitle("\u30b9\u30c6\u30fc\u30b8\u8a2d\u5b9a\uff08\u5909\u66f4\u3042\u308a\uff09");
        } else {
            this.changed = false;
            this.buttonSave.setEnabled(false);
            this.setTitle("\u30b9\u30c6\u30fc\u30b8\u8a2d\u5b9a");
        }
    }

    private void makeStageList(int num) {
        this.listModelStage.clear();
        this.listModelStage.addElement("default" + this.fileIO.checkDefaultStageFileInWorkFolder());
        int n = 1;
        while (n <= num) {
            this.listModelStage.addElement("stage " + n + this.fileIO.checkFileInWorkFolder(FDBFileIO.getTargetStageFileName(n)));
            ++n;
        }
        this.listStage.setSelectedIndex(0);
        this.selected = 0;
    }

    private void changeSelectedListElement() {
        if (this.selected == 0) {
            this.listModelStage.set(0, "default" + this.fileIO.checkDefaultStageFileInWorkFolder());
        } else {
            this.listModelStage.set(this.selected, "stage " + this.selected + this.fileIO.checkFileInWorkFolder(FDBFileIO.getTargetStageFileName(this.selected)));
        }
    }

    public void setLatestData(FDBSetFile defSetFile, int stg) {
        this.s0 = defSetFile;
        this.makeStageList(stg);
        this.reflectSelectedStageToPanel();
    }

    private void transferDataToPanel(FDBSetFile set) {
        this.lifeupScore.setValue(set.lifeupScore);
        this.powerEffect.setValue(set.powerEffect);
        if (set.ballCount == -2) {
            this.ballCount.setValue(0);
        } else {
            this.ballCount.setValue(set.ballCount);
        }
        this.ballSpeed.setValue(set.ballSpeed);
        this.ballRadius.setValue(set.ballRadius);
        this.ballColor.setBackground(set.ballColor);
        this.barsLength.setValue(set.barsLength);
        this.barsColor.setBackground(set.barsColor);
        this.barsOverhang.setValue(set.barsOverhang);
        this.wallUp.setSelected(set.direction[0]);
        this.wallDown.setSelected(set.direction[1]);
        this.wallLeft.setSelected(set.direction[2]);
        this.wallRight.setSelected(set.direction[3]);
        this.clearRate.setValue(set.clearRate);
        this.frontLine.setValue(set.frontLine);
        this.backColor.setBackground(set.backColor);
        if (set.backImage == null) {
            this.backImage.setText(NO_IMAGE);
        } else {
            this.backImage.setText(FDBFileIO.changeImagePathToName(set.backImage));
        }
        this.backImageFile = null;
        this.itemRate.setValue(set.itemRate);
        this.itemBarLong.setValue(set.itemRatio[0][0]);
        this.itemBarShort.setValue(set.itemRatio[0][1]);
        this.itemBallBig.setValue(set.itemRatio[1][0]);
        this.itemBallSmall.setValue(set.itemRatio[1][1]);
        this.itemSpeedUp.setValue(set.itemRatio[2][0]);
        this.itemSpeedDown.setValue(set.itemRatio[2][1]);
        this.itemBlockHide.setValue(set.itemRatio[3][0]);
        this.itemGoThrough.setValue(set.itemRatio[4][0]);
        this.itemKeepIn.setValue(set.itemRatio[5][0]);
        this.itemLifeUp.setValue(set.itemRatio[6][0]);
        this.itemLifeDown.setValue(set.itemRatio[6][1]);
        this.itemBlockIncrease.setValue(set.itemRatio[7][0]);
        this.itemBlockDecrease.setValue(set.itemRatio[7][1]);
        this.itemScoreUp.setValue(set.itemRatio[8][0]);
        this.itemScoreDown.setValue(set.itemRatio[8][1]);
        this.itemBallIncrease.setValue(set.itemRatio[9][0]);
    }

    private void transferDataToSetfile(FDBSetFile set) {
        set.lifeupScore = (Integer)this.lifeupScore.getValue();
        set.powerEffect = (Integer)this.powerEffect.getValue();
        int bC = (Integer)this.ballCount.getValue();
        set.ballCount = bC == 0 ? -2 : bC;
        set.ballSpeed = (Integer)this.ballSpeed.getValue();
        set.ballRadius = (Integer)this.ballRadius.getValue();
        set.ballColor = this.ballColor.getBackground();
        set.barsLength = (Integer)this.barsLength.getValue();
        set.barsColor = this.barsColor.getBackground();
        set.barsOverhang = (Integer)this.barsOverhang.getValue();
        set.direction[0] = this.wallUp.isSelected();
        set.direction[1] = this.wallDown.isSelected();
        set.direction[2] = this.wallLeft.isSelected();
        set.direction[3] = this.wallRight.isSelected();
        set.clearRate = (Integer)this.clearRate.getValue();
        set.frontLine = (Integer)this.frontLine.getValue();
        set.backColor = this.backColor.getBackground();
        set.backImage = this.backImage.getText().equals(NO_IMAGE) ? null : (this.backImageFile == null ? FDBFileIO.changeImageNameToPath(this.backImage.getText()) : FDBFileIO.changeImageNameToPath(this.backImageFile.getName()));
        set.itemRate = (Integer)this.itemRate.getValue();
        set.itemRatio[0][0] = (Integer)this.itemBarLong.getValue();
        set.itemRatio[0][1] = (Integer)this.itemBarShort.getValue();
        set.itemRatio[1][0] = (Integer)this.itemBallBig.getValue();
        set.itemRatio[1][1] = (Integer)this.itemBallSmall.getValue();
        set.itemRatio[2][0] = (Integer)this.itemSpeedUp.getValue();
        set.itemRatio[2][1] = (Integer)this.itemSpeedDown.getValue();
        set.itemRatio[3][0] = (Integer)this.itemBlockHide.getValue();
        set.itemRatio[4][0] = (Integer)this.itemGoThrough.getValue();
        set.itemRatio[5][0] = (Integer)this.itemKeepIn.getValue();
        set.itemRatio[6][0] = (Integer)this.itemLifeUp.getValue();
        set.itemRatio[6][1] = (Integer)this.itemLifeDown.getValue();
        set.itemRatio[7][0] = (Integer)this.itemBlockIncrease.getValue();
        set.itemRatio[7][1] = (Integer)this.itemBlockDecrease.getValue();
        set.itemRatio[8][0] = (Integer)this.itemScoreUp.getValue();
        set.itemRatio[8][1] = (Integer)this.itemScoreDown.getValue();
        set.itemRatio[9][0] = (Integer)this.itemBallIncrease.getValue();
    }

    private void reflectSelectedStageToPanel() {
        if (this.selected == 0) {
            this.s0.setDefaultData(this.fileIO.getStageData(0));
            this.transferDataToPanel(this.s0);
        } else {
            this.s1.setStageData(this.fileIO.getStageData(this.selected), false, this.s0);
            this.transferDataToPanel(this.s1);
        }
        this.setChanged(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.buttonDelete) {
            if (this.selected == 0) {
                this.fileIO.makeFirstStageFile(this.listModelStage.getSize() - 1);
            } else {
                this.fileIO.deleteStageFile(this.selected);
            }
            this.reflectSelectedStageToPanel();
            this.changeSelectedListElement();
            this.fileIO.changePuzzle(false);
        } else if (object == this.buttonSave) {
            this.saveStageSetting();
        } else if (object == this.buttonEnd) {
            if (!this.checkChanged(1)) {
                return;
            }
            this.fileIO.deleteUselessBackImages(this.listModelStage.getSize() - 1);
            this.frame.restartPuzzle(true);
            this.setVisible(false);
        } else if (object == this.ballColor) {
            this.ballColor.setBackground(this.selectColor(this.ballColor));
        } else if (object == this.barsColor) {
            this.barsColor.setBackground(this.selectColor(this.barsColor));
        } else if (object == this.backColor) {
            this.backColor.setBackground(this.selectColor(this.backColor));
        } else if (object == this.backImageSelect) {
            File file = this.fileIO.chooseFileOnLoad("\u80cc\u666f\u753b\u50cf\u3092\u9078\u629e", "\u9078\u629e", this.backImageFile);
            if (file != null) {
                this.backImage.setText(file.getName());
                this.backImageFile = file;
                this.setChanged(true);
            }
        } else if (object == this.backImageDelete) {
            this.backImage.setText(NO_IMAGE);
            this.backImageFile = null;
            this.setChanged(true);
        } else if (object == this.wallUp) {
            this.checkWallOpen();
        } else if (object == this.wallDown) {
            this.checkWallOpen();
        } else if (object == this.wallLeft) {
            this.checkWallOpen();
        } else if (object == this.wallRight) {
            this.checkWallOpen();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int f = this.listStage.getMinSelectionIndex();
        int l = this.listStage.getMaxSelectionIndex();
        if (this.selected == f && this.selected == l) {
            return;
        }
        if (!this.checkChanged(1)) {
            this.listStage.removeListSelectionListener(this);
            this.listStage.setSelectedIndex(this.selected);
            this.listStage.addListSelectionListener(this);
            return;
        }
        if (f == this.selected) {
            this.listStage.setSelectedIndex(l);
            this.selected = l;
        } else {
            this.listStage.setSelectedIndex(f);
            this.selected = f;
        }
        this.reflectSelectedStageToPanel();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setChanged(true);
    }

    private void saveStageSetting() {
        if (this.selected == 0) {
            this.transferDataToSetfile(this.s0);
            this.fileIO.makeStageFile(0, this.s0.getDefaultDataString());
        } else {
            this.transferDataToSetfile(this.s1);
            this.fileIO.makeStageFile(this.selected, this.s1.getStageDataString(this.s0));
        }
        if (this.backImageFile != null) {
            this.fileIO.copyBackImage(this.backImageFile);
        }
        this.changeSelectedListElement();
        this.fileIO.changePuzzle(false);
        this.setChanged(false);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.checkChanged(0);
        this.fileIO.deleteUselessBackImages(this.listModelStage.getSize() - 1);
        this.frame.restartPuzzle(true);
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    private Color selectColor(JButton button) {
        Color cc = JColorChooser.showDialog(this.frame, "\u80cc\u666f\u8272\u3092\u9078\u629e", button.getBackground());
        if (cc != null) {
            this.setChanged(true);
            return cc;
        }
        return button.getBackground();
    }

    private void checkWallOpen() {
        if (this.wallUp.isSelected() && this.wallDown.isSelected() && this.wallLeft.isSelected() && this.wallRight.isSelected()) {
            this.wallDown.setSelected(false);
        }
        this.setChanged(true);
    }
}

