/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FDBSoundDialog
extends JDialog
implements ActionListener,
ChangeListener {
    FDBFrame frame;
    FDBFileIO fileIO;
    JRadioButton defaultRadio = new JRadioButton("\u5185\u90e8");
    JRadioButton offRadio = new JRadioButton("\u306a\u3057");
    JRadioButton folderRadio = new JRadioButton("\u5916\u90e8\u304b\u3089\u53d6\u308a\u8fbc\u307f");
    JComboBox<String> typeCombo = new JComboBox<String>(new String[]{"au", "wav"});
    JButton buttonFolder = new JButton("\u30d5\u30a9\u30eb\u30c0\u9078\u629e");
    JButton buttonOk = new JButton("\u4e86\u89e3");
    JButton buttonCancel = new JButton("\u53d6\u6d88");

    public FDBSoundDialog(FDBFrame frm, FDBFileIO fIO) {
        super(frm, "\u52b9\u679c\u97f3\u6307\u5b9a", true);
        this.frame = frm;
        this.fileIO = fIO;
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.defaultRadio);
        bg.add(this.offRadio);
        bg.add(this.folderRadio);
        this.defaultRadio.setSelected(true);
        this.enableButton();
        JPanel panelRadio = new JPanel();
        panelRadio.add(this.defaultRadio);
        panelRadio.add(this.offRadio);
        panelRadio.add(this.folderRadio);
        panelRadio.add(this.typeCombo);
        this.typeCombo.setSelectedItem("wav");
        JPanel panelBtn = new JPanel();
        panelBtn.add(this.buttonFolder);
        panelBtn.add(this.buttonOk);
        panelBtn.add(this.buttonCancel);
        this.setLayout(new BorderLayout());
        this.add((Component)panelRadio, "Center");
        this.add((Component)panelBtn, "South");
        this.defaultRadio.addChangeListener(this);
        this.offRadio.addChangeListener(this);
        this.folderRadio.addChangeListener(this);
        this.buttonFolder.addActionListener(this);
        this.buttonOk.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setLatestData(int snd) {
        switch (snd) {
            case 0: {
                this.defaultRadio.setSelected(true);
                break;
            }
            case 1: {
                this.offRadio.setSelected(true);
                break;
            }
            case 2: {
                this.folderRadio.setSelected(true);
                this.typeCombo.setSelectedItem("au");
                break;
            }
            case 3: {
                this.folderRadio.setSelected(true);
                this.typeCombo.setSelectedItem("wav");
                break;
            }
            default: {
                this.defaultRadio.setSelected(true);
            }
        }
        this.enableButton();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.buttonFolder) {
            File dir = this.fileIO.chooseFolder("\u52b9\u679c\u97f3\u304c\u5165\u3063\u305f\u30d5\u30a9\u30eb\u30c0\u3092\u9078\u629e", "\u9078\u629e", null);
            if (dir == null) {
                return;
            }
            String ext = (String)this.typeCombo.getSelectedItem();
            this.fileIO.copySEFiles(dir, ext);
            if (ext.equals("au")) {
                this.frame.changeBaseSetting(2);
            } else if (ext.equals("wav")) {
                this.frame.changeBaseSetting(3);
            }
            this.fileIO.changePuzzle(false);
            this.frame.restartPuzzle(true);
            this.setVisible(false);
        } else if (object == this.buttonOk) {
            this.fileIO.deleteSEFolder();
            if (this.defaultRadio.isSelected()) {
                this.frame.changeBaseSetting(0);
            } else if (this.offRadio.isSelected()) {
                this.frame.changeBaseSetting(1);
            }
            this.fileIO.changePuzzle(false);
            this.frame.restartPuzzle(true);
            this.setVisible(false);
        } else if (object == this.buttonCancel) {
            this.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.enableButton();
    }

    private void enableButton() {
        if (this.folderRadio.isSelected()) {
            this.buttonFolder.setEnabled(true);
            this.buttonOk.setEnabled(false);
            this.typeCombo.setEnabled(true);
        } else {
            this.buttonFolder.setEnabled(false);
            this.buttonOk.setEnabled(true);
            this.typeCombo.setEnabled(false);
        }
    }
}

