/** nengowin.cpp
 * aENϊ
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + Boost C++ Libraries
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01-19-01.shtm
 */
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <sstream>
#include <string>
#include <vector>
#include <locale>
#include <regex>
#include <cmath>
#include <winsock2.h>
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include <richedit.h>
#include <boost/format.hpp>
#include <boost/program_options.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include "resource.h"
#include "pahooNormalizeText.hpp"

using namespace std;
using namespace boost;
using namespace boost::property_tree;
using namespace boost::program_options;

// 萔Ȃ ==================================================================
#define MAKER		"pahoo.org"				// 쐬
#define APPNAME		"nengowin"				// AvP[V
#define APPNAMEJP	"aENϊ"	// AvP[Vi{j
#define APPVERSION	"1.2.9"					// o[W
#define APPYEAR		"2020-25"				// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-19-01.shtm"	// QlTCg

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// ftHgۑt@C
#define SAVEFILE	"nengowin.txt"

// ̌ϊt@C
#define TABLEERA_FNAME	"etc/era.txt"

// IvVۑt@CFύXs
#define OPTIONFILE	"option.txt"

// ݂̃C^[tFCX
HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// ϊvV
string Option;

// ϊIvV̏l
#define NOPTION_INIT	"C1hH"

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// G[EbZ[Wi[pyύXsz
string ErrorMessage;

// pahooNormalizeTextIuWFNg
pahooNormalizeText* pNT;

// char*obt@TCY
#define SIZE_BUFF	512

// ϊeLXgilj
#define DEF_SOUR	"clNꌎOAHE̐킢NB1023AVcʁB1868N125ɑkēKpꂽB2N517AܗŊsJAC푈͏IB"

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
p܂ޖp\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃CuCt[[NCAPI𗘗pĂ܂D
@MinGWig++j^Boost C++Cu
)")
% APPNAMEJP
% APPVERSION
% APPYEAR).str();

// CUIwv
string Help = (boost::format(R"(
%1%  o[W %2%

nengo.exe -IvV
        -s, --sour   ̓eLXgt@C
        -c, --clip   Nbv{[h
        -d, --dest   o̓eLXgt@C
        -p, --paste  Nbv{[h֏o
        -o, --option ϊiׂĎw\jFGUIłƓp
                A@ɓ
                W@aɓ
                C@(a)
                1@ޗǎȍ~
                2@Vȍ~
                0@ϊȂ
                h@ϊ()Fp
                z@@@@@@FSp
                k@@@@@@F(P)
                l@@@@@@F
                H@ϊ(a)Fp
                Z@@@@@@FSp
                K@@@@@@F(P)
                L@@@@@@F
                PCɕۑCNɂ͏ȗ\łD
        -v, --version o[W
        -h, --help    ICwv
)")
% APPNAMEJP
% APPVERSION).str();

// ϊIvVǍ^ۑ =================================================
/**
 * AppDatãpX擾
 * @param	char* appname AvP[V
 * @return	string pX
 */
string getMyPath(const char* appname) {
	static TCHAR myPath[MAX_PATH] = "";

	if (strlen(myPath) == 0) {
		if (SHGetSpecialFolderPath(NULL, myPath, CSIDL_APPDATA, 0)) {
			TCHAR *ptmp = _tcsrchr(myPath, _T('\\'));
			if (ptmp != NULL) {
				ptmp = _tcsinc(ptmp);
				*ptmp = _T('\0');
			}
			strcat(myPath, _T("Roaming"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\pahoo.org"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
			strcat(myPath, _T(appname));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
		} else {
		}
	}
	return (string)myPath;
}

/**
 * p[^̏
 * @param	Ȃ
 * @return	Ȃ
 */
void initParameter(void) {
	Option = NOPTION_INIT;
	hParent_X = 0;
	hParent_Y = 0;
}

/**
 * p[^̓ǂݍ
 * @param	Ȃ
 * @return	Ȃ
 */
void loadParameter(void) {
	ptree pt;

	// lݒ
	initParameter();

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (optional<string>str = pt.get_optional<string>("parameter")) {
			} else {
				return;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "option") {
					Option = (string)it.second.data();
				} else if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			initParameter();
			return;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		initParameter();
		return;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
}

/**
 * p[^̕ۑ
 * @param	Ȃ
 * @return	Ȃ
 */
void saveParameter(void) {
#ifndef CMDAPP
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
#endif

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", Option);
	child1.add("<xmlattr>.type", "option");
	ptree& child2 = pt.add("parameter.param", hParent_X);
	child2.add("<xmlattr>.type", "wx");
	ptree& child3 = pt.add("parameter.param", hParent_Y);
	child3.add("<xmlattr>.type", "wy");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

/**
 * p[^̍폜
 * @param	Ȃ
 * @return	Ȃ
 */
void delParameter(void) {
	remove((getMyPath(APPNAME) + APPNAME + ".xml").c_str());

	// lݒ
	initParameter();
}

// Nbv{[h֘A ======================================================
/**
 * Nbv{[hɕZbg
 * @param	string str 
 * @return	Ȃ
 */
void setClipboardData(string str) {
	char buff[str.size() + 1];
	char_traits<char>::copy(buff, str.c_str(), str.size() + 1);

	OpenClipboard(NULL);
	EmptyClipboard();

	HGLOBAL hText = GlobalAlloc(GHND | GMEM_SHARE, str.size() + 1);
	PTSTR pText = (PTSTR) GlobalLock(hText);
	lstrcpy(pText, buff);
	GlobalUnlock(hText);
	SetClipboardData(CF_TEXT, hText);
	CloseClipboard();
}

/**
 * Nbv{[h當擾
 * @param	Ȃ
 * @return	^NULL擾s
 */
char* getClipboardData(void) {
	static char buff[SIZE_BUFF + 1];

	OpenClipboard(NULL);
	HGLOBAL hText = GetClipboardData(CF_TEXT);

	if (hText == NULL) {
		return NULL;
	} else {
		PTSTR pText = (PTSTR) GlobalLock(hText);
		lstrcpy(buff, pText);
		GlobalUnlock(hText);
	}
	CloseClipboard();

	return buff;
}

#ifndef CMDAPP
// t@CǍ ========================================================
/**
 * eLXgt@Cǂݍ
 * @param	const char* fname  ǂݍރt@C
 * @return	wstring ǂݍ񂾃eLXg
*/
wstring __loadTXT(const char* fname) {
	ifstream ifs(fname);
	if (! ifs) {
		ErrorMessage = (string)fname + " ̓ǂݍ݂Ɏs܂";
	}
	string ss;
	wstring wstr = L"";
	while (getline(ifs, ss)) {
		wstr += _SW(ss) + L"\n";
	}

	return wstr;
}

/**
 * eLXgt@Cǂݍށi_CAOj
 * @param	Ȃ
 * @return	wstring ǂݍ񂾃eLXg
*/
wstring loadTXT(void) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, SAVEFILE);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("eLXgt@C(*.txt)\0*.txt\0ׂẴt@C(*.*)\0*.*\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("txt");
	// R_CAO̕\
	GetOpenFileName(&of);
	// t@Cۑ
	return __loadTXT(fname);
}

// t@Cۑ ========================================================
/**
 * ʂTXTt@Cɕۑ
 * @param	const char* fname  ۑt@C
 * @param	const wstring wstr ۑeLXg
 * @return	Ȃ
*/
void __saveTXT(const char* fname, const wstring wstr) {
	ofstream outputfile(fname);

	if (wstr != L"") {
		outputfile << _WS(wstr) << endl;
	}

	if (outputfile.bad()) {
		ErrorMessage = "eLXgt@C݃G[";
	}
	outputfile.close();
}

/**
 * ʂTXTt@Cɕۑi_CAOj
 * @param	const wstring wstr ۑeLXg
 * @return	Ȃ
*/
void saveTXT(const wstring wstr) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, SAVEFILE);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("eLXgt@C(*.txt)\0*.txt\0ׂẴt@C(*.*)\0*.*\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("txt");
	// R_CAO̕\
	GetSaveFileName(&of);
	// t@Cۑ
	__saveTXT(fname, wstr);
}

// GUI =================================================================
/**
 * eLXg{bNXɕ
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  string	s     ݒl
 * @return Ȃ
 */
void setStrEditBox(HWND hDlg, unsigned id, string s) {
	char buff[s.length() + 1];
	char_traits<char>::copy(buff, s.c_str(), s.size() + 1);
	SetDlgItemText(hDlg, id, buff);
}

/**
 * eLXg{bNX當擾
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @return string 擾
 */
string getStrEditBox(HWND hDlg, unsigned id) {
	char buff[SIZE_BUFF * 10 + 1];
	GetDlgItemText(hDlg, id, buff, SIZE_BUFF * 10);
	return (string) buff;
}

/**
 * _CAOeEBhE̒ɔzu
 * @param	HWND hDlg		̃nh
 * @global	HWND hParent	eEBhẼnh
 * @return	Ȃ
 */
void CenterWindow(HWND hDlg) {
	int x, y;
	RECT rc;

	GetWindowRect(hParent, &rc);
	x = rc.left + (rc.right - rc.left) / 2;
	y = rc.top + (rc.bottom - rc.top) / 2;

	SetWindowPos(hDlg, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}

// ϊIvV擾Eݒ ==================================================
/**
 * ϊIvVݒ肷
 * @param	HWND hDlg	EBhEEnh
 * @param	string opt	ϊIvV
 * @return	Ȃ
 */
void setOption(HWND hDlg, string opt) {
	for (int i = 0; i < (int)opt.length(); i++) {
		char* ch = (char*)opt.substr(i, 1).c_str();
		switch (*ch) {
		// ϊ
		case OPTION_MODE_AD:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_MODE_AD),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_MODE_ERA),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_MODE_ADERA),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_MODE_ERA:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_MODE_AD),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_MODE_ERA),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_MODE_ADERA),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_MODE_ADERA:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_MODE_AD),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_MODE_ERA),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_MODE_ADERA),
							BM_SETCHECK, BST_CHECKED,   0);
			break;
		// ϊ͈
		case OPTION_SCOPE_1:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SCOPE_1),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SCOPE_2),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SCOPE_0),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_SCOPE_2:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SCOPE_1),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SCOPE_2),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SCOPE_0),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_SCOPE_0:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SCOPE_1),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SCOPE_2),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_SCOPE_0),
							BM_SETCHECK, BST_CHECKED,   0);
			break;
		// ϊij
		case OPTION_AD_HAN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_HAN),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_KAN1),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_KAN2),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_AD_ZEN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_ZEN),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_KAN1),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_KAN2),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_AD_KAN1:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_KAN1),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_KAN2),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_AD_KAN2:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_KAN1),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_KAN2),
							BM_SETCHECK, BST_CHECKED,   0);
			break;
		// ϊiaj
		case OPTION_ERA_HAN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_HAN),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_KAN1),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_KAN2),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_ERA_ZEN:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_ZEN),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_KAN1),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_KAN2),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_ERA_KAN1:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_KAN1),
							BM_SETCHECK, BST_CHECKED,   0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_KAN2),
							BM_SETCHECK, BST_UNCHECKED, 0);
			break;
		case OPTION_ERA_KAN2:
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_HAN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_ZEN),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_KAN1),
							BM_SETCHECK, BST_UNCHECKED, 0);
			SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_KAN2),
							BM_SETCHECK, BST_CHECKED,   0);
			break;
		default:
			break;
		}
	}
}

/**
 * ϊIvV擾
 * @param	HWND hDlg	EBhEEnh
 * @return	string ϊIvV
 */
string getOption(HWND hDlg) {
	string opt = "";
	// ϊ
	if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_MODE_AD), BM_GETCHECK, 0, 0)) {
		opt += OPTION_MODE_AD;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_MODE_ERA), BM_GETCHECK, 0, 0)) {
		opt += OPTION_MODE_ERA;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_MODE_ADERA), BM_GETCHECK, 0, 0)) {
		opt += OPTION_MODE_ADERA;
	}
	// ϊ͈
	if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_SCOPE_1), BM_GETCHECK, 0, 0)) {
		opt += OPTION_SCOPE_1;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_SCOPE_2), BM_GETCHECK, 0, 0)) {
		opt += OPTION_SCOPE_2;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_SCOPE_0), BM_GETCHECK, 0, 0)) {
		opt += OPTION_SCOPE_0;
	}
	// ϊij
	if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_HAN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_AD_HAN;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_ZEN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_AD_ZEN;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_KAN1), BM_GETCHECK, 0, 0)) {
		opt += OPTION_AD_KAN1;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_AD_KAN2), BM_GETCHECK, 0, 0)) {
		opt += OPTION_AD_KAN2;
	}
	// ϊiaj
	if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_HAN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_ERA_HAN;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_ZEN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_ERA_ZEN;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_KAN1), BM_GETCHECK, 0, 0)) {
		opt += OPTION_ERA_KAN1;
	} else if (SendMessage(GetDlgItem(hDlg, IDC_RADIO_ERA_KAN2), BM_GETCHECK, 0, 0)) {
		opt += OPTION_ERA_KAN2;
	}

	return opt;
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg			EBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
 */
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg,
					WPARAM wParam, LPARAM lParam) {
	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
		setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
		break;

		// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// s
		case IDC_BUTTON_OK:
			EndDialog(hDlg, 0);
			break;
		default:
			return 1;
		}
		break;
		// vOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
	return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
 */
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC) handler);
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
 */
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	HICON hIcon;
	static wstring wsour, wdest;

	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		hParent = hDlg;
		hIcon = (HICON) LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON,
				16, 16, 0);
		SendMessage(hParent, WM_SETICON, ICON_SMALL, (LPARAM) hIcon);
		ErrorMessage = "";
		// p[^ǂݍ
		loadParameter();
		setStrEditBox(hDlg, IDC_EDIT_SOUR, DEF_SOUR);
		// AvP[VEEBhEړ
		SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));
		hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
		SendMessage(hParent, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
		setOption(hDlg, Option);
		// ̌ϊ\ǂݍ
		pNT->readTableEra(TABLEERA_FNAME);
		break;

	// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// ϊ
		case IDC_BUTTON_EXEC:
		case IDM_EXEC:
			// ϊIvV擾
			Option = getOption(hDlg);
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			// Ks
			wsour = _SW(getStrEditBox(hDlg, IDC_EDIT_SOUR));
			wdest = pNT->convNengo(wsour, Option.c_str());
			setStrEditBox(hDlg, IDC_EDIT_DEST, _WS(wdest));
			break;
		// J
		case IDM_OPEN:
			wsour = loadTXT();
			setStrEditBox(hDlg, IDC_EDIT_SOUR, _WS(wsour));
			break;
		// Zbg
		case IDC_BUTTON_RESET:
		case IDM_RESET:
			setStrEditBox(hDlg, IDC_EDIT_SOUR, "");
			break;
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			saveTXT(wdest);
			break;
		// ݒNA{AvI
		case IDM_CLEAR_PARAMETER:
			delParameter();
			EndDialog(hParent, 0);
			return 0;
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hParent, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hParent, processHelp);
			break;
		// TCg
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// Rs[
		case IDM_COPY:
		case IDC_BUTTON_COPY:
			setClipboardData(getStrEditBox(hDlg, IDC_EDIT_DEST));
			break;
		// ؂
		case IDM_DELETE:
			setStrEditBox(hParent, IDC_EDIT_SOUR, "");
			setStrEditBox(hParent, IDC_EDIT_DEST, "");
			break;
		// vOI
		case IDM_QUIT:
			// p[^ۑ
			saveParameter();
			EndDialog(hParent, 0);
			return 0;
		default:
			return 0;
		}
		break;

	// vOI
	case WM_CLOSE:
		// p[^ۑ
		saveParameter();
		EndDialog(hParent, 0);
		return 0;
	}
	return 0;
}

// GUICvO ======================================================
/**
 * GUIpCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
 */
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");
	hInst = hInstance;

	// pahooNormalizeTextIuWFNg
	pNT = new pahooNormalizeText();

	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);

	// IuWFNg
	delete pNT;

	return 0;
}

// CUICEvO ====================================================
#else
/**
 * CUIpCvO
 * @param	int argc
 * @paramm	char* argv[]
 * @return	int ^[R[h
 */
int main(int argc, char* argv[]) {
	// p[^ǂݍ
	loadParameter();
	string sour = "";

	// pahooNormalizeTextIuWFNg
	pNT = new pahooNormalizeText();
	// ̌ϊ\ǂݍ
	pNT->readTableEra(TABLEERA_FNAME);

	// R}hCEIvV̒`
	options_description options("R}hCEIvV");
	options.add_options()
		("option,o", value<std::string>()->default_value(Option), "ϊIvV")
		("sour,s", value<std::string>(), "̓eLXg")
		("clip,c", "Nbv{[h")
		("dest,d", value<std::string>(), "o̓eLXg")
		("paste,p", "Nbv{[h֏o")
		("help,h", "wv")
		("version,v", "o[W")
		;
	// R}hCEIvV̎擾
	variables_map vm;
	try {
		store(parse_command_line(argc, argv, options), vm);
	} catch(const boost::program_options::error_with_option_name& e) {
		ErrorMessage =  e.what();
		cerr << ErrorMessage << endl;
		return 1;
	}
	notify(vm);

	// ϊIvV
	auto opt = vm["option"].as<string>();

	wstring wdest = L"";
	// wv
	if (vm.count("help")) {
		wdest = _SW(Help);
	// o[W
	} else if (vm.count("version")) {
		wdest = _SW(Version);

	// ϊs
	} else {
		// ̓t@C
		wstring wsour = _SW(DEF_SOUR);
		if (vm.count("sour")) {
			auto infile = vm["sour"].as<string>();
			ifstream ifs(infile.c_str());
			if (ifs.fail()) {
				ErrorMessage = infile + " ܂";
				cerr << ErrorMessage << endl;
				return 1;
			}
			string sour = "";
			string ss;
			while (getline(ifs, ss)) {
				sour += ss + "\r";
			}
			wsour = _SW(sour);
		// Nbv{[h
		} else if (vm.count("clip")) {
			char *ss = getClipboardData();
			sour = ss;
			wsour = _SW(sour);
		// W͂
		} else {
			string sour;
			cin >> sour;
			if (sour.length() > 0) {
				wsour = _SW(sour);
			}
		}
		wdest = pNT->convNengo(wsour, opt.c_str());
	}

	// o̓t@C
	if (vm.count("dest")) {
		// sR[hu
		wregex re(_SW("\r"));
		wdest = regex_replace(wdest, re, _SW("\n"));
		auto outfile = vm["dest"].as<string>();
		ofstream ofs(outfile.c_str());
		ofs << _WS(wdest);
		if (ofs.bad()) {
			ErrorMessage = outfile + " ւ݂̏Ɏs܂";
			cerr << ErrorMessage << endl;
			return 1;
		}
		ofs.close();
	// Nbv{[h
	} else if (vm.count("paste")) {
		// sR[hu
		wregex re(_SW("\r"));
		wdest = regex_replace(wdest, re, _SW("\n"));
		setClipboardData(_WS(wdest));
	// Wo͂
	} else {
		// sR[hu
		wregex re(_SW("\r"));
		wdest = regex_replace(wdest, re, _SW("\n"));
		cout << _WS(wdest);
	}

	// IuWFNg
	delete pNT;

	// p[^ۑ
	Option = opt;
	saveParameter();

	return 0;
}

#endif

/*
 ** o[WAbv =====================================================
 *
 * @version 1.2.9  2025/11/23 gpCuXV
 * @version 1.2.8  2025/08/02 gpCuXV
 * @version 1.2.7  2025/03/29 gpCuXV
 * @version 1.2.5  2024/08/31 gpCuXV
 * @version 1.2.4  2024/04/20 gpCuXV
 * @version 1.2.3  2023/12/17 gpCuXV
 * @version 1.2.2  2023/07/23 gpCuXV
 * @version 1.2.1  2023/04/08 gpCuXV
 * @version 1.2.0  2022/10/15 EBhEʒuۑCݒNA@\ǉ
 * @version 1.1.0  2022/10/12 CUIł --clip, --paste IvVǉ
 * @version 1.0    2020/11/14 
*/
