/** pahooNormalizeText.hpp
 * eLXgKNXFC++wb_
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + Boost C++ Libraries + MeCab
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01-18-01.shtm
 * @⑫
 *	1) MeCabgpɂ MECAB `
 */
#ifndef PAHOONORMALIZETEXT_HPP
#define PAHOONORMALIZETEXT_HPP

#include <stdlib.h>
#include <vector>

// R[hϊ
std::wstring __sjis_wstring(std::string src);
#define _SW(s)	__sjis_wstring(s)
std::string __wstring_sjis(std::wstring src);
#define _WS(s)	__wstring_sjis(s)
std::wstring __utf8_wstring(std::string src);
#define _UW(s)	__utf8_wstring(s)
std::string __wstring_utf8(std::wstring src);
#define _WU(s)	__wstring_utf8(s)
std::string sjis_utf8(std::string src);
#define _SU(s)	sjis_utf8(s)
std::string utf8_sjis(std::string src);
#define _US(s)	utf8_sjis(s)
std::wstring wconvString(std::wstring wsour, DWORD method);

// KIvV
#define OPTION_SPC_TRIM1	't'		// sEs̋󔒕
#define OPTION_SPC_TRIM2	'T'		// SpƗׂ荇󔒕
#define OPTION_NUM_HAN		'n'		// 𔼊pɓ
#define OPTION_NUM_ZEN		'N'		// Spɓ
#define OPTION_NUM_KAN		'K'		// ɓ
#define OPTION_NUM_KAN2		'k'		// (P)ɓ
#define OPTION_ALP_HAN		'a'		// p𔼊pɓ
#define OPTION_ALP_ZEN		'A'		// pSpɓ
#define OPTION_YAK_HAN		'y'		// L𔼊pɓ
#define OPTION_YAK_ZEN		'Y'		// LSpɓ
#define OPTION_KANA_HAN		'h'		// J^Ji𔼊pɓ
#define OPTION_KANA_ZEN		'H'		// J^JiSpɓ
#define OPTION_SPEC_HAN		's'		// ꕶ𔼊pɓ
#define OPTION_SPEC_ZEN		'S'		// ꕶSpɓ
#define OPTION_NUM_SCALE	'F'		// ʎL@ɂ
#define OPTION_NUM_NOSCALE 	'f'		// ʎL@ɂȂ
#define OPTION_CONTROL_DEL 	'c'		// 䕶폜
#define OPTION_DBL_QUOTE 	'D'		// dp̊Ju
#define OPTION_VARIABLE		'V'		// \L𓝈ꂷ

// KIvV̏l
#define OPTION_INIT			"anYSHF"

// aENϊIvV
#define OPTION_MODE_AD		'A'		// ɓ
#define OPTION_MODE_ERA		'W'		// aɓ
#define OPTION_MODE_ADERA  	'C'		// (a)
#define OPTION_SCOPE_1		'1'		// ޗǎȍ~
#define OPTION_SCOPE_2		'2'		// ȍ~
#define OPTION_SCOPE_0		'0'		// ϊȂ
#define OPTION_AD_HAN		'h'		// ϊ()Fp
#define OPTION_AD_ZEN		'z'		//@@@@@FSp
#define OPTION_AD_KAN1		'k'		//@@@@@F(P)
#define OPTION_AD_KAN2  	'l'		//@@@@@F
#define OPTION_ERA_HAN		'H'		// ϊ(a)Fp
#define OPTION_ERA_ZEN		'Z'		//@@@@@FSp
#define OPTION_ERA_KAN1		'K'		//@@@@@F(P)
#define OPTION_ERA_KAN2		'L'		//@@@@@F

// u`t@C
#define FRONT_REPLACE_CSV	".\\etc\\frontrep.csv"

// \Lꓝꎫt@C
#define VARIABILITY_REPLACE_CSV	".\\etc\\vardic.csv"

// NϊIvV̏l
#define CONVOPT_INIT		"C1hH"

// NX`
class pahooNormalizeText {
public:
// RXgN^
pahooNormalizeText();
~pahooNormalizeText();

std::wstring errmsg = L"";		// G[bZ[W

bool isError(void);
std::wstring getError(void);
void resetError(void);
void setError(std::wstring msg);

std::wstring frontend_replace(std::wstring sour);
std::wstring num2kanji(std::wstring instr);
std::wstring num2scale(std::wstring instr);
std::wstring num2kan(std::wstring wsour);
std::wstring num2kanSimple(std::wstring wsour);
std::wstring bignum2scale(std::wstring wsour);
std::wstring kan2num(std::wstring kanji, int mode);
std::wstring convString(std::wstring wsour, DWORD flags);
std::wstring toHankaku(std::wstring wsour, bool trim, bool variable);
std::wstring normalizeText(std::wstring wsour, const char* option, bool trim);

// \Lꓝꎫ
std::vector<std::pair<std::wstring, std::wstring>> VariableDict;

std::vector<std::pair<std::wstring, std::wstring>> loadVariableDictionary(const std::string& filename);
std::wstring variable2standard(std::wstring word);

// ̌ϊe[u
struct _tableEra {
	long start;				// JnN
	std::wstring era;		// 
};
std::vector<_tableEra> TableEra;

// ̌ϊ͈
long convStart = 11110101;			// JnNij
long convEnd   = 99999999;			// INij
#define START_SCOPE1	06450717	// 剻N
#define START_SCOPE2	18730101	// 6N11
#define END_SCOPE		99999999
#define ESCYEAR			L"^\\\\"	// GXP[vǐ̔N͕ϊȂj

void readTableEra(const char* fname);
void setScope(long start, long end);
bool isConvEra(long yyyymmdd);
bool isEra(std::wstring wstr);
std::wstring convNengo(std::wstring wsour, const char* option);

private:
#ifdef MECAB
MeCab::Tagger *tagger = MeCab::createTagger("--dicdir=etc --userdic=etc/user_wiki.dic --node-format=%M\\t%f[0],%f[1],%f[2],%f[3],%f[4],%f[5],%f[6],%f[7],%f[8]\\n --unk-format=%M\\t%f[0],%f[1],%f[2],%f[3],%f[4],%f[5]\\n");
#endif
std::wstring kanword2num(std::wstring kanji);
std::wstring hanfloat(std::wstring wsour);
std::wstring han2zen(std::wstring wsour, bool (*func)(wchar_t wch));

std::wstring ad2era(std::wstring prefix, int year, int month, int day, const char* option);
std::wstring era2ad(std::wstring prefix, int year, int month, int day, const char* option);
std::wstring seireki2wareki(std::wsmatch mt, const char* option);
std::wstring wareki2seireki(std::wsmatch mt, const char* option);
std::wstring seireki2mix(std::wsmatch mt, const char* option);
std::wstring wareki(std::wstring wsour, const char* option, bool flag);
std::wstring seireki(std::wstring wsour, const char* option, bool flag);
std::wstring mixture(std::wstring wsour, const char* option, bool flag);
std::wstring monthday(std::wstring wsour, const char* option);

};

#endif
