const sharp = require('sharp');
const fs = require('fs');

async function test() {
    console.log('Creating dark test image...');
    // Create a dark image (RGB 50,50,50)
    await sharp({
        create: {
            width: 100,
            height: 100,
            channels: 3,
            background: { r: 50, g: 50, b: 50 }
        }
    })
        .toFile('test_dark.png');

    console.log('Processing image...');

    // Simulate Logic from main.js
    let pipeline = sharp('test_dark.png');
    const stats = await pipeline.stats();
    const meanLuminance = (0.2126 * stats.channels[0].mean + 0.7152 * stats.channels[1].mean + 0.0722 * stats.channels[2].mean);

    console.log(`Original Luminance: ${meanLuminance}`);

    const targetLuminance = 135;
    if (meanLuminance < targetLuminance) {
        const boost = Math.min(2.5, targetLuminance / Math.max(10, meanLuminance));
        console.log(`Boosting brightness by x${boost}`);
        pipeline = pipeline.modulate({ brightness: boost });
    }

    await pipeline.toFile('test_fixed.png');

    // Verify result
    const newStats = await sharp('test_fixed.png').stats();
    const newMean = (0.2126 * newStats.channels[0].mean + 0.7152 * newStats.channels[1].mean + 0.0722 * newStats.channels[2].mean);
    console.log(`New Luminance: ${newMean}`);

    if (newMean > meanLuminance) {
        console.log('PASS: Image was brightened.');
    } else {
        console.error('FAIL: Image was not brightened.');
        process.exit(1);
    }
}

test().catch(err => {
    console.error(err);
    process.exit(1);
});
