//------------------------------
// ln10
//------------------------------
//static BCD_REG ln10;
static char* ln10_txt = "2."
"3025850929940456840 17991454684364207601 10148862877297603332 79009675726096773524 80235997205089598298 34196778404228624863 34095254650828067566 66287369098781689482 90720832555468084379 98948262331985283935"  //200
#if nBCD_DSIZE > 100
"05308965377732628846 16336622228769821988 67465436674744042432 74365155048934314939 39147961940440022210 51017141748003688084 01264708068556774321 62283552201148046637 15659121373450747856 94768346361679210180"  //400
#endif
#if nBCD_DSIZE > 300
"64450706480002775026 84916746550586856935 67342067058113642922 45544057589257242082 41314695689016758940 25677631135691929203 33765871416602301057 03089634572075440370 84746994016826928280 84811842893148485249"  //600
"48644871927809676271 27577539702766860595 24967166741834857044 22507197965004714951 05049221477656763693 86629769795221107182 64549734772662425709 42932258279850258550 97852653832076067263 17164309505995087807"  //800
"52371033310119785754 73315414218084275438 63591778117054309827 48238504564801909561 02992918243182375253 57709750539565187697 51037497088869218020 51893395072385392051 44634197265287286965 11086257149219884997"  //1000
"87488737713456862091 67058498078280597511 93854445009978131146 91593466624107184669 23101075984383191912 92230792503747298650 92900988039194170265 44168163357275557031 51596113564846546190 89704281976336583698"  //1200
#endif
#if nBCD_DSIZE > 1000
"37163289821744073660 09162177850541779276 36773114504178213766 01110107310423978325 21894898817597921798 66639431952393685591 64471182467532456309 12528778330963604262 98215304087456092776 07266413547875766162"  //1400
"62926568298704957954 91395491804920906943 85807900327630179415 03117866862092408537 94986126493347935487 17374516758095370882 81067452440105892444 97647968607512027572 41818749893959716431 05518848195288330746"  //1600
"69931781463493000032 12003277656541304726 21883970596794457943 46834321839530441484 48037013057536742621 53675579814770458031 41363779323629156012 81853364984669422614 65206459942072917119 37060244492935803700"  //1800
"77189810973625332245 48366988505528285966 19280509844717519850 36666808749704969822 73220244823343097169 11113681358841869654 93237149969419796878 03008850408979618598 75657989483644521204 36982164152929878117"  //2000
"42973332588607915912 51096718751092924847 50239305726654462762 00923068791518135803 47770129559364629841 23664970233551745861 95564772461857717369 36840467657704787431 97805738532718109338 83496338813069945569"  //2200
"39934610109074561603 33122479493604553618 49123333063704751724 87127637914092439833 18101647378233796922 65637682071706935846 39453161694941170184 19381194054164494661 11274712819705817783 29384174223140993002"  //2400
"29115023621921867233 37268385688273533371 92510341293070563254 44266114297653883018 22384091026198582888 43358745596045300454 83707890525784731662 83701953392231047527 56499811922874278971 37157132283196410034"  //2600
"22124210082180679525 27668985818095611920 83917607210809199234 61516952599099473782 78064812805879273199 38934534153201859697 11021407542282796298 23706894176474064222 57572124553925261793 73652434440560595336"  //2800
"59153916031252448014 93132345724538795243 89036839236450507881 73135971123814532370 15084134911223243909 27681724749607955799 15136398288105828574 05380006533716555530 14196332241918087621 01820491949265148389"  //3000
"26922937078986352706 38502702269755124994 30043818278847319921 96581431219760711108 76341224466407377945 55885839194408093110 24283085084746319069 32198146864308355534 76511146507690973333 95832575068277582831"  //3200
#endif
#if nBCD_DSIZE > 3000
"05180329948130848399 68172113667988019203 77706868547950620358 41721998437439410636 23432314811745524756 40089192165491269082 78150604817119907018 86292098228627167304 77199015770285357910 50628467337223240001"  //3400
"87956150228908439674 14685656483176881389 20684095796918033543 39136467865745905494 88029854381988073595 54270415408734014531 73925453673281939976 45602559843243305615 87350029328025723064 53270348118108472311"  //3600
"64468047519194264144 37554865769392929683 42866758510673192419 18228522689913893119 21694424230385170652 93370451214983835979 40218271629133640253 15495969131171466353 44222645685446832262 89253198527399466669"  //3800
"57186015792983850440 15374615282751288575 45617541969976789089 21172490237634787894 24021833767813973546 58345556295079309046 68051597640950524818 94758730994766129863 20677356531111786061 53748101081586427721"  //4000
"11135001766610911496 96494183076946301388 41602650317848119297 23802068086896236543 96591512067607905008 31952302434781788303 87784710282630559124 30624394315691194617 23321513047832089425 85130526425182114798"  //4200
"48258424730967079501 64439552006313711424 85002497652901513103 80216416843468036623 96504005785203172746 46341488894127703883 18760666904172965971 35990817736900634789 45952889762219978807 98271398331815395541"  //4400
"57297894701672875025 32359082781316357066 63489567636634400113 00980093878359213002 62953071236743022323 99707337986684151718 24688814565764772117 51163677973275051830 74902665362406067789 61293130685497587433"  //4600
"05485369376656303167 11117871564571156402 49978305349228978026 84646081921328403148 04827498936970373280 93314540101927648340 60593715141857989335 64159483238353253287 52010085555501592808 91833268089936832751"  //4800
"61374389819736125706 67962716178982016808 57611037066082157532 70001344145799883900 77090577909476933387 18593055745163721639 22302788546884992191 74775362013574000738 08029003464801289505 06385687149679702782"  //5000
"42133986903666476924 21387221047479329426 74694063112638491014 36180728776608041051 25122038577942906377 30069124170742882066 97986107777430245043 07895780078739402732 57119728212361207957 71418186747839517573"  //5200
"80445978887663092635 35332561183535891639 65030383340477719373 34420956690205359846 63348283042430767205 76588502226370439924 58137869126129100508 62966339808643426856 70653861399614353931 35314836142479346861"  //5400
"21473700807141967542 13323059139854224273 62960268352527074543 30860376309325759906 52793185369595215291 57904052693858492440 62500718796054882446 35856835841371473358 07077567299853264277 35317760670765957691"  //5600
"01489925506561596572 42843087609627514754 01096713288805825291 00941413237062430201 08989379485419014287 16311211438780592832 74773639422153542558 11251641646176650616 33826060708786432495 93445108874230105969"  //5800
"11622338648581093139 25605573164788595221 77741562011464894467 23915722478824329448 46662113928463874193 71535080451021101817 00409986759395896327 61524137751011977989 52283073314745871908 41251491288453203292"  //6000
"92331889907799972401 72419836349540307148 74924560790239878370 44095908189182931318 93226710177961588364 60660160983103380614 18288332139895255915 13924232242952561091 89125514743525452675 36813785157099205423"  //6200
"65566862511988946909 78912714378398839944 04234836623253992113 69323739338408735725 64221022276740723601 94115308610349855598 00843143629810795520 31286315326602072719 75693753721028575367 35310421655645802569"  //6400
"46039604043130694270 14164857524792785136 18420545316386728163 17593784244177173886 98381203126982893906 23502999504655557480 21266049908868952083 54986807114405225574 59701884599998745124 49746656973212289169"  //6600
"79294225917554074302 51842250695731372772 46627141256081141015 54710203063484420740 11859509077785692063 18487169837187426670 40069571921733340732 61395165667232648032 93030224211880671851 19138574488850452631"  //6800
"80142687370186817482 32020111635350318502 08975299309933054826 17038295285538628175 56329686632900112107 79886921289244661329 29541744813316322446 24932244078265721868 88602202803446835097 47149994659019730572"  //7000
"79831876298731556117 44885012602366975787 15078787081014024232 60573829982711679577 75940139250524607966 63325525104577423100 83418369042134346701 50373525245838356143 37169267218349538828 92183597514996887113"  //7200
"43808120074364193799 93964671098625939931 91481956514925609806 37030630448483156653 62292676744705425215 88524364253313344941 11751193450823720142 01936855182607165747 99956042242203738639 48942382566342712928"  //7400
"72822932137193365805 01931032882798790979 22251654544086990681 20207260764586272802 66435191085336917693 69353560212633772746 05121808158172930054 55050338987131858422 57727243084979762893 02941282700891592011"  //7600
"33151716977141037003 06103623971794621822 99994937672809514441 79515953802443130460 20561305623405774440 80943554356253961025 18065579169379128797 89632022348607588753 29359285385260541841 91304151822796368670"  //7800
"54943203269837819503 26775153462564463751 02261459938428710416 51001086982320890071 14703515879405126129 59502864474994464326 02757180053078402418 24000548994937070953 94788567741704836930 24988900857190446195"  //8000
"55186412130128331142 01692643683047702059 43951221471895975165 45168555419484830314 34085109327777863715 07942785778250390193 74184436520306088767 05981835988208529352 92812133308207381640 36733068455193263394"  //8200
"14694319813172411319 60875461690877511182 81752209418399539272 12394364366177202788 77457153731271938984 86345990279634393401 22277049352074931943 41126536676243200568 56114699723520702103 44660576530569058689"  //8400
"26923324775179079597 73340413117818567019 39965655457177547593 28189684629785362524 29563312968610830760 31551333325641275708 34713871459980652297 49446086926994646460 96141849969789203979 87382885032071731979"  //8600
"26472752309833709667 12808190012077669357 05882861817815812551 67349138590563695004 16310399572692334345 54007420775114289094 96370725267627513433 14407995396626463859 53338158417387721448 10361999729003686000"  //8800
"61895892271510808778 87680109653132728970 38365116476361624533 74187135234085117040 67426091506202162207 36286824463555670495 28849819333913009956 38482463358675941130 71245255855688656980 83365920906879453147"  //9000
"87836754320194593272 60779320485364163673 34444251145180770598 80807989070279740212 26626797842637863765 22976800906915561019 48016024914255091395 88642320521008279775 18014498254161637789 41552444904378354179"  //9200
"07465913586062794799 08945819916357522826 89806096152994281469 56604275658126542194 95177965849724632706 02702975982699071046 16875128933520093150 02763060118213773538 50649498537050528236 55166266724075041648"  //9400
"42675247033103125401 53499715634682432552 66580543454057045637 53059986619384290701 33467937570418997892 43295402996256017838 57709197350259335987 94923197452860625376 66331411969382128951 37364385823623738836"  //9600
"61925958390943833902 83131409670269821532 99200106711446228452 26894328758962744557 47255003644536973276 86214199589912359720 13417747312058321980 92358509217033449046 50822177976636794312 04834061116285659611"  //9800
"02793963524649251888 93712638399014172519 62409864260561053450 47204020153371961696 49522830408146949921 85855352288301226079 72516882582180889408 29057902834761964296 35491705854527783750 79041139063718148833"  //10000
"93240830608011513745 61845705167563001798 75756122825840822238 45446317203277805490 38605149612591770322 49954587395991361192 12233450865349015879 95548677006724492683 02273904555705480837 93007245967042835042"  //10200
#endif
#if nBCD_DSIZE > 10000
"67254074866282693281 14470562787563760391 07400014555869829550 30165809354838259223 01680053777007889985 77702171500649220814 76551798207285680798 69565447690513130397 90189121730526057476 23638027783554565891"  //10400
"81908966098543260225 05481069500429725986 69827000620813112784 82953903318475431016 14961632448650801749 92984236042416112083 28517732360079852179 43313195818114564168 84731505855415572147 95204077426038956031"  //10600
"21621977825122429482 99043090705235808914 46525020483107398162 25654345312425706078 37942057234197554585 91160372889797288475 34237948663635365770 71342872349714869596 27839619338034122085 30338012936099773475"  //10800
"09509226872800548940 26120651693910811673 11009867988039224104 69263464821877356288 11293507283807485403 15682296011712547759 55965371654656479801 89970164451083395333 52676806724189942044 88045803865148408007"  //11000
"57330797686753051854 75241105072308700912 11415199695602952048 50455156096880113525 89210227244521002257 24984272187717647528 05124926095909695717 24912299062982120578 91792213889212761327 85209885340872629794"  //11200
"17719098307239692508 31414869790107036131 61284421157378500442 23855140524771216882 90872720728503964827 23935497087923717945 32125280712728619057 00834114030914824343 63608456020526336705 25563362446865052475"  //11400
"60929150459654347787 90779087576754734427 57269592494432141836 82563133135267937621 40131394755885763023 66269029844480250155 62395578314037580830 20222135662160011645 32434978663395116706 14724853598528842360"  //11600
"13280756480205168600 70146925736971785127 82081057672187313281 00328310721822339932 75470010130076665928 99591248592311575942 56724308440740318168 08918515197663208513 00430161771878874633 61023909198388997082"  //11800
"74037100310057996013 05322082607180025256 11182832843078726708 35663156142650409523 57741793440327114840 63670101366882566772 14116686268678490826 59032171906822397810 37089368313328117225 05224206098905505696"  //12000
"27228743486737486428 82544953924060374282 76736897507459179100 03290333023269594759 33036028518354163191 27070484555660055612 68890051592114971511 29413205144980312874 55813323955042620448 73973617767973608071"  //12200
"08541884029963275853 85652559490995189756 54516685053499507265 06337530724960394596 13473183000996117554 23569041902870163923 54408909253204115546 93252759760528811219 84210082220644531958 10685932866927088546"  //12400
"34943189643849150796 13343641978084553924 91819923630712489186 24339538182509404767 90517513326617901033 29159396127088723440 70016447853238180425 58877159560788427425 97476511816473562645 88478489799591990407"  //12600
"37622699589245749717 39885287813466385663 09959163762826467575 29075926932481790557 37004055280167037917 31825712135104949285 74198269630164535690 28618355954390232088 30638417553687129759 10850478800401053084"  //12800
"48962250856828663212 21605535220104868681 30408237095682101959 76523279347029873281 45345950922165090860 62914215491003047919 10077238825867627047 78309001628699186754 92633383287137809319 91538648138058746683"  //13000
"16956438272982190652 96697678103665786962 07485982528209027423 69938024287388168163 51082393360605931550 91171067346107080460 31828927544540570043 49268761977647765880 37841613413161345692 34139150014283297410"  //13200
"51306844221277715184 22853521149527939593 81216760333540621549 87558328899745258030 67278581267922375392 91785637174755887203 28402683311200957981 00924893153554340032 63174743499153674765 91685975866326683842"  //13400
"22543810763372760518 56607148117745665499 86491383056401754288 74991594312435496768 77244747207858931991 50346327173335334677 87832931879525238093 29120513434282965499 04992203315010356807 40230886894646552748"  //13600
"52927973751531038994 86371773696156500986 11831365579301736798 21211828434204253845 42421903800313790348 74627167339047527833 98118728672173688445 39652774626786613591 72283703386704886090 41991597084504853934"  //13800
"91790162094846829927 99184405798178716150 59638539361858106497 11043776533327968500 26078113790752630224 43077393890020091607 08112280630705969602 00854384145895255342 68981543929976389148 77039580518297890569"  //14000
"63474705878743728836 49027631548626048014 97444998926662471266 67364904878076528148 82693545353114444256 71338545254521170291 24353853233743193425 13856324130312392011 00336908343404209547 38126863468540181030"  //14200
"18787227783985216002 10284886733121167573 99630916639461942200 42987169928972468529 82949650236820649897 24415661310441284371 53656967674687342819 20715398881946931988 77785245072301470114 03678929492082328313"  //14400
"76534890917828160845 91447616645492066619 91337840077917480658 51366649386401971775 07432732456492781333 52382575247384369113 52662800219940487883 40509325402831438962 05155782976359169551 67082760032902182533"  //14600
"78028211510877647736 26575108317854058996 78699837533828400748 75245704620390040180 56154078696972066565 98115737077069685249 98844388439100831144 39592328392200182134 26083755921955627721 31201498999791400615"  //14800
"04411635059492134142 07273196867035499811 40263112034589797612 05519891962492714471 07171174125796401950 87837908576165081167 91079762517061657753 13136833571465216572 76207353042823285783 40734266199817002450"  //15000
"12424485545652299392 06224813751221070210 25809934773813566489 51365989428908435982 72384171906852553880 76047537734256798776 99626869618226395351 04147580472796871821 93273962679474976354 54093985625870015022"  //15200
"70920116932121667763 05766626262408537136 01985761527911830955 23212280016101478712 58635731553718812080 06299384716484226983 45886410052182523793 92071622352726794287 73931026479215241284 75747767686203378356"  //15400
"91869006555320132858 36843242595179570742 82567216137771269792 99875290619148946049 29002828249662428250 72359971962800183664 41467244558220865829 43171980583687956183 67748753567341791043 08471361063697111106"  //15600
"43236893816963543420 46710983592076736925 17010692943015862416 93358421858334709074 87780670775275802134 64092795072337510539 40988972453692663249 39429584227680047800 55841973560559003973 13374923549119801360"  //15800
"83450465150422392959 76427004412221357408 12971293716911657560 96011811341840941321 94231898389995736420 11624362198895590147 56528784418257394514 55877149619969234420 39288833593294714050 26086389096948131051"  //16000
"29546401064244993290 69828488830067966366 66892453891528255639 59359925632807706325 21612066879264423374 57254030621889315915 47081430411744815569 49361933345274276278 50338858569660694631 31851353875696860364"  //16200
"72971483165785623774 60572645949715519568 14374509195831193818 50716070352013788150 81717586718342049469 49076141835846837790 06172844925167410764 34295637141206898986 46692122835320338956 81202785700598279592"  //16400
"70177389383494525816 86888845636266633699 02219259896509956839 10178393785271359448 84433377054489847244 42463287616494581691 09495500951046451404 49116375240969621413 63995153961522774517 81861183418090143815"  //16600
"31001162114144489179 19221521172024800919 65415261727259249224 90141048882648826880 34382414934193711400 60380831282256859673 41723886516075277476 24410509030885115437 78093387196117496769 30131716809906576188"  //16800
"08796184483509593642 39726577186379620533 25281501136042559152 93996958376187252862 69942820331456115498 64052078883022661145 40877598709249017961 39754969576254482395 48011207885028931217 33291359669835699081"  //17000
"17025984434741140815 78670631037681883683 40713236512920689388 07871487912180780966 42589408533871117564 59699521175295617258 22864859667272489928 75155393383166421604 88009291881186636222 65681958321052036383"  //17200
"19544384483957636010 27512289363081089201 38132338064190563495 86392461565444020714 25118133838306044271 25925176045791987018 36012636850255336940 01837089243640877080 06721039416879708534 96007276295298166310"  //17400
"82808808367210199959 81286085082176101409 92562322409249799080 12580287456889550370 70725479449580272394 23746719891051061891 88602366651641121917 15923470846464629765 83249390492956015277 98043326493162979117"  //17600
"38378914006774155550 76834833756332148131 34281299699723607482 95595762173506464136 46269218495404309939 23151129316636732076 49299114085863699619 84805374141779002060 19644130729584034704 79202990703122421262"  //17800
"48199278896690218262 69225083428663312568 90919913576921659010 84326927216632618886 56139759087072029637 38975896943090213825 96811309653863450159 16876619101561020886 81034153269257650670 88208109832504552645"  //18000
"69306304319921089528 03766863547587829555 99927492567655199166 60759078059789332021 56327376413211387071 76102510325613939735 99628979609746369534 42742013262336874100 95148161238448105766 62197070335506876507"  //18200
"62525321625033215780 23403252873921844917 24154875497498490554 51884063165843479357 55233602476072426712 92522542955113511481 31110853616438423227 70470426155391724290 67778918489864449893 45982274298149818377"  //18400
"55843950110968798528 05466237491291222840 92621793712372387283 15549615364028130480 23460200295676551803 13821670463109879891 60660849548286911395 23938156289460202311 14889307013440329988 08158306177470561376"  //18600
"78265270317931890815 51658814317780218522 55447336204657219986 93184258271516431154 38527608752474701477 79149816801130998051 82021079485827483189 41176362050245741961 23421283297682793752 66936113971070833147"  //18800
"01684371798022223630 34952231932415844964 18563757785991255904 38305735947938970058 59966196938841948312 09921646568193711990 49854857548289032533 78600962330599932648 08992706828556818320 85563100546447725767"  //19000
"95803695055759490542 59909020980961964203 13768908707447892066 66956241795533051464 63887931915712019367 80809360524173737320 91361293576484273808 76017144394078680825 74459839313267275641 51841464731735620211"  //19200
"71236413355148797111 73013337481272152444 89952284856040750343 12932686875315585988 03939150044430642229 82746214232964345390 75463821085887005303 03219638709213058519 93612045631754451604 94007842461275493005"  //19400
"73272900976113361736 00314156498078901157 16382799003963864830 05661237821144435940 10579348799681403001 81922461128885624612 67489771176548259489 64320315728077074549 66169915230973719788 48882793654447938556"  //19600
"28708200649267402520 39932553868859977417 12079106797783206480 97759358717645804833 48028076840769344098 96100834807983095381 76583639786348520590 93705236021087436183 12998323897593487294 25415958931281468768"  //19800
"85222119202498556682 14181946248394782140 72989935342655870830 79987214156387385481 28811650240066996476 91877002502365325305 78375001241535411192 81740706278257288882 42540859676892796009 46083626388098833002"  //20000
"66585302781835135883 31431462902575157790 48073260469085665065 14905137455134391085 60677180572391003912 20805416192873938993 75447480996789475181 54655149805473696871 43271152938679687383 69937713323158825700"  //20200
"25233344725942735212 68417651004930670394 85598949017571630529 91728702502090193639 87381034343043463989 73625699980085009351 20678751320842998500 32696459166364122422 91420254968983271946 88645153905516306795"  //20400
"73820298453042382463 08216349488537231826 26135898246597668413 97965176909220438388 44371136924068706986 39428651154794181280 12611668808798898521 29001951780030623777 04340167521547818223 43567270804749307978"  //20600
"86703375733622118447 94792044328421413964 47616220541343489216 85793102876852270966 84344459783331783728 21619758629133514784 58363534576916941967 30633289548016670139 87255271126980163879 62820024753266556197"  //20800
"57981559036302648376 11843287169826663151 27520209365393218128 03820305131821127460 23338924016142978545 56378125953000339580 69679879218093582305 30234695533037331545 25421142053700405418 83282436663668234916"  //21000
"65220146111076470314 41514364610329919130 73782494359457805473 58332300222618150280 59312838445957941847 20778932251860409867 80166263484302127724 51546195779543638047 55634083957045654992 63033975807443127597"  //21200
"50351037765700510212 81677913642587452107 79407801170480348233 12683447552840271722 20882781725615930800 11884757441815721376 88084072832311731761 37878103386549016020 56073439491652416329 28863041248625098920"  //21400
"92908849907819666261 62479597197559424337 91745697465799890155 01970433334766364456 04628108750863187863 59570968479009475618 13608853477315189037 36280236303502215673 25340709673004500780 01280816695907589535"  //21600
"95630295064786471281 27474868641243535708 44491783423248560938 65228539895462765112 53954213935845846226 23206343833322626667 75465802455989710599 88379678594325902757 32821918677076812522 98427616779449746215"  //21800
"80059738928949223053 96572316414831918368 10714276155672992881 77116508551971648712 77316228150520966326 22940610419079696233 51036549410080157820 59925139192755002404 23408851932015787113 90380400431477175046"  //22000
"32998406062952205443 77664359806442740613 43506222295831867480 34592401462774326512 48425137044112375953 66447769076826971540 28243946041295438619 21294679407182771397 47982845376603711177 91986699580265517356"  //22200
"20133012385563669218 47563484443833787137 51056357272740138198 24381886937210114830 53688535104215919991 27251903870805305388 68472031017738200923 21444606577247323172 32960983310768201840 89352414501497453660"  //22400
"57861089893128230789 65004771318439803730 92504789672055231697 50068583858851927613 56339883223916912323 34641278446682297383 38015109385785712926 36393973119065417014 63419303198684433651 98815670961598925712"  //22600
"41086568371320741513 48037749910461171587 68708430390832641586 95685389323928524466 15246616827422552147 71002140049993892232 06187894065627102046 76756613549685261210 88615194932057918810 29849659338830538545"  //22800
"69875781238090619798 21866582426714764487 03575054511597802936 58407835258031112847 83145546130924845864 04892214595507883629 59369131493385766491 81881213265215729120 08062561853428574518 24701128748128160379"  //23000
"04840831262978918000 95405073107846063839 98027435297611966144 64787854464442936378 79128101883295807424 19561483224229445319 54786419682704160344 20617419277191206783 04271490568447464703 65434644583793051050"  //23200
"50714795635644819984 97145071250766072439 67849587168027164013 25555878159808078367 17079150644165547370 17511788340746082750 16990547166076060387 49289475307604809162 53538157201320375843 45155001982006930331"  //23400
"81914083906938883273 13777209277131238018 95701240460912720251 79654675218108095779 51441588613542887922 70182842510614464403 28293820088269904152 45967898780209293972 68927329065981093298 25219478629566319154"  //23600
"60668325575131340420 70634455792815458502 85850180854677390032 80336283636726489102 30000915237275752246 55230961132448479317 78373784065170042985 09476202496379838298 45661825606846442976 40334205128499821353"  //23800
"89888896818434438910 35882007829957903518 50451470847508389810 94965470469496426784 43661354384981633667 16862317230315169870 47036176746404603792 32988368460086895022 80030185891531280233 97921049121120714507"  //24000
"23807035065120546177 61005491196854306337 40967960110169834337 19771362615502452843 50425662650898518591 19334848141511485561 70605980654719970923 07401195874114939092 42939712006969011473 15310750132177598279"  //24200
"98982522953059778961 83150281386902672795 53399097863224853583 74572492257010301257 81488163856238116290 57221657008319421090 59902725606892998257 55971669986229955755 74559455165104316957 68593691088281903200"  //24400
"43733083800702737190 93333139080009738631 59921749294153737873 77512601859237550454 56668470283503990330 76851947189485531267 85887069376723097691 87879344745148526303 42224263130774152347 34438795361140166864"  //24600
"87228505102784984753 57474891874667893982 52575951458575970435 94747576939266145738 46964196998421150689 91531724329745314807 26684199700689870910 55241772999238186071 68673289024471920693 66642135206219757378"  //24800
"22599590482312258644 48482271907568894098 62688892731766081792 66819206465331887156 81753681473839737349 65683385249734530386 59153375241235202669 43101802494092083674 25919242382973463297 10180751273873687126"  //25000
"39535237215279540543 56854522227333674046 59514990432236387801 02709716029234141539 84107734293280643142 06734413728994465916 54541387016032777077 83402880933960141901 51389651372802345863 61234448905232171230"  //25200
"71689824043150451059 01622048452608848081 63061988635759501311 82215781585771199660 27121777820237873913 53086472032244484085 14041750875260692975 05818187203321700942 21085960467907295224 07552350950766926937"  //25400
"73957272867129447893 94775422930238473527 15970653847514760510 82504766873348484587 99741732277675224788 91909581036926745081 35579605000628948352 27639229652054782863 77135997322082443242 30764939175463198374"  //25600
"72750684953536692715 51819368417743563081 30822074141458396489 64609262915686964648 79979899434305158735 72284247307293639176 41167327704035144360 58885705742356367072 35015020636026270868 64888330036841116797"  //25800
"27286252821418236636 47479220775451840280 98806309475820325235 18824761151195783509 13825180062866436709 88034622660286179222 29881603516739888272 30012137350775338645 48744636090092194616 88860384105746429055"  //26000
"32827572748138690468 90564745140267987327 67503313079589902005 60956391901893968049 42986160402016076742 47994409795204750400 62943175927630112833 95124756442551131130 08274089617738064929 72866190917159270944"  //26200
"30520322150240950450 47068785028876947384 19765917145978102432 88950405358535378475 14066750233559663636 52746679040153059168 78060314366781576459 55385053839925926515 22545613844098787189 23547978264347980899"  //26400
"03275846454224410855 03962331958319180904 70670259288708420788 45341110129428504220 97863946402403214849 40998786466224096652 40785791964070497090 00329410394940424808 05226579372084252272 97911224978028905692"  //26600
"89085875373266649618 76794976752174549630 56688720309249060168 48691203704226652252 74538485526611668867 15303391987347776794 85738483548854996301 19716968694399631597 74474956150472426837 21441670682681015592"  //26800
"59182492881404442172 52402336534501613370 10442585148588985784 70848944763113990585 90400275504624506741 53203377419880948230 33065225199015057342 20702440377837256323 77347367431100037581 19776981023713906784"  //27000
"01136669144433530262 56306088320738200033 13610332647289941062 09543807167375235866 63294203591779724089 81006857030553322255 76719163064858732353 73431564792818815040 34053702365073071264 96110567141189494729"  //27200
"33133173240114991725 22793736770925017952 05957977287374009794 57688558762326893819 89873597224870456602 39509815346750223980 58666851185029237215 60602745679321919619 28645696199987140244 07099024048818458441"  //27400
"80310765787549910608 28037535739290997523 90168559682994847983 83401253800503717220 49185764754759490896 74723712776207706453 73164467654202630221 47884228157736886411 83099464190146296106 40059957712903922531"  //27600
"23362642259166089033 95523796321273103386 60751778586682512283 41090521475412035513 99099107885223493551 51891183916955965604 08600391148717418254 60737127292946733660 97738475703576980331 65794731054718659939"  //27800
"67406555020250807406 24159844406004841626 21911396978895619332 92695486288537118321 90568934384416655703 64217671721566318793 86748809570737731534 52818060918391599371 08232706091761893280 61613993155906648602"  //28000
"35459436949858072158 29279606562190195931 69482172488697941467 30162223147255877162 32215271285015222468 02505142810633821951 98901114633410832505 55605530250750205311 11576890167948436245 87403510235354735019"  //28200
"46865820440924653685 00212626500996583289 60149265168700004652 07458892932480998289 29104202462128066214 10418107830575121170 84894728025068544772 21883867493752953816 05122643105134951402 74157224331046652000"  //28400
"85423252824354263792 80784001231239637962 35900980140738815610 13369645262208890571 03177168075194874850 26120774127025756568 66468055285878936954 84288348441615468003 65865583369875750253 49789568729248038084"  //28600
"98247197543786992707 21350715609223991629 97074200262512743264 62023993352561603456 16363416489469139466 54241976805401489761 21182432960892705575 31504725792079154246 92523091455695098139 05710869772772183357"  //28800
"37678378099829103731 65211152118919868454 98498362572636878922 97781434014344438187 37999735666863602773 86680059912094668038 11449521402742431683 12862539147328530099 94208130355979440560 20077962322204883420"  //29000
"53198574771987594175 55613528196390120165 27064520078000717111 45362371198332421972 37456379218463494320 59497516209395084319 56830490318660440034 98151825229362996475 40507417214004943466 25500472173574621614"  //29200
"48324083858948730615 50279099175098783088 89985766177076976466 99962506951601233729 54648399039775806834 63008357379557849792 20679556375766586213 01410153417547669888 82505916589155455986 63026910939945477853"  //29400
"05283119016264557773 61682264506691485114 62386648255436233694 70756448697693651777 37296570610621257485 56082143171581241118 16830946370907383252 26512827441520853708 42941563034404062902 04856657847245885406"  //29600
"17604537393848273297 16482884741985243801 53855412275603633069 85660431292501770354 85190317049865053258 22167744059505870712 16553232395883882632 05543453159631290268 94900322695585360883 50105319344681160243"  //29800
"43160755667521282993 76569318049710332023 17076358511907009556 45406371075274021462 54697371950080756345 89140421544278253466 03305393189035339621 24732742708366937376 20353117369673614528 20218352739816588360"  //30000
"44504879991809905603 35621825258514491506 58114300073988038237 08373210723260975373 24139353189746830092 69615199854842361949 66957777218437548139 51261861764288035871 08024734417961254547 64849255714970204619"  //30200
#endif
;

#if nBCD_DSIZE > 30000
static char* ln10_txt2 =
"9.7167559059869860984 74532599850345986694 21776688460589237733 60511048839870680950 05517353855742279369 73361031391434315187 57920039728761454543 06759628566163851915 77630043446877719297 05982737287552459091"  //30400
"19855376534987170599 41617471313039780733 14351099515310974620 15445861618087913831 51678907817587179062 71810713866893647913 86054482458363073820 45873556607799683081 40800918281268323243 93370758259509887385"  //30600
"39900842433491825350 61186792349558346223 04919290594625826047 23991571339544149854 82092809645488183084 51912785699318287511 40692227870880095006 90719268571892646268 80503032488525516829 06882323060909924038"  //30800
"12542759128367498041 02291288679461226587 10101415902479644282 69113354431262579760 19968321467496101962 00115898509070997443 00200260063506101120 65617256977657621944 80755873073271826973 58324582222165290928"  //31000
"75845558971506817849 63183112821886550264 67828634681354051253 44148675035401997674 60323666904204763922 57147437550448874859 16931288482816021613 09461663630532847539 62237447883284119306 50464513838327527723"  //31200
"99154426601545738140 62746641372853865780 85874615912724160157 89267642764194915509 90884280003060447227 99744342474939542182 12811619500460996135 81586982059518217513 89558003847163956923 07283207154699502161"  //31400
"41616988939558459336 44962686280146401444 42122209722726252968 33821884885959510466 70268956553755108354 28767808512959732027 23791652539014810148 74200300012167050008 00179605161014493378 95260172647931453913"  //31600
"72910236563052213098 69113855058449917182 67285747999457948117 93698819668771879533 83037683384675661191 70835225592692012185 06145486821567094064 24846185309336420853 71874809847827351470 57647399356064918664"  //31800
"05793424239983589358 08823168830193467982 89814936611132026811 16239558293054416024 67567024699889707210 53231471125331346019 53132439252024621582 87653635650050408080 09930705187053371689 62800288470092191251"  //32000
"37720496556705640581 98450239408693819185 98271354855575094212 70946736237549183191 52414840013027743073 22897409599449573812 33968247790135150079 30857537746548105255 55605573942671199590 64305735594141928319"  //32200
"31606149735660570473 56051905593868743483 53697210251848908824 91372427433035222132 74645471925494893216 62622705196075149749 64493900942453516643 45719306115695609446 60413888871772027700 60554930926566532454"  //32400
"25587157531299948670 04285293170263861197 04401644650619228049 12260128600529557907 67462814812993355545 56953700482347045245 84516362074318108428 91626476956992884367 36562424553533077666 19151994462960741743"  //32600
"97333149409222241593 97879957103749827040 17673503888160688732 00908387086553263672 27253904124134708132 23148757978862618861 46351410658874338926 90169520799685713231 46511918130657927198 88010949164710456296"  //32800
"24216251043287547465 15060046543190281280 29055796323008062335 45374623971102259707 99991105737895507947 33765824407544156980 85652198421316189918 66340998099964240399 01330145176085215123 69759840077967846043"  //33000
"56788605328934251509 63580357220076874500 72435770744756491034 54806182055929707622 38513284662535201645 73195018593707265539 18200017075626157437 48086223032473096563 51857166307393938697 44942826020226520468"  //33200
"34716223158681591199 96959548286910542787 72400415997138409285 22573650305133271720 77590796744476602374 03739326191854883205 05771430947247235613 76730172830313013783 64341371902229632553 68892413733736553438"  //33400
"80985154098316939411 29148154817691037206 88506551376930325468 71108351022484688466 71361280624938184829 15571237650315264212 48310658270177719060 93858600509299885463 74409407695027600355 38084140298413491360"  //33600
"68923209922551067812 32827004415497634753 51122566337515482257 71052754447897034162 95132036514373536397 84352969460811679836 65906969002259245345 19230146179423556284 88160963419264414999 74955583868263701418"  //33800
"77585828293477667730 53368671479173623986 14805140812762969796 43753382893740363775 51743563197367020922 23623182062704022973 55603843897202256417 68938817749919893453 40232265309922055803 41861512158690776622"  //34000
"61058000682653879816 60301069935856940811 97274528504556693854 36163500409753885315 28718486968316232646 61892156338016070038 13709750339490201718 90607824951920021870 57522824966088772196 18612971937758915181"  //34200
"05494912282889450464 12246742556865754502 05029870351079612596 84291695059934219917 13909293039845460250 50052973666108298869 67037370496915774994 12464281176690338367 17085433482476070930 79433300301841416964"  //34400
"29699083348910573714 14896091045930843720 59708669830347851743 52614143610434356981 46113296054029516878 24558001747618259366 30352858795247379361 29204504357112474271 31028812520268806236 13583896148497885617"  //34600
"82578645071571918072 91785926813249152065 73089486241921424019 43147641883796414882 53551835497776940109 19298848642930481386 15287448993504677085 14440835042416543393 40987110826224859232 97909595579257390116"  //34800
"54630148929840905216 81000894780324440411 27879628779886682483 93318223633866733553 38674385527504058258 72844005340843104471 95277558304112697750 74230995411846844653 09645409152413871613 07695469086853959015"  //35000
"34434881859288698881 75650436536852493721 91344148650364668992 17306193523090812952 83094427097445005362 17453576458484480052 24338343065869826910 30375699932203455344 63303601494187052333 27879741522689011802"  //35200
"85353797412531241919 51325600381701996678 63549838565033796606 23240399849001860527 42645192826413219947 89696600126857415331 24868308991221405972 31079745125996293772 05412426015042832835 14363138247655325855"  //35400
"15715467062607933464 15635499904374732867 77772360070672459832 63787644422874493252 63894211762835116168 69573272557312378684 04981434781500066561 53836361989160442838 57091411621185199547 54409558816302331521"  //35600
"02679772708486706924 63670404598215436844 72253570352988298718 92579708962198607932 70974679745783520248 74923231781867164041 27871634424442082948 14244421341317995524 95703041187170082661 16624889417594733345"  //35800
"23296168476673212958 75836679341771193471 17888469705589335242 28732476024606406961 52574920271246078661 58364974049638831809 26904672622972516068 36334672289881400838 69602353339480201953 80925879906072424335"  //36000
"40846667494042817738 74649578960210894590 44849237149976230626 91729277174526728941 89814213184225290456 86110683124874276448 95275474015200782502 18150978154576341855 29354898589055408152 13827915542043745640"  //36200
"49193489042198265389 21851299943963255909 33829792617825537734 56430340596026784762 82323747735975508500 85500964434015578460 34933730831633360663 65420649155836445166 20445318666656273903 70618336442887541955"  //36400
"14023315446596523845 75072903491734114871 91951624915873108528 10112003964263450676 30876108455423483280 70468799510650647217 59532460807432539892 17921505756615564042 28911573245480109302 01373501359468285185"  //36600
"93316068978733929815 95441909113877401008 36064687059240493489 65479610209605777361 63975803807888902268 64277154613141770717 08128670425364029159 99002601861179786490 33463207974573405740 83816679557279111460"  //36800
"52885032561378056408 20277555811128486188 02885391329389626527 78162080296390359569 03240376965449670707 79556186082505612797 12753794645041569399 83499388628863083112 92627036953735608380 24898027880075789287"  //37000
"88903773923179483158 81013026907067078100 67640764954661397261 92581132839404191730 87748266842653107836 13656633313634958726 32044301743025686303 46579822195767683961 18924406891300926977 01250717988443101710"  //37200
"44037198112613326104 96937432112454063550 30771989473007552079 26059660189664842013 99417026967833637308 46915916905804234707 22510802720113469502 76171747430488392630 75830725768722327437 22754105494015563290"  //37400
"18689755113072762193 45160217871778473016 02583971868671360112 42437975612970575113 40614278722851425629 47782879728794184559 28659464033944869577 67259968284590133841 12587499630838157608 70577808962584245777"  //37600
"41811961818103647418 65650099282066704099 53588376203010814552 33473644763239747459 24347551739175686461 77256687394920698368 84962486068926504786 93013082674914355143 17114406788873159759 53593716535210848640"  //37800
"59700846183087942853 31164953951517479669 86282980357800076276 80243516115750678273 94441011502220210591 30325916818112302770 22964581496303787956 71415471269741493734 62128311620577143726 96977918827175340178"  //38000
"45857430261512132717 22822177376173553973 90857097835052871298 04292977970630144914 18794922737645638957 30668759285603781975 29761815211673639697 20039914335043658095 36138878243976140959 42325880488703026487"  //38200
"67097187303831214547 45125126325694486769 14650006689604565951 98742728788094735961 73681330413482483686 53447596303644846132 02648408980743281665 04955813909634836261 04991297518479344715 82385876585030828796"  //38400
"77156089128558930610 76004075229718632092 00755153900688776299 91612582651635260094 58044909329997674338 63714237373705432997 21318570086854190992 06306126152286330445 71960040348055247504 26789085109960978089"  //38600
"31691262274995460857 15444373794303184067 20839551812986689255 02595587233463455720 48558561969248796135 73225832169359691640 47487967055959778873 72488093261175948410 85994733445196019661 66116837542519750238"  //38800
"83088565175742027887 72724084305723456342 22089525044193246078 42516977142149714601 38083552916800923754 09554659023375636480 74891156121090428699 95017928312431419611 60423515431303697972 12719231658310451681"  //39000
"28322099711047582015 84071719329310745678 51541749319387878411 35723675084603870458 63508420798153377202 19325906062707223620 90302584243006150857 89179616758007336916 71005395577470911347 90605693433167523573"  //39200
"03810464483554896987 78360813950769244494 01277696835423937525 54107028596339905349 37218774342019006359 60646648171440216554 94288567344105377946 18922113269940050360 76443410595158481238 89038790962006403063"  //39400
"89064794676727643062 57153677287757620758 29905741239999095192 77178583965320595689 39358400899254480679 93650773452437872141 44380650899620672598 65292980961199338407 01152784566151980045 34262216425745033145"  //39600
"97690399701486651095 19673531691282989464 20377155231077750854 20185759199793644668 67936007445682367138 21744455506537093852 87997181270697413944 32377891226180361180 26923995410497330083 87442638526179073309"  //39800
"12131587649302018389 75237980804425722275 34558556626822755994 27969636637061492516 42109793362495233624 41939622378756981964 15805188224455740688 22098538533113980772 46197523828151782314 71017966073119356088"  //40000
"36969778641577747550 25570905011145867886 52892985985395218121 00032741178343142754 50544573841312799015 13214409164059762139 96039216583525234103 84747863517281308058 27860145441992776532 19906612152222456651"  //40200
"33084289905966984911 83680105467533855157 65872593414642335302 10004670538261624982 92224597773612591433 06571640243487610777 29397338983610954919 77425368747629983296 95608076491993290946 21593523600605248686"  //40400
"80776260152334927666 90546981220003863415 14414228649736368437 05673588885688938009 51026304134693525807 14334205689052835805 88939904518758726687 85936684672175999752 31490631596780401207 37748306216895257436"  //40600
"93084237588596934742 68903374499014904648 48702287644628963342 94934920442115089697 29750063050234354037 42193594916785735809 22656190755443206675 49578745113605183325 88530843803571668128 89310435412109186936"  //40800
"72154553383750763048 94555372478047599947 61241119847742489281 40187381957156483626 71724639364740420470 74035069707663243046 05334281580955077750 46636800061972594395 01949427925670215051 85735777109211299320"  //41000
"17628580470885444219 02640261787048661761 39111086232452263636 01714231972913154995 84073918694134164900 61585863934199560277 08609079835778114985 62549498102479781111 81893956022504980332 26481808049291760505"  //41200
"76232944214009854689 77247162135359048385 67339717422317978870 68020907488808612652 38705260498166140777 50633071607783757646 43795173805333123401 10531305057876504004 25777734078556086463 73761241031937501765"  //41400
"31194276884374656657 76470878677011061343 32301092673494453113 43930409272299440124 37750691688667217964 01715943493389809773 12547299872003425067 80844807040229520230 15314514895431181435 47565704615146165047"  //41600
"10568699353311861386 88861493591438402577 67109923812913672772 53898738902779555767 02013896063826472824 09651771037721048132 76766128251176734232 66811923362821791283 22744228526811864743 98757048863200622869"  //41800
"24719377083710128515 85270015892884682162 54031565402747016161 99192011546799841461 55996514923222574906 07267348338453614750 02517821593048264951 84922842763741559013 05636269244988824745 72767397781518237579"  //42000
"87092823234773931833 62956676745386980183 29827180345049517905 53143718147487228955 50197333373389937342 35935827319564631165 12406814430735392636 70154102834426603768 73808534838759580449 53695930463236130925"  //42200
"18018723253243549910 68256367188846850472 71141279231293782099 68716117186853588186 87563354890393298822 79649713853271464613 01616827305438958039 91620711906697606573 89037280469132510169 64685323417131004651"  //42400
"21422986999173885987 60254086099583633278 43361131008785505228 42220146279949632833 35711198688966625354 82104554865180155330 89268464213373226077 20821824125501444923 56623929705551507690 13298875791379145328"  //42600
"02088315884553964193 17698809096019430820 24206624719922233076 62896022606823618900 34287928457211739243 46398958364467945790 77546335000563494014 54211062055733864447 26865733454925941455 82637141927948045670"  //42800
"45491298113531551945 46005468043999227106 80192485317595523319 41443781767992014615 72996885162497121861 30091155237611556989 56000564767493440908 45882166843952609782 94890097935375405207 25426783789576639186"  //43000
"82013742508470853183 10537498305439382080 77797094174715774133 17048553877215280656 66849681100080165183 66740170026425993320 88518505546742055770 47653738726134691402 81220981229079598936 28582596688027514354"  //43200
"49540837472693890135 34770697288825205284 57903023875804524685 70126612499057022729 25953953548128963540 83738761392294841489 66455087864765064598 72733161939985246955 64138694386310882332 52981409450882114174"  //43400
"80498871114538623378 12635554197716696573 66871367927065883854 55919455204730603250 55478875731843937210 25888240923451798031 08132312879857994529 60303327213508614494 11404341536048550778 70017585288707743992"  //43600
"02384111945835031904 63106962380338130122 91977111461489715062 72484778394760888133 43862483753184634184 30048469120908259721 23009873547901648022 30563479419766900408 43649307041238785252 19384197915278399744"  //43800
"53460107218767532027 22534401825537756107 22251860399527567906 06945146734773092898 81749856953555092957 23049287571867765661 47416948943296313384 15237501663734506105 03915744694188547800 41975441191289616976"  //44000
"26111913360217470135 14350844828123868176 98333339413275520279 38227545533664982512 71788261597987571356 75169107783284175467 78361947471615222748 50814364149735796260 99475943172564313062 81536562170641464203"  //44200
"04568589750107588235 38053416133358826043 29952295405679036507 74556393894978505078 23796581935884350140 42628425364733035768 49741814161098272592 42248043842664715508 13361700501312936985 83392233585817595067"  //44400
"19629298296599725850 08471867031013792593 24025792703764844855 50871809590821010510 42497344152278237037 49834131327365941615 47647565793822127465 20753064733112877509 55905404124601621363 61546004220389644679"  //44600
"89751255304777555876 78052494781439232504 76104032488212787436 17822764912216629360 48542935721949585750 37018848922327934668 02124609622004980945 96812720650271624536 20402562961636082270 67891751414083623473"  //44800
"56135649077959463351 77560422548827913293 74990399287403985854 22944596662372937845 58488465091268925903 90358288965464501745 15720998771934492172 03996812927626026684 47359387401194468566 12154105209178059463"  //45000
"53165688732295270208 03405820509402474945 73274594664232459108 47825023073155005703 36244084298480341027 63015295479100554654 13814999410687002963 99259304954229426112 55157154517737010670 95511334600856091475"  //45200
"49741563622184113065 01389442156515459188 91250578744504760009 35197281131315920310 57982282756025502392 39977494332527010989 66054406896588553700 81624467305788891329 83235629592579828780 88365044398566745553"  //45400
"78249043268414982594 94439763361688556718 02168055377321794579 26798115583126693149 78538922316449897209 40632883589124619594 15962103607828823474 58239400408860022047 24175547439639330117 89480080799526368515"  //45600
"89206413732575115804 70938622158330668377 86411689560364523045 66360519462753997633 14371580338704431291 64963920289257078768 77133807777711643570 59668513795513732457 89144439025269604126 61377118116977455733"  //45800
"69133733041450822221 97803667997965170232 23160451164542970332 29961668722502482031 76668039120495306278 42845005521919437454 44072585086021294031 69655472124064493167 50460179408277077334 15874398038576684679"  //46000
"06198732498099145415 81362812166194073661 50802575880964716489 56967072951626730102 80842109879230556976 99589054627719794077 92346978446468922820 97783463200770420314 41384748184031955202 39468830814479977898"  //46200
"96560264754335581948 15353981996637810307 79770749561357953362 75624524569749692371 47317050018089448525 41508293610424231709 49427422122569798666 54538270664045698888 13360282732032238421 07541109326426698555"  //46400
"15365903592047671780 47383961779591020542 39153089754759562584 50512129386349811119 44109646957093028721 66554682510318464436 69539570209390452478 28043869595133964156 37686127647893223131 12751424521198833551"  //46600
"37988125573201757411 18919718520613340666 32326409438884651335 65340284700338469265 14689620946481332710 16653881608390589340 83473163239827391429 98597537845111344557 22714032338845145872 14502651221484842127"  //46800
"13375732800796812705 06779298763963307634 95163422547517683348 57996511478793044281 37146938714615197516 64729953331349711044 33062966864842384358 86606310332180224004 35549974535004515176 76205216432993870076"  //47000
"16759015673983367321 65295979016243542193 42964063060932273568 51626972124035011849 73734645951180536593 10740565488363077917 84550965906288861096 54399372360263405609 76342515779328153008 58605567568271195670"  //47200
"66608732630024989555 37546251538704068254 86685218701068651020 05705756523915980014 70345464425746493189 84368613372495255190 05618488528333051383 19668615085896316724 28617034660651207081 29091327042441983322"  //47400
"63111495667120329055 03231424802466900941 81805033045251015992 00582774037170982988 10586558359746939858 55874023168441229771 91864061277181420001 07881886238394841338 63856490393296003661 98614201009296827455"  //47600
"10801154431489333947 78897419320521707806 00272779529390367085 83401360096580764205 39324221499493892863 95755247716874526676 54593338640916264011 59716988046864117425 93693630399149280634 02617612359451280802"  //47800
"43174115091952969649 07607691547297065466 42861180409749391871 76787663028227008674 53816897759647785770 98413379378289985008 80493860659023815940 36809570374382486833 64870295267229409784 24351445873290689333"  //48000
"27621733175159280904 63306280738021297991 96142423248886344772 64598086717885152373 34294071446082943809 47383572680335065085 11475986744441947440 09637796963952369332 42452935703526903362 72683117248616668025"  //48200
"84223196493113057046 26861632497178257202 63801345141648480893 21124355397850828038 05231975070438733492 41807564321478699134 12486894584347192222 59714327838088154709 74549600334568492961 64116787453477492907"  //48400
"14806456887184323372 68644634918036443398 57658156306464905713 39346957110961643208 61018712939659874967 76046810972547801577 27439650321381100748 84157467109027032459 13225438199578378905 38360440443874381266"  //48600
"49711804719052345206 13954945832564204082 11047147987335877353 59238170601267047199 31184435754915420077 31220686558613049239 13535516122603760397 69562914765465843570 77902111397203125583 94579608704569207332"  //48800
"26870422645718783535 14941947153897313127 39498251773771835212 59609961341647901515 30298906814095684541 08539140243528369188 86378682853226664689 81594807960847891216 76028446724963713912 89311395989202431530"  //49000
"58197118901658020668 80765855161309523773 06590108264781413433 97635143778820184638 58186388791706338891 43185904285715454643 40739340872448867768 49715270555115187257 41951420781822271845 89044934112610863467"  //49200
"50867978080753644994 63184641272860982673 56486789847604924914 89992644146281278393 79905569438284687782 94185005092974004466 21632733217382017995 94790174571479744666 55763480075466858523 15636839904683269729"  //49400
"68181489398594228275 62961164408334777696 52936698880047664904 22535574938903853792 62521420431959230319 55772766578715494707 01987944630840935086 75315293618011080349 40129770742087968779 45333711978423987665"  //49600
"53103313505994930349 14109872004133797594 83183617944659468369 46473072082652312401 09012962163037954101 65392023171576364951 61071818331971152422 22461848481676062272 09528028789881354882 99299252747890830093"  //49800
"46403170053390895171 13640665252964627576 91638774806377525581 46828483516217697764 52513097873330289707 70179314615072653625 37896603225417699048 74821140493028306574 82800598822550890297 36950053162276083090"  //50000
"55408251715004701455 51122067130271768954 56148679540071323459 19741086138400514480 23968962638750604309 52914597344868371724 47475151695492503523 98850017990050178432 35108083412922893335 00354778235465998253"  //50200
"68453227286408940300 57833813691906722774 10437474051296794914 24476070365993367111 38154405779947207139 20736835164455694109 11849769249454406291 19855243063405330423 62103798128392259679 07712363618684637218"  //50400
"08237247900671854371 59037266252199946426 10098203969819195678 82610208332309153031 84786151122308612126 42572775489647943068 53495076281299556625 97245755137619148460 45296680723446798563 62479066542701791679"  //50600
"74057290841063336532 60614562762701604024 23669318408713850859 19490617692601052336 95794254457948333882 75807366057646915640 71111976265476075062 20124419875910559479 74288484432940950016 92666906336822597458"  //50800
"59586870536194456452 38111625187853170310 02223679889211646642 69854678444925520960 99652515634952699872 64484430231503635402 03049475992469689226 51937522101108794584 06620180585790652733 54134832344669642818"  //51000
"65669500063290839624 02609141851406031319 95951811460988051201 01016823284653873885 24796817541283107982 44672206749257812509 47903051273373729474 48634532078892074368 21206953248404819585 49669796151381316625"  //51200
"79952690931862899111 34681108253211189830 11052211943134393409 38355781746217285307 00897544306589945221 85580040009746505043 33330801078167320884 79557238859997065742 81528022396680751657 62329693353425554811"  //51400
"61204844073190045749 30962962477967633015 71910851809139932858 90741823852861968827 32156866175328552295 95123127699307772650 64846755729869948200 07742302671838136249 97472630308482707080 28622972086521910265"  //51600
"69782027959662033456 74643694442782519483 04566253833227853099 12420502417801580786 39998105099427318826 86626445154333423390 02437177012661544720 67799793725962356978 03911530234751984278 13372427897749170016"  //51800
"49987018908856959435 90524226475343359022 94980495156785003762 40283533906931672216 03393207029276317854 75290797848136569597 71601002706152149922 77329270813694671390 16109962449445195198 82412092985065687194"  //52000
"29564832286222516403 96379822223047054447 73431333207013576167 21308924255536173239 10926360850902378832 46739304560688597759 87473562686334590496 08277245672719016947 68967699236164039994 49059389730325400016"  //52200
"52483616509214039538 39111245183358044951 78764020015041134509 84769261490462626958 85186330513832154053 12638537441529716337 02565179240213540419 23532485927413632246 11117063589732663490 88069147328773434266"  //52400
"35850826196393886727 65309119651302091181 47026482920902794122 88666529851813398776 01589934271981809885 71477363022649603842 83348326130630640826 16083433258524925978 79461873923670347036 96616066417665718287"  //52600
"25467532780831987787 55451326085682330872 22656658644147987956 94993209890408037621 07389750740274857488 03042056107184952627 06236362835363390937 25361356198863739941 51144820279189721044 17690306394833758496"  //52800
"36004669506925710067 27907703470323495485 82492044805927032091 06716481452746869501 32661736284627450188 38369320717696159778 00487898812635914556 77034233725549430387 67593638826912134466 44182962787523653265"  //53000
"00917238465890514726 90499705890544544713 43862734935194466985 54316995228855037969 20749995353135282801 23793598588542369468 10611026397418355421 05105852297100219686 00060328507674157868 70277605733700684017"  //53200
"79054721730444876956 11885906529604651086 85335729473084391972 88642725678901588755 42975574302661558862 21169947706119628464 47664806089780029515 59696644387276792552 81839207202353146367 59739848286210480105"  //53400
"21986901733870405683 11678973113476281687 73520858514434119816 41642786102547046633 55649220538245163700 45513843206128365156 93768017014804408880 15368383320510494329 94835155241770802886 34460371312063206911"  //53600
"81268998885818423240 90784250606108696575 22563705438439504907 35435693889799503597 45141090552179633063 99199387765987115556 61202458957404120871 22622475891632407323 98503106079548896980 49962835665122129613"  //53800
"72008384157202789289 98706582058030104584 78087120550404532692 98571714130857449654 60716041969897014537 34313511337908165846 25480901288454964097 88251328683391978808 14568480918604838688 17705698066136091171"  //54000
"15688272319074132186 41548088745599443886 99237581348479764705 51380404469401237672 03803077010990298176 10656247312882787171 52239742211046358772 32890061730647162153 00355561874113878694 88804645243293515447"  //54200
"61642204079752472960 18658952497551226004 28239098170581383221 33329400962475269836 97097522094172200068 27041753716553520417 28010665669048404300 43923435372444760871 50503439649446277494 87997560865564393954"  //54400
"45326738214829532437 14853836182267625244 07835888262291325504 72984551336095343733 60327268464218777339 14113023193358237880 40034489467984639277 95533877103162267423 74246794066686975301 99028987402614548293"  //54600
"42829095424513317699 94431675707709633949 39942461232655017191 65869526637375218709 04193943851347518010 93416225035193677056 75297382903588571099 22250058586010597028 49921743530298883985 63355742367963999647"  //54800
"95814493559691186087 57961017057748170112 85890169845747427464 90803093879360520095 96606254991219489587 93243450400260669847 06941879410887135550 51503474137706652822 22195936476987722392 65252098643601501264"  //55000
"28813359170896392106 73474584074240907865 24163661893452059471 44227478839445164107 20997830398186985859 58833253727601655002 14706092543033542346 86768353599773459515 00355268134171420229 69045386855820743147"  //55200
"89200926209331684248 97566078444592268509 85681135459209557227 76169310641142654908 30629434285639655051 49883654993928551017 43344988636194759780 16833223656737455839 73491898106381030348 96993635854102972057"  //55400
"78130457773833924474 68940196548135369274 88717307375444218379 72946828674684150325 47982854027103210720 53906896994047506543 99315835804772960426 78537800339476789235 03042198505259321270 86663069769320182323"  //55600
"38715846430263834078 73959220141069680950 62436878534424213786 03570990341797975202 87803543546219997319 71170081618142275199 52971925616239987173 03702317404374165018 50994516113804092911 95569227665015671514"  //55800
"02955852674239227298 07031274623280622839 78845851529278747610 54474156880642021414 89405846124135364441 24326343629521415264 67347555749475360759 54866709829110498566 42778965172097418989 24433728613030976447"  //56000
"45375042886695967329 28249312142634886499 75435816099493956026 41536722362217657153 67007673879803039643 87112876241125665086 71248329352999382842 19860793836684363451 97500105431366116282 16485597496419841833"  //56200
"10273364434068591702 04010369766833953224 67421920595023966828 32716866456324668979 05312423196252314919 21562688371891066564 39297760294078728977 02563704711955999566 73505674886577848065 43810615054671354859"  //56400
"48226309475531347796 41451415286602087456 81780947304440883161 58562970365118716520 49759123833881865934 59720124866123388009 30670470323125137455 77950137379203472086 69726615571655684867 34431685733411823235"  //56600
"11825136211358460909 45584588685483785122 78711628920620364166 07300793791397570539 61526646513332460466 69708188498269271075 73015421118616332073 08008900889498642433 33936500589038322689 22803792346132400777"  //56800
"27113453657264892083 80016784830062077330 16780399103771328415 06656929490581247343 20610243748012354693 03345610455983667859 67998288293086597174 72609708820483128353 13441830037349079072 31164417303662434241"  //57000
"77377939005351819686 47683599723244199190 57989190384926952337 69620591585860177236 25027425437088300255 86624491003602162479 78619288679519837682 07040213470486854091 21136053000669666264 00785566469041170638"  //57200
"04554194464630560899 30146504523575206744 46782875229163809530 76601365290380181793 08812567940402711803 41864540162941681808 04593253718903924658 63933153944740276687 99982404343820629714 02894903642441025835"  //57400
"45049796960584380676 16724973886919019750 23592907502255315119 74876987303970808904 45123243803897837886 63932469533166924705 91191061654088206041 50855339197229130052 60657329370565579146 98370122275550152061"  //57600
"29613339110450626878 46154709104562460952 47074075781007537648 89652378413908220846 75160495883554675117 83971113893484770489 80546411981301973318 26604327832713124247 97863518404266150927 45338386655382066711"  //57800
"83845674792280376990 69425757370920087720 27630089351400335361 93183943331847349822 34960599770904795982 47541830416227236712 05903962258841421125 78192853636191656150 43935846165210610451 88919427725310814518"  //58000
"73832160200161690524 37398011760788322637 87584857768595700852 74044299195702192655 42199553775613755459 23518606525116339325 22573477049851827415 91239342215322267115 23209520563674736892 15551649474443724868"  //58200
"04342262186988762311 71847797486374529985 32319428106766969555 56034089886134074251 83812906202535975827 27974143913815791959 33445540544090263603 18006473581871283176 01899545006874424153 25836638999288792383"  //58400
"27454531987150160748 87539816513339824220 74019822989725503667 83094029550041152299 89922763490330274251 18649918697142282464 33338129952811636852 72331473800023979865 16782028999066049426 82000566006429841759"  //58600
"53518859927359244363 51400301497805740911 34279950064844171375 67095475039852281664 57125665546773375722 78496082493409067580 85863954533541248044 60184914553425782214 75303489065659313615 76270170626647561529"  //58800
"78425907483448548785 86589848791299666532 20316693744578260694 12267207730208684820 61287365574727817316 18286889407550915997 73478491734338057076 78441035477357003336 94767949344020851969 71527119143906113575"  //59000
"01038452899525845978 39608494003133072152 90138075313937858745 75098472498750262372 96129341106451158188 74029380563468936498 43174772227611413831 19903276072758815778 55428735073377120903 64632788961982862314"  //59200
"87887674141017586320 27606191002080637313 03440057817363719315 60045269475678555655 68900473925755129223 98280571580723016235 26443486071255163159 37466942375183432059 29158154173557734597 93383338312677508988"  //59400
"76410928435685276475 41959438415267561103 50862144002107719223 24956477645783595619 61073546775422392885 49259955500502414130 41237381343978007340 98352598789326776310 46491455346190556042 33177710419158791494"  //59600
"63988979676416149932 99156386978614042830 87420147257681228171 99395121591973207390 33365622756283130678 79274130829186922717 47101481377123462077 74054821561885221106 16778809798451520333 84322200671177036043"  //59800
"32514356959298271362 13746939839876603967 83353058318752445218 30102829916031387097 50023855940029298576 04563118830259610968 18910366289216167581 33937786929911831401 34902801240214852859 74499048290820719487"  //60000
"78927828525315695360 81845815272755464568 53405547277716294366 41454444745081051938 37406962627764085259 03136691119691261175 26505857249290574398 51387565633446550473 56579065014023866500 83102717498254125773"  //60200
"e-30200"
;
#endif

#if nBCD_DSIZE > 60000
static char* ln10_txt3 =
"7.1945847445804221677 59238430405334120798 08063284529022309419 93386947117908927602 40953164671414968238 61783949378783695978 70952164238060839880 37600009351543877361 91505666613455925148 71733587385689940247"  //60400
"11074383815470232078 58444411020527731937 37300982991290561935 59462337991539047708 05009851156251066213 23331566783163791140 19555695385151613235 19285098885336250155 16917287525741040344 22867219247985819320"  //60600
"29675437860581827794 81422567324980432690 94570231597104779215 34223465096818256657 82335132822563731236 59806707980062387512 14153477807429147430 12731870157625968524 24487936724345321796 55671934330076186251"  //60800
"42858571275498674821 60340437529594157452 31624251404502317916 02845096432350806346 25293761726721204917 81439503616463297410 50925587151812954649 90180024736124473901 53594657795566944682 43675338843056513455"  //61000
"88355677938938357290 79943598045587731720 81090099647047269417 12599451546115777172 57416588715735353792 19032471682494713526 83759265586717640767 73509780883743008835 35384064746248330626 67025161952887454821"  //61200
"87536535516086003130 22985953833158710382 94865998629652898633 44574993613956442885 85323961145710294024 64174846822649957522 21040731061560565539 65624350936371832724 00826392726205842176 39542545392339867678"  //61400
"44991927554412304642 49895049581339919637 67364120874733293400 45735878921137364041 39703578983015335279 64214879269375628167 34241312606948286237 02038415246428261359 17041627492008019346 80271691242450413718"  //61600
"88140764395484729885 43265839158536532855 38271053287224913706 55944951307611104634 65562659408246009415 53170502736820349124 64641028845930781166 89313395609699479568 74675163973529590351 14886954417124006504"  //61800
"31226021265310782638 48609201315059328905 29077248169676760190 98030411266653341993 48788514898440178316 39554754128456021157 81235880324935426353 55832189090568167424 06548075430478031017 81578746724466226847"  //62000
"70823289095283748787 81347590191899131138 48775351715864611473 14220803040065240647 91318730123685529841 34308036484243764500 14237950405875534547 67245903128249052255 68403544699181675121 07170854803377000890"  //62200
"75824670771245309622 35830652514860287522 59027620027828948273 46362175048807815221 70275352764478780520 84175013641649998116 65343406431381363175 62920315805910668152 45219691158119843798 75880698664200403582"  //62400
"06371326065730625094 16823323371092432459 95813258530644591020 87751814494716619683 86376367635138018130 07514814495192681213 16987569000554855071 44799863752955155683 53218357245193416202 84869093656627091200"  //62600
"60384953669974553919 58661800018285189439 88902549657227567810 85630659105409555469 05471864739680843814 83632793329476971148 28975115258724131654 47807495587120613443 75811379588330271602 65624210676267170005"  //62800
"57007701415107349229 92578079006198796878 53926851795463274591 58316260705097671095 14399537933855386960 07624518988823676200 90150200801477437667 77853717313950789505 07734638432257524348 79195701393492848627"  //63000
"79661241449548024238 99584301760641990603 82530840654117236599 72981859112668540747 21380094626862055863 84256461979649349238 35600978538832759623 10203763728484383099 44426964199481107030 12415924700122536009"  //63200
"57403615831406149756 63618351080465115119 85124292084565076287 90338779106444233267 32971885953211657928 74816650391233260233 12011130955119867463 01078181011570093653 52747052394017238757 88935919522085753738"  //63400
"01102066290944943142 45180933089242712107 13831760819605957792 73095194710037020604 90335047844960038255 65236121242367434796 73292057487915385800 67690755095722609720 76399700051092499412 34828151670317116715"  //63600
"02633385104210264287 70861051040741474138 64124797456084252819 39727576772446373657 65506453621271626758 53471777469740142287 97123496583762835343 77311173247329199582 01373635849535771803 49775393778666428725"  //63800
"36024143280626844188 37253456215732663819 40778738334953718181 94343098855586015824 39604298491590160157 13378991476010624557 84187189470765306201 70661783522172750721 33705501938309911564 22456512092283563660"  //64000
"97371462404632239065 50215627184730325518 97177523184511520263 46370406585718769425 58926586593607195902 48952544824995546021 77236483580156306051 39099681432634237241 51912557873062589424 76108046161984459678"  //64200
"72668268492267631412 80015671073277146314 59250209757050644868 91598568951665772045 28753756848210562356 02764618168299026798 26739002706050416596 60713757317445604163 39279395279761374706 69674209601831665377"  //64400
"70404356721963225234 15208718607905894577 72390918696214421978 01511592451634815470 58215829976450517218 65239277141350494835 66755888507021447596 25608545305945877856 97331188028836519431 63501847901392249825"  //64600
"52170787180431967853 87985848876395712244 73965670875838160522 48774437324259513751 17314980493282529539 83895501596152706325 85129088389884440040 36457748435351718885 79400643836719319127 00783051066192431252"  //64800
"45606706419002497067 42374858852210304696 06184202628466057542 26677879097619023966 16215460290139999185 98227953250147416303 75621233712098605915 45695300598627997706 09938765224347032752 66406906039896106957"  //65000
"87735204555700732919 70452801365393781721 35986621792910992369 89106502023119745816 94680782156088728829 04058215137992827114 25848472043471597843 32001337727214392557 36166019239728319600 70350336923052499122"  //65200
"75272484483702681787 14777637847588612356 35679634775929101476 88489384458050168869 85649862356038847133 10497906586963052594 57990702162768149315 66886804856539458327 98709250339079176739 83676108531757492418"  //65400
"25073459790446119728 72856054649525324540 61342809826452382459 38874826630989423650 85399903344388454502 93093183153061313712 10064890386049137357 51651799397100126573 24845887627292981687 07540231519647723011"  //65600
"57282550423639416771 49957164978287826539 50900198451502594535 50648591931229317864 34525591625138909462 27057977449482108610 34147366606706072753 13163548918646431207 21515164807589808829 22442644717343548289"  //65800
"77202812615820954304 83591520358173033532 68810478048795793200 59288500081367973119 69952676383051181673 63613080514391453433 88383280368022534725 62921147036967208132 47139310911628170357 00880561152149893100"  //66000
"93483766137627713522 16964053084651219477 89456731635518682683 72963995832822811593 72533756599192127716 28730119989628294650 06247004447264340640 04326471296260691281 72544924343228360535 75748528895597514673"  //66200
"66648440841706297776 09930804896260187897 25457596052603763421 60241288651279527770 92183522228509025337 00094435147341194944 54275468969054139900 66000618386185418653 35484290399198189851 50299504880244740888"  //66400
"12875755349391915842 10574372404288123893 83312181177075079575 02471284808627034862 60002280685187843233 39144824504501253483 19114968499726760453 04050883403779339594 95799438563994864170 86915596992237944712"  //66600
"64965871950786965635 36028529386402635386 45594127579039302797 03678444170411733351 54099467338937152172 94988076240672952222 21844895799347214204 07326403282577464115 66109118316574646871 09144223633677302468"  //66800
"28448393547614443668 72074255785029181298 82738900945692156873 02124910103237274083 44275439360043430577 11369039427510564547 64842200055874076182 74251561732512599900 72346575244526883229 84559085020681223832"  //67000
"18033305751386679542 28564439726095091202 09129195517894957485 90047439145636984187 90455323838072142422 17564094796052620573 49769051673232688086 87732535128047853163 88835972305255965489 57059379111737730683"  //67200
"63043371309960321423 55955155649993835818 18790679064487614051 53209254359711586172 62915572091702040372 52080830337762412080 56373339056545624891 72539986615376770342 07957655345381873093 91717802861487905844"  //67400
"32835345698854409270 91859248262064367589 27413094058124338500 27413483396399361894 30138668474907796274 49933443625918003807 87749318891017626874 57984116971165742495 76308448960634186674 86346783644933567370"  //67600
"81046194931624114637 73062669944831466894 26810458772723937924 00040289197058506817 23277998856749090507 52494452580689168354 29501401582791556246 34290633496088831135 49570327631626886918 45972556665633846756"  //67800
"86873371107891692079 58239070207925556068 77112433206418737659 11615244398473962979 82084714451511470092 26224941910998787762 10503012991614652246 79440717335852534505 39186891900626833275 71087509786373427038"  //68000
"78103960279045989143 06878075665020615407 99867724669351101695 87398442732214940833 68485152101595946692 30560960974794831677 09972157088015367863 96404836302721104886 72122251901726112562 15360745124360977241"  //68200
"18221651951897997200 10064860251912354879 09063811019654625035 06420205904608960123 09160478226187324751 67306337504689510475 69873381038512117039 23731362267211143145 28768346396476510263 74492814995198637712"  //68400
"46117616392812664945 43925796187709062219 96589163235965246349 24131517093098754478 45357147482044730554 26002478402988433213 86678274821459251253 06585078887488660788 82065373299225546355 61968249867209232610"  //68600
"85784173629714187370 73466453078294593925 90612210556979229173 10177745491132545577 94171212648422094290 93037103490123540109 61236084169568455077 24032746647830506477 54572826619316476482 10465036466626849748"  //68800
"76997897731295865832 76778901738838878728 31049359406374381504 63729065214280471810 07925611096498517566 29142246826615547164 31166746419929804992 70443269395223911124 09768357117940832864 74702013295470728631"  //69000
"11644251079955978760 52656750392072140151 51697616146549880130 89415302001770107718 96591571531119844781 71393958024483709473 25737775957908760405 62315163214361864540 88334346036616881276 31697175989502586860"  //69200
"12830010747892865914 65775405635174284989 75788298781076102994 65364913424846108791 10441195647751912262 25052402086176293478 54857409655800651533 77239430760418237684 64081106864580705071 86708279830856384788"  //69400
"96029935264610534454 91471785060341848089 76006452327793742594 21050070589227605790 28949440954428815209 34483846641665011238 15269639721703984978 88023152462173965166 62765657639904525015 90935292075940923359"  //69600
"72741069276365357592 50867969584673437737 09991642171153068554 79068073775959467003 51507905640192401189 91920063418157275351 69631487672409524545 60779204112057422018 52630967067970256753 76839222992051708635"  //69800
"37858864934016389701 89723509881138342969 41185194198880344900 30121006766622050155 27340816680721453512 41813831476421999351 13818998302084544080 75396464631656285217 80394453284000325006 94498244503410110614"  //70000
"51280016116572621860 81379951662977425738 54385171086609580076 65589417616321609961 66310561227397865208 97955351525047799198 59435363890076613097 08250666779497503776 33456158782703200350 32528042862892975212"  //70200
"25097986746572868086 16491358182730198581 05005782063296375340 31491562866451660418 40885511789377449462 30833823325358047643 94057355823789998718 55302586301018936734 89974621933465017892 40602589836778295421"  //70400
"15313143774831912332 51633756416621487410 94367086634800436801 88558113648366909700 64858159634393914793 62134661599007803043 16814504469920120314 94618646992178137142 49239580053158607437 18996276792160798423"  //70600
"12408430358819457660 76423168089726552291 76480952255005856328 16677744823143900607 16093681263076720628 98224804729355939247 63624278250868909595 27533194307887356953 54714648306431304629 14997031438247915178"  //70800
"93348863324602505682 55203196408407188297 23998605688613245309 26056967697924644589 50412888362228187341 08298420149581476145 97953127613392091688 92145048699636155358 45364689324997651994 79831995971392338278"  //71000
"04494413123882372569 31457607296266195975 08704897126265700512 91266515222011027422 83481754069037803667 15152612089395764022 71993732862803452228 92512905140483288401 68682216643185822220 87448790628712456137"  //71200
"69739790520144484718 45950328634965140733 94049722384700546311 54837383436293172823 07645026170453315034 03479499275305389172 92192764073188563151 90149804330643338580 56098369727452457074 24605269731328979902"  //71400
"53166090999118540514 38035035199043551518 82791549831421912984 17660491429051037708 91223263238502493099 59932073693888475279 22143041030416999372 66449353742280269356 71841943260165081081 24751886270946646112"  //71600
"35928943037205646376 84013098156638393190 12739776182600074784 91631502688462723396 05495573432399184960 90737653002276741932 06050970676136314229 11648321844372342224 10888838294592916561 77313354917683465595"  //71800
"92107771198600029490 06816736593177074899 87541208897123999097 97214466971101413161 19701715217897544584 20047958752493826852 36062779741219172651 19849089164625548291 50364974268516524069 01911922629164451811"  //72000
"20110258131094932042 34558286652016290043 64714568238745068190 60386061513972503964 04135001038383687317 68963026147267322404 17607403610431423799 36343917127428530704 89745309934202314354 51236901414349878277"  //72200
"04019128751652773047 45897723182462211034 52101518068174180234 36089421223384524246 88376582967171834448 05039475406530027085 89107925351136698745 97197158269544810668 69789642216575346321 48008193185213414092"  //72400
"29810551321054495629 93730330281090001225 96855856612552753428 82464170528973645240 52823321559734576621 71437378925285375686 68868225336487057530 71102019856305853206 15125237111342514793 36951417891709242805"  //72600
"14255729797523219982 20600180140146181335 41099894276804541189 40524386662038421415 70929770472277214522 60613303693554451980 64450361608674336516 32323065684324546498 36091128040479896245 89846838588733053221"  //72800
"43037106634655254764 71779814402597405009 91119444265637960300 61124226193602725783 05190969495821591333 55687405899972332099 59347052868282056370 69249718507485808326 61922015789830177795 40363157713608807920"  //73000
"96456935956379237857 71287873784511499712 99259260206934642406 84358874495886710690 01148570117555901752 86585727957852282755 62360773293372220864 55917358087579298743 87407098673858407766 44588342222846307842"  //73200
"29316165955705631478 20456845267966436540 97745978786308950991 77417972186618277848 62219511027721993774 41240343182740508140 80803535022884852180 96220357801169974472 34252447346916819644 23699611583150701409"  //73400
"21783400113213186196 48870359994770445301 97220804603910139888 43283767367218470221 17115623366129048572 15947407297729000708 78551358174353763830 69133871310611984656 40060692258946925678 00134251265723352687"  //73600
"97284218611990142669 02984031293372305321 77561548707438200641 50533323291967765751 47382931758545346661 91415366764425796484 19580426118421786718 79280178853498790366 53795373864290930479 70855924229513289969"  //73800
"89112038598487067867 20336715903754046627 16841015965979908308 64967974031991276115 01832757866943138059 35313265361303865699 34547086746416715059 38887937047777876663 68974912341218114632 12236649717088934629"  //74000
"94859191030800748170 75634251021302134762 76037865520886905122 58725261432833007819 23153382913553200859 60572663120451875063 36481384461978372082 40397175712384398309 63832271970059266847 73954725731143038379"  //74200
"42686750007296739243 96184394934689339199 54473417218932865594 19867419707236478925 20675476257211761527 69565342638158183484 30816472200082990753 77349817239959922203 25511080984890139092 05883909858018024954"  //74400
"05854082752270618753 67541104043248633583 17335499326846767885 20744698456505056155 41442910072469395744 15797009737319595326 69890230093911902859 75865922761812574423 92416880472218720293 18160639920698623842"  //74600
"63275346349722363002 58640151264992746395 79159989855918376054 25583965482647833941 55214991189177510964 12692903272489399303 24207356698447637039 61281193578509361389 53305900737440811954 97830944665386471345"  //74800
"12186562864283123963 84861423770775128554 90613583809455996133 55247033114171604368 05817315271216466795 03508380320901885599 24171899184665914980 70588813097354938657 54388862002587183189 57467349868192816558"  //75000
"15117656775148133378 42023440333650529450 54839606919808431668 85402293081467249583 88732325175662292172 39226494717924841493 03987333779592030398 92536469106749385643 89976506308844995718 16261361802093696884"  //75200
"11508451930757503437 59609743054410887584 92298867777761755807 50050250280236790287 46860235653252273491 44811541952794937383 28445455147933422348 38876347479354086124 91326904069498780140 55286643808815901355"  //75400
"36091488512321653711 25232170971460217164 06756163592867011255 81829030352338294959 78485536973657783294 23818002355977553906 18947429415940976331 01059505251428207413 72137690452110203440 78370711350504137432"  //75600
"04945588712358627991 80381209894909703240 82361800841559692670 78269689002922708650 62883075673950914444 18163847696232535843 92792436288641023567 22653996130451191858 07183386868737835794 72682848386456062792"  //75800
"25723575651754611871 26776099662275912459 52596323053260808281 30324081645570287737 09336892226605135393 83031966283343218984 20545044776510108077 54135330115567197640 30450712514307279161 64467204173731482916"  //76000
"72615443367581011134 17629691708526780277 60775969469630648644 21340486077154685623 39839824803055621214 36366903345539379161 06551479485270961492 85626573746512997661 24130509549823489045 77079330479770350995"  //76200
"94681118090070021297 06523079606537119334 50837280494746206426 94958626806275925313 74849569037980467236 99504973761600157594 92562886514266441272 84643115531445193471 27275853770487054239 08660148863158506893"  //76400
"12488935111009625462 84757234827047916292 35296026611341578157 89329885317320003597 50423053608631017990 59552250804965951200 11198064697889804622 60648655251846360978 43957545774173732996 29345332477672046039"  //76600
"78054151025600814187 23251082402770818103 96198112909641727907 17390112558683519878 03946190142810556188 52371376168617502930 61818128984748980656 31074093474640159971 37200724921277829698 68222501010638971449"  //76800
"91612258713240649165 24725686455384021031 44697980089168737858 00753684471403583141 69368702422873703893 72346740909119222953 82613309375866966022 34237418413781614701 02952163369855256282 16963641362358529029"  //77000
"28711917953600090561 71028677887016170382 59594399772053878959 34460024625211392103 92285452463187877839 27664618766743457735 89806422259094006357 98787250284098943645 29234829716852533430 11496296700137915252"  //77200
"18318468869570352203 95403048597502785595 38491846853904465429 32676619305324057411 89222477481398942797 35997587414152321981 84013498936861080945 36647969786266723636 50815751449576740114 28803045975244037151"  //77400
"30933151716751929902 54337560714334751858 63401079000824859401 20473116755002981897 93427762881577514718 79652105971008643255 54234658773554278595 07557105296622810332 22758918063658743017 81880075535517580146"  //77600
"77825604586128761371 37695006365870886252 21209440803235895293 67946684345386371621 43958732310101297683 59851751772188502552 72975667970075548564 75874080571531761291 91621271222113247142 00574470952883689528"  //77800
"75932868094636241868 48069676009095824955 43360326150483299015 14596853094926191788 44290179240498085938 95200678951231135621 93422011516672274773 54625235911560892294 93895661482548175391 95640031991354787035"  //78000
"78959408445682512182 92815531558364133227 78411422293185884053 76688381006341577914 48176188464777283053 26919409268954977440 68774643660039552742 69443299831277250056 04457374520048146631 76697591117090698768"  //78200
"01838163840816082278 34075133369794053425 04840034475514726877 66227906834578165994 80495982225301542520 17125988068777047422 88998021002462292605 81583680020773244843 57820913719571713816 39608580391168387844"  //78400
"75151110644713990397 67262201364993361724 14097313010782231868 20232629016054569332 03176922524909576826 14591484979246688659 07187585990598035843 16116118848072140440 66291840686529656209 82027260057892260536"  //78600
"30905835829287249043 80016035720515845584 81523207786745010413 39943337970624451085 84254602778346799817 03931458970605025629 72312068297863725054 72083936336538752688 53611957527239645565 74036526447932875434"  //78800
"60055176289160108071 11345331575471400597 74457290782650059036 88109349264764434612 19108428543619638104 57379054526497797969 69308882359881309077 71900372948968840357 06299598066617399031 94935286726504887256"  //79000
"86765124369639202292 83157489813973602600 63791775463392888099 94471887270268502351 14640862064125964162 09034923730102710578 76636114520104715234 88268096304052715059 09196809551565712142 42923715982714131492"  //79200
"79957764964917243245 80265081285537567167 33549610462422707721 59143546568779691882 73042951145620054808 46308025371749206501 61446863035367932483 62448147627077082855 65501192078334087906 83774476845446637813"  //79400
"28173571532085370042 66742867032058193932 81476977976005761238 99369257267720107420 76916433735747991365 54224386282386424481 77852081715446228289 26353433867257811700 14112283829064140615 07419235536052601628"  //79600
"17605123447550706377 85769887295132736177 66984526432942314690 26536801492859947421 27971914698446471757 15216068045370439224 26024322814376371954 32268079117926263308 08685471250521714691 05044304041671953753"  //79800
"49590039628799469917 45918774634718636471 84394451748769368695 80622852695704889587 19761965471802384965 13082106748358978603 93108886629209530166 91167753246110964953 43386760275435245928 46874922716399779823"  //80000
"24627390985417956629 73213578779655014355 61563724799767398432 74481868322008615115 48147399578453840200 63071941385173178448 61332306870749009778 55292691508108146654 86164441880001378103 73814179019206436668"  //80200
"18636150867174834452 62498945423975134535 98692232887661699354 75833608611648209204 30931643998001289012 73476397554280511210 90855246956980084642 06748150642293086285 38190607322250957202 57582009154744056687"  //80400
"72004260939861018234 58087816345989862141 73157504403797967913 01331783160675141376 98404876662457463372 39216862003098505073 81547940643004944468 59375116884361610329 63173680890904400781 43445971776660226476"  //80600
"34076626043159850429 17079062818210431007 82932116617102069956 22101985439630141623 92027336369748449647 57286423365562651135 90088093863741393103 44266629068439184346 95820525881543817285 31839422173552100891"  //80800
"29476307298235885171 06013139874704416075 69060847629338526791 12853740759886214663 20490850864860814537 14993505007889868809 57176011709034618511 19029559191225377270 71443996741195845329 59210286877783231520"  //81000
"26953817733967378216 85246611878194918920 76956824015806421460 68961509571875125984 73946862816002084955 25295430718926638975 54698388398199651630 49367949992472870343 56900486620950989793 97346116766351421674"  //81200
"74737061746402386997 73312276359970818497 25106600741263377824 88116829572592960196 92581731339848134329 51792106066825622079 81271449856706242672 51518322670329831922 66839251892192700371 67101675396980031536"  //81400
"25107677549826451070 73456159690489338161 38827795722153349812 99581484624171991571 48957789567564070684 56957649054241577011 96312499899605116707 36787250584044290381 77319296539112996062 27529522675611007032"  //81600
"01171099181995295390 54144435831447263786 09250629122610925466 47660316311909078100 76343095969140685655 29714261159542841786 41877590345653533800 49613544092498078528 93409737509531096592 20579378242692006877"  //81800
"66223974439161835769 16679804366210239466 94197941645420779206 07105217501127483876 42640886377267964797 23468272194679744820 35971239193511179682 04645751208267101105 00912729834433992257 98537470543371688903"  //82000
"06359433774159653417 13686466224865219516 95842808208795425943 28073068441139419040 76495238389459766250 57944899147697143742 39412490739800396457 17674909698899648118 22255826886214517636 23564047468917919591"  //82200
"34807382145572662282 25805075265209674639 17303435330197819436 97657717604119785215 04294625197679095057 80664524478394386034 75415695032949024714 76053340484097179165 49484639774277017917 50665517411554948661"  //82400
"25106451593943273377 78333808708763580982 52352713331558776640 26190145165772032707 97606647745402225056 49295834129233621149 49846593398167693193 25373026986142104458 86149981024075248015 48720363180290305228"  //82600
"50406237579853433217 82372577601925290011 37760187820318392005 81631139315765492618 14457130345221618427 41507819940675471690 21028107645426573826 15872379169327528126 15806470917813493478 94896193488069961291"  //82800
"95295500640014419454 22604558007547938783 33755628605047123549 59836017894338489819 31535601664742357010 01588010869134699217 12450660301171218161 14841854763576121178 91862620819202152154 42073924768774512164"  //83000
"12100652178482550403 59095763361884803139 04833303300471040923 15639799467705451866 87015752186713823284 68134767025727772372 02504688455391843286 06234839063396403886 95650764880988720174 67280983375925486255"  //83200
"26060384577727041459 81915467780348238134 87310920413008268076 18687654779591389313 15140302177580972009 06881612868331911682 86459234874015257917 28928205079518142757 26454429179090116885 06880327300204257918"  //83400
"86842751415232128309 35116051435016930888 90564181417902311485 52830008584595765086 22231175774031609863 23774056548131384298 77019387961234993542 83810211627975649580 13165728906342677041 15621530019621655503"  //83600
"23660325481054645801 65404200040321766271 47092267227717531842 02592478047945878833 31361758218498694715 42506840120162820003 37845334057489158701 07956695183736745085 57397467984917258081 04161977587283087542"  //83800
"20300806731723645838 28583300896289399714 92385601459029219536 81506279919470448756 99661690834157049598 33036594419331121582 00292271594034761332 65552125631750847171 58747694539716878333 56137876287714601450"  //84000
"74026446046275982490 18491142411335244408 89393022835466013258 70836006486724912993 60613586525546500757 21546973698622312089 51212403080817303830 78363361801353054487 95854256338266127865 27646862987820318640"  //84200
"37144080887805926163 81913689958427652707 33732946358044350113 63836227919555033387 52204718171458531705 36780844446020671142 06890032288025496560 73916511167332560139 62843994386947021565 48856605231242938173"  //84400
"11131933540356838923 94422198463101439346 79253502276030431332 41434962290930259409 66360752533993297514 13732899641206707805 84816642328313046603 24815975217909554233 20903143199445232969 56420156014142610618"  //84600
"54312327197942730262 34879163925352723662 67880169037511124979 41927868983771886635 10227778718157695084 70168168324700560844 21660904546878932137 00056044773179254662 30764408909482620674 12404002616138679146"  //84800
"38831205985528595614 69850577457680863499 61677542483682024737 30064479658109461240 63520842051436033724 25825760713002994089 95744260375588587561 91413577231252195415 89810006613308672266 73006668225658034621"  //85000
"77739660008956817834 02554685068257164581 92632003814282792527 26121206890291132600 34814554400968034060 18053117441797867577 41178533856301599664 72826810390419318510 76377367674189036632 88037064436214309079"  //85200
"10624019948262393502 17624774220187444547 88504552164318737771 71523380726844925155 37015797110338525560 16085276327770161950 84025342350028967971 65613760839187977689 80971776024189486099 41430722768215810754"  //85400
"17850848992256907571 87657303250494468804 69286904672087089295 54194334474894014925 97269647708136341806 20976730512211071682 18132095862179047420 07580397533920514422 03802037875003594470 18882642524774082131"  //85600
"03078738462915912123 27039859119301841703 91171463675565819174 78183852135205367540 13363015533674483224 58848579356800175894 89268152679169147251 57783025563795448128 56594571649166992477 29696725847287917541"  //85800
"55382615012806631310 99428392983841489829 55930872016232265040 79549731915220221087 27816787050799481464 03238466414746432000 57103756699722719320 16195519330607314779 46918386194457215859 78541430676521198863"  //86000
"28841201657060156533 82701963087197539497 74207835687885430823 54119133408995054108 49273226946124267726 13918607977639244661 01349027034299289031 67169804484344052548 11913205085330758082 42655620702096365417"  //86200
"03989731207782531097 24727251993673203420 43847159364411967034 65166886955524518523 75073038168394740356 59599701355104992653 73747453830772872215 27906681723463982558 51360197482568980566 98348951719931688542"  //86400
"39730330441792034561 10435748833430308005 77547133643168166692 56952556180635810034 41332844981300120391 37887173397139523695 67917402947096927464 20576924563670471705 33039102668337903351 82912084713278034303"  //86600
"76070666977797241904 27470109555917413524 76430758951395673061 45254403805208014779 31615533228989745674 11187971168743822442 42666656866131747477 16554763264534230400 94099589173109888162 77404210427018812994"  //86800
"09494123583599109535 52570871908422572835 28158045580083192194 17585295809782422124 43381687005959871048 71066434953059699372 72758065091604466531 66801347440317340592 12700944517022299297 78605007342315984281"  //87000
"43477037254754050364 64092077443608484115 45291898069285219131 42589109077328253794 08623534185382088601 91216535184282053834 86249863897584744903 89419554444030534661 15926499502074985380 08611183681484136650"  //87200
"41086842798846372231 70288180884017424939 86644639594400804936 93681262010099216898 89649862662665984916 62130621628819755746 93566290684211333591 13565542147962535024 83099880633268597999 46906552943009714585"  //87400
"37551658590524232762 14283427270867069003 05332952886949894187 71152505982396456771 76698632582946567489 25966770059861532115 58588604572680232986 91019759683639676199 45674106495569576442 62259827323606671654"  //87600
"86689355548034519691 90919617296970388773 85552200311237871934 63152551574005428944 58691419148005117900 94967050225927973010 65561716636201731508 57285472233274925096 66306348728258209441 84736502209841829518"  //87800
"42425510709611049108 92271021765104379723 78149407246209955970 52710062231230809637 76795809870351121557 03922189228491378784 72299182300616632096 19464334155487091302 79605373862088394490 81355215250201846960"  //88000
"33104063395118722909 22964973906248725269 30273792307925338556 93936150579649306556 74764110849382416385 06232379551701032726 03147779152026963710 23636399038669120807 24381026780261009405 38003705847870784034"  //88200
"26127210762500364220 63067255795630970527 05834391141184304784 29890201166134671076 92000849963702986805 30158204045477838255 29395537420100383775 54042049534356514849 53359829763249746939 34359983499361970018"  //88400
"54446101856753790525 14392980089359676932 40507422640942674837 78737055102242710350 54298510080457362200 19026107788747224579 00967495261278909816 76385820012125985253 35684040194872181517 74777276146717909398"  //88600
"89609031725181164108 70613380596822182495 62994974543034328842 31290367611052873534 35895855739149630530 81797221274092661904 88361025533165378263 55922055881009707856 73575899443091753865 67902191407280465654"  //88800
"21281398711160033023 38856510939290584288 94063216322119320973 71175150273730696862 34624349717278299166 11000883291788652816 30173368941045458966 22119262156841449579 57476687228771141344 66218995513252477612"  //89000
"89880105601072535399 09260624351786083928 65662993925162238466 07009823265431502733 69533842750108995204 12145350902850972588 15087098252733090676 39045717821340752530 05788056183181045180 27487457896609242783"  //89200
"46394278413708519835 30364210347322164290 58368264371633497150 10397948688586526010 68853120829439350701 74126890924323508564 62515229179456875442 18347871099957025444 75147110872642661601 79839987352591817426"  //89400
"72226204197821280333 38583036398835017938 64338986093798422514 76092617926869354799 74500596999277495453 43992664997155369830 09255300777701430942 91242097391012893928 16555660427413572890 08684689034478180106"  //89600
"61329200052959751106 65932838580317451591 53761456865605711824 45311116459004050143 05691912713260519439 73103810781120640397 11273419295777679745 14285927556846740600 59626644834804468949 37950602538994569093"  //89800
"32253195963482807316 70904056138585033032 51358294794437254348 78054194305035703176 52867681329187796435 69716028422791992871 66815984847329078456 57554618794384696713 31322033627773127288 57497736634483117943"  //90000
"63872891946722752025 17122181061969424919 03622855505697720266 85660770408678236000 85476733048453973465 00728634811887747844 70740193234287578264 68205192157389958205 03073173243344120978 95511080757041785718"  //90200
"e-60200"
;
#endif

#if nBCD_DSIZE > 90000
static char* ln10_txt4 =
"4.3824173598075262055 02053009372799354318 90499668591924305229 93380032905024899061 68425305958544383239 68174801126684808103 72526556418864605492 99852536806677663094 83541270881119268693 35193333765368443876"  //90400
"97331462195635549301 28706992828635193828 43752886117116975499 28412587607192121562 52598820057264477768 40599873200533679227 60961089173029046227 14659472753859918741 82354991443386087073 98488412949160573675"  //90600
"87103926262784894246 77755268930073158293 25829439183701576804 21294945367020098055 97222061792536533430 09862844894958755928 30168315770970945136 85070105362546589409 61890557926482636985 84839418437101394028"  //90800
"24360794580748599202 82013680337409870280 98452227575072401573 90777037489826931439 06763448159114521624 36976069196462672920 59760740432107418587 22552015333386615110 39167786110979587743 49465021034930247393"  //91000
"09615699533325095514 95913727799505213781 75794315591685950600 10565508424141684069 36884541330056790991 57025993334361005644 28860440410499213174 68107660276579111745 58203937190184779504 99915389093711817607"  //91200
"09486876595502501637 37851084590081457223 07515666998631512513 50213873895970992006 04389582469883072107 73290314344544928504 41390306930132805272 87914899115158918988 01800693726608916935 95103519837110885782"  //91400
"02095204523479236034 53296047413026787747 08113534479192130958 23115188833991744757 71804488032652968684 98165150187118785831 67471183742115035072 75800744687974889234 76096190229519441326 20749963607634904912"  //91600
"66747937125210604115 49806080902329057796 23990582267815076324 66311831419595118078 15237112000817399457 84763933196075978204 31738801361941497044 18041036935599103156 94700742138416800415 18341994360749869771"  //91800
"00331618041019114542 03248126637411817953 29271163315414872340 95723418243588825749 66738885755820319005 30349242351951175786 65160547089987467561 99600703358079479607 88644861434434621139 48545456419622737116"  //92000
"61196920846130412063 49254049839847785154 98719767769930879493 58547568820756375546 78790376634354102275 71445175374885177259 68976266729986771083 88089470822677104835 53067367338748628104 59489062152254865105"  //92200
"61242476157935975330 99453633399250764722 11847128046827702575 13349097560596192652 42020744914044567732 08194399065564156819 50145327234958921600 77620935989512443327 12061430404311300777 55312017157398410150"  //92400
"55702848307822417853 31235282948093092692 67007244909063187135 81002178378655978891 83744472078198982625 39866863064311225590 37726316096107027507 68066902977412506040 76023602866560773869 79621081315667717453"  //92600
"12152425688444682944 57542902594298205294 86020507720022273256 14150431779394875683 97602971811829715822 77874553653749543120 21405770272030838596 65829113686907856163 11953208015593570703 56122446098989958126"  //92800
"76494016327028702092 32874250126153232309 77209543975909188872 84444632817117879899 35299198137210613267 93339384748230209056 24335476042278427427 86227688018819797380 56253520894962164005 38250385895894173884"  //93000
"64089616887273916687 04671706363092895367 37252826232306958877 46750869053934247058 67516122064454979591 94559614739226290202 80880451469860473186 16215387910324757978 58031257829683697291 41810148337327305298"  //93200
"20346345784070723019 41304247325094769824 86828275516193215342 78476732323071797150 15251275625512555051 01804138895545992428 78141798171325409246 08129861096691309419 55309155074741088761 55626902848129581049"  //93400
"56185014838925849234 50788384746313037587 33071437587797243475 49612447373955928635 33202487781334284733 75668902831702447154 26954171774870436325 48962419088571353671 20085951243164110367 53017500461149586361"  //93600
"30273533136163414976 05402261749038091042 77622037427283838418 58715998125300723897 51668516565309931006 32071255613585746259 38959269965845491174 03515517235103970067 80013269741946887976 18942206315942955434"  //93800
"89217069994479417009 95608938121794879493 91961617682648096314 17234339357270980176 15122021274669681413 45519419140209614964 18196538456468842511 17512936790258303198 01839744126435087538 64344297214825623168"  //94000
"79279622021876776642 13012677398263187691 39927441568595474707 39064524271482827959 35545864309191578925 71390829794872068369 39684833927680363240 46531236991129362424 52524616792003761967 52600957922311663752"  //94200
"59430005703789245548 64625754751178006765 84644082760326742093 68222670529170725085 55464421915912195591 65821736169109353549 82795829360845114113 72544965918937457753 66545771478213446488 84240320833447461829"  //94400
"02827406635170641002 19689967274430426447 36518576972771395434 16461488859248148389 14679503060363632015 50349953582779140757 50839667811716409768 43430467698545854978 55813862475356282706 44126033070741110793"  //94600
"51419219692376290532 85330454992054052775 42453030157387689839 03692069769355354035 28080771114421113933 57692099215730831792 44375661409649158924 68276622506941983542 34156750903179569284 49262295204863253630"  //94800
"68239353428920961945 71918935316551676266 27439877214527188403 41976981223428731883 60139997020785153736 82221522700034028087 53141173944042079479 25704898873218915650 92495287193788380210 39201537299213212148"  //95000
"25427095570743772905 16875747804986534058 32495790974969794593 70591433356636041030 07146226860925913581 23913565347000315339 12313387977032122455 09314635816776029349 62414071482197646561 44417298176518086522"  //95200
"60389768935634898433 89153933207418713937 03781022495695441324 11886259281317982538 50903765263446717069 75140396192497407724 10012025012079096632 90088015919106813777 89489449245508230781 64093403921341388524"  //95400
"80529165689318328873 17065431580098244686 92783721643472152757 44692919497175070815 23090265958678073471 66663717362802266446 00974319852106810318 42084069143140209945 43148177187146309646 11875068969673103713"  //95600
"37613052141768906713 06403000303424730756 03576486806936418192 56204820479266604804 73341752085034006421 37019950486564505603 82472775834978570021 57052133142903616776 82419266419575028598 03591787712573318395"  //95800
"30927733405818882487 72939849092725044816 40824234800579777395 80878918313718358226 55058840939079869943 87000948872598590558 50528436409865710253 51368451188326624944 94438253032858641411 41424980224332730344"  //96000
"22944146492378560240 26951476121319662668 54608649264662943884 91860027977366771623 76134178968553745834 49102650396959583036 08399129917331766491 23362538289094843925 95050990519112752433 45669758492906471335"  //96200
"74656884243713070660 15808362981019573462 75495114870955457125 91678186941878666248 86248107734894421352 54562516996924307359 67931191300573812092 46435193046311637329 81720561653646523167 57001287653529604448"  //96400
"08233584185369687670 04086078519780872935 14534579684758469679 53574680603373951354 21990216071614284208 97085445655146225054 36526641039326198895 93924302193914094075 63739568844204111601 37222293157197664696"  //96600
"58367197599402970061 12553932950972120058 13965389839731031958 16130799756331332534 51347546655031635266 09752526534352854854 36893100994403501129 50768364737965583966 07054211070385971901 47501448033457167287"  //96800
"53743753757553774683 56828733664103858739 83452509569018987121 44958402059546086999 00120457065423380575 51926265113642486590 97632029842878783661 24733605795885776145 74616545952404207865 69559435434383292463"  //97000
"09888997200158312549 54773842110781259010 35712336802046045061 36283475365380418567 56168599375678896493 87317202765823829458 16849107214166251132 07956659485596628064 83227741003697010695 23033001070765895089"  //97200
"47564598555071734608 27935131547111964377 59055123389224717958 49352278429689896326 70526737515078197103 17041305714954326114 48631784314782309687 33555830317019309156 12010194815923673841 92137526957666372086"  //97400
"12569893928129244491 68605401705341334954 17144378983859172081 60254352302543512263 27934351260445189702 25857865319104193611 61926768984058749490 26794263429764549507 87626671047632059740 93395987161947102926"  //97600
"04900102245515394310 70298949610780676383 00090907400038200531 80046403317296068838 97315942000402662364 59127068002118909211 96820405446721536438 27362153496936597844 57308247174692541729 71751150619723082645"  //97800
"41559995876151101854 42463870422851763918 96298249497925382098 30319671001870330985 75866701826606599656 66494236327092643662 71657169557634202861 20595062525027243735 95863569449311164260 70177123188082445763"  //98000
"03708414438343987953 89742741018687075255 83368964756335334355 55390193283649610273 67531965407967667496 05577540194263329922 77770785119049791391 60970371172029321592 46239766685922836218 80784815916676011006"  //98200
"08853717341596717797 66326600537271901635 14154058631048368407 51216740408099218686 11136276766355092382 36399923416508341673 88714529237148570345 44211467647281917703 41414427445959949636 60238444274785169323"  //98400
"55183593764069157470 52269466413093262776 81515137653570497080 32608137555341486677 31425605920323897496 01706230532235623045 66119906364265262419 18816860052327421537 86961574553480574070 68803017146632129430"  //98600
"19677603414701868804 52854650406166723255 99912415735315888336 70068804326271021788 20763754359645866140 93755619291370534831 12079674414079695560 29022530454289548965 39005312145062138881 59562908521564183471"  //98800
"52028732849655829252 59022670551904095059 15572582949972111336 97489578065562312015 01441497018715106052 12337759866162500288 73447892962594684315 73846790329132970394 64703982964588042297 96970938845362545640"  //99000
"17068247842665813915 40651952641317704826 25527172225471700369 75959614680143432971 74891528516972497394 21117469539494780499 82597308119629839667 12628482111051278370 39270393086110623170 96169832781947582432"  //99200
"53134498157915014038 70076858435168385848 14844787929264215844 48484188729394536883 22681179922169290155 98460114026496701154 43802149267331066589 18827678496216151059 35246175798857782674 83019846602734132424"  //99400
"76837663231423040005 09526362757456817967 51261801257634466518 01229952287323758735 64399452848521520505 29798880462929493245 93473823872391784329 00760769288846099344 35190038310565474473 40537669465260750754"  //99600
"41678823802997606228 51201930073049193430 00420794261294703772 61004191110839509453 39330048194550376861 14860297426320931324 41005282646793559388 61243976532591933700 65711737679744386650 01031579112605365835"  //99800
"08623928036309450369 88335607404477568597 84302718130861174734 23759628509725158068 38394167884177251500 18973959468005034212 57807492663718138062 48227632411237932970 85324871940318206190 69713446458057204866"  //100000
"67644243225422642663 87459196551158727396 99218597211981869162 37347144592317359430 62632077506670179881 21125821158356863187 27523496355349183175 40483949838990742108 64563773754708747226 14247600301872410680"  //100200
"e-90200"
;
#endif
