// =============================================================================
// =============================================================================
// BCDZCu(32bitCPU, Cp) e[u
// BCD calculation library (32bitCPU, C language) Table
//											(c)2025 }CRZ@Vc 
//											(c)2025 Maikon - Giken  Akira Sawada
// Release 1.10  2025/12/15
// =============================================================================
// =============================================================================

// =============================================================================
// ŏL`FbN
// =============================================================================
#define nBCD_MIN_SIGNIF			(12)							// ŏL
#if		nBCD_NUM_SIGNIF < nBCD_MIN_SIGNIF
#undef	nBCD_NUM_SIGNIF
#define nBCD_NUM_SIGNIF			nBCD_MIN_SIGNIF
#endif

// =============================================================================
// gxe[u
// =============================================================================
#define BCD_TBL_SIGNIF(n)	( ((n) < 100)? 5 : \
							( ((n) < 1000)? 6 : \
							( ((n) < 10000)? 7 : \
							( ((n) < 100000)? 8 : \
							( ((n) < 1000000)? 9 : \
							( ((n) < 10000000)? 10 : \
							( ((n) < 100000000)? 11 : 12) ))))))

#ifndef BCD_BASIC_FUNC
// =============================================================================
// ߎ֐[v
// =============================================================================
#ifndef BCD_NO_EVALUATION
#define nBCD_EVA_LOOP		(func_loop_num)
#else
#define nBCD_EVA_LOOP		(0)
#endif

#define BCD_TBL_SIN(n)		( (nBCD_EVA_LOOP > 0)? nBCD_EVA_LOOP : \
							  ((n) <=     18)?    10 : \
							  ((n) <=     24)?    12 : \
							  ((n) <=     30)?    14 : \
							  ((n) <=     54)?    21 : \
							  ((n) <=     72)?    26 : \
							  ((n) <=    100)?    35 : \
							  ((n) <=    150)?    49 : \
							  ((n) <=    200)?    60 : \
							  ((n) <=    300)?    82 : \
							  ((n) <=    500)?   125 : \
							  ((n) <=    700)?   165 : \
							  ((n) <=   1000)?   220 : \
							  ((n) <=   1500)?   310 : \
							  ((n) <=   2000)?   395 : \
							  ((n) <=   3000)?   560 : \
							  ((n) <=   5000)?   865 : \
							  ((n) <=   7000)?  1160 : \
							  ((n) <=  10000)?  1580 : \
							  ((n) <=  15000)?  2260 : \
							  ((n) <=  20000)?  2920 : \
							  ((n) <=  30000)?  4180 : \
							  ((n) <=  50000)?  6600 : \
							  ((n) <=  70000)?  8930 : \
							  ((n) <= 100000)? 12320 : 13000)

#define BCD_TBL_COS(n)		( (nBCD_EVA_LOOP > 0)? nBCD_EVA_LOOP : \
							  ((n) <=     18)?    10 : \
							  ((n) <=     24)?    12 : \
							  ((n) <=     30)?    14 : \
							  ((n) <=     54)?    21 : \
							  ((n) <=     72)?    26 : \
							  ((n) <=    100)?    35 : \
							  ((n) <=    150)?    49 : \
							  ((n) <=    200)?    60 : \
							  ((n) <=    300)?    82 : \
							  ((n) <=    500)?   125 : \
							  ((n) <=    700)?   165 : \
							  ((n) <=   1000)?   220 : \
							  ((n) <=   1500)?   310 : \
							  ((n) <=   2000)?   395 : \
							  ((n) <=   3000)?   560 : \
							  ((n) <=   5000)?   865 : \
							  ((n) <=   7000)?  1160 : \
							  ((n) <=  10000)?  1580 : \
							  ((n) <=  15000)?  2260 : \
							  ((n) <=  20000)?  2920 : \
							  ((n) <=  30000)?  4180 : \
							  ((n) <=  50000)?  6600 : \
							  ((n) <=  70000)?  8930 : \
							  ((n) <= 100000)? 12320 : 13000)

#define BCD_TBL_ASIN(n)		( (nBCD_EVA_LOOP > 0)? nBCD_EVA_LOOP : \
							  ((n) <=     18)?    34 : \
							  ((n) <=     24)?    42 : \
							  ((n) <=     30)?    53 : \
							  ((n) <=     54)?    93 : \
							  ((n) <=     72)?   120 : \
							  ((n) <=    100)?   170 : \
							  ((n) <=    150)?   260 : \
							  ((n) <=    200)?   345 : \
							  ((n) <=    300)?   510 : \
							  ((n) <=    500)?   840 : \
							  ((n) <=    700)?  1170 : \
							  ((n) <=   1000)?  1670 : \
							  ((n) <=   1500)?  2500 : \
							  ((n) <=   2000)?  3330 : \
							  ((n) <=   3000)?  4990 : \
							  ((n) <=   5000)?  8310 : \
							  ((n) <=   7000)? 11630 : \
							  ((n) <=  10000)? 16620 : \
							  ((n) <=  15000)? 24920 : \
							  ((n) <=  20000)? 33230 : \
							  ((n) <=  30000)? 49850 : \
							  ((n) <=  50000)? 83100 : \
							  ((n) <=  70000)?116300 : \
							  ((n) <= 100000)?166200 : 168000)

#define BCD_TBL_EXP(n)		( (nBCD_EVA_LOOP > 0)? nBCD_EVA_LOOP : \
							  ((n) <=     18)?    20 : \
							  ((n) <=     24)?    24 : \
							  ((n) <=     30)?    27 : \
							  ((n) <=     54)?    41 : \
							  ((n) <=     72)?    50 : \
							  ((n) <=    100)?    65 : \
							  ((n) <=    150)?    90 : \
							  ((n) <=    200)?   112 : \
							  ((n) <=    300)?   155 : \
							  ((n) <=    500)?   230 : \
							  ((n) <=    700)?   305 : \
							  ((n) <=   1000)?   410 : \
							  ((n) <=   1500)?   580 : \
							  ((n) <=   2000)?   740 : \
							  ((n) <=   3000)?  1050 : \
							  ((n) <=   5000)?  1630 : \
							  ((n) <=   7000)?  2190 : \
							  ((n) <=  10000)?  3000 : \
							  ((n) <=  15000)?  4300 : \
							  ((n) <=  20000)?  5560 : \
							  ((n) <=  30000)?  7980 : \
							  ((n) <=  50000)? 12620 : \
							  ((n) <=  70000)? 17090 : \
							  ((n) <= 100000)? 23600 : 24000)

#define BCD_TBL_LOGE(n)		( (nBCD_EVA_LOOP > 0)? nBCD_EVA_LOOP : \
							  ((n) <=     18)?     9 : \
							  ((n) <=     24)?    12 : \
							  ((n) <=     30)?    14 : \
							  ((n) <=     54)?    24 : \
							  ((n) <=     72)?    32 : \
							  ((n) <=    100)?    45 : \
							  ((n) <=    150)?    67 : \
							  ((n) <=    200)?    88 : \
							  ((n) <=    300)?   130 : \
							  ((n) <=    500)?   215 : \
							  ((n) <=    700)?   295 : \
							  ((n) <=   1000)?   420 : \
							  ((n) <=   1500)?   635 : \
							  ((n) <=   2000)?   850 : \
							  ((n) <=   3000)?  1260 : \
							  ((n) <=   5000)?  2090 : \
							  ((n) <=   7000)?  2920 : \
							  ((n) <=  10000)?  4160 : \
							  ((n) <=  15000)?  6240 : \
							  ((n) <=  20000)?  8320 : \
							  ((n) <=  30000)? 12470 : \
							  ((n) <=  50000)? 20780 : \
							  ((n) <=  70000)? 29080 : \
							  ((n) <= 100000)? 41550 : 42000)

#endif	/* BCD_BASIC_FUNC */
