// =============================================================================
//	Copyright 2025 Maikon-Giken
// =============================================================================
#include "all_define.h"

// =============================================================================
// =============================================================================
// 1.v@X^[gAbv
// =============================================================================
// =============================================================================
// AvNƂɈԍŏɎŝWinMain֐łB
// WinMainł͎̂ƂsB
//	(1)CʂCreateWindow APIɂ쐬B
//	(2)Windows烁bZ[WL[ɑĂbZ[WEChEEvV[
//     W֐֓]B
//	   : Windows璼ڃEChEEvV[W֐֑郁bZ[Ŵ,
//         WinMain̒ŃbZ[WȂB
//         L[ւ̑t"|Xg", ڑt"Zh"ƌĂѕB
//  (3)IbZ[W(WM_QUIT)󂯎AvIB
// =============================================================================
int WINAPI WinMain(HINSTANCE hInstance,			//ݽݽ (۾ID)
                   HINSTANCE hPrevInstance,		//۸т̍ŐVݽݽ
                   LPSTR  lpszCmdParam,			//ײ݈ւ߲
                   int    nCmdShow)				//\@
{
	HWND		hwnd;
	MSG			msg;
	WNDCLASS	wndclass;
	
	//==========================================================================
	// 1.1 Cʂ̐
	//==========================================================================
	//   CreateWindow APIŉʂ𐶐ɂ, ܂ʂ̊{I߂"EC
	// hENX"o^Ȃ΂ȂȂB
	// (1)WNDCLASS\̂Ɋe푮B
	// (2)RegisterClass APIɂNXo^sB
	//   :ۂɂ, ANSIR[hgpꍇ RegisterClassExA, Unicodegp
	//      ꍇ RegisterClassExW RpCɂĎIB
	//==========================================================================
	wndclass.lpszClassName = szAppName;		//NX:ʂɃAv̖Ogp
	wndclass.lpfnWndProc = WndProc;			//EChEEvV[W֐
	wndclass.hInstance = hInstance;			//{֐ɓnꂽl̂܂܎g
	wndclass.cbClsExtra = 0;				//NX\ ǉ̈
	wndclass.cbWndExtra = 0;				//EChE\ ǉ̈
	wndclass.style = CS_HREDRAW | CS_VREDRAW;		//H,VTCYύXɂĕ`w
	wndclass.hIcon = LoadIcon(NULL,IDI_APPLICATION);//ACRw
	wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);	//}EXEJ[\w
	wndclass.lpszMenuName = NULL;					//j[

	//wiF̐ݒ, GetStockObject APIŃXgbNuVw肷鎟̋Lq
	//wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
	//ʓI炵B{vO̓VXeJ[gpÂLqsB
	//:+1WNDCLASSŎgꍇ̂܂Ȃ
	wndclass.hbrBackground = (HBRUSH) (COLOR_BTNFACE +1);
							//COLOR_BTNFACE:_CAOE{bNX̔wiF
							//COLOR_WINDOW :EChE̔wiF

	//NXo^ (o^ɎsAvI)
	if (!RegisterClass(&wndclass)) {
		MessageBox(NULL, "Few resource or Wrong coding", szAppName, MB_ICONERROR);
		return 0;
	}


	//==========================================================================
	// 1.2 Cʂ̐
	//==========================================================================
	// (1)CreateWindow APIɂ萶B
	//    :ۂɂ, ANSIR[hgpꍇ CreateWindowA, Unicodegp
	//       ꍇ CreateWindowW RpCɂĎIB
	// (2)Show Window, UpdateWindow API@ɂۂɉʏɕ\B
	//==========================================================================
	hwnd = CreateWindow (
		szAppName,					//NX
		APP_TITLE,					//^Cgo[
		WS_OVERLAPPEDWINDOW | WS_VSCROLL | WS_HSCROLL,	//X^C
		CW_USEDEFAULT,				//wW l
		CW_USEDEFAULT,				//xW l
		CW_USEDEFAULT,				//̏l
		CW_USEDEFAULT,				//̏l
        NULL,						//eEChẼnh
        NULL,						//EChEj[̃nh
        hInstance,
        NULL);						//쐬

	ShowWindow(hwnd, nCmdShow);		//EChE̕\Ԃݒ(͎擾)
	UpdateWindow(hwnd);				//NCAg`w


	//==========================================================================
	// 1.3 bZ[W̓]
	//==========================================================================
	// (1)GetMessage APIŃL[烁bZ[WoBIbZ[W(WM_QUIT)
	//    oꍇ͖߂l0ƂȂ邽, AvI
	// (2)V[gJbgL[Ȃǂ̓ꏈȂꍇ, TranslateMessage APIɂ
	//    L[Ԃ𕶎R[hɕϊ,R[hEbZ[W(WM_CHAR)|X
	//    gĂ炤B
	// (3)DispatchMessage API ɂEChEEvV[WփbZ[W]
	//    BvV[WŏIȂƖ߂ĂȂB
	//==========================================================================
	while(GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		}
	return msg.wParam;
}


// =============================================================================
// =============================================================================
// 2.EChEEvV[W
// =============================================================================
// =============================================================================
// Windows璼ڑĂbZ[WWinMain֐]Ăb
// Z[WB
// {֐, bZ[W̎ނd, Ή֐ĂяoĂ邾łB
// =============================================================================
LRESULT CALLBACK WndProc(HWND hwnd, UINT message,
                         WPARAM wParam, LPARAM lParam)
{
	switch(message) {
		case WM_COMMAND: proc_command(hwnd, message, wParam, lParam); break;
		case WM_PAINT:   proc_paint(hwnd, message, wParam, lParam);   break;
		case WM_SIZE:    proc_size(hwnd,  message, wParam, lParam);   break;
		case WM_VSCROLL: proc_vscroll(hwnd, message, wParam, lParam); break;
		case WM_HSCROLL: proc_hscroll(hwnd, message, wParam, lParam); break;
		case WM_CREATE:  proc_create(hwnd, message, wParam, lParam);  break;
		case WM_DESTROY: proc_destroy(hwnd, message, wParam, lParam); break;
		//case WM_CHAR: proc_char(hwnd, message, wParam, lParam); break;
		//case WM_LBUTTONUP:
		//case WM_LBUTTONDOWN:
		//case WM_MOVE: proc_move(hwnd, message, wParam, lParam); break;
		default:         return DefWindowProc(hwnd, message, wParam, lParam);
	}
	return 0;
}


// =============================================================================
// =============================================================================
// 2.1 {bZ[W@o`hms (WM_PAINT)
// =============================================================================
// =============================================================================
// WM_PAINT, ʂ̍ĕ`悪KvɂȂƂɑĂB
// ʂ, ̎菇ōĕ`sB
// (1)BeginPaint APIŃfoCXReLXg擾BfoCXReLXgƂ, 
//    ł͕fBXvCт̃hCȍB
// (2)Avɉʍĕ`sB
// (3)EndPaint APIŃfoCXReLXgB
//
// {vOł, \ɕKvȏ̕ϐɏW񂵂Ă(wb_[Œ`)B
//   EsDef\: \ʒu\@, 萔߂\
//   Efpnumz : \鐔li[z
//   Efparaz : \镶i[z
// {֐ł, sDef\̂̒, "DrawText APIɂ镶\", "DrawEdge API
// g\" w肳Ă鍀ڂɂčĕ`sB
//
// :DrawText̐\JnW̏ꍇ,DrawText̑Ώۗ̈悪SďB
//    XN[̏ꍇɖ肪oB̒mł͉s\B
//    Ȃ,\JnW͕łĂ̈敪͕\, ͂ȂB
// =============================================================================
int proc_paint(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int		i, lan;
	char	wk[50];
	HDC		hdc;
	RECT	rect;
	PAINTSTRUCT ps;

	// =========================================================================
	// 2.1.1 `揀
	// =========================================================================
	hdc = BeginPaint(hwnd, &ps);


	// =========================================================================
	// 2.1.2 Avˑ̍ĕ`
	// =========================================================================

	//F, wiFݒ(ʐ݌vɈˑ)
	SetTextColor(hdc, GetSysColor(COLOR_BTNTEXT));
	SetBkColor(hdc, GetSysColor(COLOR_BTNFACE));

	//p[^[JϐɊi[(vǑʂǂ邽)
	//:{vO͕\I{^Ő؂芷B
	lan = fpnum[kNUM_LAN];

	//\ڂ`\sDef̎wɉ
	for (i = 0; i < nCHILD; i++) {

		//{֐ł̏ΏۍڂɂĂ, \W̕ϊsB
		switch (sDef[i].type) {
			case DCC_textM:
			case DCC_textS:
			case DCC_textD:
			case DCC_textX:
			case DCC_edge:
				proc_rect(&rect, &sDef[i].pos);	//Wϊ(2.1.4Q)
				break;
			default:
				rect.left = -1;							//\ΏۊO
				break;
		}

		//{֐ł̏ΏۍڂƂ, `sB
		if (rect.left >= 0) {
			switch (sDef[i].type) {

				//sDefɊi[Ă镶萔() DrawText APIŕ`B
				case DCC_textM: DrawText(hdc, sDef[i].mess[lan], -1, &rect, sDef[i].style);
								break;
				//fpara DrawText APIŕ`B
				case DCC_textS: DrawText(hdc, fpara[sDef[i].para], -1, &rect, sDef[i].style);
								break;
				//l10iɕϊ DrawText APIŕ`B
				case DCC_textD: sprintf_s(wk, sizeof wk, "%d", fpnum[sDef[i].para]);
								DrawText(hdc, wk, -1, &rect, sDef[i].style);
								break;
				//l16iɕϊ DrawText APIŕ`B
				case DCC_textX: sprintf_s(wk, sizeof wk, "%#x", fpnum[sDef[i].para]);
								DrawText(hdc, wk, -1, &rect, sDef[i].style);
								break;
				//g,̈Ȃǂ DrawEdge APIŕ`B
				case DCC_edge:  DrawEdge(hdc, &rect, sDef[i].style, sDef[i].flag);
								break;
			}
		}
	}

	// =========================================================================
	// 2.1.3 `I
	// =========================================================================
	EndPaint(hwnd, &ps);
	return 0;
}


// ====================================================
// ====================================================
// 2.1.4 WϊTu֐
// ====================================================
// ====================================================
// E{vOł, ̑傫x0.1PʂƂW
//   nŉʈʒu`ĂB
// E{֐ɂeAPIŎg_Wւ̕ϊsB
// Ȇ傫, WM_CREATȄ̒ŃO[o
//   cxChar(), cyChar()Ɋi[B
// EXN[ɂ錴_ړ̊Ǘ,̑傫P
//   ōsȂ, O[oϐiHpos(x), iVpos(y)
//   Ɍ_ʒui[B
// ====================================================
void proc_rect(RECT *p, RECT *q) {
	int	x, y;

	x = iHpos * cxChar;
	y = iVpos * cyChar;
	p->left   = (q->left   * cxChar) / 10 + x;
	p->right  = (q->right  * cxChar) / 10 + x;
	p->top	  = (q->top    * cyChar) / 10 + y;
	p->bottom = (q->bottom * cyChar) / 10 + y;

	return;
}


// =============================================================================
// =============================================================================
// 2.2 {bZ[W@rhyd (WM_SIZE)
// =============================================================================
// =============================================================================
// WM_SIZE, ʂ̃TCYύXꂽƂɑĂB
//
// {vOł, ̏sB
// EVȉʃTCY擾
// EXN[(_ǗϐiVpos, iHpos)ŃTCYg傳ꂽꍇ, K
//   ȃXN[ԂɒsB
// ESetScrollInfo APIɂXN[Eo[ɐVȔ͈͂ݒ肷B
// =============================================================================
int proc_size(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int		cxClient, cyClient, i, j;
	SCROLLINFO	si;

	//--------------------------------------------
	// 2.2.1 TCY̎擾(,sZ)
	//--------------------------------------------
	cxClient = LOWORD(lParam) / cxChar;
	cyClient = HIWORD(lParam) / cyChar;

	//--------------------------------------------
	// 2.2.2 XN[
	//--------------------------------------------
	// XN[
	j = 0;
	if (iVpos < 0) {							//XN[(_)ɂ,
		i = iVpos + nVsize / 10;					//ő`s(̍̕s)
		if (cyClient > i)  {						//NCAgs傫Ȃ
			i = cyClient - i;								//Vɐ\\͈͂vZ,
			if (i > -iVpos) i = -iVpos;						//XN[͈͓ɐ
			ScrollWindow(hwnd, 0, i * cyChar, NULL, NULL);	//ScrollWindow APIɂXN[B
			iVpos += i;										//_ǗϐXVB
			j = 1;											//XN[ƂtOĂB
		}
	}
	// XN[
	if (iHpos < 0) {							//XN[(_)ɂ,
		i = iHpos + nHsize / 10;					//ő`挅(̌̕)
		if (cxClient > i)  {						//NCAg傫Ȃ
			i = cxClient - i;								//Vɐ\\͈͂vZ,
			if (i > -iHpos) i = -iHpos;						//XN[͈͓ɐ
			ScrollWindow(hwnd, i * cxChar, 0, NULL, NULL);	//ScrollWindow APIɂXN[B
			iHpos += i;										//_ǗϐXVB
			j = 1;											//XN[ƂtOĂB
		}
	}
	if (j) InvalidateRect(hwnd, NULL, TRUE);	//ĕ`w

	//-------------------------
	// 2.2.3 XN[Eo[͈͐ݒ
	//-------------------------
	// XN[Eo[ݒ
	si.cbSize = sizeof(si);
	si.fMask = SIF_RANGE | SIF_PAGE;
	si.nMin = 0;
	si.nMax = nVsize / 10;
	si.nPage = cyClient;
	SetScrollInfo(hwnd, SB_VERT, &si, TRUE);

	// XN[Eo[ݒ
	si.cbSize = sizeof(si);
	si.fMask = SIF_RANGE | SIF_PAGE;
	si.nMin = 0;
	si.nMax = nHsize / 10;
	si.nPage = cxClient;
	SetScrollInfo(hwnd, SB_HORZ, &si, TRUE);

	return 0;
}


// =============================================================================
// =============================================================================
// 2.3 {bZ[W@urbqnkk (WM_VSCROLL)
// =============================================================================
// =============================================================================
// WM_VSCROLL, XN[Eo[삳ꂽƂɑĂB
// wParamɋ̓Iȑ삪i[Ă̂, ɊÂăXN[Eo[
// ̈ʒuZo, SetScrollInfo APIŃo[ʒuύX, ScrollWindow APIŃXN[
// {B
//
// {֐ł, ̑傫ɂsPʂŃXN[sƋ, XN
// [ɂĈړ_ʒuO[oϐiVpos Ɋi[B
// =============================================================================
int proc_vscroll(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int	i;
	SCROLLINFO	si;

	// ړÕo[̃|WV[Jϐiɕۑ
	si.cbSize = sizeof(si);
	si.fMask = SIF_ALL;
	GetScrollInfo(hwnd, SB_VERT, &si);
	i = si.nPos;

	// eɉăo[̃|WV肷B
	switch (LOWORD(wParam)) {
		case SB_TOP:        si.nPos = si.nMin;	break;
		case SB_BOTTOM:     si.nPos = si.nMax;	break;
		case SB_LINEUP:     si.nPos--;			break;
		case SB_LINEDOWN:   si.nPos++;			break;
		case SB_PAGEUP:     si.nPos -= si.nPage; break;
		case SB_PAGEDOWN:   si.nPos += si.nPage; break;
		case SB_THUMBTRACK: si.nPos = si.nTrackPos; break;
		default:            break;
	}

	// |WVݒ肷B
	si.fMask = SIF_POS;
	SetScrollInfo(hwnd, SB_VERT, &si, TRUE);
	// ʂقȂ邱Ƃ̂, ۂ̃|WVĎ擾B
	GetScrollInfo(hwnd, SB_VERT, &si);

	// ŏɕۑ|WVړĂ΃XN[sB
	if (i != si.nPos) {
		i -= si.nPos;									// ړsZo
		if (i > -iVpos) i = -iVpos;						// ͈͐
		ScrollWindow(hwnd, 0, i * cyChar, NULL, NULL);	//XN[
		iVpos += i;										// _ʒu(sPʐ)ۑ
		UpdateWindow(hwnd);								// ĕ`w
	}
	return 0;
}


// =============================================================================
// =============================================================================
// 2.4 {bZ[W@grbqnkk (WM_HSCROLL)
// =============================================================================
// =============================================================================
// WM_HSCROLL, XN[o[삳ꂽƂɑĂB
// wParamɋ̓Iȑ삪i[Ă̂, ɊÂăXN[Eo[
// ̈ʒuZo, SetScrollInfo APIŃo[ʒuύX, ScrollWindow APIŃXN[
// {B
//
// {֐ł, ̑傫ɂPʂŃXN[sƋ, XN
// [ɂĈړ_ʒuO[oϐiHpos Ɋi[B
// 2.1̒QƁB
// =============================================================================
int proc_hscroll(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int	i;
	SCROLLINFO	si;

	// ړÕo[̃|WV[Jϐiɕۑ
	si.cbSize = sizeof(si);
	si.fMask = SIF_ALL;
	GetScrollInfo(hwnd, SB_HORZ, &si);
	i = si.nPos;

	// eɉăo[̃|WV肷B
	switch (LOWORD(wParam)) {
		case SB_LEFT:		si.nPos = si.nMin;	break;
		case SB_RIGHT:		si.nPos = si.nMax;	break;
		case SB_LINELEFT:	si.nPos--;			break;
		case SB_LINERIGHT:	si.nPos++;			break;
		case SB_PAGELEFT:	si.nPos -= si.nPage; break;
		case SB_PAGERIGHT:	si.nPos += si.nPage; break;
		case SB_THUMBTRACK: si.nPos = si.nTrackPos; break;
		default:            break;
	}

	// |WVݒ肷B
	si.fMask = SIF_POS;
	SetScrollInfo(hwnd, SB_HORZ, &si, TRUE);
	// ʂقȂ邱Ƃ̂, ۂ̃|WVĎ擾B
	GetScrollInfo(hwnd, SB_HORZ, &si);

	// ŏɕۑ|WVړĂ΃XN[sB
	if (i != si.nPos) {
		i -= si.nPos;									// ړZo
		if (i > -iHpos) i = -iHpos;						// ͈͐
		ScrollWindow(hwnd, i * cxChar, 0, NULL, NULL);	// XN[
		iHpos += i;										// _ʒu(Pʐ)ۑ

		// DrawTextŕ`悵肪B2.1̒QƁB
//		UpdateWindow(hwnd);					// 炾ƍĕ`悳ȂB
		InvalidateRect(hwnd, NULL, TRUE);	// 炾ƕB
											// InvalidateRect̕܂ȏ󋵁B
	}

	return 0;
}

// =============================================================================
// =============================================================================
