# ExeToText

ExeToText は、Windows 向けのコンソールアプリケーションで、EXE や DLL などの **バイナリファイルから文字列を抽出するツール**です。

`strings` コマンドとほぼ同等の動作をしますが、**Shift-JIS と UTF-16（LE）が混在していることを前提**として処理を行う点が特徴です。そのため、日本語文字列の抽出において `strings` より有利になるケースがあります。

本ツールは **検索フィルター（インデクサ）用途**で利用されることを想定しています。

---

## 特徴

- EXE / DLL などのバイナリファイルに対応
- Shift-JIS 決め打ちによる日本語文字列抽出
- UTF-16（LE）文字列の抽出
- 出力は UTF-16（Windows 環境向け）
- 単一ファイル引数のみのシンプルな設計
- 軽量・高速

---

## 動作環境

- OS: Windows
- ビルド環境: Visual Studio
- 実行形式: コンソールアプリケーション

---

## 使用方法

```cmd
ExeToText.exe <対象ファイル>
```

### 例

```cmd
ExeToText.exe kernel32.dll

(出力例・抜粋)
VS_VERSION_INFO
StringFileInfo
040904B0
CompanyName
Microsoft Corporation
FileDescription
Windows NT BASE API Client DLL
FileVersion
10.0.26100.7171 (WinBuild.160101.0800)
```cmd
ExeToText.exe kernel32.dll
```

---

## 出力について

- 標準出力に **UTF-16** で文字列を出力します
- Shift-JIS / UTF-16 が混在していても、日本語文字列を優先的に可読な形に変換します
- 2文字以上の連続した可視文字列のみを出力します

---

## 想定用途

- Windows Search / 独自検索エンジン向けのフィルタ
- バイナリ内のエラーメッセージ・ログ文字列の調査
- 日本語アプリケーションの解析補助

---

## ライセンス

MIT License

---

## 注意事項

- 本ツールは PE 構造（.rdata など）を解析していません
- バイナリ全体をスキャンする方式のため、文字化けが非常に多く含まれます

---

## 作者

- GitHub: https://github.com/HoshiTomoyuki440

