﻿# SimpleMetaGetter

SimpleMetaGetter is a **Windows console tool** that extracts metadata from files
(such as Microsoft Office documents) using **IFilter**.

It is designed to be used as a **search filter or command-line utility**, with a focus on:
- Japanese language
- minimal functionality
- no external runtime environments

---

## Features

- Extracts metadata from Office and other IFilter-supported files
- Uses Windows **IFilter**
- Clean and readable output
- Output encoded in **UTF-16**
- Simple and compact codebase
- Suitable for search filters, batch processing, and pipelines

---

## Motivation

There are many tools that extract metadata from Office files, but many of them:
- produce garbled character output
- include excessive and unnecessary features
- require Python or other runtime environments
- are inconvenient to use as lightweight search filters

SimpleMetaGetter was created to solve these problems with a **native Windows executable**.

---

## Requirements

SimpleMetaGetter relies on Windows **IFilter**.

One of the following is required:

- Microsoft Office installed  
**OR**
- Microsoft Office 2010 Filter Packs (64-bit)

### Filter Pack Download

Microsoft official download page:

https://www.microsoft.com/ja-jp/download/details.aspx?id=17062

Package name:Microsoft Office 2010 Filter Packs (FilterPack64bit.exe)

## Build

- Platform: **Windows**
- Language: **C++**
- Compiler: **Microsoft Visual Studio**
- Application type: Console application

Open the project in Visual Studio and build normally.

---

## License

This project is licensed under the **MIT License**.

See the `LICENSE` file for details.

---

## Author

Tomoyuki Hoshi