/** passwordStrength.cpp
 * pX[h̋x𒲂ׂiWindowsAvŁj
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @J	MinGW C++ + Boost C++ Libraries
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-05-01.shtm
*/
//  ======================================================
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <sstream>
#include <string>
#include <locale>
#include <regex>
#include <filesystem>
#include <winsock2.h>
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include <richedit.h>
#include <cstdlib>
#include <algorithm>
#include <boost/program_options.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/format.hpp>
#include <openssl/md5.h>
#include "resource.h"

using namespace std;
using namespace boost;
using namespace boost::program_options;
using namespace boost::property_tree;

#define MAKER		"pahoo.org"				// 쐬
#define APPNAME		"passwordStrength"		// AvP[ViGUIŁj
#define APPNAMEJP	"pX[hx@"	// AvP[V
#define APPCMD		"pswst"					// AvP[ViCUIŁj
#define APPVERSION	"1.0.8"					// o[W
#define APPYEAR		"2023-25"				// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-20-01.shtm"	// QlTCg

// char*obt@TCY
#define SIZE_BUFF		512

// WtHg
#define FONT_FACE		"MS UI Gothic"

// ݂̃C^[tFCX
HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// G[EbZ[Wi[p
string ErrorMessage;

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// pX[h̍ŏ
#define PASSWORD_MINIMUM_LENGTH		8
// pX[h̍ő咷
#define PASSWORD_MAXIMUM_LENGTH		64

// t@C
#define FILENAME_DIC	"passwords.dic"

// õnbVli[^iMD5nbVli[pj
typedef unsigned char Digest[16];

// o^\Ȏoꐔ
#define MAX_WORDS	60000000

// kďd`FbN鎫oꐔ
#define BACK_WORDS	100000

// I̓JE^yύXsz
size_t DictionaryCounter = 0;

// pX[h̋xyύXsz
vector<std::string> strengthList = {
	"x0FmC܂n̒D",
	"x1F̂݁D",
	"x2Fp̂݁D",
	"x3FubNXgɑ݂D",
	"x4FubNXgɑ݂CL܂܂ȂD",
	"x5FubNXgɑ݂CL܂łD",
	"x6FubNXgɑ݂CL܂łCA镶͂ȂD"
};

// pX[hǂɗv鎞ԁi1p^[jyύXsz
// #define DECODE_TIME		2.00e-11
#define DECODE_TIME		5.61e-12		// RTX 4090 https://gigazine.net/news/20240502-nvidia-gpus-solve-password/

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
p܂ޖp\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

̃Cu𗘗pĂ܂D
MinGWig++j^Boost C++Cu
)")
% APPNAMEJP
% APPVERSION
% APPYEAR
).str();

// CUIwv
string Help = (boost::format(R"(
%1%  o[W %2%

%3%.exe -IvV
  pX[h
    -p, --password pX[h  肵pX[hw肷
  쐬
    -e, --empty                ɂ
    -i, --insert               ɒǉ
    -s, --source t@C    ǂݍރubNXgw肷
    -c, --column           ǂݍރJԍw肷 (1ȏ̐)
  ̑
    -h, --help                 wv\
    -v, --version              o[W\

() %3% -i -s passwords.txt
        ubNXg password.txt ǂݍŎɒǉD
)")
% APPNAMEJP
% APPVERSION
% APPCMD
).str();

// Nbv{[h֘A ======================================================
/**
 * Nbv{[hɕZbg
 * @param	string str 
 * @return	Ȃ
*/
void setClipboardData(string str) {
	char buff[str.size() + 1];
	char_traits<char>::copy(buff, str.c_str(), str.size() + 1);

	OpenClipboard(NULL);
	EmptyClipboard();

	HGLOBAL hText = GlobalAlloc(GHND | GMEM_SHARE, SIZE_BUFF);
	PTSTR pText = (PTSTR)GlobalLock(hText);
	lstrcpy(pText, buff);
	GlobalUnlock(hText);
	SetClipboardData(CF_TEXT, hText);
	CloseClipboard();
}

// IvVǍ^ۑ ====================================================
/**
 * AppDatãpX߂D
 * @param	char* appname AvP[V
 * @return	string pX
 */
string getMyPath(const char* appname) {
	static TCHAR myPath[MAX_PATH] = "";

	if (strlen(myPath) == 0) {
		if (SHGetSpecialFolderPath(NULL, myPath, CSIDL_APPDATA, 0)) {
			TCHAR *ptmp = _tcsrchr(myPath, _T('\\'));
			if (ptmp != NULL) {
				ptmp = _tcsinc(ptmp);
				*ptmp = _T('\0');
			}
			strcat(myPath, _T("Roaming"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\pahoo.org"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
			strcat(myPath, _T(appname));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
		} else {
		}
	}
	return (string)myPath;
}

/**
 * ۑp[^ǂݍށD
 * @param	Ȃ
 * @return	Ȃ
 */
string loadParam(void) {
	hParent_X = 0;
	hParent_Y = 0;
	ptree pt;

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (optional<string>str = pt.get_optional<string>("parameter")) {
			} else {
				return "";
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			hParent_X = 0;
			hParent_Y = 0;
			return "";
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		hParent_X = 0;
		hParent_Y = 0;
		return "";
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}

	return "";
}

/**
 * p[^ۑD
 * @param	Ȃ
 * @return	Ȃ
 */
void saveParam(void) {
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}

	// XMLt@C֏
	ptree pt;
	ptree& child3 = pt.add("parameter.param", (string)to_string(hParent_X));
	child3.add("<xmlattr>.type", "wx");
	ptree& child4 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child4.add("<xmlattr>.type", "wy");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

// t@C ========================================================
/**
 * t@C߂D
 * @param	Ȃ
 * @return	string t@C
*/
const char *getDictionaryName(void) {
	static char buff[SIZE_BUFF + 1];
	strncpy(buff, (getMyPath(APPNAME) + FILENAME_DIC).c_str(), SIZE_BUFF);
	return (const char *)buff;
}

/**
 * MD5nbVl\D
 * @param	Digest *dd  nbVl
 * @return	Ȃ
*/
void printDictionary(Digest *dd) {
	char s2[SIZE_BUFF + 1];
	for (size_t i = 0; i < sizeof(Digest); i++) {
		unsigned char *ch = (unsigned char *)dd + i;
		snprintf(s2, SIZE_BUFF, "%02X", (unsigned int)*ch);
		cout << s2;
	}
}

/**
 * t@CɂD
 * @param	Ȃ
 * @return	bool TRUEF^FALSEFs
*/
bool emptyDictionary() {
	const char *outfname = getDictionaryName();
	FILE *outfp;
	outfp = fopen(outfname, "wb");
	fclose(outfp);

	return TRUE;
}

/**
 * t@Cw肵ɓǂݍށD
 * @param	unsigned char *dic  ǂݍރ
 * @return	size_t ǂݍ񂾌o̐
*/
size_t readDictionary(unsigned char *dic) {
	size_t cnt;
	const char *infname = getDictionaryName();
	FILE *infp;
	infp = fopen(infname, "rb");
	if (infp == NULL) {
		ErrorMessage = "t@C܂";
		return 0;
	}

	// JE^ăɓǂݍށD
	DictionaryCounter = 0;
	for (cnt = 0; cnt < MAX_WORDS; cnt++) {
		if (feof(infp))		break;
		fread(dic + cnt * sizeof(Digest), sizeof(Digest), 1, infp);
		DictionaryCounter++;
	}
	fclose(infp);

	return cnt;
}

/**
 * w肵̓et@CɏށD
 * @param	unsigned char *dic  ރ
 * @param	size_t         cnt  o̐
 * @return	bool TRUEFݐ^FALSEFs
*/
bool writeDictionary(unsigned char *dic, size_t cnt) {
	const char *outfname = getDictionaryName();
	FILE *outfp;
	outfp = fopen(outfname, "wb");
	for (size_t i = 0; i < cnt; i++) {
		fwrite(dic + i * sizeof(Digest), sizeof(Digest), 1, outfp);
	}
	fclose(outfp);

	return TRUE;
}

/**
 * w肵nbVlw肵ɂȂΒǉD
 * ߂ɓo^50ɏdȂΒǉD
 * @param	unsigned char *dic  nbVli[
 * @param	Digest *md5         nbVl
 * @return	bool TRUEFǉ^FALSEFs
*/
bool addDictionary(unsigned char *dic, Digest *md5) {
	static Digest zero;
	memset((void *)&zero, 0, sizeof(Digest));
	size_t i;
	static unsigned char *pointer;
	static size_t ll = sizeof(Digest);
	size_t cnt;

	// BACK_WORDSꂾkďd`FbND
	if (DictionaryCounter > BACK_WORDS) {
		cnt = DictionaryCounter - BACK_WORDS;
		pointer = dic + cnt * ll;
	// ȊO
	} else {
		cnt = 0;
		pointer = dic;
	}

	// w肵nbVlw肵ɂȂΒǉD
	for (i = cnt; i < MAX_WORDS; i++) {
		if (memcmp(pointer, (void *)&zero, ll) == 0) {
			break;
		} else if (memcmp(pointer, (void *)md5, ll) == 0) {
			return FALSE;
		}
		pointer += ll;
	}

	// o^\ǂD
	if (i >= MAX_WORDS) {
		ErrorMessage = "ɓo^łȂ";
		return FALSE;
	} else {
		memcpy(dic + i * sizeof(Digest), (void *)md5, sizeof(Digest));
		DictionaryCounter++;
		return TRUE;
	}
}

/**
 * ubNXgEt@CǂݍŁCt@CɒǉD
 * @param	const char* infname  pX[hEt@C
 * @param	unsigned    column   ǂݍރJԍ
 * @return	size_t ǂݍ񂾌o̐
*/
size_t readKeywords2Dictionary(const char* infname, unsigned column) {
	// J[\v
	HCURSOR cur = SetCursor(LoadCursor(NULL, IDC_WAIT));

	// ǂݍݗp̃mۂB
	unsigned char *dic;
	dic = (unsigned char *)malloc((MAX_WORDS + 1) * sizeof(Digest));
	memset(dic, 0, (MAX_WORDS + 1) * sizeof(Digest));

	// t@CɓǂݍށD
	if (readDictionary(dic) == FALSE) {
		return FALSE;
	}

	// ubNXgEt@Cǂݍ݃I[vD
	static char s1[SIZE_BUFF + 1];
	static char s2[SIZE_BUFF + 1];
	FILE *infp;
	infp = fopen(infname, "rb");
	if (infp == NULL) {
		ErrorMessage = (string)infname + " ̓ǂݍ݂Ɏs܂";
		fclose(infp);
		return FALSE;
	}

	// pX[h1ǂݍ݁CnbVlɕϊĎt@C֒ǉD
	size_t cnt  = 0;
	size_t cnt2 = 0;
	size_t len  = 0;
	while (cnt2 < MAX_WORDS) {
		if (feof(infp))		break;
		if (fgets(s1, SIZE_BUFF, infp) == NULL)		break;
		len = strlen(s1);
		int k = 0;
		unsigned col = 1;	// Jԍ
		for (size_t j = 0; j < len; j++) {
			// J؂蕶CJԍ1₷D
			// ǂݍރJԍ𒴂ǂݍ݂ł؂D
			if ((s1[j] == '\t') || (s1[j] == ' ') || (s1[j] == ',')) {
				col++;
				if (col > column) {
					break;
				}
				k = 0;
			// pL荞ށD
			} else if (col == column) {
				if ((s1[j] >= '!') && (s1[j] <= '~')) {
					// ɓꂷD
					s2[k] = tolower(s1[j]);
					k++;
				}
			}
		}
		s2[k] = '\0';

		// ŏ蒷Ύɓo^D
		static Digest dd;
		if (k >= PASSWORD_MINIMUM_LENGTH) {
			// MD5nbVlddɑD
			MD5((const unsigned char *)s2, k, (unsigned char *)&dd);

//			cout << s2 << endl;
//			printDictionary((Digest *)dd);
//			cout << endl;

			// ǂݍ݃JE^
			if (cnt % 10000 == 0) {
				cout << cnt << "=>" << cnt2 << '\r';
			}
			if (addDictionary(dic, &dd) == TRUE) {
				cnt2++;
			}
			cnt++;
		}
	}
	fclose(infp);

	// t@C֏ށD
	writeDictionary(dic, DictionaryCounter);
	cout << "\nDictionaryCounter = " << DictionaryCounter << endl;
	// D
	free(dic);

	// J[\ɖ߂
	SetCursor(cur);

	return cnt2;
}

/**
 * t@Cɓo^ĂpX[h߂D
 * pX[h"1234","10"̂悤ȕŕԂD
 * @param	Ȃ
 * @return	string pX[h
*/
string countDictionary(void) {
	const char *infname = getDictionaryName();
	double fsize = filesystem::file_size((string)infname) / sizeof(Digest);
	char buff[SIZE_BUFF + 1];

	if (fsize < 10000) {
		snprintf(buff, SIZE_BUFF, " (o^ꐔF%.0f)", fsize);
	} else if (fsize < 100000000) {
		snprintf(buff, SIZE_BUFF, " (o^ꐔF%.0f)", fsize / 10000);
	} else if (fsize < 1000000000000) {
		snprintf(buff, SIZE_BUFF, " (o^ꐔF%.0f)", fsize / 100000000);
	} else {
		snprintf(buff, SIZE_BUFF, " (o^ꐔF1ȏ)");
	}

	return buff;
}

// pX[h̋𒲂ׂ =================================================
/**
 * w肵񂪐ǂ߂D
 * @param	string str 
 * @return	bool TRUEFł^FALSEFł͂Ȃ
*/
bool isNumbersOnly(string str) {
	regex re("^[0-9]+$");
	return regex_match(str, re);
}

/**
 * w肵񂪉pǂ߂D
 * @param	string str 
 * @return	bool TRUEFpł^FALSEFł͂Ȃ
*/
bool isAlphanumeric(string str) {
	regex re("^[A-Z|a-z|0-9]+$");
	return regex_match(str, re);
}

/**
 * w肵񂪎ɑ݂邩ǂ߂D
 * w肵ɓꂵĎt@CƔrD
 * @param	string str 
 * @return	bool TRUEF݂^FALSEF݂ȂA܂̓G[
*/
bool inDictionary(string str) {
	unsigned char s1[SIZE_BUFF + 1];
	unsigned char s2[SIZE_BUFF + 1];

	string s0 = str;
	// ɓꂷ
	transform(s0.begin(), s0.end(), s0.begin(), ::tolower);
	size_t len = s0.length();
	// MD5nbVls1ɑD
	MD5((const unsigned char *)s0.c_str(), len, (unsigned char *)s1);

//	printDictionary((Digest *)s1);
//	cout << endl;

	// J[\v
	HCURSOR cur = SetCursor(LoadCursor(NULL, IDC_WAIT));

	// t@CɊ܂܂Ă邩ǂTD
	bool ret = FALSE;
	const char *dicname = getDictionaryName();
	FILE *infp = fopen(dicname, "rb");
	if (infp == NULL) {
		ErrorMessage = "t@C܂";
		cout << ErrorMessage << endl;
		return FALSE;
	}
	for (size_t i = 0; i < MAX_WORDS; i++) {
		if (feof(infp))		break;
		fread(s2, sizeof(Digest), 1, infp);

//		printDictionary((Digest *)s2);
//		cout << endl;

		if (memcmp(s1, s2, sizeof(Digest)) == 0) {
			ret = TRUE;
			break;
		}
	}
	fclose(infp);

	// J[\ɖ߂
	SetCursor(cur);

	return ret;
}

/**
 * w肵񂪋L܂ނǂԂD
 * @param	string str 
 * @return	bool TRUEFL܂łȂ^FALSEF܂ł
*/
bool isContainNoSymbol(string str) {
	regex re("^[A-Z|a-z|0-9]+$");
	return regex_match(str, re);
}

/**
 * w肵ɘA܂ނǂ߂D
 * @param	string str 
 * @return	bool trueFA܂ށ^falseF܂܂Ȃ
*/
bool isSeqCharacters(string str) {
	const char *ptr = str.c_str();
	bool ret = FALSE;
	size_t len = str.length();
	if (len > 1) {
		for (size_t i = 1; i < len; i++) {
			if (ptr[i] == ptr[i - 1]) {
				ret = TRUE;
				break;
			}
		}
	}
	return ret;
}

/**
 * w肵pX[h𑍓ŉǂƂ̎Ԃ߂D
 * @param	string psw pX[h
 * @return	string ǎ
*/
string calcDecodeTime(string psw) {
	// ƌ߂D
	regex re1("^[0-9]+$");
	regex re2("^[A-Z]+$");
	regex re3("^[0-9|A-Z]+$");
	regex re4("^[a-z]+$");
	regex re5("^[0-9|a-z]+$");
	regex re6("^[A-Z|a-z]+$");
	regex re7("^[0-9|A-Z|a-z]+$");
	size_t num, len;
	if (regex_match(psw, re1)) {
		num = 10;
	} else if (regex_match(psw, re2)) {
		num = 26;
	} else if (regex_match(psw, re3)) {
		num = 36;
	} else if (regex_match(psw, re4)) {
		num = 26;
	} else if (regex_match(psw, re5)) {
		num = 36;
	} else if (regex_match(psw, re6)) {
		num = 52;
	} else if (regex_match(psw, re7)) {
		num = 62;
	} else {
		num = 86;
	}
	len = psw.length();

	// ǎԂvZD
	static char buff[SIZE_BUFF + 1];
	double sec = (double)pow(num, len) * DECODE_TIME;
	if (sec <= 1) {
		snprintf(buff, sizeof(buff), "1bȉŉǂłD");
	} else if (sec < 60) {
		snprintf(buff, sizeof(buff), "ǂɖ%.0fbD", sec);
	} else if (sec < (double)60 * 60) {
		snprintf(buff, sizeof(buff), "ǂɖ%.0fD", sec / 60);
	} else if (sec < (double)60 * 60 * 24) {
		snprintf(buff, sizeof(buff), "ǂɖ%.0fԂD", sec / (60 * 60));
	} else if (sec < (double)60 * 60 * 24 * 30) {
		snprintf(buff, sizeof(buff), "ǂɖ%.0fD", sec / (60 * 60 * 24));
	} else if (sec < (double)60 * 60 * 24 * 30 * 12) {
		snprintf(buff, sizeof(buff), "ǂɖ%.0fD", sec / (60 * 60 * 24 * 30));
	} else if (sec < (double)60 * 60 * 24 * 30 * 12 * 1000) {
		snprintf(buff, sizeof(buff), "ǂɖ%.0fND", sec / ((double)60 * 60 * 24 * 30 * 12));
	} else {
		snprintf(buff, sizeof(buff), "ǂ1000NȏォD");
	}

	return (string)buff;
}

/**
 * w肵pX[h̋x߂D
 * x1`5̐ŁC傫قǋxD
 * @param	string psw pX[h
 * @param	size_t min pX[h̍ŏGȗPASSWORD_MINIMUM_LENGTH
 * @param	size_t max pX[h̍ő咷GȗPASSWORD_MAXIMUM_LENGTH
 * @return	int x
 * 				1F̂
 *				2Fpnȉ
 *				3FubNXgɑ݂
 *				4F1`3NACL܂܂ĂȂ
 *				5F1`3NACL܂܂Ă
 *				6F1`5NACAȂ
*/
int getPasswordStrength(string psw, size_t min=PASSWORD_MINIMUM_LENGTH, size_t max=PASSWORD_MAXIMUM_LENGTH) {
	// 󔒂
	string str = regex_replace(psw, regex("[ \\t]+"), "");

	// pX[hstr̋xZoD
	int ret = 0;
	if ((psw.length() < min) || (psw.length() > max)) {
		ret = 0;
	} else if (isNumbersOnly(str)) {
		ret = 1;
	} else if (isAlphanumeric(str)) {
		ret = 2;
	} else if (inDictionary(str)) {
		ret = 3;
	} else if (isContainNoSymbol(str)) {
		ret = 4;
	} else if (isSeqCharacters(str)) {
		ret = 5;
	} else {
		ret = 6;
	}
	return ret;
}

#ifndef CMDAPP
// GUI =================================================================
/**
 * eLXg{bNX琮擾
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @return int 擾l
*/
int getIntEditBox(HWND hDlg, unsigned id) {
	char buff[SIZE_BUFF];
	GetDlgItemText(hDlg, id, buff, sizeof(buff));

	return atoi(buff);
}

/**
 * eLXg{bNXɐ
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  int		i     ݒl
 * @return Ȃ
*/
void setIntEditBox(HWND hDlg, unsigned id, int i) {
	char buff[SIZE_BUFF];
	snprintf(buff, sizeof(buff), "%d", i);
	SetDlgItemText(hDlg, id, buff);
}

/**
 * eLXg{bNX當擾
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @return string 擾
*/
string getStrEditBox(HWND hDlg, unsigned id) {
	char buff[SIZE_BUFF];
	GetDlgItemText(hDlg, id, buff, sizeof(buff));
	return (string)buff;
}

/**
 * eLXg{bNXɕ
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  string	s     ݒl
 * @return Ȃ
*/
void setStrEditBox(HWND hDlg, unsigned id, string s) {
	char buff[SIZE_BUFF];
	char_traits<char>::copy(buff, s.c_str(), s.size() + 1);
	SetDlgItemText(hDlg, id, buff);
	UpdateWindow(hDlg);
}

/**
 * _CAOeEBhE̒ɔzu
 * @param	HWND hDlg		̃nh
 * @global	HWND hParent	eEBhẼnh
 * @return	Ȃ
*/
void CenterWindow(HWND hDlg) {
	int  x, y;
	RECT rc;

	GetWindowRect(hParent, &rc);
	x = rc.left + (rc.right - rc.left) / 2;
	y = rc.top + (rc.bottom - rc.top) / 2;

	SetWindowPos(hDlg, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg	EBhEEnh
 * @paramm	UINT uMsg
 * @param	WPARAM wParam
 * @paramL	PARAM lParam
 * @return	INT_PTR CALLBACK
*/
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
		setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
		break;

	// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// s
		case IDC_BUTTON_OK:
			EndDialog(hDlg, 0);
			break;
		default:
			return 1;
		}
		break;
	// vOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
	return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
*/
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC)handler);
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
 */
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	HICON hIcon;
	string psw = "";
	string msg = "";
	int strength = 0;

    switch(uMsg){
	// _CAO
	case WM_INITDIALOG:
		hParent = hDlg;
		hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
		SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
		// p[^ǂݍ
		loadParam();
		// AvP[VEEBhEړ
		SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));
		// x0̃bZ[WpӂD
		char buff1[SIZE_BUFF + 1];
		snprintf(buff1, SIZE_BUFF, "x0F%dC܂%d̒D", PASSWORD_MINIMUM_LENGTH, PASSWORD_MAXIMUM_LENGTH);
		strengthList[0] = (string)buff1;
		// x3̃bZ[WpӂD
		strengthList[3] = strengthList[3] + countDictionary();
		break;

	// {^
	case WM_COMMAND:
		 switch (LOWORD(wParam)) {
			// pX[hx𔻒肷D
			case IDM_EXEC:
			case IDC_BUTTON_EXEC:
				psw = getStrEditBox(hParent, IDC_EDIT_PSW);
				strength = getPasswordStrength(psw, PASSWORD_MINIMUM_LENGTH, PASSWORD_MAXIMUM_LENGTH);
				if (ErrorMessage != "") {
					setStrEditBox(hParent, IDC_EDIT_MESSAGE, ErrorMessage);
				} else if (strength >= 0 && strength <= 6) {
					msg = strengthList[strength] + "\n\n" + calcDecodeTime(psw);
					setStrEditBox(hParent, IDC_TEXT_RESULT, msg.c_str());
				}
				break;
			// wv\D
			case IDM_HELP:
				ShellExecute(hParent, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
				break;
			// o[W\D
			case IDM_VERSION:
				createHelp(hParent, processHelp);
				break;
			// TCgփWvD
			case IDM_PAHOO:
				ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
				break;
			// 茋ʂRs[D
			case IDM_COPY:
			case IDC_BUTTON_COPY:
				msg = getStrEditBox(hDlg, IDC_EDIT_MESSAGE);
				setClipboardData(msg);
				break;
			// 茋ʂD
			case IDM_DELETE:
				setStrEditBox(hParent, IDC_EDIT_MESSAGE, "");
				break;
			// vOID
			case IDM_QUIT:
				saveParam();
				EndDialog(hParent, 0);
				return 0;
			default:
				break;
		}
		break;

	// vOID
	case WM_CLOSE:
		saveParam();
		EndDialog(hDlg, 0);
		break;
	}
    return 0;
}

// GUICvO ======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");
	hInst = hInstance;
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);

	return 0;
}

#else
// CUICvO ======================================================
/**
 * CUIpCvO
 * @param	int argc
 * @paramm	char* argv[]
 * @return	int ^[R[h
 */
int main(int argc, char* argv[]) {
	string psw = "";
	int ret = 0;

	// R}hCEIvV̒`
	options_description options("R}hCEIvV");
	options.add_options()
		("empty,e",		"ɂ")
		("insert,i",	"ɒǉ")
		("sour,s",		value<std::string>(), "ǂݍރubNXgw肷")
		("column,c",	value<unsigned>()->default_value(1), "ǂݍރJԍ")
		("password,p",	value<std::string>(), "pX[h̋x𔻒肷")
		("help,h",		"wv\\")
		("version,v",	"o[W\\")
		;
	// R}hCEIvV̎擾
	variables_map vm;
	try {
		store(parse_command_line(argc, argv, options), vm);
	} catch(const boost::program_options::error_with_option_name& e) {
		ErrorMessage =  e.what();
		cerr << ErrorMessage << endl;
		return 1;
	}
	notify(vm);

	// pX[hEt@C擾D
	string infname = "";
	if (vm.count("sour")) {
		infname = vm["sour"].as<string>();
	}
	// pX[hǂݍރJԍ擾D
	unsigned column = 1;
	if (vm.count("column")) {
		column = vm["column"].as<unsigned>();
	}

	// wv
	if (vm.count("help")) {
		cout << Help;
	// o[W
	} else if (vm.count("version")) {
		cout << Version;
	// t@CɂDD
	} else if (vm.count("empty")) {
		emptyDictionary();
	// t@CɒǉD
	} else if (vm.count("insert")) {
		readKeywords2Dictionary(infname.c_str(), column);
	// pX[h̋x𔻒肷D
	} else if (vm.count("password")) {
		psw = vm["password"].as<string>();
		ret = getPasswordStrength(psw);
		cout << "strength = " << ret << endl;
	}
	// G[
	if (ErrorMessage != "") {
		cout << "G[F" << ErrorMessage << endl;
	}
	return ret;
}

#endif

/*
** o[WAbv =====================================================
 *
 * @version 1.0.8  2025/11/30 gpCuXV
 * @version 1.0.7  2025/08/02 gpCuXV
 * @version 1.0.6  2025/03/29 ubNXg̋CgpCuXV
 * @version 1.0.5  2024/08/31 ubNXg̋CgpCuXV
 * @version 1.0.4  2024/05/04 DECODE_TIME ̒l
 * @version 1.0.3  2024/04/20 gpCuXV
 * @version 1.0.2  2023/11/23 t@CCgpCuXV
 * @version 1.0.1  2023/07/23 gpCuXVCbug-fix
 * @version 1.0.0  2023/02/19 
*/
