#!/bin/sh

remove_icons()
{
    rm /usr/share/icons/varicad"$ADDON".xpm 2>/dev/null
    rm /usr/share/pixmaps/varicad"$ADDON".xpm 2>/dev/null
}

remove_wmconfig()
{  
    rm /etc/X11/wmconfig/varicad"$ADDON" 2>/dev/null
    rm /etc/X11/applnk/varicad"$ADDON".desktop 2>/dev/null
    rm /etc/X11/applnk/$MENU_GROUP/varicad"$ADDON".desktop 2>/dev/null
}

remove_gnome_entries()
{
    rm ${1}/pixmaps/varicad"$ADDON".xpm 2>/dev/null
    rm ${1}/apps/$MENU_GROUP/varicad"$ADDON".desktop 2>/dev/null
}

remove_kde_entries()
{
	DIR_HI=${1}/icons/hicolor
	rm $DIR_HI/512x512/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/256x256/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/192x192/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/128x128/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/96x96/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/72x72/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/64x64/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/48x48/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/42x42/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/36x36/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/32x32/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/24x24/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/22x22/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_HI/16x16/apps/varicad"$ADDON".png 2>/dev/null
	DIR_LO=${1}/icons/locolor
	rm $DIR_LO/512x512/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/256x256/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/192x192/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/128x128/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/96x96/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/72x72/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/64x64/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/48x48/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/42x42/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/36x36/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/32x32/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/24x24/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/22x22/apps/varicad"$ADDON".png 2>/dev/null
	rm $DIR_LO/16x16/apps/varicad"$ADDON".png 2>/dev/null
	rm ${1}/applnk/$MENU_GROUP/varicad"$ADDON".desktop 2>/dev/null
	rm ${1}/applnk-mdk/$MENU_GROUP/varicad"$ADDON".desktop 2>/dev/null
}

remove_desktop_entries()
{
	DIR_SHARE=/usr/share
	if test -d $DIR_SHARE; then
		DIR_HI=$DIR_SHARE/icons/hicolor
		if test -d $DIR_HI -a -w $DIR_HI; then
			rm $DIR_HI/512x512/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/256x256/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/192x192/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/128x128/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/96x96/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/72x72/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/64x64/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/48x48/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/42x42/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/36x36/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/32x32/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/24x24/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/22x22/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_HI/16x16/apps/varicad"$ADDON".png 2>/dev/null
			if test -x /usr/bin/gtk-update-icon-cache; then
				/usr/bin/gtk-update-icon-cache -f $DIR_HI 2> /dev/null
			fi
		fi
		DIR_LO=$DIR_SHARE/icons/locolor
		if test -d $DIR_LO -a -w $DIR_LO; then
			rm $DIR_LO/512x512/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/256x256/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/192x192/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/128x128/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/96x96/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/72x72/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/64x64/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/48x48/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/42x42/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/36x36/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/32x32/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/24x24/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/22x22/apps/varicad"$ADDON".png 2>/dev/null
			rm $DIR_LO/16x16/apps/varicad"$ADDON".png 2>/dev/null
			if test -x /usr/bin/gtk-update-icon-cache; then
				/usr/bin/gtk-update-icon-cache -f $DIR_LO 2> /dev/null
			fi
		fi
		if test -d $DIR_SHARE/applications/; then
			rm $DIR_SHARE/applications/varicad"$ADDON".desktop 2>/dev/null
		fi
		if test -d $DIR_SHARE/mimelnk/application/; then
			rm $DIR_SHARE/mimelnk/application/x-varicad"$ADDON".desktop 2>/dev/null
		fi
		if test -x /usr/bin/update-desktop-database; then
			/usr/bin/update-desktop-database 2> /dev/null
		fi
		if test -x /usr/bin/update-mime-database; then
			/usr/bin/update-mime-database 2> /dev/null
		fi
	fi
  USERS_VCD=$(cut -d ":" -f1 < /etc/passwd)
  for USER_VCD in $USERS_VCD; do
    USER_HOME=$(grep "^$USER_VCD:" /etc/passwd | cut -d ":" -f6)
    if test -d $USER_HOME/Desktop; then
			rm $USER_HOME/Desktop/varicad"$ADDON".desktop 2> /dev/null
    fi
  done
}

update_mandrake_menu()
{
	if test -x /usr/bin/update-menus; then
		rm /usr/lib/menu/varicad 2>/dev/null
		rm /usr/share/icons/varicad"$ADDON".png 2>/dev/null
		rm /usr/share/icons/mini/varicad"$ADDON".png 2>/dev/null
		rm /usr/share/icons/large/varicad"$ADDON".png 2>/dev/null
		/usr/bin/update-menus || true
	fi
}

remove_mime()
{
	remove=1;
  if [ -f ../bin/varicad ]; then
		if [ -f /opt/VariCAD-View/bin/varicad-view ] || [ -f /opt/VariCAD-Trial/bin/varicad-trial ]; then remove=0; fi
  fi
	if [ -f ../bin/varicad-view ]; then
		if [ -f /opt/VariCAD/bin/varicad ] || [ -f /opt/VariCAD-Trial/bin/varicad-trial ]; then remove=0; fi
  fi
  if [ -f ../bin/varicad-trial ]; then
		if [ -f /opt/VariCAD/bin/varicad ] || [ -f /opt/VariCAD-View/bin/varicad-view ]; then remove=0; fi
  fi 
	if [ $remove -eq 1 ]; then
		if test -d ${1}; then
			DIR_HI=${1}/icons/hicolor
			if test -d $DIR_HI -a -w $DIR_HI; then
				if test -d $DIR_HI/512x512/mimetypes; then
					rm $DIR_HI/512x512/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/512x512/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/512x512/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/512x512/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/256x256/mimetypes; then
					rm $DIR_HI/256x256/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/256x256/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/256x256/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/256x256/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/192x192/mimetypes; then
					rm $DIR_HI/192x192/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/192x192/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/192x192/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/192x192/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/128x128/mimetypes; then
					rm $DIR_HI/128x128/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/128x128/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/128x128/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/128x128/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/96x96/mimetypes; then
					rm $DIR_HI/96x96/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/96x96/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/96x96/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/96x96/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/72x72/mimetypes; then
					rm $DIR_HI/72x72/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/72x72/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/72x72/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/72x72/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/64x64/mimetypes; then
					rm $DIR_HI/64x64/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/64x64/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/64x64/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/64x64/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/48x48/mimetypes; then
					rm $DIR_HI/48x48/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/48x48/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/48x48/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/48x48/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/42x42/mimetypes; then
					rm $DIR_HI/42x42/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/42x42/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/42x42/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/42x42/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/36x36/mimetypes; then
					rm $DIR_HI/36x36/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/36x36/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/36x36/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/36x36/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/32x32/mimetypes; then
					rm $DIR_HI/32x32/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/32x32/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/32x32/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/32x32/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/24x24/mimetypes; then
					rm $DIR_HI/24x24/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/24x24/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/24x24/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/24x24/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/22x22/mimetypes; then
					rm $DIR_HI/22x22/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/22x22/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/22x22/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/22x22/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_HI/16x16/mimetypes; then
					rm $DIR_HI/16x16/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_HI/16x16/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_HI/16x16/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_HI/16x16/mimetypes/varicad-dxf.png 2>/dev/null
				fi
			fi
			DIR_GNOME=${1}/icons/gnome
			if test -d $DIR_GNOME -a -w $DIR_GNOME; then
				if test -d $DIR_GNOME/512x512/mimetypes; then
					rm $DIR_GNOME/512x512/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/512x512/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/512x512/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/512x512/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/256x256/mimetypes; then
					rm $DIR_GNOME/256x256/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/256x256/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/256x256/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/256x256/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/192x192/mimetypes; then
					rm $DIR_GNOME/192x192/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/192x192/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/192x192/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/192x192/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/128x128/mimetypes; then
					rm $DIR_GNOME/128x128/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/128x128/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/128x128/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/128x128/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/96x96/mimetypes; then
					rm $DIR_GNOME/96x96/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/96x96/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/96x96/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/96x96/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/72x72/mimetypes; then
					rm $DIR_GNOME/72x72/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/72x72/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/72x72/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/72x72/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/64x64/mimetypes; then
					rm $DIR_GNOME/64x64/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/64x64/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/64x64/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/64x64/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/48x48/mimetypes; then
					rm $DIR_GNOME/48x48/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/48x48/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/48x48/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/48x48/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/42x42/mimetypes; then
					rm $DIR_GNOME/42x42/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/42x42/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/42x42/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/42x42/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/36x36/mimetypes; then
					rm $DIR_GNOME/36x36/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/36x36/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/36x36/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/36x36/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/32x32/mimetypes; then
					rm $DIR_GNOME/32x32/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/32x32/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/32x32/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/32x32/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/24x24/mimetypes; then
					rm $DIR_GNOME/24x24/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/24x24/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/24x24/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/24x24/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/22x22/mimetypes; then
					rm $DIR_GNOME/22x22/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/22x22/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/22x22/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/22x22/mimetypes/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_GNOME/16x16/mimetypes; then
					rm $DIR_GNOME/16x16/mimetypes/varicad-dwb.png 2>/dev/null
					rm $DIR_GNOME/16x16/mimetypes/varicad-dwg.png 2>/dev/null
					rm $DIR_GNOME/16x16/mimetypes/varicad-stp.png 2>/dev/null
					rm $DIR_GNOME/16x16/mimetypes/varicad-dxf.png 2>/dev/null
				fi
			fi
			DIR_UNITY=${1}/icons/Humanity
			if test -d $DIR_UNITY/mimes -a -w $DIR_UNITY/mimes; then
				if test -d $DIR_UNITY/mimes/512; then
					rm $DIR_UNITY/mimes/512/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/512/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/512/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/512/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/256; then
					rm $DIR_UNITY/mimes/256/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/256/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/256/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/256/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/192; then
					rm $DIR_UNITY/mimes/192/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/192/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/192/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/192/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/128; then
					rm $DIR_UNITY/mimes/128/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/128/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/128/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/128/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/96; then
					rm $DIR_UNITY/mimes/96/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/96/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/96/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/96/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/72; then
					rm $DIR_UNITY/mimes/72/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/72/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/72/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/72/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/64; then
					rm $DIR_UNITY/mimes/64/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/64/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/64/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/64/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/48; then
					rm $DIR_UNITY/mimes/48/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/48/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/48/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/48/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/42; then
					rm $DIR_UNITY/mimes/42/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/42/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/42/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/42/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/36; then
					rm $DIR_UNITY/mimes/36/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/36/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/36/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/36/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/32; then
					rm $DIR_UNITY/mimes/32/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/32/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/32/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/32/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/24; then
					rm $DIR_UNITY/mimes/24/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/24/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/24/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/24/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/22; then
					rm $DIR_UNITY/mimes/22/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/22/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/22/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/22/varicad-dxf.png 2>/dev/null
				fi
				if test -d $DIR_UNITY/mimes/16; then
					rm $DIR_UNITY/mimes/16/varicad-dwb.png 2>/dev/null
					rm $DIR_UNITY/mimes/16/varicad-dwg.png 2>/dev/null
					rm $DIR_UNITY/mimes/16/varicad-stp.png 2>/dev/null
					rm $DIR_UNITY/mimes/16/varicad-dxf.png 2>/dev/null
				fi
			fi						
			DIR_XML=${1}/mime/packages
			if test -d $DIR_XML -a -w $DIR_XML; then
				rm $DIR_XML/varicad-dwb.xml 2>/dev/null
				rm $DIR_XML/varicad-dwg.xml 2>/dev/null
				rm $DIR_XML/varicad-dxf.xml 2>/dev/null
				rm $DIR_XML/varicad-stp.xml 2>/dev/null
			fi
			DIR_MIME=${1}/mime
			if test -x /usr/bin/update-mime-database; then
				if test -d $DIR_MIME -a -w $DIR_MIME; then
					/usr/bin/update-mime-database -n $DIR_MIME 2> /dev/null
				fi
			fi
			if test -x /usr/bin/gtk-update-icon-cache; then
				if test -d $DIR_HI -a -w $DIR_HI; then
					/usr/bin/gtk-update-icon-cache $DIR_HI 2> /dev/null
				fi
				if test -d $DIR_GNOME -a -w $DIR_GNOME; then
					/usr/bin/gtk-update-icon-cache $DIR_GNOME 2> /dev/null
				fi
				if test -d $DIR_UNITY -a -w $DIR_UNITY; then
					/usr/bin/gtk-update-icon-cache $DIR_UNITY 2> /dev/null
				fi
			fi
			DIR_APP=${1}/applications
			if test -x /usr/bin/update-desktop-database; then
				if test -d $DIR_APP -a -w $DIR_APP; then
					/usr/bin/update-desktop-database $DIR_APP 2> /dev/null
				fi
			fi
		fi
	fi
}


  ADDON=""
  if test -f varicadview.xpm ; then
    ADDON="view"
  fi
   if test -f varicadtrial.xpm ; then
    ADDON="trial"
  fi 
  MENU_GROUP=Graphics

  remove_icons
  remove_wmconfig
  remove_gnome_entries /opt/gnome/share
  remove_gnome_entries /usr/share/gnome
  remove_kde_entries /opt/kde2/share
  remove_kde_entries /opt/kde3/share
  remove_kde_entries /usr/share
  remove_desktop_entries
  update_mandrake_menu
	remove_mime /usr/share
