#!/bin/sh

copy_icons()
{
	if test -w /usr/share/icons; then
			cp $DIR_FROM/varicad"$ADDON".xpm /usr/share/icons/varicad"$ADDON".xpm
	fi
	if test -w /usr/share/pixmaps/; then
			cp $DIR_FROM/varicad"$ADDON".xpm /usr/share/pixmaps/varicad"$ADDON".xpm
	fi
}

copy_wmconfig()
{  
	if test -w /etc/X11/wmconfig/; then
		cp $DIR_FROM/varicad"$ADDON".wmconfig /etc/X11/wmconfig/varicad"$ADDON"
	fi
	
	if test -d /etc/X11/applnk/; then
		if test ! -d /etc/X11/applnk/$MENU_GROUP/; then
			if test -w /etc/X11/applnk; then
				mkdir /etc/X11/applnk/$MENU_GROUP/
				chmod 755 /etc/X11/applnk/$MENU_GROUP
			fi
		fi
		if test -w /etc/X11/applnk/$MENU_GROUP; then
			cp $DIR_FROM/varicad"$ADDON".desktop /etc/X11/applnk/$MENU_GROUP
		fi
	fi
}

create_gnome_entries()
{
	if test -d ${1}; then
		if test ! -d ${1}/pixmaps/ -a -w ${1}; then
			mkdir ${1}/pixmaps/
			chmod 755 ${1}/pixmaps
		fi
		if test -w ${1}/pixmaps; then cp $DIR_FROM/varicad"$ADDON".xpm ${1}/pixmaps/varicad"$ADDON".xpm; fi
	fi
}

create_kde_entries()
{
	if test -d ${1}; then
		DIR_HI=${1}/icons/hicolor
		if test -d $DIR_HI -a -w $DIR_HI; then
			if test -d $DIR_HI/512x512/apps -a -w $DIR_HI/512x512/apps; then cp $DIR_FROM/varicad"$ADDON"_512x512.png $DIR_HI/512x512/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/256x256/apps -a -w $DIR_HI/256x256/apps; then cp $DIR_FROM/varicad"$ADDON"_256x256.png $DIR_HI/256x256/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/192x192/apps -a -w $DIR_HI/192x192/apps; then cp $DIR_FROM/varicad"$ADDON"_192x192.png $DIR_HI/192x192/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/128x128/apps -a -w $DIR_HI/128x128/apps; then cp $DIR_FROM/varicad"$ADDON"_128x128.png $DIR_HI/128x128/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/96x96/apps -a -w $DIR_HI/96x96/apps; then cp $DIR_FROM/varicad"$ADDON"_96x96.png $DIR_HI/96x96/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/72x72/apps -a -w $DIR_HI/72x72/apps; then cp $DIR_FROM/varicad"$ADDON"_72x72.png $DIR_HI/72x72/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/64x64/apps -a -w $DIR_HI/64x64/apps; then cp $DIR_FROM/varicad"$ADDON"_64x64.png $DIR_HI/64x64/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/48x48/apps -a -w $DIR_HI/48x48/apps; then cp $DIR_FROM/varicad"$ADDON"_48x48.png $DIR_HI/48x48/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/42x42/apps -a -w $DIR_HI/42x42/apps; then cp $DIR_FROM/varicad"$ADDON"_42x42.png $DIR_HI/42x42/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/36x36/apps -a -w $DIR_HI/36x36/apps; then cp $DIR_FROM/varicad"$ADDON"_36x36.png $DIR_HI/36x36/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/32x32/apps -a -w $DIR_HI/32x32/apps; then cp $DIR_FROM/varicad"$ADDON"_32x32.png $DIR_HI/32x32/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/24x24/apps -a -w $DIR_HI/24x24/apps; then cp $DIR_FROM/varicad"$ADDON"_24x24.png $DIR_HI/24x24/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/22x22/apps -a -w $DIR_HI/22x22/apps; then cp $DIR_FROM/varicad"$ADDON"_22x22.png $DIR_HI/22x22/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/16x16/apps -a -w $DIR_HI/16x16/apps; then cp $DIR_FROM/varicad"$ADDON"_16x16.png $DIR_HI/16x16/apps/varicad"$ADDON".png; fi
		fi
		DIR_LO=${1}/icons/locolor
		if test -d $DIR_LO -a -w $DIR_LO; then
			if test -d $DIR_LO/512x512/apps -a -w $DIR_LO/512x512/apps; then cp $DIR_FROM/varicad"$ADDON"_512x512.png $DIR_LO/512x512/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/256x256/apps -a -w $DIR_LO/256x256/apps; then cp $DIR_FROM/varicad"$ADDON"_256x256.png $DIR_LO/256x256/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/192x192/apps -a -w $DIR_LO/192x192/apps; then cp $DIR_FROM/varicad"$ADDON"_192x192.png $DIR_LO/192x192/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/128x128/apps -a -w $DIR_LO/128x128/apps; then cp $DIR_FROM/varicad"$ADDON"_128x128.png $DIR_LO/128x128/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/96x96/apps -a -w $DIR_LO/96x96/apps; then cp $DIR_FROM/varicad"$ADDON"_96x96.png $DIR_LO/96x96/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/72x72/apps -a -w $DIR_LO/72x72/apps; then cp $DIR_FROM/varicad"$ADDON"_72x72.png $DIR_LO/72x72/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/64x64/apps -a -w $DIR_LO/64x64/apps; then cp $DIR_FROM/varicad"$ADDON"_64x64.png $DIR_LO/64x64/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/48x48/apps -a -w $DIR_LO/48x48/apps; then cp $DIR_FROM/varicad"$ADDON"_48x48.png $DIR_LO/48x48/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/42x42/apps -a -w $DIR_LO/42x42/apps; then cp $DIR_FROM/varicad"$ADDON"_42x42.png $DIR_LO/42x42/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/36x36/apps -a -w $DIR_LO/36x36/apps; then cp $DIR_FROM/varicad"$ADDON"_36x36.png $DIR_LO/36x36/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/32x32/apps -a -w $DIR_LO/32x32/apps; then cp $DIR_FROM/varicad"$ADDON"_32x32.png $DIR_LO/32x32/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/24x24/apps -a -w $DIR_LO/24x24/apps; then cp $DIR_FROM/varicad"$ADDON"_24x24.png $DIR_LO/24x24/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/22x22/apps -a -w $DIR_LO/22x22/apps; then cp $DIR_FROM/varicad"$ADDON"_22x22.png $DIR_LO/22x22/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/16x16/apps -a -w $DIR_LO/16x16/apps; then cp $DIR_FROM/varicad"$ADDON"_16x16.png $DIR_LO/16x16/apps/varicad"$ADDON".png; fi
		fi
	fi  
}

create_desktop_entries()
{
	DIR_SHARE=/usr/share
	DIR_ETC=/etc
	if test -d $DIR_SHARE; then
		DIR_HI=$DIR_SHARE/icons/hicolor
		if test -d $DIR_HI -a -w $DIR_HI; then
			if test -d $DIR_HI/512x512/apps -a -w $DIR_HI/512x512/apps; then cp $DIR_FROM/varicad"$ADDON"_512x512.png $DIR_HI/512x512/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/256x256/apps -a -w $DIR_HI/256x256/apps; then cp $DIR_FROM/varicad"$ADDON"_256x256.png $DIR_HI/256x256/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/192x192/apps -a -w $DIR_HI/192x192/apps; then cp $DIR_FROM/varicad"$ADDON"_192x192.png $DIR_HI/192x192/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/128x128/apps -a -w $DIR_HI/128x128/apps; then cp $DIR_FROM/varicad"$ADDON"_128x128.png $DIR_HI/128x128/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/96x96/apps -a -w $DIR_HI/96x96/apps; then cp $DIR_FROM/varicad"$ADDON"_96x96.png $DIR_HI/96x96/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/72x72/apps -a -w $DIR_HI/72x72/apps; then cp $DIR_FROM/varicad"$ADDON"_72x72.png $DIR_HI/72x72/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/64x64/apps -a -w $DIR_HI/64x64/apps; then cp $DIR_FROM/varicad"$ADDON"_64x64.png $DIR_HI/64x64/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/48x48/apps -a -w $DIR_HI/48x48/apps; then cp $DIR_FROM/varicad"$ADDON"_48x48.png $DIR_HI/48x48/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/42x42/apps -a -w $DIR_HI/42x42/apps; then cp $DIR_FROM/varicad"$ADDON"_42x42.png $DIR_HI/42x42/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/36x36/apps -a -w $DIR_HI/36x36/apps; then cp $DIR_FROM/varicad"$ADDON"_36x36.png $DIR_HI/36x36/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/32x32/apps -a -w $DIR_HI/32x32/apps; then cp $DIR_FROM/varicad"$ADDON"_32x32.png $DIR_HI/32x32/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/24x24/apps -a -w $DIR_HI/24x24/apps; then cp $DIR_FROM/varicad"$ADDON"_24x24.png $DIR_HI/24x24/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/22x22/apps -a -w $DIR_HI/22x22/apps; then cp $DIR_FROM/varicad"$ADDON"_22x22.png $DIR_HI/22x22/apps/varicad"$ADDON".png; fi
			if test -d $DIR_HI/16x16/apps -a -w $DIR_HI/16x16/apps; then cp $DIR_FROM/varicad"$ADDON"_16x16.png $DIR_HI/16x16/apps/varicad"$ADDON".png; fi
			if test -x /usr/bin/gtk-update-icon-cache; then
				/usr/bin/gtk-update-icon-cache -f $DIR_HI 2> /dev/null
			fi
		fi
		DIR_LO=$DIR_SHARE/icons/locolor
		if test -d $DIR_LO -a -w $DIR_LO; then
			if test -d $DIR_LO/512x512/apps -a -w $DIR_LO/512x512/apps; then cp $DIR_FROM/varicad"$ADDON"_512x512.png $DIR_LO/512x512/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/256x256/apps -a -w $DIR_LO/256x256/apps; then cp $DIR_FROM/varicad"$ADDON"_256x256.png $DIR_LO/256x256/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/192x192/apps -a -w $DIR_LO/192x192/apps; then cp $DIR_FROM/varicad"$ADDON"_192x192.png $DIR_LO/192x192/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/128x128/apps -a -w $DIR_LO/128x128/apps; then cp $DIR_FROM/varicad"$ADDON"_128x128.png $DIR_LO/128x128/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/96x96/apps -a -w $DIR_LO/96x96/apps; then cp $DIR_FROM/varicad"$ADDON"_96x96.png $DIR_LO/96x96/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/72x72/apps -a -w $DIR_LO/72x72/apps; then cp $DIR_FROM/varicad"$ADDON"_72x72.png $DIR_LO/72x72/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/64x64/apps -a -w $DIR_LO/64x64/apps; then cp $DIR_FROM/varicad"$ADDON"_64x64.png $DIR_LO/64x64/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/48x48/apps -a -w $DIR_LO/48x48/apps; then cp $DIR_FROM/varicad"$ADDON"_48x48.png $DIR_LO/48x48/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/42x42/apps -a -w $DIR_LO/42x42/apps; then cp $DIR_FROM/varicad"$ADDON"_42x42.png $DIR_LO/42x42/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/36x36/apps -a -w $DIR_LO/36x36/apps; then cp $DIR_FROM/varicad"$ADDON"_36x36.png $DIR_LO/36x36/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/32x32/apps -a -w $DIR_LO/32x32/apps; then cp $DIR_FROM/varicad"$ADDON"_32x32.png $DIR_LO/32x32/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/24x24/apps -a -w $DIR_LO/24x24/apps; then cp $DIR_FROM/varicad"$ADDON"_24x24.png $DIR_LO/24x24/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/22x22/apps -a -w $DIR_LO/22x22/apps; then cp $DIR_FROM/varicad"$ADDON"_22x22.png $DIR_LO/22x22/apps/varicad"$ADDON".png; fi
			if test -d $DIR_LO/16x16/apps -a -w $DIR_LO/16x16/apps; then cp $DIR_FROM/varicad"$ADDON"_16x16.png $DIR_LO/16x16/apps/varicad"$ADDON".png; fi
			if test -x /usr/bin/gtk-update-icon-cache; then
				/usr/bin/gtk-update-icon-cache -f $DIR_LO 2> /dev/null
			fi
		fi
		if test -d $DIR_SHARE/applications/; then
			if test -w $DIR_SHARE/applications/; then cp $DIR_FROM/varicad"$ADDON".desktop $DIR_SHARE/applications/; fi
		fi
		if test -d $DIR_SHARE/mimelnk/application/; then
			if test -w $DIR_SHARE/mimelnk/application/; then cp $DIR_FROM/x-varicad"$ADDON".desktop $DIR_SHARE/mimelnk/application/; fi
		fi
		if test -x /usr/bin/update-desktop-database; then
			/usr/bin/update-desktop-database 2> /dev/null
		fi
		if test -x /usr/bin/update-mime-database; then
			/usr/bin/update-mime-database 2> /dev/null
		fi
	fi
  USERS_VCD=$(cut -d ":" -f1 < /etc/passwd)
  for USER_VCD in $USERS_VCD; do
    USER_HOME=$(grep "^$USER_VCD:" /etc/passwd | cut -d ":" -f6)
    GROUP_ID=$(grep "^$USER_VCD:" /etc/passwd | cut -d ":" -f4)
    GROUP_VCD=$(grep ":$GROUP_ID:" /etc/group | cut -d ":" -f1)
    if test -d $USER_HOME/Desktop; then
			cp $DIR_FROM/varicad"$ADDON".desktop $USER_HOME/Desktop/ 2> /dev/null
			chown $USER_VCD $USER_HOME/Desktop/varicad"$ADDON".desktop 2> /dev/null
			chgrp $GROUP_VCD $USER_HOME/Desktop/varicad"$ADDON".desktop 2> /dev/null
			chmod 744 $USER_HOME/Desktop/varicad"$ADDON".desktop 2> /dev/null
     fi
  done
}

update_mandrake_menu()
{
	if test -x /usr/bin/update-menus; then
		test ! -d /usr/lib/menu && test -w /usr/lib && mkdir /usr/lib/menu/
		test -d /usr/lib/menu -a -w /usr/lib/menu && cp $DIR_FROM/varicad"$ADDON".mdkmenu /usr/lib/menu/varicad
		test ! -d /usr/share/icons && test -w /usr/share && mkdir /usr/share/icons/ && chmod 755 /usr/share/icons
		test -d /usr/share/icons -a -w /usr/share/icons && cp $DIR_FROM/varicad"$ADDON"_32x32.png /usr/share/icons/varicad"$ADDON".png
		test ! -d /usr/share/icons/mini && test -w /usr/share/icons && mkdir /usr/share/icons/mini/ && chmod 755 /usr/share/icons/mini
		test -d /usr/share/icons/mini -a -w /usr/share/icons/mini && cp $DIR_FROM/varicad"$ADDON"_16x16.png /usr/share/icons/mini/varicad"$ADDON".png
		test ! -d /usr/share/icons/large && test -w /usr/share/icons && mkdir /usr/share/icons/large && chmod 755 /usr/share/icons/large
		test -d /usr/share/icons/large -a -w /usr/share/icons/large && cp $DIR_FROM/varicad"$ADDON"_48x48.png /usr/share/icons/large/varicad"$ADDON".png
		/usr/bin/update-menus || true
	fi
}

create_mime()
{
	if test -d ${1}; then
		DIR_HI=${1}/icons/hicolor
		DIR_GNOME=${1}/icons/gnome
		DIR_GNOME=${1}/icons/gnome
		DIR_UNITY=${1}/icons/Humanity
		DIR_XML=${1}/mime/packages
		if test -d $DIR_XML -a -w $DIR_XML; then
			if test ! -f $DIR_XML/varicad-dwb.xml; then
				cp $DIR_FROM/mime/varicad-dwb.xml $DIR_XML/varicad-dwb.xml;
				if test -d $DIR_HI -a -w $DIR_HI; then
					if test -d $DIR_HI/512x512/mimetypes -a -w $DIR_HI/512x512/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_512x512.png $DIR_HI/512x512/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/256x256/mimetypes -a -w $DIR_HI/256x256/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_256x256.png $DIR_HI/256x256/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/192x192/mimetypes -a -w $DIR_HI/192x192/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_192x192.png $DIR_HI/192x192/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/128x128/mimetypes -a -w $DIR_HI/128x128/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_128x128.png $DIR_HI/128x128/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/96x96/mimetypes -a -w $DIR_HI/96x96/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_96x96.png $DIR_HI/96x96/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/72x72/mimetypes -a -w $DIR_HI/72x72/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_72x72.png $DIR_HI/72x72/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/64x64/mimetypes -a -w $DIR_HI/64x64/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_64x64.png $DIR_HI/64x64/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/48x48/mimetypes -a -w $DIR_HI/48x48/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_48x48.png $DIR_HI/48x48/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/42x42/mimetypes -a -w $DIR_HI/42x42/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_42x42.png $DIR_HI/42x42/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/36x36/mimetypes -a -w $DIR_HI/36x36/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_36x36.png $DIR_HI/36x36/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/32x32/mimetypes -a -w $DIR_HI/32x32/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_32x32.png $DIR_HI/32x32/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/24x24/mimetypes -a -w $DIR_HI/24x24/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_24x24.png $DIR_HI/24x24/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/22x22/mimetypes -a -w $DIR_HI/22x22/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_22x22.png $DIR_HI/22x22/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_HI/16x16/mimetypes -a -w $DIR_HI/16x16/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_16x16.png $DIR_HI/16x16/mimetypes/varicad-dwb.png; fi
				fi
				if test -d $DIR_GNOME -a -w $DIR_GNOME; then
					if test -d $DIR_GNOME/512x512/mimetypes -a -w $DIR_GNOME/512x512/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_512x512.png $DIR_GNOME/512x512/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/256x256/mimetypes -a -w $DIR_GNOME/256x256/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_256x256.png $DIR_GNOME/256x256/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/192x192/mimetypes -a -w $DIR_GNOME/192x192/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_192x192.png $DIR_GNOME/192x192/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/128x128/mimetypes -a -w $DIR_GNOME/128x128/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_128x128.png $DIR_GNOME/128x128/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/96x96/mimetypes -a -w $DIR_GNOME/96x96/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_96x96.png $DIR_GNOME/96x96/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/72x72/mimetypes -a -w $DIR_GNOME/72x72/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_72x72.png $DIR_GNOME/72x72/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/64x64/mimetypes -a -w $DIR_GNOME/64x64/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_64x64.png $DIR_GNOME/64x64/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/48x48/mimetypes -a -w $DIR_GNOME/48x48/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_48x48.png $DIR_GNOME/48x48/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/42x42/mimetypes -a -w $DIR_GNOME/42x42/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_42x42.png $DIR_GNOME/42x42/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/36x36/mimetypes -a -w $DIR_GNOME/36x36/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_36x36.png $DIR_GNOME/36x36/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/32x32/mimetypes -a -w $DIR_GNOME/32x32/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_32x32.png $DIR_GNOME/32x32/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/24x24/mimetypes -a -w $DIR_GNOME/24x24/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_24x24.png $DIR_GNOME/24x24/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/22x22/mimetypes -a -w $DIR_GNOME/22x22/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_22x22.png $DIR_GNOME/22x22/mimetypes/varicad-dwb.png; fi
					if test -d $DIR_GNOME/16x16/mimetypes -a -w $DIR_GNOME/16x16/mimetypes; then cp $DIR_FROM/mime/varicad-dwb_16x16.png $DIR_GNOME/16x16/mimetypes/varicad-dwb.png; fi
				fi
				if test -d $DIR_UNITY/mimes -a -w $DIR_UNITY/mimes; then
					if test -d $DIR_UNITY/mimes/512 -a -w $DIR_UNITY/mimes/512; then cp $DIR_FROM/mime/varicad-dwb_512x512.png $DIR_UNITY/mimes/512/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/256 -a -w $DIR_UNITY/mimes/256; then cp $DIR_FROM/mime/varicad-dwb_256x256.png $DIR_UNITY/mimes/256/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/192 -a -w $DIR_UNITY/mimes/192; then cp $DIR_FROM/mime/varicad-dwb_192x192.png $DIR_UNITY/mimes/192/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/128 -a -w $DIR_UNITY/mimes/128; then cp $DIR_FROM/mime/varicad-dwb_128x128.png $DIR_UNITY/mimes/128/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/96 -a -w $DIR_UNITY/mimes/96; then cp $DIR_FROM/mime/varicad-dwb_96x96.png $DIR_UNITY/mimes/96/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/72 -a -w $DIR_UNITY/mimes/72; then cp $DIR_FROM/mime/varicad-dwb_72x72.png $DIR_UNITY/mimes/72/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/64 -a -w $DIR_UNITY/mimes/64; then cp $DIR_FROM/mime/varicad-dwb_64x64.png $DIR_UNITY/mimes/64/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/48 -a -w $DIR_UNITY/mimes/48; then cp $DIR_FROM/mime/varicad-dwb_48x48.png $DIR_UNITY/mimes/48/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/42 -a -w $DIR_UNITY/mimes/42; then cp $DIR_FROM/mime/varicad-dwb_42x42.png $DIR_UNITY/mimes/42/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/36 -a -w $DIR_UNITY/mimes/36; then cp $DIR_FROM/mime/varicad-dwb_36x36.png $DIR_UNITY/mimes/36/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/32 -a -w $DIR_UNITY/mimes/32; then cp $DIR_FROM/mime/varicad-dwb_32x32.png $DIR_UNITY/mimes/32/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/24 -a -w $DIR_UNITY/mimes/24; then cp $DIR_FROM/mime/varicad-dwb_24x24.png $DIR_UNITY/mimes/24/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/22 -a -w $DIR_UNITY/mimes/22; then cp $DIR_FROM/mime/varicad-dwb_22x22.png $DIR_UNITY/mimes/22/varicad-dwb.png; fi
					if test -d $DIR_UNITY/mimes/16 -a -w $DIR_UNITY/mimes/16; then cp $DIR_FROM/mime/varicad-dwb_16x16.png $DIR_UNITY/mimes/16/varicad-dwb.png; fi
				fi
			fi
			if test ! -f $DIR_XML/varicad-dwg.xml; then
				cp $DIR_FROM/mime/varicad-dwg.xml $DIR_XML/varicad-dwg.xml;
				if test -d $DIR_HI -a -w $DIR_HI; then
					if test -d $DIR_HI/512x512/mimetypes -a -w $DIR_HI/512x512/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_512x512.png $DIR_HI/512x512/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/256x256/mimetypes -a -w $DIR_HI/256x256/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_256x256.png $DIR_HI/256x256/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/192x192/mimetypes -a -w $DIR_HI/192x192/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_192x192.png $DIR_HI/192x192/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/128x128/mimetypes -a -w $DIR_HI/128x128/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_128x128.png $DIR_HI/128x128/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/96x96/mimetypes -a -w $DIR_HI/96x96/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_96x96.png $DIR_HI/96x96/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/72x72/mimetypes -a -w $DIR_HI/72x72/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_72x72.png $DIR_HI/72x72/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/64x64/mimetypes -a -w $DIR_HI/64x64/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_64x64.png $DIR_HI/64x64/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/48x48/mimetypes -a -w $DIR_HI/48x48/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_48x48.png $DIR_HI/48x48/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/42x42/mimetypes -a -w $DIR_HI/42x42/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_42x42.png $DIR_HI/42x42/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/36x36/mimetypes -a -w $DIR_HI/36x36/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_36x36.png $DIR_HI/36x36/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/32x32/mimetypes -a -w $DIR_HI/32x32/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_32x32.png $DIR_HI/32x32/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/24x24/mimetypes -a -w $DIR_HI/24x24/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_24x24.png $DIR_HI/24x24/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/22x22/mimetypes -a -w $DIR_HI/22x22/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_22x22.png $DIR_HI/22x22/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_HI/16x16/mimetypes -a -w $DIR_HI/16x16/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_16x16.png $DIR_HI/16x16/mimetypes/varicad-dwg.png; fi
				fi
				if test -d $DIR_GNOME -a -w $DIR_GNOME; then
					if test -d $DIR_GNOME/512x512/mimetypes -a -w $DIR_GNOME/512x512/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_512x512.png $DIR_GNOME/512x512/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/256x256/mimetypes -a -w $DIR_GNOME/256x256/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_256x256.png $DIR_GNOME/256x256/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/192x192/mimetypes -a -w $DIR_GNOME/192x192/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_192x192.png $DIR_GNOME/192x192/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/128x128/mimetypes -a -w $DIR_GNOME/128x128/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_128x128.png $DIR_GNOME/128x128/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/96x96/mimetypes -a -w $DIR_GNOME/96x96/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_96x96.png $DIR_GNOME/96x96/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/72x72/mimetypes -a -w $DIR_GNOME/72x72/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_72x72.png $DIR_GNOME/72x72/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/64x64/mimetypes -a -w $DIR_GNOME/64x64/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_64x64.png $DIR_GNOME/64x64/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/48x48/mimetypes -a -w $DIR_GNOME/48x48/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_48x48.png $DIR_GNOME/48x48/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/42x42/mimetypes -a -w $DIR_GNOME/42x42/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_42x42.png $DIR_GNOME/42x42/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/36x36/mimetypes -a -w $DIR_GNOME/36x36/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_36x36.png $DIR_GNOME/36x36/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/32x32/mimetypes -a -w $DIR_GNOME/32x32/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_32x32.png $DIR_GNOME/32x32/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/24x24/mimetypes -a -w $DIR_GNOME/24x24/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_24x24.png $DIR_GNOME/24x24/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/22x22/mimetypes -a -w $DIR_GNOME/22x22/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_22x22.png $DIR_GNOME/22x22/mimetypes/varicad-dwg.png; fi
					if test -d $DIR_GNOME/16x16/mimetypes -a -w $DIR_GNOME/16x16/mimetypes; then cp $DIR_FROM/mime/varicad-dwg_16x16.png $DIR_GNOME/16x16/mimetypes/varicad-dwg.png; fi
				fi
				if test -d $DIR_UNITY/mimes -a -w $DIR_UNITY/mimes; then
					if test -d $DIR_UNITY/mimes/512 -a -w $DIR_UNITY/mimes/512; then cp $DIR_FROM/mime/varicad-dwg_512x512.png $DIR_UNITY/mimes/512/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/256 -a -w $DIR_UNITY/mimes/256; then cp $DIR_FROM/mime/varicad-dwg_256x256.png $DIR_UNITY/mimes/256/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/192 -a -w $DIR_UNITY/mimes/192; then cp $DIR_FROM/mime/varicad-dwg_192x192.png $DIR_UNITY/mimes/192/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/128 -a -w $DIR_UNITY/mimes/128; then cp $DIR_FROM/mime/varicad-dwg_128x128.png $DIR_UNITY/mimes/128/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/96 -a -w $DIR_UNITY/mimes/96; then cp $DIR_FROM/mime/varicad-dwg_96x96.png $DIR_UNITY/mimes/96/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/72 -a -w $DIR_UNITY/mimes/72; then cp $DIR_FROM/mime/varicad-dwg_72x72.png $DIR_UNITY/mimes/72/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/64 -a -w $DIR_UNITY/mimes/64; then cp $DIR_FROM/mime/varicad-dwg_64x64.png $DIR_UNITY/mimes/64/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/48 -a -w $DIR_UNITY/mimes/48; then cp $DIR_FROM/mime/varicad-dwg_48x48.png $DIR_UNITY/mimes/48/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/42 -a -w $DIR_UNITY/mimes/42; then cp $DIR_FROM/mime/varicad-dwg_42x42.png $DIR_UNITY/mimes/42/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/36 -a -w $DIR_UNITY/mimes/36; then cp $DIR_FROM/mime/varicad-dwg_36x36.png $DIR_UNITY/mimes/36/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/32 -a -w $DIR_UNITY/mimes/32; then cp $DIR_FROM/mime/varicad-dwg_32x32.png $DIR_UNITY/mimes/32/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/24 -a -w $DIR_UNITY/mimes/24; then cp $DIR_FROM/mime/varicad-dwg_24x24.png $DIR_UNITY/mimes/24/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/22 -a -w $DIR_UNITY/mimes/22; then cp $DIR_FROM/mime/varicad-dwg_22x22.png $DIR_UNITY/mimes/22/varicad-dwg.png; fi
					if test -d $DIR_UNITY/mimes/16 -a -w $DIR_UNITY/mimes/16; then cp $DIR_FROM/mime/varicad-dwg_16x16.png $DIR_UNITY/mimes/16/varicad-dwg.png; fi
				fi
			fi				
			if test ! -f $DIR_XML/varicad-dxf.xml; then
				cp $DIR_FROM/mime/varicad-dxf.xml $DIR_XML/varicad-dxf.xml;
				if test -d $DIR_HI -a -w $DIR_HI; then
					if test -d $DIR_HI/512x512/mimetypes -a -w $DIR_HI/512x512/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_512x512.png $DIR_HI/512x512/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/256x256/mimetypes -a -w $DIR_HI/256x256/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_256x256.png $DIR_HI/256x256/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/192x192/mimetypes -a -w $DIR_HI/192x192/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_192x192.png $DIR_HI/192x192/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/128x128/mimetypes -a -w $DIR_HI/128x128/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_128x128.png $DIR_HI/128x128/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/96x96/mimetypes -a -w $DIR_HI/96x96/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_96x96.png $DIR_HI/96x96/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/72x72/mimetypes -a -w $DIR_HI/72x72/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_72x72.png $DIR_HI/72x72/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/64x64/mimetypes -a -w $DIR_HI/64x64/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_64x64.png $DIR_HI/64x64/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/48x48/mimetypes -a -w $DIR_HI/48x48/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_48x48.png $DIR_HI/48x48/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/42x42/mimetypes -a -w $DIR_HI/42x42/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_42x42.png $DIR_HI/42x42/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/36x36/mimetypes -a -w $DIR_HI/36x36/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_36x36.png $DIR_HI/36x36/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/32x32/mimetypes -a -w $DIR_HI/32x32/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_32x32.png $DIR_HI/32x32/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/24x24/mimetypes -a -w $DIR_HI/24x24/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_24x24.png $DIR_HI/24x24/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/22x22/mimetypes -a -w $DIR_HI/22x22/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_22x22.png $DIR_HI/22x22/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_HI/16x16/mimetypes -a -w $DIR_HI/16x16/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_16x16.png $DIR_HI/16x16/mimetypes/varicad-dxf.png; fi
				fi
				if test -d $DIR_GNOME -a -w $DIR_GNOME; then
					if test -d $DIR_GNOME/512x512/mimetypes -a -w $DIR_GNOME/512x512/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_512x512.png $DIR_GNOME/512x512/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/256x256/mimetypes -a -w $DIR_GNOME/256x256/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_256x256.png $DIR_GNOME/256x256/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/192x192/mimetypes -a -w $DIR_GNOME/192x192/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_192x192.png $DIR_GNOME/192x192/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/128x128/mimetypes -a -w $DIR_GNOME/128x128/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_128x128.png $DIR_GNOME/128x128/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/96x96/mimetypes -a -w $DIR_GNOME/96x96/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_96x96.png $DIR_GNOME/96x96/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/72x72/mimetypes -a -w $DIR_GNOME/72x72/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_72x72.png $DIR_GNOME/72x72/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/64x64/mimetypes -a -w $DIR_GNOME/64x64/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_64x64.png $DIR_GNOME/64x64/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/48x48/mimetypes -a -w $DIR_GNOME/48x48/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_48x48.png $DIR_GNOME/48x48/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/42x42/mimetypes -a -w $DIR_GNOME/42x42/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_42x42.png $DIR_GNOME/42x42/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/36x36/mimetypes -a -w $DIR_GNOME/36x36/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_36x36.png $DIR_GNOME/36x36/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/32x32/mimetypes -a -w $DIR_GNOME/32x32/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_32x32.png $DIR_GNOME/32x32/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/24x24/mimetypes -a -w $DIR_GNOME/24x24/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_24x24.png $DIR_GNOME/24x24/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/22x22/mimetypes -a -w $DIR_GNOME/22x22/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_22x22.png $DIR_GNOME/22x22/mimetypes/varicad-dxf.png; fi
					if test -d $DIR_GNOME/16x16/mimetypes -a -w $DIR_GNOME/16x16/mimetypes; then cp $DIR_FROM/mime/varicad-dxf_16x16.png $DIR_GNOME/16x16/mimetypes/varicad-dxf.png; fi
				fi				
				if test -d $DIR_UNITY/mimes -a -w $DIR_UNITY/mimes; then
					if test -d $DIR_UNITY/mimes/512 -a -w $DIR_UNITY/mimes/512; then cp $DIR_FROM/mime/varicad-dxf_512x512.png $DIR_UNITY/mimes/512/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/256 -a -w $DIR_UNITY/mimes/256; then cp $DIR_FROM/mime/varicad-dxf_256x256.png $DIR_UNITY/mimes/256/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/192 -a -w $DIR_UNITY/mimes/192; then cp $DIR_FROM/mime/varicad-dxf_192x192.png $DIR_UNITY/mimes/192/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/128 -a -w $DIR_UNITY/mimes/128; then cp $DIR_FROM/mime/varicad-dxf_128x128.png $DIR_UNITY/mimes/128/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/96 -a -w $DIR_UNITY/mimes/96; then cp $DIR_FROM/mime/varicad-dxf_96x96.png $DIR_UNITY/mimes/96/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/72 -a -w $DIR_UNITY/mimes/72; then cp $DIR_FROM/mime/varicad-dxf_72x72.png $DIR_UNITY/mimes/72/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/64 -a -w $DIR_UNITY/mimes/64; then cp $DIR_FROM/mime/varicad-dxf_64x64.png $DIR_UNITY/mimes/64/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/48 -a -w $DIR_UNITY/mimes/48; then cp $DIR_FROM/mime/varicad-dxf_48x48.png $DIR_UNITY/mimes/48/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/42 -a -w $DIR_UNITY/mimes/42; then cp $DIR_FROM/mime/varicad-dxf_42x42.png $DIR_UNITY/mimes/42/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/36 -a -w $DIR_UNITY/mimes/36; then cp $DIR_FROM/mime/varicad-dxf_36x36.png $DIR_UNITY/mimes/36/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/32 -a -w $DIR_UNITY/mimes/32; then cp $DIR_FROM/mime/varicad-dxf_32x32.png $DIR_UNITY/mimes/32/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/24 -a -w $DIR_UNITY/mimes/24; then cp $DIR_FROM/mime/varicad-dxf_24x24.png $DIR_UNITY/mimes/24/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/22 -a -w $DIR_UNITY/mimes/22; then cp $DIR_FROM/mime/varicad-dxf_22x22.png $DIR_UNITY/mimes/22/varicad-dxf.png; fi
					if test -d $DIR_UNITY/mimes/16 -a -w $DIR_UNITY/mimes/16; then cp $DIR_FROM/mime/varicad-dxf_16x16.png $DIR_UNITY/mimes/16/varicad-dxf.png; fi
				fi
			fi				
			if test ! -f $DIR_XML/varicad-stp.xml; then
				cp $DIR_FROM/mime/varicad-stp.xml $DIR_XML/varicad-stp.xml;
				if test -d $DIR_HI -a -w $DIR_HI; then
					if test -d $DIR_HI/512x512/mimetypes -a -w $DIR_HI/512x512/mimetypes; then cp $DIR_FROM/mime/varicad-stp_512x512.png $DIR_HI/512x512/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/256x256/mimetypes -a -w $DIR_HI/256x256/mimetypes; then cp $DIR_FROM/mime/varicad-stp_256x256.png $DIR_HI/256x256/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/192x192/mimetypes -a -w $DIR_HI/192x192/mimetypes; then cp $DIR_FROM/mime/varicad-stp_192x192.png $DIR_HI/192x192/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/128x128/mimetypes -a -w $DIR_HI/128x128/mimetypes; then cp $DIR_FROM/mime/varicad-stp_128x128.png $DIR_HI/128x128/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/96x96/mimetypes -a -w $DIR_HI/96x96/mimetypes; then cp $DIR_FROM/mime/varicad-stp_96x96.png $DIR_HI/96x96/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/72x72/mimetypes -a -w $DIR_HI/72x72/mimetypes; then cp $DIR_FROM/mime/varicad-stp_72x72.png $DIR_HI/72x72/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/64x64/mimetypes -a -w $DIR_HI/64x64/mimetypes; then cp $DIR_FROM/mime/varicad-stp_64x64.png $DIR_HI/64x64/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/48x48/mimetypes -a -w $DIR_HI/48x48/mimetypes; then cp $DIR_FROM/mime/varicad-stp_48x48.png $DIR_HI/48x48/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/42x42/mimetypes -a -w $DIR_HI/42x42/mimetypes; then cp $DIR_FROM/mime/varicad-stp_42x42.png $DIR_HI/42x42/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/36x36/mimetypes -a -w $DIR_HI/36x36/mimetypes; then cp $DIR_FROM/mime/varicad-stp_36x36.png $DIR_HI/36x36/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/32x32/mimetypes -a -w $DIR_HI/32x32/mimetypes; then cp $DIR_FROM/mime/varicad-stp_32x32.png $DIR_HI/32x32/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/24x24/mimetypes -a -w $DIR_HI/24x24/mimetypes; then cp $DIR_FROM/mime/varicad-stp_24x24.png $DIR_HI/24x24/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/22x22/mimetypes -a -w $DIR_HI/22x22/mimetypes; then cp $DIR_FROM/mime/varicad-stp_22x22.png $DIR_HI/22x22/mimetypes/varicad-stp.png; fi
					if test -d $DIR_HI/16x16/mimetypes -a -w $DIR_HI/16x16/mimetypes; then cp $DIR_FROM/mime/varicad-stp_16x16.png $DIR_HI/16x16/mimetypes/varicad-stp.png; fi
				fi
				if test -d $DIR_GNOME -a -w $DIR_GNOME; then
					if test -d $DIR_GNOME/512x512/mimetypes -a -w $DIR_GNOME/512x512/mimetypes; then cp $DIR_FROM/mime/varicad-stp_512x512.png $DIR_GNOME/512x512/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/256x256/mimetypes -a -w $DIR_GNOME/256x256/mimetypes; then cp $DIR_FROM/mime/varicad-stp_256x256.png $DIR_GNOME/256x256/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/192x192/mimetypes -a -w $DIR_GNOME/192x192/mimetypes; then cp $DIR_FROM/mime/varicad-stp_192x192.png $DIR_GNOME/192x192/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/128x128/mimetypes -a -w $DIR_GNOME/128x128/mimetypes; then cp $DIR_FROM/mime/varicad-stp_128x128.png $DIR_GNOME/128x128/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/96x96/mimetypes -a -w $DIR_GNOME/96x96/mimetypes; then cp $DIR_FROM/mime/varicad-stp_96x96.png $DIR_GNOME/96x96/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/72x72/mimetypes -a -w $DIR_GNOME/72x72/mimetypes; then cp $DIR_FROM/mime/varicad-stp_72x72.png $DIR_GNOME/72x72/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/64x64/mimetypes -a -w $DIR_GNOME/64x64/mimetypes; then cp $DIR_FROM/mime/varicad-stp_64x64.png $DIR_GNOME/64x64/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/48x48/mimetypes -a -w $DIR_GNOME/48x48/mimetypes; then cp $DIR_FROM/mime/varicad-stp_48x48.png $DIR_GNOME/48x48/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/42x42/mimetypes -a -w $DIR_GNOME/42x42/mimetypes; then cp $DIR_FROM/mime/varicad-stp_42x42.png $DIR_GNOME/42x42/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/36x36/mimetypes -a -w $DIR_GNOME/36x36/mimetypes; then cp $DIR_FROM/mime/varicad-stp_36x36.png $DIR_GNOME/36x36/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/32x32/mimetypes -a -w $DIR_GNOME/32x32/mimetypes; then cp $DIR_FROM/mime/varicad-stp_32x32.png $DIR_GNOME/32x32/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/24x24/mimetypes -a -w $DIR_GNOME/24x24/mimetypes; then cp $DIR_FROM/mime/varicad-stp_24x24.png $DIR_GNOME/24x24/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/22x22/mimetypes -a -w $DIR_GNOME/22x22/mimetypes; then cp $DIR_FROM/mime/varicad-stp_22x22.png $DIR_GNOME/22x22/mimetypes/varicad-stp.png; fi
					if test -d $DIR_GNOME/16x16/mimetypes -a -w $DIR_GNOME/16x16/mimetypes; then cp $DIR_FROM/mime/varicad-stp_16x16.png $DIR_GNOME/16x16/mimetypes/varicad-stp.png; fi
				fi
				if test -d $DIR_UNITY/mimes -a -w $DIR_UNITY/mimes; then
					if test -d $DIR_UNITY/mimes/512 -a -w $DIR_UNITY/mimes/512; then cp $DIR_FROM/mime/varicad-stp_512x512.png $DIR_UNITY/mimes/512/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/256 -a -w $DIR_UNITY/mimes/256; then cp $DIR_FROM/mime/varicad-stp_256x256.png $DIR_UNITY/mimes/256/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/192 -a -w $DIR_UNITY/mimes/192; then cp $DIR_FROM/mime/varicad-stp_192x192.png $DIR_UNITY/mimes/192/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/128 -a -w $DIR_UNITY/mimes/128; then cp $DIR_FROM/mime/varicad-stp_128x128.png $DIR_UNITY/mimes/128/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/96 -a -w $DIR_UNITY/mimes/96; then cp $DIR_FROM/mime/varicad-stp_96x96.png $DIR_UNITY/mimes/96/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/72 -a -w $DIR_UNITY/mimes/72; then cp $DIR_FROM/mime/varicad-stp_72x72.png $DIR_UNITY/mimes/72/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/64 -a -w $DIR_UNITY/mimes/64; then cp $DIR_FROM/mime/varicad-stp_64x64.png $DIR_UNITY/mimes/64/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/48 -a -w $DIR_UNITY/mimes/48; then cp $DIR_FROM/mime/varicad-stp_48x48.png $DIR_UNITY/mimes/48/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/42 -a -w $DIR_UNITY/mimes/42; then cp $DIR_FROM/mime/varicad-stp_42x42.png $DIR_UNITY/mimes/42/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/36 -a -w $DIR_UNITY/mimes/36; then cp $DIR_FROM/mime/varicad-stp_36x36.png $DIR_UNITY/mimes/36/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/32 -a -w $DIR_UNITY/mimes/32; then cp $DIR_FROM/mime/varicad-stp_32x32.png $DIR_UNITY/mimes/32/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/24 -a -w $DIR_UNITY/mimes/24; then cp $DIR_FROM/mime/varicad-stp_24x24.png $DIR_UNITY/mimes/24/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/22 -a -w $DIR_UNITY/mimes/22; then cp $DIR_FROM/mime/varicad-stp_22x22.png $DIR_UNITY/mimes/22/varicad-stp.png; fi
					if test -d $DIR_UNITY/mimes/16 -a -w $DIR_UNITY/mimes/16; then cp $DIR_FROM/mime/varicad-stp_16x16.png $DIR_UNITY/mimes/16/varicad-stp.png; fi
				fi
			fi
		fi
		DIR_MIME=${1}/mime
		if test -x /usr/bin/update-mime-database; then
			if test -d $DIR_MIME -a -w $DIR_MIME; then
				/usr/bin/update-mime-database -n $DIR_MIME 2> /dev/null
			fi
		fi
		if test -x /usr/bin/gtk-update-icon-cache; then
			if test -d $DIR_HI -a -w $DIR_HI; then
				/usr/bin/gtk-update-icon-cache $DIR_HI 2> /dev/null
			fi
			if test -d $DIR_GNOME -a -w $DIR_GNOME; then
				/usr/bin/gtk-update-icon-cache $DIR_GNOME 2> /dev/null
			fi
			if test -d $DIR_UNITY -a -w $DIR_UNITY; then
				/usr/bin/gtk-update-icon-cache $DIR_UNITY 2> /dev/null
			fi
		fi
		sleep 2
		DIR_APP=${1}/applications
		if test -x /usr/bin/update-desktop-database; then
			if test -d $DIR_APP -a -w $DIR_APP; then
				/usr/bin/update-desktop-database $DIR_APP 2> /dev/null
			fi
		fi
	fi  
}


  DIR_FROM=./
  ADDON=""
  if test -f varicadview.xpm ; then
    ADDON="view"
  fi
  if test -f varicadtrial.xpm ; then
    ADDON="trial"
  fi
  MENU_GROUP=Graphics

  copy_icons
  copy_wmconfig
  create_gnome_entries /opt/gnome/share
  create_gnome_entries /usr/share/gnome
  create_kde_entries /opt/kde2/share
  create_kde_entries /opt/kde3/share
  create_kde_entries /usr/share
  create_desktop_entries
  update_mandrake_menu
	create_mime /usr/share
