/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define DEBUG_CPP
#include "common.h"

/*------------------------------------------------------------------------------
    \
------------------------------------------------------------------------------*/
typedef struct st_DebugMsg {
	INT32 winType;
	INT32 msg;
	WPARAM wp;
	LPARAM lp;
} st_DebugMsg;

/*------------------------------------------------------------------------------
    t@C[J
------------------------------------------------------------------------------*/
UINT16      dbIdx;
st_DebugMsg dbQueue  [CNT_DEBUG];
WCHAR       dbStrBuff[40];
WCHAR       dbStrWin [8][5+1] = {L"CORE",
								 L"FORM",
								 L"CNTN",
								 L"PICT",
								 L"TOOL",
								 L"ITEM",
								 L"STAT",
								 L"CHIP"};

/*------------------------------------------------------------------------------
    Fvoid DebugAdd(INT32, INT32, WPARAM, LPARAM)
    FWINDTYPE    -
          INT32       -
          WPARAM      -
          LPARAM      -
    @\FbZ[WۑĂ
------------------------------------------------------------------------------*/
void DebugAdd(INT32 winType, INT32 msg, WPARAM wp, LPARAM lp)
{
	WCHAR str[100];
	INT32 idx;
	INT32 i;
	
	if (((winType == N_CORE) && (IsBit(g_flgsDebug, BIT_CORE))) ||
		((winType == N_FORM) && (IsBit(g_flgsDebug, BIT_FORM))) ||
		((winType == N_CNTN) && (IsBit(g_flgsDebug, BIT_CNTN))) ||
		((winType == N_PICT) && (IsBit(g_flgsDebug, BIT_PICT))) ||
		((winType == N_TOOL) && (IsBit(g_flgsDebug, BIT_TOOL))) ||
		((winType == N_ITEM) && (IsBit(g_flgsDebug, BIT_ITEM))) ||
		((winType == N_STAT) && (IsBit(g_flgsDebug, BIT_STAT))) ||
		((winType == N_CHIP) && (IsBit(g_flgsDebug, BIT_CHIP))))
	{
		for (i = 0; i < 10; i++) {
			if (g_ignore[i] == (INT32)msg) {return;}
		}
		
		dbQueue[dbIdx].winType = winType;
		dbQueue[dbIdx].msg     = msg;
		dbQueue[dbIdx].wp      = wp;
		dbQueue[dbIdx].lp      = lp;
		dbIdx = (dbIdx + 1) % CNT_DEBUG;
		
		DebugPrint(msg, wp);
		
		if (wcscmp(dbStrBuff, L"-") == 0) {
			idx = 0;
			idx += swprintf(str+idx, dbStrWin[winType]);
			idx += swprintf(str+idx, L"\t");
			idx += swprintf(str+idx, L"0x%03X\r\n", msg);
			DebugStore(str);
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid DebugStore(WCHAR *)
    FWCHAR *  -
    @\FfobȌ݂sB
------------------------------------------------------------------------------*/
void DebugStore(WCHAR *pStr)
{
	HANDLE hFile;
	ULOG32 cnt;
	WCHAR path[MAX_PATH];
	char str[100];
	INT32 len;
	
	SHGetSpecialFolderPath(NULL, path, CSIDL_PERSONAL, FALSE);
	wcscat(path, L"\\");
	wcscat(path, L_TITLE);
	
	if (IsExistFolder(path)) {CreateDirectory(path, NULL);}
	
	wcscat(path, L"\\debug.txt");
	
	hFile = CreateFile(path, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, OPEN_ALWAYS,
					   FILE_ATTRIBUTE_NORMAL, NULL);
	
	if (hFile == INVALID_HANDLE_VALUE)
	{MessageBox(NULL, L"debug.txt error", L_ERROR, MB_OK);  return;}
	
	SetFilePointer(hFile, 0, NULL, FILE_END);
	
	memset(str, 0x00, 100);
	len = wcslen(pStr);
	wcstombs(str, pStr, len);
	str[len] = 0x00;
	WriteFile(hFile, str, len, &cnt, NULL);
	
	CloseHandle(hFile);
}

/*------------------------------------------------------------------------------
    Fvoid DebugDump(void)
    @\FbZ[W\
------------------------------------------------------------------------------*/
void DebugDump(void)
{
	INT32 i;
	INT32 pos;
	INT32 idx;
	WCHAR str[2500];
	
	idx = 0;
	wmemset(str, 0x0000, 2500);
	
	for (i = 0; i < CNT_DEBUG; i++) {
		pos = (dbIdx + i) % CNT_DEBUG;
		
		if (dbQueue[pos].winType == N_INVALID) {continue;}
		
		idx += swprintf(str+idx, dbStrWin[dbQueue[pos].winType]);
		idx += swprintf(str+idx, L"\t");
		
		DebugPrint(dbQueue[pos].msg, dbQueue[pos].wp);
		
		idx += swprintf(str+idx, L"0x%03X\t", dbQueue[pos].msg);
		idx += swprintf(str+idx, L"%s", dbStrBuff);
		idx += swprintf(str+idx, L"\n");
	}
	if (wcslen(str) == 0) {wcscpy(str, L"none");}
	
	MessageBox(NULL, str, L_DEBUG, MB_OK);
	DebugReset();
}

/*------------------------------------------------------------------------------
    Fvoid DebugPrint(INT32, WPARAM)
    FINT32     -
          WPARAM    -
    @\F쐬
------------------------------------------------------------------------------*/
void DebugPrint(INT32 msg, WPARAM wp)
{
	INT16 lwp;
	INT16 hwp;
	
	lwp = LOWORD(wp);
	hwp = HIWORD(wp);
	
	if (msg == 0x0111) {
		swprintf(dbStrBuff, L"COMMAND(0x%X)", wp);
	}
	else if (msg == 0x0400) {
		wcscpy(dbStrBuff, L"USER");
		switch(lwp) {
		case WMU_NULL:       wcscat(dbStrBuff, L" (NULL)");       break;
		case WMU_REQUEST:    wcscat(dbStrBuff, L" (REQUEST)");    break;
		case WMU_THREND:     wcscat(dbStrBuff, L" (THREND)");     break;
		case WMU_THRVTEND:   wcscat(dbStrBuff, L" (THRVTEND)");   break;
		case WMU_THRLTEND:   wcscat(dbStrBuff, L" (THRLTEND)");   break;
		case WMU_NEXTPOP:    wcscat(dbStrBuff, L" (NEXTPOP)");    break;
		case WMU_RGBEND:     wcscat(dbStrBuff, L" (RGBEND)");     break;
		default: break;
		}
		// MAKEWPARAM(WMU_THREND, i)
	}
	else if (msg <= 0x03FF) {
		wcscpy(dbStrBuff, TxDg(msg));
	}
	else if ((0xC000 <= msg) && (msg <= 0xFFFF)) {
		wcscpy(dbStrBuff, L"RegisterWindowMessage");
	}
	else {
		wcscpy(dbStrBuff, L"-");
	}
}

/*------------------------------------------------------------------------------
    Fvoid DebugReset(void)
    @\FbZ[W
------------------------------------------------------------------------------*/
void DebugReset(void)
{
	INT32 i;
	
	for (i = 0; i < CNT_DEBUG; i++) {
		dbQueue[i].winType = N_INVALID;
		dbQueue[i].msg     = 0x000;
		dbQueue[i].wp      = NULL;
		dbQueue[i].lp      = NULL;
	}
}
