/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define AR_CPP
#include "../common.h"
//  AreaF͈

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 x1;
	INT32 y1;
	INT32 x2;
	INT32 y2;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_AREA];
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;} cn;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			UINT32 percent;
			BOOL flgClick;
			INT32 flgsArBorder;
			st_Image tmp;
			st_Image shw;} pc;
	
	HWND hWnd;
	HWND hPd[2];
	HWND hEdit[4];
	HWND hBtn[2];
	HWND hCn;
	HWND hPc;
	
	LRESULT (CALLBACK *pCallEdit[4]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn [2]) (HWND,UINT,WPARAM,LPARAM);
} ar[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void ArInitClass(void);
void ArInit(LONG);
void ArInst(LONG);
void ArDialog(LONG);
LRESULT CALLBACK ArWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ArWndProcPd    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ArWndProcEditX1(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ArWndProcEditY1(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ArWndProcEditX2(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ArWndProcEditY2(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ArWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ArWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ArWndProcPc    (HWND, UINT, WPARAM, LPARAM);
void ArSize         (LONG, WPARAM, LPARAM);
void ArGetMinMaxInfo(LONG, WPARAM, LPARAM);
void ArSetFocus     (LONG, WPARAM, LPARAM);
void ArKeyDown      (LONG, WPARAM, LPARAM, HWND);
void ArKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void ArKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void ArKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void ArKeyDownF5    (LONG, WPARAM, LPARAM, HWND);
void ArKeyDownUpDw  (LONG, WPARAM, LPARAM, HWND);
void ArKeyDownRtLf  (LONG, WPARAM, LPARAM, HWND);
void ArClose        (LONG, WPARAM, LPARAM);
void ArDestroy      (LONG, WPARAM, LPARAM);
void ArPdCommand    (LONG, WPARAM, LPARAM);
void ArPdPaint      (LONG, WPARAM, LPARAM);
void ArEdSetFocus   (LONG, WPARAM, LPARAM, HWND);
void ArEdKillFocus  (LONG, WPARAM, LPARAM, HWND);
BOOL ArEdChar       (LONG, LONG, WPARAM, LPARAM);
void ArPcPaint      (LONG, WPARAM, LPARAM);
void ArPcMouseMove  (LONG, WPARAM, LPARAM);
void ArPcLButtonDown(LONG, WPARAM, LPARAM);
void ArPcLButtonUp  (LONG, WPARAM, LPARAM);
void ArEnterOk(LONG);
void ArEnterCan(LONG);
void ArUpdate(LONG);
void ArTmpCreate(LONG, INT32, INT32, INT32);
void ArTmpDelete(LONG);
void ArShadowCreate(LONG, INT32, INT32);
void ArShadowDelete(LONG);
void ArShadow(LONG, HDC, HDC, INT32, INT32, INT32, INT32);
void ArBorder(LONG, HDC);
void ArSetCursor(LONG, INT32, INT32);
void ArMouse(LONG, INT32, INT32);
void ArLimitXy(LONG, INT32 *, INT32 *, INT32 *, INT32 *);
void ArImageView(LONG);
void ArSetPane(LONG);

/*------------------------------------------------------------------------------
    Fvoid ArInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void ArInitClass(void)
{
	WNDCLASS wc;
	WNDCLASS wcPd;
	WNDCLASS wcCn;
	WNDCLASS wcPc;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_AREA,  &wc);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_AREAPD,&wcPd);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_AREACN,&wcCn);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrNull,  NM_AREAPC,&wcPc);
	
	RegisterClass(&wc);
	RegisterClass(&wcPd);
	RegisterClass(&wcCn);
	RegisterClass(&wcPc);
}

/*------------------------------------------------------------------------------
    Fvoid ArInit(LONG)
    FLONG    FORM ID
    @\F͈͏
------------------------------------------------------------------------------*/
void ArInit(LONG id)
{
	INT32 i;
	
	ar[id].x1  = 0;
	ar[id].y1  = 0;
	ar[id].x2  = 0;
	ar[id].y2  = 0;
	
	ar[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_AREA; i++) {ar[id].tabStops[i] = NULL;}
	
	ar[id].cn.x = 0;
	ar[id].cn.y = 0;
	ar[id].cn.w = 0;
	ar[id].cn.h = 0;
	
	ar[id].pc.x         = 0;
	ar[id].pc.y         = 0;
	ar[id].pc.w         = 0;
	ar[id].pc.h         = 0;
	ar[id].pc.percent   = 0;
	ar[id].pc.flgClick  = FALSE;
	ar[id].pc.flgsArBorder= 0;
	InitImg(&ar[id].pc.tmp);
	InitImg(&ar[id].pc.shw);
	
	ar[id].hWnd = NULL;
	for (i = 0; i < 2; i++) {ar[id].hPd  [i] = NULL;}
	for (i = 0; i < 4; i++) {ar[id].hEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {ar[id].hBtn [i] = NULL;}
	ar[id].hCn  = NULL;
	ar[id].hPc  = NULL;
	for (i = 0; i < 4; i++) {ar[id].pCallEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {ar[id].pCallBtn [i] = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid ArInst(LONG)
    FLONG      FORM ID
    @\FAREẢ
------------------------------------------------------------------------------*/
void ArInst(LONG id)
{
	DWORD styleAr = WS_OVERLAPPED|WS_CAPTION|WS_MAXIMIZEBOX|WS_THICKFRAME|WS_SYSMENU;
	DWORD stylePd1= WS_CHILD|WS_VISIBLE;
	DWORD stylePd2= WS_CHILD;
	DWORD styleEd = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleBt = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD styleCn = WS_CHILD|WS_CLIPCHILDREN;
	DWORD stylePc = WS_CHILD;
	INT32 x[4] = {61,61,61, 61,};
	INT32 y[4] = {12,42,72,102,};
	INT32 w;
	WCHAR buff[4][10+1];
	
	ar[id].x1 = 0;
	ar[id].y1 = 0;
	ar[id].x2 = fm[id].pc[0].img.w-1;
	ar[id].y2 = fm[id].pc[0].img.h-1;
	_itow(ar[id].x1, buff[0], 10);
	_itow(ar[id].y1, buff[1], 10);
	_itow(ar[id].x2, buff[2], 10);
	_itow(ar[id].y2, buff[3], 10);
	
	w = SZ_WEDIT2-PADD8*2;
	ar[id].hWnd     = a_CreateWindow(NM_AREA,  TxTl(E_TTLARA),styleAr, 0,   0,   0, 0,  fm[id].hWnd);
	ar[id].hPd[0]   = a_CreateWindow(NM_AREAPD,NULL,          stylePd1,8,   8,   w, 166,ar[id].hWnd);
	ar[id].hPd[1]   = a_CreateWindow(NM_AREAPD,NULL,          stylePd2,0,   0,   0, 0,  ar[id].hWnd);
	ar[id].hEdit[0] = a_CreateWindow(L"Edit",  buff[0],       styleEd, x[0],y[0],65,17, ar[id].hPd[0]);
	ar[id].hEdit[1] = a_CreateWindow(L"Edit",  buff[1],       styleEd, x[1],y[1],65,17, ar[id].hPd[0]);
	ar[id].hEdit[2] = a_CreateWindow(L"Edit",  buff[2],       styleEd, x[2],y[2],65,17, ar[id].hPd[0]);
	ar[id].hEdit[3] = a_CreateWindow(L"Edit",  buff[3],       styleEd, x[3],y[3],65,17, ar[id].hPd[0]);
	ar[id].hBtn[0]  = a_CreateWindow(L"Button",TxEd(E_OK),    styleBt, 10,  132, 70,25, ar[id].hPd[0]);
	ar[id].hBtn[1]  = a_CreateWindow(L"Button",TxEd(E_CANCEL),styleBt, 90,  132, 70,25, ar[id].hPd[0]);
	ar[id].hCn      = a_CreateWindow(NM_AREACN,NULL,          styleCn, 0,   0,   0, 0,  ar[id].hPd[1]);
	ar[id].hPc      = a_CreateWindow(NM_AREAPC,NULL,          stylePc, 0,   0,   0, 0,  ar[id].hCn);
	
	SetWindowLong(ar[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(ar[id].hPd[0],   GWL_USERDATA, 0*100+id);
	SetWindowLong(ar[id].hPd[1],   GWL_USERDATA, 1*100+id);
	SetWindowLong(ar[id].hEdit[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(ar[id].hEdit[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(ar[id].hEdit[2], GWL_USERDATA, 2*100+id);
	SetWindowLong(ar[id].hEdit[3], GWL_USERDATA, 3*100+id);
	SetWindowLong(ar[id].hBtn[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(ar[id].hBtn[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(ar[id].hPc,      GWL_USERDATA, id);
	
	SetWindowLong(ar[id].hWnd,   GWL_WNDPROC, (LONG)ArWndProc);
	SetWindowLong(ar[id].hPd[0], GWL_WNDPROC, (LONG)ArWndProcPd);
	SetWindowLong(ar[id].hPd[1], GWL_WNDPROC, (LONG)ArWndProcPd);
	SetWindowLong(ar[id].hPc,    GWL_WNDPROC, (LONG)ArWndProcPc);
	
	E_SETLIMITTEXT(ar[id].hEdit[0], 4);
	E_SETLIMITTEXT(ar[id].hEdit[1], 4);
	E_SETLIMITTEXT(ar[id].hEdit[2], 4);
	E_SETLIMITTEXT(ar[id].hEdit[3], 4);
	
	E_SETFONT(ar[id].hEdit[0], hFtCourier);
	E_SETFONT(ar[id].hEdit[1], hFtCourier);
	E_SETFONT(ar[id].hEdit[2], hFtCourier);
	E_SETFONT(ar[id].hEdit[3], hFtCourier);
	B_SETFONT(ar[id].hBtn [0], hFtArial14);
	B_SETFONT(ar[id].hBtn [1], hFtArial14);
	
	ar[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(ar[id].hEdit[0], GWL_WNDPROC);
	ar[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(ar[id].hEdit[1], GWL_WNDPROC);
	ar[id].pCallEdit[2] = (CALLFUNC)GetWindowLong(ar[id].hEdit[2], GWL_WNDPROC);
	ar[id].pCallEdit[3] = (CALLFUNC)GetWindowLong(ar[id].hEdit[3], GWL_WNDPROC);
	ar[id].pCallBtn [0] = (CALLFUNC)GetWindowLong(ar[id].hBtn [0], GWL_WNDPROC);
	ar[id].pCallBtn [1] = (CALLFUNC)GetWindowLong(ar[id].hBtn [1], GWL_WNDPROC);
	SetWindowLong(ar[id].hEdit[0], GWL_WNDPROC, (LONG)ArWndProcEditX1);
	SetWindowLong(ar[id].hEdit[1], GWL_WNDPROC, (LONG)ArWndProcEditY1);
	SetWindowLong(ar[id].hEdit[2], GWL_WNDPROC, (LONG)ArWndProcEditX2);
	SetWindowLong(ar[id].hEdit[3], GWL_WNDPROC, (LONG)ArWndProcEditY2);
	SetWindowLong(ar[id].hBtn [0], GWL_WNDPROC, (LONG)ArWndProcBtnOk);
	SetWindowLong(ar[id].hBtn [1], GWL_WNDPROC, (LONG)ArWndProcBtnCan);
	
	ar[id].tabStopIdx = 0;
	ar[id].tabStops[0] = ar[id].hEdit[0];
	ar[id].tabStops[1] = ar[id].hEdit[1];
	ar[id].tabStops[2] = ar[id].hEdit[2];
	ar[id].tabStops[3] = ar[id].hEdit[3];
	ar[id].tabStops[4] = ar[id].hBtn[0];
	ar[id].tabStops[5] = ar[id].hBtn[1];
	
	SetFocus  (ar[id].hEdit[0]);
	EditSelAll(ar[id].hEdit[0]);
}

/*------------------------------------------------------------------------------
    Fvoid ArDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void ArDialog(LONG id)
{
	ArInit(id);
	ArInst(id);
	PpPlacement(id, ar[id].hWnd);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = ar[id].hWnd;
	
	ShowWindow(ar[id].hPd[1], 0x1);
	ShowWindow(ar[id].hCn,    0x1);
	ShowWindow(ar[id].hPc,    0x1);
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK ArWndProc(,,,)
    F-
    ߒlF-
    @\FAR Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK ArWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SIZE:           ArSize         (id, wp, lp);  break;
	case WM_GETMINMAXINFO:  ArGetMinMaxInfo(id, wp, lp);  break;
	case WM_SETFOCUS:       ArSetFocus     (id, wp, lp);  break;
	case WM_CLOSE:          ArClose        (id, wp, lp);  break;
	case WM_DESTROY:        ArDestroy      (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK ArWndProcPd(,,,)
    F-
    ߒlF-
    @\FPDCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK ArWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idP;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:
		if (idP == 0) {
			ArPdCommand(id, wp, lp);
		}
		break;
	case WM_PAINT:
		if (idP == 0) {
			ArPdPaint(id, wp, lp);
		}
		break;
	default:  break;
	}
	
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK ArWndProcEditX1(,,,)
    F-
    ߒlF-
    @\FEDIT X1Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK ArWndProcEditX1(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   ArEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  ArEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		ArKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (ArEdChar(id, idE, wp, lp) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return ar[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK ArWndProcEditY1(,,,)
    F-
    ߒlF-
    @\FEDIT Y1Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK ArWndProcEditY1(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   ArEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  ArEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		ArKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (ArEdChar(id, idE, wp, lp) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return ar[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK ArWndProcEditX2(,,,)
    F-
    ߒlF-
    @\FEDIT X2Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK ArWndProcEditX2(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   ArEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  ArEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		ArKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (ArEdChar(id, idE, wp, lp) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return ar[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK ArWndProcEditY2(,,,)
    F-
    ߒlF-
    @\FEDIT Y2Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK ArWndProcEditY2(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   ArEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  ArEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		ArKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (ArEdChar(id, idE, wp, lp) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return ar[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK ArWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FBTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK ArWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  ArEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   ArKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return ar[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK ArWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FBTN CANCELCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK ArWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  ArEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   ArKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return ar[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK ArWndProcPc(,,,)
    F-
    ߒlF-
    @\FPCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK ArWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        ArPcPaint      (id, wp, lp);  break;
	case WM_MOUSEMOVE:    ArPcMouseMove  (id, wp, lp);  break;
	case WM_LBUTTONDOWN:  ArPcLButtonDown(id, wp, lp);  break;
	case WM_LBUTTONUP:    ArPcLButtonUp  (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid ArSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_SIZECxg
------------------------------------------------------------------------------*/
void ArSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	INT32 x1, y1, w1, h1;
	INT32 x2, y2, w2, h2;
	INT32 mode;
	
	if (fm[id].cntSkipEdit != 0) {fm[id].cntSkipEdit--;  return;}
	
	GetClientRect(ar[id].hWnd, &rc);
	a_SetWindowPos(ar[id].hPd[1], SZ_WEDIT2, PADD8, rc.right-SZ_WEDIT2-PADD8, rc.bottom-PADD8*2);
	
	ArSetPane(id);
	ArImageView(id);
	
	x2 = 0;
	y2 = 0;
	w2 = ar[id].pc.w;
	h2 = ar[id].pc.h;
	x1 = 0;
	y1 = 0;
	w1 = fm[id].pc[0].img.w;
	h1 = fm[id].pc[0].img.h;
	
	if (ar[id].pc.percent < 10000) {mode = HALFTONE;}
	else                              {mode = COLORONCOLOR;}
	
	ArTmpDelete(id);
	ArShadowDelete(id);
	ArTmpCreate(id, w2, h2, mode);
	ArShadowCreate(id, w2, h2);
	StretchBlt(ar[id].pc.tmp.hdc,    x2, y2, w2, h2,
			   fm[id].pc[0].img.hdc, x1, y1, w1, h1, SRCCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w2;
	rc.bottom = h2;
	FrameRect(ar[id].pc.tmp.hdc, &rc, hBrGray);
	
	a_SetWindowPos(ar[id].hPc, ar[id].pc.x, ar[id].pc.y,
							   ar[id].pc.w, ar[id].pc.h);
	
	InvalidateRect(ar[id].hWnd,   NULL, TRUE);
	InvalidateRect(ar[id].hPd[1], NULL, TRUE);
	InvalidateRect(ar[id].hCn,    NULL, TRUE);
	InvalidateRect(ar[id].hPc,    NULL, FALSE);
	UpdateWindow(ar[id].hWnd);
	UpdateWindow(ar[id].hPd[1]);
	UpdateWindow(ar[id].hCn);
	UpdateWindow(ar[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid ArGetMinMaxInfo(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void ArGetMinMaxInfo(LONG id, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	INT32 w;
	INT32 h;
	
	w = SZ_WEDIT2+PADD8*3+GetSystemMetrics(SM_CYSIZEFRAME)*2;
	h = 166      +PADD8*2+GetSystemMetrics(SM_CYSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = w;
	mmi->ptMinTrackSize.y = h;
}

/*------------------------------------------------------------------------------
    Fvoid ArSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void ArSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(ar[id].tabStops[ar[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid ArKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FWM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void ArKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  ArKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    ArKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    ArKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_F5:     ArKeyDownF5   (id, wp, lp, hWnd);  break;
	case KEY_UP:
	case KEY_DW:     ArKeyDownUpDw (id, wp, lp, hWnd);  break;
	case KEY_RT:
	case KEY_LF:     ArKeyDownRtLf (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid ArKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[enter]L[Cxg
------------------------------------------------------------------------------*/
void ArKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == ar[id].hBtn[1]) {ArEnterCan(id);}
	else                        {ArEnterOk(id);}
}

/*------------------------------------------------------------------------------
    Fvoid ArKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[esc]L[Cxg
------------------------------------------------------------------------------*/
void ArKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(ar[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid ArKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[tab]L[Cxg
------------------------------------------------------------------------------*/
void ArKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (ar[id].tabStopIdx == 0) {ar[id].tabStopIdx = TBSP_AREA-1;}
		else                        {ar[id].tabStopIdx--;}
	}
	else {
		ar[id].tabStopIdx = (ar[id].tabStopIdx + 1) % TBSP_AREA;
	}
	SetFocus(ar[id].tabStops[ar[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid ArKeyDownF5(LONG, WPARAM, LPARAM, HWND hWnd)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FKEY_F5Cxg
------------------------------------------------------------------------------*/
void ArKeyDownF5(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	ArUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid ArKeyDownUpDw(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[][]L[Cxg
------------------------------------------------------------------------------*/
void ArKeyDownUpDw(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	LONG idE;
	INT16 tmp;
	UINT16 comb;
	BOOL shift;
	WCHAR text[4+1];
	INT32 val;
	INT32 valTmp;
	INT32 limL;
	INT32 limH;
	INT32 step;
	POINT pt;
	RECT rc;
	
	comb  = 0x000;
	shift = FALSE;
	tmp = GetKeyState(KEY_CTRL);   if((tmp & 0x80)!=0){comb |= 0x100;}
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){comb |= 0x010;  shift = TRUE;}
	
	if      (comb == 0x000) {step = 1;}
	else if (comb == 0x100) {step = 10;}
	else if (comb == 0x010) {step = 100;}
	else                    {return;}
	
	if      (hWnd == ar[id].hBtn [0]) {return;}
	else if (hWnd == ar[id].hBtn [1]) {return;}
	else if (hWnd == ar[id].hEdit[0]) {idE = 0;}
	else if (hWnd == ar[id].hEdit[1]) {idE = 1;}
	else if (hWnd == ar[id].hEdit[2]) {idE = 2;}
	else if (hWnd == ar[id].hEdit[3]) {idE = 3;}
	
	GetWindowText(hWnd, text, 4+1);
	val = _wtoi(text);
	valTmp = val;
	
	limL = 0;
	if ((idE == 0) || (idE == 2)) {limH = fm[id].pc[0].img.w-1;}
	else                          {limH = fm[id].pc[0].img.h-1;}
	
	if      (idE == 0) {limH = ar[id].x2;}
	else if (idE == 1) {limH = ar[id].y2;}
	
	if      (idE == 2) {limL = ar[id].x1;}
	else if (idE == 3) {limL = ar[id].y1;}
	
	if (wp == KEY_UP) {val += step;}
	else              {val -= step;}
	
	if (val < limL) {val = limL;}
	if (limH < val) {val = limH;}
	
	switch (idE) {
	case 0:  ar[id].x1 = val;  break;
	case 1:  ar[id].y1 = val;  break;
	case 2:  ar[id].x2 = val;  break;
	case 3:  ar[id].y2 = val;  break;
	default: break;
	}
	
	if (valTmp == val) {return;}
	
	InvalidateRect(ar[id].hPc, NULL, FALSE);
	UpdateWindow(ar[id].hPc);
	
	_itow(val, text, 10);
	SetWindowText(hWnd, text);
	EditSelAll(hWnd);
	
	GetCursorPos(&pt);
	GetWindowRect(ar[id].hPc, &rc);
	ArSetCursor(id, pt.x - rc.left, pt.y - rc.top);
}

/*------------------------------------------------------------------------------
    Fvoid ArKeyDownRtLf(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[][]L[Cxg
------------------------------------------------------------------------------*/
void ArKeyDownRtLf(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == ar[id].hBtn[0]) {
		if (wp == KEY_RT) {
			ar[id].tabStopIdx++;
			SetFocus(ar[id].tabStops[ar[id].tabStopIdx]);
		}
	}
	else if (hWnd == ar[id].hBtn[1]) {
		if (wp == KEY_LF) {
			ar[id].tabStopIdx--;
			SetFocus(ar[id].tabStops[ar[id].tabStopIdx]);
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid ArClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_CLOSECxg
------------------------------------------------------------------------------*/
void ArClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid ArDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_DESTROYCxg
------------------------------------------------------------------------------*/
void ArDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	ArTmpDelete(id);
	ArShadowDelete(id);
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid ArPdCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPD WM_COMMANDCxg
------------------------------------------------------------------------------*/
void ArPdCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if      ((HWND)lp == ar[id].hBtn[0]) {ArEnterOk(id);}
	else if ((HWND)lp == ar[id].hBtn[1]) {ArEnterCan(id);}
}

/*------------------------------------------------------------------------------
    Fvoid ArPdPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPD WM_PAINTCxg
------------------------------------------------------------------------------*/
void ArPdPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	
	hdc = BeginPaint(ar[id].hPd[0], &ps);
	GetClientRect(ar[id].hPd[0], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	a_TextOut(hdc, 33, 13, L"X1");
	a_TextOut(hdc, 33, 43, L"Y1");
	a_TextOut(hdc, 33, 73, L"X2");
	a_TextOut(hdc, 33,103, L"Y2");
	
	SelectClipRgn(hdc, NULL);
	EndPaint(ar[id].hPd[0], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid ArEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FEDIT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void ArEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_AREA; i++) {
		if (hWnd == ar[id].tabStops[i]) {
			ar[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid ArEdKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FEDIT WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void ArEdKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_AREA; i++) {
		if ((HWND)wp == ar[id].tabStops[i]) {
			ArUpdate(id);
			break;
		}
	}
}

/*------------------------------------------------------------------------------
    FBOOL ArEdChar(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    EDIT ID
          WPARAM  -
          LPARAM  -
    ߒlFBOOL    -
    @\FEDIT WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL ArEdChar(LONG id, LONG idE, WPARAM wp, LPARAM lp)
{
	if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	
	switch (wp) {
	case 0x03:		// ctrl+C
	case 0x08:		// back space
	case 0x16:		// ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid ArPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_PAINTCxg
------------------------------------------------------------------------------*/
void ArPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	INT32 x, y;
	INT32 w, h;
	INT32 x1, y1, x2, y2;
	RECT rc;
	st_Image img;
	
	hdc = BeginPaint(ar[id].hPc, &ps);
	GetClientRect(ar[id].hPc, &rc);
	SetClipRgn(hdc, &rc);
	ImageCreate(&img, ar[id].pc.w, ar[id].pc.h);
	
	BitBlt(img.hdc,           0, 0, ar[id].pc.w, ar[id].pc.h,
		   ar[id].pc.tmp.hdc, 0, 0, SRCCOPY);
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	x1 = (double)(ar[id].x1     * ar[id].pc.w) / fm[id].pc[0].img.w;
	y1 = (double)(ar[id].y1     * ar[id].pc.h) / fm[id].pc[0].img.h;
	x2 = (double)((ar[id].x2+1) * ar[id].pc.w) / fm[id].pc[0].img.w;
	y2 = (double)((ar[id].y2+1) * ar[id].pc.h) / fm[id].pc[0].img.h;
	ArLimitXy(id, &x1, &y1, &x2, &y2);
	
	x = 0;
	y = 0;
	w = ar[id].pc.w;
	h = y1;
	ArShadow(id, img.hdc, ar[id].pc.shw.hdc, x, y, w, h);
	x = 0;
	y = y1;
	w = x1;
	h = y2 - y1;
	ArShadow(id, img.hdc, ar[id].pc.shw.hdc, x, y, w, h);
	x = x2;
	y = y1;
	w = ar[id].pc.w - x2;
	h = y2 - y1;
	ArShadow(id, img.hdc, ar[id].pc.shw.hdc, x, y, w, h);
	x = 0;
	y = y2;
	w = ar[id].pc.w;
	h = ar[id].pc.h - y2;
	ArShadow(id, img.hdc, ar[id].pc.shw.hdc, x, y, w, h);
	
	BitBlt(hdc,     0, 0, ar[id].pc.w, ar[id].pc.h,
		   img.hdc, 0, 0, SRCCOPY);
	
	ArBorder(id, hdc);
	
	ImageDeleteSt(&img);
	SelectClipRgn(hdc, NULL);
	EndPaint(ar[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid ArPcMouseMove(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_MOUSEMOVECxg
------------------------------------------------------------------------------*/
void ArPcMouseMove(LONG id, WPARAM wp, LPARAM lp)
{
	INT16 x, y;
	RECT rc;
	
	x = LOWORD(lp);		// 16rbg([h)A32rbgi_u[hj
	y = HIWORD(lp);
	
	GetClientRect(ar[id].hPc, &rc);
//	if ((x < rc.left) || (rc.right  < x)) {return;}
//	if ((y < rc.top)  || (rc.bottom < y)) {return;}
	if (x < rc.left)   {x = rc.left;}
	if (rc.right < x)  {x = rc.right;}
	if (y < rc.top)    {y = rc.top;}
	if (rc.bottom < y) {y = rc.bottom;}
	
	if ((wp & MK_LBUTTON) != 0) {ArMouse(id, x, y);}
	else                        {ArSetCursor(id, x, y);}
}

/*------------------------------------------------------------------------------
    Fvoid ArPcLButtonDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void ArPcLButtonDown(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 x, y;
	INT32 x1, y1, x2, y2;
	INT32 x1L, x1H;
	INT32 y1L, y1H;
	INT32 x2L, x2H;
	INT32 y2L, y2H;
	
	ar[id].pc.flgClick = TRUE;
	
	x = LOWORD(lp);
	y = HIWORD(lp);
	
	SetCapture(ar[id].hPc);
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	x1 = (double)(ar[id].x1     * ar[id].pc.w) / fm[id].pc[0].img.w;
	y1 = (double)(ar[id].y1     * ar[id].pc.h) / fm[id].pc[0].img.h;
	x2 = (double)((ar[id].x2+1) * ar[id].pc.w) / fm[id].pc[0].img.w;
	y2 = (double)((ar[id].y2+1) * ar[id].pc.h) / fm[id].pc[0].img.h;
	x1L = x1 - 5;
	x1H = x1 + 5;
	y1L = y1 - 5;
	y1H = y1 + 5;
	x2L = x2 - 5;
	x2H = x2 + 5;
	y2L = y2 - 5;
	y2H = y2 + 5;
	
	ar[id].pc.flgsArBorder = 0;
	if ((x1L<x) && (x<x1H)) {
		if      ((y1L<y) && (y<y1H)) {ar[id].pc.flgsArBorder = BIT_WEST|BIT_NORTH;}
		else if ((y2L<y) && (y<y2H)) {ar[id].pc.flgsArBorder = BIT_WEST|BIT_SOUTH;}
		else                         {ar[id].pc.flgsArBorder = BIT_WEST;}
	}
	else if ((x2L<x) && (x<x2H)) {
		if      ((y1L<y) && (y<y1H)) {ar[id].pc.flgsArBorder = BIT_EAST|BIT_NORTH;}
		else if ((y2L<y) && (y<y2H)) {ar[id].pc.flgsArBorder = BIT_EAST|BIT_SOUTH;}
		else                         {ar[id].pc.flgsArBorder = BIT_EAST;}
	}
	else if ((y1L<y) && (y<y1H)) {ar[id].pc.flgsArBorder = BIT_NORTH;}
	else if ((y2L<y) && (y<y2H)) {ar[id].pc.flgsArBorder = BIT_SOUTH;}
	
	ArSetCursor(id, x, y);
}

/*------------------------------------------------------------------------------
    Fvoid ArPcLButtonUp(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void ArPcLButtonUp(LONG id, WPARAM wp, LPARAM lp)
{
	ReleaseCapture();
	ar[id].pc.flgClick = FALSE;
}

/*------------------------------------------------------------------------------
    Fvoid ArEnterOk(LONG id)
    FLONG    FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void ArEnterOk(LONG id)
{
	WCHAR text[4][4+1];
	INT32 val[4];
	INT32 i, j;
	INT32 len;
	INT32 srcX1, srcY1, srcX2, srcY2;
	INT32 dstX1, dstY1, dstX2, dstY2;
	
	for (i = 0; i < 4; i++) {
		GetWindowText(ar[id].hEdit[i], text[i], 4+1);
		val[i] = _wtoi(text[i]);
	}
	
	for (i = 0; i < 4; i++) {
		len = wcslen(text[i]);
		for (j = 0; j < len; j++) {
			if ((text[i][j] < L'0') || (L'9' < text[i][j])) {
//				MessageBox(ar[id].hWnd, L"scope validation char", L_TITLE, MB_OK);
				CLOSE(ar[id].hWnd);
				return;
			}
		}
	}
	
	srcX1 = 0;
	srcY1 = 0;
	srcX2 = fm[id].pc[0].img.w - 1;
	srcY2 = fm[id].pc[0].img.h - 1;
	
	if ((val[0] < srcX1) ||
		(val[1] < srcY1) ||
		(srcX2 < val[2]) ||
		(srcY2 < val[3]) ||
		(val[0] > val[2]) || (val[1] > val[3]))
	{
//		MessageBox(ar[id].hWnd, L"scope validation value", L_TITLE, MB_OK);
		CLOSE(ar[id].hWnd);
		return;
	}
	
	if ((val[0] == srcX1) && (val[1] == srcY1) &&
		(val[2] == srcX2) && (val[3] == srcY2))
	{
//		MessageBox(ar[id].hWnd, L"scope validation equal", L_TITLE, MB_OK);
		CLOSE(ar[id].hWnd);
		return;
	}
	
	dstX1 = val[0];
	dstY1 = val[1];
	dstX2 = val[2];
	dstY2 = val[3];
	
	ImageTrim(&fm[id].pc[0].img, dstY1 - srcY1, srcY2 - dstY2, dstX1 - srcX1, srcX2 - dstX2);
	
	fm[id].pc[0].div = RAW;
	fm[id].flgArea   = TRUE;
	LiImageDelete(id, 0);
	
	MnFlushFile(id);
	
	SetAverageColor(id, 0);
	FmSizeNeutral(id, NULL, NULL);
	
	SbFlush(id);
	SetFormText(id);
	
	CLOSE(ar[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid ArEnterCan(LONG id)
    FLONG    FORM ID
    @\F[CANCEL]{^s
------------------------------------------------------------------------------*/
void ArEnterCan(LONG id)
{
	CLOSE(ar[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid ArUpdate(LONG id)
    FLONG    FORM ID
    @\F͈͂̕\XV
------------------------------------------------------------------------------*/
void ArUpdate(LONG id)
{
	WCHAR text[6];
	INT32 val;
	
	GetWindowText(ar[id].hEdit[0], text, 6);
	val = _wtoi(text);
	if (val < 0)                        {ar[id].x1 = 0;}
	else if (ar[id].x2 < val)           {ar[id].x1 = ar[id].x2;}
	else if (fm[id].pc[0].img.w <= val) {ar[id].x1 = fm[id].pc[0].img.w-1;}
	else                                {ar[id].x1 = val;}
	_itow(ar[id].x1, text, 10);
	SetWindowText(ar[id].hEdit[0], text);
	
	GetWindowText(ar[id].hEdit[1], text, 6);
	val = _wtoi(text);
	if (val < 0)                        {ar[id].y1 = 0;}
	else if (ar[id].y2 < val)           {ar[id].y1 = ar[id].y2;}
	else if (fm[id].pc[0].img.h <= val) {ar[id].y1 = fm[id].pc[0].img.h-1;}
	else                                {ar[id].y1 = val;}
	_itow(ar[id].y1, text, 10);
	SetWindowText(ar[id].hEdit[1], text);
	
	GetWindowText(ar[id].hEdit[2], text, 6);
	val = _wtoi(text);
	if (val < 0)                        {ar[id].x2 = 0;}
	else if (fm[id].pc[0].img.w <= val) {ar[id].x2 = fm[id].pc[0].img.w-1;}
	else if (val < ar[id].x1)           {ar[id].x2 = ar[id].x1;}
	else                                {ar[id].x2 = val;}
	_itow(ar[id].x2, text, 10);
	SetWindowText(ar[id].hEdit[2], text);
	
	GetWindowText(ar[id].hEdit[3], text, 6);
	val = _wtoi(text);
	if (val < 0)                        {ar[id].y2 = 0;}
	else if (fm[id].pc[0].img.h <= val) {ar[id].y2 = fm[id].pc[0].img.h-1;}
	else if (val < ar[id].y1)           {ar[id].y2 = ar[id].y1;}
	else                                {ar[id].y2 = val;}
	_itow(ar[id].y2, text, 10);
	SetWindowText(ar[id].hEdit[3], text);
	
	InvalidateRect(ar[id].hPc, NULL, FALSE);
}

/*------------------------------------------------------------------------------
    Fvoid ArTmpCreate(LONG, INT32, INT32, INT32)
    FLONG     FORM ID
          INT32    
          INT32    
          INT32    ][h
    @\F͈ ꎞC[W쐬
------------------------------------------------------------------------------*/
void ArTmpCreate(LONG id, INT32 w, INT32 h, INT32 mode)
{
	ImageCreate(&ar[id].pc.tmp, w, h);
	
	SetStretchBltMode(ar[id].pc.tmp.hdc, mode);
}

/*------------------------------------------------------------------------------
    Fvoid ArTmpDelete(LONG)
    FLONG     FORM ID
    @\F͈ ꎞC[W폜
------------------------------------------------------------------------------*/
void ArTmpDelete(LONG id)
{
	DeleteDC    (ar[id].pc.tmp.hdc);
	DeleteObject(ar[id].pc.tmp.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid ArShadowCreate(LONG, INT32, INT32)
    FLONG     FORM ID
          INT32    
          INT32    
    @\F͈ eC[W 쐬
------------------------------------------------------------------------------*/
void ArShadowCreate(LONG id, INT32 w, INT32 h)
{
	INT64 r, g, b;
	INT64 bright;
	BYTE color;
	
	ImageCreate(&ar[id].pc.shw, w, h);
	
	SetAverageColor(id, 0);
	r = (UINT8)fm[id].cn[0].avgRed;
	g = (UINT8)fm[id].cn[0].avgGreen;
	b = (UINT8)fm[id].cn[0].avgBlue;
	bright = (r + g + b) / 3;
	if (bright < 0x80) {color = 0xFF;}
	else               {color = 0x00;}
	
	memset(ar[id].pc.shw.pB, color, w * h * 4);
}

/*------------------------------------------------------------------------------
    Fvoid ArShadowDelete(LONG)
    FLONG     FORM ID
    @\F͈ eC[W  폜
------------------------------------------------------------------------------*/
void ArShadowDelete(LONG id)
{
	ImageDeleteSt(&ar[id].pc.shw);
}

/*------------------------------------------------------------------------------
    Fvoid ArShadow(LONG, HDC, HDC, INT32, INT32, INT32, INT32)
    FLONG    FORM ID
          HDC     -
          HDC     -
          INT32   -
          INT32   -
          INT32   -
          INT32   -
    @\F͈ e`
------------------------------------------------------------------------------*/
void ArShadow(LONG id, HDC hdcDst, HDC hdcSrc, INT32 x, INT32 y, INT32 w, INT32 h)
{
	BLENDFUNCTION blFunc;
	
	if (w <= 0) {return;}
	if (h <= 0) {return;}
	
	blFunc.BlendOp             = AC_SRC_OVER;
	blFunc.BlendFlags          = 0;
	blFunc.SourceConstantAlpha = 128;
	blFunc.AlphaFormat         = 0;
	
	AlphaBlend(hdcDst, x, y, w, h, hdcSrc, x, y, w, h, blFunc);
}

/*------------------------------------------------------------------------------
    Fvoid ArBorder(LONG id, HDC)
    FLONG    FORM ID
          HDC     -
    @\F͈ E`
------------------------------------------------------------------------------*/
void ArBorder(LONG id, HDC hdc)
{
	INT32 x1, y1, x2, y2;
	RECT rc;
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = ar[id].pc.tmp.w;
	rc.bottom = ar[id].pc.tmp.h;
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hPnBlack);
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	x1 = (double)(ar[id].x1     * ar[id].pc.w) / fm[id].pc[0].img.w;
	y1 = (double)(ar[id].y1     * ar[id].pc.h) / fm[id].pc[0].img.h;
	x2 = (double)((ar[id].x2+1) * ar[id].pc.w) / fm[id].pc[0].img.w;
	y2 = (double)((ar[id].y2+1) * ar[id].pc.h) / fm[id].pc[0].img.h;
	ArLimitXy(id, &x1, &y1, &x2, &y2);
	
	MoveToEx(hdc, x1, 0, NULL);
	LineTo  (hdc, x1, ar[id].pc.h);
	
	MoveToEx(hdc, 0,           y1, NULL);
	LineTo  (hdc, ar[id].pc.w, y1);
	
	if (ar[id].pc.w <= x2) {x2 = ar[id].pc.w-1;}
	MoveToEx(hdc, x2, 0, NULL);
	LineTo  (hdc, x2, ar[id].pc.h);
	
	if (ar[id].pc.h <= y2) {y2 = ar[id].pc.h-1;}
	MoveToEx(hdc, 0,           y2, NULL);
	LineTo  (hdc, ar[id].pc.w, y2);
	
	SelectClipRgn(hdc, NULL);
}

/*------------------------------------------------------------------------------
    Fvoid ArSetCursor(LONG id, INT32, INT32)
    FLONG    FORM ID
          INT32   XW
          INT32   YW
    @\F͈ J[\ύX
------------------------------------------------------------------------------*/
void ArSetCursor(LONG id, INT32 x, INT32 y)
{
	INT32 x1, y1, x2, y2;
	INT32 x1L, x1H;
	INT32 y1L, y1H;
	INT32 x2L, x2H;
	INT32 y2L, y2H;
	HCURSOR hCur;
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	x1 = (double)(ar[id].x1     * ar[id].pc.w) / fm[id].pc[0].img.w;
	y1 = (double)(ar[id].y1     * ar[id].pc.h) / fm[id].pc[0].img.h;
	x2 = (double)((ar[id].x2+1) * ar[id].pc.w) / fm[id].pc[0].img.w;
	y2 = (double)((ar[id].y2+1) * ar[id].pc.h) / fm[id].pc[0].img.h;
	x1L = x1-5;    x1H = x1+5;
	y1L = y1-5;    y1H = y1+5;
	x2L = x2-5;    x2H = x2+5;
	y2L = y2-5;    y2H = y2+5;
	
	hCur = hCurArrow;
	if ((x1L<x) && (x<x1H)) {
		if      ((y1L<y) && (y<y1H)) {hCur = hCurSzNwse;}
		else if ((y2L<y) && (y<y2H)) {hCur = hCurSzNesw;}
		else                         {hCur = hCurSzWe;}
	}
	else if ((x2L<x) && (x<x2H)) {
		if      ((y1L<y) && (y<y1H)) {hCur = hCurSzNesw;}
		else if ((y2L<y) && (y<y2H)) {hCur = hCurSzNwse;}
		else                         {hCur = hCurSzWe;}
	}
	else if ((y1L<y) && (y<y1H)) {hCur = hCurSzNs;}
	else if ((y2L<y) && (y<y2H)) {hCur = hCurSzNs;}
	SetCursor(hCur);
	SetClassLong(ar[id].hPc, GCL_HCURSOR, (LONG)hCur);
}

/*------------------------------------------------------------------------------
    Fvoid ArMouse(LONG id, INT32, INT32)
    FLONG    FORM ID
          INT32   XW
          INT32   YW
    @\F͈ }EX
------------------------------------------------------------------------------*/
void ArMouse(LONG id, INT32 x, INT32 y)
{
	WCHAR text[4+1];
	INT32 val;
	HWND hWnd;
	
	if (ar[id].pc.flgClick == FALSE) {return;}
	if (ar[id].pc.flgsArBorder == 0)   {return;}
	
	if (IsBit(ar[id].pc.flgsArBorder, BIT_SOUTH)) {
		TryZeroDivision(ar[id].pc.h);
		y = (double)(y * fm[id].pc[0].img.h+1) / ar[id].pc.h;
		if (y < ar[id].y1) {ar[id].y2 = ar[id].y1;}
		else                  {ar[id].y2 = y;}
		val = ar[id].y2;
		if (fm[id].pc[0].img.h <= val) {val = fm[id].pc[0].img.h-1;}
		hWnd = ar[id].hEdit[3];
		_itow(val, text, 10);
		SetWindowText(hWnd, text);
	}
	if (IsBit(ar[id].pc.flgsArBorder, BIT_EAST)) {
		TryZeroDivision(ar[id].pc.w);
		x = (double)(x * fm[id].pc[0].img.w+1) / ar[id].pc.w;
		if (x < ar[id].x1) {ar[id].x2 = ar[id].x1;}
		else                  {ar[id].x2 = x;}
		val = ar[id].x2;
		if (fm[id].pc[0].img.w <= val) {val = fm[id].pc[0].img.w-1;}
		hWnd = ar[id].hEdit[2];
		_itow(val, text, 10);
		SetWindowText(hWnd, text);
	}
	if (IsBit(ar[id].pc.flgsArBorder, BIT_NORTH)) {
		TryZeroDivision(ar[id].pc.h);
		y = (double)(y * fm[id].pc[0].img.h) / ar[id].pc.h;
		if (ar[id].y2 < y) {ar[id].y1 = ar[id].y2;}
		else                  {ar[id].y1 = y;}
		val = ar[id].y1;
		hWnd = ar[id].hEdit[1];
		_itow(val, text, 10);
		SetWindowText(hWnd, text);
	}
	if (IsBit(ar[id].pc.flgsArBorder, BIT_WEST)) {
		TryZeroDivision(ar[id].pc.w);
		x = (double)(x * fm[id].pc[0].img.w) / ar[id].pc.w;
		if (ar[id].x2 < x) {ar[id].x1 = ar[id].x2;}
		else                  {ar[id].x1 = x;}
		val = ar[id].x1;
		hWnd = ar[id].hEdit[0];
		_itow(val, text, 10);
		SetWindowText(hWnd, text);
	}
	InvalidateRect(ar[id].hPc, NULL, FALSE);
}

/*------------------------------------------------------------------------------
    Fvoid ArLimitXy(-)
    F-
    @\F͈ W𐧌
------------------------------------------------------------------------------*/
void ArLimitXy(LONG id, INT32 *pX1, INT32 *pY1, INT32 *pX2, INT32 *pY2)
{
	if (*pX1 < 0) {*pX1 = 0;}
	if (*pY1 < 0) {*pY1 = 0;}
	if (*pX2 < 0) {*pX2 = 0;}
	if (*pY2 < 0) {*pY2 = 0;}
	if (ar[id].pc.w <= *pX1) {*pX1 = ar[id].pc.w-1;}
	if (ar[id].pc.h <= *pY1) {*pY1 = ar[id].pc.h-1;}
	if (ar[id].pc.w <= *pX2) {*pX2 = ar[id].pc.w-1;}
	if (ar[id].pc.h <= *pY2) {*pY2 = ar[id].pc.h-1;}
}

/*------------------------------------------------------------------------------
    Fvoid ArImageView(LONG)
    FLONG    FORM ID
    @\F͈͕\p
------------------------------------------------------------------------------*/
void ArImageView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	
	if (IsBit(fm[id].pc[0].img.stat, BIT_NONE|BIT_FAILURE)) {return;}
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	gainW = (double)ar[id].cn.w / fm[id].pc[0].img.w;
	gainH = (double)ar[id].cn.h / fm[id].pc[0].img.h;
	
	if (CmpGain(gainW, gainH) == TRUE) {
		limW = TRUE;
		limH = TRUE;
	}
	else {
		if (gainW < gainH) {
			gainH = gainW;
			limW = TRUE;
		}
		else {
			gainW = gainH;
			limH = TRUE;
		}
	}
	
	x = (double)ar[id].cn.w / 2 - (double)fm[id].pc[0].img.w * gainW / 2;
	y = (double)ar[id].cn.h / 2 - (double)fm[id].pc[0].img.h * gainH / 2;
	w = (double)fm[id].pc[0].img.w * gainW;
	h = (double)fm[id].pc[0].img.h * gainH;
	
	if (limW == TRUE) {x = 0;  w = ar[id].cn.w;}
	if (limH == TRUE) {y = 0;  h = ar[id].cn.h;}
	
	if (limW == TRUE) {TryZeroDivision(fm[id].pc[0].img.w);  ar[id].pc.percent = ((double)w / fm[id].pc[0].img.w) * 10000;}
	else              {TryZeroDivision(fm[id].pc[0].img.h);  ar[id].pc.percent = ((double)h / fm[id].pc[0].img.h) * 10000;}
	
	ar[id].pc.x = x;
	ar[id].pc.y = y;
	if (w <= 0) {ar[id].pc.w = 1;}
	else        {ar[id].pc.w = w;}
	if (h <= 0) {ar[id].pc.h = 1;}
	else        {ar[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    Fvoid ArSetPane(LONG)
    FLONG    FORM ID
    @\F͈͂̕\̘g\
------------------------------------------------------------------------------*/
void ArSetPane(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(ar[id].hPd[1], &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	a_SetWindowPos(ar[id].hCn, PADD8, PADD8, w-PADD8*2, h-PADD8*2);
	
	GetClientRect(ar[id].hCn, &rc);
	ar[id].cn.x = rc.left;
	ar[id].cn.y = rc.top;
	ar[id].cn.w = rc.right - rc.left;
	ar[id].cn.h = rc.bottom - rc.top;
}
