/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define DM_CPP
#include "../common.h"
//  DeformFό`

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 w;
	INT32 h;
	BOOL asp;
	HWND hCur;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_DEFORM];
	
	HWND hWnd;
	HWND hEdit[2];
	HWND hChk;
	HWND hBtn[2];
	
	LRESULT (CALLBACK *pCallEdit[2]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallChk)     (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn[2])  (HWND,UINT,WPARAM,LPARAM);
} dm[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void DmInitClass(void);
void DmInit(LONG);
void DmInst(LONG);
void DmDialog(LONG);
void DmLoad(LONG);
void DmStore(LONG);
LRESULT CALLBACK DmWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DmWndProcEditW (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DmWndProcEditH (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DmWndProcChk   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DmWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DmWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
void DmPaint       (LONG, WPARAM, LPARAM);
void DmCommand     (LONG, WPARAM, LPARAM);
void DmSetFocus    (LONG, WPARAM, LPARAM);
void DmKeyDown     (LONG, WPARAM, LPARAM, HWND);
void DmKeyDownEnter(LONG, WPARAM, LPARAM, HWND);
void DmKeyDownEsc  (LONG, WPARAM, LPARAM, HWND);
void DmKeyDownTab  (LONG, WPARAM, LPARAM, HWND);
void DmKeyDownF5   (LONG, WPARAM, LPARAM, HWND);
void DmKeyDownUpDw (LONG, WPARAM, LPARAM, HWND);
void DmClose       (LONG, WPARAM, LPARAM);
void DmDestroy     (LONG, WPARAM, LPARAM);
void DmEdSetFocus  (LONG, WPARAM, LPARAM, HWND);
void DmEdKillFocus (LONG, WPARAM, LPARAM, HWND);
BOOL DmEdChar      (LONG, WPARAM, LPARAM);
void DmChSetCheck  (LONG, WPARAM, LPARAM);
void DmEnterOk(LONG);
void DmEnterCan(LONG);
void DmUpdate(LONG);

/*------------------------------------------------------------------------------
    Fvoid DmInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void DmInitClass(void)
{
	WNDCLASS wcDeform;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_DEFORM,&wcDeform);
	
	RegisterClass(&wcDeform);
}

/*------------------------------------------------------------------------------
    Fvoid DmInit(LONG)
    FLONG    FORM ID
    @\Fό`
------------------------------------------------------------------------------*/
void DmInit(LONG id)
{
	INT32 i;
	
	dm[id].w    = 0;
	dm[id].h    = 0;
	dm[id].asp  = FALSE;
	dm[id].hCur = NULL;
	
	dm[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_DEFORM; i++) {dm[id].tabStops[i] = NULL;}
	
	dm[id].hWnd = NULL;
	for (i = 0; i < 2; i++) {dm[id].hEdit[i] = NULL;}
	dm[id].hChk = NULL;
	for (i = 0; i < 2; i++) {dm[id].hBtn[i] = NULL;}
	
	for (i = 0; i < 2; i++) {dm[id].pCallEdit[i] = NULL;}
	dm[id].pCallChk = NULL;
	for (i = 0; i < 2; i++) {dm[id].pCallBtn[i] = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid DmInst(LONG)
    FLONG      FORM ID
    @\FDEFORM̉
------------------------------------------------------------------------------*/
void DmInst(LONG id)
{
	DWORD styleDm = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU;
	DWORD styleEd = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleCk = WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX;
	DWORD styleBt = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	INT32 y[2] = {22,52,};
	WCHAR buff[2][10+1];
	WPARAM wp;
	
	dm[id].w = fm[id].pc[0].img.w;
	dm[id].h = fm[id].pc[0].img.h;
	
	_itow(fm[id].pc[0].img.w, buff[0], 10);
	_itow(fm[id].pc[0].img.h, buff[1], 10);
	
	dm[id].hWnd     = a_CreateWindow(NM_DEFORM,TxTl(E_TTLDFM),  styleDm,0, 0,   0, 0, fm[id].hWnd);
	dm[id].hEdit[0] = a_CreateWindow(L"Edit",  buff[0],         styleEd,85,y[0],65,17,dm[id].hWnd);
	dm[id].hEdit[1] = a_CreateWindow(L"Edit",  buff[1],         styleEd,85,y[1],65,17,dm[id].hWnd);
	dm[id].hChk     = a_CreateWindow(L"Button",TxEd(E_DMASPECT),styleCk,50,79,  85,25,dm[id].hWnd);
	dm[id].hBtn[0]  = a_CreateWindow(L"Button",TxEd(E_OK),      styleBt,18,112, 70,25,dm[id].hWnd);
	dm[id].hBtn[1]  = a_CreateWindow(L"Button",TxEd(E_CANCEL),  styleBt,98,112, 70,25,dm[id].hWnd);
	
	SetWindowLong(dm[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(dm[id].hEdit[0], GWL_USERDATA, id);
	SetWindowLong(dm[id].hEdit[1], GWL_USERDATA, id);
	SetWindowLong(dm[id].hChk,     GWL_USERDATA, id);
	SetWindowLong(dm[id].hBtn[0],  GWL_USERDATA, id);
	SetWindowLong(dm[id].hBtn[1],  GWL_USERDATA, id);
	
	SetWindowLong(dm[id].hWnd, GWL_WNDPROC, (LONG)DmWndProc);
	
	E_SETLIMITTEXT(dm[id].hEdit[0], 4);
	E_SETLIMITTEXT(dm[id].hEdit[1], 4);
	
	E_SETFONT(dm[id].hEdit[0], hFtCourier);
	E_SETFONT(dm[id].hEdit[1], hFtCourier);
	B_SETFONT(dm[id].hChk,     hFtArial14);
	B_SETFONT(dm[id].hBtn[0],  hFtArial14);
	B_SETFONT(dm[id].hBtn[1],  hFtArial14);
	
	if (dm[id].asp) {wp = BST_CHECKED;} else {wp = BST_UNCHECKED;}
	B_SETCHECK(dm[id].hChk, wp);
	
	dm[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(dm[id].hEdit[0], GWL_WNDPROC);
	dm[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(dm[id].hEdit[1], GWL_WNDPROC);
	dm[id].pCallChk     = (CALLFUNC)GetWindowLong(dm[id].hChk,     GWL_WNDPROC);
	dm[id].pCallBtn[0]  = (CALLFUNC)GetWindowLong(dm[id].hBtn[0],  GWL_WNDPROC);
	dm[id].pCallBtn[1]  = (CALLFUNC)GetWindowLong(dm[id].hBtn[1],  GWL_WNDPROC);
	SetWindowLong(dm[id].hEdit[0], GWL_WNDPROC, (LONG)DmWndProcEditW);
	SetWindowLong(dm[id].hEdit[1], GWL_WNDPROC, (LONG)DmWndProcEditH);
	SetWindowLong(dm[id].hChk,     GWL_WNDPROC, (LONG)DmWndProcChk);
	SetWindowLong(dm[id].hBtn[0],  GWL_WNDPROC, (LONG)DmWndProcBtnOk);
	SetWindowLong(dm[id].hBtn[1],  GWL_WNDPROC, (LONG)DmWndProcBtnCan);
	
	dm[id].tabStopIdx = 0;
	dm[id].tabStops[0] = dm[id].hEdit[0];
	dm[id].tabStops[1] = dm[id].hEdit[1];
	dm[id].tabStops[2] = dm[id].hChk;
	dm[id].tabStops[3] = dm[id].hBtn[0];
	dm[id].tabStops[4] = dm[id].hBtn[1];
	
	SetFocus  (dm[id].hEdit[0]);
	EditSelAll(dm[id].hEdit[0]);
}

/*------------------------------------------------------------------------------
    Fvoid DmDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void DmDialog(LONG id)
{
	WINDOWPLACEMENT plcm;
	
	DmInit(id);
	DmLoad(id);
	DmInst(id);
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5 + 4;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + 190;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + 185;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(dm[id].hWnd, &plcm);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = dm[id].hWnd;
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid DmLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void DmLoad(LONG id)
{
	dm[id].asp = g_dmAsp;
}

/*------------------------------------------------------------------------------
    Fvoid DmStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void DmStore(LONG id)
{
	g_dmAsp = dm[id].asp;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK DmWndProc(,,,)
    F-
    ߒlF-
    @\FDEFORMCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK DmWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:     DmPaint   (id, wp, lp);  break;
	case WM_COMMAND:   DmCommand (id, wp, lp);  break;
	case WM_SETFOCUS:  DmSetFocus(id, wp, lp);  break;
	case WM_CLOSE:     DmClose   (id, wp, lp);  break;
	case WM_DESTROY:   DmDestroy (id, wp, lp);  break;
	case WM_CTLCOLORSTATIC:
		if ((HWND)lp == dm[id].hChk) {return (LRESULT)hBrWhite;}
		break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK DmWndProcEditW(,,,)
    F-
    ߒlF-
    @\FDEFORM EDIT Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK DmWndProcEditW(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:   DmEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  DmEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		DmKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (DmEdChar(id, wp, lp) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return dm[id].pCallEdit[0](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK DmWndProcEditH(,,,)
    F-
    ߒlF-
    @\FDEFORM EDIT Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK DmWndProcEditH(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:   DmEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  DmEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		DmKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (DmEdChar(id, wp, lp) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return dm[id].pCallEdit[1](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK DmWndProcChk(,,,)
    F-
    ߒlF-
    @\FDEFORM CHKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK DmWndProcChk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:  DmEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   DmKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	
	res = dm[id].pCallChk(hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  DmChSetCheck(id, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK DmWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FDEFORM BUTTON OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK DmWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  DmEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   DmKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	
	return dm[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK DmWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FDEFORM BUTTON CANCELCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK DmWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  DmEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   DmKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	
	return dm[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid DmPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FDEFORM WM_PAINTCxg
------------------------------------------------------------------------------*/
void DmPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1;
	INT32 x2, y2;
	
	hdc = BeginPaint(dm[id].hWnd, &ps);
	GetClientRect(dm[id].hWnd, &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hBrWhite);
	SelectObject(hdc, hFtArial14);
	
	PatBlt(hdc, rc.left+PADD8,
				rc.top+PADD8,
				rc.right-rc.left-PADD8*2,
				rc.bottom-rc.top-PADD8*2, PATCOPY);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	switch (g_idxLang) {
	case 0:  x1 = 48;  x2 = 48;  break;
	case 1:  x1 = 37;  x2 = 37;  break;
	default: break;
	}
	
	y1 = 23;
	y2 = 53;
	a_TextOut(hdc, x1, y1, TxEd(E_DMWIDTH));
	a_TextOut(hdc, x2, y2, TxEd(E_DMHEIGHT));
	
	SelectClipRgn(hdc, NULL);
	EndPaint(dm[id].hWnd, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid DmCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FDEFORM WM_COMMANDCxg
------------------------------------------------------------------------------*/
void DmCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if      ((HWND)lp == dm[id].hBtn[0]) {DmEnterOk(id);}
	else if ((HWND)lp == dm[id].hBtn[1]) {DmEnterCan(id);}
}

/*------------------------------------------------------------------------------
    Fvoid DmSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FDEFORM WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void DmSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(dm[id].tabStops[dm[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid DmKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FDEFORM WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void DmKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  DmKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    DmKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    DmKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_F5:     DmKeyDownF5   (id, wp, lp, hWnd);  break;
	case KEY_UP:
	case KEY_DW:     DmKeyDownUpDw (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid DmKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FDEFORM [enter]Cxg
------------------------------------------------------------------------------*/
void DmKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == dm[id].hBtn[1]) {DmEnterCan(id);}
	else                        {DmEnterOk(id);}
}

/*------------------------------------------------------------------------------
    Fvoid DmKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FDEFORM [esc]Cxg
------------------------------------------------------------------------------*/
void DmKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(dm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid DmKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FDEFORM [tab]Cxg
------------------------------------------------------------------------------*/
void DmKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (dm[id].tabStopIdx == 0) {dm[id].tabStopIdx = TBSP_DEFORM-1;}
		else                        {dm[id].tabStopIdx--;}
	}
	else {
		dm[id].tabStopIdx = (dm[id].tabStopIdx + 1) % TBSP_DEFORM;
	}
	SetFocus(dm[id].tabStops[dm[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid DmKeyDownF5(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FDEFORM [F5]Cxg
------------------------------------------------------------------------------*/
void DmKeyDownF5(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	DmUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid DmKeyDownUpDw(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FDEFORM [][]Cxg
------------------------------------------------------------------------------*/
void DmKeyDownUpDw(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT16 tmp;
	UINT16 comb;
	BOOL shift;
	WCHAR text[4+1];
	INT32 val;
	INT32 valTmp;
	INT32 limL;
	INT32 limH;
	INT32 step;
	
	comb  = 0x000;
	shift = FALSE;
	tmp = GetKeyState(KEY_CTRL);   if((tmp & 0x80)!=0){comb |= 0x100;}
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){comb |= 0x010;  shift = TRUE;}
	
	if ((hWnd != dm[id].hEdit[0]) &&
		(hWnd != dm[id].hEdit[1])) {return;}
	
	if      (comb == 0x000) {step = 1;}
	else if (comb == 0x100) {step = 10;}
	else if (comb == 0x010) {step = 100;}
	else                    {return;}
	
	GetWindowText(hWnd, text, 4+1);
	val = _wtoi(text);
	valTmp = val;
	
	limL = 0;
	limH = 9999;
	
	if (wp == KEY_UP) {val += step;}
	else              {val -= step;}
	
	if (val < limL) {val = limL;}
	if (limH < val) {val = limH;}
	
	if (valTmp == val) {return;}
	
	_itow(val, text, 10);
	SetWindowText(hWnd, text);
	EditSelAll(hWnd);
	
	DmUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid DmClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FDEFORM WM_CLOSECxg
------------------------------------------------------------------------------*/
void DmClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid DmDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FDEFORM WM_DESTROYCxg
------------------------------------------------------------------------------*/
void DmDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid DmEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FDEFORM EDIT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void DmEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_DEFORM; i++) {
		if (hWnd == dm[id].tabStops[i]) {
			dm[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
	
	if ((hWnd == dm[id].hEdit[0]) || (hWnd == dm[id].hEdit[1])) {
		dm[id].hCur = hWnd;
	}
}

/*------------------------------------------------------------------------------
    Fvoid DmEdKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FDEFORM WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void DmEdKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_DEFORM; i++) {
		if ((HWND)wp == dm[id].tabStops[i]) {
			DmUpdate(id);
			break;
		}
	}
}

/*------------------------------------------------------------------------------
    FBOOL DmEdChar(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    ߒlFBOOL    -
    @\FDEFORM WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL DmEdChar(LONG id, WPARAM wp, LPARAM lp)
{
	if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	
	switch (wp) {
	case 0x03:		// ctrl+C
	case 0x08:		// back space
	case 0x16:		// ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid DmChSetCheck(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FDEFORM CHECK BM_SETCHECKCxg
------------------------------------------------------------------------------*/
void DmChSetCheck(LONG id, WPARAM wp, LPARAM lp)
{
	WCHAR strEditW[4+1];
	WCHAR strEditH[4+1];
	INT32 w;
	INT32 h;
	INT32 wImg;
	INT32 hImg;
	WCHAR text[4+1];
	
	if (wp != BST_CHECKED) {return;}
	
	wImg = fm[id].pc[0].img.w;
	hImg = fm[id].pc[0].img.h;
	
	GetWindowText(dm[id].hEdit[0], strEditW, 4+1);
	GetWindowText(dm[id].hEdit[1], strEditH, 4+1);
	w = _wtoi(strEditW);
	h = _wtoi(strEditH);
	
	if (dm[id].hCur == dm[id].hEdit[0]) {
		TryZeroDivision(wImg);
		h = (w*hImg)/wImg;
		if (9999 <= h) {h = 9999;}
		_itow(h, text, 10);
		SetWindowText(dm[id].hEdit[1], text);
	}
	else {
		TryZeroDivision(hImg);
		w = (h*wImg)/hImg;
		if (9999 <= w) {w = 9999;}
		_itow(w, text, 10);
		SetWindowText(dm[id].hEdit[0], text);
	}
}

/*------------------------------------------------------------------------------
    Fvoid DmEnterOk(LONG id)
    FLONG    FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void DmEnterOk(LONG id)
{
	WCHAR text[2][4+1];
	INT32 val[2];
	INT32 i, j;
	INT32 len;
	INT32 checked;
	
	DmUpdate(id);
	
	for (i = 0; i < 2; i++) {
		GetWindowText(dm[id].hEdit[i], text[i], 4+1);
		val[i] = _wtoi(text[i]);
	}
	
	for (i = 0; i < 2; i++) {
		len = wcslen(text[i]);
		for (j = 0; j < len; j++) {
			if ((text[i][j] < L'0') || (L'9' < text[i][j])) {
				MessageBox(dm[id].hWnd, L"deform validation not numeric", L_TITLE, MB_OK);
				return;
			}
		}
	}
	
	if ((val[0] == 0) || (val[1] == 0)) {
		MessageBox(dm[id].hWnd, L"deform validation 0", L_TITLE, MB_OK);
		return;
	}
	
	if ((5000 < val[0]) || (5000 < val[1])) {
		MessageBox(dm[id].hWnd, L"deform validation over 5000", L_TITLE, MB_OK);
		return;
	}
	
	if ((val[0] == fm[id].pc[0].img.w) &&
		(val[1] == fm[id].pc[0].img.h)) {CLOSE(dm[id].hWnd);  return;}
	
	ImageDeform(&fm[id].pc[0].img, val[0], val[1]);
	
	fm[id].pc[0].div = RAW;
	fm[id].flgDeform = TRUE;
	LiImageDelete(id, 0);
	
	MnFlushFile(id);
	
	SetAverageColor(id, 0);
	FmSizeNeutral(id, NULL, NULL);
	
	SbFlush(id);
	SetFormText(id);
	
	checked = B_GETCHECK(dm[id].hChk);
	if (checked == BST_CHECKED) {dm[id].asp=TRUE;}  else {dm[id].asp=FALSE;}
	
	DmStore(id);
	CLOSE(dm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid DmEnterCan(LONG id)
    FLONG    FORM ID
    @\F[CANCEL]{^s
------------------------------------------------------------------------------*/
void DmEnterCan(LONG id)
{
	CLOSE(dm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid DmUpdate(LONG id)
    FLONG    FORM ID
    @\FcɂčXV
------------------------------------------------------------------------------*/
void DmUpdate(LONG id)
{
	WCHAR strEditW[4+1];
	WCHAR strEditH[4+1];
	INT32 w;
	INT32 h;
	INT32 wImg;
	INT32 hImg;
	INT32 checked;
	WCHAR text[4+1];
	
	GetWindowText(dm[id].hEdit[0], strEditW, 4+1);
	GetWindowText(dm[id].hEdit[1], strEditH, 4+1);
	w = _wtoi(strEditW);
	h = _wtoi(strEditH);
	
	checked = B_GETCHECK(dm[id].hChk);
	if (checked == BST_CHECKED) {dm[id].asp = TRUE;}  else {dm[id].asp = FALSE;}
	
	if (dm[id].asp) {
		wImg = fm[id].pc[0].img.w;
		hImg = fm[id].pc[0].img.h;
		
		if (w != dm[id].w) {
			TryZeroDivision(wImg);
			h = (w*hImg)/wImg;
			if (9999 <= h) {h = 9999;}
			_itow(h, text, 10);
			SetWindowText(dm[id].hEdit[1], text);
		}
		else if (h != dm[id].h) {
			TryZeroDivision(hImg);
			w = (h*wImg)/hImg;
			if (9999 <= w) {w = 9999;}
			_itow(w, text, 10);
			SetWindowText(dm[id].hEdit[0], text);
		}
	}
	dm[id].w = w;
	dm[id].h = h;
}
