/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define KC_CPP
#include "../common.h"
//  KeyCodeFL[R[h

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	HWND hWnd;
} kc[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void KcInitClass(void);
void KcInit(LONG);
void KcInst(LONG);
void KcDialog(LONG);
LRESULT CALLBACK KcWndProc(HWND, UINT, WPARAM, LPARAM);
void KcPaint     (LONG, WPARAM, LPARAM);
void KcKeyDown   (LONG, WPARAM, LPARAM);
void KcSysKeyDown(LONG, WPARAM, LPARAM);
void KcClose     (LONG, WPARAM, LPARAM);
void KcDestroy   (LONG, WPARAM, LPARAM);

/*------------------------------------------------------------------------------
    Fvoid KcInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void KcInitClass(void)
{
	WNDCLASS wcKcode;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrWhite,NM_KCODE,&wcKcode);
	
	RegisterClass(&wcKcode);
}

/*------------------------------------------------------------------------------
    Fvoid KcInit(LONG)
    FLONG    FORM ID
    @\FL[R[h 
------------------------------------------------------------------------------*/
void KcInit(LONG id)
{
	kc[id].hWnd = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid KcInst(LONG)
    FLONG      FORM ID
    @\FKCODẺ
------------------------------------------------------------------------------*/
void KcInst(LONG id)
{
	DWORD style = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU;
	
	kc[id].hWnd = a_CreateWindow(NM_KCODE, L_TITLE, style, 0, 0, 0, 0, NULL);
	SetWindowLong(kc[id].hWnd, GWL_USERDATA, id);
	SetWindowLong(kc[id].hWnd, GWL_WNDPROC, (LONG)KcWndProc);
}

/*------------------------------------------------------------------------------
    Fvoid KcDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void KcDialog(LONG id)
{
	WINDOWPLACEMENT plcm;
	
	KcInit(id);
	KcInst(id);
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5 + 4;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left  + 150;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top   +  70;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(kc[id].hWnd, &plcm);
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = kc[id].hWnd;
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK KcWndProc(,,,)
    F-
    ߒlF-
    @\FKCODECxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK KcWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:       KcPaint     (id, wp, lp);  break;
	case WM_KEYDOWN:     KcKeyDown   (id, wp, lp);  return 0;
	case WM_SYSKEYDOWN:  KcSysKeyDown(id, wp, lp);  return 0;
	case WM_CLOSE:       KcClose     (id, wp, lp);  break;
	case WM_DESTROY:     KcDestroy   (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid KcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FKCODE WM_PAINTCxg
------------------------------------------------------------------------------*/
void KcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	
	hdc = BeginPaint(kc[id].hWnd, &ps);
	GetClientRect(kc[id].hWnd, &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial16);
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	a_TextOut(hdc, 30, 10, L"press any key");
	
	SelectClipRgn(hdc, NULL);
	EndPaint(kc[id].hWnd, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid KcKeyDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FKCODE WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void KcKeyDown(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 idx;
	WCHAR str[50];
	
	switch (wp) {
	case KEY_F1:  break;
	case KEY_F2:  break;
	case KEY_F3:  break;
	case KEY_F4:  break;
	case KEY_F5:  break;
	default:  break;
	}
	
	idx = 0;
	idx += swprintf(str+idx, L"KEYF");
	idx += swprintf(str+idx, L"0x%02X", wp);
	SetWindowText(kc[id].hWnd, str);
}

/*------------------------------------------------------------------------------
    Fvoid KcSysKeyDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FKCODE WM_SYSKEYDOWNCxg
------------------------------------------------------------------------------*/
void KcSysKeyDown(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 idx;
	WCHAR str[50];
	
	idx = 0;
	idx += swprintf(str+idx, L"SYSF");
	idx += swprintf(str+idx, L"0x%02X", wp);
	SetWindowText(kc[id].hWnd, str);
}

/*------------------------------------------------------------------------------
    Fvoid KcClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FKCODE WM_CLOSECxg
------------------------------------------------------------------------------*/
void KcClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid KcDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FKCODE WM_DESTROYCxg
------------------------------------------------------------------------------*/
void KcDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}
