/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define MO_CPP
#include "../common.h"
//  MoveOverF㏑ړ

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	BOOL res;
	LONG idP;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_MVOV];
	
	struct {WCHAR pathD[MAX_PATH];
			BOOL flgClick;} dr[2];
	
	struct {WCHAR path[MAX_PATH];
			st_Image img;
			INT32 wRaw;
			INT32 hRaw;
			BOOL flgClick;} pc[2];
	
	HWND hWnd;
	HWND hDr[2];
	HWND hPc[2];
	HWND hLb[2];
	HWND hBtn[2];
	
	LRESULT (CALLBACK *pCallBtn[2]) (HWND,UINT,WPARAM,LPARAM);
} mo[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void MoInitClass(void);
void MoInit(LONG);
void MoInst(LONG, WCHAR *);
void MoDialog(LONG);
LRESULT CALLBACK MoWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MoWndProcDr    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MoWndProcPc    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MoWndProcLb    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MoWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MoWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
void MoPaint        (LONG, WPARAM, LPARAM);
void MoCommand      (LONG, WPARAM, LPARAM);
void MoSetFocus     (LONG, WPARAM, LPARAM);
void MoClose        (LONG, WPARAM, LPARAM);
void MoDestroy      (LONG, WPARAM, LPARAM);
void MoDrPaint      (LONG, LONG, WPARAM, LPARAM);
void MoDrLButtonDown(LONG, LONG, WPARAM, LPARAM);
void MoDrLButtonUp  (LONG, LONG, WPARAM, LPARAM);
void MoPcPaint      (LONG, LONG, WPARAM, LPARAM);
void MoPcLButtonDown(LONG, LONG, WPARAM, LPARAM);
void MoPcLButtonUp  (LONG, LONG, WPARAM, LPARAM);
void MoLbPaint      (LONG, LONG, WPARAM, LPARAM);
void MoBtSetFocus   (LONG, WPARAM, LPARAM, HWND);
void MoBtKeyDown    (LONG, WPARAM, LPARAM, HWND);
void         ThrMoStart(LONG, WCHAR *, WCHAR *);
DWORD WINAPI ThrMoFunc (LPVOID);
void         ThrMoEnd  (LONG, LONG);
void         ThrMoLast (LONG);
void MoImageRead(LONG, LONG, st_Image *, WCHAR *);
BOOL MoImageReadGdi(LONG, LONG, st_Image *, WCHAR *);
void MoImageDraw(LONG, LONG, st_Image *, Bitmap *);
void MoImageMargin(LONG, LONG, st_Image *);
void MoImageDelete(LONG, LONG);
BOOL MoEnterOk(LONG);

/*------------------------------------------------------------------------------
    Fvoid MoInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void MoInitClass(void)
{
	WNDCLASS wcMvov;
	WNDCLASS wcMvovDr;
	WNDCLASS wcMvovPc;
	WNDCLASS wcMvovLb;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_MVOV,  &wcMvov);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurHand, hBrNull,  NM_MVOVDR,&wcMvovDr);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurHand, hBrNull,  NM_MVOVPC,&wcMvovPc);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrNull,  NM_MVOVLB,&wcMvovLb);
	
	RegisterClass(&wcMvov);
	RegisterClass(&wcMvovDr);
	RegisterClass(&wcMvovPc);
	RegisterClass(&wcMvovLb);
}

/*------------------------------------------------------------------------------
    Fvoid MoInit(LONG)
    FLONG    FORM ID
    @\Fړď㏑ 
------------------------------------------------------------------------------*/
void MoInit(LONG id)
{
	INT32 i;
	
	mo[id].res = FALSE;
	mo[id].idP = 0;
	
	for (i = 0; i < 2; i++) {
		wmemset(mo[id].dr[i].pathD, 0x0000, MAX_PATH);
		mo[id].dr[i].flgClick = FALSE;
		
		wmemset(mo[id].pc[i].path, 0x0000, MAX_PATH);
		InitImg(&mo[id].pc[i].img);
		
		mo[id].pc[i].wRaw = 0;
		mo[id].pc[i].hRaw = 0;
		
		mo[id].pc[i].flgClick = FALSE;
	}
	
	mo[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_MVOV; i++) {mo[id].tabStops[i] = NULL;}
	
	mo[id].hWnd = NULL;
	for (i = 0; i < 2; i++) {mo[id].hPc [i] = NULL;}
	for (i = 0; i < 2; i++) {mo[id].hLb [i] = NULL;}
	for (i = 0; i < 2; i++) {mo[id].hBtn[i] = NULL;}
	
	for (i = 0; i < 2; i++) {mo[id].pCallBtn[i] = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid MoInst(LONG, WCHAR *)
    FLONG     FORM ID
          WCHAR *  -
    @\FMVOV̉
------------------------------------------------------------------------------*/
void MoInst(LONG id, WCHAR *pathF)
{
	DWORD styleMv = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU;
	DWORD styleDr = WS_CHILD|WS_VISIBLE;
	DWORD stylePc = WS_CHILD|WS_VISIBLE;
	DWORD styleSt = WS_CHILD|WS_VISIBLE;
	DWORD styleBt = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	WCHAR title[MAX_PATH+50];
	
	wcscpy(title, TxTl(E_TTLMVO));
	wcscat(title, L"@");
	wcscat(title, pathF);
	
	mo[id].hWnd    = a_CreateWindow(NM_MVOV,  title,    styleMv,0,  0,  0,  0,  fm[id].hWnd);
	mo[id].hDr[0]  = a_CreateWindow(NM_MVOVDR,NULL,     styleDr,20, 20, 180,25, mo[id].hWnd);
	mo[id].hDr[1]  = a_CreateWindow(NM_MVOVDR,NULL,     styleDr,274,20, 180,25, mo[id].hWnd);
	mo[id].hPc[0]  = a_CreateWindow(NM_MVOVPC,NULL,     stylePc,20, 55, 200,200,mo[id].hWnd);
	mo[id].hPc[1]  = a_CreateWindow(NM_MVOVPC,NULL,     stylePc,274,55, 200,200,mo[id].hWnd);
	mo[id].hLb[0]  = a_CreateWindow(NM_MVOVLB,NULL,     styleSt,20, 265,120,61, mo[id].hWnd);
	mo[id].hLb[1]  = a_CreateWindow(NM_MVOVLB,NULL,     styleSt,274,265,120,61, mo[id].hWnd);
	mo[id].hBtn[0] = a_CreateWindow(L"Button",L"OK",    styleBt,323,337,70, 25, mo[id].hWnd);
	mo[id].hBtn[1] = a_CreateWindow(L"Button",L"CANCEL",styleBt,404,337,70, 25, mo[id].hWnd);
	
	SetWindowLong(mo[id].hWnd,    GWL_USERDATA, id);
	SetWindowLong(mo[id].hDr[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(mo[id].hDr[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(mo[id].hPc[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(mo[id].hPc[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(mo[id].hLb[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(mo[id].hLb[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(mo[id].hBtn[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(mo[id].hBtn[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(mo[id].hWnd,    GWL_WNDPROC, (LONG)MoWndProc);
	SetWindowLong(mo[id].hDr[0],  GWL_WNDPROC, (LONG)MoWndProcDr);
	SetWindowLong(mo[id].hDr[1],  GWL_WNDPROC, (LONG)MoWndProcDr);
	SetWindowLong(mo[id].hPc[0],  GWL_WNDPROC, (LONG)MoWndProcPc);
	SetWindowLong(mo[id].hPc[1],  GWL_WNDPROC, (LONG)MoWndProcPc);
	SetWindowLong(mo[id].hLb[0],  GWL_WNDPROC, (LONG)MoWndProcLb);
	SetWindowLong(mo[id].hLb[1],  GWL_WNDPROC, (LONG)MoWndProcLb);
	
	B_SETFONT(mo[id].hBtn[0], hFtArial14);
	B_SETFONT(mo[id].hBtn[1], hFtArial14);
	
	mo[id].pCallBtn[0] = (CALLFUNC)GetWindowLong(mo[id].hBtn[0], GWL_WNDPROC);
	mo[id].pCallBtn[1] = (CALLFUNC)GetWindowLong(mo[id].hBtn[1], GWL_WNDPROC);
	SetWindowLong(mo[id].hBtn[0], GWL_WNDPROC, (LONG)MoWndProcBtnOk);
	SetWindowLong(mo[id].hBtn[1], GWL_WNDPROC, (LONG)MoWndProcBtnCan);
	
	mo[id].tabStopIdx = 0;
	mo[id].tabStops[0] = mo[id].hBtn[0];
	mo[id].tabStops[1] = mo[id].hBtn[1];
	
	SetFocus(mo[id].hBtn[0]);
}

/*------------------------------------------------------------------------------
    Fvoid MoDialog(LONG, LONG, WCHAR *, WCHAR *)
    FLONG     FORM ID
          LONG     PICT ID
          WCHAR *  
          WCHAR *  O
    @\F_CAO
------------------------------------------------------------------------------*/
void MoDialog(LONG id, LONG idP, WCHAR *pDst, WCHAR *pSrc)
{
	WINDOWPLACEMENT plcm;
	
	MoInit(id);
	MoInst(id, PathFindFileName(pDst));
	wcscpy(mo[id].pc[0].path,  pSrc);
	wcscpy(mo[id].pc[1].path,  pDst);
	wcscpy(mo[id].dr[0].pathD, pSrc);
	wcscpy(mo[id].dr[1].pathD, pDst);
	PathRemoveFileSpec(mo[id].dr[0].pathD);
	PathRemoveFileSpec(mo[id].dr[1].pathD);
	mo[id].idP = idP;
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5 + 4;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + 500;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + 411;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(mo[id].hWnd, &plcm);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = mo[id].hWnd;
	
	GetImageWH(pSrc, &mo[id].pc[0].wRaw, &mo[id].pc[0].hRaw);
	GetImageWH(pDst, &mo[id].pc[1].wRaw, &mo[id].pc[1].hRaw);
	ThrMoStart(id, pSrc, pDst);
	
	MessageLoop();
	if (mo[id].res == FALSE) {return;}
	
	if (IsModeNeutral(id)) {MoveSlide1(id);}
	else                   {MoveSlideMulti(id, mo[id].idP);}
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MoWndProc(,,,)
    F-
    ߒlF-
    @\FMVOVCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MoWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:     MoPaint   (id, wp, lp);  break;
	case WM_COMMAND:   MoCommand (id, wp, lp);  break;
	case WM_SETFOCUS:  MoSetFocus(id, wp, lp);  break;
	case WM_CLOSE:     MoClose   (id, wp, lp);  break;
	case WM_DESTROY:   MoDestroy (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MoWndProcDr(,,,)
    F-
    ߒlF-
    @\FMVOV DRCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MoWndProcDr(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id; 
	LONG idD;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idD = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:        MoDrPaint      (id, idD, wp, lp);  break;
	case WM_LBUTTONDOWN:  MoDrLButtonDown(id, idD, wp, lp);  break;
	case WM_LBUTTONUP:    MoDrLButtonUp  (id, idD, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MoWndProcPc(,,,)
    F-
    ߒlF-
    @\FMVOV PCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MoWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG idP;
	LONG id;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:        MoPcPaint      (id, idP, wp, lp);  break;
	case WM_LBUTTONDOWN:  MoPcLButtonDown(id, idP, wp, lp);  break;
	case WM_LBUTTONUP:    MoPcLButtonUp  (id, idP, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MoWndProcLb(,,,)
    F-
    ߒlF-
    @\FMVOV LBCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MoWndProcLb(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG idL;
	LONG id;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idL = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:  MoLbPaint(id, idL, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MoWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FMVOV BTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MoWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG idB;
	LONG id;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  MoBtSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   MoBtKeyDown (id, wp, lp, hWnd);  break;
	default:  break;
	}
	return mo[id].pCallBtn[0](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MoWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FMVOV BTN CANCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MoWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG idB;
	LONG id;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  MoBtSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   MoBtKeyDown (id, wp, lp, hWnd);  break;
	default:  break;
	}
	return mo[id].pCallBtn[1](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid MoPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMVOV WM_PAINTCxg
------------------------------------------------------------------------------*/
void MoPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	
	hdc = BeginPaint(mo[id].hWnd, &ps);
	GetClientRect(mo[id].hWnd, &rc);
	SetClipRgn(hdc, &rc);
	SelectObject(hdc, hBrWhite);
	
	PatBlt(hdc, rc.left+PADD8,
				rc.top+PADD8,
				rc.right-rc.left-PADD8*2,
				rc.bottom-rc.top-PADD8*2, PATCOPY);
	
	SelectObject(hdc, hFtArial20);
	SetTextColor(hdc, RGB_GRAY);
	SetBkMode(hdc, TRANSPARENT);
	a_TextOut(hdc, 232, 153, L">>>");
	
	SelectClipRgn(hdc, NULL);
	EndPaint(mo[id].hWnd, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid MoCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMVOV WM_COMMANDCxg
------------------------------------------------------------------------------*/
void MoCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	if (ThrIsAnyBusy(id) == TRUE) {return;}
	
	if ((HWND)lp == mo[id].hBtn[0]) {
		if (MoEnterOk(id) == TRUE) {CLOSE(mo[id].hWnd);}
	}
	else if ((HWND)lp == mo[id].hBtn[1]) {
		CLOSE(mo[id].hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid MoSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMVOV WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void MoSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(mo[id].tabStops[mo[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid MoClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMVOV WM_CLOSECxg
------------------------------------------------------------------------------*/
void MoClose(LONG id, WPARAM wp, LPARAM lp)
{
	ImageDeleteSt(&mo[id].pc[0].img);
	ImageDeleteSt(&mo[id].pc[1].img);
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid MoDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMVOV WM_DESTROYCxg
------------------------------------------------------------------------------*/
void MoDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid MoDrPaint(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    DIRE ID
          WPARAM  -
          LPARAM  -
    @\FMVOV DR WM_PAINTCxg
------------------------------------------------------------------------------*/
void MoDrPaint(LONG id, LONG idD, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	
	hdc = BeginPaint(mo[id].hDr[idD], &ps);
	GetClientRect(mo[id].hDr[idD], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	SetTextColor(hdc, RGB_BLACK);
	SetBkMode(hdc, TRANSPARENT);
	
	a_TextOut(hdc, 6, 5, PathFindFileName(mo[id].dr[idD].pathD));
	
	GetClientRect(mo[id].hDr[idD], &rc);
	FrameRect(hdc, &rc, hBrGray);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(mo[id].hDr[idD], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid MoDrLButtonDown(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    DIRE ID
          WPARAM  -
          LPARAM  -
    @\FMVOV DR WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void MoDrLButtonDown(LONG id, LONG idD, WPARAM wp, LPARAM lp)
{
	mo[id].dr[idD].flgClick = TRUE;
	SetCapture(mo[id].hDr[idD]);
}

/*------------------------------------------------------------------------------
    Fvoid MoDrLButtonUp(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    DIRE ID
          WPARAM  -
          LPARAM  -
    @\FMVOV DR WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void MoDrLButtonUp(LONG id, LONG idD, WPARAM wp, LPARAM lp)
{
	WCHAR str[MAX_PATH * 2];
	
	if (mo[id].dr[idD].flgClick == TRUE) {
		if (IsInClientArea(mo[id].hDr[idD], LOWORD(lp), HIWORD(lp))) {
			SHGetSpecialFolderPath(NULL, str, CSIDL_WINDOWS, FALSE);
			
			wcscat(str, L"\\explorer.exe ");
			wcscat(str, L"\"");
			wcscat(str, mo[id].dr[idD].pathD);
			wcscat(str, L"\"");
			
			if (!CmdExe(str)) {
				MessageBox(mo[id].hWnd, L"explorer is none", L_ERROR, MB_OK);
				MessageBox(mo[id].hWnd, str, L_ERROR, MB_OK);
			}
		}
	}
	
	mo[id].dr[idD].flgClick = FALSE;
	ReleaseCapture();
}

/*------------------------------------------------------------------------------
    Fvoid MoPcPaint(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    PICT ID
          WPARAM  -
          LPARAM  -
    @\FMVOV PC WM_PAINTCxg
------------------------------------------------------------------------------*/
void MoPcPaint(LONG id, LONG idP, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 w, h;
	
	hdc = BeginPaint(mo[id].hPc[idP], &ps);
	
	GetClientRect(mo[id].hPc[idP], &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	
	if (mo[id].pc[idP].img.res == TRUE) {
		BitBlt(hdc,                    0, 0, w, h,
			   mo[id].pc[idP].img.hdc, 0, 0, SRCCOPY);
	}
	else {
		SelectObject(hdc, hBrWhite);
		PatBlt(hdc, 0, 0, w, h, PATCOPY);
		FrameRect(hdc, &rc, hBrGray);
	}
	
	EndPaint(mo[id].hPc[idP], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid MoPcLButtonDown(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    PICT ID
          WPARAM  -
          LPARAM  -
    @\FMVOV PC WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void MoPcLButtonDown(LONG id, LONG idP, WPARAM wp, LPARAM lp)
{
	mo[id].pc[idP].flgClick = TRUE;
	SetCapture(mo[id].hPc[idP]);
}

/*------------------------------------------------------------------------------
    Fvoid MoPcLButtonUp(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    PICT ID
          WPARAM  -
          LPARAM  -
    @\FMVOV PC WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void MoPcLButtonUp(LONG id, LONG idP, WPARAM wp, LPARAM lp)
{
	COPYDATASTRUCT data;
	
	if (mo[id].pc[idP].flgClick == TRUE) {
		if (IsInClientArea(mo[id].hPc[idP], LOWORD(lp), HIWORD(lp))) {
			data.dwData = 0;
			data.cbData = MAX_PATH;
			data.lpData = mo[id].pc[idP].path;
			COPYDATA(hCore, &data);
		}
	}
	
	mo[id].pc[idP].flgClick = FALSE;
	ReleaseCapture();
}

/*------------------------------------------------------------------------------
    Fvoid MoLbPaint(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM  ID
          LONG    LABEL ID
          WPARAM  -
          LPARAM  -
    @\FMVOV LB WM_PAINTCxg
------------------------------------------------------------------------------*/
void MoLbPaint(LONG id, LONG idL, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	WCHAR buff[4][100];
	
	hdc = BeginPaint(mo[id].hLb[idL], &ps);
	
	if (mo[id].pc[idL].img.res == TRUE) {
		SelectObject(hdc, hFtArial12);
		SetTextColor(hdc, RGB_BLACK);
		SetBkMode(hdc, TRANSPARENT);
		
		swprintf  (buff[0], L"%d~%d", mo[id].pc[idL].wRaw,
									   mo[id].pc[idL].hRaw);
		SbPxFmtStr(buff[1], mo[id].pc[idL].img.pxFmt);
		SbByteMK  (buff[2], mo[id].pc[idL].img.fileSize);
		SbFmtBPJIC(buff[3], mo[id].pc[idL].img.fmt,
							mo[id].pc[idL].img.fmtIco);
		a_TextOut(hdc, 6, 4,  buff[0]);
		a_TextOut(hdc, 6, 18, buff[1]);
		a_TextOut(hdc, 6, 32, buff[2]);
		a_TextOut(hdc, 6, 46, buff[3]);
	}
	
	GetClientRect(mo[id].hLb[idL], &rc);
	FrameRect(hdc, &rc, hBrGray);
	
	EndPaint(mo[id].hLb[idL], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid MoBtSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FMVOV BT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void MoBtSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_MVOV; i++) {
		if (hWnd == mo[id].tabStops[i]) {
			mo[id].tabStopIdx = i;
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid MoBtKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FMVOV BT WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void MoBtKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT8 tmp;
	BOOL shift;
	
	if (ThrIsAnyBusy(id) == TRUE) {return;}
	
	tmp = GetKeyState(KEY_SHIFT);
	if((tmp & 0x80)!=0){shift=TRUE;}else{shift=FALSE;}
	
	switch (wp) {
	case KEY_ENTER:
		if ((HWND)hWnd == mo[id].hBtn[0]) {
			if (MoEnterOk(id) == TRUE) {
				CLOSE(mo[id].hWnd);
			}
		}
		else {
			CLOSE(mo[id].hWnd);
		}
		break;
	case KEY_ESC:
		CLOSE(mo[id].hWnd);
		break;
	case KEY_TAB:
		if (shift == TRUE) {
			if (mo[id].tabStopIdx == 0) {mo[id].tabStopIdx = TBSP_MVOV-1;}
			else                        {mo[id].tabStopIdx--;}
		}
		else {
			mo[id].tabStopIdx = (mo[id].tabStopIdx + 1) % TBSP_MVOV;
		}
		SetFocus(mo[id].tabStops[mo[id].tabStopIdx]);
		break;
	case KEY_RT: if ((HWND)hWnd==mo[id].hBtn[0]) {SetFocus(mo[id].hBtn[1]);} break;
	case KEY_LF: if ((HWND)hWnd==mo[id].hBtn[1]) {SetFocus(mo[id].hBtn[0]);} break;
	default:
		break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid ThrMoStart(LONG, WCHAR *, WCHAR *)
    FLONG    FORM ID
          WCHAR * t@C1
          WCHAR * t@C2
    @\Fړď㏑XbhJn
------------------------------------------------------------------------------*/
void ThrMoStart(LONG id, WCHAR *path1, WCHAR *path2)
{
	INT32 i;
	
	if (pstThrMo[id] != NULL) {MessageBox(mo[id].hWnd, L"cannot create thr data", L_TITLE, MB_OK); return;}
	pstThrMo[id] = (st_ThrMo *)a_malloc(sizeof(st_ThrMo));
	
	wcscpy(pstThrMo[id]->path[0], path1);
	wcscpy(pstThrMo[id]->path[1], path2);
	
	for (i = 0; i < 2; i++) {
		InitImg(&pstThrMo[id]->img[i]);
	}
	
	fm[id].thrMo.busy = TRUE;
	CreateThread(NULL, 0, ThrMoFunc, fm[id].hWnd, 0, NULL);
}

/*------------------------------------------------------------------------------
    FDWORD WINAPI ThrMoFunc(LPVOID)
    FLPVOID  -
    ߒlFDWORD   -
    @\Fړď㏑Xbh֐
------------------------------------------------------------------------------*/
DWORD WINAPI ThrMoFunc(LPVOID lpvoid)
{
	INT32 i;
	HWND hWnd = (HWND)lpvoid;
	LONG id;
	
	id = ThrGetFormId(hWnd);
	
	ThrSetPrio(g_idxPrio);
	
	for (i = 0; i < 2; i++) {
		MoImageRead(id, i, &pstThrMo[id]->img[i], pstThrMo[id]->path[i]);
		P_USER(hWnd, WMU_THRMOEND, i);
	}
	P_USER(hWnd, WMU_THRMOLAST, NULL);
	
	return 0;
}

/*------------------------------------------------------------------------------
    Fvoid ThrMoEnd(LONG, LONG)
    FLONG    FORM ID
          LONG    PICT ID
    @\Fړď㏑XbhI
------------------------------------------------------------------------------*/
void ThrMoEnd(LONG id, LONG idP)
{
	st_Image *pThr = &pstThrMo[id]->img[idP];
	st_Image *pImg = &mo[id].pc[idP].img;
	
	if (IsBit(pThr->stat, BIT_SUCCESS)) {
		ImageReplace(pImg, pThr);
	}
	else {
		ImageDeleteSt(pThr);
	}
	
	InvalidateRect(mo[id].hPc[idP], NULL, FALSE);
	InvalidateRect(mo[id].hLb[idP], NULL, TRUE);
	UpdateWindow(mo[id].hPc[idP]);
	UpdateWindow(mo[id].hLb[idP]);
}

/*------------------------------------------------------------------------------
    Fvoid ThrMoLast(LONG)
    FLONG    FORM ID
          LONG    PICT ID
    @\Fړď㏑XbhŌ
------------------------------------------------------------------------------*/
void ThrMoLast(LONG id)
{
	free(pstThrMo[id]);
	pstThrMo[id]      = NULL;
	fm[id].thrMo.busy = FALSE;
}

/*------------------------------------------------------------------------------
    FBOOL MoEnterOk(LONG)
    FLONG    FORM ID
    ߒlFBOOL    -
    @\Fړď㏑s
------------------------------------------------------------------------------*/
BOOL MoEnterOk(LONG id)
{
	INT32 i;
	HANDLE hFile1;
	HANDLE hFile2;
	WCHAR *pSrc;
	WCHAR *pDst;
	char buff[1024];
	DWORD cnt;
	BOOL res;
	
	pSrc = mo[id].pc[0].path;
	pDst = mo[id].pc[1].path;
	
	hFile1 = CreateFile(pSrc, GENERIC_READ, NULL, NULL, OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile1 == INVALID_HANDLE_VALUE)
	{MessageBox(mo[id].hWnd, L"src open error", L_ERROR, MB_OK);  return FALSE;}
	
	hFile2 = CreateFile(pDst, GENERIC_WRITE, NULL, NULL, CREATE_ALWAYS,
						FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile2 == INVALID_HANDLE_VALUE)
	{MessageBox(mo[id].hWnd, L"dst open error", L_ERROR, MB_OK);  CloseHandle(hFile1);  return FALSE;}
	
	SetFilePointer(hFile1, 0, NULL, FILE_BEGIN);
	SetFilePointer(hFile2, 0, NULL, FILE_BEGIN);
	
	i = 0;
	while (1) {
		// 1GB܂
		if (i > (1024 * 1024)) {
			MessageBox(mo[id].hWnd, L"size over", L_ERROR, MB_OK);
			CloseHandle(hFile1);
			CloseHandle(hFile2);
			return FALSE;
		}
		
		res = ReadFile(hFile1, buff, 1024, &cnt, NULL);
		if (res == FALSE) {
			MessageBox(mo[id].hWnd, L"read error", L_ERROR, MB_OK);
			CloseHandle(hFile1);
			CloseHandle(hFile2);
			return FALSE;
		}
		
		if (cnt == 0) {break;}
		
		res = WriteFile(hFile2, buff, cnt, &cnt, NULL);
		if (res == FALSE) {
			MessageBox(mo[id].hWnd, L"write error", L_ERROR, MB_OK);
			CloseHandle(hFile1);
			CloseHandle(hFile2);
			return FALSE;
		}
	}
	
	CloseHandle(hFile1);
	CloseHandle(hFile2);
	
	if (DeleteFile(pSrc) == FALSE)
	{MessageBox(mo[id].hWnd, L"delete error", L_ERROR, MB_OK);  return FALSE;}
	
	mo[id].res = TRUE;
	return TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid MoImageRead(LONG, LONG, st_Image *, WCHAR *)
    FLONG         FORM ID
          LONG         PICT ID
          st_Image *   -
          WCHAR *      -
    @\Fړď㏑̉摜ǂݍ
------------------------------------------------------------------------------*/
void MoImageRead(LONG id, LONG idP, st_Image *pImg, WCHAR *path)
{
	BOOL res;
	INT32 fmt;
	
	fmt = IsImageFile(path);
	pImg->fileSize = GetImageFileSize(path);
	pImg->pxFmt    = PixelFormat24bppRGB;
	
	if (fmt == UNDEF) {
		res = FALSE;
	}
	else if ((fmt == BMP) && (g_idxBmp == 0)) {
		res = BmImageRead(pImg, path);
		if (res == TRUE) {
			pImg->fmt   = BMP;
			pImg->pxFmt = PixelFormat24bppRGB;
		}
	}
	else if (fmt == ICO) {
		res = IcImageRead(pImg, path);
		if (res == TRUE) {
			pImg->fmt = ICO;
			
			switch (icHeader.type) {
			case 0x01:  pImg->fmtIco = 0x01;  break;
			case 0x02:  pImg->fmtIco = 0x02;  break;
			default:  break;
			}
			
			switch (icBmpInfo.bpp) {
			case 24:  pImg->pxFmt = PixelFormat24bppRGB;   break;
			case 32:  pImg->pxFmt = PixelFormat32bppARGB;  break;
			default:  break;
			}
		}
	}
	else {
		res = MoImageReadGdi(id, idP, pImg, path);
	}
	
	if (res == TRUE) {
		MoImageMargin(id, idP, pImg);
		pImg->stat = BIT_SUCCESS;
		pImg->res  = TRUE;
	}
	else {
		if (PathFileExists(path) == FALSE) {pImg->stat = BIT_FAILURE|BIT_NOTEXIST;}
		else                               {pImg->stat = BIT_FAILURE|BIT_NOTIMAGE;}
		pImg->res = FALSE;
	}
}

/*------------------------------------------------------------------------------
    FBOOL MoImageReadGdi(LONG, LONG, st_Image *, WCHAR *)
    FLONG        FORM  ID
          LONG        TPICT ID
          st_Image *  -
          WCHAR *     pX
    ߒlFBOOL        -
    @\Fړď㏑̉摜GDI+œǂݍ
------------------------------------------------------------------------------*/
BOOL MoImageReadGdi(LONG id, LONG idP, st_Image *pImg, WCHAR *path)
{
	BOOL res;
	GUID guid;
	Bitmap *pBmp;
	
	pBmp = Gdiplus::Bitmap::FromFile(path);
	
	if((pBmp != NULL) && (pBmp->GetLastStatus() == Gdiplus::Ok) &&
	   (pBmp->GetWidth()  != 0) &&
	   (pBmp->GetHeight() != 0))
	{
		pImg->w = pBmp->GetWidth();
		pImg->h = pBmp->GetHeight();
		
		MoImageDraw(id, idP, pImg, pBmp);
		
		pBmp->GetRawFormat(&guid);
		if     ((guid == ImageFormatBMP) ||
				(guid == ImageFormatMemoryBMP)) {pImg->fmt = BMP;}
		else if (guid == ImageFormatPNG)        {pImg->fmt = PNG;}
		else if (guid == ImageFormatJPEG)       {pImg->fmt = JPG;}
		
		pImg->pxFmt = pBmp->GetPixelFormat();
		
		res = TRUE;
	}
	else {
		pImg->w = 0;
		pImg->h = 0;
		res = FALSE;
	}
	delete pBmp;
	return res;
}

/*------------------------------------------------------------------------------
    Fvoid MoImageDraw(LONG, LONG, st_Image *, Bitmap *)
    FLONG        FORM  ID
          LONG        TPICT ID
          st_Image *  -
          Bitmap *    -
    @\Fړď㏑̉摜ǂݍ
------------------------------------------------------------------------------*/
void MoImageDraw(LONG id, LONG idP, st_Image *pImg, Bitmap *pBmp)
{
	INT32 w;
	INT32 h;
	INT32 size;
	
	size = 200;
	
	w = pImg->w;
	h = pImg->h;
	if ((size*8 < w) && (size*8 < h)) {
		w /= 8;
		h /= 8;
	}
	else if ((size*4 < w) && (size*4 < h)) {
		w /= 4;
		h /= 4;
	}
	else if ((size*2 < w) && (size*2 < h)) {
		w /= 2;
		h /= 2;
	}
	
	ImageCreate(pImg, w, h);
	
	Graphics graphics(pImg->hdc);
	graphics.DrawImage(pBmp, 0, 0, pImg->w, pImg->h);
}

/*------------------------------------------------------------------------------
    Fvoid MoImageMargin(LONG, LONG, st_Image *)
    FLONG        FORM ID
          LONG        PICT ID
          st_Image *  -
    @\Fk摜ɗ]
------------------------------------------------------------------------------*/
void MoImageMargin(LONG id, LONG idP, st_Image *pImg)
{
	INT32 i;
	st_Image img;
	INT32 x,    y,    w,    h;
	INT32 xImg, yImg, wImg, hImg;
	INT32 *pB32;
	INT32 size;
	RECT rc;
	
	size = 200;
	
	x    = 0;
	y    = 0;
	w    = size;
	h    = size;
	
	wImg = pImg->w;
	hImg = pImg->h;
	if ((wImg > size) || (hImg > size)) {
		if (hImg < wImg) {
			TryZeroDivision(pImg->w);
			wImg = size;
			hImg = (double)(size * pImg->h) / pImg->w;
		}
		else {
			TryZeroDivision(pImg->h);
			hImg = size;
			wImg = (double)(size * pImg->w) / pImg->h;
		}
	}
	xImg = 0;
	yImg = 0;
	if (wImg < size) {xImg += (size - wImg) / 2;}
	if (hImg < size) {yImg += (size - hImg) / 2;}
	
	ImageCreate(&img, w, h);
	
	pB32 = (INT32 *)img.pB;
	for (i = 0; i < w*h; i++) {
		*pB32 = 0x00FFFFFF;
		pB32++;
	}
	
	SetStretchBltMode(img.hdc, HALFTONE);
	StretchBlt(img.hdc,   xImg, yImg, wImg,    hImg,
			   pImg->hdc, 0,    0,    pImg->w, pImg->h, SRCCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = size;
	rc.bottom = size;
	FrameRect(img.hdc, &rc, hBrGray);
	
	DeleteObject(pImg->hBmp);
	DeleteDC    (pImg->hdc);
	pImg->w    = img.w;
	pImg->h    = img.h;
	pImg->hBmp = img.hBmp;
	pImg->hdc  = img.hdc;
	pImg->pB   = img.pB;
}
