/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define NEWSIZE_CPP
#include "../common.h"

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	BOOL res;
	INT32 w;
	INT32 h;
	WCHAR path [MAX_PATH];
	WCHAR pathF[MAX_PATH];
	INT32 tabStopIdx;
	HWND tabStops[TBSP_NSIZE];
	
	HWND hWnd;
	HWND hEdit[3];
	HWND hBtn[2];
	
	LRESULT (CALLBACK *pCallEdit[3]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn [2]) (HWND,UINT,WPARAM,LPARAM);
} ns[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void NsInitClass(void);
void NsInit(LONG);
void NsInst(LONG);
void NsDialog(LONG);
void NsLoad(LONG);
void NsStore(LONG);
LRESULT CALLBACK NsWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK NsWndProcEditN (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK NsWndProcEditW (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK NsWndProcEditH (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK NsWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK NsWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
void NsPaint       (LONG, WPARAM, LPARAM);
void NsCommand     (LONG, WPARAM, LPARAM);
void NsSetFocus    (LONG, WPARAM, LPARAM);
void NsKeyDown     (LONG, WPARAM, LPARAM, HWND);
void NsKeyDownEnter(LONG, WPARAM, LPARAM, HWND);
void NsKeyDownEsc  (LONG, WPARAM, LPARAM, HWND);
void NsKeyDownTab  (LONG, WPARAM, LPARAM, HWND);
void NsKeyDownUpDw (LONG, WPARAM, LPARAM, HWND);
void NsClose       (LONG, WPARAM, LPARAM);
void NsDestroy     (LONG, WPARAM, LPARAM);
void NsEdSetFocus  (LONG, WPARAM, LPARAM, HWND);
BOOL NsEdChar      (LONG, WPARAM, LPARAM, HWND);
BOOL NsEnterOk(LONG);

/*------------------------------------------------------------------------------
    Fvoid NsInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void NsInitClass(void)
{
	WNDCLASS wcNSize;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_NSIZE,&wcNSize);
	
	RegisterClass(&wcNSize);
}

/*------------------------------------------------------------------------------
    Fvoid NsInit(LONG)
    FLONG    FORM ID
    @\FVK쐬 
------------------------------------------------------------------------------*/
void NsInit(LONG id)
{
	INT32 i;
	
	ns[id].res = FALSE;
	ns[id].w   = 0;
	ns[id].h   = 0;
	wmemset(ns[id].path,  0x0000, MAX_PATH);
	wmemset(ns[id].pathF, 0x0000, MAX_PATH);
	
	ns[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_NSIZE; i++) {ns[id].tabStops[i] = NULL;}
	
	ns[id].hWnd = NULL;
	for (i = 0; i < 3; i++) {ns[id].hEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {ns[id].hBtn [i] = NULL;}
	
	for (i = 0; i < 3; i++) {ns[id].pCallEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {ns[id].pCallBtn [i] = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid NsInst(LONG)
    FLONG      FORM ID
    @\FNSIZẺ
------------------------------------------------------------------------------*/
void NsInst(LONG id)
{
	DWORD styleNs  = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU;
	DWORD styleEdN = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_AUTOHSCROLL|ES_LEFT;
	DWORD styleEd  = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_AUTOHSCROLL|ES_CENTER;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	WCHAR buff[2][10+1];
	
	_itow(ns[id].w, buff[0], 10);
	_itow(ns[id].h, buff[1], 10);
	
	ns[id].hWnd     = a_CreateWindow(NM_NSIZE, TxTl(E_TTLNEW), styleNs, 0,  0,  0,  0,  fm[id].hWnd);
	ns[id].hEdit[0] = a_CreateWindow(L"Edit",  ns[id].pathF,   styleEdN,84, 16, 130,20, ns[id].hWnd);
	ns[id].hEdit[1] = a_CreateWindow(L"Edit",  buff[0],        styleEd, 84, 46, 70, 20, ns[id].hWnd);
	ns[id].hEdit[2] = a_CreateWindow(L"Edit",  buff[1],        styleEd, 84, 76, 70, 20, ns[id].hWnd);
	ns[id].hBtn[0]  = a_CreateWindow(L"Button",L"OK",          styleBt, 84, 110,70, 25, ns[id].hWnd);
	ns[id].hBtn[1]  = a_CreateWindow(L"Button",L"CANCEL",      styleBt, 164,110,70, 25, ns[id].hWnd);
	
	SetWindowLong(ns[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(ns[id].hEdit[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(ns[id].hEdit[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(ns[id].hEdit[2], GWL_USERDATA, 2*100+id);
	SetWindowLong(ns[id].hBtn[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(ns[id].hBtn[1],  GWL_USERDATA, 1*100+id);
	
	SetWindowLong(ns[id].hWnd, GWL_WNDPROC, (LONG)NsWndProc);
	
	E_SETLIMITTEXT(ns[id].hEdit[0], 100);
	E_SETLIMITTEXT(ns[id].hEdit[1], 4);
	E_SETLIMITTEXT(ns[id].hEdit[2], 4);
	
	E_SETFONT(ns[id].hEdit[0], hFtArial16);
	E_SETFONT(ns[id].hEdit[1], hFtArial16);
	E_SETFONT(ns[id].hEdit[2], hFtArial16);
	B_SETFONT(ns[id].hBtn[0],  hFtArial14);
	B_SETFONT(ns[id].hBtn[1],  hFtArial14);
	
	ns[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(ns[id].hEdit[0], GWL_WNDPROC);
	ns[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(ns[id].hEdit[1], GWL_WNDPROC);
	ns[id].pCallEdit[2] = (CALLFUNC)GetWindowLong(ns[id].hEdit[2], GWL_WNDPROC);
	ns[id].pCallBtn[0]  = (CALLFUNC)GetWindowLong(ns[id].hBtn[0],  GWL_WNDPROC);
	ns[id].pCallBtn[1]  = (CALLFUNC)GetWindowLong(ns[id].hBtn[1],  GWL_WNDPROC);
	SetWindowLong(ns[id].hEdit[0], GWL_WNDPROC, (LONG)NsWndProcEditN);
	SetWindowLong(ns[id].hEdit[1], GWL_WNDPROC, (LONG)NsWndProcEditW);
	SetWindowLong(ns[id].hEdit[2], GWL_WNDPROC, (LONG)NsWndProcEditH);
	SetWindowLong(ns[id].hBtn[0],  GWL_WNDPROC, (LONG)NsWndProcBtnOk);
	SetWindowLong(ns[id].hBtn[1],  GWL_WNDPROC, (LONG)NsWndProcBtnCan);
	
	ns[id].tabStopIdx = 0;
	ns[id].tabStops[0] = ns[id].hEdit[0];
	ns[id].tabStops[1] = ns[id].hEdit[1];
	ns[id].tabStops[2] = ns[id].hEdit[2];
	ns[id].tabStops[3] = ns[id].hBtn[0];
	ns[id].tabStops[4] = ns[id].hBtn[1];
	
	SetFocus  (ns[id].hEdit[0]);
	EditSelAll(ns[id].hEdit[0]);
}

/*------------------------------------------------------------------------------
    Fvoid NsDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void NsDialog(LONG id)
{
	BOOL res;
	INT32 i;
	INT32 w;
	INT32 h;
	WCHAR path [MAX_PATH];
	WCHAR pathD[MAX_PATH];
	WCHAR pathF[MAX_PATH];
	WCHAR buff [MAX_PATH+100];
	WCHAR *pStr1 = NULL;
	WCHAR *pStr2 = NULL;
	st_Image img;
	INT32 *pB32;
	COPYDATASTRUCT data;
	WINDOWPLACEMENT plcm;
	
	NsInit(id);
	NsLoad(id);
	
	wcscpy(pathD, fm[id].pathD);
	if ((PathIsRoot(pathD) == TRUE) || !IsExistFolder(pathD)) {
		SHGetSpecialFolderPath(NULL, pathD, CSIDL_DESKTOP, FALSE);
	}
	
	for (i = 1; ; i++) {
		if (100 <= i) {MessageBox(fm[id].hWnd, L"naming error", L_ERROR, MB_OK);  return;}
		
		swprintf(pathF, L"%s%d%s", L"NewFile", i, L".png");
		wcscpy(path, pathD);
		wcscmb(path, pathF);
		
		if (!IsExistFile(path)) {break;}
	}
	wcscpy(ns[id].pathF, pathF);
	
	NsInst(id);
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5 + 4;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + 260;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + 185;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(ns[id].hWnd, &plcm);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = ns[id].hWnd;
	
	MessageLoop();
	if (ns[id].res == FALSE) {return;}
	// ㏈KviʃEBhEj
	
	NsStore(id);
	
	wcscpy(pathF, PathFindFileName(ns[id].path));
	
	switch (g_idxLang) {
	case 0:  pStr1 = pathD;  pStr2 = pathF;  break;
	case 1:  pStr1 = pathF;  pStr2 = pathD;  break;
	default: break;
	}
	swprintf(buff, TxFm(E_FMTNEW), pStr1, pStr2);
	if (MessageBox(fm[id].hWnd, buff, TxTl(E_TTLNEW), MB_OKCANCEL) != IDOK)
	{return;}
	
	wcscpy(path, ns[id].path);
	w = ns[id].w;
	h = ns[id].h;
	ImageCreate(&img, w, h);
	
	pB32 = (INT32 *)img.pB;
	for (i = 0; i < w*h; i++) {
		*pB32 = 0x00FFFFFF;
		pB32++;
	}
	
	res = ImageSave(&img, path);
	ImageDeleteSt(&img);
	
	if (res) {
		if (IsModeNeutral(id) && IsBit(fm[id].pc[0].img.stat, BIT_NONE)) {
			ImageDelete(id, 0);
			wcscpy(fm[id].pc[0].pathF, PathFindFileName(path));
			wcscpy(fm[id].pc[0].path, path);
			ThrStarting(id, 1, FALSE, NULL);
		}
		else {
			data.dwData = 0;
			data.cbData = MAX_PATH;
			data.lpData = path;
			COPYDATA(hCore, &data);
		}
	}
	else {
		MessageBox(fm[id].hWnd, L"save error", L_TITLE, MB_OK);
	}
}

/*------------------------------------------------------------------------------
    Fvoid NsLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void NsLoad(LONG id)
{
	ns[id].w = g_nsW;
	ns[id].h = g_nsH;
}

/*------------------------------------------------------------------------------
    Fvoid NsStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void NsStore(LONG id)
{
	g_nsW = ns[id].w;
	g_nsH = ns[id].h;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK NsWndProc(,,,)
    F-
    ߒlF-
    @\FNSIZECxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK NsWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:     NsPaint   (id, wp, lp);  break;
	case WM_COMMAND:   NsCommand (id, wp, lp);  break;
	case WM_SETFOCUS:  NsSetFocus(id, wp, lp);  break;
	case WM_CLOSE:     NsClose   (id, wp, lp);  break;
	case WM_DESTROY:   NsDestroy (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK NsWndProcEditN(,,,)
    F-
    ߒlF-
    @\FNSIZE EDIT OCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK NsWndProcEditN(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  NsEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   NsKeyDown   (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (wp == KEY_TAB)   {return 0;}
		if (wp == KEY_ENTER) {return 0;}
		break;
	default: break;
	}
	
	return ns[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK NsWndProcEditW(,,,)
    F-
    ߒlF-
    @\FNSIZE EDIT Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK NsWndProcEditW(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  NsEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		NsKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (NsEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return ns[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK NsWndProcEditH(,,,)
    F-
    ߒlF-
    @\FNSIZE EDIT Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK NsWndProcEditH(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  NsEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		NsKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (NsEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return ns[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK NsWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FNSIZE BTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK NsWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  NsEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   NsKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	return ns[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK NsWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FNSize BTN LZ Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK NsWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  NsEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   NsKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	return ns[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid NsPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FNSIZE WM_PAINTCxg
------------------------------------------------------------------------------*/
void NsPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, x2, x3;
	
	hdc = BeginPaint(ns[id].hWnd, &ps);
	GetClientRect(ns[id].hWnd, &rc);
	SetClipRgn(hdc, &rc);
	SelectObject(hdc, hBrWhite);
	
	PatBlt(hdc, rc.left+PADD8,
				rc.top+PADD8,
				rc.right-rc.left-PADD8*2,
				rc.bottom-rc.top-PADD8*2, PATCOPY);
	
	SelectObject(hdc, hFtArial14);
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	switch (g_idxLang) {
	case 0:  x1 = 38;  x2 = 42;  x3 = 38;  break;
	case 1:  x1 = 32;  x2 = 32;  x3 = 32;  break;
	default: break;
	}
	
	a_TextOut(hdc, x1, 19, TxEd(E_NSNAME));
	a_TextOut(hdc, x2, 49, TxEd(E_NSWIDTH));
	a_TextOut(hdc, x3, 79, TxEd(E_NSHEIGHT));
	
	SelectClipRgn(hdc, NULL);
	EndPaint(ns[id].hWnd, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid NsCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FNSIZE WM_COMMANDCxg
------------------------------------------------------------------------------*/
void NsCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if ((HWND)lp == ns[id].hBtn[0]) {
		if (NsEnterOk(id) == TRUE) {
			CLOSE(ns[id].hWnd);
		}
	}
	else if ((HWND)lp == ns[id].hBtn[1]) {
		CLOSE(ns[id].hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid NsSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FNSIZE WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void NsSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(ns[id].tabStops[ns[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid NsKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FNSIZE WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void NsKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  NsKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    NsKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    NsKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_UP:
	case KEY_DW:     NsKeyDownUpDw (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid NsKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FNSIZE [enter]L[Cxg
------------------------------------------------------------------------------*/
void NsKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == ns[id].hBtn[1]) {
		CLOSE(ns[id].hWnd);
	}
	else {
		if (NsEnterOk(id) == TRUE) {CLOSE(ns[id].hWnd);}
	}
}

/*------------------------------------------------------------------------------
    Fvoid NsKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FNSIZE [esc]L[Cxg
------------------------------------------------------------------------------*/
void NsKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(ns[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid NsKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FNSIZE [tab]L[Cxg
------------------------------------------------------------------------------*/
void NsKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (ns[id].tabStopIdx == 0) {ns[id].tabStopIdx = TBSP_NSIZE-1;}
		else                        {ns[id].tabStopIdx--;}
	}
	else {
		ns[id].tabStopIdx = (ns[id].tabStopIdx + 1) % TBSP_NSIZE;
	}
	SetFocus(ns[id].tabStops[ns[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid NsKeyDownUpDw(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FNSIZE [][]L[Cxg
------------------------------------------------------------------------------*/
void NsKeyDownUpDw(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT16 tmp;
	UINT16 comb;
	BOOL shift;
	WCHAR text[4+1];
	INT32 val;
	INT32 valTmp;
	INT32 limL;
	INT32 limH;
	INT32 step;
	
	comb  = 0x000;
	shift = FALSE;
	tmp = GetKeyState(KEY_CTRL);   if((tmp & 0x80)!=0){comb |= 0x100;}
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){comb |= 0x010;  shift = TRUE;}
	
	if ((hWnd != ns[id].hEdit[1]) &&
		(hWnd != ns[id].hEdit[2])) {return;}
	
	if      (comb == 0x000) {step = 1;}
	else if (comb == 0x100) {step = 10;}
	else if (comb == 0x010) {step = 100;}
	else                    {return;}
	
	GetWindowText(hWnd, text, 4+1);
	val = _wtoi(text);
	valTmp = val;
	
	limL = 0;
	limH = 9999;
	
	if (wp == KEY_UP) {val += step;}
	else              {val -= step;}
	
	if (val < limL) {val = limL;}
	if (limH < val) {val = limH;}
	
	if (valTmp == val) {return;}
	
	_itow(val, text, 10);
	SetWindowText(hWnd, text);
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid NsClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FNSIZE WM_CLOSECxg
------------------------------------------------------------------------------*/
void NsClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid NsDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FNSIZE WM_DESTROYCxg
------------------------------------------------------------------------------*/
void NsDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid NsEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FNSIZE EDIT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void NsEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_NSIZE; i++) {
		if (hWnd == ns[id].tabStops[i]) {
			ns[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    FBOOL NsEdChar(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    ߒlFBOOL    -
    @\FNSIZE WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL NsEdChar(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	
	switch (wp) {
	case 0x03:		// ctrl+C
	case 0x08:		// back space
	case 0x16:		// ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    FBOOL NsEnterOk(LONG id)
    FLONG    FORM ID
    ߒlFBOOL    -
    @\FVK쐬s
------------------------------------------------------------------------------*/
BOOL NsEnterOk(LONG id)
{
	INT32 i, j;
	INT32 len;
	WCHAR text[2][4+1];
	WCHAR textN[100+1];
	INT32 w;
	INT32 h;
	WCHAR path[MAX_PATH];
	WCHAR *pExt;
	
	GetWindowText(ns[id].hEdit[1], text[0], 4+1);
	GetWindowText(ns[id].hEdit[2], text[1], 4+1);
	w = _wtoi(text[0]);
	h = _wtoi(text[1]);
	
	for (i = 0; i < 2; i++) {
		len = wcslen(text[i]);
		for (j = 0; j < len; j++) {
			if ((text[i][j] < L'0') || (L'9' < text[i][j])) {
				MessageBox(ns[id].hWnd, L"create validation not numeric", L_TITLE, MB_OK);
				return FALSE;
			}
		}
	}
	
	if ((w == 0) || (h == 0)) {
		MessageBox(ns[id].hWnd, L"create validation 0", L_TITLE, MB_OK);
		return FALSE;
	}
	
	if ((5000 < w) || (5000 < h)) {
		MessageBox(ns[id].hWnd, L"create validation over 5000", L_TITLE, MB_OK);
		return FALSE;
	}
	
	GetWindowText(ns[id].hEdit[0], textN, 100+1);
	if (80 < wcslen(textN))
	{MessageBox(ns[id].hWnd, L"length over", L_ERROR, MB_OK);  return FALSE;}
	
	pExt = PathFindExtension(textN);
	if (*pExt == NULL) {PathAddExtension(textN, L".png");}
	
	wcscpy(path, fm[id].pathD);
	wcscmb(path, textN);
	if (IsExistFile(path))
	{MessageBox(ns[id].hWnd, L"exist same name", L_ERROR, MB_OK);  return FALSE;}
	
	wcscpy(ns[id].path, path);
	ns[id].w = w;
	ns[id].h = h;
	
	ns[id].res = TRUE;
	return TRUE;
}
