/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define RM_CPP
#include "../common.h"
//  ReNameFOύX

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 tabStopIdx;
	HWND tabStops[TBSP_REM];
	
	HWND hWnd;
	HWND hEdit;
	HWND hBtn[2];
	
	LRESULT (CALLBACK *pCallEdit)   (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn[2]) (HWND,UINT,WPARAM,LPARAM);
} rm[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void RmInitClass(void);
void RmInit(LONG);
void RmInst(LONG);
void RmDialog(LONG);
LRESULT CALLBACK RmWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RmWndProcEdit  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RmWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RmWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
void RmPaint       (LONG, WPARAM, LPARAM);
void RmCommand     (LONG, WPARAM, LPARAM);
void RmSetFocus    (LONG, WPARAM, LPARAM);
void RmKeyDown     (LONG, WPARAM, LPARAM, HWND);
void RmKeyDownEnter(LONG, WPARAM, LPARAM, HWND);
void RmKeyDownEsc  (LONG, WPARAM, LPARAM, HWND);
void RmKeyDownTab  (LONG, WPARAM, LPARAM, HWND);
void RmKeyDownRtLf (LONG, WPARAM, LPARAM, HWND);
void RmClose       (LONG, WPARAM, LPARAM);
void RmDestroy     (LONG, WPARAM, LPARAM);
void RmEdSetFocus  (LONG, WPARAM, LPARAM, HWND);
BOOL RmEnterOk(LONG);

/*------------------------------------------------------------------------------
    Fvoid RmInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void RmInitClass(void)
{
	WNDCLASS wcRem;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_REM,&wcRem);
	
	RegisterClass(&wcRem);
}

/*------------------------------------------------------------------------------
    Fvoid RmInit(LONG)
    FLONG    FORM ID
    @\FOύX 
------------------------------------------------------------------------------*/
void RmInit(LONG id)
{
	INT32 i;
	
	rm[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_REM; i++) {rm[id].tabStops[i] = NULL;}
	
	rm[id].hWnd  = NULL;
	rm[id].hEdit = NULL;
	for (i = 0; i < 2; i++) {rm[id].hBtn[i] = NULL;}
	
	rm[id].pCallEdit = NULL;
	for (i = 0; i < 2; i++) {rm[id].pCallBtn[i] = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid RmInst(LONG)
    FLONG      FORM ID
    @\FREM̉
------------------------------------------------------------------------------*/
void RmInst(LONG id)
{
	DWORD styleRm = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU;
	DWORD styleEd = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_LEFT|ES_AUTOHSCROLL;
	DWORD styleBt = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	
	rm[id].hWnd    = a_CreateWindow(NM_REM,   TxTl(E_TTLREM),     styleRm,0,  0, 0,  0, fm[id].hWnd);
	rm[id].hEdit   = a_CreateWindow(L"Edit",  fm[id].pc[0].pathF, styleEd,19, 20,420,20,rm[id].hWnd);
	rm[id].hBtn[0] = a_CreateWindow(L"Button",L"OK",              styleBt,289,50,70, 25,rm[id].hWnd);
	rm[id].hBtn[1] = a_CreateWindow(L"Button",L"CANCEL",          styleBt,369,50,70, 25,rm[id].hWnd);
	
	SetWindowLong(rm[id].hWnd,    GWL_USERDATA, id);
	SetWindowLong(rm[id].hEdit,   GWL_USERDATA, id);
	SetWindowLong(rm[id].hBtn[0], GWL_USERDATA, id);
	SetWindowLong(rm[id].hBtn[1], GWL_USERDATA, id);
	
	SetWindowLong(rm[id].hWnd, GWL_WNDPROC, (LONG)RmWndProc);
	
	E_SETLIMITTEXT(rm[id].hEdit, 100);
	
	E_SETFONT(rm[id].hEdit,   hFtArial16);
	B_SETFONT(rm[id].hBtn[0], hFtArial14);
	B_SETFONT(rm[id].hBtn[1], hFtArial14);
	
	rm[id].pCallEdit  = (CALLFUNC)GetWindowLong(rm[id].hEdit,   GWL_WNDPROC);
	rm[id].pCallBtn[0]= (CALLFUNC)GetWindowLong(rm[id].hBtn[0], GWL_WNDPROC);
	rm[id].pCallBtn[1]= (CALLFUNC)GetWindowLong(rm[id].hBtn[1], GWL_WNDPROC);
	SetWindowLong(rm[id].hEdit,   GWL_WNDPROC, (LONG)RmWndProcEdit);
	SetWindowLong(rm[id].hBtn[0], GWL_WNDPROC, (LONG)RmWndProcBtnOk);
	SetWindowLong(rm[id].hBtn[1], GWL_WNDPROC, (LONG)RmWndProcBtnCan);
	
	rm[id].tabStopIdx = 0;
	rm[id].tabStops[0] = rm[id].hEdit;
	rm[id].tabStops[1] = rm[id].hBtn[0];
	rm[id].tabStops[2] = rm[id].hBtn[1];
	
	SetFocus  (rm[id].hEdit);
	EditSelAll(rm[id].hEdit);
}

/*------------------------------------------------------------------------------
    Fvoid RmDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void RmDialog(LONG id)
{
	WINDOWPLACEMENT plcm;
	
	RmInit(id);
	RmInst(id);
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5 + 4;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + 464;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + 121;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(rm[id].hWnd, &plcm);
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = rm[id].hWnd;
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RmWndProc(,,,)
    F-
    ߒlF-
    @\FREMCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RmWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:     RmPaint   (id, wp, lp);  break;
	case WM_COMMAND:   RmCommand (id, wp, lp);  break;
	case WM_SETFOCUS:  RmSetFocus(id, wp, lp);  break;
	case WM_CLOSE:     RmClose   (id, wp, lp);  break;
	case WM_DESTROY:   RmDestroy (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RmWndProcEdit(,,,)
    F-
    ߒlF-
    @\FREM EDITCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RmWndProcEdit(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:  RmEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   RmKeyDown   (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (wp == KEY_TAB)   {return 0;}
		if (wp == KEY_ENTER) {return 0;}
		break;
	default:
		break;
	}
	return rm[id].pCallEdit(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RmWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FREM BTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RmWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:  RmEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   RmKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	return rm[id].pCallBtn[0](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RmWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FREM BTN LZ Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RmWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:  RmEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   RmKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	return rm[id].pCallBtn[1](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid RmPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FREM WM_PAINTCxg
------------------------------------------------------------------------------*/
void RmPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	
	hdc = BeginPaint(rm[id].hWnd, &ps);
	GetClientRect(rm[id].hWnd, &rc);
	SetClipRgn(hdc, &rc);
	SelectObject(hdc, hBrWhite);
	
	PatBlt(hdc, rc.left+PADD8,
				rc.top+PADD8,
				rc.right-rc.left-PADD8*2,
				rc.bottom-rc.top-PADD8*2, PATCOPY);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(rm[id].hWnd, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid RmCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FREM WM_COMMANDCxg
------------------------------------------------------------------------------*/
void RmCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if ((HWND)lp == rm[id].hBtn[0]) {
		if (RmEnterOk(id) == TRUE) {
			CLOSE(rm[id].hWnd);
		}
	}
	else if ((HWND)lp == rm[id].hBtn[1]) {
		CLOSE(rm[id].hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid RmSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FREM WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void RmSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(rm[id].tabStops[rm[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid RmKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FREM WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void RmKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  RmKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    RmKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    RmKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_RT:
	case KEY_LF:     RmKeyDownRtLf (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid RmKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FREM [enter]L[Cxg
------------------------------------------------------------------------------*/
void RmKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if ((hWnd == rm[id].hEdit) ||
		(hWnd == rm[id].hBtn[0]))
	{
		if (RmEnterOk(id) == TRUE) {CLOSE(rm[id].hWnd);}
	}
	else if (hWnd == rm[id].hBtn[1]) {
		CLOSE(rm[id].hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid RmKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FREM [esc]L[Cxg
------------------------------------------------------------------------------*/
void RmKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(rm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid RmKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FREM [tab]L[Cxg
------------------------------------------------------------------------------*/
void RmKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT8 tmp;
	BOOL shift;
	
	tmp = GetKeyState(KEY_SHIFT);
	if((tmp & 0x80)!=0){shift=TRUE;}else{shift=FALSE;}
	
	if (shift == TRUE) {
		if (rm[id].tabStopIdx == 0) {rm[id].tabStopIdx = TBSP_REM-1;}
		else                        {rm[id].tabStopIdx--;}
	}
	else {
		rm[id].tabStopIdx = (rm[id].tabStopIdx + 1) % TBSP_REM;
	}
	SetFocus(rm[id].tabStops[rm[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid RmKeyDownRtLf(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FREM [][]L[Cxg
------------------------------------------------------------------------------*/
void RmKeyDownRtLf(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if      ((HWND)hWnd==rm[id].hBtn[0]) {SetFocus(rm[id].hBtn[1]);}
	else if ((HWND)hWnd==rm[id].hBtn[1]) {SetFocus(rm[id].hBtn[0]);}
}

/*------------------------------------------------------------------------------
    Fvoid RmClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FREM WM_CLOSECxg
------------------------------------------------------------------------------*/
void RmClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid RmDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FREM WM_DESTROYCxg
------------------------------------------------------------------------------*/
void RmDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid RmEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FREM WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void RmEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_REM; i++) {
		if (hWnd == rm[id].tabStops[i]) {
			rm[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    FBOOL RmEnterOk(LONG id)
    FLONG    FORM ID
    ߒlFBOOL    -
    @\FOύXs
------------------------------------------------------------------------------*/
BOOL RmEnterOk(LONG id)
{
	WCHAR pathBef[MAX_PATH];
	WCHAR pathAft[MAX_PATH];
	WCHAR text   [100+1];
	WCHAR msg    [MAX_PATH+100];
	WCHAR *pExt;
	WCHAR *pStr;
	
	wcscpy(pathBef, fm[id].pathD);
	wcscmb(pathBef, fm[id].pc[0].pathF);
	
	wcscpy(pathAft, fm[id].pathD);
	wcscat(pathAft, L"\\");
	GetWindowText(rm[id].hEdit, text, 100+1);
	if (80 < wcslen(text))
	{MessageBox(rm[id].hWnd, L"length over", L_ERROR, MB_OK);  return FALSE;}
	
	pExt = PathFindExtension(text);
	if (*pExt == NULL) {
		switch (fm[id].pc[0].img.fmt) {
		case BMP:     pStr = (WCHAR *)L".bmp";  break;
		case PNG:     pStr = (WCHAR *)L".png";  break;
		case JPG:     pStr = (WCHAR *)L".jpg";  break;
		case ICO:
//			switch (fm[id].pc[0].img.fmtIco) {
//			case 0x01:  pStr = (WCHAR *)L".ico";  break;
//			case 0x02:  pStr = (WCHAR *)L".cur";  break;
//			default:    pStr = NULL;              break;
//			}
			pStr = (WCHAR *)L".ico";
			break;
		default:      pStr = NULL;              break;
		}
		PathAddExtension(text, pStr);  // L".exe"
	}
	
	wcscat(pathAft, text);
	
	if (wcscmp(pathBef, pathAft) == 0) {return TRUE;}
	
	swprintf(msg, TxFm(E_FMTREM), text);
	if (MessageBox(rm[id].hWnd, msg, TxTl(E_TTLREM), MB_OKCANCEL) != IDOK) {return FALSE;}
	
	if (MoveFile(pathBef, pathAft) == FALSE)
	{MessageBox(rm[id].hWnd, L"rename error", L_ERROR, MB_OK);  return FALSE;}
	
	wcscpy(fm[id].pc[0].pathF, text);
	wcscpy(fm[id].pc[0].path,  pathAft);
	SetFormText(id);
	
	ImageCount(id, 0);
	SbFlush(id);
	
	return TRUE;
}
