/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define TX_CPP
#include "../common.h"
//  TextF

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 x;
	INT32 y;
	WCHAR text[100+1];
	INT32 fore;
	INT32 back;
	BOOL alpha;
	INT32 idxFont;
	INT32 size;
	BOOL vert;
	BOOL flgClick[2];
	BOOL flgUpdate;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_TEXT];
	
	struct {INT32 idx;
			BOOL flgClick;} ftbx;
	
	struct {INT32 idx;
			INT32 tabStopIdx;
			HWND tabStops[CNT_FONTFAMILY];} ft;
	
	struct {BOOL flgClick;
			BOOL flgHighlight;} ftem[CNT_FONTFAMILY];
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;} cn;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			UINT32 percent;
			st_Image tmp;} pc;
	
	HWND hWnd;
	HWND hPd[2];
	HWND hEdit[6];
	HWND hRgb[2];
	HWND hChk[2];
	HWND hFtBox;
	HWND hFt;
	HWND hFtElm[CNT_FONTFAMILY];
	HWND hBtn[3];
	HWND hCn;
	HWND hPc;
	
	LRESULT (CALLBACK *pCallEdit[6]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallChk [2]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn [3]) (HWND,UINT,WPARAM,LPARAM);
} tx[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void TxInitClass(void);
void TxInit(LONG);
void TxInst(LONG);
void TxInstFt(LONG);
void TxDialog(LONG);
void TxLoad(LONG);
void TxStore(LONG);
LRESULT CALLBACK TxWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcPd    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcEditX (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcEditY (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcEditS (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcEditF (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcEditB (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcEditZ (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcRgbF  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcRgbB  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcChkA  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcChkV  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcFtBox (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcFt    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcFtElm (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcBtnApl(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TxWndProcPc    (HWND, UINT, WPARAM, LPARAM);
void TxSize           (LONG, WPARAM, LPARAM);
void TxGetMinMaxInfo  (LONG, WPARAM, LPARAM);
void TxSetFocus       (LONG, WPARAM, LPARAM);
void TxKeyDown        (LONG, WPARAM, LPARAM, HWND);
void TxKeyDownEnter   (LONG, WPARAM, LPARAM, HWND);
void TxKeyDownEsc     (LONG, WPARAM, LPARAM, HWND);
void TxKeyDownTab     (LONG, WPARAM, LPARAM, HWND);
void TxKeyDownSpace   (LONG, WPARAM, LPARAM, HWND);
void TxKeyDownF5      (LONG, WPARAM, LPARAM, HWND);
void TxKeyDownUpDw    (LONG, WPARAM, LPARAM, HWND);
void TxClose          (LONG, WPARAM, LPARAM);
void TxDestroy        (LONG, WPARAM, LPARAM);
void TxPdCommand      (LONG, WPARAM, LPARAM);
void TxPdPaint        (LONG, WPARAM, LPARAM);
void TxEdSetFocus     (LONG, WPARAM, LPARAM, HWND);
void TxEdKillFocus    (LONG, WPARAM, LPARAM, HWND);
BOOL TxEdChar         (LONG, WPARAM, LPARAM, HWND);
void TxRbPaint        (LONG, LONG, WPARAM, LPARAM, HWND);
void TxRbSetFocus     (LONG, LONG, WPARAM, LPARAM, HWND);
void TxRbKillFocus    (LONG, LONG, WPARAM, LPARAM, HWND);
void TxRbLButtonDown  (LONG, LONG, WPARAM, LPARAM, HWND);
void TxRbLButtonUp    (LONG, LONG, WPARAM, LPARAM, HWND);
void TxChSetCheck     (LONG, WPARAM, LPARAM);
void TxFtBxSetFocus   (LONG, WPARAM, LPARAM);
void TxFtBxKillFocus  (LONG, WPARAM, LPARAM);
void TxFtBxPaint      (LONG, WPARAM, LPARAM);
void TxFtBxEraseBkGnd (LONG, WPARAM, LPARAM);
void TxFtBxLButtonDown(LONG, WPARAM, LPARAM);
void TxFtBxLButtonUp  (LONG, WPARAM, LPARAM);
void TxFtPaint        (LONG, WPARAM, LPARAM);
void TxFtSetFocus     (LONG, WPARAM, LPARAM);
void TxFtClose        (LONG, WPARAM, LPARAM);
void TxFtEmPaint      (LONG, LONG, WPARAM, LPARAM);
void TxFtEmEraseBkGnd (LONG, LONG, WPARAM, LPARAM);
void TxFtEmLButtonDown(LONG, LONG, WPARAM, LPARAM);
void TxFtEmLButtonUp  (LONG, LONG, WPARAM, LPARAM);
void TxFtEmSetFocus   (LONG, LONG, WPARAM, LPARAM);
void TxFtEmKeyDown    (LONG, WPARAM, LPARAM);
void TxPcPaint        (LONG, WPARAM, LPARAM);
void TxPcLButtonDown  (LONG, WPARAM, LPARAM);
void TxEnterOk(LONG);
void TxEnterCan(LONG);
void TxEnterApl(LONG);
void TxUpdate(LONG);
void TxFtCreate(LONG);
void TxTmpCreate(LONG, INT32, INT32);
void TxTmpDraw(LONG);
void TxTmpDelete(LONG);
void TxImageView(LONG);
void TxSetPane(LONG);

/*------------------------------------------------------------------------------
    Fvoid TxInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void TxInitClass(void)
{
	WNDCLASS wcText;
	WNDCLASS wcTextPd;
	WNDCLASS wcTextFtBox;
	WNDCLASS wcTextFt;
	WNDCLASS wcTextFtElm;
	WNDCLASS wcTextCn;
	WNDCLASS wcTextPc;
	
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_TEXTPD,   &wcTextPd);
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_TEXT,     &wcText);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurHand, hBrWhite, NM_TEXTFTBOX,&wcTextFtBox);
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_TEXTFT,   &wcTextFt);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurHand, hBrWhite, NM_TEXTFTELM,&wcTextFtElm);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_TEXTCN,   &wcTextCn);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrNull,  NM_TEXTPC,   &wcTextPc);
	
	RegisterClass(&wcTextPd);
	RegisterClass(&wcText);
	RegisterClass(&wcTextFtBox);
	RegisterClass(&wcTextFt);
	RegisterClass(&wcTextFtElm);
	RegisterClass(&wcTextCn);
	RegisterClass(&wcTextPc);
}

/*------------------------------------------------------------------------------
    Fvoid TxInit(LONG)
    FLONG    FORM ID
    @\F
------------------------------------------------------------------------------*/
void TxInit(LONG id)
{
	INT32 i;
	
	tx[id].x       = 0;
	tx[id].y       = 0;
	wmemset(tx[id].text, 0x0000, 100+1);
	tx[id].fore    = 0x000000;
	tx[id].back    = 0x000000;
	tx[id].alpha   = FALSE;
	tx[id].idxFont = 0;
	tx[id].size    = 0;
	tx[id].vert    = FALSE;
	tx[id].flgUpdate  = FALSE;
	
	tx[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_TEXT; i++) {tx[id].tabStops[i] = NULL;}
	
	tx[id].ftbx.idx      = 0;
	tx[id].ftbx.flgClick = FALSE;
	for (i = 0; i < CNT_FONTFAMILY; i++) {tx[id].ft.tabStops[i] = NULL;}
	
	for (i = 0; i < CNT_FONTFAMILY; i++) {
		tx[id].ftem[i].flgClick     = 0;
		tx[id].ftem[i].flgHighlight = 0;
	}
	
	tx[id].cn.x = 0;
	tx[id].cn.y = 0;
	tx[id].cn.w = 0;
	tx[id].cn.h = 0;
	
	tx[id].pc.x       = 0;
	tx[id].pc.y       = 0;
	tx[id].pc.w       = 0;
	tx[id].pc.h       = 0;
	tx[id].pc.percent = 0;
	InitImg(&tx[id].pc.tmp);
	
	tx[id].hWnd = NULL;
	for (i = 0; i < 2; i++) {tx[id].hPd[i]   = NULL;}
	for (i = 0; i < 6; i++) {tx[id].hEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {tx[id].hRgb[i]  = NULL;}
	for (i = 0; i < 2; i++) {tx[id].hChk[i]  = NULL;}
	tx[id].hFtBox = NULL;
	tx[id].hFt    = NULL;
	for (i = 0; i < CNT_FONTFAMILY; i++) {tx[id].hFtElm[i] = NULL;}
	for (i = 0; i < 3; i++)              {tx[id].hBtn[i]   = NULL;}
	tx[id].hCn  = NULL;
	tx[id].hPc  = NULL;
	
	for (i = 0; i < 6; i++) {tx[id].pCallEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {tx[id].pCallChk [i] = NULL;}
	for (i = 0; i < 2; i++) {tx[id].pCallBtn [i] = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid TxInst(LONG)
    FLONG      FORM ID
    @\FTEXT̉
------------------------------------------------------------------------------*/
void TxInst(LONG id)
{
	DWORD styleSr  = WS_OVERLAPPED|WS_CAPTION|WS_MAXIMIZEBOX|WS_THICKFRAME|WS_SYSMENU;
	DWORD stylePd1 = WS_CHILD|WS_VISIBLE;
	DWORD stylePd2 = WS_CHILD;
	DWORD styleEd  = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_AUTOHSCROLL|ES_CENTER;  // ES_NUMBER
	DWORD styleEdS = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_AUTOHSCROLL;
	DWORD styleRb  = WS_CHILD|WS_VISIBLE|WS_BORDER;
	DWORD styleCk  = WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX;  // BS_CHECKBOX  BS_RIGHTBUTTON 
	DWORD styleFt  = WS_CHILD|WS_VISIBLE|WS_BORDER;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD styleCn  = WS_CHILD|WS_CLIPCHILDREN;
	DWORD stylePc  = WS_CHILD;
	INT32 y[6] = {12,42,72,102,132,222,};
	INT32 w;
	INT32 wChk;
	WCHAR strFore[6+1];
	WCHAR strBack[6+1];
	WCHAR strSize[3+1];
	WPARAM wp[2];
	
	_htow(tx[id].fore, strFore, 6);
	_htow(tx[id].back, strBack, 6);
	_itow(tx[id].size, strSize, 10);
	
	if (g_idxLang == 0) {
		wChk = 70;
		if (tx[id].alpha) {wp[0] = BST_CHECKED;}
		else              {wp[0] = BST_UNCHECKED;}
	}
	else {
		wChk = 100;
		if (tx[id].alpha) {wp[0] = BST_UNCHECKED;}
		else              {wp[0] = BST_CHECKED;}
	}
	if (tx[id].vert) {wp[1] = BST_CHECKED;}
	else             {wp[1] = BST_UNCHECKED;}
	
	w = SZ_WEDIT3-PADD8*2;
	tx[id].hWnd    = a_CreateWindow(NM_TEXT,     TxTl(E_TTLSTR), styleSr, 0,   0,   0,   0,  fm[id].hWnd);
	tx[id].hPd[0]  = a_CreateWindow(NM_TEXTPD,   NULL,           stylePd1,8,   8,   w,   318,tx[id].hWnd);
	tx[id].hPd[1]  = a_CreateWindow(NM_TEXTPD,   NULL,           stylePd2,0,   0,   0,   0,  tx[id].hWnd);
	tx[id].hEdit[0]= a_CreateWindow(L"Edit",     L"0",           styleEd, 81,  y[0],65,  17, tx[id].hPd[0]);
	tx[id].hEdit[1]= a_CreateWindow(L"Edit",     L"0",           styleEd, 81,  y[1],65,  17, tx[id].hPd[0]);
	tx[id].hEdit[2]= a_CreateWindow(L"Edit",     L"",            styleEdS,81,  y[2],140, 17, tx[id].hPd[0]);
	tx[id].hEdit[3]= a_CreateWindow(L"Edit",     strFore,        styleEd, 81,  y[3],65,  17, tx[id].hPd[0]);
	tx[id].hEdit[4]= a_CreateWindow(L"Edit",     strBack,        styleEd, 81,  y[4],65,  17, tx[id].hPd[0]);
	tx[id].hEdit[5]= a_CreateWindow(L"Edit",     strSize,        styleEd, 81,  y[5],65,  17, tx[id].hPd[0]);
	tx[id].hChk[0] = a_CreateWindow(L"Button",   TxEd(E_TXTRANS),styleCk, 86,  158, wChk,25, tx[id].hPd[0]);
	tx[id].hChk[1] = a_CreateWindow(L"Button",   TxEd(E_TXVERT), styleCk, 86,  248, 70,  25, tx[id].hPd[0]);
	tx[id].hRgb[0] = a_CreateWindow(NM_RGBBOX,   NULL,           styleRb, 152, 103, 16,  16, tx[id].hPd[0]);
	tx[id].hRgb[1] = a_CreateWindow(NM_RGBBOX,   NULL,           styleRb, 152, 133, 16,  16, tx[id].hPd[0]);
	tx[id].hFtBox  = a_CreateWindow(NM_TEXTFTBOX,NULL,           styleFt, 82,  192, 99,  17, tx[id].hPd[0]);
	tx[id].hBtn[0] = a_CreateWindow(L"Button",   TxEd(E_OK),     styleBt, 10,  285, 70,  25, tx[id].hPd[0]);
	tx[id].hBtn[1] = a_CreateWindow(L"Button",   TxEd(E_CANCEL), styleBt, 90,  285, 70,  25, tx[id].hPd[0]);
	tx[id].hBtn[2] = a_CreateWindow(L"Button",   TxEd(E_APPLY),  styleBt, 170, 285, 70,  25, tx[id].hPd[0]);
	tx[id].hCn     = a_CreateWindow(NM_TEXTCN,   NULL,           styleCn, 0,   0,   0,   0,  tx[id].hPd[1]);
	tx[id].hPc     = a_CreateWindow(NM_TEXTPC,   NULL,           stylePc, 0,   0,   0,   0,  tx[id].hCn);
	
	SetWindowLong(tx[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(tx[id].hPd[0],   GWL_USERDATA, 0*100+id);
	SetWindowLong(tx[id].hPd[1],   GWL_USERDATA, 1*100+id);
	SetWindowLong(tx[id].hEdit[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(tx[id].hEdit[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(tx[id].hEdit[2], GWL_USERDATA, 2*100+id);
	SetWindowLong(tx[id].hEdit[3], GWL_USERDATA, 3*100+id);
	SetWindowLong(tx[id].hEdit[4], GWL_USERDATA, 4*100+id);
	SetWindowLong(tx[id].hEdit[5], GWL_USERDATA, 5*100+id);
	SetWindowLong(tx[id].hRgb[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(tx[id].hRgb[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(tx[id].hChk[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(tx[id].hChk[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(tx[id].hFtBox,   GWL_USERDATA, id);
	SetWindowLong(tx[id].hBtn[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(tx[id].hBtn[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(tx[id].hBtn[2],  GWL_USERDATA, 2*100+id);
	SetWindowLong(tx[id].hPc,      GWL_USERDATA, id);
	
	SetWindowLong(tx[id].hWnd,    GWL_WNDPROC, (LONG)TxWndProc);
	SetWindowLong(tx[id].hPd[0],  GWL_WNDPROC, (LONG)TxWndProcPd);
	SetWindowLong(tx[id].hPd[1],  GWL_WNDPROC, (LONG)TxWndProcPd);
	SetWindowLong(tx[id].hRgb[0], GWL_WNDPROC, (LONG)TxWndProcRgbF);
	SetWindowLong(tx[id].hRgb[1], GWL_WNDPROC, (LONG)TxWndProcRgbB);
	SetWindowLong(tx[id].hFtBox,  GWL_WNDPROC, (LONG)TxWndProcFtBox);
	SetWindowLong(tx[id].hPc,     GWL_WNDPROC, (LONG)TxWndProcPc);
	
	E_SETLIMITTEXT(tx[id].hEdit[0], 4);
	E_SETLIMITTEXT(tx[id].hEdit[1], 4);
	E_SETLIMITTEXT(tx[id].hEdit[2], 100);
	E_SETLIMITTEXT(tx[id].hEdit[3], 6);
	E_SETLIMITTEXT(tx[id].hEdit[4], 6);
	E_SETLIMITTEXT(tx[id].hEdit[5], 3);
	
	E_SETFONT(tx[id].hEdit[0], hFtCourier);
	E_SETFONT(tx[id].hEdit[1], hFtCourier);
	E_SETFONT(tx[id].hEdit[2], hFtCourier);
	E_SETFONT(tx[id].hEdit[3], hFtCourier);
	E_SETFONT(tx[id].hEdit[4], hFtCourier);
	E_SETFONT(tx[id].hEdit[5], hFtCourier);
	
	B_SETCHECK(tx[id].hChk[0], wp[0]);
	B_SETCHECK(tx[id].hChk[1], wp[1]);
	
	B_SETFONT(tx[id].hChk[0], hFtArial14);
	B_SETFONT(tx[id].hChk[1], hFtArial14);
	B_SETFONT(tx[id].hBtn[0], hFtArial14);
	B_SETFONT(tx[id].hBtn[1], hFtArial14);
	B_SETFONT(tx[id].hBtn[2], hFtArial14);
	
	tx[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(tx[id].hEdit[0], GWL_WNDPROC);
	tx[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(tx[id].hEdit[1], GWL_WNDPROC);
	tx[id].pCallEdit[2] = (CALLFUNC)GetWindowLong(tx[id].hEdit[2], GWL_WNDPROC);
	tx[id].pCallEdit[3] = (CALLFUNC)GetWindowLong(tx[id].hEdit[3], GWL_WNDPROC);
	tx[id].pCallEdit[4] = (CALLFUNC)GetWindowLong(tx[id].hEdit[4], GWL_WNDPROC);
	tx[id].pCallEdit[5] = (CALLFUNC)GetWindowLong(tx[id].hEdit[5], GWL_WNDPROC);
	tx[id].pCallChk[0]  = (CALLFUNC)GetWindowLong(tx[id].hChk[0],  GWL_WNDPROC);
	tx[id].pCallChk[1]  = (CALLFUNC)GetWindowLong(tx[id].hChk[1],  GWL_WNDPROC);
	tx[id].pCallBtn[0]  = (CALLFUNC)GetWindowLong(tx[id].hBtn[0],  GWL_WNDPROC);
	tx[id].pCallBtn[1]  = (CALLFUNC)GetWindowLong(tx[id].hBtn[1],  GWL_WNDPROC);
	tx[id].pCallBtn[2]  = (CALLFUNC)GetWindowLong(tx[id].hBtn[2],  GWL_WNDPROC);
	SetWindowLong(tx[id].hEdit[0], GWL_WNDPROC, (LONG)TxWndProcEditX);
	SetWindowLong(tx[id].hEdit[1], GWL_WNDPROC, (LONG)TxWndProcEditY);
	SetWindowLong(tx[id].hEdit[2], GWL_WNDPROC, (LONG)TxWndProcEditS);
	SetWindowLong(tx[id].hEdit[3], GWL_WNDPROC, (LONG)TxWndProcEditF);
	SetWindowLong(tx[id].hEdit[4], GWL_WNDPROC, (LONG)TxWndProcEditB);
	SetWindowLong(tx[id].hEdit[5], GWL_WNDPROC, (LONG)TxWndProcEditZ);
	SetWindowLong(tx[id].hChk[0],  GWL_WNDPROC, (LONG)TxWndProcChkA);
	SetWindowLong(tx[id].hChk[1],  GWL_WNDPROC, (LONG)TxWndProcChkV);
	SetWindowLong(tx[id].hBtn[0],  GWL_WNDPROC, (LONG)TxWndProcBtnOk);
	SetWindowLong(tx[id].hBtn[1],  GWL_WNDPROC, (LONG)TxWndProcBtnCan);
	SetWindowLong(tx[id].hBtn[2],  GWL_WNDPROC, (LONG)TxWndProcBtnApl);
	
	tx[id].tabStopIdx = 0;
	tx[id].tabStops[0] = tx[id].hEdit[0];
	tx[id].tabStops[1] = tx[id].hEdit[1];
	tx[id].tabStops[2] = tx[id].hEdit[2];
	tx[id].tabStops[3] = tx[id].hEdit[3];
	tx[id].tabStops[4] = tx[id].hRgb[0];
	tx[id].tabStops[5] = tx[id].hEdit[4];
	tx[id].tabStops[6] = tx[id].hRgb[1];
	tx[id].tabStops[7] = tx[id].hChk[0];
	tx[id].tabStops[8] = tx[id].hFtBox;
	tx[id].tabStops[9] = tx[id].hEdit[5];
	tx[id].tabStops[10]= tx[id].hChk[1];
	tx[id].tabStops[11]= tx[id].hBtn[0];
	tx[id].tabStops[12]= tx[id].hBtn[1];
	tx[id].tabStops[13]= tx[id].hBtn[2];
	SetFocus  (tx[id].hEdit[2]);
	EditSelAll(tx[id].hEdit[2]);
}

/*------------------------------------------------------------------------------
    Fvoid TxInstFt(LONG)
    FLONG      FORM ID
    @\FTEXTFTSEL̉
------------------------------------------------------------------------------*/
void TxInstFt(LONG id)
{
	DWORD styleFt    = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU;  // WS_THICKFRAME ֎~
	DWORD styleFtElm = WS_CHILD|WS_VISIBLE|WS_BORDER;
	DWORD styleFtBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	INT32 i;
	INT32 x[CNT_FONTFAMILY]={20,20,20, 20,  30, 30, 30, 30, 180,210,210, 140,140, 400,400,400,400,400,400,390, 190,190,230,230,  370,};
	INT32 y[CNT_FONTFAMILY]={20,55,90,125, 215,250,285,320,  20, 65,100, 360,395,  20, 55, 90,125,160,195,320, 160,195,260,295,  360,};
	INT32 w[CNT_FONTFAMILY]={52,95,75,116, 135,140,120,120, 100,100,125, 100,100, 160,160,160,160,160,160,145, 100,100,120,120,  100,};
	
	tx[id].ft.idx        = tx[id].ftbx.idx;
	tx[id].ft.tabStopIdx = tx[id].ftbx.idx;
	
	tx[id].hFt = a_CreateWindow(NM_TEXTFT, TxTl(E_TTLFNT), styleFt, 0, 0, 0, 0, tx[id].hWnd);
	SetWindowLong(tx[id].hFt, GWL_USERDATA, id);
	SetWindowLong(tx[id].hFt, GWL_WNDPROC, (LONG)TxWndProcFt);
	
	for (i = 0; i < CNT_FONTFAMILY; i++) {
		tx[id].ftem[i].flgClick     = FALSE;
		tx[id].ftem[i].flgHighlight = FALSE;
		tx[id].hFtElm[i] = a_CreateWindow(NM_TEXTFTELM, NULL, styleFtElm, x[i], y[i], w[i], 24, tx[id].hFt);
		SetWindowLong(tx[id].hFtElm[i], GWL_USERDATA, i*100+id);
		SetWindowLong(tx[id].hFtElm[i], GWL_WNDPROC, (LONG)TxWndProcFtElm);
		tx[id].ft.tabStops[i] = tx[id].hFtElm[i];
	}
	
	SetFocus(tx[id].hFtElm[tx[id].ft.idx]);
}

/*------------------------------------------------------------------------------
    Fvoid TxDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void TxDialog(LONG id)
{
	TxInit(id);
	TxLoad(id);
	TxTmpCreate(id, fm[id].pc[0].img.w, fm[id].pc[0].img.h);
	TxInst(id);
	PpPlacement(id, tx[id].hWnd);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = tx[id].hWnd;
	
	ShowWindow(tx[id].hPd[1], 0x1);
	ShowWindow(tx[id].hCn,    0x1);
	ShowWindow(tx[id].hPc,    0x1);
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid TxLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void TxLoad(LONG id)
{
	tx[id].fore     = g_txFore;
	tx[id].back     = g_txBack;
	tx[id].alpha    = g_txAlpha;
	tx[id].vert     = g_txVert;
	tx[id].idxFont  = g_txIdxFont;
	tx[id].size     = g_txSize;
	tx[id].ftbx.idx = g_txIdxFont;
}

/*------------------------------------------------------------------------------
    Fvoid TxStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void TxStore(LONG id)
{
	g_txFore    = tx[id].fore;
	g_txBack    = tx[id].back;
	g_txAlpha   = tx[id].alpha;
	g_txVert    = tx[id].vert;
	g_txIdxFont = tx[id].idxFont;
	g_txSize    = tx[id].size;
	g_txIdxFont = tx[id].ftbx.idx;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProc(,,,)
    F-
    ߒlF-
    @\FTEXTCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_USER:  TxUpdate(id);  break;  // WMU_RGBEND
	case WM_SIZE:           TxSize         (id, wp, lp);  break;
	case WM_GETMINMAXINFO:  TxGetMinMaxInfo(id, wp, lp);  break;
	case WM_SETFOCUS:       TxSetFocus     (id, wp, lp);  break;
	case WM_CLOSE:          TxClose        (id, wp, lp);  break;
	case WM_DESTROY:        TxDestroy      (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcPd(,,,)
    F-
    ߒlF-
    @\FTEXT PDCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idP;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:
		if (idP == 0) {
			TxPdCommand(id, wp, lp);
		}
		break;
	case WM_PAINT:
		if (idP == 0) {
			TxPdPaint(id, wp, lp);
		}
		break;
	case WM_CTLCOLORSTATIC:
		if ((HWND)lp == tx[id].hChk[0]) {return (LRESULT)hBrWhite;}
		if ((HWND)lp == tx[id].hChk[1]) {return (LRESULT)hBrWhite;}
//		if ((HWND)lp == tx[id].hWndStc) {
//			SetBkColor((HDC)wp, RGB_SKYBLUE);
//			return (LRESULT)hBrSkyBlue;
//		}
		break;
//	case WM_CTLCOLORBTN:
//	case WM_CTLCOLOREDIT:
//	case WM_CTLCOLORMSGBOX:
//	case WM_CTLCOLORLISTBOX:
//	case WM_CTLCOLORDLG:
//	case WM_CTLCOLORSCROLLBAR:
	default:  break;
	}
	
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcEditX(,,,)
    F-
    ߒlF-
    @\FTEXT EDIT XCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcEditX(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   TxEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  TxEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		TxKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (TxEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return tx[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcEditY(,,,)
    F-
    ߒlF-
    @\FTEXT EDIT YCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcEditY(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   TxEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  TxEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		TxKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (TxEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return tx[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcEditS(,,,)
    F-
    ߒlF-
    @\FTEXT EDIT Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcEditS(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   TxEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  TxEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    TxKeyDown    (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (wp == 0x09) {return 0;}  // tab
//		if (wp == 0x0D) {return 0;}  // enter
		if (wp == 0x0A) {return 0;}  // ctrl+enter  shift͕ς炸Actrl͕ς
		break;
	default:
		break;
	}
	return tx[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcEditF(,,,)
    F-
    ߒlF-
    @\FTEXT EDIT FCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcEditF(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   TxEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  TxEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    TxKeyDown    (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (TxEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return tx[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcEditB(,,,)
    F-
    ߒlF-
    @\FTEXT EDIT wiCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcEditB(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   TxEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  TxEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    TxKeyDown    (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (TxEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return tx[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcEditZ(,,,)
    F-
    ߒlF-
    @\FTEXT EDIT TCYCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcEditZ(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   TxEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  TxEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		TxKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (TxEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return tx[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcRgbF(,,,)
    F-
    ߒlF-
    @\FTEXT RGB F  Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcRgbF(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG idR;
	LONG id;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idR = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:        TxRbPaint      (id, idR, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     TxRbSetFocus   (id, idR, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    TxRbKillFocus  (id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  TxRbLButtonDown(id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    TxRbLButtonUp  (id, idR, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      TxKeyDown      (id,      wp, lp, hWnd);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcRgbB(,,,)
    F-
    ߒlF-
    @\FTEXT RGB wiCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcRgbB(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG idR;
	LONG id;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idR = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:        TxRbPaint      (id, idR, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     TxRbSetFocus   (id, idR, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    TxRbKillFocus  (id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  TxRbLButtonDown(id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    TxRbLButtonUp  (id, idR, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      TxKeyDown      (id,      wp, lp, hWnd);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcChkA(,,,)
    F-
    ߒlF-
    @\FTEXT CHK ALPHACxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcChkA(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG idC;
	LONG id;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  TxEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   TxKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	
	res = tx[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  TxChSetCheck(id, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcChkV(,,,)
    F-
    ߒlF-
    @\FTEXT CHK VERTCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcChkV(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG idC;
	LONG id;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  TxEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   TxKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	
	res = tx[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  TxChSetCheck(id, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcFtBox(,,,)
    F-
    ߒlF-
    @\FTEXT FT BOXCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcFtBox(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:     TxFtBxSetFocus   (id, wp, lp);        break;
	case WM_KILLFOCUS:    TxFtBxKillFocus  (id, wp, lp);        break;
	case WM_PAINT:        TxFtBxPaint      (id, wp, lp);        break;
	case WM_ERASEBKGND:   TxFtBxEraseBkGnd (id, wp, lp);        break;
	case WM_LBUTTONDOWN:  TxFtBxLButtonDown(id, wp, lp);        break;
	case WM_LBUTTONUP:    TxFtBxLButtonUp  (id, wp, lp);        break;
	case WM_KEYDOWN:      TxKeyDown        (id, wp, lp, hWnd);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcFt(,,,)
    F-
    ߒlF-
    @\FTEXT FTCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcFt(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:     TxFtPaint   (id, wp, lp);  break;
	case WM_SETFOCUS:  TxFtSetFocus(id, wp, lp);  break;
	case WM_CLOSE:     TxFtClose   (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcFtElm(,,,)
    F-
    ߒlF-
    @\FTEXT FT ELMCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcFtElm(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:       TxFtEmPaint      (id, idE, wp, lp);  break;
	case WM_ERASEBKGND:  TxFtEmEraseBkGnd (id, idE, wp, lp);  break;
	case WM_LBUTTONDOWN: TxFtEmLButtonDown(id, idE, wp, lp);  break;
	case WM_LBUTTONUP:   TxFtEmLButtonUp  (id, idE, wp, lp);  break;
	case WM_SETFOCUS:    TxFtEmSetFocus   (id, idE, wp, lp);  break;
	case WM_KEYDOWN:     TxFtEmKeyDown    (id, wp, lp);       break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FTEXT BTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  TxEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   TxKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return tx[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FTEXT BTN CANCELCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  TxEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   TxKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return tx[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcBtnApl(,,,)
    F-
    ߒlF-
    @\FTEXT BTN APPLYCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcBtnApl(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  TxEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   TxKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return tx[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TxWndProcPc(,,,)
    F-
    ߒlF-
    @\FTEXT PCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TxWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        TxPcPaint      (id, wp, lp);  break;
	case WM_LBUTTONDOWN:  TxPcLButtonDown(id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid TxSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT WM_SIZECxg
------------------------------------------------------------------------------*/
void TxSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	
	if (fm[id].cntSkipEdit != 0) {fm[id].cntSkipEdit--;  return;}
	
	GetClientRect(tx[id].hWnd, &rc);
	a_SetWindowPos(tx[id].hPd[1], SZ_WEDIT3, PADD8, rc.right-SZ_WEDIT3-PADD8, rc.bottom-PADD8*2);
	
	TxSetPane(id);
	TxImageView(id);
	
	a_SetWindowPos(tx[id].hPc, tx[id].pc.x, tx[id].pc.y,
							   tx[id].pc.w, tx[id].pc.h);
	
	InvalidateRect(tx[id].hWnd,   NULL, TRUE);
	InvalidateRect(tx[id].hPd[1], NULL, TRUE);
	InvalidateRect(tx[id].hCn,    NULL, TRUE);
	InvalidateRect(tx[id].hPc,    NULL, FALSE);
	UpdateWindow(tx[id].hWnd);
	UpdateWindow(tx[id].hPd[1]);
	UpdateWindow(tx[id].hCn);
	UpdateWindow(tx[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid TxGetMinMaxInfo(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT WM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void TxGetMinMaxInfo(LONG id, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	INT32 w;
	INT32 h;
	
	w = SZ_WEDIT3+PADD8*3+GetSystemMetrics(SM_CYSIZEFRAME)*2;
	h = 318      +PADD8*2+GetSystemMetrics(SM_CYSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = w;
	mmi->ptMinTrackSize.y = h;
}

/*------------------------------------------------------------------------------
    Fvoid TxSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void TxSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(tx[id].tabStops[tx[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid TxKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void TxKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  TxKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    TxKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    TxKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_SP:     TxKeyDownSpace(id, wp, lp, hWnd);  break;
	case KEY_F5:     TxKeyDownF5   (id, wp, lp, hWnd);  break;
	case KEY_UP:
	case KEY_DW:     TxKeyDownUpDw (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid TxKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT [enter]L[Cxg
------------------------------------------------------------------------------*/
void TxKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if      (hWnd == tx[id].hBtn[1]) {TxEnterCan(id);}
	else if (hWnd == tx[id].hBtn[2]) {TxEnterApl(id);}
	else                             {TxEnterOk(id);}
}

/*------------------------------------------------------------------------------
    Fvoid TxKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT [esc]L[Cxg
------------------------------------------------------------------------------*/
void TxKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(tx[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid TxKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT [tab]L[Cxg
------------------------------------------------------------------------------*/
void TxKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT8 tmp;
	BOOL shift;
	
	tmp = GetKeyState(KEY_SHIFT);
	if((tmp & 0x80)!=0){shift=TRUE;}else{shift=FALSE;}
	
	if (shift == TRUE) {
		if (tx[id].tabStopIdx == 0) {tx[id].tabStopIdx = TBSP_TEXT-1;}
		else                        {tx[id].tabStopIdx--;}
	}
	else {
		tx[id].tabStopIdx = (tx[id].tabStopIdx + 1) % TBSP_TEXT;
	}
	SetFocus(tx[id].tabStops[tx[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid TxKeyDownSpace(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT [space]L[Cxg
------------------------------------------------------------------------------*/
void TxKeyDownSpace(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (hWnd == tx[id].hFtBox) {
		TxFtCreate(id);
	}
	else if (hWnd == tx[id].hRgb[0]) {
		GetWindowText(tx[id].hEdit[3], buffRgb, 6+1);
		RbDialog(id, buffRgb, tx[id].hWnd, tx[id].hEdit[3], tx[id].hRgb[0]);
	}
	else if (hWnd == tx[id].hRgb[1]) {
		GetWindowText(tx[id].hEdit[4], buffRgb, 6+1);
		RbDialog(id, buffRgb, tx[id].hWnd, tx[id].hEdit[4], tx[id].hRgb[1]);
	}
}

/*------------------------------------------------------------------------------
    Fvoid TxKeyDownF5(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT [F5]L[Cxg
------------------------------------------------------------------------------*/
void TxKeyDownF5(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	TxUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid TxKeyDownUpDw(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT [][]L[Cxg
------------------------------------------------------------------------------*/
void TxKeyDownUpDw(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT16 tmp;
	UINT16 comb;
	BOOL shift;
	INT32 step;
	WCHAR text[4+1];
	INT32 val;
	INT32 limL;
	INT32 limH;
	
	comb  = 0x000;
	shift = FALSE;
	tmp = GetKeyState(KEY_CTRL);   if((tmp & 0x80)!=0){comb |= 0x100;}
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){comb |= 0x010;  shift = TRUE;}
	
	if ((hWnd != tx[id].hEdit[0]) &&
		(hWnd != tx[id].hEdit[1]) &&
		(hWnd != tx[id].hEdit[5]))
	{
		return;
	}
	
	if      (comb == 0x000) {step = 1;}
	else if (comb == 0x100) {step = 10;}
	else if (comb == 0x010) {step = 100;}
	else                    {return;}
	
	GetWindowText(hWnd, text, 4+1);
	val = _wtoi(text);
	
	if      (hWnd == tx[id].hEdit[0]) {limL = -999;  limH = 9999;}
	else if (hWnd == tx[id].hEdit[1]) {limL = -999;  limH = 9999;}
	else                              {limL = 0;     limH = 999;}
	
	if (wp == KEY_UP) {val += step;}
	else              {val -= step;}
	
	if (val < limL) {val = limL;}
	if (limH < val) {val = limH;}
	
	_itow(val, text, 10);
	SetWindowText(hWnd, text);
	EditSelAll(hWnd);
	
	TxUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid TxClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT WM_CLOSECxg
------------------------------------------------------------------------------*/
void TxClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid TxDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT WM_DESTROYCxg
------------------------------------------------------------------------------*/
void TxDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	TxTmpDelete(id);
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid TxPdCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT WM_COMMANDCxg
------------------------------------------------------------------------------*/
void TxPdCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if      ((HWND)lp == tx[id].hBtn[0]) {TxEnterOk(id);}
	else if ((HWND)lp == tx[id].hBtn[1]) {TxEnterCan(id);}
	else if ((HWND)lp == tx[id].hBtn[2]) {TxEnterApl(id);}
}

/*------------------------------------------------------------------------------
    Fvoid TxPdPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT PD WM_PAINTCxg
------------------------------------------------------------------------------*/
void TxPdPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1;
	INT32 x2, y2;
	INT32 x3, y3;
	INT32 x4, y4;
	INT32 x5, y5;
	
	hdc = BeginPaint(tx[id].hPd[0], &ps);
	GetClientRect(tx[id].hPd[0], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	a_TextOut(hdc, 59, 13, L"X");
	a_TextOut(hdc, 59, 43, L"Y");
	
	switch (g_idxLang) {
	case 0:
		x1 = 48;
		x2 = 54;
		x3 = 48;
		x4 = 43;
		x5 = 43;
		break;
	case 1:
		x1 = 48;
		x2 = 48;
		x3 = 48;
		x4 = 48;
		x5 = 48;
		break;
	default: break;
	}
	y1 = 73;
	y2 = 103;
	y3 = 133;
	y4 = 193;
	y5 = 223;
	a_TextOut(hdc, x1, y1, TxEd(E_TXTEXT));
	a_TextOut(hdc, x2, y2, TxEd(E_TXFORE));
	a_TextOut(hdc, x3, y3, TxEd(E_TXBACK));
	a_TextOut(hdc, x4, y4, TxEd(E_TXFONT));
	a_TextOut(hdc, x5, y5, TxEd(E_TXSIZE));
	
	SelectClipRgn(hdc, NULL);
	EndPaint(tx[id].hPd[0], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid TxEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void TxEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_TEXT; i++) {
		if (hWnd == tx[id].tabStops[i]) {
			tx[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
	
//	WCHAR name[20];
//	GetClassName(hWnd, name, 20);
//	if (wcscmp(name, L"Edit") == 0) {EditSelAll(hWnd);}
}

/*------------------------------------------------------------------------------
    Fvoid TxEdKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void TxEdKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_TEXT; i++) {
		if ((HWND)wp == tx[id].tabStops[i]) {
			TxUpdate(id);
			break;
		}
	}
}

/*------------------------------------------------------------------------------
    FBOOL TxEdChar(LONG, WPARAM, LPARAM, HWND )
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    ߒlFBOOL    -
    @\FTEXT WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL TxEdChar(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if ((hWnd == tx[id].hEdit[0]) ||
		(hWnd == tx[id].hEdit[1]))
	{
		if (wp == 0x2D) {return TRUE;}	// -
		
		if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	}
	else if (hWnd == tx[id].hEdit[5]) {
		if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	}
	else if ((hWnd == tx[id].hEdit[3]) ||
			 (hWnd == tx[id].hEdit[4]))
	{
		if (((0x30 <= wp) && (wp <= 0x39)) ||  // 0-9
			((0x41 <= wp) && (wp <= 0x46)) ||  // a-f
			((0x61 <= wp) && (wp <= 0x66)))    // A-F
		{
			return TRUE;
		}
	}
	
	switch (wp) {
	case 0x03:  // ctrl+C
	case 0x08:  // back space
	case 0x16:  // ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid TxRbPaint(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT RGBBOX WM_PAINTCxg
------------------------------------------------------------------------------*/
void TxRbPaint(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	RbBoxPaint(id, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid TxRbSetFocus(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT RGBBOX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void TxRbSetFocus(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_TEXT; i++) {
		if ((HWND)wp == tx[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
	
	TxEdSetFocus(id, wp, lp, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid TxRbKillFocus(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT RGBBOX WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void TxRbKillFocus(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_TEXT; i++) {
		if ((HWND)wp == tx[id].tabStops[i]) {
			res = TRUE;
		}
	}
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid TxRbLButtonDown(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT RGBBOX WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void TxRbLButtonDown(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	tx[id].flgClick[idR] = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid TxRbLButtonUp(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FTEXT RGBBOX WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void TxRbLButtonUp(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (tx[id].flgClick[idR] == FALSE) {return;}
	tx[id].flgClick[idR] = FALSE;
	SetFocus(hWnd);
	
	GetWindowText(tx[id].hEdit[3+idR], buffRgb, 6+1);
	RbDialog(id, buffRgb, tx[id].hWnd, tx[id].hEdit[3+idR], tx[id].hRgb[idR]);
}

/*------------------------------------------------------------------------------
    Fvoid TxChSetCheck(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT CHECK BM_SETCHECKCxg
------------------------------------------------------------------------------*/
void TxChSetCheck(LONG id, WPARAM wp, LPARAM lp)
{
	TxUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid TxFtBxSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT BOX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void TxFtBxSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_TEXT; i++) {
		if ((HWND)wp == tx[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(tx[id].hFtBox, NULL, TRUE);
		UpdateWindow  (tx[id].hFtBox);
	}
	
	TxEdSetFocus(id, wp, lp, tx[id].hFtBox);
}

/*------------------------------------------------------------------------------
    Fvoid TxFtBxKillFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT BOX WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void TxFtBxKillFocus(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_TEXT; i++) {
		if ((HWND)wp == tx[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(tx[id].hFtBox, NULL, TRUE);
		UpdateWindow  (tx[id].hFtBox);
	}
}

/*------------------------------------------------------------------------------
    Fvoid TxFtBxPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT BOX WM_PAINTCxg
------------------------------------------------------------------------------*/
void TxFtBxPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	HFONT hFt;
	HFONT old;
	RECT rc;
	SIZE sz;
	INT32 w, h;
	WCHAR *pFmy;
	HWND hWnd;
	COLORREF color;
	
	hdc = BeginPaint(tx[id].hFtBox, &ps);
	GetClientRect(tx[id].hFtBox, &rc);
	SetClipRgn(hdc, &rc);
	
	hWnd = GetFocus();
	if (hWnd == tx[id].hFtBox) {color = RGB_WHITE;}
	else                       {color = RGB_BLACK;}
	SetTextColor(hdc, color);
	SetBkMode(hdc, TRANSPARENT);
	
	pFmy = (WCHAR *)TxFf(tx[id].ftbx.idx);
	hFt = a_CreateFont(14, pFmy);
	
	old = (HFONT)SelectObject(hdc, hFt);
	
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	
	GetTextExtentPoint32(hdc, pFmy, wcslen(pFmy), &sz);
	
	a_TextOut(hdc, (w - sz.cx) / 2, (h - sz.cy) / 2, pFmy);
	
	SelectObject(hdc, old);
	DeleteObject(hFt);
	SelectClipRgn(hdc, NULL);
	EndPaint(tx[id].hFtBox, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid TxFtBxEraseBkGnd(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT BOX WM_PAINTCxg
------------------------------------------------------------------------------*/
void TxFtBxEraseBkGnd(LONG id, WPARAM wp, LPARAM lp)
{
	HWND hWnd;
	HBRUSH hBr;
	
	hWnd = GetFocus();
	if (hWnd == tx[id].hFtBox) {hBr = hBrSelBlue;}
	else                       {hBr = hBrWhite;}
	
	SetClassLong(tx[id].hFtBox, GCL_HBRBACKGROUND, (LONG)hBr);
}

/*------------------------------------------------------------------------------
    Fvoid TxFtBxLButtonDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT BOX WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void TxFtBxLButtonDown(LONG id, WPARAM wp, LPARAM lp)
{
	tx[id].ftbx.flgClick = TRUE;
	SetCapture(tx[id].hFtBox);
}

/*------------------------------------------------------------------------------
    Fvoid TxFtBxLButtonUp(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT BOX WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void TxFtBxLButtonUp(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 x;
	INT32 y;
	RECT rc;
	
	GetClientRect(tx[id].hFtBox, &rc);
	x = LOWORD(lp);
	y = HIWORD(lp);
	
	if ((tx[id].ftbx.flgClick == TRUE) &&
		(rc.left <= x) && (x <= rc.right) &&
		(rc.top  <= y) && (y <= rc.bottom))
	{
		SetFocus(tx[id].hFtBox);
		TxFtCreate(id);
	}
	
	tx[id].ftbx.flgClick = FALSE;
	ReleaseCapture();
}

/*------------------------------------------------------------------------------
    Fvoid TxFtPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT WM_PAINTCxg
------------------------------------------------------------------------------*/
void TxFtPaint(LONG id, WPARAM wp, LPARAM lp)
{
//	HDC hdc;
//	PAINTSTRUCT ps;
//	RECT rc;
//	
//	hdc = BeginPaint(tx[id].hFt, &ps);
//	GetClientRect(tx[id].hFt, &rc);
//	SetClipRgn(hdc, &rc);
//	SelectObject(hdc, hBrWhite);
//	
//	PatBlt(hdc, rc.left+PADD8,
//				rc.top+PADD8,
//				rc.right-rc.left-PADD8*2,
//				rc.bottom-rc.top-PADD8*2, PATCOPY);
//	
//	SelectClipRgn(hdc, NULL);
//	EndPaint(tx[id].hFt, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid TxFtSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void TxFtSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(tx[id].ft.tabStops[tx[id].ft.tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid TxFtClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT SEL WM_CLOSECxg
------------------------------------------------------------------------------*/
void TxFtClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = tx[id].hWnd;
	EnableWindow(tx[id].hWnd, TRUE);
	SetForegroundWindow(tx[id].hWnd);
	SetFocus(tx[id].hFtBox);
}

/*------------------------------------------------------------------------------
    Fvoid TxFtEmPaint(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    ELEM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT ELM WM_PAINTCxg
------------------------------------------------------------------------------*/
void TxFtEmPaint(LONG id, LONG idE, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	HFONT hFt;
	HFONT old;
	RECT rc;
	SIZE sz;
	INT32 w, h;
	WCHAR *pFmy;
	HWND hWnd;
	COLORREF color;
	
	hdc = BeginPaint(tx[id].hFtElm[idE], &ps);
	GetClientRect(tx[id].hFtElm[idE], &rc);
	SetClipRgn(hdc, &rc);
	
	hWnd = GetFocus();
	if (hWnd == tx[id].hFtElm[idE]) {color = RGB_WHITE;}
	else                            {color = RGB_BLACK;}
	SetTextColor(hdc, color);
	SetBkMode(hdc, TRANSPARENT);
	
	pFmy = (WCHAR *)TxFf(idE);
	hFt = a_CreateFont(20, pFmy);
	
	old = (HFONT)SelectObject(hdc, hFt);
	
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	
	GetTextExtentPoint32(hdc, pFmy, wcslen(pFmy), &sz);
	
	a_TextOut(hdc, (w - sz.cx) / 2, (h - sz.cy) / 2, pFmy);
	
	SelectObject(hdc, old);
	DeleteObject(hFt);
	SelectClipRgn(hdc, NULL);
	EndPaint(tx[id].hFtElm[idE], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid TxFtEmEraseBkGnd(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    ELEM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT ELM WM_ERASEBKGNDCxg
------------------------------------------------------------------------------*/
void TxFtEmEraseBkGnd(LONG id, LONG idE, WPARAM wp, LPARAM lp)
{
	HWND hWnd;
	HBRUSH hBr;
	
	hWnd = GetFocus();
	if (hWnd == tx[id].hFtElm[idE]) {hBr = hBrSelBlue;}
	else                            {hBr = hBrWhite;}
	
	SetClassLong(tx[id].hFtElm[idE], GCL_HBRBACKGROUND, (LONG)hBr);
}

/*------------------------------------------------------------------------------
    Fvoid TxFtEmLButtonDown(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    ELEM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT ELM WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void TxFtEmLButtonDown(LONG id, LONG idE, WPARAM wp, LPARAM lp)
{
	tx[id].ftem[idE].flgClick = TRUE;
	SetCapture(tx[id].hFtElm[idE]);
}

/*------------------------------------------------------------------------------
    Fvoid TxFtEmLButtonUp(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    ELEM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT ELM WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void TxFtEmLButtonUp(LONG id, LONG idE, WPARAM wp, LPARAM lp)
{
	INT32 x;
	INT32 y;
	RECT rc;
	
	GetClientRect(tx[id].hFtElm[idE], &rc);
	x = LOWORD(lp);
	y = HIWORD(lp);
	
	if ((tx[id].ftem[idE].flgClick == TRUE) &&
		(rc.left <= x) && (x <= rc.right) &&
		(rc.top  <= y) && (y <= rc.bottom))
	{
		tx[id].ft.idx        = idE;
		tx[id].ft.tabStopIdx = idE;
		SetFocus(tx[id].hFtElm[idE]);
	}
	
	tx[id].ftem[idE].flgClick = FALSE;
	ReleaseCapture();
	
	tx[id].ftbx.idx = tx[id].ft.idx;
	CLOSE(tx[id].hFt);
	InvalidateRect(tx[id].hFtBox, NULL, TRUE);
	UpdateWindow(tx[id].hFtBox);
	InvalidateRect(tx[id].hPc, NULL, FALSE);
	UpdateWindow(tx[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid TxFtEmSetFocus(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    ELEM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT ELM WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void TxFtEmSetFocus(LONG id, LONG idE, WPARAM wp, LPARAM lp)
{
	INT32 i;
	HWND hWndFocus;
	
	for (i = 0; i < CNT_FONTFAMILY; i++) {
		hWndFocus = tx[id].hFtElm[i];
		
		if (i == idE) {
			if (tx[id].ftem[i].flgHighlight == FALSE) {
				InvalidateRect(hWndFocus, NULL, TRUE);
				UpdateWindow(hWndFocus);
			}
			tx[id].ftem[i].flgHighlight = TRUE;
		}
		else {
			if (tx[id].ftem[i].flgHighlight == TRUE) {
				InvalidateRect(hWndFocus, NULL, TRUE);
				UpdateWindow(hWndFocus);
			}
			tx[id].ftem[i].flgHighlight = FALSE;
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid TxFtEmKeyDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT FT ELM WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void TxFtEmKeyDown(LONG id, WPARAM wp, LPARAM lp)
{
	INT16 tmp;
	BOOL shift;
	
	shift = FALSE;
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){shift = TRUE;}
	
	switch (wp) {
	case KEY_ENTER:
		tx[id].ftbx.idx = tx[id].ft.idx;
		CLOSE(tx[id].hFt);
		InvalidateRect(tx[id].hFtBox, NULL, TRUE);
		UpdateWindow(tx[id].hFtBox);
		TxUpdate(id);
		break;
	case KEY_ESC:
		CLOSE(tx[id].hFt);
		break;
	case KEY_TAB:
		if (shift == TRUE) {
			if (tx[id].ft.tabStopIdx == 0) {tx[id].ft.tabStopIdx = CNT_FONTFAMILY-1;}
			else                              {tx[id].ft.tabStopIdx--;}
		}
		else {
			tx[id].ft.tabStopIdx = (tx[id].ft.tabStopIdx + 1) % CNT_FONTFAMILY;
		}
		
		tx[id].ft.idx = tx[id].ft.tabStopIdx;
		
		SetFocus(tx[id].ft.tabStops[tx[id].ft.tabStopIdx]);
		break;
	case KEY_RT:
	case KEY_DW:
		tx[id].ft.tabStopIdx = (tx[id].ft.tabStopIdx + 1) % CNT_FONTFAMILY;
		tx[id].ft.idx = tx[id].ft.tabStopIdx;
		SetFocus(tx[id].ft.tabStops[tx[id].ft.tabStopIdx]);
		break;
	case KEY_LF:
	case KEY_UP:
		if (tx[id].ft.tabStopIdx == 0) {tx[id].ft.tabStopIdx = CNT_FONTFAMILY-1;}
		else                              {tx[id].ft.tabStopIdx--;}
		tx[id].ft.idx = tx[id].ft.tabStopIdx;
		SetFocus(tx[id].ft.tabStops[tx[id].ft.tabStopIdx]);
		break;
	default:
		break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid TxPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT PC WM_PAINTCxg
------------------------------------------------------------------------------*/
void TxPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1, w1, h1;
	INT32 x2, y2, w2, h2;
	INT32 mode;
//	INT32 i;
//	INT32 j;
//	BYTE *pB1, *pB2;
	
	hdc = BeginPaint(tx[id].hPc, &ps);
	GetClientRect(tx[id].hPc, &rc);
	SetClipRgn(hdc, &rc);
	
	x2 = 0;
	y2 = 0;
	w2 = tx[id].pc.w;
	h2 = tx[id].pc.h;
	x1 = 0;
	y1 = 0;
	w1 = fm[id].pc[0].img.w;
	h1 = fm[id].pc[0].img.h;
	
	if (tx[id].pc.percent < 10000) {mode = HALFTONE;}
	else                              {mode = COLORONCOLOR;}
	
//	BitBlt(tx[id].pc.tmp.hdc,  x1, y1, w1, h1,
//		   fm[id].pc[0].img.hdc, x1, y1, SRCCOPY);
	
//	pB1 = fm[id].pc[0].img.pB;
//	pB2 = tx[id].pc.tmp.pB;
//	for (i = 0; i < h1; i++) {
//		for (j = 0; j < w1; j++) {
//			*(pB2+2) = *(pB1+2);
//			*(pB2+1) = *(pB1+1);
//			*(pB2+0) = *(pB1+0);
//			pB1 += 4;
//			pB2 += 4;
//		}
//	}
	
	memcpy(tx[id].pc.tmp.pB, fm[id].pc[0].img.pB, w1 * h1 * 4);
	
	TxTmpDraw(id);
	
	SetStretchBltMode(hdc, mode);
	StretchBlt(hdc,                 x2, y2, w2, h2,
			   tx[id].pc.tmp.hdc, x1, y1, w1, h1, SRCCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w2;
	rc.bottom = h2;
	FrameRect(hdc, &rc, hBrGray);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(tx[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid TxPcLButtonDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXT PC WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void TxPcLButtonDown(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 x;
	INT32 y;
	INT32 xStr;
	INT32 yStr;
	WCHAR buff[2][10+1];
	
	x = LOWORD(lp);
	y = HIWORD(lp);
	
	xStr = (double)(x * fm[id].pc[0].img.w) / tx[id].pc.w;
	yStr = (double)(y * fm[id].pc[0].img.h) / tx[id].pc.h;
	
	_itow(xStr, buff[0], 10);
	_itow(yStr, buff[1], 10);
	SetWindowText(tx[id].hEdit[0], buff[0]);
	SetWindowText(tx[id].hEdit[1], buff[1]);
	UpdateWindow (tx[id].hEdit[0]);
	UpdateWindow (tx[id].hEdit[1]);
	
	TxUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid TxEnterOk(LONG id)
    FLONG    FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void TxEnterOk(LONG id)
{
	WCHAR buffFore[6+1];
	WCHAR buffBack[6+1];
	WCHAR buffSz  [3+1];
	INT32 checked[2];
	
	TxUpdate(id);
	if (tx[id].flgUpdate == FALSE) {CLOSE(tx[id].hWnd);  return;}
	
	memcpy(fm[id].pc[0].img.pB, tx[id].pc.tmp.pB, fm[id].pc[0].img.w * fm[id].pc[0].img.h * 4);
	LiImageDelete(id, 0);
	
	InvalidateRect(fm[id].hPict[0],  NULL, TRUE);
	UpdateWindow(fm[id].hPict[0]);
	
	fm[id].flgText = TRUE;
	SetFormText(id);
	MnFlushFile(id);
	
	GetWindowText(tx[id].hEdit[3], buffFore, 6+1);
	GetWindowText(tx[id].hEdit[4], buffBack, 6+1);
	GetWindowText(tx[id].hEdit[5], buffSz,   3+1);
	
	tx[id].fore = _wtoh(buffFore, 6);
	tx[id].back = _wtoh(buffBack, 6);
	tx[id].size = _wtoi(buffSz);
	
	checked[0] = B_GETCHECK(tx[id].hChk[0]);
	checked[1] = B_GETCHECK(tx[id].hChk[1]);
	if (g_idxLang == 0) {
		if (checked[0] == BST_CHECKED) {tx[id].alpha = TRUE;}
		else                           {tx[id].alpha = FALSE;}
	}
	else {
		if (checked[0] == BST_CHECKED) {tx[id].alpha = FALSE;}
		else                           {tx[id].alpha = TRUE;}
	}
	if (checked[1] == BST_CHECKED) {tx[id].vert = TRUE;}
	else                           {tx[id].vert = FALSE;}
	
	TxStore(id);
	CLOSE(tx[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid TxEnterCan(LONG id)
    FLONG    FORM ID
    @\F[CANCEL]{^s
------------------------------------------------------------------------------*/
void TxEnterCan(LONG id)
{
	CLOSE(tx[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid TxEnterApl(LONG id)
    FLONG    FORM ID
    @\F[APPLY]{^s
------------------------------------------------------------------------------*/
void TxEnterApl(LONG id)
{
	WCHAR fmt[100] = L"%d\r\n"
					 L"%d\r\n"
					 L"%s\r\n"
					 L"%s\r\n"
					 L"%s\r\n"
					 L"%s\r\n"
					 L"%d\r\n"
					 L"%d\r\n"
					 L"%s\r\n";
	WCHAR str[100];
	WCHAR strFore [6+1];
	WCHAR strBack [6+1];
	WCHAR strAlpha[5+1];
	WCHAR strVert [5+1];
	
	TxUpdate(id);
	memcpy(fm[id].pc[0].img.pB, tx[id].pc.tmp.pB, fm[id].pc[0].img.w * fm[id].pc[0].img.h * 4);
	LiImageDelete(id, 0);
	
	InvalidateRect(fm[id].hPict[0], NULL, TRUE);
	UpdateWindow(fm[id].hPict[0]);
	
	fm[id].flgText = TRUE;
	SetFormText(id);
	
	_rtow(tx[id].fore,  strFore);
	_rtow(tx[id].back,  strBack);
	_btow(tx[id].alpha, strAlpha);
	_btow(tx[id].vert,  strVert);
	swprintf(str, fmt, tx[id].x,
					   tx[id].y,
					   tx[id].text,
					   strFore,
					   strBack,
					   strAlpha,
					   tx[id].idxFont,
					   tx[id].size,
					   strVert);
	MessageBox(tx[id].hWnd, str, TxEd(E_APPLY), MB_OK);
}

/*------------------------------------------------------------------------------
    Fvoid TxUpdate(LONG id)
    FLONG    FORM ID
    @\F̕\XV
------------------------------------------------------------------------------*/
void TxUpdate(LONG id)
{
	WCHAR strEditX[4+1];
	WCHAR strEditY[4+1];
	WCHAR strEditS[100+1];
	WCHAR strEditC[6+1];
	WCHAR strEditB[6+1];
	WCHAR strEditZ[6+1];
	INT32 x;
	INT32 y;
	INT32 fore;
	INT32 back;
	BOOL  alpha;
	BOOL  vert;
	INT32 idxFont;
	INT32 size;
	INT32 checked[2];
	
	GetWindowText(tx[id].hEdit[0], strEditX, 4+1);
	GetWindowText(tx[id].hEdit[1], strEditY, 4+1);
	GetWindowText(tx[id].hEdit[2], strEditS, 100+1);
	GetWindowText(tx[id].hEdit[3], strEditC, 6+1);
	GetWindowText(tx[id].hEdit[4], strEditB, 6+1);
	GetWindowText(tx[id].hEdit[5], strEditZ, 3+1);
	
	x = _wtoi(strEditX);
	y = _wtoi(strEditY);
	fore = _wtoh(strEditC, 6);
	back = _wtoh(strEditB, 6);
	checked[0] = B_GETCHECK(tx[id].hChk[0]);
	checked[1] = B_GETCHECK(tx[id].hChk[1]);
	if (g_idxLang == 0) {
		if (checked[0] == BST_CHECKED) {alpha = TRUE;}
		else                           {alpha = FALSE;}
	}
	else {
		if (checked[0] == BST_CHECKED) {alpha = FALSE;}
		else                           {alpha = TRUE;}
	}
	if (checked[1] == BST_CHECKED) {vert = TRUE;}
	else                           {vert = FALSE;}
	idxFont = tx[id].ftbx.idx;
	size    = _wtoi(strEditZ);
	
	if ((x != tx[id].x) ||
		(y != tx[id].y) ||
		(wcscmp(strEditS, tx[id].text) != 0) ||
		(fore    != tx[id].fore)    ||
		(back    != tx[id].back)    ||
		(alpha   != tx[id].alpha)   ||
		(vert    != tx[id].vert)    ||
		(idxFont != tx[id].idxFont) ||
		(size    != tx[id].size))
	{
		InvalidateRect(tx[id].hPc, NULL, FALSE);
		UpdateWindow(tx[id].hPc);
		
		tx[id].flgUpdate = TRUE;
	}
	
	tx[id].x = x;
	tx[id].y = y;
	wcscpy(tx[id].text, strEditS);
	tx[id].fore    = fore;
	tx[id].back    = back;
	tx[id].alpha   = alpha;
	tx[id].vert    = vert;
	tx[id].idxFont = idxFont;
	tx[id].size    = size;
}

/*------------------------------------------------------------------------------
    Fvoid TxFtCreate(LONG id)
    FLONG    FORM ID
    @\FtHgIJ
------------------------------------------------------------------------------*/
void TxFtCreate(LONG id)
{
	WINDOWPLACEMENT plcm;
	RECT rc;
	
	TxInstFt(id);
	
	GetWindowRect(tx[id].hWnd, &rc);
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = rc.left + 10;
	plcm.rcNormalPosition.top    = rc.top  + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + 590;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + 470;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(tx[id].hFt, &plcm);
	
	EnableWindow(tx[id].hWnd, FALSE);
	fm[id].hModal = tx[id].hFt;
}

/*------------------------------------------------------------------------------
    Fvoid TxTmpCreate(LONG, INT32, INT32)
    FLONG     FORM ID
          INT32    
          INT32    
    @\F ꎞC[W쐬
------------------------------------------------------------------------------*/
void TxTmpCreate(LONG id, INT32 w, INT32 h)
{
	ImageCreate(&tx[id].pc.tmp, w, h);
}

/*------------------------------------------------------------------------------
    Fvoid TxTmpDraw(LONG)
    FLONG     FORM ID
    @\F ꎞC[W`
------------------------------------------------------------------------------*/
void TxTmpDraw(LONG id)
{
	HDC hdc;
	WCHAR buffX   [4+1];
	WCHAR buffY   [4+1];
	WCHAR buffStr [100+1];
	WCHAR buffFore[6+1];
	WCHAR buffBack[6+1];
	WCHAR buffSz  [3+1];
	INT32 x;
	INT32 y;
	INT32 rgbFore;
	INT32 rgbBack;
	INT32 rFore, gFore, bFore;
	INT32 rBack, gBack, bBack;
	HFONT hFt;
	HFONT hFtOld;
	WCHAR *pFmy;
	INT32 size;
	INT32 checked[2];
	INT32 mode;
	RECT rc;
	WCHAR fmy[50];
	INT32 escapement;
	INT32 xMv;
	
	hdc = tx[id].pc.tmp.hdc;
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = tx[id].pc.tmp.w;
	rc.bottom = tx[id].pc.tmp.h;
	SetClipRgn(hdc, &rc);
	
	GetWindowText(tx[id].hEdit[0], buffX,    4+1);
	GetWindowText(tx[id].hEdit[1], buffY,    4+1);
	GetWindowText(tx[id].hEdit[2], buffStr,  100+1);
	GetWindowText(tx[id].hEdit[3], buffFore, 6+1);
	GetWindowText(tx[id].hEdit[4], buffBack, 6+1);
	GetWindowText(tx[id].hEdit[5], buffSz,   3+1);
	x    = _wtoi(buffX);
	y    = _wtoi(buffY);
	size = _wtoi(buffSz);
	
	rgbFore = _wtoh(buffFore, 6);
	rgbBack = _wtoh(buffBack, 6);
	
	size = _wtoi(buffSz);
	
	checked[0] = B_GETCHECK(tx[id].hChk[0]);
	checked[1] = B_GETCHECK(tx[id].hChk[1]);
	
	pFmy = (WCHAR *)TxFf(tx[id].ftbx.idx);
	
	if (checked[1] == BST_CHECKED) {swprintf(fmy, L"@%s", pFmy); xMv = size; escapement = 2700;}
	else                           {swprintf(fmy, L"%s",  pFmy); xMv = 0;    escapement = 0;}
	
	hFt = CreateFont(size,
					 0,
					 escapement,
					 0,
					 FW_DONTCARE,
					 FALSE,
					 FALSE,
					 FALSE,
					 ANSI_CHARSET,
					 OUT_DEFAULT_PRECIS,
					 CLIP_DEFAULT_PRECIS,
//					 CLEARTYPE_QUALITY,
					 DEFAULT_QUALITY,
					 DEFAULT_PITCH|FF_DONTCARE,
					 fmy);
	
	rFore = (rgbFore & 0x00FF0000) >> 16;
	gFore = (rgbFore & 0x0000FF00) >> 8;
	bFore = (rgbFore & 0x000000FF) >> 0;
	rBack = (rgbBack & 0x00FF0000) >> 16;
	gBack = (rgbBack & 0x0000FF00) >> 8;
	bBack = (rgbBack & 0x000000FF) >> 0;
	SetTextColor(hdc, RGB(rFore,gFore,bFore));
	SetBkColor  (hdc, RGB(rBack,gBack,bBack));
	
	if (g_idxLang == 0) {
		if (checked[0] == BST_CHECKED) {mode = TRANSPARENT;}
		else                           {mode = OPAQUE;}
	}
	else {
		if (checked[0] == BST_CHECKED) {mode = OPAQUE;}
		else                           {mode = TRANSPARENT;}
	}
	SetBkMode(hdc, mode);
	
	hFtOld = (HFONT)SelectObject(hdc, hFt);
	
	a_TextOut(hdc, x+xMv, y, buffStr);
	
	SelectObject(hdc, hFtOld);
	DeleteObject(hFt);
	SelectClipRgn(hdc, NULL);
}

/*------------------------------------------------------------------------------
    Fvoid TxTmpDelete(LONG)
    FLONG     FORM ID
    @\F ꎞC[W폜
------------------------------------------------------------------------------*/
void TxTmpDelete(LONG id)
{
	DeleteDC    (tx[id].pc.tmp.hdc);
	DeleteObject(tx[id].pc.tmp.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid TxImageView(LONG)
    FLONG    FORM ID
    @\F͈͕\p
------------------------------------------------------------------------------*/
void TxImageView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	
	if (IsBit(fm[id].pc[0].img.stat, BIT_NONE|BIT_FAILURE)) {return;}
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	gainW = (double)tx[id].cn.w / fm[id].pc[0].img.w;
	gainH = (double)tx[id].cn.h / fm[id].pc[0].img.h;
	
	if ((1 < gainW) && (1 < gainH)) {
		gainW = gainH = (double)1;
	}
	else {
		if (CmpGain(gainW, gainH) == TRUE) {
			limW = TRUE;
			limH = TRUE;
		}
		else {
			if (gainW < gainH) {
				gainH = gainW;
				limW = TRUE;
			}
			else {
				gainW = gainH;
				limH = TRUE;
			}
		}
	}
	
	x = (double)tx[id].cn.w / 2 - (double)fm[id].pc[0].img.w * gainW / 2;
	y = (double)tx[id].cn.h / 2 - (double)fm[id].pc[0].img.h * gainH / 2;
	w = (double)fm[id].pc[0].img.w * gainW;
	h = (double)fm[id].pc[0].img.h * gainH;
	
	if (limW == TRUE) {x = 0;  w = tx[id].cn.w;}
	if (limH == TRUE) {y = 0;  h = tx[id].cn.h;}
	
	if (limW == TRUE) {TryZeroDivision(fm[id].pc[0].img.w);  tx[id].pc.percent = ((double)w / fm[id].pc[0].img.w) * 10000;}
	else              {TryZeroDivision(fm[id].pc[0].img.h);  tx[id].pc.percent = ((double)h / fm[id].pc[0].img.h) * 10000;}
	
	tx[id].pc.x = x;
	tx[id].pc.y = y;
	if (w <= 0) {tx[id].pc.w = 1;}
	else        {tx[id].pc.w = w;}
	if (h <= 0) {tx[id].pc.h = 1;}
	else        {tx[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    Fvoid TxSetPane(LONG)
    FLONG    FORM ID
    @\F̕\̘g\
------------------------------------------------------------------------------*/
void TxSetPane(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(tx[id].hPd[1], &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	a_SetWindowPos(tx[id].hCn, PADD8, PADD8, w-PADD8*2, h-PADD8*2);
	
	GetClientRect(tx[id].hCn, &rc);
	tx[id].cn.x = rc.left;
	tx[id].cn.y = rc.top;
	tx[id].cn.w = rc.right - rc.left;
	tx[id].cn.h = rc.bottom - rc.top;
}
