/** geocode.cpp
 * ZEܓxEoxɊւNXFC++\[X
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + cURL + OpenSSL + Boost C++ Libraries
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01-12-01.shtm
 */
#include <iostream>
#include <iomanip>
#include <fstream>
#include <winsock2.h>
#include <windows.h>
#include <shlobj.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <tchar.h>
#include <sstream>
#include <string>
#include <regex>
#include <locale>
#include <boost/format.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/property_tree/json_parser.hpp>
#include "apikey.h"
#include "pahooGeocode.hpp"
#include "mystrings.h"
#include "resource.h"

using namespace std;
using namespace boost;
using namespace boost::property_tree;

/**
 * RXgN^
 * @param	string appname AvP[V
 */
pahooGeocode::pahooGeocode(std::string appname) {
	this->appname = appname;
	this->readGoogleApiKey();
	// zbgybp[OWebT[rX APIL[ǂݍ
	readApiKey(FNAME_YAHOO_API, &this->YahooAPIkey);
}

// fXgN^
pahooGeocode::~pahooGeocode() {
}

// e폈 ==================================================================
/**
 * G[
 * @param	Ȃ
 * @return	bool TRUE:ُ^FALSE:
*/
bool pahooGeocode::isError(void) {
	return this->errmsg.length() > 0;
}

/**
 * G[bZ[W擾
 * @param	Ȃ
 * @return	wstring ݔĂG[bZ[W
*/
wstring pahooGeocode::getError(void) {
	return this->errmsg;
}

/**
 * G[Zbg
 * @param	Ȃ
 * @return	Ȃ
*/
void pahooGeocode::resetError(void) {
	this->errmsg = L"";
}

/**
 * G[Zbg
 * @param	wstring msg G[bZ[W
 * @return	Ȃ
*/
void pahooGeocode::setError(wstring msg) {
	this->errmsg = msg;
}

/**
 * ߂ŎgpWebAPIURL擾
 * @param	Ȃ
 * @return	string URL
*/
string pahooGeocode::getwebapi(void) {
	return this->webapi;
}

/**
 * GoogleNEhT[rXAPIL[ݒ肳Ă邩ǂԂD
 * @param	Ȃ
 * @return	bool TRUE:ݒρ^FALSE:ݒ
*/
bool pahooGeocode::isGoogleApiKey(void) {
	return this->GoogleAPIkey.length() > 0;
}

// APIL[ =============================================================
/**
 * Google Cloud Platform APIL[ǂݍ
 * @param	Ȃ
 * @return	bool TRUEFǍ^FALSEFt@CȂ
 */
bool pahooGeocode::readGoogleApiKey(void) {
	string key;
	bool ret = FALSE;

	ifstream ifs((string)getMyPath(this->appname.c_str()) + FNAME_GOOGLE_API);
	// APIL[Et@CΏ
	if (!ifs) {
		this->GoogleAPIkey = "";
		this->GoogleMap1 = "";
		this->GoogleMap2 = "";
		this->GoogleMap3 = "";
		this->GoogleMap4 = "";
		return ret;
	}

	// APIL[ǂݍ
	ifs >> key;
	if(ifs.bad()) {
		this->errmsg = _SW("Google Cloud Platform APIL[̓ǂݍ݂Ɏs܂");
		ifs.close();
		this->GoogleAPIkey = "";
		this->GoogleMap1 = "";
		this->GoogleMap2 = "";
		this->GoogleMap3 = "";
		this->GoogleMap4 = "";
		return FALSE;
	}
	ifs.close();

	// APIL[Ȃǂ̐ݒ
	if (key.length() > 0) {
		this->GoogleAPIkey = key;
		this->GoogleMap1 = "<script src='https://maps.googleapis.com/maps/api/js?key="
				+ key + "' async defer></script>";
		this->GoogleMap2 =
				"<script src='https://unpkg.com/leaflet.gridlayer.googlemutant@0.10.2/Leaflet.GoogleMutant.js'></script>";
		this->GoogleMap3 =
				"var GMRD = L.gridLayer.googleMutant({type:'roadmap', name:'GMRD'});\nvar GMST = L.gridLayer.googleMutant({type:'satellite', name:'GMST'});\nvar GMHB = L.gridLayer.googleMutant({type:'hybrid', name:'GMHB'});";
		this->GoogleMap4 = ",'Google}bv(W)' : GMRD,\n'Google}bv(ʐ^)' : GMST,\n'Google}bv()' : GMHB";
		ret = TRUE;
		// APIL[Ώ
	} else {
		this->GoogleAPIkey = "";
		this->GoogleMap1 = "";
		this->GoogleMap2 = "";
		this->GoogleMap3 = "";
		this->GoogleMap4 = "";
	}
	return ret;
}

// WvZ =================================================================
/**
 * {nn𐢊Ennɕϊ
 * @param	double  lng0  oxi{nnj
 * @param	double  lat0  ܓxi{nnj
 * @param	double* lng1  ϊ̌oxiEnnj
 * @param	double* lat1  ϊ̈ܓxiEnnj
 * @return	Ȃ
*/
void pahooGeocode::tokyo_wgs84(double lng0, double lat0, double* lng1, double* lat1) {
	*lng1 = lng0 - lat0 * 0.000046038 - lng0 * 0.000083043 + 0.010040;
	*lat1 = lat0 - lat0 * 0.00010695  + lng0 * 0.000017464 + 0.0046017;
}

/**
 * Enn{nnɕϊ
 * @param	double  lng0  oxiEnnj
 * @param	duble   lat0  ܓxiEnnj
 * @param	double* lng1  ϊ̌oxi{nnj
 * @param	double* lat1  ϊ̈ܓxi{nnj
 * @return	Ȃ
*/
void pahooGeocode::wgs84_tokyo(double lng0, double lat0, double* lng1, double* lat1) {
	*lng1 = lng0 + lat0 * 0.000046047 + lng0 * 0.000083049 - 0.010041;
	*lat1 = lat0 + lat0 * 0.00010696  - lng0 * 0.000017467 - 0.0046020;
}

/**
 * n_w苗ꂽn_̈ܓxEox߂
 * @param	double sour_lng   N_̌oxiEnnj
 * @param	double sour_lat   N_̈ܓxiEnnj
 * @param	double y          kւ̋i[gGȂ}CiXj
 * @param	double x          ւ̋i[gGȂ}CiXj
 * @param	double* dest_lng  ꂽn_̌oxiEnnj
 * @param	double* dest_lat  ꂽn_̈ܓxiEnnj
 * @return	float array(ox,ܓx)
*/
void pahooGeocode::getPointDistance(double sour_lng, double sour_lat,
	double y, double x, double* dest_lng, double* dest_lat) {
	double rad = 6378137;		// n̔ai[gj

	*dest_lat = (y / rad + sour_lat * (M_PI / 180)) * (180 / M_PI);
	*dest_lng = (x / (rad * cos(sour_lat * (M_PI / 180))) + sour_lng * (M_PI / 180)) * (180 / M_PI);
}

// WIR[fBOAPI =====================================================
/**
 * Google Geocoding API pČL[[hܓxEox߂
 * @param	wstring query L[[h
 * @param	string ua  UserAgent
 * @return	int qbgn_^(-1)FG[
*/
int pahooGeocode::getPointsGoogle(wstring query, string ua) {
	int httpStatus = 0;
	this->webapi = "https://maps.googleapis.com/maps/api/geocode/xml?key=" + this->GoogleAPIkey + "&language=ja&region=JP&address=" + urlencode(query);
	static string contents = "";
	bool res = readWebContents(this->webapi, ua, &contents, &httpStatus);
	if (res == FALSE) {
		this->errmsg = _SW("Google Geocoding API̐ڑG[܂");
		return (-1);
	} else if ((httpStatus < 200) || (httpStatus > 299)) {
		this->errmsg = _SW("Google Geocoding API̐ڑG[܂iHTTPXe[^XR[h" + to_string(httpStatus) + "j");
		return (-1);
	}

	// XMLǂݍ
	int cnt = 0;
	try {
		std::stringstream ss;
		ss << contents;
		ptree pt;
		xml_parser::read_xml(ss, pt);

		// `FbN
		if (optional<string>str = pt.get_optional<string>("GeocodeResponse.status")) {
			if (str.get() != "OK") {
				this->errmsg = _SW("Google Geocoding APỈG[܂");
				return (-1);
			}
		} else {
			this->errmsg = _SW("Google Geocoding APỈG[܂");
			return (-1);
		}

		// XML
		wstring co = L"";
		try {
			for (auto it : pt.get_child("GeocodeResponse.result")) {
				if (cnt >= __SIZE_PPOINTS)	break;
				// ܓx
				if (optional<string>lat = it.second.get_optional<string>("location.lat")) {
					this->Ppoints[cnt].latitude = stod(lat.value());
				}
				// ox
				if (optional<string>lng = it.second.get_optional<string>("location.lng")) {
					this->Ppoints[cnt].longitude = stod(lng.value());
					cnt++;
				}
				// Z
				if (it.first == "formatted_address") {
					this->Ppoints[cnt].address = _UW(it.second.data());
				}
			}
		// XML߃G[
		} catch(ptree_bad_path& e) {
			this->errmsg = _SW("Google Geocoding APǏG[܂");
			return (-1);
		}
	// ǂݍ݃G[
	} catch(xml_parser_error& e) {
		this->errmsg = _SW("Google Geocoding APĨG[܂");
		return (-1);
	}
	contents.clear();

	return cnt + 1;
}

/**
 * YOLPRecWIR[_API pČL[[hܓxEox߂
 * @param	wstring query L[[h
 * @param	string ua  UserAgent
 * @return	int qbgn_
*/
int pahooGeocode::getPointsYOLP(wstring query, string ua) {
	int httpStatus = 0;
	const string category[] = { "address", "landmark", "world" };
	this->webapi = "https://map.yahooapis.jp/geocode/cont/V1/contentsGeoCoder?appid=" + this->YahooAPIkey + "&el=UTF-8&output=xml&category=" + category[0] + "&query=" + urlencode(query);

	string contents = "";
	bool res = readWebContents(this->webapi, ua, &contents, &httpStatus);
	if (res == FALSE) {
		this->errmsg = _SW("YOLPRecWIR[_API̐ڑG[܂");
		return (-1);
	} else if ((httpStatus < 200) || (httpStatus > 299)) {
		this->errmsg = _SW("YOLPRecWIR[_API̐ڑG[܂iHTTPXe[^XR[h" + to_string(httpStatus) + "j");
		return (-1);
	}

	// XMLǂݍ
	int cnt = 0;
	try {
		std::stringstream ss;
		ss << contents;
		ptree pt;
		xml_parser::read_xml(ss, pt);

		// `FbN
		if (optional<string>str = pt.get_optional<string>("YDF.ResultInfo.Status")) {
			if (str.get() != "200") {
				this->errmsg = _SW("YOLPRecWIR[_APỈG[܂");
				return (-1);
			}
		} else {
			this->errmsg = _SW("YOLPRecWIR[_APỈG[܂");
			return (-1);
		}

		// XML
		try {
			wstring co = L"";
			for (auto it : pt.get_child("YDF.Feature")) {
				if (cnt >= __SIZE_PPOINTS)	break;
				// oxCܓx
				if (optional<string>coordinates = it.second.get_optional<string>("Coordinates")) {
					co = _UW(coordinates.value());
					vector<wstring> arr = wsplit(co, L',');
					this->Ppoints[cnt].longitude = stod(arr[0]);
					this->Ppoints[cnt].latitude  = stod(arr[1]);
					co = L"";
				}
				// Z
				if (optional<string>address = it.second.get_optional<string>("Address")) {
					this->Ppoints[cnt].address = _UW(address.value());
					cnt++;
				}
			}
		// XML߃G[
		} catch(ptree_bad_path& e) {
			this->errmsg = _SW("YOLPRecWIR[_APǏG[܂");
			return (-1);
		}

	// ǂݍ݃G[
	} catch(xml_parser_error& e) {
		this->errmsg = _SW("YOLPRecWIR[_API̐ڑG[܂");
		return (-1);
	}
	contents.clear();

	return cnt;
}

/**
 * HeartRails Geo API - L[[hܓxEox߂
 * @param	wstring query L[[h
 * @param	string ua  UserAgent
 * @return	int qbgn_
*/
int pahooGeocode::getPointsHRG(wstring query, string ua) {
	int httpStatus = 0;
	this->webapi = "http://geoapi.heartrails.com/api/xml?method=suggest&matching=like&keyword=" + urlencode(query);
	string contents = "";
	bool res = readWebContents(this->webapi, ua, &contents, &httpStatus);
	if (res == FALSE) {
		this->errmsg = _SW("HeartRails Geo API̐ڑG[܂");
		return (-1);
	} else if ((httpStatus < 200) || (httpStatus > 299)) {
		this->errmsg = _SW("HeartRails Geo API̐ڑG[܂iHTTPXe[^XR[h" + to_string(httpStatus) + "j");
		return (-1);
	}

	// XMLǂݍ
	int cnt = 0;
	try {
		std::stringstream ss;
		ss << contents;
		ptree pt;
		xml_parser::read_xml(ss, pt);

		// `FbN
		if (optional<string>str = pt.get_optional<string>("response.location")) {
		} else {
			this->errmsg = _SW("HeartRails Geo APỈG[܂");
			return (-1);
		}

		// XML
		try {
			for (auto it : pt.get_child("response")) {
				if (cnt >= __SIZE_PPOINTS)	break;
				// ܓx
				if (optional<string>lat = it.second.get_optional<string>("y")) {
					this->Ppoints[cnt].latitude = stod(lat.value());
				}
				// ox
				if (optional<string>lng = it.second.get_optional<string>("x")) {
					this->Ppoints[cnt].longitude = stod(lng.value());
				}
				// Z
				if (optional<string>town = it.second.get_optional<string>("town")) {
					this->Ppoints[cnt].address = _UW(town.value());
				}
				if (optional<string>city = it.second.get_optional<string>("city")) {
					this->Ppoints[cnt].address = _UW(city.value()) + this->Ppoints[cnt].address;
				}
				if (optional<string>pref = it.second.get_optional<string>("prefecture")) {
					this->Ppoints[cnt].address = _UW(pref.value()) + this->Ppoints[cnt].address;
					cnt++;
				}
			}
		// XML߃G[
		} catch(ptree_bad_path& e) {
			this->errmsg = _SW("HeartRails Geo APǏG[܂");
			return (-1);
		}

	// ǂݍ݃G[
	} catch(xml_parser_error& e) {
		this->errmsg = _SW("HeartRails Geo API̐ڑG[܂");
		return (-1);
	}
	contents.clear();

	return cnt;
}

/**
 * HeartRails Geo API - X֔ԍܓxEoxEZ
 * @param	string postal X֔ԍi7̔pj
 * @param	string ua  UserAgent
 * @return	int qbgn_
*/
int pahooGeocode::getPointsHRG_postal(string postal, string ua) {
	int httpStatus = 0;
	this->webapi = "http://geoapi.heartrails.com/api/xml?method=searchByPostal&postal=" + postal;
	string contents = "";
	bool res = readWebContents(this->webapi, ua, &contents, &httpStatus);
	if (res == FALSE) {
		this->errmsg = _SW("HeartRails Geo API̐ڑG[܂");
		return (-1);
	} else if ((httpStatus < 200) || (httpStatus > 299)) {
		this->errmsg = _SW("HeartRails Geo API̐ڑG[܂iHTTPXe[^XR[h" + to_string(httpStatus) + "j");
		return (-1);
	}

	// XMLǂݍ
	int cnt = 0;
	try {
		std::stringstream ss;
		ss << contents;
		ptree pt;
		xml_parser::read_xml(ss, pt);

		// `FbN
		if (optional<string>str = pt.get_optional<string>("response.location")) {
		} else {
			this->errmsg = _SW("HeartRails Geo APỈG[܂");
			return (-1);
		}

		// XML
		try {
			for (auto it : pt.get_child("response")) {
				if (cnt >= __SIZE_PPOINTS)	break;
				// ܓx
				if (optional<string>lat = it.second.get_optional<string>("y")) {
					this->Ppoints[cnt].latitude = stod(lat.value());
				}
				// ox
				if (optional<string>lng = it.second.get_optional<string>("x")) {
					this->Ppoints[cnt].longitude = stod(lng.value());
				}
				// Z
				if (optional<string>town = it.second.get_optional<string>("town")) {
					this->Ppoints[cnt].address = _UW(town.value());
				}
				if (optional<string>city = it.second.get_optional<string>("city")) {
					this->Ppoints[cnt].address = _UW(city.value()) + this->Ppoints[cnt].address;
				}
				if (optional<string>pref = it.second.get_optional<string>("prefecture")) {
					this->Ppoints[cnt].address = _UW(pref.value()) + this->Ppoints[cnt].address;
					cnt++;
				}
			}
		// XML߃G[
		} catch(ptree_bad_path& e) {
			this->errmsg = _SW("HeartRails Geo APǏG[܂");
			return (-1);
		}

	// ǂݍ݃G[
	} catch(xml_parser_error& e) {
		this->errmsg = _SW("HeartRails Geo API̐ڑG[܂");
		return (-1);
	}
	contents.clear();

	return cnt;
}

/**
 * OSM Nominatim Search API pČL[[hܓxEox߂
 * @param	wstring query L[[h
 * @param	string ua  UserAgent
 * @return	int qbgn_
*/
int pahooGeocode::getPointsNominatim(wstring query, string ua) {
	int httpStatus = 0;
	this->webapi = "https://nominatim.openstreetmap.org/search?format=xml&q=" + urlencode(query);
	string contents = "";
	bool res = readWebContents(this->webapi, ua, &contents, &httpStatus);
	if (res == FALSE) {
		this->errmsg = _SW("OSM Nominatim Search API̐ڑG[܂");
		return (-1);
	} else if ((httpStatus < 200) || (httpStatus > 299)) {
		this->errmsg = _SW("OSM Nominatim Search API̐ڑG[܂iHTTPXe[^XR[h" + to_string(httpStatus) + "j");
		return (-1);
	}

	// XMLǂݍ
	int cnt = 0;
	try {
		std::stringstream ss;
		ss << contents;
		ptree pt;
		xml_parser::read_xml(ss, pt);

		// `FbN
		if (optional<string>str = pt.get_optional<string>("searchresults.place")) {
		} else {
			this->errmsg = _SW("OSM Nominatim Search APỈG[܂");
			return (-1);
		}

		// XML
		try {
			for (auto it : pt.get_child("searchresults")) {
				if (cnt >= __SIZE_PPOINTS)	break;
				// ܓx
				if (optional<string>lat = it.second.get_optional<string>("<xmlattr>.lat")) {
					this->Ppoints[cnt].latitude = stod(lat.value());
				}
				// ox
				if (optional<string>lng = it.second.get_optional<string>("<xmlattr>.lon")) {
					this->Ppoints[cnt].longitude = stod(lng.value());
				}
				// Z
				if (optional<string>address = it.second.get_optional<string>("<xmlattr>.display_name")) {
					this->Ppoints[cnt].address = _UW(address.value());
					cnt++;
				}
			}
		// XML߃G[
		} catch(ptree_bad_path& e) {
			this->errmsg = _SW("OSM Nominatim Search APǏG[܂");
			return (-1);
		}

	// ǂݍ݃G[
	} catch(xml_parser_error& e) {
		this->errmsg = _SW("OSM Nominatim Search API̐ڑG[܂");
		return (-1);
	}
	contents.clear();

	return cnt;
}

/**
 * yn@WIR[fBOAPIpČL[[hܓxEox߂
 * @param	wstring query L[[h
 * @param	string ua  UserAgent
 * @return	int qbgn_
*/
int pahooGeocode::getPointsGSI(wstring query, string ua) {
	int httpStatus = 0;
	this->webapi = "https://msearch.gsi.go.jp/address-search/AddressSearch?q=" + urlencode(query);
	string contents = "";
	bool res = readWebContents(this->webapi, ua, &contents, &httpStatus);
	cout << httpStatus << httpStatus << endl;
	if (res == FALSE) {
		this->errmsg = _SW("yn@WIR[fBOAPI̐ڑG[܂");
		return (-1);
	} else if ((httpStatus < 200) || (httpStatus > 299)) {
		this->errmsg = _SW("yn@WIR[fBOAPI̐ڑG[܂iHTTPXe[^XR[h" + to_string(httpStatus) + "j");
		return (-1);
	}

	// XMLǂݍ
	int cnt = 0;
	try {
		std::stringstream ss;
		ss << contents;
		ptree pt;
		json_parser::read_json(ss, pt);

		// JSON
		try {
			for (auto it = pt.begin(); it != pt.end(); ++it) {
				if (cnt >= __SIZE_PPOINTS)	break;
				ptree pt2 = it->second.get_child("geometry.coordinates");
				int cnt2 = 0;
				for (auto it2 = pt2.begin(); it2 != pt2.end(); ++it2) {
					// ܓx
					if (cnt2 == 1) {
						this->Ppoints[cnt].latitude = stod(it2->second.data());
					// ox
					} else {
						this->Ppoints[cnt].longitude = stod(it2->second.data());
					}
					cnt2++;
				}
				// Z
				if (optional<string>address = it->second.get_optional<string>("properties.title")) {
					this->Ppoints[cnt].address = _UW(address.value());
					cnt++;
				}
			}
		// JSON߃G[
		} catch(ptree_bad_path& e) {
			this->errmsg = _SW("yn@WIR[fBOAPǏG[܂");
			return (-1);
		}

	// ǂݍ݃G[
	} catch(json_parser_error &e) {
		this->errmsg = _SW("yn@WIR[fBOAPI̐ڑG[܂");
		return (-1);
	}
	contents.clear();

	return cnt;
}

/**
 * WIR[_API pČL[[hܓxEox߂ij
 *
 * @param	wstring query L[[h
 * @param	string ua  UserAgent
 * @param	int     api    1FGoogle Geocoding API
 *                         2FYahoo!WIR[_API
 *                        11FHeartRails Geo API
 *                        12FOSM Nominatim Search API
 *                        13Fyn@WIR[fBOAPI
 * @return	int qbgn_
*/
int pahooGeocode::__searchPoints(wstring query, string ua, int api) {
	int cnt = 0;

	switch (api) {
	case 1:
		if (this->GoogleAPIkey == "")	return (-1);
		cnt = this->getPointsGoogle(query, ua);
		break;
	case 2:
		if (this->YahooAPIkey == "")	return (-1);
		cnt = this->getPointsYOLP(query, ua);
		break;
	case 11:
		cnt = this->getPointsHRG(query, ua);
		break;
	case 12:
		cnt = this->getPointsNominatim(query, ua);
		break;
	case 13:
		cnt = this->getPointsGSI(query, ua);
		break;
	default:
		cnt = (-1);
		break;
	}
	return cnt;
}

/**
 * WIR[_API pČL[[hܓxEox߂
 *
 * @param	wstring query L[[h
 *                         X֔ԍ\L@###-####܂#######ipj
 *                         ܓxEox\L@E##.##.##.#N###.##.##.#ipj
 *                         ܓxEox\L@##.##,###.##iܓxCoxGpj
 * @param	string ua  UserAgent
 * @param	int     api    0FAPIIiȗj
 *                         1FGoogle Geocoding API
 *                         2FYahoo!WIR[_API
 *                        11FHeartRails Geo API
 *                        12FOSM Nominatim Search API
 *                        13Fyn@WIR[fBOAPI
 * @return	int qbgn_
*/
int pahooGeocode::searchPoints(wstring query, string ua, int api=0) {
	static int apilist[] = { 1, 2, 11, 12, 13 };
	int cnt;
	wsmatch mt1;
	// X֔ԍp^[
	wregex re01(_SW("([0-9]{3})\\-?([0-9]{4})"));
	// ܓxEoxp^[
	wregex re11(_SW("(E|e|W|w|N|n|S|s)([0-9]+)\\.([0-9]+)\\.([0-9]+\\.?[0-9]*)(E|e|W|w|N|n|S|s)([0-9]+)\\.([0-9]+)\\.([0-9]+\\.?[0-9]*)"));
	wregex re12(_SW("(E|e|W|w|N|n|S|s)([0-9]+\\.?[0-9]*)(E|e|W|w|N|n|S|s)([0-9]+\\.?[0-9]*)"));
	wregex re13(_SW("(\\+|\\-)*([0-9]+\\.?[0-9]*)\\s*,\\s*(\\+|\\-)*([0-9]+\\.?[0-9]*)"));

	// z̏
	for (int i = 0; i < __SIZE_PPOINTS; i++) {
		this->Ppoints[i].longitude = 0;
		this->Ppoints[i].latitude  = 0;
		this->Ppoints[i].address   = L"";
	}

	// X֔ԍǂ
	if (regex_search(query, mt1, re01)) {
		cnt = this->getPointsHRG_postal(_WS(mt1[1].str() + mt1[2].str()), ua);

	// ܓxEox\Lǂ
	} else if (regex_search(query, mt1, re11)) {
		cnt = 0;
		string s1 = _WS(mt1[1].str());
		string s2 = _WS(mt1[5].str());
		double d1 = stod(mt1[2].str()) + stod(mt1[3].str()) / 60 + stod(mt1[4].str()) / (60 * 60);
		double d2 = stod(mt1[6].str()) + stod(mt1[7].str()) / 60 + stod(mt1[8].str()) / (60 * 60);
		if ((s1 == "E") || (s1 == "e")) {
			this->Ppoints[cnt].longitude = d1;
		} else if ((s1 == "S") || (s1 == "s")) {
			this->Ppoints[cnt].longitude = -d1;
		} else if ((s1 == "N") || (s1 == "n")) {
			this->Ppoints[cnt].latitude = d1;
		} else if ((s1 == "S") || (s1 == "s")) {
			this->Ppoints[cnt].latitude = -d1;
		}
		if ((s2 == "E") || (s2 == "e")) {
			this->Ppoints[cnt].longitude = d2;
		} else if ((s2 == "S") || (s2 == "s")) {
			this->Ppoints[cnt].longitude = -d2;
		} else if ((s2 == "N") || (s2 == "n")) {
			this->Ppoints[cnt].latitude = d2;
		} else if ((s2 == "S") || (s2 == "s")) {
			this->Ppoints[cnt].latitude = -d2;
		}
		cnt++;
	} else if (regex_search(query, mt1, re12)) {
		cnt = 0;
		string s1 = _WS(mt1[1].str());
		string s2 = _WS(mt1[3].str());
		double d1 = stod(mt1[2].str());
		double d2 = stod(mt1[4].str());
		if ((s1 == "E") || (s1 == "e")) {
			this->Ppoints[cnt].longitude = d1;
		} else if ((s1 == "S") || (s1 == "s")) {
			this->Ppoints[cnt].longitude = -d1;
		} else if ((s1 == "N") || (s1 == "n")) {
			this->Ppoints[cnt].latitude = d1;
		} else if ((s1 == "S") || (s1 == "s")) {
			this->Ppoints[cnt].latitude = -d1;
		}
		if ((s2 == "E") || (s2 == "e")) {
			this->Ppoints[cnt].longitude = d2;
		} else if ((s2 == "S") || (s2 == "s")) {
			this->Ppoints[cnt].longitude = -d2;
		} else if ((s2 == "N") || (s2 == "n")) {
			this->Ppoints[cnt].latitude = d2;
		} else if ((s2 == "S") || (s2 == "s")) {
			this->Ppoints[cnt].latitude = -d2;
		}
		cnt++;
	} else if (regex_search(query, mt1, re13)) {
		cnt = 0;
		string s1 = _WS(mt1[1].str());
		string s2 = _WS(mt1[3].str());
		double d1 = stod(mt1[2].str());
		double d2 = stod(mt1[4].str());
		if ((s1 == "") || (s1 == "+")) {
			this->Ppoints[cnt].latitude = d1;
		} else if (s1 == "-") {
			this->Ppoints[cnt].latitude = -d1;
		}
		if ((s2 == "") || (s2 == "+")) {
			this->Ppoints[cnt].longitude = d2;
		} else if (s2 == "-") {
			this->Ppoints[cnt].longitude = -d2;
		}
		cnt++;

	// APII
	} else if (api == 0) {
		for (int api : apilist) {
			this->resetError();
			cnt = this->__searchPoints(query, ua, api);
			if (cnt > 0)	break;
		}
	// APIw
	} else {
		cnt = this->__searchPoints(query, ua, api);
	}

	return cnt;
}

// n}` =================================================================
/**
 * n}`XNvg𐶐
 * @param	string id        }bvID
 * @param	double longitude SWFoxiEnnj
 * @param	double latitude  SWFܓxiEnnj
 * @param	int    zoom      g嗦
 * @param	string type      }bv^Cv
 *								GSISTDFn@n}iWjFȗ
 *								GSIPALEFn@n}iWFn}j
 *								GSIBLANKFn@n}in}j
 *								GSIPHOTOFn@n}iʐ^j
 *								OSMFOpenStreetMap
 *								GMRDFGoogle}bviROADMAPjGAPIL[L
 * @param	ppoints_t* items  n_ziȗ\j
 * @param	size_t size       n_z̐iȗ\j
 * @param	string call1      CxgɃR[֐iȗj
 * @param	string call2      ǉXNvgiȗj
 * @param	int    max_width  EBhE̍ő啝iȗF200j
 * @param	int    ofst_x     EBhẼItZbgʒuiX)iȗF0j
 * @param	int    ofst_y     EBhẼItZbgʒuiY)iȗF0j
 * @return	string XNvg
 */
string pahooGeocode::makeMapLeaflet(
	string id, double longitude, double latitude, int zoom,
	string type, ppoints_t* items, size_t size, string call1, string call2,
	int max_width, int ofst_x, int ofst_y) {

	// n_XNvg̐
	char lat[SIZE_BUFF + 1], lng[SIZE_BUFF + 1];
	char buff[SIZE_BUFF + 1];
	string icode = "";
	if (items != NULL) {
		string icon = "";
		string info = "";
		for (size_t i = 0; i < size; i++) {
			if ((items[i].icon) == "" && (i > 25))	break;
									// ACRURLȂ 'Z'𒴂ł~
			string mark = {(char)(65 + i)};
			if (items[i].icon == "") {
				icon = "https://www.google.com/mapfiles/marker" + mark + ".png";
			} else {
				icon = items[i].icon;
			}
			info = "";
			if (items[i].description != L"") {
				snprintf(buff, SIZE_BUFF, "', {maxWidth: %d, offset: [%d, %d] });", max_width, ofst_x, ofst_y);
				info = "marker_" + mark + ".bindPopup('" + _WS(items[i].description) + buff;
			}
			snprintf(lat, SIZE_BUFF, "%.5f", items[i].latitude);
			snprintf(lng, SIZE_BUFF, "%.5f", items[i].longitude);
			icode += (boost::format(R"(
				var icon_%1% =  new L.icon({
					iconUrl: '%2%',
					iconAnchor: [10, 10]	// b
				});
				var marker_%1% = new L.Marker([%3%, %4%], {icon: icon_%1%}).addTo(map);
				%5%
)")
% mark			// }[J[ʎq
% icon			// }[J[URL
% lat			// ܓx
% lng			// ox
% info			// 
).str();
		}
	}

	// n}`XNvg̐
	string script = (boost::format(R"(
%6%
<link rel="stylesheet" href="https://unpkg.com/leaflet@latest/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@latest/dist/leaflet.js"></script>
%7%
<script>
window.onload = function() {
	var map = L.map('%1%',{zoomControl:false});
	map.setView([%2%, %3%], %4%);
	L.control.scale({
		maxWidth: 250,
		position: 'bottomright',
		imperial: false
	}).addTo(map);
	L.control.zoom({position:'topleft'}).addTo(map);

	// n@n}FWn}
	var GSISTD = new L.tileLayer(
		'https://cyberjapandata.gsi.go.jp/xyz/std/{z}/{x}/{y}.png',
		{
			attribution: "<a href='https://maps.gsi.go.jp/development/ichiran.html' target='_blank'>n@^C</a>",
			minZoom: 0,
			maxZoom: 18,
			name: 'GSISTD'
		});
	// n@n}FWFn}
	var GSIPALE = new L.tileLayer(
		'https://cyberjapandata.gsi.go.jp/xyz/pale/{z}/{x}/{y}.png',
		{
			attribution: "<a href='https://maps.gsi.go.jp/development/ichiran.html' target='_blank'>n@^C</a>",
			minZoom: 2,
			maxZoom: 18,
			name: 'GSIPALE'
		});
	// n@n}Fn}
	var GSIBLANK = new L.tileLayer(
		'https://cyberjapandata.gsi.go.jp/xyz/blank/{z}/{x}/{y}.png',
		{
			attribution: "<a href='https://maps.gsi.go.jp/development/ichiran.html' target='_blank'>n@^C</a>",
			minZoom: 5,
			maxZoom: 14,
			name: 'GSIBLANK'
		});
	// n@n}Fʐ^
	var GSIPHOTO = new L.tileLayer(
		'https://cyberjapandata.gsi.go.jp/xyz/seamlessphoto/{z}/{x}/{y}.jpg',
		{
			attribution: "<a href='https://maps.gsi.go.jp/development/ichiran.html' target='_blank'>n@^C</a>",
			minZoom: 2,
			maxZoom: 18,
			name: 'GSIPHOTO'
		});
	// OpenStreetMap
	var OSM = new L.tileLayer(
		'https://tile.openstreetmap.jp/{z}/{x}/{y}.png',
		{
			attribution: "<a href='https://osm.org/copyright' target='_blank'>OpenStreetMap</a> contributors",
			minZoom: 0,
			maxZoom: 18,
			name: 'OSM'
		});
%8%

	// baseMapsIuWFNgɃ^Cݒ
	var baseMaps = {
		"n@n}" : GSISTD,
		"WFn}" : GSIPALE,
		"n}" : GSIBLANK,
		"ʐ^n}" : GSIPHOTO,
		"I[vXg[g}bv" : OSM
		%9%
	};

	// layersRg[baseMapsIuWFNgݒ肵Ēn}ɒǉ
	L.control.layers(baseMaps).addTo(map);
	%5%.addTo(map);

	// Cxgǉ
	map.on('moveend', getPointData);
	map.on('zoomend', getPointData);
	map.on('baselayerchange', getPointData);

	// Cxg̒n}擾Ei[
	function getPointData() {
		var pos = map.getCenter();
		// ox
		if (document.getElementById('longitude') != null) {
			document.getElementById('longitude').value = pos.lng;
		}
		// ܓx
		if (document.getElementById('latitude') != null) {
			document.getElementById('latitude').value = pos.lat;
		}
		// Y[
		if (document.getElementById('zoom') != null) {
			document.getElementById('zoom').value = map.getZoom();
		}
		// ^Cv
		if (document.getElementById('maptype') != null) {
			for (var k in baseMaps) {
				if (map.hasLayer(baseMaps[k])) {
					document.getElementById('maptype').value = baseMaps[k].options.name;
				}
			}
		}
		%11%
	}
	%10%
}
</script>
)")
% id					// n}ID
% latitude				// ܓx
% longitude				// ox
% zoom					// n}g嗦
% type					// n}^Cv
% this->GoogleMap1		// Google}bv`pXNvgURL
% this->GoogleMap2		// Leaftet:Google}bvEAhIURL
% this->GoogleMap3		// Leaftet:Google}bvpC
% this->GoogleMap4		// Leaftet:Google}bvI
% icode
% call1
).str();

	return script;
}

/*
 ** o[WAbv =====================================================
 *
 * @version 1.9.0 2025/03/16 HTTPXe[^XEG[Lb`Abv
 * @version 1.8.1 2025/02/23 setError() -- bug-fix
 * @version 1.8.0 2024/05/03 getMyPath()apikey.appgetMyPath()֐ɕύX
 * @version 1.7.0 2024/04/27 EdgeΉɔfobOpR[hp
 * @version 1.6.0 2023/07/02 getPointsGSI()\bhǉ
 * @version 1.5   2022/09/03 fobOR[hߍ
 * @version 1.4   2021/05/01 makeMapLeaflet() ǉ
 * @version 1.3   2021/03/07 tokyo_wgs84(), wgs84_tokyo()\bhǉ
 * @version 1.2   2020/12/20 leafletXNvg̎QURLύX
 * @version 1.1   2020/09/27 makeMapLeaflet()\bhǉ
 * @version 1.0   2020/09/23 
 */
