/** pahooWebView2.cpp
 * WebView2R|[lg֐
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + WebView2
 * @QlURL		http://www.pahoo.org/e-soul/webtech/cpp01-12-01.shtm
 */
#define CINTERFACE
#include <iostream>
#include <tchar.h>
#include <locale>
#include <string>
#include "WebView2.h"
#include "event.h"
#include "pahooWebView2.hpp"
#ifndef UNICODE
#include <codecvt>
#endif

using namespace std;

//eEBhEFCvOŒ`D
extern HWND hParent;

//e|t@CFCvOŒ`D
extern wchar_t *wUri;

//WebView2֘A
ICoreWebView2* webView2 = nullptr;
static ICoreWebView2Controller* controller = nullptr;
static bool webView2Ready = false;

/**
 * WebView2łĂ邩ǂD
 * @param	Ȃ
 * @return	bool trueFłĂ^falseFłĂȂ
*/
bool isWeb2Ready(void) {
	if (webView2Ready) {
		return true;
	} else {
		return false;
	}
}

/**
 * LPCTSTRwstringϊ
 * @param	LPCTSTR str		ϊ̕
 * @return	wstring			ϊ̕
*/
std::wstring TStrToWStr(LPCTSTR str) {
#ifdef UNICODE
    return std::wstring(str);
#else
	// ANSI/MultiByte  UTF-16iwstringjւ̕ϊ
	int size_needed = MultiByteToWideChar(CP_UTF8, 0, str, -1, nullptr, 0);
	if (size_needed == 0) {
		return L"";			// ϊs͋󕶎Ԃ
	}
	std::wstring result(size_needed, 0);
	MultiByteToWideChar(CP_UTF8, 0, str, -1, &result[0], size_needed);
	result.pop_back(); // null terminator 폜
	return result;
#endif
}

/**
 * G[bZ[W\ăvOID
 * @param	LPCTSTR errmsg	G[EbZ[W
 * @return	Ȃ
 */
void FatalError(LPCTSTR errmsg, ...) {
	MessageBox(NULL, errmsg, TEXT("G["), MB_OK | MB_ICONSTOP);
	ExitProcess(1);
}

/**
 * f[^EpX擾D
 * @param	LPTSTR szOut	f[^EpXi[̈
 * @param	DWORD nSize		f[^ETCY
 * @return	Ȃ
*/
void GetDataPath(LPTSTR szOut, DWORD nSize) {
	TCHAR szExePath[MAX_PATH];
	GetModuleFileName(nullptr, szExePath, _countof(szExePath));

	LPTSTR szExeName = _tcsrchr(szExePath, TEXT('\\'));
	szExeName = szExeName ? szExeName + 1 : szExePath;

	TCHAR szAppData[MAX_PATH];
	GetEnvironmentVariable(TEXT("AppData"), szAppData, _countof(szAppData));

	_tcsncpy(szOut, szAppData, nSize);
	_tcsncat(szOut, TEXT("\\"), nSize);
	_tcsncat(szOut, szExeName, nSize);
}

/**
 * WebView2TCYD
 * @param	HWND hWnd	EBhEEnh
 * @return	Ȃ
*/
void ResizeBrowser(HWND hWnd) {
	if (!controller) {
		return;
	}
	RECT bounds;
	GetClientRect(hWnd, &bounds);
	controller->lpVtbl->put_Bounds(controller, bounds);
}

/**
 * CxgnhFWebView2
 * @param	HWND hDlg		eEBhEEnh
 * @paramm	UINT uMsg		bZ[Wʎq
 * @param	WPARAM wParam	bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam	bZ[W2Ԗڂ̃p[^
 * @return	LRESULT WINAPI	bZ[W
*/
LRESULT WINAPI WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {
	switch (msg) {
	case WM_CLOSE:
		EndDialog(hParent, 0);
		return 0;
		break;
	case WM_DESTROY:
        PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, msg, wParam, lParam);
	}
	return 0;
}

/**
 * WebView2𐶐D
 * @param	HINSTANCE hInst		݂̃C^[tFCX
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	int x, y			WebView2̍W
 * @paramm	int width, height	WebView2̕A
 * @param	LPCWSTR uri			\URI
 * @return	HWND				WebView2ւ̃nh
*/
HWND createWebView2(HINSTANCE hInst, HWND hDlg, int x, int y, int width, int height, LPCWSTR uri) {
	//EBhE NX
	static WNDCLASSEX wc{};
	wc.cbSize = sizeof(WNDCLASSEX);
	wc.hInstance = hInst;
	wc.lpszClassName = TEXT("webview");
	wc.lpfnWndProc = WndProc;
	RegisterClassEx(&wc);

	//EBhE
	static HWND hWnd = CreateWindowEx(
		0,
		TEXT("webview"),
		TEXT("MinGW WebView2"),
		WS_CHILD | WS_VISIBLE | ES_LEFT,
		x, y, width, height,
		hDlg,
		nullptr,
		hInst,
		nullptr
	);
	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);
	SetFocus(hWnd);

	//f[^EpX擾
	TCHAR szDataPath[MAX_PATH + 1];
	GetDataPath(szDataPath, MAX_PATH);
	//Cxgnh
	static EventHandler handler{};

	handler.EnvironmentCompleted = [&](HRESULT result, ICoreWebView2Environment* created_environment) {
//		cout << "EnvironmentCompleted" << endl;
		if (FAILED(result)) {
			FatalError(TEXT("Failed to create environment?"));
		}
		created_environment->lpVtbl->CreateCoreWebView2Controller(created_environment, hWnd, &handler);
		return S_OK;
	};

	handler.ControllerCompleted = [&](HRESULT result, ICoreWebView2Controller* new_controller) {
//		cout << "ControllerCompleted" << endl;
		if (FAILED(result)) {
			FatalError(TEXT("Failed to create controller?"));
		}
		controller = new_controller;
		controller->lpVtbl->AddRef(controller);
		controller->lpVtbl->get_CoreWebView2(controller, &webView2);
		webView2->lpVtbl->AddRef(webView2);
		webView2->lpVtbl->Navigate(webView2, uri);
		ResizeBrowser(hWnd);
		webView2Ready = true;
		return S_OK;
	};

	HRESULT result = CreateCoreWebView2EnvironmentWithOptions(
		nullptr,
		TStrToWStr(szDataPath).c_str(),
		nullptr,
		&handler
	);

	if (FAILED(result)) {
		FatalError(TEXT("Call to CreateCoreWebView2EnvironmentWithOptions failed!"));
	}

	return hWnd;
}

/*
 ** o[WAbv =====================================================
 *
 * @version 1.1.0 2025/06/07  TStrToWStr() -- C++17 Ή
 * @version 1.0.0 2024/04/27  
 */
