/* sub1.c */
/* edmi - text editor min - */
/* (c)2024,2025 wnc develop / t.w. */
/* The MIT License */
/* 20251201 ed13 */

#include <stdio.h>
#include <string.h>
#include <i86.h>
#include <dos.h>
#include "escsub.h"
#include "maindef.h"
#include "mainprot.h"


/* ============== */
/* screen exec    */
/* ============== */

/* set cursor position (0,0) start position */
/* convert ESC_cursor(x,y) */
void cursor(int x,int y) { ESC_cursor((x+1),(y+1)); }

/* output 1gyo nomi (y pos) */
void sc1gyooutonly(edit_dat *wed,int y)
{
	static char scwork[SCRMJIMAX+2];

	char a;
	char b;
	int vx;
	int n;
	int scoypos;
	int f1;
	char *p;
	int i,j,k;
	int tabsiz;
	int tusize; /* ed10 */

	edit_dat tmped;
	tmped.tmem = wed->tmem;
	tmped.tsize = wed->tsize;
	tmped.mypos = wed->oypos;
	tmped.tusize = wed->tusize;  /* ed10 */
	scoypos = wed->oypos; /* bug fuzi */
	tabsiz = wed->tab;
	tusize = wed->tusize;

	n = gyocnt(wed);
	if( n <= y ) { return; }

	for(i=0;i<y;i++)
	{
		scoypos = zigyoypos(&tmped);
		tmped.mypos = scoypos;
	}

	p = wed->tmem;

	f1 = 0;

	cursor(0,y);
	vx = 0;
	scwork[vx] = 0;
	for(j=0; j < SCRMJIMAX;j++) /* 2 */
	{
		a = p[scoypos];
		if( scoypos > tusize ) { break; } /* ed10 */
		scoypos++;

		if(a == EOF_CODE)  /* ed10 */
		{
			scwork[vx]=0;
			f1 = 1;
			break;
		}
		if(a == CR_CODE)
		{
			scwork[vx] = 0;
			if(p[scoypos] == LF_CODE) { scoypos++;}
			break;
		}

		if( a == TAB_CODE)
		{
			a = SPC_CODE;
			n = tabsiz - (vx % tabsiz);
			if(n >= 1)
			{
				/* tab adjust */
				for(k=1;k < n; k++)
				{
					scwork[vx] = a;
					vx++;
					if(vx > SCRMJIMAX){ vx=SCRMJIMAX; break;}
				}
			}
			else
			{
				continue;
			}
		}

		if(vx >= SCRMJIMAX) { break;}

		/* ----------------------------- */
		/* seigyo code mugai ka 20240805 */
		/* ----------------------------- */
		if( a < SPC_CODE ) { a = SPC_CODE; }

		/* kakunou */
		scwork[vx] = a;

		vx++;
	} /* 2 */

	scwork[vx] = 0;

	/* scr over */
	/* next cr */
	if( a >= SPC_CODE )
	{
		while(1)
		{
			b = p[scoypos];
			scoypos++;
			if( scoypos > tusize ) { break; } /* ed10 */
			if(b == CR_CODE)
			{
				if(p[scoypos] == LF_CODE) { scoypos++;}
				break;
			}
		}
	}

	/* gamen hyouji saigo shift jis kensa */
	for(k=0; k < SCRMJIMAX;k++)
	{
		a = scwork[k];
		if( chksjis1b( a ) == 0)
		{
			/* none */
		}
		else
		{
			/* shift jis */
			k++; /* add */
			if( k >= SCRMJIMAX )
			{
				/* mukou ka */
				scwork[(k-1)] = SPC_CODE;
				break;
			}
		}
	}

	/* output 1gyo nomi */
#if OUTCA==1
	outca(scwork,SCRMJIMAX);
#else
	fputs(scwork,stdout);
	fflush(stdout);
#endif
}

/* scexec SC_SYDEL */
void scmojioutsydel(edit_dat *wed)
{
	int y;
	int w1y;

	y = wed->sy;
	cursor(0, y);
	ESC_1linedel();
	ESC_cur_delgyo();
	sc1gyooutonly(wed,y);

	y = SCRGYOMAXm1;
	w1y = gyocntzan(wed,GCZ_SCYMAX);
	if(y > w1y) { return;}
	cursor(0, y);
	sc1gyooutonly(wed,(SCRGYOMAX-1));
}

/* scexec SC_ALL */
void scmojioutall(edit_dat *wed)
{
	static char scwork[SCRMJIMAX+2];

	char a;
	char b;
	int vx;
	int n;
	int scoypos;
	int f1;
	char *p;
	int tusize; /* ed10 */
	int i,j,k;
	int tabsiz;
#if OUTCA==1
	char crlf[] = { 0x0d,0x0a,0};
#endif
	scoypos = wed->oypos;
	p = wed->tmem;
	tabsiz = wed->tab;
	tusize = wed->tusize; /* ed10 */

	f1 = 0;

	ESC_cls();

	for(i=0; i<SCRGYOMAX;i++) /* 1 */
	{
		vx = 0;
		scwork[vx] = 0;
		for(j=0; j < SCRMJIMAX;j++) /* 2 */
		{
			a = p[scoypos];
			if( scoypos > tusize ) { break; }  /* ed10 */
			scoypos++;

			if(a == EOF_CODE) /* ed10 */
			{
				scwork[vx]=0;
				f1 = 1;
				break;
			}
			if(a == CR_CODE)
			{
				a = 0;
				scwork[vx]=a;
				if(p[scoypos] == LF_CODE) { scoypos++;}
				break;
			}

			if( a == TAB_CODE)
			{
				a = SPC_CODE;
				n = tabsiz - (vx % tabsiz);
				
				if(n >= 1)
				{
					/* tab adjust */
					for(k=1;k < n; k++)
					{
						scwork[vx] = a;
						vx++;
						if(vx > SCRMJIMAX){ vx=SCRMJIMAX; break;}
					}
				}
				else
				{
					continue;
				}
			}
			if(vx >= SCRMJIMAX) { scwork[SCRMJIMAX]= '\0'; break;}

			/* ----------------------------- */
			/* seigyo code mugai ka 20240915 */
			/* ----------------------------- */
			if( a < SPC_CODE ) { a = SPC_CODE; }

			scwork[vx] = a;
			scwork[vx+1]= 0;
			vx++;
		} /* 2 */

		/* scr over */
		/* next cr */
		if( a >= SPC_CODE )
		{
			while(1)
			{
				b = p[scoypos];
				scoypos++;
				if( scoypos > tusize ) { break; } /* ed10 */
				if(b == CR_CODE)
				{
					if(p[scoypos] == LF_CODE) { scoypos++;}
					break;
				}
			}
		}

		/* gamen hyouji saigo shift jis kensa */
		for(k=0; k < SCRMJIMAX;k++)
		{
			a = scwork[k];
			if( chksjis1b( a ) == 0)
			{
				/* none */
			}
			else
			{
				/* shift jis */
				k++; /* add */
				if( k >= SCRMJIMAX )
				{
					/* mukou ka */
					scwork[(k-1)] = SPC_CODE;
					scwork[k] = '\0'; /* bug fuji */
					break;
				}
			}
		}

		/* output */
		if(i < (SCRGYOMAX-1))
		{
#if OUTCA==1
			outca(scwork,SCRMJIMAX);
			outca(crlf,sizeof(crlf));
#else
			fprintf(stdout,"%s\n",scwork);
#endif
		}
		else
		{
			/* saigono gyo */
#if OUTCA==1
			outca(scwork,SCRMJIMAX);
#else
			fprintf(stdout,"%s",scwork);
#endif
		}

		if(f1 >= 1) { break; }
	} /* 1 */
#if OUTCA==0
	fflush(stdout);
#endif
}

/* scexec SC_SYINS */
void scmojioutsyins(edit_dat *wed)
{
	if(wed->sy >= (SCRGYOMAX-1))
	{
		scmojioutall(wed);
	}
	else
	{
		cursor(0,wed->sy);
		ESC_1lineinsert();

		cursor(wed->bsx,wed->bsy);
		ESC_cur_delend();  /* cursor x right to end delete */

		cursor(0,wed->sy);
		if(wed->sy >= 1)
		{
			sc1gyooutonly(wed,wed->sy-1);
		}
		sc1gyooutonly(wed,wed->sy);
	}
}

/* scexec SC_SAIGOADD */
void scmojioutendy(edit_dat *wed)
{
	cursor(0,0);
	ESC_1linedel(); /* 0gyome del */
	sc1gyooutonly(wed,(SCRGYOMAX-1));
}

/* scexec SC_SENTOADD */
void scmojioutoy(edit_dat *wed)
{
	cursor(0,0);
	ESC_1lineinsert();  /* 0gyome insert */
	sc1gyooutonly(wed,0);
}

/* scexec SC_SYDAKE */
void scmojioutsy(edit_dat *wed)
{
	int y;
	y = wed->sy;

	cursor(0,y);

	ESC_cur_delgyo();  /* delete cursor gyo nomi */
	sc1gyooutonly(wed,y);
}

/* scexec SC_CMIGILAST */
void scmojioutsyrlast(edit_dat *wed)
{
	ESC_cur_dellast(); /* delete cursor right to lastlineright */
}

/* scexec SC_CMIGISAI */
void scmojioutsyre(edit_dat *wed,int mode)
{
	int x,y;
	x = wed->sx;
	y = wed->sy;

	cursor(x,y);
	if(mode == 0) /* == 0 delete migi */
	{
		ESC_cur_delend(); /* delete cursor right to end */
	}
	sc1gyooutonly(wed,y);
}

/* output asciiz (max c) */
/* int 29h use (20240801)*/
#if OUTCA==1
void outca(char *p,int c)
{
	__asm{
	mov si,p
	mov cx,c
	cld
lp1:
	lodsb
	or al,al
	jz jp1
	int 29h
	loop lp1
jp1:
	}
}
#endif

/* --------------- */
/* editor other    */
/* --------------- */
/* ed6 20240731 */
/* sx -> mxypos adjust(tab) */
void adjtabmxypos(edit_dat *wed)
{
	char a;
	int x,w1,i;
	int w1mypos;
	char *p;
	int tabsiz;
	int w1sx;

	x=0;
	w1mypos = wed->mypos;
	p = wed->tmem;
	tabsiz = wed->tab;
	w1sx = wed->sx;

	for(i=0;i <= w1sx; i++)
	{
		a = p[(w1mypos+i)];
		if((a == CR_CODE)||(a==EOF_CODE)||(a=='\0'))
		{
			wed->mxypos = (w1mypos+i);
			break;
		}

		if(a == TAB_CODE)
		{
			w1 = x % tabsiz;
			w1 = tabsiz - w1;
			x += w1;
		}
		else
		{
			x++;
		}
		if(x > w1sx)
		{
			wed->mxypos = (w1mypos+i);
			break;
		}
		wed->mxypos = (w1mypos+i);
	}
}

/* ed6 20240731 */
/* mxypos -> sx adjust (tab) */
void adjtabscx(edit_dat *wed)
{
	char a;
	int x,w1,i;
	int w1mypos,w2mxypos;
	char *p;
	int tabsiz;

	x=0;
	w1mypos = wed->mypos;
	w2mxypos = wed->mxypos;
	p = wed->tmem;
	tabsiz = wed->tab;

	for(i=w1mypos;i < w2mxypos; i++)
	{
		a = p[i];
		if(a == TAB_CODE)
		{
			w1 = x % tabsiz;
			w1 = tabsiz - w1;
			x += w1;
		}
		else
		{
			x++;
		}
	}
	if( x > SCRMJIMAXm1)
	{
		x = SCRMJIMAXm1;  /* limit */
	}
	wed->sx = x;
}

/* oypos kara nokori gyo cnt */
int gyocntzan(edit_dat *wed,int mode)
{
	char *p;
	char a;
	int w1oypos;
	int tusize;
	int cnt;

	w1oypos = wed->oypos;
	tusize = wed->tusize;
	p = wed->tmem;
	cnt = 0;

	switch(mode)
	{
		case GCZ_SCYMAX:
			for(int i=w1oypos;i < tusize;i++)
			{
				a = p[i];
				if(a == CR_CODE) { cnt++;}
				if(cnt >= SCRGYOMAX) { break; }
			}
			break;

		default: /* (GCZ_DEF) */
			for(int i=w1oypos;i < tusize;i++)
			{
				a = p[i];
				if(a == CR_CODE) { cnt++;}
			}
			break;
	}
	return cnt;
}

/* tab sc kyori henkan */
int gettabscx(edit_dat *wed)
{
	char a;
	int x;
	int w1;
	int i;
	int w1mypos;
	int w2mxypos;
	char *p;
	int tabsiz;
	x=0;
	w1mypos = wed->mypos;
	w2mxypos = wed->mxypos;
	p = wed->tmem;
	tabsiz = wed->tab;

	for(i=w1mypos;i < w2mxypos; i++)
	{
		a = p[i];
		if(a == TAB_CODE)
		{
			w1 = x % tabsiz;
			w1 = tabsiz - w1;
			x += w1;
		}
		else
		{
			x++;
		}
	}
	return x;
}

/* shift jis chk */
/* ed7 add 20240805 */
int chksjis1b(char a)
{
	if( ((a>=0x81)&&(a<=0x9f)) || ((a>=0xe0)&&(a<=0xef)) )
	{
		return 1;
	}
	return 0;
}

/* gyou tou kara kensa */
int chksjismx(edit_dat *wed)
{
	/* shift jis to cyu  ret==-1 */
	/* soreigai ret== 0 */
	char a;
	int w1mypos;
	int w2mxypos;
	char *p;
	int i;
	int f1;
	int csize;
	int c;
	f1=0;
	p = wed->tmem;
	w1mypos = wed->mypos;
	w2mxypos = wed->mxypos;
	c=0;
	for(i=w1mypos; i < w2mxypos;i++)
	{
		a = p[i];
		if( chksjis1b( a ) == 0)
		{
			/* none */
		}
		else
		{
			/* shift jis */
			i++; /* add */
			if( i >= w2mxypos ) { f1=-1; break;}
		}
	}
	return f1;
}

/* text 1 insert */
int mojioneins(edit_dat *wed,char a)
{
	char *p;
	int i;
	int tsize;
	int w1mxypos;
	int cnt;
	p = wed->tmem;
	tsize = wed->tsize;
	w1mxypos = wed->mxypos;

	cnt = wed->tusize;  /* text memory use size */

	if( (cnt+1) >= tsize) { return -1; } /* full */
	if( w1mxypos >= tsize ) { return -1; }
	memmove(&p[w1mxypos+1],&p[w1mxypos],(tsize-w1mxypos));
	p[w1mxypos] = a;
	wed->tusize++;  /* text memory use size inc */
	return 0;
}

/* tugino gyo pos */
int zigyoypos(edit_dat *wed)
{
	char w1;
	int sinypos;
	int f1;
	char *p;
	int tsize;

	sinypos = wed->mypos;
	f1=0;
	p = wed->tmem;
	tsize = wed->tsize;

	while(1)
	{
		if(tsize <= sinypos) { sinypos = tsize; break; }
		w1 = p[sinypos];
		if(w1 == LF_CODE) { sinypos++; break; }
		if(w1 == EOF_CODE) { break;} /* ed10 */
		if((w1 != LF_CODE) && (f1 == 1)) { break; }
		if(w1 == CR_CODE) { f1 = 1; }
		sinypos++;
	}
	if(sinypos > tsize){ sinypos = tsize; } /* ed10 */

	/* zigyo nai */
	if(f1 <= 0) { sinypos = wed->mypos; }

	return sinypos;
}

/* rev20240716 */
void mojigyodel(edit_dat *wed)
{
	char *p1,*p2;
	int textsize;
	textsize = wed->tsize;
	textsize = textsize - wed->mxypos;
	p1 = wed->tmem;
	p2 = (&p1[wed->mxypos]);
	p1 = p2;
	p2++;
	memmove(p1,p2,textsize);
	/* p1[textsize] = '\0'; */ /* old code bug fuzi */
	p1[textsize] = EOF_CODE;  /* bug fuzi ed10 */

	if(wed->tusize >= 1)
	{
		wed->tusize--;  /* text memory use dec */
	}
}

int getgyolen(edit_dat *wed)
{
	int textcntmax;
	int textnokori;
	int i;
	int c;
	int w1mypos;
	char *p;
	w1mypos = wed->mypos;
	c=0;
	p = wed->tmem;

	textcntmax = textmemcnt(wed);
	textnokori = textcntmax - wed->mypos;
	for(i=0;i < textnokori ;i++)
	{
		if( p[w1mypos] == CR_CODE)
		{
			break;
		}
		w1mypos++;
		c++;
	}
	return c;
}

/* maeno gyo pos */
int zengyoypos(edit_dat *wed)
{
	char w1;
	int sinypos;
	int bksinypos;
	int f1,f2;
	char *p;
	sinypos = wed->mypos;
	f1=0;f2=0;
	p = wed->tmem;

	while(1)
	{
		bksinypos = sinypos;
		sinypos--;
		if(0 > sinypos) { sinypos = 0; break; }
		w1 = p[sinypos];
		if(w1 == LF_CODE) { f1++; }
		if(w1 == CR_CODE) { f2++; }
		if((f1 >= 2) || (f2 >= 2))
		{
			break;
		}
	}
	sinypos = bksinypos;
	if(sinypos < 0){ sinypos = 0; }
	return sinypos;
}

/* allgyocount */
int gyocnt(edit_dat *wed)
{
	int gyo;
	int c;
	char a;
	char *p;
	int tusize;  /* ed10 */
	p = wed->tmem;
	tusize = wed->tusize;  /* ed10 */

	gyo = 1;
	c = 0;
	while(c < tusize) /* ed10 */
	{
		a = p[c];
		if( a == CR_CODE ) { gyo++; }
		if( a == EOF_CODE) { break; }  /* ed10 */
		c++;
	}
	return gyo;
}

int textmemcnt(edit_dat *wed)
{
	/* ed10 */
	int retv;
	retv = wed->tusize;
	return retv;  /* ed10 */
}

int mojigyocnt(edit_dat *wed)
{
	int c;
	c = getgyolen(wed);
	return c;
}

/* text cr */
int mojigyocr(edit_dat *wed)
{
	int ret;
	ret = mojioneins(wed,CR_CODE);
	return ret;
}

/* ed10 20241004 Ctrl+K */
void sakujyo(edit_dat *wed)
{
	int i;
	int stpos;
	int edpos;

	edpos = zigyoypos(wed);
	stpos = wed->mypos;
	wed->mxypos = stpos;

	for(i=stpos; i < edpos; i++)
	{
		mojigyodel(wed);
	}

	adjtabscx(wed);
}

/* ed10 20241004 Ctrl+C */
void copygyou(edit_dat *wed,char *p,int maxsize)
{
	char *st;
	char a;
	int i;

	st = &(wed->tmem[wed->mypos]);

	for(i=0;i < (maxsize-1);i++)
	{
		a = st[i];
		p[i] = a;
		if( a == EOF_CODE ) { break;}
		if( a == CR_CODE) { break;}
	}
	p[i] = CR_CODE;
	p[i+1]= LF_CODE;
}

/* ed10 20241004 Ctrl+V */
void haritsuke(edit_dat *wed,char *p,int maxsize)
{
	int retv;
	char a;
	int i;
	wed->mxypos = wed->mypos;

	if(p[i] == 0) { return;}  /* kara no toki */

	for(i=0;i<maxsize;i++)
	{
		a = p[i];
		retv = mojioneins(wed,a);
		wed->mxypos++;
		if( a == CR_CODE)
		{
			mojioneins(wed,LF_CODE);
			break;
		}
	}
	adjtabmxypos(wed);
}

char keyin(void)
{
	char a;
/*	a = bdos(0x06,0x00ff,0); */ /* old ver 240630 */
	a = (char)(bdos(0x07,0,0)&0xff);
	return a;
}

/* input filename */
int fname_input(char *fnam,int fnamesiz)
{
	int retcode;
	char *retp;

	retcode = 0;  /* 0==noerror */
	cursor(0,0);
	ESC_cur_delgyo();
	ESC_fontaqua();
	fputs(MES000,stdout);
	ESC_fontdef();
	retp =fgets(fnam, fnamesiz ,stdin);
	for(int i=0; i < fnamesiz; i++)
	{
		if((fnam[i] == CR_CODE) || fnam[i] == LF_CODE)
		{
			fnam[i] = '\0';
		}
	}
	if(retp == NULL)
	{
		retcode = 1;
	}
	return retcode;
}

/* quit ? */
int quit_input()
{
	int retcode;
	char key;

	cursor(0,0);
	ESC_cur_delgyo();
	ESC_fontyellow();
	fputs(MES100,stdout);
	ESC_fontaqua();
	fputs(MES101,stdout);
	ESC_fontdef();

	key = keyin();
	if(key == 'y' || key == 'Y')
	{
		retcode = 1;  /* quit = yes */
	}
	else
	{
		retcode = 0;
	}
	return retcode;
}

/* err output sub */
void err_put(char *p)
{
	cursor(0,0);
	ESC_cur_delgyo();
	ESC_fontred();
	fputs(p,stdout);
	fputs(MES991,stdout);
	ESC_fontdef();
}

/* check write key */
int chkwrkey(char a)
{
	int retval;
	retval = 0;
	switch(a)
	{
		case BS_KEY:
		case TAB_KEY:
		case CR_KEY:
		case EDSCDEL:
		case CTRL_K:
		case CTRL_V:
		retval = 1;
	}

	if( a >= ' ' && a < 0xfd )
	{
		retval = 1;
	}
	return retval;
}

/* editor option -? */
void ed_help()
{
	fputs(
		HELP00
		HELP01
		HELP02
		HELP03
		HELP04
		HELP05
		HELP06
		HELP07
		HELP08
		,stdout);
}

