// =============================================================================
// =============================================================================
// BCDZCu(32bitCPU, Cp) APIwb_
// BCD calculation library (32bitCPU, C language) API Header
//											(c)2025 }CRZ@Vc 
//											(c)2025 Maikon - Giken  Akira Sawada
// Release 1.30  2025/12/23	ׂ\֐ǉ
// Release 1.10  2025/12/15
// =============================================================================
// =============================================================================
// L7܂(ʂɂ萧)
// ẃ}999,999,999(ftHgݒ)
// ֐(Op֐AwEΐ֐A)̐x́AR1.0010܂őΉ

#ifndef VLBCD_API_H
#define VLBCD_API_H
// =============================================================================
// IvVݒ (Option setting)
//		ȉ̒`ɂăRpCEIvV(vvZbT`)Őݒ肷邩A
//		\[XĂB
// =============================================================================
//
#ifndef nBCD_NUM_SIGNIF				// Lݒ(IɕύXꍇ͍őlw)B12ȏ7ȉ(ʂɂ萧)
#define nBCD_NUM_SIGNIF	  (100000)	// eXgTvp\tg(10֐d)̒l
#endif								// IɕύXꍇAۂ̗Lbcd_num_digits()֐Őݒ̂

//#define BCD_NUM_FIXED			// LŒ̏ꍇɎw肷(IuWFNgȂ)

#ifndef nBCD_EXPLIM					// w̌x(Βl)ݒBL{20ȏݒ肷
#define nBCD_EXPLIM	   (999999999)	// ftHgl(l)
#endif

//#define BCD_NON_SECURITY			// RpCstrcpy_s()̈SȊ֐񋟂ĂȂꍇ͎ŵ

//#define BCD_COMPACT_MEM			// ([Nϐ)ߖ񂵂ꍇ͎w肷BZx͒xȂ(Z4{̎Ԃ)

//#define BCD_BASIC_FUNC			// lẐ݂ɐꍇɎw肷B([Nϐ)ߖłB

// BCDϐ𕶎ɕϊ֐(bcd_tostr֐)ɊւIvV
#ifndef nBCD_DISP_SPACE
#define nBCD_DISP_SPACE		  (20)	// ̌Ƃɋ󔒂B0ɂƋ󔒂ȂB
#endif

#ifndef nBCD_DISP_LINE
#define nBCD_DISP_LINE		 (200)	// ̌ƂɉsB0ɂƉsȂBnBCD_DISP_SPACE̐{w肷B
#endif

#ifndef nBCD_DISP_DECIMAL
#define nBCD_DISP_DECIMAL	 (200)	// _ȉ̌ȏ̃[ꍇ͗LZĂw`ɕϊB
#endif

// ]@\
//#define BCD_NO_EVALUATION			// ]@\𖳌ɂꍇ͎w肷B 


// =============================================================================
// BCD_REG(BCDZpϐ)̌^A֘A`
// =============================================================================
// BCD_REGTCYɊւ`
// BCDf[^1word(32bit)6i[B]ēZ6̔{ƂȂB
// ܂Z덷₤߂̐xg(5ȏ)ьグp1KvƂȂB
// xǧ́ALɉĉL萔e[u̒ŎIɑIB

//萔e[u
#include "vlbcd_lib_tbl.h"

//KvTCYvZ
#define nBCD_DNUM				(6)											// 1[ȟ
#define nBCD_EXPAND_SIGNIF		(BCD_TBL_SIGNIF(nBCD_NUM_SIGNIF))			// gx
#define nBCD_NUM_ATLEAST		(nBCD_EXPAND_SIGNIF + nBCD_NUM_SIGNIF + 1)	// ŏKv
#define nBCD_DATMAX				((nBCD_NUM_ATLEAST - 1) / nBCD_DNUM + 1)	// Kv[h
#define nBCD_DIGMAX				(nBCD_DATMAX * nBCD_DNUM)					// Z

// BCDZpϐ̌^`
typedef struct {
	int			 exp;						// wѕBOVERFLOWERROR͓ʂȒlƂB
	unsigned int dat[nBCD_DATMAX];			// dat[0]ŏwordB6/wordB
} BCD_REG;


// =============================================================================
// ֐߂l
// =============================================================================
// S(ʂ̎w̖֐)
#define BCD_OK			(0)				// 
#define BCD_NG			(-1)			// s
#define BCD_INT_ERROR	(0x80000000)	// s(ʂ𐔒lŖ߂֐̏ꍇ)

// =============================================================================
// vg^Cv錾
// =============================================================================
#ifndef BCD_NUM_FIXED
int bcd_num_digits(int d);									// Lݒ (Œ莞͕sv)
#endif

int bcd_strto(BCD_REG* dist, char* src);					// 񂩂BCDϐɊi[B
int bcd_tostr(BCD_REG* src, char* dist);					// BCDϐ𕶎ɕϊBL+1ڂľܓB
															// KvȕTCY@= L*(1 + 1/nBCD_DISP_SPACE + 1/nBCD_DISP_LINE) + 15 mۂ̂ƁB

// ȉAdistsrcƓłĂǂBdistsrcقȂꍇsrc͔j󂳂ȂB
// ȉZLŁA\:ZA%:]Z@Ä͋KiC99ɏ(̏[ɐ؂̂)
int bcd_copy(BCD_REG* dist, BCD_REG* src);					// dist = src
int bcd_clear(BCD_REG* dist);								// dist = 0

int bcd_add(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2);	// dist = src1 + src2
int bcd_sub(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2);	// dist = src1 - src2
int bcd_mul(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2);	// dist = src1 * src2
int bcd_div(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2);	// dist = src1 / src2
int bcd_din(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2);	// dist = src1 \ src2
int bcd_dim(BCD_REG* dist1,BCD_REG* dist2,BCD_REG* src1,BCD_REG* src2);	// dist1= src1 \ src2, dist2 = src1 % src2
int bcd_mod(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2);	// dist = src1 % src2
int bcd_cmp(BCD_REG* src1, BCD_REG* src2);					// src1src2̑召rB߂ĺA0:src1==src2, 1:src1>src2, -1:srtc1<src2

int bcd_abs(BCD_REG* dist, BCD_REG* src);					// dist = abs(src)   
int bcd_inv(BCD_REG* dist, BCD_REG* src);					// dist = -src       
int bcd_IP(BCD_REG* dist, BCD_REG* src);					// dist = src̐(Integer Part)
int bcd_FP(BCD_REG* dist, BCD_REG* src);					// dist = src̏(Fraction Part)
int bcd_EP(BCD_REG* dist, BCD_REG* src);					// dist = src̎w(Exponent Part) (w\̒l)
int bcd_round(BCD_REG* dist, BCD_REG* src, int m);			// dist = srcۂ߂l(m=1Ȃ珬_ȉ2ڂľܓ)

// ȉAnum̗L͈͂́}2,147,483,647܂łƂA-2,147,483,648(0x80000000)̓G[B^ׂ͂(Cxorł͂Ȃ)B
int bcd_ito(BCD_REG* dist, int num, int n);					// dist = num*10^n
int bcd_toi(BCD_REG* src);									// BCDϐ̐intlƂĖ߂B
int bcd_addi(BCD_REG* dist, BCD_REG* src, int num, int n);	// dist = src + num*10^n
#define bcd_subi(dist, src, num, n)	bcd_addi((dist), (src), -(num), (n))	// dist = src - num*10^n
int bcd_isub(BCD_REG* dist, int num, int n, BCD_REG* src);	// dist = num*10^n - src
int bcd_muli(BCD_REG* dist, BCD_REG* src, int num, int n);	// dist = src * num*10^n
int bcd_divi(BCD_REG* dist, BCD_REG* src, int num, int n);	// dist = src / num*10^n
int bcd_dini(BCD_REG* dist, BCD_REG* src, int num, int n);	// dist = src \ num*10^n
int bcd_dimi(BCD_REG* dist1,BCD_REG* dist2,BCD_REG* src,int num,int n);	// dist1 = src \ num*10^n, dist2 = src % num*10^n
int bcd_modi(BCD_REG* dist, BCD_REG* src, int num, int n);	// dist = src % num*10^n
int bcd_cmpi(BCD_REG*  src, int num, int n);				// srcnum*10^n̑召rB߂ĺA0:src==num*10^n, 1:src>num*10^n, -1:srtc<num*10^n
int bcd_facti(BCD_REG* dist, int num);						// dist = num!

#ifndef BCD_BASIC_FUNC
int bcd_sqrt(BCD_REG* dist, BCD_REG* src);					// dist = (src)   
int bcd_curt(BCD_REG* dist, BCD_REG* src);					// dist = 3(src)  
int bcd_pow(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2);	// dist = src1^src2		(^ׂ͂)
int bcd_const_pi(BCD_REG* dist);							// dist =  (~)
int bcd_const_e(BCD_REG* dist);								// dist =  (lCsA)
int bcd_const_ln10(BCD_REG* dist);							// dist = loge(10)

int bcd_angle(int mode);									// Op֐̊px̒PʎwB0:xA1:WA
int bcd_sin(BCD_REG* dist, BCD_REG* src);					// dist = sin(src)
int bcd_cos(BCD_REG* dist, BCD_REG* src);					// dist = cos(src)
int bcd_tan(BCD_REG* dist, BCD_REG* src);					// dist = tan(src)
int bcd_asin(BCD_REG* dist, BCD_REG* src);					// dist = asin(src)
int bcd_acos(BCD_REG* dist, BCD_REG* src);					// dist = acos(src)
int bcd_atan(BCD_REG* dist, BCD_REG* src);					// dist = atan(src)

int bcd_exp(BCD_REG* dist, BCD_REG* src);					// dist = e^src			(^ׂ͂)
int bcd_loge(BCD_REG* dist, BCD_REG* src);					// dist = loge(src)
int bcd_exp10(BCD_REG* dist, BCD_REG* src);					// dist = 10^src		(^ׂ͂)
int bcd_log10(BCD_REG* dist, BCD_REG* src);					// dist = log10(src)

int bcd_sinh(BCD_REG* dist, BCD_REG* src);					// dist = sinh(src)
int bcd_cosh(BCD_REG* dist, BCD_REG* src);					// dist = cosh(src)
int bcd_tanh(BCD_REG* dist, BCD_REG* src);					// dist = tanh(src)
int bcd_asinh(BCD_REG* dist, BCD_REG* src);					// dist = asinh(src)
int bcd_acosh(BCD_REG* dist, BCD_REG* src);					// dist = acosh(src)
int bcd_atanh(BCD_REG* dist, BCD_REG* src);					// dist = atanh(src)
#endif

#ifndef BCD_NO_EVALUATION
int bcd_set_compact(int i);									// COMPACT_MEM[hɂɂ1ݒ肷B0ŉB
int bcd_set_precision(int i);								// ]p̍x揜Zsꍇ1ݒ肷B0ŉB
int bcd_set_baremode(int i);								// bcd_tostrœSĂϊꍇ1w肷B0ŉB
int bcd_set_dispmode(int i);								// Xy[Xs̖l\1w肷B0ŉB
int bcd_fillw9(BCD_REG* dist);								// ̃[9Ŗ߂
#ifndef BCD_BASIC_FUNC
int bcd_set_loop(int i);									// ߎ֐̃[v(1ȏ)w肷B0ŉ(ݒ)B
#endif
#endif

// =============================================================================
#endif	/*VLBCD_API_H*/
