// =============================================================================
// =============================================================================
// BCDZCu(32bitCPU, Cp) LIB R[h
// BCD calculation library (32bitCPU, C language) LIB Code
//											(c)2025 }CRZ@Vc 
//											(c)2025 Maikon - Giken  Akira Sawada
// Release 1.30  2025/12/23	bcd_addsi, bcd_subsiC(bcd_addi, bcd_isub̕s΍)
//							l0ɕwts΍Aׂ\ǉ
//							Γ̒萔ǎ𕶎񂩂16iɕύX(IuWFNgk)
// Release 1.10  2025/12/15
// =============================================================================
// =============================================================================
#include "vlbcd_lib.h"

// =============================================================================
// f[^
// =============================================================================
// ZǗp
#ifndef BCD_NUM_FIXED
static int	bcd_dmax_num, bcd_nmax_num, bcd_signif_num;
#endif

//\[Xؑ֗p
#ifdef BCD_BASIC_FUNC
#define BCD_BASIC_EXE		(1)
#else
#define BCD_BASIC_EXE		(0)
#endif

#ifdef BCD_COMPACT_MEM
#define BCD_COMPACT_EXE		(1)
#else
#define BCD_COMPACT_EXE		(0)
#endif

#ifndef BCD_NO_EVALUATION
#define BCD_EVALUATION		(1)
#else
#define BCD_EVALUATION		(0)
#endif

// Zp[N
#if    BCD_BASIC_EXE == 1 && BCD_EVALUATION == 0
#ifdef BCD_COMPACT_MEM
static BCD_REG w[3];		//lẐ݁Aȃ(ᑬ揜Z)
#define w3	(&w[2])
#else
static BCD_REG w[10];		//lẐ݁A揜Z
#define w3	(&w[2])
#endif	/*BCD_COMPACT_MEM*/
#endif	/*BCD_BASIC_FUNC*/

#if    BCD_BASIC_EXE == 0 || BCD_EVALUATION == 1
#if    BCD_COMPACT_EXE == 1 && BCD_EVALUATION == 0	//S@\Aȃ(ᑬ揜Z)
static BCD_REG w[8];
#define w2	(&w[1])
#define w4	(&w[3])
#define w6	(&w[4])
#define w10	(&w[2])
#define w11	(&w[3])
#define w12	(&w[4])
#define w13	(&w[5])
#define w14	(&w[6])
#define w3	(&w[7])
#else
static BCD_REG w[15];		//S@\A揜Z
#define w2	(&w[2])
#define w4	(&w[4])
#define w6	(&w[5])
#define w10	(&w[10])
#define w11	(&w[11])
#define w12	(&w[12])
#define w13	(&w[13])
#define w14	(&w[14])
#define w3	(&w[9])
#endif	/*BCD_COMPACT_MEM*/
#endif	/*BCD_BASIC_FUNC*/

#define w0	(&w[0])		//ɏ揜Zp
#define w1	(&w[1])		//ɏ揜Zp
//    &w[2]`&w[9]		//揜Zp
//		w2:		Ap
//		w4,w6:	p
//		w10-w12:b֐p(sin,cos,asin,exp,loge)
//		w13,w14:p֐p(tan,acos,atan,exp10,log10, x^y)
//		w3:		ᑬZp(揜ZwłĂ]w̏ꍇ͕Kv)

#define nBCD_WINDEX		(4)
static int wi[nBCD_WINDEX][4];		//num*10^ni[piBCD_REG^ɃLXgĎgpB\[X{ŃV[g^ƌĂԁj
static int wdrop;					//rp[N

#ifndef BCD_BASIC_FUNC
static int wmode;					//px[hI(0:x, 1:WA)
#endif

// 萔
#ifndef BCD_BASIC_FUNC
#include "vlbcd_lib_pi.h"
#include "vlbcd_lib_nap.h"
#include "vlbcd_lib_ln10.h"
#endif

//]p
#ifndef BCD_NO_EVALUATION
static int compact_flag;
static int precision_flag;
static int baremode_flag;

static int space_control = nBCD_DISP_SPACE;			//ׂ\ƒʏ\̐؂ւp
static int line_control = nBCD_DISP_LINE;			//ׂ\ƒʏ\̐؂ւp
#define nBCD_CONT_SPACE		(space_control)
#define nBCD_CONT_LINE		(line_control)

#ifndef BCD_BASIC_FUNC
static int func_loop_num;
#endif

#else
#define nBCD_CONT_SPACE		(nBCD_DISP_SPACE)
#define nBCD_CONT_LINE		(nBCD_DISP_LINE)
#endif

// =============================================================================
// =============================================================================
// lZȂǂ̊{IȊ֐
// =============================================================================
// =============================================================================

// ===============================================
// Zݒ
// ===============================================
#ifndef BCD_NUM_FIXED
int bcd_num_digits(int d) {

	if (d < nBCD_MIN_SIGNIF || d > nBCD_NUM_SIGNIF) return BCD_NG;
	nBCD_SIGNIF = d;
	nBCD_NMAX = (d + BCD_TBL_SIGNIF(d)) / nBCD_DNUM + 1;
	nBCD_DMAX = nBCD_NMAX * nBCD_DNUM;

	return BCD_OK;
}
#endif

// ===============================================
// 񂩂BCDϐɊi[
// ===============================================
int bcd_strto(BCD_REG* dist, char* src) {
	int sgn, dp, num;
	unsigned int *dw, nj;
	long na;
	char *p;

	if (dist == NULL || src == NULL) return BCD_NG;
	bcd_clr(dist);

	sgn = num = dp = 0;	//mA擪mA_m
	dw = dist->dat;
	nj = BCD_DAT_BITF;
	p = src;

	//̃ftHg͐Ȃ̂ŕ̎̂ݕύXB
	//ϐ̓[NAĂ̂Ől1`9̂݊i[B
	while (*p >= '\n') {
		if (*p == '0') {
			if (!sgn) sgn = 1;								//m聨+m
			else if (!num) {								//擪m
				if (dp)	BCD_ADD_EXP(dist, -1);				//_m͎w-1B~bg`FbN͌ōs
			}
			else {											//擪m
				if (dw < dist->dat + nBCD_NMAX) {
					BCD_IDX_DW(nj, dw);						//[͊i[Kv
				}
				if (!dp) BCD_ADD_EXP(dist, 1);				//_m莞͎w+1B~bg`FbN͌ōs
			}
		}
		else if (*p > '0' && *p <= '9') {
			sgn = 1;										//m
			if (dw < dist->dat + nBCD_NMAX) {
				*dw |= (*p & 0x0f) << nj;
				BCD_IDX_DW(nj, dw);
			}
			if (num && !dp)	BCD_ADD_EXP(dist, 1);			//擪mς݂ŏ_m莞͎w+1B~bg`FbN͌ōs
			num = 1;										//擪m
		}
		else if (*p == '-' || *p == '+') {
			if (!sgn) {
				sgn = 1;									//m聨m
				if (*p == '-') BCD_SET_NEGA(dist);
			}
			else { BCD_SET_ERROR(dist); return BCD_NG; }	//s
		}
		else if (*p == '.') {
			if (!dp) {
				sgn = 1;
				dp = 1;										//_m聨m
				if (!num) BCD_ADD_EXP(dist, -1);			//擪mȂw-1ݒ
			}
			else { BCD_SET_ERROR(dist); return BCD_NG; }	//s
		}
		else if (*p == 'e' || *p == 'E') {
			p++;
			na = strtol(p, NULL, 10);
			if (na < -nBCD_EXPLIM) dist->dat[0] = 0;
			else if (na > nBCD_EXPLIM) BCD_SET_EXP(dist, nBCD_EXPLIM + 1);
			else BCD_ADD_EXP(dist, na);
			break;	//I
		}
		else if (*p != ' ' && *p != ',' && *p != '\r' && *p != '\n') break;
		p++;
	}

	if (BCD_CHK_UNDER(dist) || BCD_DET_ZERO(dist)) {
		return bcd_clr(dist);
	}
	if (BCD_CHK_OVER(dist)) {
		BCD_SET_OVER(dist);
		return BCD_NG;
	}

	return BCD_OK;
}

// ===============================================
// BCDϐ𕶎ɕϊ
// ===============================================
int bcd_tostr(BCD_REG* src, char* dist) {
	int j, k, mm, np, maru, nexp;
	int spc, lpc, limit;
	unsigned int *dw, nj, carry;
//	char *p;

	if (src == NULL || dist == NULL) return BCD_NG;
	limit = nBCD_SIGNIF;
#ifndef BCD_NO_EVALUATION
	if (baremode_flag) limit = nBCD_DMAX - 1;
#endif

	if (BCD_DET_OVER(src)) {
		__strcpy_s(dist, nBCD_STRLIM, "OVERFLOW\r\n");
		return BCD_NG;
	}
	if (BCD_DET_ERROR(src)) {
		__strcpy_s(dist, nBCD_STRLIM, "ERROR\r\n");
		return BCD_NG;
	}
	if (src->dat[0] & BCD_DAT_BCDT || !(src->dat[0] & BCD_DAT_BCDF) && src->exp) {
		__strcpy_s(dist, nBCD_STRLIM, "WRONG FORMAT\r\n");
		return BCD_NG;
	}
	if (BCD_DET_ZERO(src)) {
		__strcpy_s(dist, nBCD_STRLIM, "0\r\n");
		return BCD_OK;
	}
	dist[0] = '\0';

	if (nBCD_CONT_SPACE == 0) spc = nBCD_DIGMAX + 20;
	else					  spc = nBCD_DISP_SPACE;
	if (nBCD_CONT_LINE  == 0) lpc = nBCD_DIGMAX + 20;
	else					  lpc = (nBCD_DISP_LINE / nBCD_DISP_SPACE) * nBCD_DISP_SPACE;

	// ľܓ
	maru = 0;
	if (limit < nBCD_DMAX - 1) {
		dw = src->dat + (limit + 1) / nBCD_DNUM;		//ptc
		j = (limit + 1) % nBCD_DNUM;					//ptc
		nj = BCD_DAT_BITT - nBCD_DBIT * j;				//ptc
		if (((*dw >> nj) & 0x0f) >= 5) {
			maru = 1;
			BCD_IDX_UP(nj, dw);
			*dw += 1 << nj;
			carry = 0;
			do {
				*dw += BCD_SUP_MASK + BCD_CRY_MASK + carry;
				carry = (*dw & BCD_CRY_MASK) >> 2;
				carry += carry >> 1;
				*dw -= carry;
				carry = *dw >> BCD_CYU_BIT;
				*dw-- &= BCD_DAT_MASK;
			} while (carry && dw >= src->dat);
		}
	}

	dw = src->dat;
	if (*dw & BCD_DAT_BCDT) j = limit - 1; 			//ۂ߂ɂ錅莞
	else 				    j = limit;
	dw += j / nBCD_DNUM;								//ptc
	nj = BCD_DAT_BITT - (j % nBCD_DNUM) * nBCD_DBIT;	//ptc
	for (j = 0; j < limit; j++) {
		if (*dw & (0x0f << nj)) break;
		BCD_IDX_UP(nj, dw);
	}
	mm = j;		//0̌

	//}CiX\
	if (BCD_GET_SGN(src)) {
		dist[0] = '-';
		np = 1;
	}
	else np = 0;

	dw = src->dat;
	if (*dw & BCD_DAT_BCDT) {		//L
		nj = BCD_DAT_BITT;
		nexp = BCD_GET_EXP(src) + 1;
	}
	else {
		nj = BCD_DAT_BITF;
		nexp = BCD_GET_EXP(src);
	}
	if (nexp >= -nBCD_DISP_DECIMAL && (nexp >= 0 && nexp < limit || nexp < 0 && (-nexp <= mm || -nexp <= 3))) {
		//w\
		mm = limit - mm;
		if (nexp < 0) {
			dist[np++] = '.';
			for (j = 1; j < -nexp; j++) {
				if (j % lpc == 0) { dist[np++] = '\r'; dist[np++] = '\n'; }
				else if (j % spc == 0) dist[np++] = ' ';
				dist[np++] = '0';
			}
			k = j;
			for (; j < k + mm; j++) {
				if (j % lpc == 0) { dist[np++] = '\r'; dist[np++] = '\n'; }
				else if (j % spc == 0) dist[np++] = ' ';
				dist[np++] = ((*dw >> nj) & 0x0f) + '0';
				BCD_IDX_DW(nj, dw);
			}
		}
		else {
			for (j = 0; j <= nexp; j++) {
				if (j > 0) {
					if (j % lpc == 0) { dist[np++] = '\r'; dist[np++] = '\n'; }
					else if (j % spc == 0) dist[np++] = ' ';
				}
				if (j >= mm) dist[np++] = '0';
				else {
					dist[np++] = ((*dw >> nj) & 0x0f) + '0';
					BCD_IDX_DW(nj, dw);
				}
			}
			if (j < mm) {
				dist[np++] = '.';
				if (nBCD_CONT_SPACE != 0) dist[np++] = ' ';
				for (; j < mm; j++) {
					if (j % lpc == 0) { dist[np++] = '\r'; dist[np++] = '\n'; }
					else if (j % spc == 0) dist[np++] = ' ';
					dist[np++] = ((*dw >> nj) & 0x0f) + '0';
					BCD_IDX_DW(nj, dw);
				}
			}
		}
		dist[np++] = '\r'; dist[np++] = '\n'; dist[np] = '\0';
	}
	else {
		//w\
		dist[np++] = ((*dw >> nj) & 0x0f) + '0';
		BCD_IDX_DW(nj, dw);
		mm = limit - mm;
		if (mm > 1) {
			dist[np++] = '.';
			for (j = 1; j < mm; j++) {
				if (j % lpc == 0) { dist[np++] = '\r'; dist[np++] = '\n'; }
				else if (j % spc == 0) dist[np++] = ' ';
				dist[np++] = ((*dw >> nj) & 0x0f) + '0';
				BCD_IDX_DW(nj, dw);
			}
		}
		if (nBCD_CONT_SPACE != 0) dist[np++] = ' ';
		dist[np++] = 'e';
		__sprintf_s(&dist[np], 12, "%d", nexp);
		while (dist[np] != '\0') np++;
		__strcat_s(&dist[np], 4, "\r\n");
	}

	// ľܓ߂
	if (maru) {
		dw = src->dat     +  limit / nBCD_DNUM;					//ptc
		nj = BCD_DAT_BITT - (limit % nBCD_DNUM) * nBCD_DBIT;	//ptc
		*dw -= 1 << nj;
		carry = 0;
		do {
			*dw -= carry;
			carry = (*dw & BCD_CRY_MASK) >> 2;
			carry += carry >> 1;
			*dw -= carry;
			carry = *dw >> BCD_CYU_BIT;
			*dw-- &= BCD_DAT_MASK;
		} while (carry && dw >= src->dat);
	}

	return BCD_OK;
}

// ===============================================
// @Rs[@
// ===============================================
int bcd_copy(BCD_REG* dist, BCD_REG* src) {
	if (dist == NULL || src == NULL) return BCD_NG;
	if (dist == src) return BCD_OK;
	return bcd_cpy(dist, src);
}

static int bcd_cpy(BCD_REG* dist, BCD_REG* src) {
	unsigned int *dd, *dw;

	dist->exp = src->exp;
	dd = dist->dat;
	dw = src->dat;
	while (dd < dist->dat + nBCD_NMAX) *dd++ = *dw++;
	return BCD_OK;
}

// ===============================================
// @NA@
// ===============================================
int bcd_clear(BCD_REG* dist) {
	if (dist == NULL) return BCD_NG;
	return bcd_clr(dist);
}

int bcd_clr(BCD_REG* dist) {
	unsigned int *dd;

	dist->exp = 0;
	dd = dist->dat;
	while (dd < dist->dat + nBCD_NMAX) *dd++ = 0;
	return BCD_OK;
}

// ===============================================
// @Z@
// ===============================================
int bcd_add(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2) {
	int i, j;

	// G[l̉Z`FbN
	if (bcd_err_chk2(dist, src1, src2)) return BCD_NG;

	i = nBCD_DMAX - 1;
	j = BCD_GET_EXP(src2) - BCD_GET_EXP(src1);
	// Е[܂̓[ƓȂvZȗ
	if (BCD_DET_ZERO(src1) || j > i) {
		bcd_cpy(dist, src2);
		return BCD_OK;
	}
	else if (BCD_DET_ZERO(src2) || -j > i) {
		bcd_cpy(dist, src1);
		return BCD_OK;
	}

	// `FbN
	if (BCD_GET_SGN(src1) ^ BCD_GET_SGN(src2)) {
		//Z
		i = bcd_cmpabs(src1, src2);
		if (i == 0) 		return bcd_clr(dist);
		else if (i > 0) 	bcd_subsi(dist, src1, src2, nBCD_NMAX - 1, nBCD_NMAX - 1);
		else				bcd_subsi(dist, src2, src1, nBCD_NMAX - 1, nBCD_NMAX - 1);
		//
		return bcd_dropup(dist);
	}

	//Zьオ菈
	if (j > 0)	bcd_addsi(dist, src2, src1, nBCD_NMAX - 1, nBCD_NMAX - 1);
	else		bcd_addsi(dist, src1, src2, nBCD_NMAX - 1, nBCD_NMAX - 1);
	return bcd_shiftd(dist, nBCD_NMAX - 1);
}

static int bcd_addsi(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2, int nbot1, int nbot2) {
	int nj, njs, nk, nn;
	unsigned int  wku, carry, *d1, *d2, *dd, *dw;

	//w̑召͊OōsB̊֐ł͕Kwsrc1 >= src2ɂȂ邱ƂOƂB
	//nbot2src2̍Ō̗Lʒu(VtgΉ̂+1l)B~bg`FbNς݂ł邱ƁB
	//Zʂ肵̃Vtg_E(bcd_shiftd)͌ďoŎs邱ƁB
	//dist̕src1pĂ̂ŁAKvɉČďoŔ]邱ƁB

	//VtgʎZ
	if      (nbot1 >=  0)	nn = nBCD_NMAX - 1;
	else if (nbot1 == -1)	nn = nbot1 = nBCD_NMAX + nBCD_NMAX;						//{
	else if (nbot1 == -2)	nn = nbot1 = nBCD_NMAX + nBCD_NMAX + nBCD_NMAX + 1;		//3{
	nk = BCD_GET_EXP(src1) - BCD_GET_EXP(src2);
	nj = (nk % nBCD_DNUM) * nBCD_DBIT;			//ptc
	nk = nn - nk / nBCD_DNUM;					//ptc
	if (nbot2 < nk) {
		d2 = src2->dat + nbot2;
		nk -= nbot2;
		if (dist == src1) {
			d1 = src1->dat + nn - nk;
			dd = d1;
		}
		else {
			d1 = src1->dat + nn;
			dd = dist->dat + nn;
			while (nk-- > 0) *dd-- = *d1--;
		}
	}
	else {
		d2 = src2->dat + nk;
		d1 = src1->dat + nn;
		dd = dist->dat + nn;
	}

	//Zьグ
	carry = 0;
	if (nj == 0) {
		if (nbot1 < nbot2) while (d1 > src1->dat + nbot1) {
			if (d2 >= src2->dat)	*dd-- = *d2--;
			else					*dd-- = 0;
			d1--;
		}
		while (d2 >= src2->dat) {
			wku = *d1-- + *d2-- + carry;
			wku += BCD_SUP_MASK + BCD_CRY_MASK;
			carry = (wku & BCD_CRY_MASK) >> 2;
			carry += carry >> 1;
			wku -= carry;
			carry = wku >> BCD_CYU_BIT;
			*dd-- = wku & BCD_DAT_MASK;
		}
	}
	else {
		njs = nBCD_ABIT - nj;
		if (nbot1 < nbot2) while (d1 > src1->dat + nbot1) {
			if (d2 >= src2->dat)	wku = *d2-- >> nj;
			else					wku = 0;
			if (d2 >= src2->dat)	wku += BCD_CYU_CLR(*d2 << njs);		//VtgAbv͕KJzL[NA
			*dd-- = wku;
			d1--;
		}
		while (d2 > src2->dat) {
			wku = *d2-- >> nj;
			wku += BCD_CYU_CLR(*d2 << njs);								//VtgAbv͕KJzL[NA
			wku += *d1-- + carry;
			wku += BCD_SUP_MASK + BCD_CRY_MASK;
			carry = (wku & BCD_CRY_MASK) >> 2;
			carry += carry >> 1;
			wku -= carry;
			carry = wku >> BCD_CYU_BIT;
			*dd-- = wku & BCD_DAT_MASK;
		}
		if (d2 == src2->dat) {
			wku = *d2 >> nj;
			wku += *d1-- + carry;
			wku += BCD_SUP_MASK + BCD_CRY_MASK;
			carry = (wku & BCD_CRY_MASK) >> 2;
			carry += carry >> 1;
			wku -= carry;
			carry = wku >> BCD_CYU_BIT;
			*dd-- = wku & BCD_DAT_MASK;
		}
	}

	if (dist != src1) {
		dw = dd;
		d2 = d1;
		while (dw >= dist->dat) *dw-- = *d2--;
	}
	while (carry && dd >= dist->dat) {
		*dd += BCD_SUP_MASK + BCD_CRY_MASK + 1;
		carry = (*dd & BCD_CRY_MASK) >> 2;
		carry += carry >> 1;
		*dd -= carry;
		carry = *dd >> BCD_CYU_BIT;
		*dd-- &= BCD_DAT_MASK;
	}

	//wE
	dist->exp = src1->exp;

	return BCD_OK;
}

// ===============================================
// @Z@
// ===============================================
int bcd_sub(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2) {
	int i, j;

	// G[l̉Z`FbN
	if (bcd_err_chk2(dist, src1, src2)) return BCD_NG;

	i = nBCD_DMAX - 1;
	j = BCD_GET_EXP(src2) - BCD_GET_EXP(src1);
	// Е[܂̓[ƓȂvZȗ
	if (BCD_DET_ZERO(src1) || j > i) {
		bcd_cpy(dist, src2);
		BCD_SET_SINV(dist);
		return BCD_OK;
	}
	else if (BCD_DET_ZERO(src2) || -j > i) {
		bcd_cpy(dist, src1);
		//͂̂܂
		return BCD_OK;
	}

	// `FbN
	if (BCD_GET_SGN(src1) ^ BCD_GET_SGN(src2)) {
		//Zƌオ菈
		if (j > 0) {
			bcd_addsi(dist, src2, src1, nBCD_NMAX - 1, nBCD_NMAX - 1);
			BCD_SET_SINV(dist);
		}
		else {
			bcd_addsi(dist, src1, src2, nBCD_NMAX - 1, nBCD_NMAX - 1);
		}
		return bcd_shiftd(dist, nBCD_NMAX - 1);
	}

	//Zƌ
	i = bcd_cmpabs(src1, src2);
	if (i == 0)	return bcd_clr(dist);
	else if (i > 0) {
		bcd_subsi(dist, src1, src2, nBCD_NMAX - 1, nBCD_NMAX - 1);
	}
	else {
		bcd_subsi(dist, src2, src1, nBCD_NMAX - 1, nBCD_NMAX - 1);
		BCD_SET_SINV(dist);
	}
	return bcd_dropup(dist);
}

static int bcd_subsi(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2, int nbot1, int nbot2) {
	int nj, njs, nk, nn;
	unsigned int wku, carry, *d1, *d2, *dd, *dw;

	//召͊OōsB̊֐ł͕KΒlsrc1>=src2ƂȂ邱ƂOƂB
	//nbot2src2̍Ō̗Lʒu(VtgΉ̂+1l)B~bg`FbNς݂ł邱ƁB
	//Zʂ̃VtgAbv(bcd_dropup)͌ďoŎs邱ƁB
	//dist̕src1pĂ̂ŁAKvɉČďoŔ]邱ƁB

	//VtgʎZ
	if (nbot1 >= 0)	nn = nBCD_NMAX - 1;
	else if (nbot1 == -1)	nn = nbot1 = nBCD_NMAX + nBCD_NMAX;						//{
	else if (nbot1 == -2)	nn = nbot1 = nBCD_NMAX + nBCD_NMAX + nBCD_NMAX + 1;		//3{
	nk = BCD_GET_EXP(src1) - BCD_GET_EXP(src2);
	nj = (nk % nBCD_DNUM) * nBCD_DBIT;			//ptc
	nk = nn - nk / nBCD_DNUM;		//ptc
	if (nbot2 < nk) {
		d2 = src2->dat + nbot2;
		nk -= nbot2;
		if (dist == src1) {
			d1 = src1->dat + nn - nk;
			dd = d1;
		}
		else {
			d1 = src1->dat + nn;
			dd = dist->dat + nn;
			while (nk-- > 0) *dd-- = *d1--;
		}
	}
	else {
		d2 = src2->dat + nk;
		d1 = src1->dat + nn;
		dd = dist->dat + nn;
	}

	//Zьグ
	carry = 1;
	if (nj == 0) {
		if (nbot1 < nbot2) while (d1 > src1->dat + nbot1) {
			if (d2 >= src2->dat)	wku = ~*d2-- + carry;
			else					wku = ~0 + carry;
			d1--;
			carry = (wku & BCD_CRY_MASK) >> 2;
			carry += carry >> 1;
			wku -= carry;
			carry = (wku >> BCD_CYU_BIT) ^ 1;
			*dd-- = wku & BCD_DAT_MASK;
		}
		while (d2 >= src2->dat) {
			wku = *d1-- + ~*d2-- + carry;
			carry = (wku & BCD_CRY_MASK) >> 2;
			carry += carry >> 1;
			wku -= carry;
			carry = (wku >> BCD_CYU_BIT) ^ 1;
			*dd-- = wku & BCD_DAT_MASK;
		}
	}
	else {
		njs = nBCD_ABIT - nj;
		if (nbot1 < nbot2) while (d1 > src1->dat + nbot1) {
			if (d2 >= src2->dat)	wku = *d2-- >> nj;
			else					wku = 0;
			if (d2 >= src2->dat)	wku |= BCD_CYU_CLR(*d2 << njs);		//VtgAbv͕KJzL[NA
			wku = ~wku + carry;
			d1--;
			carry = (wku & BCD_CRY_MASK) >> 2;
			carry += carry >> 1;
			wku -= carry;
			carry = (wku >> BCD_CYU_BIT) ^ 1;
			*dd-- = wku & BCD_DAT_MASK;
		}
		while (d2 > src2->dat) {
			wku = *d2-- >> nj;
			wku |= BCD_CYU_CLR(*d2 << njs);								//VtgAbv͕KJzL[NA
			wku = *d1-- + ~wku + carry;
			carry = (wku & BCD_CRY_MASK) >> 2;
			carry += carry >> 1;
			wku -= carry;
			carry = (wku >> BCD_CYU_BIT) ^ 1;
			*dd-- = wku & BCD_DAT_MASK;
		}
		if (d2 == src2->dat) {
			wku = *d2 >> nj;
			wku = *d1-- + ~wku + carry;
			carry = (wku & BCD_CRY_MASK) >> 2;
			carry += carry >> 1;
			wku -= carry;
			carry = (wku >> BCD_CYU_BIT) ^ 1;
			*dd-- = wku & BCD_DAT_MASK;
		}
	}
	if (dist != src1) {
		dw = dd;
		d2 = d1;
		while (dw >= dist->dat) *dw-- = *d2--;
	}
	while (!carry && dd >= dist->dat) {
		*dd -= 1;
		carry = (*dd & BCD_CRY_MASK) >> 2;
		carry += carry >> 1;
		*dd -= carry;
		carry = (*dd >> BCD_CYU_BIT) ^ 1;
		*dd-- &= BCD_DAT_MASK;
	}

	//wE
	dist->exp = src1->exp;

	return BCD_OK;
}

// ===============================================
// @Z@
// ===============================================
int bcd_mul(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2) {
	int j, k, iadd, exp_hold, nbot1, nbot2;
	BCD_REG *d1, *d2;

	// G[l̉Z`FbN
	if (bcd_err_chk2(dist, src1, src2)) return BCD_NG;

	// Е[ȂvZȗ
	if (BCD_DET_ZERO(src1) || BCD_DET_ZERO(src2)) return bcd_clr(dist);

	//I[o[t[`FbN(ꎟ)
	iadd = BCD_GET_EXP(src1) + BCD_GET_EXP(src2);
	if (iadd > nBCD_EXPLIM) {
		BCD_SET_OVER(dist);
		return BCD_NG;
	}
	//A_[t[`FbN(ꎟ)
	if (iadd < -(nBCD_EXPLIM + 1)) return bcd_clr(dist);

	//L`FbNA[N|C^ݒexpۑ
	j = bcd_nbot(src1);
	k = bcd_nbot(src2);
	if (j < k) {
		d1 = src2;
		d2 = src1;
		nbot1 = k;
		nbot2 = j;
	}
	else {
		d1 = src1;
		d2 = src2;
		nbot1 = j;
		nbot2 = k;
	}
	if (dist == d1) {
		bcd_cpy(w0, d1);
		d1 = w0;
		if (src1 == src2) d2 = d1;		//d2Ԃ̂d1ƓƂB
		exp_hold = BCD_EXP_INVALID;		//d1͂Ԃ̂ŕێsvBȂ̂expیKvȂ
	}
	else {
		exp_hold = d1->exp;				//d1expj󂷂̂ŁAی삵Čŕ

		if (dist == d2 ) {				//dist!=d2 && d1==d2̎d1ɂd2̂ŖȂB
			bcd_cpy(w1, d2);
			d2 = w1;
		}
	}

	BCD_SET_EXSG(d1, iadd, BCD_GET_SGN(d1) ^ BCD_GET_SGN(d2));
	bcd_mulsi(dist, d1, d2, nbot1, nbot2);

	//
	if (exp_hold != BCD_EXP_INVALID) {
		d1->exp = exp_hold;
	}

	//菈
	j = bcd_shiftd(dist, nBCD_NMAX - 1);
	k = BCD_GET_EXP(dist);

	//I[o[t[`FbN(ŏI)
	if (j || k > nBCD_EXPLIM) {
		BCD_SET_OVER(dist);
		return BCD_NG;
	}
	//A_[t[`FbN(ŏI)
	if (k < -nBCD_EXPLIM) {
		bcd_clr(dist);
	}
	return BCD_OK;
}

static int bcd_mulsi(BCD_REG* dist, BCD_REG* d1, BCD_REG* d2, int nbot1, int nbot2) {
	int j, k, ni, nj;

	// distd1,d2Ƃ͈قȂ邱ƁBd2|鑤ŊmBnbot2̓VtgȂ̂ŕKvŒŗǂBd2̓V[g^WX^łǂB

#if	BCD_EVALUATION == 1
	if (precision_flag) goto HIGH_PREC;
	if (compact_flag)
#endif

#if BCD_COMPACT_EXE == 1 || BCD_EVALUATION == 1
	{
		//1ڂ̏
		bcd_cpy(dist, d1);
		j = (d2->dat[0] >> BCD_DAT_BITF) & 0x0f;

		while (j > 1) {
			bcd_addsi(dist, dist, d1, nbot1, nbot1);
			j--;
		}

		//2ڈȍ~̏
		ni = 0;
		nj = BCD_DAT_BITS;
		k = (nbot2 + 1) * nBCD_DNUM - 2;	//nbot2̓AhXȂ̂Ō+1ČvZ
		while (k > 0) {
			BCD_ADD_EXP(d1, -1);
			j = (d2->dat[ni] >> nj) & 0x0f;
			if (j == 1) bcd_addsi(dist, dist, d1, nbot1, nbot1);
			else if (j > 1) {
				bcd_cpy(w3, d1);			//Uw3ŉZȂƁAt߂Ō덷傫Ȃ
				while (j > 1) {
					bcd_addsi(w3, w3, d1, nbot1, nbot1);
					j--;
				}
				bcd_addsi(dist, dist, w3, nbot1, nbot1);
			}
			BCD_IDX_DW(nj, ni);
			k--;
		}
	}
#endif

#if	BCD_EVALUATION == 1
	else
#endif

#if BCD_COMPACT_EXE == 0 || BCD_EVALUATION == 1
	{
		bcd_addsi(&w[2], d1, d1, nbot1, nbot1);
		bcd_addsi(&w[3], &w[2], d1, nbot1, nbot1);
		bcd_addsi(&w[4], &w[3], d1, nbot1, nbot1);
		bcd_addsi(&w[5], &w[4], d1, nbot1, nbot1);
		bcd_addsi(&w[6], &w[5], d1, nbot1, nbot1);
		bcd_addsi(&w[7], &w[6], d1, nbot1, nbot1);
		bcd_addsi(&w[8], &w[7], d1, nbot1, nbot1);
		bcd_addsi(&w[9], &w[8], d1, nbot1, nbot1);

		//1ڂ̊|ŹARs[
		j = (d2->dat[0] >> BCD_DAT_BITF) & 0x0f;
		if (j == 1) bcd_cpy(dist, d1);
		else		 bcd_cpy(dist, &w[j]);

		//2ڈȍ~̏
		ni = 0;
		nj = BCD_DAT_BITS;
		k = (nbot2 + 1) * nBCD_DNUM - 2;	//nbot2̓AhXȂ̂Ō+1ČvZ
		while (k > 0) {
			BCD_ADD_EXP(d1, -1);
			BCD_ADD_EXP(&w[2], -1);
			BCD_ADD_EXP(&w[3], -1);
			BCD_ADD_EXP(&w[4], -1);
			BCD_ADD_EXP(&w[5], -1);
			BCD_ADD_EXP(&w[6], -1);
			BCD_ADD_EXP(&w[7], -1);
			BCD_ADD_EXP(&w[8], -1);
			BCD_ADD_EXP(&w[9], -1);
			j = (d2->dat[ni] >> nj) & 0x0f;
			if (j == 1) {
				bcd_addsi(dist, dist, d1, nbot1, nbot1);
			}
			else if (j > 1) bcd_addsi(dist, dist, &w[j], nbot1, nbot1);
			BCD_IDX_DW(nj, ni);
			k--;
		}
	}
#endif
	return BCD_OK;

#if	BCD_EVALUATION == 1
HIGH_PREC:
	bcd_addsi(&w[2], d1, d1, nbot1, nbot1);
	bcd_addsi(&w[3], &w[2], d1, nbot1, nbot1);
	bcd_addsi(&w[4], &w[3], d1, nbot1, nbot1);
	bcd_addsi(&w[5], &w[4], d1, nbot1, nbot1);
	bcd_addsi(&w[6], &w[5], d1, nbot1, nbot1);
	bcd_addsi(&w[7], &w[6], d1, nbot1, nbot1);
	bcd_addsi(&w[8], &w[7], d1, nbot1, nbot1);
	bcd_addsi(&w[9], &w[8], d1, nbot1, nbot1);

	bcd_clr(dist);
	ni = nBCD_NMAX - 1;
	nj = BCD_DAT_BITB;
	k = nBCD_DMAX - 1;		//xr̓tO
	while (k > 0) {
		BCD_ADD_EXP(dist, -1);
		j = (d2->dat[ni] >> nj) & 0x0f;
		if (compact_flag) {
			while (j > 0) {
				bcd_add(dist, dist, d1);
				j--;
			}
		}
		else {
			if (j == 1) bcd_add(dist, dist, d1);
			else		bcd_add(dist, dist, &w[j]);
		}
		BCD_IDX_UP(nj, ni);
		k--;
	}
	return BCD_OK;
#endif
}

// ===============================================
// @Z@
// ===============================================
int bcd_div(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2) {
	int isub, d2exp_hold, nbot2;
	BCD_REG	*d1, *d2;

	// G[l̉Z`FbN
	if (bcd_err_chk2(dist, src1, src2)) return BCD_NG;

	// Е[ȂvZȗ
	if (BCD_DET_ZERO(src1)) return bcd_clr(dist);
	if (BCD_DET_ZERO(src2)) {
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}

	//I[o[t[`FbN(ꎟ)
	isub = BCD_GET_EXP(src1) - BCD_GET_EXP(src2);
	if (isub >(nBCD_EXPLIM + 1)) {					//Ŏ܂\邽+1Ŕ
		BCD_SET_OVER(dist);
		return BCD_NG;
	}
	//A_[t[`FbN(ꎟ)
	if (isub < -nBCD_EXPLIM) return bcd_clr(dist);


	//[N|C^ݒ ({łłsrc1͕Kcp[NɃRs[)
	d1 = w0;
	bcd_cpy(d1, src1);
	if (dist == src2) {
		d2 = w1;
		bcd_cpy(d2, src2);
		d2exp_hold = BCD_EXP_INVALID;	//src2distł邽ߕێ̕Kv͂Ȃ
	}
	else {
		d2 = src2;
		d2exp_hold = d2->exp;			//src2expj󂳂̂ŕێB
	}
	nbot2 = bcd_nbot(d2);
	bcd_clr(dist);

	BCD_SET_EXSG(dist, isub, BCD_GET_SGN(d1) ^ BCD_GET_SGN(d2));
	bcd_divsi(dist, d1, d2, nbot2, 0);

	//
	if (d2exp_hold != BCD_EXP_INVALID) {
		src2->exp = d2exp_hold;
	}

	//I[o[t[`FbN(ŏI)
	isub = BCD_GET_EXP(dist);
	if (isub > nBCD_EXPLIM) {
		BCD_SET_OVER(dist);
		return BCD_NG;
	}
	//A_[t[`FbN(ŏI)
	if (isub < -nBCD_EXPLIM) {
		bcd_clr(dist);
	}

	return BCD_OK;	//devsiŌ΍􂵂Ă̂bcd_dropup̌ďo͕sv
}

static int bcd_divsi(BCD_REG* dist, BCD_REG* d1, BCD_REG* d2, int nbot2, int limit) {
	int j, k, nj, ddmax;
	unsigned int *dd;
#if BCD_COMPACT_EXE == 1 || BCD_EVALUATION == 1
	int m;
#endif

	//distd1,d2Ƃ͈قȂ邱ƁBdistdat̓NAĂ邱ƁB
	//d1͔j󂳂(limitwȂc]ƂȂ)Bd2expj󂳂̂ŌďoŕB

	if (limit) ddmax = limit;
	else	   ddmax = nBCD_DMAX;

	bcd_cmpflt_init();

#if	BCD_EVALUATION == 1
	if (precision_flag) goto HIGH_PDEV;
	if (compact_flag)
#endif

#if BCD_COMPACT_EXE == 1 || BCD_EVALUATION == 1
	{
		//ʏ퐸xARpNg
		d2->exp = d1->exp;
		dd = dist->dat;
		nj = BCD_DAT_BITF;

		//m = 0;
		k = bcd_cmpflt(d1, d2, 0, nbot2);
		if (k == 0) {
			*dd |= 1 << nj;
		}
		else {
			if (k < 0) {
				bcd_shiftu(d1);
				if (limit) ddmax--;
				BCD_ADD_EXP(d2, -1);
				BCD_ADD_EXP(dist, -1);
				m = 0;
			}
			else {
				bcd_subsi(d1, d1, d2, nBCD_NMAX - 1, nbot2);
				m = 1;
			}
			for (j = 1; j < ddmax; j++) {
				//m = 0; 1ڂ̂ݕʏ
				while ((k = bcd_cmpflt(d1, d2, 0, nbot2)) > 0) {
					bcd_subsi(d1, d1, d2, nBCD_NMAX - 1, nbot2);
					m++;
					if (m == 9) break;
				}
				if (k == 0) {
					*dd |= (m + 1) << nj;
					break;
				}
				else *dd |= m << nj;	//[肹ɏ񂾕g[^xオ͂B
				BCD_ADD_EXP(d2, -1);
				BCD_IDX_DW(nj, dd);
				m = 0;
			}
			if (BCD_DET_ZERO(dist)) dist->exp = 0;
		}
		if (limit > 0 && k == 0) bcd_clr(d1);
	}
#endif

#if	BCD_EVALUATION == 1
	else
#endif

#if BCD_COMPACT_EXE == 0 || BCD_EVALUATION == 1
	{
		//ʏ퐸xA
		d2->exp = d1->exp;
		dd = dist->dat;
		nj = BCD_DAT_BITF;
		bcd_addsi(&w[2], d2, d2, nbot2, nbot2);
		bcd_addsi(&w[3], &w[2], d2, nbot2, nbot2);
		bcd_addsi(&w[4], &w[3], d2, nbot2, nbot2);
		bcd_addsi(&w[5], &w[4], d2, nbot2, nbot2);
		bcd_addsi(&w[6], &w[5], d2, nbot2, nbot2);
		bcd_addsi(&w[7], &w[6], d2, nbot2, nbot2);
		bcd_addsi(&w[8], &w[7], d2, nbot2, nbot2);
		bcd_addsi(&w[9], &w[8], d2, nbot2, nbot2);
		if ((k = bcd_cmpflt(d1, d2, 0, nbot2)) < 0) {
			bcd_shiftu(d1);
			if (limit) ddmax--;
			BCD_ADD_EXP(dist, -1);
			BCD_ADD_EXP(d2, -1);
			BCD_ADD_EXP(&w[2], -1);
			BCD_ADD_EXP(&w[3], -1);
			BCD_ADD_EXP(&w[4], -1);
			BCD_ADD_EXP(&w[5], -1);
			BCD_ADD_EXP(&w[6], -1);
			BCD_ADD_EXP(&w[7], -1);
			BCD_ADD_EXP(&w[8], -1);
			BCD_ADD_EXP(&w[9], -1);
		}
		for (j = 1; j < ddmax; j++) {
			k = bcd_cmpflt(d1, &w[4], 0, nbot2);
			if      (k == 0) { *dd |= 4 << nj; break; }
			else if (k  < 0) {
				k = bcd_cmpflt(d1, &w[2], 0, nbot2);
				if (k == 0) { *dd |= 2 << nj; break; }
				else if (k < 0) {
					k = bcd_cmpflt(d1, d2, 0, nbot2);
					if      (k == 0) { *dd |= 1 << nj; break; }
					else if (k  > 0) { *dd |= 1 << nj; bcd_subsi(d1, d1, d2, nbot2, nbot2); }
				}
				else {
					k = bcd_cmpflt(d1, &w[3], 0, nbot2);
					if (k == 0)     { *dd |= 3 << nj; break; }
					else if (k > 0) { *dd |= 3 << nj; bcd_subsi(d1, d1, &w[3], nbot2, nbot2); }
					else			{ *dd |= 2 << nj; bcd_subsi(d1, d1, &w[2], nbot2, nbot2);	}
				}
			}
			else {
				k = bcd_cmpflt(d1, &w[8], 0, nbot2);
				if (k == 0) { *dd |= 8 << nj; break; }
				else if (k < 0) {
					k = bcd_cmpflt(d1, &w[6], 0, nbot2);
					if (k == 0) { *dd |= 6 << nj; break; }
					else if (k < 0) {
						k = bcd_cmpflt(d1, &w[5], 0, nbot2);
						if      (k == 0) { *dd |= 5 << nj; break; }
						else if (k  > 0) { *dd |= 5 << nj; bcd_subsi(d1, d1, &w[5], nbot2, nbot2); }
						else             { *dd |= 4 << nj; bcd_subsi(d1, d1, &w[4], nbot2, nbot2); }
					}
					else {
						k = bcd_cmpflt(d1, &w[7], 0, nbot2);
						if      (k == 0) { *dd |= 7 << nj; break; }
						else if (k  > 0) { *dd |= 7 << nj; bcd_subsi(d1, d1, &w[7], nbot2, nbot2); }
						else             { *dd |= 6 << nj; bcd_subsi(d1, d1, &w[6], nbot2, nbot2); }
					}
				}
				else {
					k = bcd_cmpflt(d1, &w[9], 0, nbot2);
					if      (k == 0) { *dd |= 9 << nj; break; }
					else if (k  > 0) { *dd |= 9 << nj; bcd_subsi(d1, d1, &w[9], nbot2, nbot2); }
					else             { *dd |= 8 << nj; bcd_subsi(d1, d1, &w[8], nbot2, nbot2); }
				}
			}

			BCD_ADD_EXP(d2, -1);
			BCD_ADD_EXP(&w[2], -1);
			BCD_ADD_EXP(&w[3], -1);
			BCD_ADD_EXP(&w[4], -1);
			BCD_ADD_EXP(&w[5], -1);
			BCD_ADD_EXP(&w[6], -1);
			BCD_ADD_EXP(&w[7], -1);
			BCD_ADD_EXP(&w[8], -1);
			BCD_ADD_EXP(&w[9], -1);
			BCD_IDX_DW(nj, dd);
		}
		if (BCD_DET_ZERO(dist)) dist->exp = 0;
		if (limit > 0 && k == 0) bcd_clr(d1);
	}
#endif
	return BCD_OK;


#if	BCD_EVALUATION == 1
	//]pxZ
HIGH_PDEV:
	if (compact_flag) {
		//xARpNg
		d2->exp = d1->exp;
		dd = dist->dat;
		nj = BCD_DAT_BITF;
		if ((k = bcd_cmpflt(d1, d2, 0, nbot2)) < 0) {
			bcd_shiftu(d1);
			BCD_ADD_EXP(d2, -1);
			BCD_ADD_EXP(dist, -1);
		}
		for (j = 1; j < ddmax; j++) {
			m = 0;
			while ((k = bcd_cmpflt(d1, d2, 0, nbot2)) > 0) {
				bcd_subsi(d1, d1, d2, nbot2, nbot2);
				m++;
				if (m == 9) break;
			}
			if (k == 0) {
				*dd |= (m + 1) << nj;
				break;
			}
			else *dd |= m << nj;	//[肹ɏ񂾕g[^xオ͂B
			bcd_dropup(d1);
			BCD_ADD_EXP(d2, -1);
			BCD_IDX_DW(nj, dd);
		}
		if (BCD_DET_ZERO(dist)) dist->exp = 0;
		if (limit > 0 && k == 0) bcd_clr(d1);
	}
	else {
		//xA
		d2->exp = d1->exp;
		dd = dist->dat;
		nj = BCD_DAT_BITF;
		bcd_addsi(&w[2], d2, d2, nbot2, nbot2);
		bcd_addsi(&w[3], &w[2], d2, nbot2, nbot2);
		bcd_addsi(&w[4], &w[3], d2, nbot2, nbot2);
		bcd_addsi(&w[5], &w[4], d2, nbot2, nbot2);
		bcd_addsi(&w[6], &w[5], d2, nbot2, nbot2);
		bcd_addsi(&w[7], &w[6], d2, nbot2, nbot2);
		bcd_addsi(&w[8], &w[7], d2, nbot2, nbot2);
		bcd_addsi(&w[9], &w[8], d2, nbot2, nbot2);
		if ((k = bcd_cmpflt(d1, d2, 0, nbot2)) < 0) {
			bcd_shiftu(d1);
			BCD_ADD_EXP(dist, -1);
			BCD_ADD_EXP(d2, -1);
			BCD_ADD_EXP(&w[2], -1);
			BCD_ADD_EXP(&w[3], -1);
			BCD_ADD_EXP(&w[4], -1);
			BCD_ADD_EXP(&w[5], -1);
			BCD_ADD_EXP(&w[6], -1);
			BCD_ADD_EXP(&w[7], -1);
			BCD_ADD_EXP(&w[8], -1);
			BCD_ADD_EXP(&w[9], -1);
		}
		for (j = 1; j < ddmax; j++) {
			k = bcd_cmpflt(d1, &w[4], 0, nbot2);
			if (k == 0) { *dd |= 4 << nj; break; }
			else if (k < 0) {
				k = bcd_cmpflt(d1, &w[2], 0, nbot2);
				if (k == 0) { *dd |= 2 << nj; break; }
				else if (k < 0) {
					k = bcd_cmpflt(d1, d2, 0, nbot2);
					if (k == 0) { *dd |= 1 << nj; break; }
					else if (k > 0) { *dd |= 1 << nj; bcd_subsi(d1, d1, d2, nbot2, nbot2); }
				}
				else {
					k = bcd_cmpflt(d1, &w[3], 0, nbot2);
					if (k == 0) { *dd |= 3 << nj; break; }
					else if (k > 0) { *dd |= 3 << nj; bcd_subsi(d1, d1, &w[3], nbot2, nbot2); }
					else { *dd |= 2 << nj; bcd_subsi(d1, d1, &w[2], nbot2, nbot2); }
				}
			}
			else {
				k = bcd_cmpflt(d1, &w[8], 0, nbot2);
				if (k == 0) { *dd |= 8 << nj; break; }
				else if (k < 0) {
					k = bcd_cmpflt(d1, &w[6], 0, nbot2);
					if (k == 0) { *dd |= 6 << nj; break; }
					else if (k < 0) {
						k = bcd_cmpflt(d1, &w[5], 0, nbot2);
						if (k == 0) { *dd |= 5 << nj; break; }
						else if (k > 0) { *dd |= 5 << nj; bcd_subsi(d1, d1, &w[5], nbot2, nbot2); }
						else { *dd |= 4 << nj; bcd_subsi(d1, d1, &w[4], nbot2, nbot2); }
					}
					else {
						k = bcd_cmpflt(d1, &w[7], 0, nbot2);
						if (k == 0) { *dd |= 7 << nj; break; }
						else if (k > 0) { *dd |= 7 << nj; bcd_subsi(d1, d1, &w[7], nbot2, nbot2); }
						else { *dd |= 6 << nj; bcd_subsi(d1, d1, &w[6], nbot2, nbot2); }
					}
				}
				else {
					k = bcd_cmpflt(d1, &w[9], 0, nbot2);
					if (k == 0) { *dd |= 9 << nj; break; }
					else if (k > 0) { *dd |= 9 << nj; bcd_subsi(d1, d1, &w[9], nbot2, nbot2); }
					else { *dd |= 8 << nj; bcd_subsi(d1, d1, &w[8], nbot2, nbot2); }
				}
			}

			bcd_dropup(d1);
			BCD_ADD_EXP(d2, -1);
			BCD_ADD_EXP(&w[2], -1);
			BCD_ADD_EXP(&w[3], -1);
			BCD_ADD_EXP(&w[4], -1);
			BCD_ADD_EXP(&w[5], -1);
			BCD_ADD_EXP(&w[6], -1);
			BCD_ADD_EXP(&w[7], -1);
			BCD_ADD_EXP(&w[8], -1);
			BCD_ADD_EXP(&w[9], -1);
			BCD_IDX_DW(nj, dd);
		}
		if (BCD_DET_ZERO(dist)) dist->exp = 0;
		if (limit > 0 && k == 0) bcd_clr(d1);
	}

	return BCD_OK;
#endif
}

// ===============================================
// @Z@
// ===============================================
int bcd_din(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2) {
	return bcd_dim(dist, w0, src1, src2);
}

// ===============================================
// @̏Ə]@
// ===============================================
int bcd_dim(BCD_REG* dist1, BCD_REG* dist2, BCD_REG* src1, BCD_REG* src2) {
	int i, j, isub, p2exp_hold, nbot2;
	BCD_REG	*p1, *p2;

	// G[l̉Z`FbN
	if (bcd_err_chk2d(dist1, dist2, src1, src2)) return BCD_NG;

	// [ZG[Ȃ
	if (BCD_DET_ZERO(src2) || dist1 == dist2) {
		BCD_SET_ERROR(dist1);
		BCD_SET_ERROR(dist2);
		return BCD_NG;
	}

	// src1[邢͏ƖȂvZȗ
	if (BCD_DET_ZERO(src1)) {
		bcd_clr(dist1);
		bcd_clr(dist2);
		return BCD_OK;
	}
	i = BCD_GET_EXP(src1);
	j = BCD_GET_EXP(src2);
	if (i < j) {
		if (dist2 != src1) bcd_cpy(dist2, src1);
		return bcd_clr(dist1);
	}

	isub = i - j;
	//I[o[t[`FbN(ꎟ)
	if (isub > (nBCD_EXPLIM + 1)) {					//Ŏ܂\邽+1Ŕ
		BCD_SET_OVER(dist1);
		BCD_SET_OVER(dist2);
		return BCD_NG;
	}
	//A_[t[(i < j̏ň邽)

	//[N|C^ݒ
	if (dist1 == src2 || dist2 == src2) {
		p2 = w1;
		bcd_cpy(p2, src2);
		p2exp_hold = BCD_EXP_INVALID;	//src2distł邽ߕێ̕Kv͂Ȃ
	}
	else {
		p2 = src2;
		p2exp_hold = p2->exp;			//src2expj󂳂̂ŕێB
	}

	p1 = src1;
	if (dist2 != src1 || dist1 == src1) {
		bcd_cpy(dist2, src1);
		p1 = dist2;
	}

	bcd_clr(dist1);
	BCD_SET_EXSG(dist1, isub, BCD_GET_SGN(p1) ^ BCD_GET_SGN(p2));
	nbot2 = bcd_nbot(p2);
	bcd_divsi(dist1, dist2, p2, nbot2, isub + 2);

	//
	if (p2exp_hold != BCD_EXP_INVALID) {
		src2->exp = p2exp_hold;
	}

	//dist1Ȃꍇ̃I[o[t[`FbN
	isub = BCD_GET_EXP(dist1);
	if (isub > nBCD_EXPLIM) {
		BCD_SET_OVER(dist1);
		BCD_SET_OVER(dist2);
		return BCD_NG;
	}
	//dist1ɂA_[t[`FbN
	if (isub < -nBCD_EXPLIM) {
		bcd_clr(dist1);
	}

	//dist2
	return bcd_dropup(dist2);
}

// ===============================================
// @]@
// ===============================================
int bcd_mod(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2) {
	return bcd_dim(w0, dist, src1, src2);
}

// ===============================================
// @召r@@(߂ĺA0:src1==src2, 1:src1>src2, -1:srtc1<src2)
// ===============================================
int bcd_cmp(BCD_REG* src1, BCD_REG* src2) {
	int s1, s2;
	if (src1 == NULL || src2 == NULL) return BCD_INT_ERROR;
	s1 = BCD_GET_SGN(src1);
	s2 = BCD_GET_SGN(src2);
	if (s1 ^ s2) {
		if (s1) return -1;
		else    return  1;
	}
	s2 = bcd_cmpabs(src1, src2);
	if (s1)		return -s2;
	return s2;
}

// ===============================================
// @dist = abs(src)@   
// ===============================================
int bcd_abs(BCD_REG* dist, BCD_REG* src) {
	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (dist != src) bcd_cpy(dist, src);
	BCD_SET_POSI(dist);
	return BCD_OK;
}

// ===============================================
// @dist = -src@
// ===============================================
int bcd_inv(BCD_REG* dist, BCD_REG* src) {
	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (dist != src) bcd_cpy(dist, src);
	if (BCD_DET_ZERO(dist)) return BCD_OK;
	BCD_SET_SINV(dist);
	return BCD_OK;
}

// ===============================================
// @dist = src̐@
// ===============================================
int bcd_IP(BCD_REG* dist, BCD_REG* src) {
	int i, j, ni, nj;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	i = BCD_GET_EXP(src);
	if (i < 0) {
		ni = 0;
		nj = nBCD_ABIT;
	}
	else {
		i += 2;						//擪ʒu
		ni = i / nBCD_DNUM;								//pt-shift
		nj = nBCD_ABIT - (i % nBCD_DNUM) * nBCD_DBIT;	//pt-shift
		if (ni >= nBCD_NMAX) {		//̏ꍇ͏ŏIʒuɂȂȂ
			ni = nBCD_NMAX - 1;
			nj = 0;					// }XN
		}
	}
	i = (~0) << nj;

	if (dist != src) {
		dist->exp = src->exp;
		for (j = 0; j <= ni; j++) dist->dat[j] = src->dat[j];
	}
	dist->dat[ni++] &= i;
	while (ni < nBCD_NMAX) {
		dist->dat[ni++] = 0;
	}
	return BCD_OK;
}

// ===============================================
// @dist = src̏@ (b)
// ===============================================
int bcd_FP(BCD_REG* dist, BCD_REG* src) {
	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (bcd_IP(w0, src)) return BCD_NG;
	return bcd_sub(dist, src, w0);
}

// ===============================================
// @dist = src̎w(w\L̒l)@
// ===============================================
int bcd_EP(BCD_REG* dist, BCD_REG* src) {
	int i;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	i = BCD_GET_EXP(src);
	return bcd_ito(dist, i, 0);
}

// ===============================================
// @dist = srcۂ߂l(n=1Ȃ珬_ȉ2ڂľܓ)@
// ===============================================
int bcd_round(BCD_REG* dist, BCD_REG* src, int n) {
	int i, j, nj;
	unsigned int *dd, *ds, carry;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;
	if (BCD_DET_ZERO(src)) {
		if (dist != src) return bcd_clr(dist);
		return BCD_OK;
	}

	n++;
	i = BCD_GET_EXP(src) + n;
	if (i >= nBCD_DMAX) {
		if (dist != src) bcd_cpy(dist, src);
		return BCD_OK;
	}
	if (i < 0 || i == 0 && src->dat[0] < (5 << BCD_DAT_BITF)) return bcd_clr(dist);

	// ľܓ
	i++;
	ds = src->dat + i / nBCD_DNUM;						//ptc
	nj = BCD_DAT_BITT - (i % nBCD_DNUM) * nBCD_DBIT;	//ptc
	if (((*ds >> nj) & 0x0f) >= 5)	carry = 1;
	else							carry = 0;

	i--;
	j = i / nBCD_DNUM;
	dd = dist->dat + nBCD_NMAX - 1;
	while (dd > dist->dat + j) *dd-- = 0;
	ds = src->dat + j;
	nj = BCD_DAT_BITT - (i % nBCD_DNUM) * nBCD_DBIT;	//ptc
	j = (~0) << nj;
	*dd = *ds-- & j;
	*dd += carry << nj;
	*dd += BCD_SUP_MASK + BCD_CRY_MASK;
	carry = (*dd & BCD_CRY_MASK) >> 2;
	carry += carry >> 1;
	*dd -= carry;
	carry = *dd >> BCD_CYU_BIT;
	*dd-- &= BCD_DAT_MASK;
	while (carry && dd >= dist->dat) {
		*dd = *ds-- + BCD_SUP_MASK + BCD_CRY_MASK + carry;
		carry = (*dd & BCD_CRY_MASK) >> 2;
		carry += carry >> 1;
		*dd -= carry;
		carry = *dd >> BCD_CYU_BIT;
		*dd-- &= BCD_DAT_MASK;
	}
	if (dist != src) {
		while (dd >= dist->dat) *dd-- = *ds--;
		dist->exp = src->exp;
	}
	return bcd_shiftd(dist, nBCD_NMAX - 1);
}

// ===============================================
// @num*10^nBCDϐɊi[@
// ===============================================
int bcd_ito(BCD_REG* dist, int num, int n) {
	// G[l̉Z`FbN
	if (bcd_err_chk0(dist)) return BCD_NG;

	bcd_clr(dist);
	if (num == 0 || n < -nBCD_EXPLIM) return BCD_OK;
	return bcd_itosi(dist, num, n);
}

static BCD_REG* bcd_itowi(int idx, int num, int n) {		// {֐̌ʂNULL̏ꍇ̓G[u邱ƁB
	BCD_REG* dist;

	if (idx < 0 || idx > nBCD_WINDEX) return NULL;
	dist = (BCD_REG*)wi[idx];
	dist->exp = 0;
	dist->dat[0] = 0;
	dist->dat[1] = 0;
	dist->dat[2] = 0;
	if (num == 0 || n < -nBCD_EXPLIM) return dist;

	if (bcd_itosi(dist, num, n)) {
		BCD_SET_ERROR(dist);
		return NULL;
	}
	return dist;
}

static int bcd_itosi(BCD_REG* dist, int num, int n) {
	int nj, j;
	unsigned int *dw;

	if (dist == NULL || num == BCD_INT_ERROR || n > nBCD_EXPLIM) return BCD_NG;

	if (num < 0) {
		BCD_SET_NEGA(dist);
		num = -num;
	}

	if (num < 10) j = 0;
	else if (num < 100) j = 1;
	else if (num < 1000) j = 2;
	else if (num < 10000) j = 3;
	else if (num < 100000) j = 4;
	else if (num < 1000000) j = 5;
	else if (num < 10000000) j = 6;
	else if (num < 100000000) j = 7;
	else if (num < 1000000000) j = 8;
	else j = 9;
	n += j;
	if (n > nBCD_EXPLIM) return BCD_NG;
	BCD_SET_EXP(dist, n);
	j++;												//擪ʒu+1
	dw = dist->dat + j / nBCD_DNUM;						//ptc
	nj = BCD_DAT_BITT - (j % nBCD_DNUM) * nBCD_DBIT;	//ptc
	while (num > 0) {
		*dw |= (num % 10) << nj;
		num /= 10;
		BCD_IDX_UP(nj, dw);
	}

	return BCD_OK;
}

// ===============================================
// @BCDϐ̐intl֕ϊĖ߂@
// ===============================================
int bcd_toi(BCD_REG* src) {
	int i, nj;
	unsigned int *dw, m;

	// G[l̉Z`FbN
	if (bcd_err_chks(src)) return BCD_NG;

	i = BCD_GET_EXP(src);
	if (i >= nBCD_INT_LIMDIG) return BCD_INT_ERROR;
	if (i < 0) return 0;

	dw = src->dat;
	m = (*dw >> BCD_DAT_BITF) & 0x0f;
	if (i == nBCD_INT_LIMDIG - 1 && m > 2) return BCD_INT_ERROR;

	nj = BCD_DAT_BITS;
	while (i > 0) {
		m *= 10;
		m += (*dw >> nj) & 0x0f;
		BCD_IDX_DW(nj, dw);
		i--;
	}
	if (m > nBCD_INT_LIM) return BCD_INT_ERROR;
	i = m;
	if (BCD_GET_SGN(src)) i = -i;
	return i;
}

// ===============================================
// @dist = src + num*10^n@
// ===============================================
int bcd_addi(BCD_REG* dist, BCD_REG* src1, int num, int n) {
	int i, j, nbot2;
	BCD_REG *src2;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src1)) return BCD_NG;

	if ((src2 = bcd_itowi(0, num, n)) == NULL) return BCD_NG;
	nbot2 = 1;
	if (src2->dat[1]) nbot2 = 2;

	i = nBCD_DMAX - 1;
	j = BCD_GET_EXP(src2) - BCD_GET_EXP(src1);
	// Е[܂̓[ƓȂvZȗ
	if (BCD_DET_ZERO(src1) || j > i) {
		dist->exp = src2->exp;
		dist->dat[0] = src2->dat[0];
		dist->dat[1] = src2->dat[1];
		for (i = 2; i < nBCD_NMAX; i++) dist->dat[i] = 0;
		return BCD_OK;
	}
	else if (num == 0 || -j > i) {
		if (dist != src1) bcd_cpy(dist, src1);
		return BCD_OK;
	}

	// `FbN
	if (BCD_GET_SGN(src1) ^ BCD_GET_SGN(src2)) {
		//Z
		i = bcd_cmpiabs(src1, src2);
		if (i == 0) 		return bcd_clr(dist);
		else if (i > 0) 	bcd_subsi(dist, src1, src2, nbot2, nbot2);
		else				bcd_subsi(dist, src2, src1, nbot2, nBCD_NMAX - 1);
		//
		return bcd_dropup(dist);
	}

	//Zьオ菈
	if (j > 0)	bcd_addsi(dist, src2, src1, nbot2, nBCD_NMAX - 1);
	else		bcd_addsi(dist, src1, src2, nbot2, nbot2);
	return bcd_shiftd(dist, nBCD_NMAX - 1);
}

// ===============================================
// @dist = num*10^n - src@
// ===============================================
int bcd_isub(BCD_REG* dist, int num, int n, BCD_REG* src2) {
	int i, j, nbot1;
	BCD_REG *src1;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src2)) return BCD_NG;

	if ((src1 = bcd_itowi(0, num, n)) == NULL) return BCD_NG;
	nbot1 = 1;
	if (src1->dat[1]) nbot1 = 2;

	i = nBCD_DMAX - 1;
	j = (BCD_GET_EXP(src2) - BCD_GET_EXP(src1));
	// Е[܂̓[ƓȂvZȗ
	if (num == 0 || j > i) {
		bcd_cpy(dist, src2);
		BCD_SET_SINV(dist);
		return BCD_OK;
	}
	else if (BCD_DET_ZERO(src2) || -j > i) {
		dist->exp = src1->exp;
		dist->dat[0] = src1->dat[0];
		dist->dat[1] = src1->dat[1];
		for (i = 2; i < nBCD_NMAX; i++) dist->dat[i] = 0;
		//͂̂܂
		return BCD_OK;
	}

	// `FbN
	if (BCD_GET_SGN(src1) ^ BCD_GET_SGN(src2)) {
		//Zƌオ菈
		if (j > 0 /*BCD_GET_EXP(src1) < BCD_GET_EXP(dsrc)*/) {
			bcd_addsi(dist, src2, src1, nbot1, nbot1);
			BCD_SET_SINV(dist);
		}
		else {
			bcd_addsi(dist, src1, src2, nbot1, nBCD_NMAX - 1);
		}
		return bcd_shiftd(dist, nBCD_NMAX - 1);
	}

	//Zƌ
	i = bcd_cmpiabs(src2, src1);			// bcd_cmpiabs()͑QV[g^(^`FbN͖)
	if (i == 0)	return bcd_clr(dist);
	else if (i < 0) {
		bcd_subsi(dist, src1, src2, nbot1, nBCD_NMAX - 1);
	}
	else {
		bcd_subsi(dist, src2, src1, nbot1, nbot1);
		BCD_SET_SINV(dist);
	}
	return bcd_dropup(dist);
}

// ===============================================
// @dist = src * num*10^n@
// ===============================================
int bcd_muli(BCD_REG* dist, BCD_REG* src, int num, int n) {
	int j, k, iadd, exp_hold, nbot1, nbot2;
	BCD_REG *d1, *d2;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	// Е[ȂvZȗ
	if (BCD_DET_ZERO(src) || num == 0) return bcd_clr(dist);

	if ((d2 = bcd_itowi(0, num, n)) == NULL) return BCD_NG;

	//I[o[t[`FbN(ꎟ)
	iadd = BCD_GET_EXP(src) + BCD_GET_EXP(d2);
	if (iadd > nBCD_EXPLIM) {
		BCD_SET_OVER(dist);
		return BCD_NG;
	}
	//A_[t[`FbN(ꎟ)
	if (iadd < -(nBCD_EXPLIM + 1)) return bcd_clr(dist);

	//L`FbNA[N|C^ݒexpۑ
	nbot1 = bcd_nbot(src);
	nbot2 = 0;
	if (d2->dat[1]) nbot2 = 1;

	d1 = src;
	if (dist == d1) {
		bcd_cpy(w0, d1);
		d1 = w0;
		exp_hold = BCD_EXP_INVALID;		//d1͂Ԃ̂ŕێsvBȂ̂expیKvȂ
	}
	else {
		exp_hold = d1->exp;				//d1expj󂷂̂ŁAی삵Čŕ
	}

	BCD_SET_EXSG(d1, iadd, BCD_GET_SGN(d1) ^ BCD_GET_SGN(d2));
	bcd_mulsi(dist, d1, d2, nbot1, nbot2);

	//
	if (exp_hold != BCD_EXP_INVALID) {
		d1->exp = exp_hold;
	}

	//菈
	j = bcd_shiftd(dist, nBCD_NMAX - 1);
	k = BCD_GET_EXP(dist);

	//I[o[t[`FbN(ŏI)
	if (j || k > nBCD_EXPLIM) {
		BCD_SET_OVER(dist);
		return BCD_NG;
	}
	//A_[t[`FbN(ŏI)
	if (k < -nBCD_EXPLIM) {
		bcd_clr(dist);
	}

	return BCD_OK;
}
// ===============================================
// @dist = src / num*10^n@
// ===============================================
int bcd_divi(BCD_REG* dist, BCD_REG* src, int num, int n) {
	int isub, nbot2;
	BCD_REG	*d1, *d2;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	// Е[ȂvZȗ
	if (BCD_DET_ZERO(src)) return bcd_clr(dist);
	if (num == 0) {
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}

	if ((d2 = bcd_itowi(0, num, n)) == NULL) return BCD_NG;

	//I[o[t[`FbN(ꎟ)
	isub = BCD_GET_EXP(src) - BCD_GET_EXP(d2);
	if (isub > (nBCD_EXPLIM + 1)) {					//Ŏ܂\邽+1Ŕ
		BCD_SET_OVER(dist);
		return BCD_NG;
	}
	//A_[t[`FbN(ꎟ)
	if (isub < -nBCD_EXPLIM) return bcd_clr(dist);

	//[N|C^ݒ ({łłsrc͕Kcp[NɃRs[)
	d1 = w0;
	bcd_cpy(d1, src);
	bcd_clr(dist);

	BCD_SET_EXSG(dist, isub, BCD_GET_SGN(d1) ^ BCD_GET_SGN(d2));
	nbot2 = 1;
	if (d2->dat[1]) nbot2 = 2;
	bcd_divsi(dist, d1, d2, nbot2, 0);

	//I[o[t[`FbN(ŏI)
	isub = BCD_GET_EXP(dist);
	if (isub > nBCD_EXPLIM) {
		BCD_SET_OVER(dist);
		return BCD_NG;
	}
	//A_[t[`FbN(ŏI)
	if (isub < -nBCD_EXPLIM) {
		bcd_clr(dist);
		return BCD_OK;
	}

	return BCD_OK;	//devsiŌ΍􂵂Ă̂bcd_dropup̌ďo͕sv
}

// ===============================================
// @dist = src \ num*10^n@
// ===============================================
int bcd_dini(BCD_REG* dist, BCD_REG* src, int num, int n) {
	return bcd_dimi(dist, w0, src, num, n);
}

// ===============================================
// @dist = src \ num*10^n, dist = src % num*10^n@
// ===============================================
int bcd_dimi(BCD_REG* dist1, BCD_REG* dist2, BCD_REG* src1, int num, int n) {
	int i, j, isub, nbot2;
	BCD_REG	*d1, *d2;

	// G[l̉Z`FbN
	if (bcd_err_chk1d(dist1, dist2, src1)) return BCD_NG;

	// [ZȂǂ̃G[
	if (num == 0 || dist1 == dist2) {
		BCD_SET_ERROR(dist1);
		BCD_SET_ERROR(dist2);
		return BCD_NG;
	}

	if ((d2 = bcd_itowi(0, num, n)) == NULL) return BCD_NG;

	// src1[邢͌ʂƖȂvZȗ
	if (BCD_DET_ZERO(src1)) {
		bcd_clr(dist1);
		bcd_clr(dist2);
		return BCD_OK;
	}
	i = BCD_GET_EXP(src1);
	j = BCD_GET_EXP(d2);
	if (i < j) {
		if (dist2 != src1) bcd_cpy(dist2, src1);
		return bcd_clr(dist1);
	}

	isub = i - j;
	//I[o[t[`FbN(ꎟ)
	if (isub > (nBCD_EXPLIM + 1)) {					//Ŏ܂\邽+1Ŕ
		BCD_SET_OVER(dist1);
		BCD_SET_OVER(dist2);
		return BCD_NG;
	}
	//A_[t[(i < j̏ň邽)

	//src1Rs[
	d1 = src1;
	if (dist2 != src1 || dist1 == src1) {
		bcd_cpy(dist2, src1);
		d1 = dist2;
	}

	bcd_clr(dist1);
	BCD_SET_EXSG(dist1, isub, BCD_GET_SGN(d1) ^ BCD_GET_SGN(d2));
	nbot2 = 1;
	if (d2->dat[1]) nbot2 = 2;
	bcd_divsi(dist1, dist2, d2, nbot2, isub + 2);

	//dist1Ȃꍇ̃I[o[t[`FbN
	isub = BCD_GET_EXP(dist1);
	if (isub > nBCD_EXPLIM) {
		BCD_SET_OVER(dist1);
		BCD_SET_OVER(dist2);
		return BCD_NG;
	}
	//dist1ɂA_[t[`FbN
	if (isub < -nBCD_EXPLIM) {
		bcd_clr(dist1);
	}

	//dist2
	return bcd_dropup(dist2);
}

// ===============================================
// @dist = src % num*10^n@
// ===============================================
int bcd_modi(BCD_REG* dist, BCD_REG* src, int num, int n) {
	return bcd_dimi(w0, dist, src, num, n);
}

// ===============================================
// @srcnum*10^nƂ̑召r@
// ===============================================
int bcd_cmpi(BCD_REG* src, int num, int n) {
	int s1, s2;
	BCD_REG *d2;

	if (src == NULL) return BCD_INT_ERROR;
	s1 = BCD_GET_SGN(src);
	if ((d2 = bcd_itowi(0, num, n)) == NULL) return BCD_NG;
	s2 = BCD_GET_SGN(d2);
	if (s1 ^ s2) {
		if (s1) return -1;
		else    return  1;
	}
	s2 = bcd_cmpiabs(src, d2);
	if (s1)		return -s2;
	return s2;
}

// ===============================================
// @K@
// ===============================================
int bcd_facti(BCD_REG* dist, int num) {

	// G[l̉Z`FbN
	if (bcd_err_chk0(dist)) return BCD_NG;
	if (num < 0) {
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}

	bcd_ito(dist, 1, 0);
	if (num < 2) return BCD_OK;
	while (num > 1) {
		if (bcd_muli(dist, dist, num, 0)) return BCD_NG;
		num--;
	}
	return BCD_OK;
}


#ifndef BCD_BASIC_FUNC
// =============================================================================
// =============================================================================
// ֐ȂǊ{I֐ȊO
// =============================================================================
// =============================================================================
// ===============================================
// @dist = (src)@
// ===============================================
int bcd_sqrt(BCD_REG* dist, BCD_REG* src) {
	int i, j, k, nj;
	int mbot_base, nbot_base;
	int hold_exp;
	unsigned int *dd, *dmax;
	BCD_REG	*wk_base, *wk_zan;
	BCD_REG	*wk_1, *wk_2;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;
	if (BCD_GET_SGN(src) == 1) {
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}
	if (BCD_DET_ZERO(src)) {
		if (dist != src) return bcd_clr(dist);
		return BCD_OK;
	}

	bcd_cmpflt_init();

	wk_base = w0;
	bcd_clear(wk_base);
	mbot_base = nbot_base = 1;

	wk_zan = w2;						//F{+1ŉZ
	hold_exp = BCD_GET_EXP(src);
	if (hold_exp & 1)	bcd_cpyu(wk_zan, src);
	else				bcd_cpy(wk_zan, src);
	dmax = dd = wk_zan->dat + nBCD_NMAX;
	dmax += nBCD_NMAX + 1;
	while (dd < dmax) *dd++ = 0;

	bcd_clear(dist);					//dist == src̏ꍇ̂srcRs[ɃNA
	dd = dist->dat;
	nj = BCD_DAT_BITF;

	hold_exp >>= 1;
	wk_zan->exp = 0;
	if ((wk_1 = bcd_itowi(0, 1, 0)) == NULL) return BCD_NG;
	if ((wk_2 = bcd_itowi(1, 2, 0)) == NULL) return BCD_NG;

	for (i = 1; i < nBCD_DMAX; i++) {
		bcd_addsi(wk_base, wk_base, wk_1, nBCD_NMAX - 1, 1);

		for (j = 0; j < 9; j++) {
			k = bcd_cmpflt(wk_zan, wk_base, -1, nbot_base);
			if (k < 0) {
				*dd |= j << nj;
				bcd_subsi(wk_base, wk_base, wk_1, nBCD_NMAX - 1, 1);
				break;
			}
			else if (k == 0) {
				*dd |= (j + 1) << nj;
				break;
			}
			else {
				bcd_subsi(wk_zan, wk_zan, wk_base, -1, nbot_base);
				if (j == 8) {
					*dd |= 9 << nj;
					bcd_addsi(wk_base, wk_base, wk_1, nBCD_NMAX - 1, 1);
					break;
				}
			}
			bcd_addsi(wk_base, wk_base, wk_2, nBCD_NMAX - 1, 1);
		}
		if (k == 0) break;

		//wVtg
		BCD_ADD_EXP(wk_zan, 2);
		BCD_ADD_EXP(wk_base, 1);
		if (++mbot_base == 6) { mbot_base = 0; if (nbot_base < nBCD_NMAX - 1) nbot_base++; }
		BCD_IDX_DW(nj, dd);
	}

	BCD_SET_EXP(dist, hold_exp);
	return BCD_OK;
}

static int bcd_cpyu(BCD_REG* dist, BCD_REG* src) {
	unsigned int *dd, *dw;

	// VtgRs[
	dd = dist->dat;
	dw = src->dat;
	while (dd < dist->dat + nBCD_NMAX - 1) {
		*dd = BCD_CYU_CLR(*dw++ << nBCD_DBIT);		//VtgAbv͕KJzL[NA
		*dd |= *dw >> (nBCD_ABIT - nBCD_DBIT);
		dd++;
	}
	*dd = BCD_CYU_CLR(*dw << nBCD_DBIT);

	return BCD_OK;
}

// ===============================================
// @dist = 3(src)@
// ===============================================
int bcd_curt(BCD_REG* dist, BCD_REG* src) {
	int i, j, k, nj;
	int mbot_base1, nbot_base1, mbot_base2, nbot_base2;
	int mbot_dist, nbot_dist;
	int hold_exp, sgn;
	unsigned int *dd, *dw, *dmax;
	BCD_REG	*wk_base1, *wk_base2, *wk_base3, *wk_zan;		//base1,3:1{Abase2:2{Azan:3{
	BCD_REG	*wk_1, *wk_6;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;
	if (BCD_DET_ZERO(src)) {
		if (dist != src) return bcd_clr(dist);
		return BCD_OK;
	}

	bcd_cmpflt_init();
	sgn = 0;
	if (BCD_GET_SGN(src)) sgn = 1;

	wk_base1 = w0;
	wk_base2 = w2;					//F{+1ŉZ
	wk_base3 = w4;
	wk_zan   = w6;					//F3{+2ŉZ
	bcd_cpy(wk_zan, src);
	dmax = dd = wk_zan->dat + nBCD_NMAX;
	dmax += nBCD_NMAX + nBCD_NMAX + 2;
	while (dd < dmax) *dd++ = 0;
	BCD_SET_POSI(wk_zan);

	hold_exp = BCD_GET_EXP(src);
	j = hold_exp % 3;
	hold_exp /= 3;
	if (j < 0) {
		j += 3;
		if (j > 0) hold_exp--;
	}
	BCD_SET_EXP(wk_zan, j);

	bcd_clear(dist);					//dist == src̏ꍇ̂srcRs[ɃNA
	dd = dist->dat;
	nj = BCD_DAT_BITF;

	mbot_base1 = 2;
	mbot_base2 = 3;
	mbot_dist  = 1;
	nbot_base1 = nbot_base2 = nbot_dist = 1;

	if ((wk_1 = bcd_itowi(0, 99, 0)) == NULL) return BCD_NG;
	if ((wk_6 = bcd_itowi(1, 6, 0)) == NULL) return BCD_NG;
	bcd_clear(wk_base1);
	bcd_ito(wk_base2, 1, 0);
	dmax = dw = wk_base2->dat + nBCD_NMAX;
	dmax += nBCD_NMAX + 1;
	while (dw < dmax) *dw++ = 0;

	for (i = 1; i < nBCD_DMAX; i++) {
		for (j = 0; j < 9; j++) {
			k = bcd_cmpflt(wk_zan, wk_base2, -2, nbot_base2);
			if (k < 0) {
				*dd |= j << nj;
				bcd_subsi(wk_base2, wk_base2, wk_base1, -1, nbot_base1);
				//bcd_dropup(wk_base2);	//ŏȂ{ɂKv͂Ȃ(vmF)B
				break;
			}
			else if (k == 0) {
				*dd |= (j + 1) << nj;
				break;
			}
			else {
				bcd_subsi(wk_zan, wk_zan, wk_base2, -2, nbot_base2);
				if (j == 8) {
					*dd |= 9 << nj;
					bcd_addsi(wk_base1, wk_base1, wk_6, nBCD_NMAX - 1, 1);
					break;
				}
			}
			bcd_addsi(wk_base1, wk_base1, wk_6, nBCD_NMAX - 1, 1);
			//bcd_shiftd(wk_base1);					//NG(ŏ̕wk_base2w傫Ȃĕss)
			bcd_addsi(wk_base2, wk_base2, wk_base1, -1, nbot_base1);
			bcd_shiftd(wk_base2, nbot_base2);
		}
		if (k == 0) break;

		//wVtg
		BCD_ADD_EXP(wk_zan, 3);
		BCD_ADD_EXP(dist, 1);
		if (++mbot_base1 == 6) { mbot_base1 = 0; if (nbot_base1 < nBCD_NMAX - 1) nbot_base1++; }
		if ((mbot_base2 += 2) >= 6) { mbot_base2 -= 6; if (nbot_base2 < nBCD_NMAX * 2) nbot_base2++; }
		if (++mbot_dist  == 6) { mbot_dist  = 0; if (nbot_dist  < nBCD_NMAX - 1) nbot_dist++;  }
		BCD_IDX_DW(nj, dd);
		bcd_shiftd(wk_base1, nbot_base1);
		bcd_addsi(wk_base3, wk_base1, wk_base1, nBCD_NMAX - 1, nbot_base1);
		bcd_addsi(wk_base3, wk_base3, wk_base3, nBCD_NMAX - 1, nbot_base1);
		bcd_addsi(wk_base3, wk_base3, wk_base1, nBCD_NMAX - 1, nbot_base1);		//base1*5
		bcd_cpyn(wk_base1, wk_base3, nbot_base1);
		BCD_ADD_EXP(wk_base3, 1);
		bcd_addsi(wk_base3, wk_base3, wk_base1, nBCD_NMAX - 1, nbot_base1);		//base1*55
		bcd_shiftd(wk_base3, nbot_base1);
		BCD_ADD_EXP(wk_base2, 2);
		bcd_addsi(wk_base2, wk_base2, wk_base3, -1, nbot_base1);
		bcd_subsi(wk_base2, wk_base2, wk_1, -1, 1);						//base2*100+base1*55-99
		bcd_shiftd(wk_base2, nbot_base2);
		bcd_shiftd(wk_base1, nbot_base1);
		bcd_addsi(wk_base1, wk_base1, wk_base1, nBCD_NMAX - 1, nbot_base1);		//base1*10
	}

	BCD_SET_EXP(dist, hold_exp);
	if (sgn) BCD_SET_NEGA(dist);
	return BCD_OK;
}

static int bcd_cpyn(BCD_REG* dist, BCD_REG* src, int nbot) {
	unsigned int *dd, *dw;

	dist->exp = src->exp;
	dd = dist->dat;
	dw = src->dat;
	while (dd <= dist->dat + nbot) *dd++ = *dw++;
	return BCD_OK;
}

// ===============================================
// @dist = src1^src2(ׂ)@
// ===============================================
int bcd_pow(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2) {			// w[10]--w[14]gp
	int i, sgn, idx, idt;
	BCD_REG *r0, *r1, *rd;

	// G[l̉Z`FbN
	if (bcd_err_chk2(dist, src1, src2)) return BCD_NG;
	if (BCD_GET_SGN(src1) || BCD_DET_ZERO(src1)) {
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}

	if (BCD_DET_ZERO(src2)) return bcd_ito(dist, 1, 0);

	r0 = w10;
	bcd_cpy(r0, src1);
	r1 = w14;
	bcd_cpy(r1, src2);
	rd = w13;

	sgn = 0;
	if (BCD_GET_SGN(r1)) {
		sgn = 1;								//ŌɋtƂ
		BCD_SET_POSI(r1);
	}

	i = BCD_GET_EXP(r1);
	if (i >= nBCD_DMAX - 1) {					//w傫ꍇ͐mȐZłȂ̂ŃG[Ƃ
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}

	idt = 0;
	while (bcd_cmpi(r1, 1073741824, 0) >= 0) {
		if (idt == 0x7fffffff) {					//{̌E͊ɂ邪AƂ肠int̍őlŔ肷B
			BCD_SET_OVER(dist);
			return BCD_NG;
		}
		idt++;
		bcd_addi(r1, r1, -1073741824, 0);
	}
	idx = bcd_toi(r1);
	bcd_addi(r1, r1, -idx, 0);						//

	bcd_ito(rd, 1, 0);								//
	i = 0;
	while (idx || idt && i < 30) {
		if (idx & 1) {
			if (bcd_mul(rd, rd, r0)) {
				BCD_SET_OVER(dist);
				return BCD_NG;
			}
		}
		idx >>= 1;
		if (idx || idt) {
			if (bcd_mul(r0, r0, r0)) {
				BCD_SET_OVER(dist);
				return BCD_NG;
			}
		}
		i++;
	}
	while (idt) {
		if (bcd_mul(rd, rd, r0)) {
			BCD_SET_OVER(dist);
			return BCD_NG;
		}
		idt--;
	}

	if (!BCD_DET_ZERO(r1)) {
		// exp(r1Eloge(src1))
		bcd_loge(dist, src1);
		bcd_mul(dist, r1, dist);
		bcd_exp(dist, dist);
		bcd_mul(dist, rd, dist);
	}
	else bcd_cpy(dist, rd);

	if (sgn) {
		bcd_ito(w12, 1, 0);
		bcd_div(dist, w12, dist);
	}

	return BCD_OK;
}

// ===============================================
// @萔Ǎ@
// ===============================================
int bcd_const_pi(BCD_REG* dist) {									// dist =       (~)
	if (dist == NULL) return BCD_NG;
	bcd_cpy(dist, (BCD_REG*)pi_const);
	return BCD_OK;
}

int bcd_const_e(BCD_REG* dist) {									// dist =       (lCsA)
	if (dist == NULL) return BCD_NG;
	bcd_cpy(dist, (BCD_REG*)nap_const);
	return BCD_OK;
}

int bcd_const_ln10(BCD_REG* dist) {									// dist = loge(10)
	if (dist == NULL) return BCD_NG;
	bcd_cpy(dist, (BCD_REG*)ln10_const);
	return BCD_OK;
}

// ===============================================
// @pxPʐݒ@
// ===============================================
int bcd_angle(int mode) {
	if (mode)	wmode = 1;
	else		wmode = 0;
	return BCD_OK;
}

// ===============================================
// @dist = sin(src)@
// ===============================================
int bcd_sin(BCD_REG* dist, BCD_REG* src) {
	int i, sgn;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (BCD_DET_ZERO(src)) return bcd_clr(dist);

	if (wmode)	bcd_const_pi(w10);					//w10:
	else		bcd_ito(w10, 180, 0);
	bcd_add(w11, w10, w10);							//w11:2
	bcd_mod(dist, src, w11);						//dist:2΂̎c]
	if (BCD_DET_ZERO(dist)) return BCD_OK;

	sgn = 0;
	if (BCD_GET_SGN(dist)) {						//Ȃ猋ʂ𕉂
		BCD_SET_POSI(dist);
		sgn = 1;
	}

	i = bcd_cmp(dist, w10);
	if (i == 0) return bcd_clr(dist);
	if (i > 0) {									//Έȏ̋Ԃ̓΂āAʂ̕𔽓]
		bcd_sub(dist, dist, w10);
		sgn ^= 1;
	}

	bcd_muli(w11, w10, 5, -1);						//w11:/2
	i = bcd_cmp(dist, w11);
	if (i == 0) bcd_ito(dist, 1, 0);
	else {
		if (i > 0) {								///2ȏ̋Ԃ̓-ƂŌvZ
			bcd_sub(dist, w10, dist);
			if (BCD_GET_SGN(dist)) bcd_clr(dist);	//ɂȂꍇ͌vZ덷Ƃ0ɂ
		}

		bcd_muli(w10, w11, 5, -1);					//w10:/4
		i = bcd_cmp(dist, w10);
		if (i == 0 && nBCD_EVA_LOOP == 0) {
			bcd_ito(dist, 5, -1);
			bcd_sqrt(dist, dist);
		}
		else {
			if (i > 0) {								///4ȏ̋Ԃcos(/2-)ŌvZ
				bcd_sub(dist, w11, dist);
				if (BCD_GET_SGN(dist)) bcd_clr(dist);	//ɂȂꍇ͌vZ덷Ƃ0ɂ
			}

			if (!wmode) {
				bcd_const_pi(w10);
				bcd_mul(w12, dist, w10);
				bcd_divi(dist, w12, 180, 0);
			}

			if (i > 0) {								///4ȏ̋Ԃcos(/2-)ŌvZ
				i = BCD_TBL_COS(nBCD_SIGNIF);
				bcd_cossi(dist, dist, i);
			}
			else {
				i = BCD_TBL_SIN(nBCD_SIGNIF);
				bcd_sinsi(dist, dist, i);
			}
		}
	}

#if 1
	i = bcd_cmpi(dist, 5, -(nBCD_SIGNIF + 1));
	if (i < 0) return bcd_clr(dist);
#endif
	if (!BCD_DET_ZERO(dist) && sgn) BCD_SET_NEGA(dist);
	return BCD_OK;
}

static int bcd_sinsi(BCD_REG* dist, BCD_REG* src, int loop) {			// w[10]--w[12]gp
	int i, i1, i2;

	//dist==src̉\邽߁Adist[NƂĎgpȂ
	bcd_ito(w10, 1, 0);				// z
	bcd_mul(w11, src, src);			// x^2

	i1 = loop * 8 + 6;
	i2 = loop + loop;
	i2 = i2 * (i2 + 1);
	for (i = loop; i > 0; i--) {
		bcd_mul(w12, w10, w11);		// z*x^2
		bcd_divi(w12, w12, i2, 0);	// z*x^2/(2i(2i+1))
		bcd_isub(w10, 1, 0, w12);	// 1-z*x^2/(2i(2i+1))
		i1 -= 8;
		i2 -= i1;
	}
	bcd_mul(dist, w10, src);		// z*x
	return BCD_OK;
}

// ===============================================
// @dist = cos(src)@
// ===============================================
int bcd_cos(BCD_REG* dist, BCD_REG* src) {
	int i, sgn;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (BCD_DET_ZERO(src)) return bcd_ito(dist, 1, 0);

	if (wmode)	bcd_const_pi(w10);						//w10:
	else		bcd_ito(w10, 180, 0);
	bcd_add(w11, w10, w10);								//w11:2
	bcd_mod(dist, src, w11);							//dist:2΂̎c]
	if (BCD_DET_ZERO(dist)) return bcd_ito(dist, 1, 0);

	sgn = 0;
	BCD_SET_POSI(dist);									//Ȃ琳ɂ

	i = bcd_cmp(dist, w10);
	if (i == 0) {
		bcd_ito(dist, 1, 0);
		sgn ^= 1;
	}
	else {
		if (i > 0) {									//Έȏ̋Ԃ̓΂āAʂ̕𔽓]
			bcd_sub(dist, dist, w10);
			sgn ^= 1;
		}

		bcd_muli(w11, w10, 5, -1);						///2
		i = bcd_cmp(dist, w11);							///2Ɣr
		if (i == 0) return bcd_clr(dist);
		if (i > 0) {									///2ȏ̋Ԃ̓-ƂŌvZA]
			bcd_sub(dist, w10, dist);
			if (BCD_GET_SGN(dist)) bcd_clr(dist);		//ɂȂꍇ͌vZ덷Ƃ0ɂ
			sgn ^= 1;
		}

		bcd_muli(w10, w11, 5, -1);						///4
		i = bcd_cmp(dist, w10);							///4Ɣr
		if (i == 0 && nBCD_EVA_LOOP == 0) {
			bcd_ito(dist, 5, -1);
			bcd_sqrt(dist, dist);
		}
		else {
			if (i > 0) {								///4ȏ̋Ԃsin(/2-)ŌvZ
				bcd_sub(dist, w11, dist);
				if (BCD_GET_SGN(dist)) bcd_clr(dist);	//ɂȂꍇ͌vZ덷Ƃ0ɂ
			}

			if (!wmode) {
				bcd_const_pi(w10);
				bcd_mul(w12, dist, w10);
				bcd_divi(dist, w12, 180, 0);
			}

			if (i > 0) {
				i = BCD_TBL_SIN(nBCD_SIGNIF);			///4ȏ̋Ԃsin(/2-)ŌvZ
				bcd_sinsi(dist, dist, i);
			}
			else {										
				i = BCD_TBL_COS(nBCD_SIGNIF);
				bcd_cossi(dist, dist, i);
			}
		}
	}

#if 1
	i = bcd_cmpi(dist, 5, -(nBCD_SIGNIF + 1));
	if (i < 0) return bcd_clr(dist);
#endif
	if (!BCD_DET_ZERO(dist) && sgn) BCD_SET_NEGA(dist);
	return BCD_OK;
}

static int bcd_cossi(BCD_REG* dist, BCD_REG* src, int loop) {		// w[10]--w[12]gp
	int i, i1, i2;

	bcd_mul(w11, src, src);				// x^2
	bcd_ito(dist, 1, 0);				// z

	i1 = loop * 8 + 2;
	i2 = loop + loop;
	i2 = i2 * (i2 - 1);
	for (i = loop; i > 0; i--) {
		bcd_mul(w12, dist, w11);		// z*x^2
		bcd_divi(w10, w12, i2, 0);		// z*x^2/(2i(2i+1))
		bcd_isub(dist, 1, 0, w10);		// 1-z*x^2/(2i(2i+1))
		i1 -= 8;
		i2 -= i1;
	}
	return BCD_OK;
}


// ===============================================
// @dist = tan(src)@
// ===============================================
int bcd_tan(BCD_REG* dist, BCD_REG* src) {				// w[10]--w[13]gp
	int i, sgn, inv;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (BCD_DET_ZERO(src)) return bcd_clr(dist);

	if (wmode)	bcd_const_pi(w10);						//w[10]:
	else		bcd_ito(w10, 180, 0);
	bcd_mod(dist, src, w10);							//w[11]:΂̎c]
	if (BCD_DET_ZERO(dist)) return bcd_clr(dist);

	sgn = 0;
	if (BCD_GET_SGN(dist)) {							//Ȃ猋ʂ𕉂
		BCD_SET_POSI(dist);
		sgn = 1;
	}

	bcd_muli(w11, w10, 5, -1);							///2
	i = bcd_cmp(dist, w11);								///2Ɣr
	if (i == 0) {
		BCD_SET_OVER(dist);
		return BCD_NG;
	}

	if (i > 0) {										///2ȏ̋Ԃ̓-ƂŌvZA]
		bcd_sub(dist, w10, dist);
		if (BCD_GET_SGN(dist)) bcd_clr(dist);			//ɂȂꍇ͌vZ덷Ƃ0ɂ
		sgn ^= 1;
	}

	bcd_muli(w10, w11, 5, -1);							///4
	i = bcd_cmp(dist, w10);								///4Ɣr
	if (i == 0 && nBCD_EVA_LOOP == 0) bcd_ito(dist, 1, 0);
	else {
		inv = 0;
		if (i > 0) {									///4ȏ̋Ԃ̓/2-ƂŌvZAʂ̋tƂ
			bcd_sub(dist, w11, dist);
			if (BCD_GET_SGN(dist)) bcd_clr(dist);		//ɂȂꍇ͌vZ덷Ƃ0ɂ
			inv = 1;
		}

		if (!wmode) {
			bcd_const_pi(w10);
			bcd_mul(w11, dist, w10);
			bcd_divi(dist, w11, 180, 0);
		}

		i = BCD_TBL_SIN(nBCD_SIGNIF);
		bcd_sinsi(w13, dist, i);
		i = bcd_cmpi(w13, 5, -(nBCD_SIGNIF + 1));
		if (i < 0) bcd_clr(w13);

		//xdȂ cos=sqrt(1-sin^2)ƂBx͖
		i = BCD_TBL_COS(nBCD_SIGNIF);
		bcd_cossi(dist, dist, i);
		i = bcd_cmpi(dist, 5, -(nBCD_SIGNIF + 1));
		if (i < 0) bcd_clr(dist);

		if (inv && BCD_DET_ZERO(w13) || !inv && BCD_DET_ZERO(dist)) {
			BCD_SET_ERROR(dist);
			return BCD_NG;
		}
		else {
			if (inv) 	bcd_div(dist, dist, w13);
			else		bcd_div(dist, w13, dist);
		}
	}

	if (!BCD_DET_ZERO(dist) && sgn) BCD_SET_NEGA(dist);
	return BCD_OK;
}

// ===============================================
// @dist = asin(src)@	ʂ-90`0`90܂-/2`0`/2͈̔
// ===============================================
int bcd_asin(BCD_REG* dist, BCD_REG* src) {
	int i, sgn, hen;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (BCD_DET_ZERO(src)) return bcd_clr(dist);

	bcd_cpy(dist, src);
	sgn = 0;
	if (BCD_GET_SGN(dist)) {						//Ȃ猋ʂ𕉂
		BCD_SET_POSI(dist);
		sgn = 1;
	}

	i = bcd_cmpi(dist, 1, 0);
	if (i > 0) {
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}

	if (i == 0) {
		if (!wmode)	bcd_ito(dist, 90, 0);
		else {
			bcd_const_pi(w10);
			bcd_muli(dist, w10, 5, -1);
		}
		if (sgn) BCD_SET_NEGA(dist);
		return BCD_OK;
	}

	i = bcd_cmpi(dist, 5, -1);
	if (i == 0 && nBCD_EVA_LOOP == 0) {
		if (!wmode)	bcd_ito(dist, 30, 0);
		else {
			bcd_const_pi(w10);
			bcd_divi(dist, w10, 6, 0);
		}
		if (sgn) BCD_SET_NEGA(dist);
		return BCD_OK;
	}

	hen = 0;
	if (i > 0) {									//0.5傫ꍇ͕ό`ŌvZ
		hen = 1;
		bcd_isub(w10, 1, 0, dist);					// 1-x
		bcd_muli(dist, w10, 5, -1);					// (1-x)/2
		bcd_sqrt(dist, dist);						// ((1-x)/2)
	}

	i = BCD_TBL_ASIN(nBCD_SIGNIF);
	bcd_asinsi(dist, dist, i);

	if (hen) {
		bcd_add(dist, dist, dist);
		bcd_const_pi(w10);
		bcd_muli(w11, w10, 5, -1);
		bcd_sub(dist, w11, dist);
	}
	if (!wmode) {
		if (!hen) bcd_const_pi(w10);
		bcd_muli(w11, dist, 180, 0);
		bcd_div(dist, w11, w10);
	}
	if (!BCD_DET_ZERO(dist) && sgn) BCD_SET_NEGA(dist);
	return BCD_OK;
}

static int bcd_asinsi(BCD_REG* dist, BCD_REG* src, int loop) {			// w[10]--w[12]gp
	int i, j1, j2, k1, k2;

	bcd_ito(w10, 1, 0);				// z
	bcd_cpy(w12, src);				// x
	bcd_mul(w11, src, src);			// x^2

	i = loop;
	for (; i > 23170; i--) {
		k1 = i + i + 1;
		j1 = k1 - 2;
		bcd_mul(dist, w10, w11);
		bcd_muli(w10, dist, j1, 0);
		bcd_muli(dist, w10, j1, 0);
		bcd_divi(dist, dist, k1, 0);
		k1--;
		bcd_divi(dist, dist, k1, 0);
		bcd_addi(w10, dist, 1, 0);
	}
	k2 = i + i;
	j2 = k2 - 1;
	j2 *= j2;
	k2 = k2 * (k2 + 1);
	j1 = i * 8;
	k1 = j1 + 6;
	for (; i > 0; i--) {
		bcd_mul(dist, w10, w11);					// z*x^2
		bcd_muli(w10, dist, j2, 0);					// z*x^2*(2i-1)^2
		bcd_divi(dist, w10, k2, 0);					// z*x^2*(2i-1)^2/(2i(2i+1))
		bcd_addi(w10, dist, 1, 0);					// 1+z*x^2*(2i-1)^2/(2i(2i+1))
		j1 -= 8;
		j2 -= j1;
		k1 -= 8;
		k2 -= k1;
	}

	bcd_mul(dist, w10, w12);						// z*x
	return BCD_OK;
}

// ===============================================
// @dist = acos(src)@ ʂ0`90`180܂0`/2`΂͈̔
// ===============================================
int bcd_acos(BCD_REG* dist, BCD_REG* src) {
	int i, sgn, hen;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (BCD_DET_ZERO(src)) {
		if (!wmode) return bcd_ito(dist, 90, 0);
		bcd_const_pi(w10);
		bcd_muli(dist, w10, 5, -1);
		return BCD_OK;
	}

	bcd_cpy(dist, src);
	sgn = 0;
	if (BCD_GET_SGN(dist)) {						//Ȃ琳ɂČvZAŌɕ␳
		BCD_SET_POSI(dist);
		sgn = 1;
	}

	i = bcd_cmpi(dist, 1, 0);
	if (i > 0) {
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}

	if (i == 0)	{
		if (!sgn) return bcd_clr(dist);
		if (!wmode) bcd_ito(dist, 180, 0);
		else		bcd_const_pi(dist);
		return BCD_OK;
	}

	i = bcd_cmpi(dist, 5, -1);
	if (i == 0) {
		if (!wmode) {
			if (!sgn)	bcd_ito(dist,  60, 0);
			else		bcd_ito(dist, 120, 0);
		}
		else {
			bcd_const_pi(w10);
			if (!sgn)	bcd_divi(dist, w10, 3, 0);
			else		bcd_divi(dist, w10, 15, -1);
		}
		return BCD_OK;
	}
	hen = 0;
	if (i > 0) {									//0.5傫ꍇ͕ό`ŌvZ
		hen = 1;
		bcd_isub(w10, 1, 0, dist);					// 1-x
		bcd_muli(dist, w10, 5, -1);					// (1-x)/2
		bcd_sqrt(dist, dist);						// ((1-x)/2)
	}

	i = BCD_TBL_ASIN(nBCD_SIGNIF);
	bcd_asinsi(dist, dist, i);

	if (hen) {
		bcd_add(dist, dist, dist);
		bcd_const_pi(w10);
		bcd_muli(w11, w10, 5, -1);
		bcd_sub(dist, w11, dist);
	}

	bcd_const_pi(w10);
	bcd_muli(w11, w10, 5, -1);
	if (sgn)	bcd_add(dist, w11, dist);
	else		bcd_sub(dist, w11, dist);

	if (!wmode) {
		bcd_muli(w11, dist, 180, 0);
		bcd_div(dist, w11, w10);
	}
	return BCD_OK;
}

// ===============================================
// @dist = atan(src)@	ʂ-90`0`90܂-/2`0`/2͈̔
// ===============================================
int bcd_atan(BCD_REG* dist, BCD_REG* src) {
	int i, sgn, inv;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (BCD_DET_ZERO(src)) {
		if (dist != src) return bcd_clr(dist);
		return BCD_OK;
	}

	if (dist != src) bcd_cpy(dist, src);
	sgn = 0;
	if (BCD_GET_SGN(dist)) {					//Ȃ琳ɂČvZAŌɕ]
		BCD_SET_POSI(dist);
		sgn = 1;
	}

	i = bcd_cmpi(dist, 1, 0);
	if (i == 0 && nBCD_EVA_LOOP == 0) {
		if (!wmode) bcd_ito(dist, 45, 0);
		else {
			bcd_const_pi(w10);
			bcd_muli(dist, w10, 25, -2);
		}
		if (sgn) BCD_SET_NEGA(dist);
		return BCD_OK;
	}

	inv = 0;
	if (i > 0) {
		inv = 1;
		bcd_ito(w11, 1, 0);
		bcd_div(dist, w11, dist);
	}

	bcd_mul(w10, dist, dist);
	bcd_addi(w11, w10, 1, 0);
	bcd_div(w11, w10, w11);
	bcd_sqrt(dist, w11);
	bcd_asin(dist, dist);

	if (inv) {
		if (!wmode)	bcd_ito(w10, 90, 0);
		else {
			bcd_const_pi(w11);
			bcd_muli(w10, w11, 5, -1);
		}
		bcd_sub(dist, w10, dist);
	}

	if (!BCD_DET_ZERO(dist) && sgn) BCD_SET_NEGA(dist);
	return BCD_OK;
}

// ===============================================
// @dist = exp(src)@
// ===============================================
int bcd_exp(BCD_REG* dist, BCD_REG* src) {
	int i;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	i = BCD_TBL_EXP(nBCD_SIGNIF);
	return bcd_expsi(dist, src, i);
}

static int bcd_expsi(BCD_REG* dist, BCD_REG* src, int loop) {	// w[10]--w[12]gp
	int i, sgn, idx, idt, rte;
	BCD_REG* r1;

	r1 = w11;
	bcd_cpy(r1, src);

	sgn = 0;
	if (BCD_GET_SGN(r1)) {
		sgn = 1;								//ŌɋtƂ
		BCD_SET_POSI(r1);
	}
	idt = 0;
	while (bcd_cmpi(r1, 1073741824, 0) >= 0) {
		idt++;
		if (idt > 2) {							//exp̏ꍇ2Ŕ肷B
			BCD_SET_OVER(dist);
			return BCD_NG;
		}
		bcd_addi(r1, r1, -1073741824, 0);
	}
	idx = bcd_toi(r1);
	bcd_addi(r1, r1, -idx, 0);						//

	bcd_ito(dist, 1, 0);							//
	if (idx > 0 || idt > 0) bcd_const_e(w12);		//w[12]base
	i = 0;
	while (idx || idt && i < 30) {
		if (idx & 1) {
			if (bcd_mul(dist, dist, w12)) {
				BCD_SET_OVER(dist);
				return BCD_NG;
			}
		}
		idx >>= 1;
		if (idx || idt) bcd_mul(w12, w12, w12);
		i++;
	}
	while (idt) {
		if (bcd_mul(dist, dist, w12)) {
			BCD_SET_OVER(dist);
			return BCD_NG;
		}
		idt--;
	}

	if (!BCD_DET_ZERO(r1)) {
		rte = 0;
		if (bcd_cmpi(r1, 5, -1) > 0) {
			rte = 1;								//Ō̑OiKœ悷
			bcd_muli(r1, r1, 5, -1);
		}

		bcd_ito(w10, 1, 0);						// z
		for (i = loop; i > 0; i--) {
			bcd_mul(w12, w10, r1);				// z*x
			bcd_divi(w12, w12, i, 0);			// z*x/i
			bcd_addi(w10, w12, 1, 0);			// 1+z*x/i
		}

		if (rte) {
			bcd_mul(w10, w10, w10);
		}
		if (bcd_mul(dist, dist, w10)) {
			BCD_SET_OVER(dist);
			return BCD_NG;
		}
	}

	if (sgn) {
		bcd_ito(w12, 1, 0);
		bcd_div(dist, w12, dist);
	}
	return BCD_OK;
}

// ===============================================
// @dist = loge(src)@
// ===============================================
int bcd_loge(BCD_REG* dist, BCD_REG* src) {
	int i, j;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;
	if (BCD_GET_SGN(src) || BCD_DET_ZERO(src)) {
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}

	i = bcd_cmpi(src, 1, 0);
	if (i == 0) return bcd_clr(dist);

	j = BCD_TBL_LOGE(nBCD_SIGNIF);
	if (i > 0) return bcd_logesi(dist, src, j);

	bcd_ito(w10, 1, 0);
	bcd_div(dist, w10, src);
	bcd_logesi(dist, dist, j);
	BCD_SET_NEGA(dist);
	return BCD_OK;
}

static int bcd_logesi(BCD_REG* dist, BCD_REG* src, int loop) {		// w[10]--w[12]gp
	int i, idw;

	idw = 1;
	bcd_cpy(w12, src);
	while (bcd_cmpi(w12, 1133148454, -9) >= 0) {
		bcd_sqrt(w12, w12);
		idw = idw + idw;
	}

	bcd_addi(w10, w12, -1, 0);			// x-1
	bcd_addi(w11, w12, 1, 0);			// x+1
	bcd_div(w12, w10, w11);				//y=(x-1)/(x+1)
	bcd_mul(w11, w12, w12);				//y^2
	i = 2 * loop + 1;
	bcd_clr(w10);						// z
	for (; i > 0; i -= 2) {
		bcd_mul(dist, w10, w11);		// z*y^2
		bcd_ito(w10, 1, 0);
		bcd_divi(w10, w10, i, 0);		// 1/i
		bcd_add(w10, w10, dist);		// 1/i + z*y^2
	}
	bcd_mul(dist, w10, w12);			// z*y
	bcd_add(dist, dist, dist);			// 2*z*y

	bcd_muli(dist, dist, idw, 0);
	return BCD_OK;
}

// ===============================================
// @dist = 10^src@
// ===============================================
int bcd_exp10(BCD_REG* dist, BCD_REG* src) {			// w[10]--w[12]gp
	int sgn, idt;
	BCD_REG *r1, *rd;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	r1 = w11;
	bcd_cpy(r1, src);
	rd = w10;

	sgn = 0;
	if (BCD_GET_SGN(r1)) {
		sgn = 1;								//ŌɋtƂ
		BCD_SET_POSI(r1);
	}

	bcd_IP(rd, r1);								//
	if (bcd_cmpi(rd, nBCD_EXPLIM, 0) > 0) {
		if (sgn) return bcd_clr(dist);
		BCD_SET_OVER(dist);
		return BCD_NG;
	}
	bcd_sub(r1, r1, rd);						//
	idt = bcd_toi(rd);

	if (!BCD_DET_ZERO(r1)) {
		// exp(r1Eln10)
		bcd_const_ln10(w12);
		bcd_mul(dist, r1, w12);
		bcd_exp(dist, dist);
	}
	else bcd_ito(dist, 1, 0);

	BCD_ADD_EXP(dist, idt);
	if (sgn) {
		bcd_ito(w12, 1, 0);
		bcd_div(dist, w12, dist);
	}

	return BCD_OK;
}

// ===============================================
// @dist = log10(src)@
// ===============================================
int bcd_log10(BCD_REG* dist, BCD_REG* src) {			// w[10]--w[12]gp
	int i, idt;

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;
	if (BCD_GET_SGN(src) || BCD_DET_ZERO(src)) {
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}

	i = bcd_cmpi(src, 1, 0);
	if (i == 0) return bcd_clr(dist);

	idt = BCD_GET_EXP(src);
	bcd_cpy(w10, src);
	w[10].exp = 0;
	bcd_loge(dist, w10);

	bcd_const_ln10(w10);
	bcd_div(dist, dist, w10);
	bcd_addi(dist, dist, idt, 0);
	return BCD_OK;
}

// ===============================================
// @dist = sinh(src)@
// ===============================================
int bcd_sinh(BCD_REG* dist, BCD_REG* src) {

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (BCD_DET_ZERO(src)) return bcd_clr(dist);
	if (bcd_exp(dist, src)) return BCD_NG;
	bcd_ito(w10, 1, 0);
	bcd_div(w11, w10, dist);
	bcd_sub(w10, dist, w11);
	bcd_muli(dist, w10, 5, -1);

	return BCD_OK;
}

// ===============================================
// @dist = cosh(src)@
// ===============================================
int bcd_cosh(BCD_REG* dist, BCD_REG* src) {

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (BCD_DET_ZERO(src)) return bcd_ito(dist, 1, 0);
	if (bcd_exp(dist, src)) return BCD_NG;
	bcd_ito(w10, 1, 0);
	bcd_div(w11, w10, dist);
	bcd_add(w10, dist, w11);
	bcd_muli(dist, w10, 5, -1);

	return BCD_OK;
}

// ===============================================
// @dist = tanh(src)@
// ===============================================
int bcd_tanh(BCD_REG* dist, BCD_REG* src) {

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (BCD_DET_ZERO(src)) return bcd_clr(dist);
	if (bcd_exp(dist, src)) return BCD_NG;
	bcd_ito(w10, 1, 0);
	bcd_div(w11, w10, dist);
	bcd_sub(w10, dist, w11);
	bcd_add(w11, dist, w11);
	bcd_div(dist, w10, w11);

	return BCD_OK;
}

// ===============================================
// @dist = asinh(src)@
// ===============================================
int bcd_asinh(BCD_REG* dist, BCD_REG* src) {

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (BCD_DET_ZERO(src)) return bcd_clr(dist);
	bcd_mul(w10, src, src);
	bcd_addi(w11, w10, 1, 0);
	bcd_sqrt(w10, w11);
	bcd_add(dist, w10, src);
	bcd_loge(dist, dist);

	return BCD_OK;
}

// ===============================================
// @dist = acosh(src)@
// ===============================================
int bcd_acosh(BCD_REG* dist, BCD_REG* src) {

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (bcd_cmpi(src, 1, 0) == 0) return bcd_clr(dist);
	bcd_mul(w10, src, src);
	bcd_subi(w11, w10, 1, 0);
	bcd_sqrt(w10, w11);
	bcd_add(dist, w10, src);
	bcd_loge(dist, dist);

	return BCD_OK;
}

// ===============================================
// @dist = atanh(src)@
// ===============================================
int bcd_atanh(BCD_REG* dist, BCD_REG* src) {

	// G[l̉Z`FbN
	if (bcd_err_chk1(dist, src)) return BCD_NG;

	if (BCD_DET_ZERO(src)) return bcd_clr(dist);
	bcd_addi(w10, src, 1, 0);
	bcd_isub(w11, 1, 0, src);
	bcd_div(dist, w10, w11);
	bcd_loge(dist, dist);
	bcd_muli(dist, dist, 5, -1);

	return BCD_OK;
}

#endif	/*BCD_BASIC_FUNC*/


// =============================================================================
// ֐
// =============================================================================
// ===============================================
// WX^Vtg(1_E)(オ菈p)
// ===============================================
static int bcd_shiftd(BCD_REG* dist, int nbot) {
	unsigned int *dd, *dw;

	if (!(dist->dat[0] & BCD_DAT_BCDT)) return BCD_OK;

	//wI[o[t[`FbN
	BCD_ADD_EXP(dist, 1);
	if (BCD_CHK_OVER(dist)) {
		BCD_SET_OVER(dist);
		return BCD_NG;
	}

	// Vtg
	dd = dist->dat + nbot;
	dw = dd;
	while (dd > dist->dat) {
		*dd = *dw-- >> nBCD_DBIT;
		*dd |= BCD_CYU_CLR(*dw << (nBCD_ABIT - nBCD_DBIT));		//VtgAbv͕KJzL[NA
		dd--;
	}
	*dd = *dw >> nBCD_DBIT;

	return BCD_OK;
}

// ===============================================
// WX^Vtg(1Abv)@Zp
// ===============================================
static int bcd_shiftu(BCD_REG* dist) {
	unsigned int *dd, *dw;

	if (dist->dat[0] & BCD_DAT_BCDT) {
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}

	BCD_ADD_EXP(dist, -1);

	// Vtg
	dd = dist->dat;
	dw = dd;
	while (dd < dist->dat + nBCD_NMAX - 1) {
		*dd = BCD_CYU_CLR(*dw++ << nBCD_DBIT);		//VtgAbv͕KJzL[NA
		*dd |= *dw >> (nBCD_ABIT - nBCD_DBIT);
		dd++;
	}
	*dd = BCD_CYU_CLR(*dw << nBCD_DBIT);

	return BCD_OK;
}

// ===============================================
// (distG[`FbN)
// ===============================================
static int bcd_dropup(BCD_REG* dist) {
	int nk, nj;
	unsigned int *dd, *dw, wku;

	dd = dist->dat;
	nk = -1;
	while (dd < dist->dat + nBCD_NMAX) {
		nj = 0;
		if (*dd & BCD_DAT_BCDT) break;
		nk++;
		if (*dd & BCD_DAT_BCD2) break;
		nk++;
		if (*dd & BCD_DAT_BCD3) break;
		nk++;
		if (*dd & BCD_DAT_BCD4) break;
		nk++;
		if (*dd & BCD_DAT_BCD5) break;
		nk++;
		if (*dd++ & BCD_DAT_BCDB) break;
		nk++;
		nj = 1;
	}
	if (dd == dist->dat + nBCD_NMAX && nj) {	// divsidist2NAꂽԂŌĂяo邱ƂB
		dist->exp = 0;
		return BCD_OK;
	}
	if (nk > 0) {
		BCD_ADD_EXP(dist, -nk);
		if (BCD_CHK_UNDER(dist)) {
			bcd_clr(dist);
			return BCD_OK;
		}
		nj = (nk % nBCD_DNUM) * nBCD_DBIT;		//pt-shift
		dw = dist->dat + nk / nBCD_DNUM;		//pt-shift
		dd = dist->dat;
		if (nj == 0) {
			while (dw < dist->dat + nBCD_NMAX) *dd++ = *dw++;
			while (dd < dist->dat + nBCD_NMAX) *dd++ = 0;
		}
		else {
			nk = nBCD_ABIT - nj;		// nj >= 5̏ꍇ
			while (dw < dist->dat + nBCD_NMAX - 1) {
				wku = BCD_CYU_CLR(*dw++ << nj);
				*dd++ = wku | (*dw >> nk);
			}
			*dd++ = BCD_CYU_CLR(*dw << nj);
			while (dd < dist->dat + nBCD_NMAX) *dd++ = 0;
		}
	}
	else if (nk < 0) return bcd_shiftd(dist, nBCD_NMAX - 1);

	return BCD_OK;
}

// ===============================================
// WX^r(Βl)(Klp)(NULL`FbN)
// ===============================================
static int bcd_cmpabs(BCD_REG* src1, BCD_REG* src2) {
	int e1, e2;
	unsigned int *d1, *d2;

	e1 = BCD_GET_EXP(src1);
	e2 = BCD_GET_EXP(src2);
	if (e1 > e2)		return 1;
	else if (e1 < e2)	return -1;

	if (BCD_DET_ZERO(src1) && BCD_DET_ZERO(src2))	return 0;
	d1 = src1->dat;
	d2 = src2->dat;
	while (d1 < src1->dat + nBCD_NMAX) {
		if (*d1 > *d2)	return 1;
		else if (*d1++ < *d2++)	return -1;
	}
	return 0;
}

static int bcd_cmpiabs(BCD_REG* src1, BCD_REG* src2) {
	int e1, e2;
	unsigned int *d1, *d2;

	//src1͐Klł邱ƁAsrc2́Abcd_itowi()Ő|C^ł邱(`FbN͂Ȃ)
	e1 = BCD_GET_EXP(src1);
	e2 = BCD_GET_EXP(src2);
	if (e1 > e2)		return 1;
	else if (e1 < e2)	return -1;

	if (BCD_DET_ZERO(src1) && BCD_DET_ZERO(src2))	return 0;
	d1 = src1->dat;
	d2 = src2->dat;
	e2 = 1;
	if (src2->dat[1]) e2 = 2;

	while (d2 < src2->dat + e2) {
		if (*d1 > *d2)	return 1;
		else if (*d1++ < *d2++)	return -1;
	}
	while (d1 < src1->dat + nBCD_NMAX) {
		if (*d1++)	return 1;
	}
	return 0;
}

// ===============================================
// WX^r(t[g) ɏZp
// ===============================================
static int bcd_cmpflt(BCD_REG* src1, BCD_REG* src2, int nbot1, int nbot2) {
	int i, ni, nj, nk;
	unsigned int *s1, *s2, *s1max, wku;

	//	src2͐Kꂽlł邱ƁBnbot2̓[Ƃ݂ȂĔrB
	//  src1͌A藼Bsrc1Ԃłsrc2̎wsrc1ȉł邱
	i = BCD_GET_EXP(src1) - BCD_GET_EXP(src2);
	if (i < 0) return -1;
	s1 = src1->dat + wdrop;
	ni = wdrop - (i / nBCD_DNUM);			//pt-shift
	nj = (i % nBCD_DNUM) * nBCD_DBIT;		//pt-shift

	while (ni < 0) {
		if (*s1++) return 1;
		ni++;
		wdrop++;
	}
	if (ni > 0) return -1;

	s2 = src2->dat;
	if      (nbot1 ==  0) s1max = src1->dat + nBCD_NMAX;
	else if (nbot1 == -1) s1max = src1->dat + nBCD_NMAX + nBCD_NMAX + 1;
	else if (nbot1 == -2) s1max = src1->dat + nBCD_NMAX + nBCD_NMAX + nBCD_NMAX + 2;
	if (nj == 0) {
		while (s2 <= src2->dat + nbot2 && s1 < s1max) {
			if (*s1 > *s2) return 1;
			if (*s1 < *s2) return -1;
			s1++; s2++;
		}
	}
	else {
		wku = *s2 >> nj;
		if (*s1 > wku) return 1;
		if (*s1 < wku) return -1;
		s1++;
		nk = nBCD_ABIT - nj;
		while (s2 < src2->dat + nbot2 && s1 < s1max) {
			wku  = BCD_CYU_CLR(*s2++ << nk);
			wku |= *s2 >> nj;
			if (*s1 > wku) return 1;
			if (*s1 < wku) return -1;
			s1++;
		}
		if (s1 < s1max) {
			wku = BCD_CYU_CLR(*s2 << nk);
			if (*s1 > wku) return 1;
			if (*s1 < wku) return -1;
			s1++;
		}
	}
	if (s2 < src2->dat + nbot2) return -1;
	while (s1 < s1max) {
		if (*s1++) return 1;
	}
	return 0;
}

// ===============================================
// L`FbN(srcNULL`FbN)
// ===============================================
static int bcd_nbot(BCD_REG* src) {
	int i;
	unsigned int *dw;

	i = nBCD_NMAX - 1;
	dw = src->dat + i;
	while (*dw == 0 && i > 0) {
		i--;
		dw--;
	}
	if (i < nBCD_NMAX - 1) i++;
	return i;
}

// ===============================================
// G[`FbN
// ===============================================
static int bcd_err_chk0(BCD_REG* dist) {
	if (dist == NULL) return BCD_NG;
	return BCD_OK;
}

static int bcd_err_chks(BCD_REG* src) {
	if (src == NULL || BCD_DET_ERROR(src) || BCD_DET_OVER(src)) return BCD_NG;
	return BCD_OK;
}

static int bcd_err_chk1(BCD_REG* dist, BCD_REG* src) {
	if (dist == NULL) return BCD_NG;
	if (src == NULL || BCD_DET_ERROR(src)) {
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}
	if (BCD_DET_OVER(src)) {
		BCD_SET_OVER(dist);
		return BCD_NG;
	}
	return BCD_OK;
}

static int bcd_err_chk1d(BCD_REG* dist1, BCD_REG* dist2, BCD_REG* src) {
	if (dist1 == NULL || dist2 == NULL) return BCD_NG;
	if (src == NULL || BCD_DET_ERROR(src)) {
		BCD_SET_ERROR(dist1);
		BCD_SET_ERROR(dist2);
		return BCD_NG;
	}
	if (BCD_DET_OVER(src)) {
		BCD_SET_OVER(dist1);
		BCD_SET_OVER(dist2);
		return BCD_NG;
	}
	return BCD_OK;
}

static int bcd_err_chk2(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2) {
	if (dist == NULL) return BCD_NG;
	if (src1 == NULL || src2 == NULL || BCD_DET_ERROR(src1) || BCD_DET_ERROR(src2)) {
		BCD_SET_ERROR(dist);
		return BCD_NG;
	}
	if (BCD_DET_OVER(src1) || BCD_DET_OVER(src2)) {
		BCD_SET_OVER(dist);
		return BCD_NG;
	}
	return BCD_OK;
}

static int bcd_err_chk2d(BCD_REG* dist1, BCD_REG* dist2, BCD_REG* src1, BCD_REG* src2) {
	if (dist1 == NULL || dist2 == NULL) return BCD_NG;
	if (src1 == NULL || src2 == NULL || BCD_DET_ERROR(src1) || BCD_DET_ERROR(src2)) {
		BCD_SET_ERROR(dist1);
		BCD_SET_ERROR(dist2);
		return BCD_NG;
	}
	if (BCD_DET_OVER(src1) || BCD_DET_OVER(src2)) {
		BCD_SET_OVER(dist1);
		BCD_SET_OVER(dist2);
		return BCD_NG;
	}
	return BCD_OK;
}

// ===============================================
// ]p
// ===============================================
#ifndef BCD_NO_EVALUATION
int bcd_set_compact(int i) {
	if (i)	compact_flag = 1;
	else	compact_flag = 0;
	return BCD_OK;
}

int bcd_set_precision(int i) {
	if (i)	precision_flag = 1;
	else	precision_flag = 0;
	return BCD_OK;
}

#ifndef BCD_BASIC_FUNC
int bcd_set_loop(int i) {
	if (i < 1)	func_loop_num = 0;
	else		func_loop_num = i;
	return BCD_OK;
}
#endif

int bcd_set_baremode(int i) {
	if (i)	baremode_flag = 1;
	else	baremode_flag = 0;
	return BCD_OK;
}

int bcd_set_dispmode(int i) {
	if (i) {
		space_control = 0;
		line_control = 0;
	}
	else {
		space_control = nBCD_DISP_SPACE;
		line_control = nBCD_DISP_LINE;
	}
	return BCD_OK;
}

int bcd_fillw9(BCD_REG* dist) {
	int i;
	unsigned int *dd;

	// G[l̉Z`FbN
	if (bcd_err_chk0(dist)) return BCD_NG;

	dd = dist->dat + nBCD_NMAX - 1;
	i = (9 << BCD_DAT_BITT) | (9 << BCD_DAT_BIT2) |
		(9 << BCD_DAT_BIT3) | (9 << BCD_DAT_BIT4) |
		(9 << BCD_DAT_BIT5) | (9 << BCD_DAT_BITB);
	while (dd > dist->dat && *dd == 0) *dd-- = i;
	if (!(*dd & BCD_DAT_BCDB)) {
		*dd |= (9 << BCD_DAT_BITB);
		if (!(*dd & BCD_DAT_BCD5))
			*dd |= (9 << BCD_DAT_BIT5);
		if (!(*dd & BCD_DAT_BCD4)) {
			*dd |= (9 << BCD_DAT_BIT4);
			if (!(*dd & BCD_DAT_BCD3)) {
				*dd |= (9 << BCD_DAT_BIT3);
				if (!(*dd & BCD_DAT_BCD2)) {
					*dd |= (9 << BCD_DAT_BIT2);
					if (dd > dist->dat && !(*dd & BCD_DAT_BCDF)) *dd |= (9 << BCD_DAT_BITF);
				}
			}
		}
	}
	return BCD_OK;
}

#endif	/*BCD_NO_EVALUATION*/
