// =============================================================================
// =============================================================================
// BCDZCu(32bitCPU, Cp) LIBwb_
// BCD calculation library (32bitCPU, C language) LIB Header
//											(c)2025 }CRZ@Vc 
//											(c)2025 Maikon - Giken  Akira Sawada
// Release 1.30  2025/12/23	萔e[up`ύX
// Release 1.10  2025/12/15
// =============================================================================
// =============================================================================
#ifndef VLBCD_LIB_H
#define VLBCD_LIB_H
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "vlbcd_api.h"

// =============================================================================
// `
// =============================================================================
// BCD_REGTCYɊւ`
#ifdef  BCD_NUM_FIXED
#define nBCD_SIGNIF			(nBCD_NUM_SIGNIF)					// L
#define nBCD_NMAX			(nBCD_DATMAX)						// f[^[hTCY
#define nBCD_DMAX			(nBCD_DIGMAX)						// Z
#else
#define nBCD_SIGNIF			(bcd_signif_num)					// ۂ̗L		bcd_num_digits()֐Őݒ
#define nBCD_NMAX			(bcd_nmax_num)						// f[^[hTCYB	bcd_num_digits()֐Őݒ
#define nBCD_DMAX			(bcd_dmax_num)						// ZB		bcd_num_digits()֐Őݒ
#endif

// BCD_REG^ expoɊւ`
// b31-b1:wAb0:@(rbgtB[h\̂͏nˑ̌Ôō̗pȂ)
#define BCD_EXP_OVER		(0x7f010000)						// OVERFLOWB
#define BCD_EXP_ERROR		(0x7f020000)						// ُ̑([ZȂΐA|C^sȂ)B
#define BCD_EXP_INVALID		(0x7fff0000)						// ̑(Zr̈ꎞIȖԁB֐I͏L2ނ݂Ȃ)
#define BCD_SET_OVER(p)		((p)->exp = BCD_EXP_OVER)			// OVERFLOWݒ
#define BCD_SET_ERROR(p)	((p)->exp = BCD_EXP_ERROR)			// ERRORݒ
#define BCD_DET_OVER(p)		((p)->exp == BCD_EXP_OVER)			// OVERFLOWȂtrue
#define BCD_DET_ERROR(p)	((p)->exp == BCD_EXP_ERROR)			// ERRORȂtrue

#define BCD_FLG_BIT			(1)									// tOBb0:B
#define BCD_FLG_MASK		((1 << BCD_FLG_BIT) - 1)			// tÕ}XN
#define BCD_GET_EXP(p)		((p)->exp >> BCD_FLG_BIT)			// w̎擾
#define BCD_SET_EXP(p,e)	((p)->exp = ((e) << BCD_FLG_BIT) | ((p)->exp & BCD_FLG_MASK))		// w̐ݒ
#define BCD_ADD_EXP(p,n)	((p)->exp += ((n) << BCD_FLG_BIT))	// wZ
#define BCD_CHK_OVER(p)		(BCD_GET_EXP(p) > nBCD_EXPLIM)		// w𒴂`FbNBĂtrue
#define BCD_CHK_UNDER(p)	(BCD_GET_EXP(p) < -nBCD_EXPLIM)		// w𒴂`FbNBĂtrue

#define BCD_SGN_MASK		(0x00000001)						// rbg}XNB
#define BCD_GET_SGN(p)		((p)->exp &   BCD_SGN_MASK)			// 擾B0:, 1:
#define BCD_SET_SGN(p,s)	((p)->exp = ((p)->exp & ~BCD_SGN_MASK) | ((s) & BCD_SGN_MASK))	// ̐ݒ
#define BCD_SET_POSI(p)		((p)->exp &= ~BCD_SGN_MASK)			// 𐳂ɂ
#define BCD_SET_NEGA(p)		((p)->exp |=  BCD_SGN_MASK)			// 𕉂ɂ
#define BCD_SET_SINV(p)		((p)->exp ^=  BCD_SGN_MASK)			// 𔽓]ɂ
#define BCD_SET_EXSG(p,e,s)	((p)->exp = ((e) << BCD_FLG_BIT) | ((s) & BCD_FLG_MASK))		// wƕ̐ݒ

// BCD_REG^ datz񃁃oɊւ`
#define nBCD_DBIT			(5)									// 1̃rbg
#define nBCD_ABIT			(nBCD_DBIT * nBCD_DNUM)				// 1[h̍vrbg
#define BCD_DAT_BITF		(21)								// dat[0]̒ʏJñrbgʒu
#define BCD_DAT_BITS		(16)								// dat[0]̒ʏ2ڂ̃rbgʒu
#define BCD_DAT_BITT		(26)								// e[h ŏ̌(1)̃rbgʒu
#define BCD_DAT_BIT2		(21)								// e[h 2ڂ̃rbgʒu
#define BCD_DAT_BIT3		(16)								// e[h 3ڂ̃rbgʒu
#define BCD_DAT_BIT4		(11)								// e[h 4ڂ̃rbgʒu
#define BCD_DAT_BIT5		( 6)								// e[h 5ڂ̃rbgʒu
#define BCD_DAT_BITB		( 1)								// e[h Ō̌(6)̃rbgʒu
#define BCD_DAT_BCDF		(0x0f << BCD_DAT_BITF)				// dat[0]̒ʏJnʒũ}XN
#define BCD_DAT_BCDT		(0x0f << BCD_DAT_BITT)				// e[h ŏ̌(1)̃}XN
#define BCD_DAT_BCD2		(0x0f << BCD_DAT_BIT2)				// e[h 2ڂ̃}XN
#define BCD_DAT_BCD3		(0x0f << BCD_DAT_BIT3)				// e[h 3ڂ̃}XN
#define BCD_DAT_BCD4		(0x0f << BCD_DAT_BIT4)				// e[h 4ڂ̃}XN
#define BCD_DAT_BCD5		(0x0f << BCD_DAT_BIT5)				// e[h 5ڂ̃}XN
#define BCD_DAT_BCDB		(0x0f << BCD_DAT_BITB)				// e[h Ō̌(6)̃}XN
#define BCD_DAT_MASK	(BCD_DAT_BCDT | BCD_DAT_BCD2 | BCD_DAT_BCD3  | \
						 BCD_DAT_BCD4 | BCD_DAT_BCD5 | BCD_DAT_BCDB)		// 1[hŜ̃f[^}XN
#define BCD_SUP_MASK	(( 6 << BCD_DAT_BITT) | ( 6 << BCD_DAT_BIT2) | \
						 ( 6 << BCD_DAT_BIT3) | ( 6 << BCD_DAT_BIT4) | \
						 ( 6 << BCD_DAT_BIT5) | ( 6 << BCD_DAT_BITB) )		// 1[hŜ10i␳l
#define BCD_CRY_MASK	((16 << BCD_DAT_BITT) | (16 << BCD_DAT_BIT2) | \
						 (16 << BCD_DAT_BIT3) | (16 << BCD_DAT_BIT4) | \
						 (16 << BCD_DAT_BIT5) | (16 << BCD_DAT_BITB) | 1 )	// 1[hŜ̃L[}XN
#define BCD_CYU_BIT			(31)								// JzL[rbgʒu
#define BCD_CYU_MASK		(1 << BCD_CYU_BIT)					// JzL[rbg̃}XN
#define BCD_CYU_CLR(d)		((d) & ~BCD_CYU_MASK)				// JzL[rbg̃NA(VtgAbv̂ݍ폜)
#define BCD_DET_ZERO(p)		((p)->dat[0] == 0)					// f[^[̏ꍇtrueBdat[0]݂̂Ŕ肪łB

#define BCD_IDX_UP(j,i)		((j) = ((j) == BCD_DAT_BITT)?	\
							       ((i)--, BCD_DAT_BITB) :	\
								   ((j) +  nBCD_DBIT)	  )		// f[^̃rbgʒuAbv(ʌֈړ),iintł|C^łǂB
#define BCD_IDX_DW(j,i)		((j) = ((j) == BCD_DAT_BITB)?	\
								   ((i)++, BCD_DAT_BITT) :	\
								   ((j) -  nBCD_DBIT)	  )		// f[^̃rbgʒu_E(ʌֈړ),iintł|C^łǂB

// ϊ֘A
#define nBCD_INT_LIM		(2147483647)						// ϊx(Βl)
#define nBCD_INT_LIMDIG		(10)								// ϊx()

// 萔e[upA֘A
#define nBCD_STRLIM	((nBCD_DIGMAX*1000 + 1000/nBCD_DISP_SPACE + 1000/nBCD_DISP_LINE) /1000 + 15)	// 񏈗̕یp

// =============================================================================
// CdlɊւ`
// =============================================================================
#ifdef BCD_NON_SECURITY
#define __strcpy_s(d, n, s)			strcpy(d, s)
#define __strcat_s(d, n, s)			strcat(d, s)
#define __sprintf_s(d, n, s, e)		sprintf(d, s, e)
#else
#define __strcpy_s		strcpy_s
#define __strcat_s		strcat_s
#define __sprintf_s		sprintf_s
#endif

// =============================================================================
// =============================================================================
// vg^Cv錾
// =============================================================================
// =============================================================================
// ֐
// =============================================================================
static int bcd_err_chk0(BCD_REG* dist);										//*
static int bcd_err_chks(BCD_REG* src);										//*
static int bcd_err_chk1(BCD_REG* dist, BCD_REG* dsrc);						//*
static int bcd_err_chk1d(BCD_REG* dist1, BCD_REG* dist2, BCD_REG* src);		//*
static int bcd_err_chk2(BCD_REG* dist, BCD_REG* dsrc1, BCD_REG* dsrc2);		//*
static int bcd_err_chk2d(BCD_REG* dist1,BCD_REG* dist2,BCD_REG* src1, BCD_REG* src2);	//*

static int bcd_cpy(BCD_REG* dist, BCD_REG* hsrc);
static int bcd_clr(BCD_REG* dist);
static int bcd_addsi(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2, int nbot1, int nbot2);
static int bcd_subsi(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2, int nbot1, int nbot2);
static int bcd_mulsi(BCD_REG* dist, BCD_REG* d1,   BCD_REG* d2,   int nbot1, int nbot2);
static int bcd_divsi(BCD_REG* dist, BCD_REG* src1, BCD_REG* src2, int nbot2, int limit);
static int bcd_itosi(BCD_REG* dist, int num, int n);
static BCD_REG* bcd_itowi(int idx, int num, int n);

static int bcd_shiftd(BCD_REG* dist, int nbot);
static int bcd_shiftu(BCD_REG* dist);
static int bcd_dropup(BCD_REG* dist);
static int bcd_cmpabs(BCD_REG* src1, BCD_REG* src2);
static int bcd_cmpiabs(BCD_REG* src1, BCD_REG* src2);
static int bcd_cmpflt(BCD_REG* src1, BCD_REG* src2, int nbot1, int nbot2);
#define bcd_cmpflt_init()			(wdrop = 0)
static int bcd_nbot(BCD_REG* src);

#ifndef BCD_BASIC_FUNC
static int bcd_cpyn(BCD_REG* dist, BCD_REG* src, int nbot);
static int bcd_cpyu(BCD_REG* dist, BCD_REG* src);
static int bcd_sinsi(BCD_REG* dist, BCD_REG* src, int loop);
static int bcd_cossi(BCD_REG* dist, BCD_REG* src, int loop);
static int bcd_asinsi(BCD_REG* dist, BCD_REG* src, int loop);
static int bcd_expsi(BCD_REG* dist, BCD_REG* src, int loop);
static int bcd_logesi(BCD_REG* dist, BCD_REG* src, int loop);
#endif

#ifndef BCD_NO_EVALUATION
#endif

// =============================================================================
#endif /*VLBCD_LIB_H*/
