// =============================================================================
// =============================================================================
// 10֐d - - - - - - - - - - BCDZCũeXgTv
// 100,000 digits Scientific Calc --- Test Sample for BCD calculation library
//											(c)2025 }CRZ@Vc 
//											(c)2025 Maikon - Giken  Akira Sawada
// Release 1.30  2025/12/23	ׂ\ǉAdump(XNvg)ǉ
// Release 1.10  2025/12/15
// =============================================================================
// =============================================================================
// w\
// ֐(Op֐AwEΐ֐AȂ)̐xmF@\

#include "all_define.h"		//ʃC^tF[X(win32_screen)gp邽߂̒`
#include "vlbcd_api.h"		//BCDZCugp邽߂̃wb_
#include <time.h>			//sԕ]p
// =============================================================================
// =============================================================================
// BCDZpϐѕ\̈̒`
// =============================================================================
// =============================================================================
#define nREG		(15)		// WX^(BCDϐ){	R0(r[0])`R14(r[14])ɑΉ({łłR11`R14gp)
#define nREGD		(10)		// \WX^			R0`R4:S\AR5`R9:擪35x̕\
#define nREGE		(5)			// ҏW\WX^		R0`R4ɑΉ

BCD_REG r[nREG];				// WX^(BCDϐ)EEE[U[ŕKvȖ{mۂBzłKv͂ȂB


// \̈ʂŐݒ肳p[^́Aďo(Win32ʐ)łłɒ`Ă̂ŕRÂ̂ݍs
#define s			(fpara)					//WX^̕\̈
#define s_digit		(fpara[kPARA_DIG])		//Lݒ
#define s_dext		(fpara[kPARA_DEXT])		//ŏg\(Ql)
#define s_dmax		(fpara[kPARA_DMAX])		//Z(Ql)
#define s_cmd		(fpara[kPARA_CMD])		//eXgXNvg
#define s_mess		(fpara[kPARA_RES])		//sʃXe[^X̕\̈
#define compac		(fpnum[kNUM_LIM])		//RpNg̃eXgp`FbN{bNXl
#define baremode	(fpnum[kNUM_HIPREC])	//ZSĂ\郂[hp`FbN{bNXl
#define planedisp	(fpnum[kNUM_DISP])		//l̃Xy[X/C\p`FbN{bNXl
#define angle		(fpnum[kNUM_RAD])		//pxP
#define command		(fpnum[kNUM_CMD])		//ʂ̉Z{^ɑΉԍ

char	sw[nREG][nPARALEN];					//ҏWẽobNAbv(ύXꂽǂ̊mFp)
char	sh[nREGD - nREGE][nPARALEN];		//R5-R9ׂ̂\s΍p
#define nMESSLEN	nPARALEN				//nPARALEŃAWin32ʐŒ`ς݂̕TCY

static int lim_digits, n_digits, r_digits;	//]pp[^FL(wl)AZAL(덷vZpl)
extern char *test_data[];					//eXgf[^(v~eBueXgp)


// =============================================================================
// =============================================================================
// dp[J֐̃vg^Cv錾
// =============================================================================
// =============================================================================
static int printREG(int i);
static int pushREG(void);
static int popREG(void);
static int cpyREG(int to, int from);
static int aclrREG(void);
static int mclrREG(void);
static int clrREG(int i);
static int strREG(int i);
static int ldrREG(int i);
static int testcomdREG(void);
static int testallREG(int st, int ed);
static int setnumREG(BCD_REG* dist, char* p);


// =============================================================================
// =============================================================================
// AvP[V{
// =============================================================================
// =============================================================================
int TSmain(LPVOID param) {
	int		i;

	s_mess[0] = '\0';		//bZ[WNA

	//pxPʐݒ
#ifndef	 BCD_BASIC_FUNC
	bcd_angle(angle);
#endif

	//]@\̐ݒ(RpNgAZS\)
#ifndef	BCD_NO_EVALUATION
	bcd_set_compact(compac);
	bcd_set_baremode(baremode);
	bcd_set_dispmode(planedisp);
#endif

	//`FbN
	lim_digits = strtol(s_digit, NULL, 10);
#ifdef BCD_NUM_FIXED
	lim_digits = nBCD_NUM_SIGNIF;
	if (lim_digits == BCD_NG) {
#else
	if (bcd_num_digits(lim_digits) == BCD_NG) {
#endif
		strcpy_s(s_mess, nMESSLEN, "Invalid number of Significant digit");
		return BCD_NG;
	}
	i = BCD_TBL_SIGNIF(lim_digits);
	n_digits = lim_digits + i + 1;
	n_digits = ((n_digits - 1) / nBCD_DNUM + 1) * nBCD_DNUM;
	r_digits = n_digits - i - 1;

	//ŏgxA\EEEQlp
	sprintf_s(s_dext, 12, "%d", i);
	sprintf_s(s_dmax, 12, "%d", n_digits);

	//WX^ǎ(NѕҏWɂύXꂽWX^̂ݓǎ)
	for (i = 0; i < nREG; i++) {
		if (strcmp(s[i], sw[i]) != 0) {
			if (i < nREGE || i > nREGD) bcd_strto(&r[i], s[i]);
			else				 		bcd_strto(&r[i], sh[i - nREGE]);
			strcpy_s(sw[i], nPARALEN, s[i]);
		}
	}

	//R}hs
	switch (command) {
		case COM_PLUS: pushREG(); bcd_add(&r[0], &r[2], &r[1]);	printREG(0); break;
		case COM_MINA: pushREG(); bcd_sub(&r[0], &r[2], &r[1]); printREG(0); break;
		case COM_MULT: pushREG(); bcd_mul(&r[0], &r[2], &r[1]);	printREG(0); break;
		case COM_DEVD: pushREG(); bcd_div(&r[0], &r[2], &r[1]); printREG(0); break;
		case COM_MOD:  pushREG(); bcd_mod(&r[0], &r[2], &r[1]); printREG(0); break;
		case COM_PUSH: pushREG(); break;
		case COM_POP:  popREG();  break;
		case COM_RECI: pushREG(); bcd_ito(&r[0], 1, 0); bcd_div(&r[0], &r[0], &r[1]); printREG(0); break;
		case COM_DUP:  pushREG(); cpyREG(0, 1); break;
		case COM_XCH01:cpyREG(10, 1); cpyREG(1, 0); cpyREG(0, 10);	break;
		case COM_XP2:  pushREG(); bcd_mul(&r[0], &r[1], &r[1]); printREG(0); break;
		case COM_XP3:  pushREG(); bcd_mul(&r[0], &r[1], &r[1]); bcd_mul(&r[0], &r[0], &r[1]); printREG(0); break;
#ifndef BCD_BASIC_FUNC
		case COM_SQRT: pushREG(); bcd_sqrt(&r[0], &r[1]); printREG(0); break;
		case COM_CBRT: pushREG(); bcd_curt(&r[0], &r[1]); printREG(0); break;
		case COM_POW:  pushREG(); bcd_pow(&r[0], &r[2], &r[1]); printREG(0); break;
		case COM_SIN:  pushREG(); bcd_sin(&r[0], &r[1]); printREG(0); break;
		case COM_COS:  pushREG(); bcd_cos(&r[0], &r[1]); printREG(0); break;
		case COM_TAN:  pushREG(); bcd_tan(&r[0], &r[1]); printREG(0); break;
		case COM_EXP:  pushREG(); bcd_exp(&r[0], &r[1]); printREG(0); break;
		case COM_E10:  pushREG(); bcd_exp10(&r[0], &r[1]); printREG(0);  break;
		case COM_ASIN: pushREG(); bcd_asin(&r[0], &r[1]); printREG(0); break;
		case COM_ACOS: pushREG(); bcd_acos(&r[0], &r[1]); printREG(0); break;
		case COM_ATAN: pushREG(); bcd_atan(&r[0], &r[1]); printREG(0); break;
		case COM_LOGE: pushREG(); bcd_loge(&r[0], &r[1]); printREG(0); break;
		case COM_LOG10:pushREG(); bcd_log10(&r[0], &r[1]); printREG(0); break;
		case COM_SINH: pushREG(); bcd_sinh(&r[0], &r[1]); printREG(0); break;
		case COM_COSH: pushREG(); bcd_cosh(&r[0], &r[1]); printREG(0); break;
		case COM_TANH: pushREG(); bcd_tanh(&r[0], &r[1]); printREG(0); break;
		case COM_PAI:  pushREG(); bcd_const_pi(&r[0]);    printREG(0); break;
		case COM_NAP:  pushREG(); bcd_const_e(&r[0]);     printREG(0); break;
		case COM_ASINH:pushREG(); bcd_asinh(&r[0], &r[1]); printREG(0); break;
		case COM_ACOSH:pushREG(); bcd_acosh(&r[0], &r[1]); printREG(0); break;
		case COM_ATANH:pushREG(); bcd_atanh(&r[0], &r[1]); printREG(0); break;
#endif
		case COM_ACLR: aclrREG(); break;
		case COM_MCLR: mclrREG(); break;
		case COM_STR5: strREG(5); break;
		case COM_STR6: strREG(6); break;
		case COM_STR7: strREG(7); break;
		case COM_STR8: strREG(8); break;
		case COM_STR9: strREG(9); break;
		case COM_LDR5: ldrREG(5); break;
		case COM_LDR6: ldrREG(6); break;
		case COM_LDR7: ldrREG(7); break;
		case COM_LDR8: ldrREG(8); break;
		case COM_LDR9: ldrREG(9); break;
		case COM_CLR0: clrREG(5); break;
		case COM_CLR1: clrREG(6); break;
		case COM_CLR2: clrREG(7); break;
		case COM_CLR3: clrREG(8); break;
		case COM_CLR4: clrREG(9); break;
		case COM_FACT: pushREG(); i = bcd_toi(&r[1]); bcd_facti(&r[0], i); printREG(0);	break;
		case COM_CHGF: bcd_inv(&r[0], &r[0]); printREG(0);	break;
		case COM_ABS:  bcd_abs(&r[0], &r[0]); printREG(0);	break;
		//case COM_zATANH:
		//case COM_zyDR8:
#ifndef	BCD_NO_EVALUATION
		case COM_FILL: bcd_fillw9(&r[0]); printREG(0); break;
#endif
		case COM_ROFF: pushREG(); i = bcd_toi(&r[1]); bcd_round(&r[0], &r[2], i); printREG(0);	break;
		case COM_IP:   pushREG(); bcd_IP(&r[0], &r[1]); printREG(0); break;
		case COM_FP:   pushREG(); bcd_FP(&r[0], &r[1]); printREG(0); break;
		case COM_EP:   pushREG(); bcd_EP(&r[0], &r[1]); printREG(0); break;
		case COM_GO:   testcomdREG(); break;
		default:
			strcpy_s(s_mess, nPARALEN, "Not yet supported");
			break;
	}

	return 0;
}

// =============================================================================
// =============================================================================
// dp֐
// =============================================================================
// =============================================================================
//------------------------------
// vg
//------------------------------
static int printREG(int i) {
	if (i < 0 || i >= nREG) return BCD_NG;
	bcd_tostr(&r[i], s[i]);
	strcpy_s(sw[i], nPARALEN, s[i]);
	return BCD_OK;
}

//------------------------------
// vbV(up)A|bv(down)ARs[
//------------------------------
static int pushREG(void) {
	int i;

	for (i = nREGE - 1; i > 0; i--) cpyREG(i, i - 1); 
	clrREG(0);
	return BCD_OK;
}

static int popREG(void) {
	int i;

	for (i = 0; i < nREGE - 1; i++) cpyREG(i, i + 1);
	clrREG(nREGE - 1);
	return BCD_OK;
}

static int cpyREG(int to, int from) {
	if (to < 0 || to >= nREG || from < 0 || from >= nREG) return BCD_NG;
	bcd_copy(&r[to], &r[from]);
	strcpy_s(s[to], nPARALEN, s[from]);
	strcpy_s(sw[to], nPARALEN, sw[from]);
	return BCD_OK;
}

//------------------------------
// WX^NAANA
//------------------------------
static int aclrREG(void) {
	int i;
	for (i = 0; i < nREGE; i++) clrREG(i);
	return BCD_OK;
}

static int mclrREG(void) {
	int i;
	for (i = nREGE; i < nREGD; i++) clrREG(i);
	return BCD_OK;
}

static int clrREG(int i) {
	if (i < 0 || i >= nREG) return BCD_NG;
	s[i][0] = '0';
	s[i][1] = '\0';
	sw[i][0] = '0';
	sw[i][1] = '\0';
	bcd_clear(&r[i]);
	return BCD_OK;
}

//------------------------------
// XgAA[h
//------------------------------
static int strREG(int i) {
	if (i < nREGE || i >= nREG) return BCD_NG;
	strcpy_s(sh[i - nREGE], nPARALEN, s[0]);
	cpyREG(i, 0);
	s[i][50] = '\0';
	sw[i][50] = '\0';
	popREG();
	return BCD_OK;
}

static int ldrREG(int i) {
	if (i < nREGE || i >= nREG) return BCD_NG;
	pushREG();
	cpyREG(0, i);
	strcpy_s(s[0], nPARALEN, sh[i - nREGE]);
	strcpy_s(sw[0], nPARALEN, sh[i - nREGE]);
	return BCD_OK;
}

void recoverREG(void) {		// R5-R9.ini֕ۑ邽߂̏
	int i;
	for (i = nREGE; i < nREGD; i++) {
		strcpy_s(s[i], nPARALEN, sh[i - nREGE]);
	}
}

void readinitREG(void) {	// R5-R9.ini畜邽߂̏
	int i;
	for (i = nREGE; i < nREGD; i++) {
		strcpy_s(sh[i - nREGE], nPARALEN, s[i]);
		s[i][50] = '\0';
	}

}

//------------------------------
// eXgR}h
//------------------------------
static int testcomdREG(void) {
	int	i, j, k, line;
	int	ii, jj, kk, kf;
	char *p, *pend, c, pwk[100];
	unsigned int *dw, *dz;
	double ts, te;

	p = s_cmd;
	i = strlen(p);
	pend = p + i;
	line = 1;
	while (*p != '\0' && p < pend) {
		while (*p == ' ') p++;
		if (strncmp(p, "loop", 4) == 0) {
			p += 4;
			i = strtol(p, &p, 10);
			p++;
			while (*p == ' ') p++;
			c = *p++;
			pushREG();
			ts = clock();
			for (j = 0; j < i; j++) {
				switch (c) {
					case '+': bcd_add(&r[0], &r[2], &r[1]);	break;
					case '-': bcd_sub(&r[0], &r[2], &r[1]);	break;
					case '*': bcd_mul(&r[0], &r[2], &r[1]);	break;
					case '/': bcd_div(&r[0], &r[2], &r[1]);	break;
					case '%': bcd_mod(&r[0], &r[2], &r[1]);	break;
#ifndef BCD_BASIC_FUNC
					case '1': bcd_pow(&r[0], &r[2], &r[1]); break;
					case '8': bcd_sqrt(&r[0], &r[1]); break;
					case '9': bcd_curt(&r[0], &r[1]); break;
					case 'a': bcd_sin(&r[0], &r[1]); break;
					case 'b': bcd_cos(&r[0], &r[1]); break;
					case 'c': bcd_tan(&r[0], &r[1]); break;
					case 'd': bcd_exp(&r[0], &r[1]); break;
					case 'e': bcd_exp10(&r[0], &r[1]); break;
					case 'f': bcd_asin(&r[0], &r[1]); break;
					case 'g': bcd_acos(&r[0], &r[1]); break;
					case 'h': bcd_atan(&r[0], &r[1]); break;
					case 'i': bcd_loge(&r[0], &r[1]); break;
					case 'j': bcd_log10(&r[0], &r[1]); break;
#endif
					default: break;
				}
			}
			te = clock();
			te = (te - ts) / CLOCKS_PER_SEC;
			printREG(0);
			sprintf_s(s_mess, nPARALEN, "total=%.2fsec, %fsec/1loop\n", te, te / i);
		}
		else if (strncmp(p, "prec", 4) == 0) {
			p += 4;
			i = strtol(p, &p, 10);
			p++;
			while (*p == ' ') p++;
			c = *p++;
			pushREG();
#ifndef BCD_NO_EVALUATION
#ifndef	BCD_BASIC_FUNC
			bcd_set_loop(i);
#endif
#endif
			ts = clock();
			switch (c) {
#ifndef BCD_BASIC_FUNC
				case '1': bcd_pow(&r[0], &r[6], &r[7]); break;
				case 'a': bcd_sin(&r[0], &r[6]); break;
				case 'b': bcd_cos(&r[0], &r[6]); break;
				case 'c': bcd_tan(&r[0], &r[6]); break;
				case 'd': bcd_exp(&r[0], &r[6]); break;
				case 'e': bcd_exp10(&r[0], &r[6]); break;
				case 'f': bcd_asin(&r[0], &r[6]); break;
				case 'g': bcd_acos(&r[0], &r[6]); break;
				case 'h': bcd_atan(&r[0], &r[6]); break;
				case 'i': bcd_loge(&r[0], &r[6]); break;
				case 'j': bcd_log10(&r[0], &r[6]); break;
#endif
				default: break;
			}
			te = clock();
			te = (te - ts) / CLOCKS_PER_SEC;
#ifndef	BCD_NO_EVALUATION
#ifndef	BCD_BASIC_FUNC
			bcd_set_loop(0);
#endif
#endif
			printREG(0);
			pushREG();
			bcd_sub(&r[0], &r[1], &r[5]);
			bcd_muli(&r[0], &r[0], 1, r_digits + 6);
			printREG(0);
			sprintf_s(s_mess, nPARALEN, "%fsec, %.2fmin\n", te, te / 60);
		}
		else if (strncmp(p, "hipr", 4) == 0) {
			p += 4;
			while (*p == ' ') p++;
			c = *p++;
			if (c == '*') {
#ifndef	BCD_NO_EVALUATION
				bcd_set_precision(1);
#endif
				bcd_mul(&r[4], &r[1], &r[0]);
#ifndef	BCD_NO_EVALUATION
				bcd_set_precision(0);
#endif
				bcd_mul(&r[3], &r[1], &r[0]);
			}
			else if (c == '/') {
#ifndef	BCD_NO_EVALUATION
				bcd_set_precision(1);
#endif
				bcd_div(&r[4], &r[1], &r[0]);
#ifndef	BCD_NO_EVALUATION
				bcd_set_precision(0);
#endif
				bcd_div(&r[3], &r[1], &r[0]);
			}
			bcd_sub(&r[2], &r[4], &r[3]);
			bcd_muli(&r[2], &r[2], 1, r_digits + 6);
			printREG(2);
			printREG(3);
			printREG(4);
		}
		else if (strncmp(p, "test", 4) == 0) {
			p += 4;
			i = strtol(p, &p, 10);
			j = strtol(++p, NULL, 10);
			testallREG(i, j);
		}
		else if (strncmp(p, "dump", 4) == 0) {
			dz = dw = (unsigned int *)&r[0];
			j = 0;
			c = 0;
			k = 41;
			kf = 1;
			for (i = 1; i < 5; i++) {
				s[i][0] = '\0';
				for (; j < nBCD_DATMAX + 1 && j < (nPARALEN/200)*8*i; j++) {
					sprintf_s(pwk, 20, "%#.8x,", *dw++);
					strcat_s(s[i], nPARALEN, pwk);
					if (++c == 8) {
						if (kf) sprintf_s(pwk, 100, "\t//%d,\texp=%d,sgn=%d,", k, *dz/2, *dz%2), dz++;
						else	sprintf_s(pwk, 100, "\t//%d,\t", k);
						strcat_s(s[i], nPARALEN, pwk);
						kk = 0;
						for (ii = kf; ii < 8; ii++) {
							for (jj = 26; jj > 0; jj-=5) {
								pwk[kk++] = ((*dz >> jj) & 0x0f) + '0';
							}
							dz++;
						}
						pwk[kk++] = '\r';
						pwk[kk++] = '\n';
						pwk[kk++] = '\0';
						strcat_s(s[i], nPARALEN, pwk);
						c = 0;
						k += 48;
						kf = 0;
					}
				}
				if (c == 0) strcat_s(s[i], nPARALEN, "\r\n");
				else {
					k -= 48;
					k += c * 6;
					kk = 0;
					sprintf_s(pwk, 100, "\t//%d,\t", k);
					strcat_s(s[i], nPARALEN, pwk);
					kk = 0;
					for (ii = 0; ii < c; ii++) {
						for (jj = 26; jj > 0; jj -= 5) {
							pwk[kk++] = ((*dz >> jj) & 0x0f) + '0';
						}
						dz++;
					}
					pwk[kk++] = '\r';
					pwk[kk++] = '\n';
					pwk[kk++] = '\0';
					strcat_s(s[i], nPARALEN, pwk);
					c = 0;
				}
			}
			break;
		}
		else if (strncmp(p, "ln10", 4) == 0) {
			pushREG();
			bcd_const_ln10(&r[0]);
			printREG(0);
			break;
		}
		else if (strncmp(p, "end", 3) == 0) {
			break;
		}
		else {
			sprintf_s(s_mess, nPARALEN, "Invalid command: line = %d\n", line);
			break;
		}
		while (*p >= ' ') p++;
		while (*p > '\0' && *p <= ' ') p++;
		line++;
	}

	return 0;
}

//------------------------------
// v~eBueXg
//------------------------------
#define TESETSEQMAX		(100000)
static int testallREG(int st, int ed) {
	int i, j, k, n, m, wki[5], error, emask, seq, step, hold;
	char ex;

	if (ed == 0) ed = TESETSEQMAX;
	hold = lim_digits;
	lim_digits = 100;
#ifndef BCD_NUM_FIXED
	bcd_num_digits(lim_digits);
#endif

	j = 0;
	for (seq = 0; seq < TESETSEQMAX; seq++) {
		if (seq > ed) break;
		if (test_data[j][0] == '\0') break;
		step = -1;								//wb_G[
		if (strncmp(test_data[j], "SEQ", 3) != 0) { error = 0xf0; goto test_error; }
		if (strtol(&test_data[j][3], NULL, 10) != seq) { error = 0xf1; goto test_error; }
		j++;
		k = test_data[j][0] - '0';
		if (k < 0 || k > 3) { error = 0xf2; goto test_error; }
		ex = test_data[j][1];
		emask = ((test_data[j][2] & 0x7) << 2) | 1;
		if (ex == '2') emask |= 2;
#ifndef	 BCD_BASIC_FUNC
		if (test_data[j][3] == 'r') bcd_angle(1);
		else						bcd_angle(0);
#endif
		n = strtol(test_data[++j], NULL, 10);
		if (n < 1) { error = 0xf3; goto test_error; }
		k++;
		j++;
		i = j;

		if (seq >= st && seq <= ed) for (step = 0; step < n; step++) {
			if (strlen(test_data[i]) == 0) break;
			for (m = k; m >= 2; m--) {
				wki[m] = strtol(test_data[i], NULL, 10);
				setnumREG(&r[m], test_data[i++]);
				cpyREG(m + 5, m);
				printREG(m + 5);
			}
			setnumREG(&r[0], test_data[i++]);
			printREG(0);
			if (ex == '2') {
				setnumREG(&r[5], test_data[i++]);
				printREG(5);
			}

			switch (seq) {
				case  0: bcd_add(&r[1], &r[3], &r[2]); break;
				case  1: bcd_sub(&r[1], &r[3], &r[2]); break;
				case  2: bcd_mul(&r[1], &r[3], &r[2]); break;
				case  3: bcd_div(&r[1], &r[3], &r[2]); break;
				case  4: bcd_addi(&r[1], &r[4], wki[3], wki[2]); break;
				case  5: bcd_isub(&r[1], wki[4], wki[3], &r[2]); break;
				case  6: bcd_muli(&r[1], &r[4], wki[3], wki[2]); break;
				case  7: bcd_divi(&r[1], &r[4], wki[3], wki[2]); break;
				case  8: bcd_mod(&r[1], &r[3], &r[2]); break;
				case  9: bcd_modi(&r[1], &r[4], wki[3], wki[2]); break;
				case 10: bcd_din(&r[1], &r[3], &r[2]); break;
				case 11: bcd_dini(&r[1], &r[4], wki[3], wki[2]); break;
				case 12: bcd_dim(&r[1], &r[6], &r[3], &r[2]); break;
				case 13: bcd_dimi(&r[1], &r[6], &r[4], wki[3], wki[2]); break;
				case 14: bcd_dim(&r[3], &r[6], &r[3], &r[2]); bcd_copy(&r[1], &r[3]);  break;
#ifndef BCD_BASIC_FUNC
				case 21:
				case 15: bcd_sin(&r[1], &r[2]); break;
				case 22:
				case 16: bcd_cos(&r[1], &r[2]); break;
				case 23:
				case 17: bcd_tan(&r[1], &r[2]); break;
				case 24:
				case 18: bcd_asin(&r[1], &r[2]); break;
				case 25:
				case 19: bcd_acos(&r[1], &r[2]); break;
				case 26:
				case 20: bcd_atan(&r[1], &r[2]); break;
				case 27: bcd_exp(&r[1], &r[2]); break;
				case 28: bcd_loge(&r[1], &r[2]); break;
				case 29: bcd_exp10(&r[1], &r[2]); break;
				case 30: bcd_log10(&r[1], &r[2]); break;
				case 31: bcd_pow(&r[1], &r[3], &r[2]); break;
				case 32: bcd_round(&r[1], &r[3], wki[2]); break;
				case 33: bcd_sinh(&r[1], &r[2]); break;
				case 34: bcd_cosh(&r[1], &r[2]); break;
				case 35: bcd_tanh(&r[1], &r[2]); break;
				case 36: bcd_asinh(&r[1], &r[2]); break;
				case 37: bcd_acosh(&r[1], &r[2]); break;
				case 38: bcd_atanh(&r[1], &r[2]); break;
				case 39: bcd_sqrt(&r[1], &r[2]); break;
				case 40: bcd_curt(&r[1], &r[2]); break;
#endif
				default: break;
			}

			error = 0;
			for (m = k; m >= 2; m--) {
				printREG(m);
				if (strcmp(s[m], s[m + 5]) != 0) error |= 1 << m;	//b4-2:r[4]`r[2]j󂳂ꂽ
			}
			printREG(1);
			if (strcmp(s[0], s[1]) != 0) error |= 1;				//b0: dist܂dist1ҒlƈقȂ
			if (ex == '2') {
				printREG(6);
				if (strcmp(s[5], s[6]) != 0) error |= 2;			//b1: dist2ҒlƈقȂ
			}
			error &= emask;
			if (error) goto test_error;
		}
		step--;
		if (ex == '2') k++;
		j += k * n;
	}

	seq--;
	sprintf_s(s_mess, nPARALEN, "TEST completed: seq=%d  step=%d\n", seq, step);
	goto test_end;

test_error:
	sprintf_s(s_mess, nPARALEN, "ERROR on seq=%d  step=%d, error=%X\n", seq, step, error);
test_end:
	lim_digits = hold;
#ifndef BCD_NUM_FIXED
	bcd_num_digits(lim_digits);
#endif
	return BCD_OK;
}

static int setnumREG(BCD_REG* dist, char* p) {
	int  i;

	if (*p != 'd' && *p != 's') bcd_strto(dist, p);
	else if (*p == 'd') {
		i = strtol(++p, NULL, 10);
#ifndef	 BCD_BASIC_FUNC
		bcd_const_pi(dist);
#endif
		bcd_muli(dist, dist, i, 0);
		bcd_divi(dist, dist, 180, 0);
	}
	return BCD_OK;
}

// =============================================================================
// =============================================================================
// eXgf[^
// =============================================================================
// =============================================================================
char *test_data[10000] = {
	// wb_e
	// ꕶFV[PXԍ(SEQƘA)
	// 񕶎F̐, ʂ̐, j󌟒mrbg}XN(eꍇ0), pxP(WA͕rt)
	// OFYV[PX̃Xebv

	// seq = 0		bcd_add
	"SEQ0","217","30",
	"9.9999999", "0.0000001","10", //Z0
	"010 020 030 040 050 060 070 080 090 010 020 030 040 050 060 070 080 090 005 015 025 035 045 055 065 075 085 095 015 025 035 045 055 065 075 085 095",
	"000 000 000 000 000 000 000 000 000 090 090 090 090 090 090 090 090 090 005 005 005 005 005 005 005 005 005 005 095 095 095 095 095 095 095 095 095",
	"10020030040050060070 08009010011012013014 01501601701800100200 30040050060070080090 10011012013014015016 0170180190", //Z1
	"010 020 030 040 050 060 070 080 090 010 020 030 040 050 060 070 080 090 005 015 025 035 045 055 065 075 085 095 015 025 035 045 055 065 075 085 095 0",
	"000 000 000 000 000 000 000 000 000 090 090 090 090 090 090 090 090 090 005 005 005 005 005 005 005 005 005 005 095 095 095 095 095 095 095 095 095 0",
	"10020030040050060070 08009010011012013014 01501601701800100200 30040050060070080090 10011012013014015016 01701801900", //Z2
	"010 020 030 040 050 060 070 080 090 010 020 030 040 050 060 070 080 090 005 015 025 035 045 055 065 075 085 095 015 025 035 045 055 065 075 085 095 00",
	"000 000 000 000 000 000 000 000 000 090 090 090 090 090 090 090 090 090 005 005 005 005 005 005 005 005 005 005 095 095 095 095 095 095 095 095 095 00",
	"10020030040050060070 08009010011012013014 01501601701800100200 30040050060070080090 10011012013014015016 017018019000", //Z3
	"010 020 030 040 050 060 070 080 090 010 020 030 040 050 060 070 080 090 005 015 025 035 045 055 065 075 085 095 015 025 035 045 055 065 075 085 095 000",
	"000 000 000 000 000 000 000 000 000 090 090 090 090 090 090 090 090 090 005 005 005 005 005 005 005 005 005 005 095 095 095 095 095 095 095 095 095 000",
	"10020030040050060070 08009010011012013014 01501601701800100200 30040050060070080090 10011012013014015016 0170180190000", //Z4
	"010 020 030 040 050 060 070 080 090 010 020 030 040 050 060 070 080 090 005 015 025 035 045 055 065 075 085 095 015 025 035 045 055 065 075 085 095 0000",
	"000 000 000 000 000 000 000 000 000 090 090 090 090 090 090 090 090 090 005 005 005 005 005 005 005 005 005 005 095 095 095 095 095 095 095 095 095 0000",
	"10020030040050060070 08009010011012013014 01501601701800100200 30040050060070080090 10011012013014015016 01701801900000", //Z5
	"010 020 030 040 050 060 070 080 090 010 020 030 040 050 060 070 080 090 005 015 025 035 045 055 065 075 085 095 015 025 035 045 055 065 075 085 095 00000",
	"000 000 000 000 000 000 000 000 000 090 090 090 090 090 090 090 090 090 005 005 005 005 005 005 005 005 005 005 095 095 095 095 095 095 095 095 095 00000",
	"10020030040050060070 08009010011012013014 01501601701800100200 30040050060070080090 10011012013014015016 017018019000000", //Z6
	"10","0.2","10.2", //Z7
	"10","-0.2","9.8", //Z8
	"-10","-0.2","-10.2", //Z9

	"-10","0.2","-9.8", //Z10
	"0.2","10","10.2", //Z11
	"0.2","-10","-9.8", //Z12
	"-0.2","-10","-10.2", //Z13
	"-0.2","10","9.8", //Z14
	"123456789","876543210","999999999", //Z15
	"123456789","876543211","1000000000", //Z16
	"123456789","1","123456790", //Z17
	"123456789","20","123456809", //Z18
	"123456789","300","123457089", //Z19

	"123456789","4000","123460789", //Z20
	"123456789","50000","123506789", //Z21
	"123456789","600000","124056789", //Z22
	"","","", //Z23
	"","","", //Z24
	"","","", //Z25
	"","","", //Z26
	"","","", //Z27
	"","","", //Z28
	"","","", //Z29

	// seq = 1		bcd_sub
	"SEQ1","217","30",
	"10", "0.0000001","9.9999999", //Z00
	"090 080 070 060 050 040 030 020 010 000 100 100 100 100 100 100 100 100 100 090 080 070 060 050 040 030 020 010 100 100 100 100 100 100 100 100 100 100",
	"000 000 000 000 000 000 000 000 000 000 010 020 030 040 050 060 070 080 090 005 005 005 005 005 005 005 005 005 005 015 025 035 045 055 065 075 085 095",
	"90080070060050040030 02001000009008007006 00500400300200100850 75065055045035025015 00509508507506505504 5035025015005", //Z01
	"090 080 070 060 050 040 030 020 010 000 100 100 100 100 100 100 100 100 100 090 080 070 060 050 040 030 020 010 100 100 100 100 100 100 100 100 100 100 0",
	"000 000 000 000 000 000 000 000 000 000 010 020 030 040 050 060 070 080 090 005 005 005 005 005 005 005 005 005 005 015 025 035 045 055 065 075 085 095 0",
	"90080070060050040030 02001000009008007006 00500400300200100850 75065055045035025015 00509508507506505504 50350250150050", //Z02
	"090 080 070 060 050 040 030 020 010 000 100 100 100 100 100 100 100 100 100 090 080 070 060 050 040 030 020 010 100 100 100 100 100 100 100 100 100 100 00",
	"000 000 000 000 000 000 000 000 000 000 010 020 030 040 050 060 070 080 090 005 005 005 005 005 005 005 005 005 005 015 025 035 045 055 065 075 085 095 00",
	"90080070060050040030 02001000009008007006 00500400300200100850 75065055045035025015 00509508507506505504 503502501500500", //Z03
	"090 080 070 060 050 040 030 020 010 000 100 100 100 100 100 100 100 100 100 090 080 070 060 050 040 030 020 010 100 100 100 100 100 100 100 100 100 100 000",
	"000 000 000 000 000 000 000 000 000 000 010 020 030 040 050 060 070 080 090 005 005 005 005 005 005 005 005 005 005 015 025 035 045 055 065 075 085 095 000",
	"90080070060050040030 02001000009008007006 00500400300200100850 75065055045035025015 00509508507506505504 5035025015005000", //Z04
	"090 080 070 060 050 040 030 020 010 000 100 100 100 100 100 100 100 100 100 090 080 070 060 050 040 030 020 010 100 100 100 100 100 100 100 100 100 100 0000",
	"000 000 000 000 000 000 000 000 000 000 010 020 030 040 050 060 070 080 090 005 005 005 005 005 005 005 005 005 005 015 025 035 045 055 065 075 085 095 0000",
	"90080070060050040030 02001000009008007006 00500400300200100850 75065055045035025015 00509508507506505504 50350250150050000", //Z05
	"090 080 070 060 050 040 030 020 010 000 100 100 100 100 100 100 100 100 100 090 080 070 060 050 040 030 020 010 100 100 100 100 100 100 100 100 100 100 00000",
	"000 000 000 000 000 000 000 000 000 000 010 020 030 040 050 060 070 080 090 005 005 005 005 005 005 005 005 005 005 015 025 035 045 055 065 075 085 095 00000",
	"90080070060050040030 02001000009008007006 00500400300200100850 75065055045035025015 00509508507506505504 503502501500500000", //Z06
	"10","0.2","9.8", //Z7
	"10","-0.2","10.2", //Z8
	"-10","-0.2","-9.8", //Z9

	"-10","0.2","-10.2", //Z10
	"0.2","10","-9.8", //Z11
	"0.2","-10","10.2", //Z12
	"-0.2","-10","9.8", //Z13
	"-0.2","10","-10.2", //Z14
	"123456789","9","123456780", //Z15
	"123456789","90","123456699", //Z16
	"123456789","800","123455989", //Z17
	"123456789","7000","123449789", //Z18
	"123456789","60000","123396789", //Z19

	"123456789","500000","122956789", //Z20
	"","","", //Z21
	"","","", //Z22
	"","","", //Z23
	"","","", //Z24
	"","","", //Z25
	"","","", //Z26
	"","","", //Z27
	"","","", //Z28
	"","","", //Z29

	// seq = 2		bcd_mul
	"SEQ2","217","30",
	"9.8696044010893586188344909998762",
	"9.8696044010893586188344909998762",
	"97.409091034002437236 44033268870607579997 35260350575800284153 2644", //Z00
	"6.25","1.6","10", //Z01
	"6.25","-1.6","-10", //Z02
	"-6.25","-1.6","10", //Z03
	"-6.25","1.6","-10", //Z04
	"1.6","625625625","1001001000", //Z05
	"1.6","-625625625","-1001001000", //Z06
	"-1.6","-625625625","1001001000", //Z07
	"-1.6","625625625","-1001001000", //Z08
	"1e-999999990","1e-9","1 e-999999999", //Z09

	"1e-999999990","1e-10","0", //Z10
	"1e999999990","1e9","1 e999999999", //Z11
	"1e999999990","1e10","1 e1999999999", //Z12
	"","","", //Z13
	"","","", //Z14
	"","","", //Z15
	"","","", //Z16
	"","","", //Z17
	"","","", //Z18
	"","","", //Z19

	"","","", //Z20
	"","","", //Z21
	"","","", //Z22
	"","","", //Z23
	"","","", //Z24
	"","","", //Z25
	"","","", //Z26
	"","","", //Z27
	"","","", //Z28
	"","","", //Z29

	// seq = 3		bcd_div
	"SEQ3", "217", "30",
	"1001001000","625625625","1.6", //Z00
	"1001001000","-625625625","-1.6", //Z01
	"-1001001000","-625625625","1.6", //Z02
	"-1001001000","625625625","-1.6", //Z03
	"625625625","1001001000","0.625", //Z04
	"625625625","-1001001000","-0.625", //Z05
	"-625625625","-1001001000","0.625", //Z06
	"-625625625","1001001000","-0.625", //Z07
	"1","333","3.0030030030030030030 03003003003003003003 00300300300300300300 30030030030030030030 03003003003003003003 e-3", //Z08
	"1","7","1.4285714285714285714 28571428571428571428 57142857142857142857 14285714285714285714 28571428571428571429 e-1", //Z09

	"123456789123456789","987654321","124999998.98593749887 51757812640603027341 99246215822509422302 21863222122226709723 47216612845659792339", //Z10
	"1e-999999990","1e9","1 e-999999999", //Z11
	"1e-999999990","1e10","0", //Z12
	"1e999999990","1e-9","1 e999999999", //Z13
	"1e999999990","1e-10","1 e1999999999", //Z14
	"","","", //Z15
	"","","", //Z16
	"","","", //Z17
	"","","", //Z18
	"","","", //Z19

	"","","", //Z20
	"","","", //Z21
	"","","", //Z22
	"","","", //Z23
	"","","", //Z24
	"","","", //Z25
	"","","", //Z26
	"","","", //Z27
	"","","", //Z28
	"","","", //Z29

	// seq = 4		bcd_addi
	"SEQ4", "317", "10",
	 "10",  "2", "-1",  "10.2",	//0
	 "10", "-2", "-1",   "9.8",	//1
	"-10", "-2", "-1", "-10.2",	//2
	"-10",  "2", "-1",  "-9.8",	//3
	 "0.2", "1",  "1",  "10.2", //4
	 "0.2","-1",  "1",  "-9.8", //5
	"-0.2","-1",  "1", "-10.2", //6
	"-0.2", "1",  "1",   "9.8", //7
	"10", "2", "-50", "10.000000000000000000 00000000000000000000 000000000002",		//8
	"10", "2", "50", "20000000000000000000 00000000000000000000 00000000010",		//9

	// seq = 5		bcd_isub
	"SEQ5", "317", "10",
	 "2", "-1",  "10",  "-9.8",	//0
	"-2", "-1",  "10", "-10.2",	//1
	"-2", "-1", "-10",   "9.8",	//2
	 "2", "-1", "-10",  "10.2",	//3
	 "1",  "1",  "0.2",  "9.8", //4
	"-1",  "1",  "0.2","-10.2", //5
	"-1",  "1", "-0.2", "-9.8", //6
	 "1",  "1", "-0.2", "10.2", //7
	"2", "-50", "10", "-9.9999999999999999999 99999999999999999999 99999999998",				//8
	"2", "50", "10", "19999999999999999999 99999999999999999999 99999999990",				//9

	// seq = 6		bcd_muli
	"SEQ6", "317", "10",
	 "6.25",   "0",  "9",   "0", //Z0
	 "6.25",  "16", "-1",  "10", //Z1
	 "6.25", "-16", "-1", "-10", //Z2
	"-6.25", "-16", "-1",  "10", //Z3
	"-6.25",  "16", "-1", "-10", //Z4
	 "1.6",  "625625625", "2",  "100100100000", //Z5
	 "1.6", "-625625625", "2", "-100100100000", //Z6
	"-1.6", "-625625625", "2",  "100100100000", //Z7
	"-1.6",  "625625625", "2", "-100100100000", //Z8
	"", "", "", "",				//9

	// seq = 7		bcd_divi
	"SEQ7", "317", "10",
	 "1001001000",  "625625625", "-2",  "160", //Z00
	 "1001001000", "-625625625", "-2", "-160", //Z01
	"-1001001000", "-625625625", "-2",  "160", //Z02
	"-1001001000",  "625625625", "-2", "-160", //Z03
	 "625625625",  "1001001000", "1",  "0.0625", //Z04
	 "625625625", "-1001001000", "1", "-0.0625", //Z05
	"-625625625", "-1001001000", "1",  "0.0625", //Z06
	"-625625625",  "1001001000", "1", "-0.0625", //Z07
	"10", "0", "0", "..",				//08
	"", "", "", "",						//09

	// seq = 8		bcd_mod
	"SEQ8", "217", "10",
	 "270",  "181",  "89",	//00
	 "270", "-181",  "89",	//01
	"-270", "-181", "-89",	//02
	"-270",  "181", "-89",	//03
	 "181",  "270",  "181", //04
	 "181", "-270",  "181", //05
	"-181", "-270", "-181", //06
	"-181",  "270", "-181", //07
	"", "", "", 			//08
	"", "", "", 			//09

	// seq = 9		bcd_modi
	"SEQ9", "317", "10",
	 "270",  "181", "0",  "89",		//00
	 "270", "-181", "0",  "89",		//01
	"-270", "-181", "0", "-89",		//02
	"-270",  "181", "0", "-89",		//03
	 "181",  "270", "0",  "181",	//04
	 "181", "-270", "0",  "181",	//05
	"-181", "-270", "0", "-181",	//06
	"-181",  "270", "0", "-181",	//07
	"", "", "", "",					//08
	"", "", "", "",					//09

	// seq = 10		bcd_din
	"SEQ10", "217", "10",
	 "270",  "181",  "1",	//00
	 "270", "-181", "-1",	//01
	"-270", "-181",  "1",	//02
	"-270",  "181", "-1",	//03
	 "181",  "270", "0", 	//04
	 "181", "-270", "0", 	//05
	"-181", "-270", "0", 	//06
	"-181",  "270", "0", 	//07
	"", "", "", 			//08
	"", "", "", 			//09

	// seq = 11		bcd_dini
	"SEQ11", "317", "10",
	 "270",  "181", "0",  "1",	//00
	 "270", "-181", "0", "-1",	//01
	"-270", "-181", "0",  "1",	//02
	"-270",  "181", "0", "-1",	//03
	 "181",  "270", "0", "0",	//04
	 "181", "-270", "0", "0",	//05
	"-181", "-270", "0", "0",	//06
	"-181",  "270", "0", "0",	//07
	"", "", "", "",				//08
	"", "", "", "",				//09

	// seq = 12		bcd_dim
	"SEQ12", "227", "10",
	 "270",  "181",  "1",  "89",	//00
	 "270", "-181", "-1",  "89",	//01
	"-270", "-181",  "1", "-89",	//02
	"-270",  "181", "-1", "-89",	//03
	 "181",  "270", "0",  "181",	//04
	 "181", "-270", "0",  "181",	//05
	"-181", "-270", "0", "-181",	//06
	"-181",  "270", "0", "-181",	//07
	"", "", "", "",					//08
	"", "", "", "",					//09

	// seq = 13		bcd_dimi
	"SEQ13", "327", "10",
	 "270",  "181", "0",  "1",  "89",	//00
	 "270", "-181", "0", "-1",  "89",	//01
	"-270", "-181", "0",  "1", "-89",	//02
	"-270",  "181", "0", "-1", "-89",	//03
	 "181",  "270", "0", "0",  "181",	//04
	 "181", "-270", "0", "0",  "181",	//05
	"-181", "-270", "0", "0", "-181",	//06
	"-181",  "270", "0", "0", "-181",	//07
	"", "", "", "", "",					//08
	"", "", "", "", "",					//09

	// seq = 14		bcd_dim(dist1, dist2, dist1, src2)
	"SEQ14", "221", "10",
	 "270",  "181",  "1",  "89",	//00
	 "270", "-181", "-1",  "89",	//01
	"-270", "-181",  "1", "-89",	//02
	"-270",  "181", "-1", "-89",	//03
	 "181",  "270", "0",  "181",	//04
	 "181", "-270", "0",  "181",	//05
	"-181", "-270", "0", "-181",	//06
	"-181",  "270", "0", "-181",	//07
	"", "", "", "",					//08
	"", "", "", "",					//09

	// seq = 15		bcd_sin
	"SEQ15", "117", "40",
	  "0", "0",		//00
	 "30", "0.5",	//01
	 "45", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",  //02
	 "60", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",  //03
	 "90", "1", 	//04
	"120", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",						//05
	"135", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",						//06
	"150", "0.5",	//07
	"180", "0",		//08
	"210","-0.5",	//09
	"225", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", //10
	"240", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", //11
	"270", "-1",	//12
	"300", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",  //13
	"315", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", 						//14
	"330", "-0.5", 	//15
	"360",  "0", 	//16
	"450",  "1", 	//17
	"540",  "0", 	//18
	"630", "-1", 	//19
	 "-30", "-0.5", //20
	 "-45", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",  //21
	 "-60", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",  //22
	 "-90", "-1", 	//23
	"-120", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",						//24
	"-135", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",						//25
	"-150", "-0.5",	//26
	"-180",  "0",	//27
	"-210",  "0.5",	//28
	"-225", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", //29
	"-240", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", //30
	"-270", "1",	//31
	"-300", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",  //32
	"-315", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", 				//33
	"-330", "0.5", 	//34
	"-360", "0", 	//35
	"-450","-1", 	//36
	"-540", "0", 	//37
	"-630", "1", 	//38
	"", "", 		//39

	// seq = 16		bcd_cos
	"SEQ16", "117", "40",
	"0",  "1",		//00
	"30", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",  //01
	"45", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",  //02
	"60", "0.5",	//03
	"90", "0", 		//04
	"120", "-0.5",	//05
	"135", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",	//06
	"150", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",	//07
	"180", "-1",	//08
	"210", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", //09
	"225", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", //10
	"240", "-0.5",	//11
	"270", "0",		//12
	"300", "0.5", 	//13
	"315", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",		//14
	"330", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",		//15
	"360", "1", 	//16
	"450", "0", 	//17
	"540", "-1", 	//18
	"630", "0", 	//19
	"-30", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",  //20
	"-45", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",  //21
	"-60", "0.5",	//22
	"-90", "0", 	//23
	"-120", "-0.5",	//24
	"-135", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",	//25
	"-150", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",	//26
	"-180", "-1",	//27
	"-210", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", //28
	"-225", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", //29
	"-240", "-0.5",	//30
	"-270", "0",	//31
	"-300", "0.5", 	//32
	"-315", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", 	//33
	"-330", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",	//34
	"-360", "1", 	//35
	"-450", "0", 	//36
	"-540", "-1", 	//37
	"-630", "0", 	//38
	"", "", 		//39

	// seq = 17		bcd_tan
	"SEQ17", "117", "40",
	"0", "0",				//00
	"30", "5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",  //01
	"45", "1",				//02
	"60", "1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	//03
	"90", "1e1999999999", 	//04
	"120", "-1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	//05
	"135", "-1",			//06
	"150", "-5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",	//07
	"180", "0",				//08
	"210", "5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1", //09
	"225", "1",				//10
	"240", "1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	//11
	"270", "1e1999999999",	//12
	"300", "-1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576", 	//13
	"315", "-1",			//14
	"330", "-5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",		//15
	"360", "0", 			//16
	"450", "1e1999999999", 	//17
	"540", "0", 			//18
	"630", "1e1999999999", 	//19
	"-30", "-5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",  //20
	"-45", "-1",			//21
	"-60", "-1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	//22
	"-90", "1e1999999999", 	//23
	"-120", "1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	//24
	"-135", "1",			//25
	"-150", "5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",	//26
	"-180", "0",			//27
	"-210", "-5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1", //28
	"-225", "-1",			//29
	"-240", "-1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	//30
	"-270", "1e1999999999",	//31
	"-300", "1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576", 	//32
	"-315", "1", 			//33
	"-330", "5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",	//34
	"-360", "0", 			//35
	"-450", "1e1999999999", //36
	"-540", "0", 			//37
	"-630", "1e1999999999", //38
	"", "", 				//39

	// seq = 18		bcd_asin
	"SEQ18", "117", "10",
	"0",    "0",	//00
	"0.5", "30", 	//01
	"7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", "45",  //02
	"8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", "60",  //03
	"1",     "90",	//04
	"-0.5", "-30",	//05
	"-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", "-45",  //06
	"-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", "-60",  //07
	"-1", "-90",  	//08
	"", "", 		//09

	// seq = 19		bcd_acos
	"SEQ19", "117", "10",
	"0",   "90",	//00
	"0.5", "60", 	//01
	"7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", "45",  //02
	"8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", "30",  //03
	"1",      "0",	//04
	"-0.5", "120",	//05
	"-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", "135",  //06
	"-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", "150",  //07
	"-1",   "180", 	//08
	"", "", 		//09

	// seq = 20		bcd_atan
	"SEQ20", "117", "10",
	"0",  "0",				//00
	"5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1", "30", 	//01
	"1", "45",				//02
	"1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	 "60",  //03
	"1e999999999", "90",	//04
	"-5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1", "-30",//05
	"-1", "-45",			//06
	"-1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	"-60",  //07
	"-1e999999999", "-90",	//08
	"", "", 		//09

	// seq = 21		bcd_sin
	"SEQ21", "117r", "40",
	"d0", "0",		//00
	"d30", "0.5",	//01
	"d45", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",  //02
	"d60", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",  //03
	"d90", "1", 	//04
	"d120", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",						//05
	"d135", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",						//06
	"d150", "0.5",	//07
	"d180", "0",	//08
	"d210", "-0.5",	//09
	"d225", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", //10
	"d240", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", //11
	"d270", "-1",	//12
	"d300", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",  //13
	"d315", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", 						//14
	"d330", "-0.5", //15
	"d360", "0", 	//16
	"d450", "1", 	//17
	"d540", "0", 	//18
	"d630", "-1", 	//19
	"d-30", "-0.5", //20
	"d-45", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",  //21
	"d-60", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",  //22
	"d-90", "-1", 	//23
	"d-120", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",						//24
	"d-135", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",						//25
	"d-150", "-0.5",//26
	"d-180", "0",	//27
	"d-210", "0.5",	//28
	"d-225", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", //29
	"d-240", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", //30
	"d-270", "1",	//31
	"d-300", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",  //32
	"d-315", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", 				//33
	"d-330", "0.5", //34
	"d-360", "0", 	//35
	"d-450", "-1", 	//36
	"d-540", "0", 	//37
	"d-630", "1", 	//38
	"", "", 		//39

	// seq = 22		bcd_cos
	"SEQ22", "117r", "40",
	"d0", "1",		//00
	"d30", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",  //01
	"d45", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",  //02
	"d60", "0.5",	//03
	"d90", "0", 	//04
	"d120", "-0.5",	//05
	"d135", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",	//06
	"d150", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",	//07
	"d180", "-1",	//08
	"d210", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", //09
	"d225", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", //10
	"d240", "-0.5",	//11
	"d270", "0",	//12
	"d300", "0.5", 	//13
	"d315", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",		//14
	"d330", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",		//15
	"d360", "1", 	//16
	"d450", "0", 	//17
	"d540", "-1", 	//18
	"d630", "0", 	//19
	"d-30", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",  //20
	"d-45", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",  //21
	"d-60", "0.5",	//22
	"d-90", "0", 	//23
	"d-120", "-0.5",//24
	"d-135", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",	//25
	"d-150", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",	//26
	"d-180", "-1",	//27
	"d-210", "-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", //28
	"d-225", "-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", //29
	"d-240", "-0.5",//30
	"d-270", "0",	//31
	"d-300", "0.5", //32
	"d-315", "7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", 	//33
	"d-330", "8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1",	//34
	"d-360", "1", 	//35
	"d-450", "0", 	//36
	"d-540", "-1", 	//37
	"d-630", "0", 	//38
	"", "", 		//39

	// seq = 23		bcd_tan
	"SEQ23", "117r", "40",
	"d0", "0",				//00
	"d30", "5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",  //01
	"d45", "1",				//02
	"d60", "1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	//03
	"d90", "..1e1999999999", 	//04
	"d120", "-1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	//05
	"d135", "-1",			//06
	"d150", "-5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",	//07
	"d180", "0",			//08
	"d210", "5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1", //09
	"d225", "1",			//10
	"d240", "1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	//11
	"d270", "..1e1999999999",	//12
	"d300", "-1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576", 	//13
	"d315", "-1",			//14
	"d330", "-5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",		//15
	"d360", "0", 			//16
	"d450", "..1e1999999999", //17
	"d540", "0", 			//18
	"d630", "..1e1999999999", //19
	"d-30", "-5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",  //20
	"d-45", "-1",			//21
	"d-60", "-1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	//22
	"d-90", "..1e1999999999", //23
	"d-120", "1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	//24
	"d-135", "1",			//25
	"d-150", "5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",	//26
	"d-180", "0",			//27
	"d-210", "-5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1", //28
	"d-225", "-1",			//29
	"d-240", "-1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576",	//30
	"d-270", "..1e1999999999",//31
	"d-300", "1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576", 	//32
	"d-315", "1", 			//33
	"d-330", "5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",	//34
	"d-360", "0", 			//35
	"d-450", "..1e1999999999",//36
	"d-540", "0", 			//37
	"d-630", "..1e1999999999",//38
	"", "", 				//39

	// seq = 24		bcd_asin
	"SEQ24", "117r", "10",
	"0", "d0",		//00
	"0.5", "d30", 	//01
	"7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", "d45",  //02
	"8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", "d60",  //03
	"1", "d90",		//04
	"-0.5", "d-30",	//05
	"-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", "d-45",  //06
	"-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", "d-60",  //07
	"-1", "d-90",  	//08
	"", "", 		//09

	// seq = 25		bcd_acos
	"SEQ25", "117r", "10",
	"0", "d90",		//00
	"0.5", "d60", 	//01
	"7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1",
		"7.8539816339744830961 56608458198757210492 92349843776455243736 14807695410157155224 96570087063355292669 e-1",  //02
	"8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", "d30",  //03
	"1", "d0",		//04
	"-0.5", "d120",	//05
	"-7.0710678118654752440 08443621048490392848 35937688474036588339 86899536623923105351 94251937671638207864 e-1", "d135",  //06
	"-8.6602540378443864676 37231707529361834714 02626905190314027903 48972596650845440001 85405730933786242878 e-1", "d150",  //07
	"-1", "d180", 	//08
	"", "", 		//09

	// seq = 26		bcd_atan
	"SEQ26", "117r", "10",
	"0", "d0",				//00
	"5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",
		"5.2359877559829887307 71072305465838140328 61566562517636829157 43205130273438103483 31046724708903528446 e-1", 	//01
	"1", "d45",				//02
	"1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576", "d60",  //03
	"1e999999999", "d90",	//04
	"-5.7735026918962576450 91487805019574556476 01751270126876018602 32648397767230293334 56937153955857495252 e-1",
		"-5.2359877559829887307 71072305465838140328 61566562517636829157 43205130273438103483 31046724708903528446 e-1",//05
	"-1", "d-45",			//06
	"-1.7320508075688772935 27446341505872366942 80525381038062805580 69794519330169088000 37081146186757248576", "d-60",  //07
	"-1e999999999", "d-90",	//08
	"", "", 				//09

	// seq = 27		bcd_exp
	"SEQ27", "117", "11",
	  "0.3", "1.3498588075760031039 83744313328007330378 29969735936580304991 79899396125873995398 91293796485784096715",		//00
	  "0.8", "2.2255409284924676045 79537531395076757053 63413504848459611858 39555566226102144063 2023826379767119915",		//01
	    "1", "2.7182818284590452353 60287471352662497757 24709369995957496696 76277240766303535475 94571382178525166427",		//02
	  "3.2", "24.532530197109348643 56026372796419656433 77616617003711644513 73279006841848128192 38697542108328815134",		//03
	"100.7", "54132031723300416581 20564502266491880591 3110.5101625661696801 92446545362726354320 61158043082185781137",		//04
	  "-0.3", ".7408182206817178660 66873779317816872182 25123199900634829531 00668080982468773547 71014373951009663971",		//05
	  "-0.8", "4.4932896411722159143 01023850155627959342 14941272184490897989 33443379075508706868 38823862031637396646 e-1",	//06
	    "-1", "3.6787944117144232159 55237701614608674458 11131031767834507836 80169746149574489980 33571472743459196437 e-1",	//07
	  "-3.2", "4.0762203978366215166 07926214442505972648 24234374975355307490 14597128835588189211 19086161406336989271 e-2",	//08
	"-100.7", "1.8473350586794310838 27272656214238944658 30916935249931987051 58356035343511434824 63850310404715383273 e-44",	//09
		 "0", "1", 				//10

	// seq = 28		bcd_loge
	"SEQ28", "117", "11",
	"1.3498588075760031039 83744313328007330378 29969735936580304991 79899396125873995398 912937964857840967152",     "0.3",	//00
	"2.2255409284924676045 79537531395076757053 63413504848459611858 39555566226102144063 202382637976711991502",     "0.8",	//01
	"2.7182818284590452353 60287471352662497757 24709369995957496696 76277240766303535475 945713821785251664273",     "1",		//02
	"24.532530197109348643 56026372796419656433 77616617003711644513 73279006841848128192 38697542108328815134",      "3.2",	//03
	"54132031723300416581 20564502266491880591 3110.5101625661696801 92446545362726354320 61158043082185781137",      "100.7",	//04
	".7408182206817178660 66873779317816872182 25123199900634829531 00668080982468773547 7101437395100966397092",      "-0.3",	//05
	"4.4932896411722159143 01023850155627959342 14941272184490897989 33443379075508706868 388238620316373966456 e-1",  "-0.8",	//06
	"3.6787944117144232159 55237701614608674458 11131031767834507836 80169746149574489980 33571472743459196437 e-1",    "-1",	//07
	"4.0762203978366215166 07926214442505972648 24234374975355307490 14597128835588189211 19086161406336989271 e-2",  "-3.2",	//08
	"1.8473350586794310838 27272656214238944658 30916935249931987051 58356035343511434824 63850310404715383273 e-44", "-100.7", //09
	"1", "0", 				//10

	// seq = 29		bcd_exp10
	"SEQ29", "117", "15",
	"0", "1",		//00
	"0.3", "1.9952623149688796013 52455396739535557986 27431540534609922991 36670049309106980489 64475380079797534796",		//01
	"0.8", "6.3095734448019324943 43601366223438646729 45257188228724527729 52883349494329768680 75729140677436522649",		//02
	"1", "10",		//03
	"3", "1000",	//04
	"3.2", "1584.8931924611134852 02101373391507013269 44213382503906831629 68123166568636684539 80110202723846111044",		//05
	"3.7", "5011.8723362727228500 15541868849457680604 71989832819263929697 45588901125568883068 89597705395481420705",		//06
	"-0.3", "5.0118723362727228500 15541868849457680604 71989832819263929697 45588901125568883068 89597705395481420705 e-1",		//07
	"-0.8", "1.5848931924611134852 02101373391507013269 44213382503906831629 68123166568636684539 80110202723846111044 e-1",	//08
	"-1", "0.1",	//09
	"-3", "0.001",	//10
	"-3.2", "6.3095734448019324943 43601366223438646729 45257188228724527729 52883349494329768680 75729140677436522649 e-4",		//11
	"-3.7", "1.9952623149688796013 52455396739535557986 27431540534609922991 36670049309106980489 64475380079797534796 e-4",//12
	"999999999", "1e999999999", 				//13
	"-999999999", "1e-999999999", 				//14

	// seq = 30		bcd_log10
	"SEQ30", "117", "15",
	"1", "0",		//00
	"1.9952623149688796013 52455396739535557986 27431540534609922991 36670049309106980489 64475380079797534796", "0.3", 	//01
	"6.3095734448019324943 43601366223438646729 45257188228724527729 52883349494329768680 75729140677436522649", "0.8", 	//02
	"10", "1",		//03
	"1000", "3",	//04
	"1584.8931924611134852 02101373391507013269 44213382503906831629 68123166568636684539 80110202723846111044", "3.2", 	//05
	"5011.8723362727228500 15541868849457680604 71989832819263929697 45588901125568883068 89597705395481420705", "3.7", 	//06
	"5.0118723362727228500 15541868849457680604 71989832819263929697 45588901125568883068 89597705395481420705 e-1", "-0.3",//07
	"1.5848931924611134852 02101373391507013269 44213382503906831629 68123166568636684539 801102027238461110435 e-1", "-0.8",//08
	"0.1", "-1",	//09
	"0.001", "-3",	//10
	"6.3095734448019324943 43601366223438646729 45257188228724527729 52883349494329768680 75729140677436522649 e-4", "-3.2",//11
	"1.9952623149688796013 52455396739535557986 27431540534609922991 36670049309106980489 64475380079797534796 e-4", "-3.7",//12
	"1e999999999", "999999999",  				//13
	"1e-999999999", "-999999999",  				//14

	// seq = 31		bcd_pow
	"SEQ31", "217", "15",
	"2.34", "0", "1",	//00
	"2", "0.3", "1.2311444133449162844 99393069167743109876 13776110081779433706 55382461007197193584 58404022749650894142",		//01
	"2", "0.8", "1.7411011265922482782 72540034959492197958 25084869600609648371 91370135000355049560 20376757529743340835",		//02
	"2", "1", "2",		//03
	"2", "3", "8",		//04
	"2", "3.2", "9.1895868399762800543 89015574223420715550 80711278238004410968 89479488256500281044 54491784904092067791",		//05
	"2", "3.7", "12.996038341699768361 75535012440450642056 32795909145510805198 99408867531894960238 16999577807705646124",		//06
	"2", "-0.3", "8.1225239635623552260 97093827752816512852 04974432159442532493 71305422074343501488 56247361298160288275 e-1",	//07
	"2", "-0.8", ".5743491774985175033 99313473388963794721 92544454889875275685 55592468016031267565 28405736556505754237",		//08
	"2", "-1", "0.5",	//09
	"2", "-3", "0.125",	//10
	"2", "-3.2", "1.0881882041201551739 20337521849682623723 90678043500381030232 44606334375221905975 12735473456089588022 e-1",				//11
	"2", "-3.7", "7.6946525834057267781 21206682298394436725 86100688011121460665 96140381294982459903 65025142185318088385 e-2",				//12
	"2", "999999999", "2.3064880005845346965 58059610518658009352 34488257910929312710 71229131281991889684 38027123691645972722 e301029995", 	//13
	"2", "-999999999", "4.3355959352338680043 42409021072164289838 31947047017382048818 93410771932559634296 1693049880813159977 e-301029996", 	//14

	// seq = 32		bcd_round
	"SEQ32", "217", "11",
	 "18.56785678", "-1",  "20",		//00
	"-18.56785678",  "0", "-19",		//01
	 "18.56785678",  "1",  "18.6",		//02
	"-18.56785678",  "2", "-18.57",		//03
	 "18.56785678",  "3",  "18.568",	//04
	"-18.56785678",  "4", "-18.5679",	//05
	 "18.56785678",  "5",  "18.56786",	//06
	"-18.56785678",  "6", "-18.567857",	//07
	  "0.04",        "1",   "0",		//08
 	 "-0.04999999",  "1",   "0",		//09
	"9.9999999999 9999999999 9999999999 9999999999 9999999999 9999999999 9999999999 9999999999 9999999999 9999999999 9999999999e999999999", "-999999990", "1e1999999999",	//10

	// seq = 33		bcd_sinh
	"SEQ33", "117", "7",
	 "0",   "0",	//00
	 "0.5",   "5.2109530549374736162 24256264114915591059 28982611480527946093 57645280225089023359 23170644542741885935 e-1",	//01
	 "1",   "1.1752011936438014568 82381850595600815155 71798133409587022956 54130133075673043238 95607117452089623392",		//02
	 "1.5", "2.1292794550948174968 34387494677631648831 78911950429386401440 73820128057539176996 659017450505249379",			//03
	"-0.5",  "-5.2109530549374736162 24256264114915591059 28982611480527946093 57645280225089023359 23170644542741885935 e-1",	//04
	"-1",  "-1.1752011936438014568 82381850595600815155 71798133409587022956 54130133075673043238 95607117452089623392",		//05
	"-1.5","-2.1292794550948174968 34387494677631648831 78911950429386401440 73820128057539176996 659017450505249379",			//06

	// seq = 34		bcd_cosh
	"SEQ34", "117", "7",
	 "0",   "1",	//00
	 "0.5", "1.1276259652063807852 26225161402672012547 84711809866748362898 57351878587703039820 1631571206578217805",	//01
	 "1",   "1.5430806348152437784 77905620757061682601 52911236586370473740 22147107690630492236 98964264726435543036",//02
	 "1.5", "2.3524096152432473257 67667965441644170173 96074886537319275824 27007731309205490141 07079308780857515491",//03
	"-0.5", "1.1276259652063807852 26225161402672012547 84711809866748362898 57351878587703039820 1631571206578217805",	//04
	"-1",   "1.5430806348152437784 77905620757061682601 52911236586370473740 22147107690630492236 98964264726435543036",//05
	"-1.5", "2.3524096152432473257 67667965441644170173 96074886537319275824 27007731309205490141 07079308780857515491",//06

	// seq = 35		bcd_tanh
	"SEQ35", "117", "7",
	"0", "0",	//00
	"0.5", "4.6211715726000975850 23184836436725487302 89280330113038552731 81583808090614040927 87749490641519624906 e-1",	//01
	"1", "7.6159415595576488811 94582826047935904127 68597257936551596810 50012195324457663848 34589475216736767144 e-1",		//02
	"1.5", ".9051482536448664382 42303696456495597227 64113515878179856422 39824511025769945795 32228432691017879922",			//03
	"-0.5", "-4.6211715726000975850 23184836436725487302 89280330113038552731 81583808090614040927 87749490641519624906 e-1",	//04
	"-1", "-7.6159415595576488811 94582826047935904127 68597257936551596810 50012195324457663848 34589475216736767144 e-1",		//05
	"-1.5", "-.9051482536448664382 42303696456495597227 64113515878179856422 39824511025769945795 32228432691017879922",			//06

	// seq = 36		bcd_asinh
	"SEQ36", "117", "7",
	"0", "0",	//00
	"5.2109530549374736162 24256264114915591059 28982611480527946093 57645280225089023359 23170644542741885935 e-1", "0.5", 	//01
	"1.1752011936438014568 82381850595600815155 71798133409587022956 54130133075673043238 95607117452089623392",	"1", 		//02
	"2.1292794550948174968 34387494677631648831 78911950429386401440 73820128057539176996 659017450505249379",		"1.5", 		//03
	"-5.2109530549374736162 24256264114915591059 28982611480527946093 57645280225089023359 23170644542741885935 e-1", "-0.5", 	//04
	"-1.1752011936438014568 82381850595600815155 71798133409587022956 54130133075673043238 95607117452089623392",	"-1", 		//05
	"-2.1292794550948174968 34387494677631648831 78911950429386401440 73820128057539176996 659017450505249379",		"-1.5", 	//06

	// seq = 37		bcd_acosh
	"SEQ37", "117", "4",
	"1", "0",	//00
	"1.1276259652063807852 26225161402672012547 84711809866748362898 57351878587703039820 163157120657821780495", "0.5", 	//01
	"1.5430806348152437784 77905620757061682601 52911236586370473740 22147107690630492236 98964264726435543036", "1",	//02
	"2.3524096152432473257 67667965441644170173 96074886537319275824 27007731309205490141 07079308780857515491", "1.5", //03

	// seq = 38		bcd_atanh
	"SEQ38", "117", "7",
	"0", "0",	//00
	"4.6211715726000975850 23184836436725487302 89280330113038552731 81583808090614040927 87749490641519624906 e-1", "0.5", 	//01
	"7.6159415595576488811 94582826047935904127 68597257936551596810 50012195324457663848 34589475216736767145 e-1", "1", 		//02
	".9051482536448664382 42303696456495597227 64113515878179856422 39824511025769945795 32228432691017879922",		"1.5", 		//03
	"-4.6211715726000975850 23184836436725487302 89280330113038552731 81583808090614040927 87749490641519624906 e-1", "-0.5", 	//04
	"-7.6159415595576488811 94582826047935904127 68597257936551596810 50012195324457663848 34589475216736767145 e-1", "-1", 	//05
	"-.9051482536448664382 42303696456495597227 64113515878179856422 39824511025769945795 32228432691017879922",	"-1.5", 	//06

	// seq = 39		bcd_sqrt
	"SEQ39", "117", "12",
	"0", "0",		//00
	"1", "1",		//01
	"9", "3",		//02
	"81", "9",		//03
	"15241578750190521", "123456789",	//04
	"2", "1.4142135623730950488 01688724209698078569 67187537694807317667 97379907324784621070 38850387534327641573",		//05
	"1000", "31.622776601683793319 98893544432718533719 55513932521682685750 48527925944386392382 21344248108379300295",	//06
	"9.999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999e999999999",
	"9.9999999999999999999 99999999999999999999 99999999999999999999 99999999999999999999 999999999995 e499999999",			//07
	"0.01", ".1",		//08
	".000004", ".002",	//09
	"0.2", ".4472135954999579392 81834733746255247088 12367192230514485417 94490821041851275609 79882882881675756455",		//10
	"1.111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111e-999999999",
	"3.3333333333333333333 33333333333333333333 33333333333333333333 33333333333333333333 33333333333333166667 e-500000000",//11

	// seq = 40		bcd_curt
	"SEQ40", "117", "12",
	"0",	"0",	//00
	"1",	"1",	//01
	"27",	"3",	//02
	"729",	"9",	//03
	"18816763717891548608 97069", "123456789",	//04
	"2", "1.2599210498948731647 67210607278228350570 25146470150798008197 51121552996765139594 83729396562436255094",		//05
	"10000", "21.544346900318837217 59293566519350495259 34494219210858248923 55063464111066483408 00185441503543243276",	//06
	"9.999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999e999999999",
	"2.1544346900318837217 59293566519350495259 34494219210858248923 55063464111066483408 00185441503471428786 e333333333",	//07
	"0.001", ".1",			//08
	".000000008", ".002",	//09
	"0.2", "5.8480354764257321310 13574720275845557060 99727020206008284514 70201451211171864346 34131440910674162644 e-1",		//10
	"1.111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111e-999999999",
	"1.0357441686512862889 59220809174128787618 30227635580733382367 94680863769075608340 54288873946140679548 e-333333333",//11


	"","","", //Ō
};