/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.ne.sk_mine.util.andr_applet.SKMLabel;
import jp.ne.sk_mine.util.andr_applet.ScrollCallback;

public class DummyScroll
extends SKMLabel {
    private int mInnerWidth;
    private int mInnerHeight;
    private JViewport mView;
    private JScrollPane mScroll;
    private ScrollCallback mCallback;

    public DummyScroll() {
        JPanel basePanel = new JPanel(new FlowLayout(0));
        basePanel.setOpaque(false);
        basePanel.add(this.mLabel);
        this.mScroll = new JScrollPane(basePanel, 20, 31);
        this.mScroll.setOpaque(false);
        this.mScroll.getViewport().setOpaque(false);
        this.mScroll.getVerticalScrollBar().setUnitIncrement(10);
        this.mView = this.mScroll.getViewport();
        this.mScroll.setBorder(null);
        this.mView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (DummyScroll.this.mCallback != null) {
                    Point p = DummyScroll.this.mView.getViewPosition();
                    DummyScroll.this.mCallback.scrolled((int)p.getX(), (int)p.getY());
                }
            }
        });
        this.setImpl(this.mScroll);
    }

    public void setInnerSize(int w, int h) {
        this.mInnerWidth = w;
        this.mInnerHeight = h;
        this.mLabel.setBounds(this.mX, this.mY, w, h);
        this.mLabel.setPreferredSize(new Dimension(w, h));
        this.mLabel.setText(" ");
    }

    public void setCallback(ScrollCallback callback) {
        this.mCallback = callback;
    }

    public void scroll(int dx, int dy) {
        if (this.mCallback != null) {
            Point p = this.mView.getViewPosition();
            int newX = (int)p.getX() + dx;
            if (newX <= 0) {
                newX = 0;
            } else if (this.mInnerWidth < newX) {
                newX = this.mInnerWidth;
            }
            int newY = (int)p.getY() + dy;
            if (newY <= 0) {
                newY = 0;
            } else if (this.mInnerHeight < newY) {
                newY = this.mInnerHeight;
            }
            this.mView.setViewPosition(new Point(newX, newY));
            this.mCallback.scrolled(newX, newY);
        }
    }
}

